double precision function eldens(dist,reall,rcut,options)
  !La  fonction densite electronique
  !Ici une exponentielle
  USE types_def
  implicit none
  TYPE(options_type) :: options
  double precision :: dist,eldens_alu,reall,distrl,rcut
  distrl=dist*reall
  if(options%potopt=="test1")then
     if(distrl > rcut) then
        eldens=0.0d0
     else
        eldens=dexp(-2.d0*(distrl))  
     endif
  elseif(options%potopt=="fm_alu")then
     eldens=eldens_alu(distrl)
  else
     print*,'option inconnue'
     stop
  endif
  return
end function eldens

double precision function dereldens(dist,reall,rcut,options)
  !La  derivee de la fonction densite electronique
  !Ici une exponentielle
  USE types_def
  implicit none
  TYPE(options_type) :: options
  double precision :: dist,reall,distrl,deldens_alu,rcut
  distrl=dist*reall
  if(options%potopt=="test1")then
     if(distrl > rcut) then
        dereldens=0.0d0
     else
        dereldens=-2.d0*reall*dexp(-2.d0*(distrl))
     endif
  elseif(options%potopt=="fm_alu")then
     dereldens=deldens_alu(distrl)*reall
  else
     print*,'option inconnue'
     stop
  endif
  return
end function dereldens
