subroutine enerpot(ameam,energy,options,pos,npart,ndim,cell,nvec,reall,rcut,nimage)

  !Calcule l'energie potentielle
  !variables
  !ameam(2): parametes a du meam
  !energy: energie
  !eneropt: option de calcul de l'nergie (modele)
  !npart: nombre de particules
  !ndim: dimension de l'espace
  !pos(npart,ndim):position des particules
  !cell(nvec,ndim): cellule de simulation
  !nvec: nombre de vecteurs de la cellule
  !reall: cote cellule de simulaion
  USE types_def
  implicit none
  TYPE(options_type) :: options
  !input
  integer :: ndim,npart,nvec,nimage
  double precision :: ameam(2),pos(npart,ndim),cell(nvec,ndim)
  double precision :: reall,densel,rcut
  character*10 :: eneropt
  !output
  double precision :: energy
  !local variables
  integer :: idim,ipart,jpart,kpart
  double precision :: icord(3),jcord(3),kcord(3),energyij,densij,densik,embedd,&
       &                     distij,distik,tetijk,unitij(3),unitik(3)
  eneropt=options%eneropt
  !partie fonction de paire
  energy=0.0d0
  do ipart=1,npart
     icord(:)=pos(ipart,:)
     do jpart=1,npart
        jcord(:)=pos(jpart,:)
        call pairener(energyij,icord,jcord,ndim,reall,rcut,nimage,options)
           energy=energy+energyij 
     enddo
  enddo
  energy=energy*.5d0
  !partie embedding
  if(eneropt=='cai'.or.eneropt=='eam')then
  do ipart=1,npart
     densel=0.0d0
     icord(:)=pos(ipart,:)
     do jpart=1,npart
        jcord(:)=pos(jpart,:)
        call pairdens(densij,eneropt,icord,jcord,ndim,reall,pos,npart,rcut,nimage,options)
        densel=densel+densij
     enddo
     energy=energy+embedd(densel,options)
  enddo
  elseif(eneropt=='meam')then
  do ipart=1,npart
     densel=0.d0
     icord(:)=pos(ipart,:)
     do jpart=1,npart
        jcord(:)=pos(jpart,:)
        if(jpart==ipart) cycle
        call pairdens(densij,eneropt,icord,jcord,ndim,reall,pos,npart,rcut,nimage,options)
        densel=densel+densij
     enddo
     do jpart=1,npart
        jcord(:)=pos(jpart,:)
        if(jpart==ipart) cycle
        call pairdens(densij,eneropt,icord,jcord,ndim,reall,pos,npart,rcut,nimage,options)
        call dist(distij,icord,jcord,ndim)
        unitij(:)=(icord(:)-jcord(:))/distij
        do kpart=1,npart
           kcord(:)=pos(kpart,:)
           if(kpart==ipart) cycle
           call pairdens(densik,eneropt,icord,kcord,ndim,reall,pos,npart,rcut,nimage,options)
           call dist(distik,icord,kcord,ndim)
           unitij(:)=(icord(:)-kcord(:))/distik
           tetijk=0.d0
           do idim=1,ndim;tetijk=tetijk+unitij(idim)*unitik(idim);enddo
           densel=densel+densij*densik*ameam(1)*ameam(1)*tetijk
           densel=densel-ameam(2)*ameam(2)*(1.d0-3.d0*tetijk**2)*densij*densik
        enddo
     enddo
     energy=energy+embedd(densel,options)
  enddo   
  endif

  return
end subroutine enerpot

subroutine pairener(energyij,icord,jcord,ndim,reall,rcut,nimage,options)
  !Calcule les energies de paire entre icord et jcord 
  !variables
  !energyij: energie de paire
  !icord,jcord: les coordonnees de la paire d'atomes
  !ndim: dimension de l'espace
  !reall: cote cellule de simulaion
  USE types_def
  implicit none
  TYPE(options_type) :: options
  !input
  integer :: ndim,nimage
  double precision :: energyij,reall,rcut
  double precision :: icord(ndim),jcord(ndim)
  !local variables
  double precision :: dist,v
  integer :: idim, iimage ,ishift(ndim),div
  energyij=0.0d0
  do iimage=0,(2*nimage+1)**3-1
     ishift(1)=mod(iimage,2*nimage+1); div=(iimage-ishift(1))/(2*nimage+1)
     ishift(2)=mod(div,2*nimage+1); div=(div-ishift(2))/(2*nimage+1)
     ishift(3)=div
     ishift(:)=ishift(:)-nimage
     dist=0.0d0
     do idim=1,ndim
        dist=dist+(icord(idim)-jcord(idim)-dfloat(ishift(idim)))**2
     enddo
     dist=sqrt(dist)
     if(dist > 1.e-5) energyij=energyij+v(dist,reall,rcut,options)
     !print*,'in pairener, energyij',dist,energyij
  enddo
  return
end subroutine pairener

subroutine pairdens(densij,eneropt,icord,jcord,ndim,reall,pos,npart,rcut,nimage,options)
  !Calcule les densites de paire entre icord et jcord 
  !variables
  !densij: energie de paire
  !icord,jcord: les coordonnees de la paire d'atomes
  !ndim: dimension de l'espace
  !reall: cote cellule de simulaion
  !eneropt:type de calcul de l'energie
  USE types_def
  implicit none
  TYPE(options_type) :: options
  !input
  integer :: ndim,npart,nimage
  double precision :: densij,reall,rcut
  double precision :: icord(ndim),jcord(ndim),pos(npart,ndim)
  character*10 :: eneropt
  !local variables
  double precision :: dist,eldens,screenij
  integer :: idim, iimage ,ishift(ndim),div
  if(eneropt=='cai')then
     if(nimage/=0) then
        print*,'nimage must be 0 for cai potential'
        stop
     endif
     dist=0.
     do idim=1,ndim
        dist=dist+(icord(idim)-jcord(idim))**2
     enddo
     dist=sqrt(dist)
     densij=eldens(dist,reall,rcut,options)
     call screen(screenij,icord,jcord,ndim,reall,pos,npart)
     densij=densij*screenij
  elseif(eneropt=='meam'.or.eneropt=='eam')then
     densij=0.0d0
     do iimage=0,(2*nimage+1)**3-1
        ishift(1)=mod(iimage,2*nimage+1); div=(iimage-ishift(1))/(2*nimage+1)
        ishift(2)=mod(div,2*nimage+1); div=(div-ishift(2))/(2*nimage+1)
        ishift(3)=div
        ishift(:)=ishift(:)-nimage
        dist=0.0d0
        do idim=1,ndim
           dist=dist+(icord(idim)-jcord(idim)-dfloat(ishift(idim)))**2
        enddo
        dist=sqrt(dist)
        if(dist > 1.e-12)densij=densij+eldens(dist,reall,rcut,options)
     enddo
  endif
  return
end subroutine pairdens

subroutine screen(screenij,icord,jcord,ndim,reall,pos,npart)
  !Calcule le terme d'ecran de paire entre icord et jcord 
  !variables
  !screenij: ecran de paire
  !icord,jcord: les coordonnees de la paire d'atomes
  !ndim: dimension de l'espace
  !reall: cote cellule de simulaion
  !distij,distjk,distjk: distance entre les particules i,j,k
  USE types_def
  implicit none
  !input
  integer :: ndim,npart
  double precision :: screenij,reall
  double precision :: icord(ndim),jcord(ndim),pos(npart,ndim)
  !local variables
  double precision :: distij,distik,distjk,gscreen
  integer :: idim,ipart
  screenij=0.d0
  distij=0.d0
  do idim=1,ndim
     distij=distij+(icord(idim)-jcord(idim))**2
  enddo
  distij=sqrt(distij)
  do ipart=1,npart
     distik=0.d0
     distjk=0.d0
     do idim=1,ndim
        distik=distik+(icord(idim)-pos(ipart,idim))**2
        distjk=distjk+(pos(ipart,idim)-jcord(idim))**2
     enddo
     distik=sqrt(distik)
     distjk=sqrt(distjk)
     if(distik < 1.d-15) cycle
     if(distjk < 1.d-15) cycle
     screenij=screenij+gscreen(distij,distik,distjk,reall)
  enddo
  screenij=exp(-screenij)
  return
end subroutine screen















