!!****m* ABINIT/interfaces_17suscep
!! NAME
!! interfaces_17suscep
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/17suscep
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_17suscep

 interface
  subroutine acfd_dyson(dtset,freq,gmet,gsq,idyson,ig_tiny,igsq_tiny,ikhxc,kg_diel,khxc,&  
&  ldgapp,mpi_enreg,ndyson,nfft,ngfft,npw_tiny,npwdiel,nspden,occopt,&  
&  option,rcut_coulomb,rhor,rhocut,rprimd,susd_data,suskxcrs,susmat,ucvol)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: idyson
   integer,intent(in) :: ikhxc
   integer,intent(in) :: ldgapp
   integer,intent(in) :: ndyson
   integer,intent(in) :: nfft
   integer,intent(in) :: npw_tiny
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: occopt
   integer,intent(in) :: option
   integer,intent(in) :: suskxcrs
   type(dataset_type),intent(in) :: dtset
   real(dp),intent(in) :: freq
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: rcut_coulomb
   real(dp),intent(in) :: rhocut
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),pointer :: khxc(:,:,:,:,:)
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: gsq(npwdiel)
   integer,intent(in) :: ig_tiny(npw_tiny,3)
   integer,intent(in) :: igsq_tiny(npw_tiny)
   integer,intent(in) :: kg_diel(3,npwdiel)
   real(dp),intent(in) :: rhor(nfft,nspden)
   real(dp),intent(out) :: susd_data(npwdiel,3)
   real(dp),intent(inout) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine acfd_dyson
 end interface

 interface
  subroutine acfd_intexact(dec,freq,gsq,ikhxc,mband,nband,nkpt,npwdiel,&  
&  nspden,nsppol,occ,occopt,rcut_coulomb,susmat)
   use defs_basis
   integer,intent(in) :: ikhxc
   integer,intent(in) :: mband
   integer,intent(in) :: nkpt
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   real(dp),intent(out) :: dec
   real(dp),intent(in) :: freq
   real(dp),intent(in) :: rcut_coulomb
   real(dp),intent(in) :: gsq(npwdiel)
   integer,intent(in) :: nband(nkpt*nsppol)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine acfd_intexact
 end interface

 interface
  subroutine dyson_de(ikernel,kernel_diag,kernel_full,npwdiel,nspden,susmat)
   use defs_basis
   integer,intent(in) :: ikernel
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   real(dp),pointer :: kernel_diag(:)
   real(dp),pointer :: kernel_full(:,:,:,:,:)
   real(dp),intent(inout) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine dyson_de
 end interface

 interface
  subroutine dyson_gl(ikernel,kernel_diag,kernel_full,npwdiel,nspden,&  
&  susd_LDG,susmat)
   use defs_basis
   integer,intent(in) :: ikernel
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   real(dp),pointer :: kernel_diag(:)
   real(dp),pointer :: kernel_full(:,:,:,:,:)
   real(dp),intent(out) :: susd_LDG(npwdiel)
   real(dp),intent(in) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine dyson_gl
 end interface

 interface
  subroutine dyson_ls(ikernel,kernel_diag,kernel_full,npwdiel,nspden,susmat)
   use defs_basis
   integer,intent(in) :: ikernel
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   real(dp),pointer :: kernel_diag(:)
   real(dp),pointer :: kernel_full(:,:,:,:,:)
   real(dp),intent(inout) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine dyson_ls
 end interface

 interface
  subroutine dyson_sc(kernel_diag,npwdiel,nspden,susd_isc,susmat)
   use defs_basis
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   real(dp),intent(in) :: kernel_diag(npwdiel)
   real(dp),intent(out) :: susd_isc(npwdiel)
   real(dp),intent(in) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
  end subroutine dyson_sc
 end interface

 interface
  subroutine get_g_tiny(gmet,gprimd,gsq_unsorted,ig_tiny,igsq_tiny,index_g,kg,npw,npw_tiny)
   use defs_basis
   integer,intent(in) :: npw
   integer,intent(in) :: npw_tiny
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   real(dp),intent(out) :: gsq_unsorted(npw)
   integer,intent(out) :: ig_tiny(npw_tiny,3)
   integer,intent(out) :: igsq_tiny(npw_tiny)
   integer,intent(out) :: index_g(npw)
   integer,intent(in) :: kg(3,npw)
  end subroutine get_g_tiny
 end interface

 interface
  subroutine get_susd_null(ig_tiny,igsq_tiny,gsq_input,npwdiel,npw_tiny,&  
&  sus_gabs,sus_gavg,sus_gdir,sus_input,kg_diel)
   use defs_basis
   integer,intent(in) :: npw_tiny
   integer,intent(in) :: npwdiel
   real(dp),intent(in) :: gsq_input(npwdiel)
   integer,intent(in) :: ig_tiny(npw_tiny,3)
   integer,intent(in) :: igsq_tiny(npw_tiny)
   integer,intent(in) :: kg_diel(3,npwdiel)
   real(dp),intent(out) :: sus_gabs(npw_tiny)
   real(dp),intent(out) :: sus_gavg(npw_tiny)
   real(dp),intent(out) :: sus_gdir(npw_tiny,3)
   real(dp),intent(in) :: sus_input(npwdiel)
  end subroutine get_susd_null
 end interface

 interface
  subroutine geteexc_cc(energy,energy_raw,gsq,npwdiel,npw_tiny,optextrap,rcut_coulomb,susd)
   use defs_basis
   integer,intent(in) :: npw_tiny
   integer,intent(in) :: npwdiel
   integer,intent(in) :: optextrap
   real(dp),intent(out) :: energy_raw
   real(dp),intent(in) :: rcut_coulomb
   real(dp),intent(out) :: energy(npw_tiny)
   real(dp),intent(in) :: gsq(npwdiel)
   real(dp),intent(in) :: susd(npwdiel)
  end subroutine geteexc_cc
 end interface

 interface
  subroutine geteexc_uc(energy,energy_raw,gsq,ig_tiny,igsq_tiny,npwdiel,npw_tiny,&  
&  susd)
   use defs_basis
   integer,intent(in) :: npw_tiny
   integer,intent(in) :: npwdiel
   real(dp),intent(out) :: energy_raw
   real(dp),intent(out) :: energy(npw_tiny)
   real(dp),intent(in) :: gsq(npwdiel)
   integer,intent(in) :: ig_tiny(npw_tiny,3)
   integer,intent(in) :: igsq_tiny(npw_tiny)
   real(dp),intent(in) :: susd(npwdiel)
  end subroutine geteexc_uc
 end interface

 interface
  subroutine getfreqsus(freqs,weights,nfreqs,optfreq,freq1,freq2)
   use defs_basis
   integer,intent(in) :: nfreqs
   integer,intent(in) :: optfreq
   real(dp),intent(in) :: freq1
   real(dp),intent(in) :: freq2
   real(dp),intent(out) :: freqs(nfreqs)
   real(dp),intent(out) :: weights(nfreqs)
  end subroutine getfreqsus
 end interface

 interface
  subroutine getlambda(idyson,lambda,nlambda,weight)
   use defs_basis
   integer,intent(in) :: idyson
   integer,intent(in) :: nlambda
   real(dp),intent(out) :: lambda(nlambda)
   real(dp),intent(out) :: weight(nlambda)
  end subroutine getlambda
 end interface

 interface
  subroutine inwffil3(dtset,eigen,hdr,istwfk,mband,mpi_enreg,nband,&  
&  nkpt,npwarr,nsppol,prtvol,wff1,unwff1,wffnm)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: mband
   integer,intent(in) :: nkpt
   integer,intent(in) :: nsppol
   integer,intent(in) :: prtvol
   integer,intent(in) :: unwff1
   type(dataset_type),intent(in) :: dtset
   type(hdr_type),intent(out) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(wffile_type),intent(out) :: wff1
   character(len=fnlen),intent(in) :: wffnm
   real(dp),intent(out) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: nband(nkpt*nsppol)
   integer,intent(in) :: npwarr(nkpt)
  end subroutine inwffil3
 end interface

 interface
  subroutine k_rpa(gsq,krpa,npw,option,rcut_coulomb)
   use defs_basis
   integer,intent(in) :: npw
   integer,intent(in) :: option
   real(dp),intent(in) :: rcut_coulomb
   real(dp),intent(in) :: gsq(npw)
   real(dp),intent(out) :: krpa(npw)
  end subroutine k_rpa
 end interface

 interface
  subroutine klocal(ispxc,kg_diel,kxc,kxcg,nfft,ngfft,npwdiel,nspden,option)
   use defs_basis
   integer,intent(in) :: ispxc
   integer,intent(in) :: nfft
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: option
   integer,intent(in) :: ngfft(18)
   integer,intent(in) :: kg_diel(3,npwdiel)
   real(dp),intent(out) :: kxc(2,npwdiel,nspden,npwdiel,nspden)
   real(dp),intent(in) :: kxcg(2,nfft)
  end subroutine klocal
 end interface

 interface
  subroutine kxc_alda(dtset,ixc,kxcg,mpi_enreg,nfft,ngfft,nspden,option,rhor,rhocut,rprimd)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: nfft
   integer,intent(in) :: nspden
   integer,intent(in) :: option
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: rhocut
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(out) :: kxcg(2,nfft,*)
   real(dp),intent(in) :: rhor(nfft,2*nspden-1)
  end subroutine kxc_alda
 end interface

 interface
  subroutine kxc_eok(ixceok,kxcg,mpi_enreg,nfft,ngfft,nspden,rhor,rhocut)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixceok
   integer,intent(in) :: nfft
   integer,intent(in) :: nspden
   type(MPI_type) :: mpi_enreg
   real(dp),intent(in) :: rhocut
   integer,intent(in) :: ngfft(18)
   real(dp),intent(out) :: kxcg(2,nfft,2*nspden-1)
   real(dp),intent(in) :: rhor(nfft,2*nspden-1)
  end subroutine kxc_eok
 end interface

 interface
  subroutine kxc_pgg(gmet,gprimd,kg,khxcg,npw,rcut_coulomb,susmat,ucvol)
   use defs_basis
   integer,intent(in) :: npw
   real(dp),intent(in) :: rcut_coulomb
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   integer,intent(in) :: kg(3,npw)
   real(dp),intent(out) :: khxcg(2,npw,npw)
   real(dp),intent(in) :: susmat(2,npw,npw)
  end subroutine kxc_pgg
 end interface

 interface
  subroutine prtsusd(gsq,ig_tiny,index_g,npw_tiny,npwdiel,optprt,susd)
   use defs_basis
   integer,intent(in) :: npw_tiny
   integer,intent(in) :: npwdiel
   integer,intent(in) :: optprt
   real(dp),intent(in) :: gsq(npwdiel)
   integer,intent(in) :: ig_tiny(npw_tiny,3)
   integer,intent(in) :: index_g(npwdiel)
   real(dp),intent(in) :: susd(npwdiel)
  end subroutine prtsusd
 end interface

 interface
  subroutine suscep(dtfil,dtset,iexit,&  
&  mband,mgfft,mkmem,mpi_enreg,mpw,natom,nfft,nkpt,&  
&  nspden,nspinor,nsppol,nsym,occ,xred,ncdims,ngfft)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iexit
   integer,intent(in) :: mband
   integer,intent(in) :: mgfft
   integer,intent(inout) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nkpt
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   type(vardims_type),intent(inout) :: ncdims
   integer,intent(in) :: ngfft(18)
   real(dp),intent(inout) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: xred(3,natom)
  end subroutine suscep
 end interface

 interface
  subroutine suscep_dyn(cg,densymop_diel,dielar,dielop,doccde,dtset,&  
&  eigen,freq,gbound_diel,irrzondiel,istwfk,kg,kg_diel,&  
&  mband,mgfftdiel,mkmem,mpi_enreg,mpw,nband,nband_mx,nfftdiel,nfreq,&  
&  ngfftdiel,nkpt,npwarr,&  
&  npwdiel,nspden,nspinor,nsppol,nsym,occ,occopt,phnonsdiel,prtvol,&  
&  susopt,sus_diag_dyn,susmat_dyn,symafm,symrel,tnons,ucvol,unkg,wff1,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: dielop
   integer,intent(in) :: mband
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_mx
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   integer,intent(in) :: occopt
   integer,intent(in) :: prtvol
   integer,intent(in) :: susopt
   integer,intent(in) :: unkg
   type(dens_sym_operator_type),intent(in) :: densymop_diel
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   type(wffile_type),intent(inout) :: wff1
   real(dp),intent(in) :: dielar(7)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: irrzondiel(nfftdiel**(1-1/nsym),2,nspden/nsppol)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: nband(nkpt*nsppol)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: phnonsdiel(2,nfftdiel**(1-1/nsym),nspden/nsppol)
   real(dp),intent(out) :: sus_diag_dyn(2,npwdiel,nspden,nfreq)
   real(dp),intent(out) :: susmat_dyn(2,npwdiel,nspden,npwdiel,nspden,nfreq)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrel(3,3,nsym)
   real(dp),intent(in) :: tnons(3,nsym)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suscep_dyn
 end interface

 interface
  subroutine suscep_kxc_dyn(cg,densymop_diel,dielar,dielop,doccde,dtset,&  
&  eigen,freq,gbound_diel,irrzondiel,istwfk,kg,kg_diel,&  
&  mband,mgfftdiel,mkmem,mpi_enreg,mpw,nband,nband_mx,nfftdiel,nfreq,&  
&  ngfftdiel,nkpt,npwarr,&  
&  npwdiel,nspden,nspinor,nsppol,nsym,occ,occopt,phnonsdiel,prtvol,&  
&  susopt,sus_diag_dyn,susmat_dyn,symafm,symrel,tnons,ucvol,unkg,wff1,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: dielop
   integer,intent(in) :: mband
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_mx
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   integer,intent(in) :: occopt
   integer,intent(in) :: prtvol
   integer,intent(in) :: susopt
   integer,intent(in) :: unkg
   type(dens_sym_operator_type),intent(in) :: densymop_diel
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   type(wffile_type),intent(inout) :: wff1
   real(dp),intent(in) :: dielar(7)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: irrzondiel(nfftdiel**(1-1/nsym),2,nspden/nsppol)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: nband(nkpt*nsppol)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: phnonsdiel(2,nfftdiel**(1-1/nsym),nspden/nsppol)
   real(dp),intent(out) :: sus_diag_dyn(2,npwdiel,nspden,nfreq)
   real(dp),intent(out) :: susmat_dyn(2,npwdiel,nspden,npwdiel,nspden,nfreq)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrel(3,3,nsym)
   real(dp),intent(in) :: tnons(3,nsym)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suscep_kxc_dyn
 end interface

 interface
  subroutine suscep_stat(cg,densymop_diel,dielar,dielop,doccde,&  
&  eigen,gbound_diel,irrzondiel,istwfk,kg,&  
&  kg_diel,&  
&  mband,mgfftdiel,mkmem,mpi_enreg,mpw,nband,nfftdiel,&  
&  ngfftdiel,nkpt,npwarr,&  
&  npwdiel,nspden,nspinor,nsppol,nsym,occ,occopt,phnonsdiel,prtvol,&  
&  susmat,symafm,symrel,tnons,ucvol,unkg,wffnew,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: dielop
   integer,intent(in) :: mband
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nkpt
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   integer,intent(in) :: occopt
   integer,intent(in) :: prtvol
   integer,intent(in) :: unkg
   type(dens_sym_operator_type),intent(in) :: densymop_diel
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   type(wffile_type),intent(inout) :: wffnew
   real(dp),intent(in) :: dielar(7)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: irrzondiel(nfftdiel**(1-1/nsym),2,nspden/nsppol)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: nband(nkpt*nsppol)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: phnonsdiel(2,nfftdiel**(1-1/nsym),nspden/nsppol)
   real(dp),intent(out) :: susmat(2,npwdiel,nspden,npwdiel,nspden)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrel(3,3,nsym)
   real(dp),intent(in) :: tnons(3,nsym)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suscep_stat
 end interface

 interface
  subroutine susk(bdtot_index,cg,doccde,drhode,eigen,extrap,gbound,&  
&  gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,occ_deavg,rhoextrap,sumdocc,&  
&  susmat,ucvol,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(inout) :: rhoextrap(ndiel4,ndiel5,ndiel6)
   real(dp),intent(inout) :: susmat(2,npwdiel,nsppol,npwdiel,nsppol)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine susk
 end interface

 interface
  subroutine susk_dyn(bdtot_index,cg,doccde,drhode,dtset,eigen,extrap,freq,&  
&  gbound,gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nfreq,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,&  
&  occ_deavg,occ_freq,rhoextrap_dyn,sumdocc,susmat_dyn,susopt,ucvol,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   integer,intent(in) :: susopt
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(in) :: occ_freq(2,mband,nfreq)
   real(dp),intent(inout) :: rhoextrap_dyn(2,ndiel4,ndiel5,ndiel6,nfreq)
   real(dp),intent(inout) :: susmat_dyn(2,npwdiel,nsppol,npwdiel,nsppol,nfreq)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine susk_dyn
 end interface

 interface
  subroutine susk_dyn_pgg(bdtot_index,cg,doccde,drhode,eigen,extrap,freq,&  
&  gbound,gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nfreq,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,&  
&  occ_deavg,occ_freq,rhoextrap_dyn,sumdocc,susmat_dyn,susopt,ucvol,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   integer,intent(in) :: susopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(in) :: occ_freq(2,mband,nfreq)
   real(dp),intent(inout) :: rhoextrap_dyn(2,ndiel4,ndiel5,ndiel6,nfreq)
   real(dp),intent(inout) :: susmat_dyn(2,npwdiel,nsppol,npwdiel,nsppol,nfreq)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine susk_dyn_pgg
 end interface

 interface
  subroutine susk_kxc_dyn(bdtot_index,cg,doccde,drhode,eigen,extrap,freq,&  
&  gbound,gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nfreq,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,&  
&  occ_deavg,occ_freq,rhoextrap_dyn,sumdocc,susmat_dyn,susopt,ucvol,wtk,kxc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   integer,intent(in) :: susopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: kxc(:,:,:,:)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(in) :: occ_freq(2,mband,nfreq)
   real(dp),intent(inout) :: rhoextrap_dyn(2,ndiel4,ndiel5,ndiel6,nfreq)
   real(dp),intent(inout) :: susmat_dyn(2,npwdiel,nsppol,npwdiel,nsppol,nfreq)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine susk_kxc_dyn
 end interface

 interface
  subroutine suskmm(bdtot_index,cg,doccde,drhode,eigen,extrap,gbound,&  
&  gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,occ_deavg,rhoextrap,sumdocc,&  
&  susmat,ucvol,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(inout) :: rhoextrap(ndiel4,ndiel5,ndiel6)
   real(dp),intent(inout) :: susmat(2,npwdiel,nsppol,npwdiel,nsppol)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suskmm
 end interface

 interface
  subroutine suskmm_dyn(bdtot_index,cg,doccde,drhode,eigen,extrap,freq,&  
&  gbound,gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nfreq,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,&  
&  occ_deavg,occ_freq,rhoextrap_dyn,sumdocc,susmat_dyn,susopt,ucvol,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   integer,intent(in) :: susopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(in) :: occ_freq(2,mband,nfreq)
   real(dp),intent(inout) :: rhoextrap_dyn(2,ndiel4,ndiel5,ndiel6,nfreq)
   real(dp),intent(inout) :: susmat_dyn(2,npwdiel,nsppol,npwdiel,nsppol,nfreq)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suskmm_dyn
 end interface

 interface
  subroutine suskmm_kxc_dyn(bdtot_index,cg,doccde,drhode,eigen,extrap,freq,&  
&  gbound,gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&  
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&  
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nfreq,ngfftdiel,nkpt,&  
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,&  
&  occ_deavg,occ_freq,rhoextrap_dyn,sumdocc,susmat_dyn,susopt,ucvol,wtk,&  
&  kxc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: bdtot_index
   integer,intent(in) :: extrap
   integer,intent(in) :: icg
   integer,intent(in) :: ikpt
   integer,intent(in) :: isp
   integer,intent(in) :: mband
   integer,intent(in) :: mcg
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nband_k
   integer,intent(in) :: ndiel4
   integer,intent(in) :: ndiel5
   integer,intent(in) :: ndiel6
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreq
   integer,intent(in) :: nkpt
   integer,intent(in) :: npw_k
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: occopt
   integer,intent(in) :: susopt
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(inout) :: sumdocc
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: kxc(:,:,:,:)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: cg(2,mcg)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreq)
   integer,intent(in) :: gbound(2*mgfftdiel+8,2)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: kg_k(3,npw_k)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: occ_deavg(mband)
   real(dp),intent(in) :: occ_freq(2,mband,nfreq)
   real(dp),intent(inout) :: rhoextrap_dyn(2,ndiel4,ndiel5,ndiel6,nfreq)
   real(dp),intent(inout) :: susmat_dyn(2,npwdiel,nsppol,npwdiel,nsppol,nfreq)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine suskmm_kxc_dyn
 end interface

 interface
  subroutine xcacfd(cg,densymop_diel,dielar,dielop,doccde,&  
&  dtfil,dtset,eigen,filsustr,freq,gbound_diel,gmet,&  
&  gprimd,irrzondiel,kg,kg_diel,mband,mgfftdiel,&  
&  mkmem,mpi_enreg,mpw,nfft,nfftdiel,nfreqsus,ngfft,&  
&  ngfftdiel,nkpt,npwarr,npwdiel,nspden,nspinor,nsppol,&  
&  nsym,occ,phnonsdiel,rhor,rmet,rprimd,ucvol,wff1,wght_freq,ncdims)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: dielop
   integer,intent(in) :: mband
   integer,intent(in) :: mgfftdiel
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: nfft
   integer,intent(in) :: nfftdiel
   integer,intent(in) :: nfreqsus
   integer,intent(in) :: nkpt
   integer,intent(in) :: npwdiel
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   type(dens_sym_operator_type),intent(in) :: densymop_diel
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   character(len=fnlen),intent(in) :: filsustr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(vardims_type),intent(inout) :: ncdims
   real(dp),intent(in) :: ucvol
   type(wffile_type),intent(inout) :: wff1
   real(dp),intent(inout) :: dielar(7)
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   integer,intent(in) :: ngfft(18)
   integer,intent(in) :: ngfftdiel(18)
   real(dp),intent(in) :: rmet(3,3)
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   real(dp),intent(in) :: doccde(mband*nkpt*nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   real(dp),intent(in) :: freq(nfreqsus)
   integer,intent(in) :: gbound_diel(2*mgfftdiel+8,2)
   integer,intent(in) :: irrzondiel(nfftdiel**(1-1/nsym),2,nspden/nsppol)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: kg_diel(3,npwdiel)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   real(dp),intent(in) :: phnonsdiel(2,nfftdiel**(1-1/nsym),nspden/nsppol)
   real(dp),intent(in) :: rhor(nfft,nspden)
   real(dp),intent(in) :: wght_freq(nfreqsus)
  end subroutine xcacfd
 end interface

end module interfaces_17suscep
!!***
