#include "Vlib.h"

#if !((defined(__GNUC__) || defined(__STDC__) || defined(_WINDOWS)) && !defined(_NO_INLINE))

/*
 * VTransform: transform a point from one coordinate system to another.
 */

void
VTransform(pt, mt, newPt)
VPoint   *pt;
VMatrix  *mt;
VPoint   *newPt;
{

	newPt->x = pt->x * mt->m[0][0] + pt->y * mt->m[0][1]
		+ pt->z * mt->m[0][2] + mt->m[0][3];

	newPt->y = pt->x * mt->m[1][0] + pt->y * mt->m[1][1]
		+ pt->z * mt->m[1][2] + mt->m[1][3];

	newPt->z = pt->x * mt->m[2][0] + pt->y * mt->m[2][1]
		+ pt->z * mt->m[2][2] + mt->m[2][3];
}

void
VReverseTransform(pt, mt, newPt)
VPoint   *pt;
VMatrix  *mt;
VPoint   *newPt;
{
	VPoint    tmp;

	tmp.x = pt->x - mt->m[0][3];
	tmp.y = pt->y - mt->m[1][3];
	tmp.z = pt->z - mt->m[2][3];

	newPt->x = tmp.x * mt->m[0][0] + tmp.y * mt->m[1][0]
		+ tmp.z * mt->m[2][0];

	newPt->y = tmp.x * mt->m[0][1] + tmp.y * mt->m[1][1]
		+ tmp.z * mt->m[2][1];

	newPt->z = tmp.x * mt->m[0][2] + tmp.y * mt->m[1][2]
		+ tmp.z * mt->m[2][2];
}

void
VTransform_(pt, mt, newPt)
VPoint   *pt;
VMatrix  *mt;
VPoint   *newPt;
{

	newPt->x = pt->x * mt->m[0][0] + pt->y * mt->m[0][1]
		+ pt->z * mt->m[0][2];

	newPt->y = pt->x * mt->m[1][0] + pt->y * mt->m[1][1]
		+ pt->z * mt->m[1][2];

	newPt->z = pt->x * mt->m[2][0] + pt->y * mt->m[2][1]
		+ pt->z * mt->m[2][2];
}

/*
 *  Apply the reverse of a given transformation
 */

void
VReverseTransform_(pt, mt, newPt)
VPoint   *pt;
VMatrix  *mt;
VPoint   *newPt;
{

	newPt->x = pt->x * mt->m[0][0] + pt->y * mt->m[1][0]
		+ pt->z * mt->m[2][0];

	newPt->y = pt->x * mt->m[0][1] + pt->y * mt->m[1][1]
		+ pt->z * mt->m[2][1];

	newPt->z = pt->x * mt->m[0][2] + pt->y * mt->m[1][2]
		+ pt->z * mt->m[2][2];
}

#endif
