/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>

#include "gedit.h"
#include <stdio.h>
#include <X11/Xos.h>

char *markers[] = {
	"Pilot's Head Location",
	"Nose/Tail Gear Ground Contact Point",
	"Main Gear Ground Contact Point",
	"Tail Ground Contact Point",
	NULL
	};

extern void MenuCB();

void
CreateMarkerList(parent)
Widget	parent;
{

	register char	**p;
	register int	count = 0, i, n;
	XmString	string;
	Widget		item, menu, cascade;
	Arg		args[4];
	char		s[32];

	for (p=markers; *p; ++p) {
		++count;
	}

	marker_count = count;

	n = 0;
	menu = XmCreatePulldownMenu (parent, "marker_menu", args, n);

	marker_list = (marker_t *) XtMalloc (count * sizeof(marker_t));

	for (i=0; i<count; ++i) {
		marker_list[i].defined = False;
		marker_list[i].id = i;
		strncpy (marker_list[i].name, markers[i],
			sizeof(marker_list[i].name));
		string = XmStringCreateSimple(markers[i]);
		sprintf (s, "marker_%d", i);
		item = XtVaCreateWidget (s, xmPushButtonWidgetClass,
			menu,
			XmNlabelString,	string,
			NULL);
		XtManageChild (item);
		XtAddCallback (item, XmNactivateCallback, MenuCB,
			(XtPointer) (MENU_MARKER + i));
		XmStringFree (string);
	}

	XtManageChild (menu);

	n = 0;
	XtSetArg (args[n], XmNsubMenuId, menu);  n++;
	XtSetArg (args[n], XmNmnemonic, 'M');  n++;
	cascade = XmCreateCascadeButton (parent, "Markers", args, n);
	XtManageChild (cascade);

}
