/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#include <Xm/Xm.h>
#include <stdio.h>

#include "../util/error.h"
#include "shared.h"

#define VWriteObject_IMPORT
#include "VWriteObject.h"


int WriteVFile(char *name)
{

	int      i, j, k, points = 0, polygons = 0, error;
	register point_t        *p;
	FILE    *f;
	char    ivname[1024];

	if ((f = fopen (name, "w")) == (FILE *) NULL) {
		perror ("can't open file");
	}

/*
 *  Total the number of vertices in all of the object's polygons
 */

	for (i=sel_polygon; i >= 0; i = polygon_list[i].next) {
		polygons ++;
		points += polygon_list[i].num_points;
	}

	for (i=unsel_polygon; i >= 0; i = polygon_list[i].next) {
		polygons ++;
		points += polygon_list[i].num_points;
	}

/*
 *  Print the header
 */

	fprintf (f, "%s\n%d %d\n", "object", points, polygons);

/*
 *  Print the point list
 */

	k = 1;

	for (i=sel_polygon; i >= 0; i = polygon_list[i].next) {
		for (j=0; j < polygon_list[i].num_points; ++j) {
			p = &polygon_list[i].point[j];
			fprintf (f, "%d %lg %lg %lg\n", k, p->point.x,
				p->point.y, p->point.z);
			++k;
		}
	}

	for (i=unsel_polygon; i >= 0; i = polygon_list[i].next) {
		for (j=0; j < polygon_list[i].num_points; ++j) {
			p = &polygon_list[i].point[j];
			fprintf (f, "%d %lg %lg %lg\n", k, p->point.x,
				p->point.y, p->point.z);
			++k;
		}
	}


/*
 *  Print the polygon list
 */

	k = 1;

	for (i=sel_polygon; i >= 0; i = polygon_list[i].next) {
		fprintf(f, "%s %d", "gray44", polygon_list[i].num_points);
		for (j=0; j < polygon_list[i].num_points; ++j) {
			fprintf(f, " %d", k++);
		}
		fprintf (f, "\n");
	}

	for (i=unsel_polygon; i >= 0; i = polygon_list[i].next) {
		fprintf(f, "%s %d", "gray44", polygon_list[i].num_points);
		for (j=0; j < polygon_list[i].num_points; ++j) {
			fprintf(f, " %d", k++);
		}
		fprintf (f, "\n");
	}

	error = ferror(f) ? -1 : 0;

	fclose (f);

/*
 *  Now write the aircraft inventory information
 */
	
	snprintf(ivname, sizeof(ivname), "%s.inv", name);
	if ((f = fopen (ivname, "w")) == NULL)
		error_system("opening %s for writing", ivname);

	c.viewPoint = marker_list[MARKER_HEAD].location.point;

	fprintf (f, "aircraft \"%s\" {\n\n", c.name);
	fprintf (f, "\tWingArea\t%lg\n", c.wingS);
	fprintf (f, "\tWingHalfSpan\t%lg\n", c.wings);
	fprintf (f, "\tChord\t\t%lg\n", c.c);
	fprintf (f, "\tEmptyWeight\t%lg\n", c.emptyWeight);
	fprintf (f, "\tMaxFuel\t\t%lg\n", c.maxFuel);
	fprintf (f, "\tIxx\t\t%lg\n", c.I.m[0][0]);
	fprintf (f, "\tIyy\t\t%lg\n", c.I.m[1][1]);
	fprintf (f, "\tIzz\t\t%lg\n", c.I.m[2][2]);     
	fprintf (f, "\tRm\t\t{%lg,  %lg,  %lg}\n", c.rm.x, c.rm.y, c.rm.z);
	fprintf (f, "\tRn\t\t{%lg,  %lg,  %lg}\n", c.rn.x, c.rn.y, c.rn.z);
	fprintf (f, "\tKm\t\t%lg\n", c.Km);
	fprintf (f, "\tKn\t\t%lg\n", c.Kn);
	fprintf (f, "\tGm\t\t%lg\n", c.Gm);
	fprintf (f, "\tGn\t\t%lg\n", c.Gn);
	fprintf (f, "\tCmMax\t\t%lg\n", c.cmMax);
	fprintf (f, "\tCnMax\t\t%lg\n", c.cnMax);
	//fprintf (f, "\tGroundingPoint\t{0.0, 0.0, %lg}\n", c.groundingPoint.z);
	fprintf (f, "\tViewPoint\t{%lg, %lg, %lg}\n",
		c.viewPoint.x, c.viewPoint.y, c.viewPoint.z);
	fprintf (f, "\n");
	fprintf (f, "\tMaxThrust\t%lg\n", c.maxThrust);
	fprintf (f, "\tMaxABThrust\t%lg\n", c.maxABThrust);
	fprintf (f, "\tSpFuelConsump\t%lg\n", c.spFuelConsump);
	fprintf (f, "\tSpABFuelConsump\t%lg\n", c.spABFuelConsump);
	fprintf (f, "\tEngineLag\t%lg\n", c.engineLag);
	fprintf (f, "\n");
	fprintf (f, "\tClda\t\t%lg\n", c.Clda);
	fprintf (f, "\tCldr\t\t%lg\n", c.Cldr);
	fprintf (f, "\tClp\t\t%lg\n", c.Clp);
	fprintf (f, "\tCmq\t\t%lg\n", c.Cmq);
	fprintf (f, "\tCnr\t\t%lg\n", c.Cnr);
	fprintf (f, "\tCmAlpha\t\t%lg\n", c.cmSlope);
	//fprintf (f, "\tCmFactor\t%lg\n", c.cmFactor);
	fprintf (f, "\t}\n");
	fclose (f);

	return error;
}
