// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkStringObject")]
    pub struct StringObject(Object<ffi::GtkStringObject, ffi::GtkStringObjectClass>);

    match fn {
        type_ => || ffi::gtk_string_object_get_type(),
    }
}

impl StringObject {
    #[doc(alias = "gtk_string_object_new")]
    pub fn new(string: &str) -> StringObject {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_string_object_new(string.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_string_object_get_string")]
    #[doc(alias = "get_string")]
    pub fn string(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_string_object_get_string(self.to_glib_none().0)) }
    }

    #[doc(alias = "string")]
    pub fn connect_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_string_trampoline<F: Fn(&StringObject) + 'static>(
            this: *mut ffi::GtkStringObject,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::string\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_string_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for StringObject {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("StringObject")
    }
}
