//
// This file is part of the aMule Project.
//
// Copyright (c) 2020 aMule Team ( admin@amule.org / http://www.amule.org )
//
// Any parts of this program derived from the xMule, lMule or eMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

/* Functions for logging EC packets in debug builds
 *
 * The following functions are not implemented in the library, they need
 * to be implemented in EC using applications.
 */

#ifndef EC_ECLOG_H
#define EC_ECLOG_H

#ifdef __DEBUG__

/**
 * Check whether EC packet logging is enabled
 */
bool ECLogIsEnabled();

/**
 * Actually log a line of text
 */
void DoECLogLine(const wxString &line);

#else

#define ECLogIsEnabled()	false
#define DoECLogLine(x)		do {} while(0)

#endif /* __DEBUG__ */

#endif /* EC_ECLOG_H */
