# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid.utils import log_error

debug_mode = False


def debug(message, *args):
    """Write debugging output to the Apache error log.
    Output only occurs if this line appears in the configuration file:

    PythonOption debug 1

    See OpenIDAccessRequest.error() for args
    """
    if debug_mode:
        error(message, *args)


def error(message, *args):
    """Write output to the Apache error log.

    :param message: The %-style string template.
    :type message: string
    :param args: An optional sequence of values to interpolate into
        the `message` template.
    :type args: A *-args tuple
    """
    log_error(message % args)
