##########################################################################
#
# Copyright 2012 Jose Fonseca
# All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
##########################################################################/


from winapi import *


D3D_DRIVER_TYPE = Enum('D3D_DRIVER_TYPE', [
    'D3D_DRIVER_TYPE_UNKNOWN',
    'D3D_DRIVER_TYPE_HARDWARE',
    'D3D_DRIVER_TYPE_REFERENCE',
    'D3D_DRIVER_TYPE_NULL',
    'D3D_DRIVER_TYPE_SOFTWARE',
    'D3D_DRIVER_TYPE_WARP',
])

D3D_FEATURE_LEVEL = Enum('D3D_FEATURE_LEVEL', [
    'D3D_FEATURE_LEVEL_9_1',
    'D3D_FEATURE_LEVEL_9_2',
    'D3D_FEATURE_LEVEL_9_3',
    'D3D_FEATURE_LEVEL_10_0',
    'D3D_FEATURE_LEVEL_10_1',
    'D3D_FEATURE_LEVEL_11_0',
    'D3D_FEATURE_LEVEL_11_1',
])

D3D_PRIMITIVE_TOPOLOGY = Enum('D3D_PRIMITIVE_TOPOLOGY', [
    'D3D_PRIMITIVE_TOPOLOGY_UNDEFINED',
    'D3D_PRIMITIVE_TOPOLOGY_POINTLIST',
    'D3D_PRIMITIVE_TOPOLOGY_LINELIST',
    'D3D_PRIMITIVE_TOPOLOGY_LINESTRIP',
    'D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST',
    'D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP',
    'D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ',
    'D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ',
    'D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ',
    'D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ',
    'D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST',
    'D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST',
])

D3D10_PRIMITIVE_TOPOLOGY = Enum('D3D10_PRIMITIVE_TOPOLOGY', [
    'D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED',
    'D3D10_PRIMITIVE_TOPOLOGY_POINTLIST',
    'D3D10_PRIMITIVE_TOPOLOGY_LINELIST',
    'D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP',
    'D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST',
    'D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP',
    'D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ',
    'D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ',
    'D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ',
    'D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ',
])

D3D11_PRIMITIVE_TOPOLOGY = Enum('D3D11_PRIMITIVE_TOPOLOGY', [
    'D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED',
    'D3D11_PRIMITIVE_TOPOLOGY_POINTLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_LINELIST',
    'D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP',
    'D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST',
    'D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP',
    'D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ',
    'D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ',
    'D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ',
    'D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ',
    'D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST',
    'D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST',
])

D3D_PRIMITIVE = Enum('D3D_PRIMITIVE', [
    'D3D_PRIMITIVE_UNDEFINED',
    'D3D_PRIMITIVE_POINT',
    'D3D_PRIMITIVE_LINE',
    'D3D_PRIMITIVE_TRIANGLE',
    'D3D_PRIMITIVE_LINE_ADJ',
    'D3D_PRIMITIVE_TRIANGLE_ADJ',
    'D3D_PRIMITIVE_1_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_2_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_3_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_4_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_5_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_6_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_7_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_8_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_9_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_10_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_11_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_12_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_13_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_14_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_15_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_16_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_17_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_18_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_19_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_20_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_21_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_22_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_23_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_24_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_25_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_26_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_27_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_28_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_29_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_30_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_31_CONTROL_POINT_PATCH',
    'D3D_PRIMITIVE_32_CONTROL_POINT_PATCH',
])

D3D10_PRIMITIVE = Enum('D3D10_PRIMITIVE', [
    'D3D10_PRIMITIVE_UNDEFINED',
    'D3D10_PRIMITIVE_POINT',
    'D3D10_PRIMITIVE_LINE',
    'D3D10_PRIMITIVE_TRIANGLE',
    'D3D10_PRIMITIVE_LINE_ADJ',
    'D3D10_PRIMITIVE_TRIANGLE_ADJ',
])

D3D11_PRIMITIVE = Enum('D3D11_PRIMITIVE', [
    'D3D11_PRIMITIVE_UNDEFINED',
    'D3D11_PRIMITIVE_POINT',
    'D3D11_PRIMITIVE_LINE',
    'D3D11_PRIMITIVE_TRIANGLE',
    'D3D11_PRIMITIVE_LINE_ADJ',
    'D3D11_PRIMITIVE_TRIANGLE_ADJ',
    'D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH',
    'D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH',
])

D3D_SRV_DIMENSION = Enum('D3D_SRV_DIMENSION', [
    'D3D_SRV_DIMENSION_UNKNOWN',
    'D3D_SRV_DIMENSION_BUFFER',
    'D3D_SRV_DIMENSION_TEXTURE1D',
    'D3D_SRV_DIMENSION_TEXTURE1DARRAY',
    'D3D_SRV_DIMENSION_TEXTURE2D',
    'D3D_SRV_DIMENSION_TEXTURE2DARRAY',
    'D3D_SRV_DIMENSION_TEXTURE2DMS',
    'D3D_SRV_DIMENSION_TEXTURE2DMSARRAY',
    'D3D_SRV_DIMENSION_TEXTURE3D',
    'D3D_SRV_DIMENSION_TEXTURECUBE',
    'D3D_SRV_DIMENSION_TEXTURECUBEARRAY',
    'D3D_SRV_DIMENSION_BUFFEREX',
])

D3D10_SRV_DIMENSION = Enum('D3D10_SRV_DIMENSION', [
    'D3D10_SRV_DIMENSION_UNKNOWN',
    'D3D10_SRV_DIMENSION_BUFFER',
    'D3D10_SRV_DIMENSION_TEXTURE1D',
    'D3D10_SRV_DIMENSION_TEXTURE1DARRAY',
    'D3D10_SRV_DIMENSION_TEXTURE2D',
    'D3D10_SRV_DIMENSION_TEXTURE2DARRAY',
    'D3D10_SRV_DIMENSION_TEXTURE2DMS',
    'D3D10_SRV_DIMENSION_TEXTURE2DMSARRAY',
    'D3D10_SRV_DIMENSION_TEXTURE3D',
    'D3D10_SRV_DIMENSION_TEXTURECUBE',
])

D3D10_SRV_DIMENSION1 = Enum('D3D10_SRV_DIMENSION1', [
    'D3D10_1_SRV_DIMENSION_UNKNOWN',
    'D3D10_1_SRV_DIMENSION_BUFFER',
    'D3D10_1_SRV_DIMENSION_TEXTURE1D',
    'D3D10_1_SRV_DIMENSION_TEXTURE1DARRAY',
    'D3D10_1_SRV_DIMENSION_TEXTURE2D',
    'D3D10_1_SRV_DIMENSION_TEXTURE2DARRAY',
    'D3D10_1_SRV_DIMENSION_TEXTURE2DMS',
    'D3D10_1_SRV_DIMENSION_TEXTURE2DMSARRAY',
    'D3D10_1_SRV_DIMENSION_TEXTURE3D',
    'D3D10_1_SRV_DIMENSION_TEXTURECUBE',
    'D3D10_1_SRV_DIMENSION_TEXTURECUBEARRAY',
])

D3D11_SRV_DIMENSION = Enum('D3D11_SRV_DIMENSION', [
    'D3D11_SRV_DIMENSION_UNKNOWN',
    'D3D11_SRV_DIMENSION_BUFFER',
    'D3D11_SRV_DIMENSION_TEXTURE1D',
    'D3D11_SRV_DIMENSION_TEXTURE1DARRAY',
    'D3D11_SRV_DIMENSION_TEXTURE2D',
    'D3D11_SRV_DIMENSION_TEXTURE2DARRAY',
    'D3D11_SRV_DIMENSION_TEXTURE2DMS',
    'D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY',
    'D3D11_SRV_DIMENSION_TEXTURE3D',
    'D3D11_SRV_DIMENSION_TEXTURECUBE',
    'D3D11_SRV_DIMENSION_TEXTURECUBEARRAY',
    'D3D11_SRV_DIMENSION_BUFFEREX',
])

D3D10_SHADER_MACRO = Struct('D3D10_SHADER_MACRO', [
    (LPCSTR, 'Name'),
    (LPCSTR, 'Definition'),
])

ID3D10Blob = Interface('ID3D10Blob', IUnknown)
ID3D10Blob.methods += [
    StdMethod(LPVOID, 'GetBufferPointer', [], sideeffects=False),
    StdMethod(SIZE_T, 'GetBufferSize', [], sideeffects=False),
]
LPD3D10BLOB = ObjPointer(ID3D10Blob)

D3D_INCLUDE_TYPE = Enum('D3D_INCLUDE_TYPE', [
    'D3D_INCLUDE_LOCAL',
    'D3D_INCLUDE_SYSTEM',
])

D3D10_INCLUDE_TYPE = Enum('D3D10_INCLUDE_TYPE', [
    'D3D10_INCLUDE_LOCAL',
    'D3D10_INCLUDE_SYSTEM',
])

ID3D10Include = Interface("ID3D10Include", IUnknown)
ID3D10Include.methods += [
    StdMethod(HRESULT, "Open", [(D3D10_INCLUDE_TYPE, "IncludeType"), (LPCSTR, "pFileName"), (LPCVOID, "pParentData"), Out(Pointer(LPCVOID), "ppData"), Out(Pointer(UINT), "pBytes")]),
    StdMethod(HRESULT, "Close", [(LPCVOID, "pData")]),
]
# It is implemented by applications, not D3D runtime, so treat as opaque for
# now.
LPD3D10INCLUDE = OpaquePointer(ID3D10Include)

D3D_SHADER_VARIABLE_CLASS = Enum('D3D_SHADER_VARIABLE_CLASS', [
    'D3D_SVC_SCALAR',
    'D3D_SVC_VECTOR',
    'D3D_SVC_MATRIX_ROWS',
    'D3D_SVC_MATRIX_COLUMNS',
    'D3D_SVC_OBJECT',
    'D3D_SVC_STRUCT',
    'D3D_SVC_INTERFACE_CLASS',
    'D3D_SVC_INTERFACE_POINTER',
])

D3D10_SHADER_VARIABLE_CLASS = Enum('D3D_SHADER_VARIABLE_CLASS', [
    'D3D10_SVC_SCALAR',
    'D3D10_SVC_VECTOR',
    'D3D10_SVC_MATRIX_ROWS',
    'D3D10_SVC_MATRIX_COLUMNS',
    'D3D10_SVC_OBJECT',
    'D3D10_SVC_STRUCT',
])

D3D11_SHADER_VARIABLE_CLASS = Enum('D3D_SHADER_VARIABLE_CLASS', [
    'D3D11_SVC_INTERFACE_CLASS',
    'D3D11_SVC_INTERFACE_POINTER',
])

D3D10_SHADER_VARIABLE_FLAGS = Enum('D3D10_SHADER_VARIABLE_FLAGS', [
    'D3D_SVF_USERPACKED',
    'D3D_SVF_USED',
    'D3D_SVF_INTERFACE_POINTER',
    'D3D_SVF_INTERFACE_PARAMETER',
])

D3D11_SHADER_VARIABLE_FLAGS = Enum('D3D11_SHADER_VARIABLE_FLAGS', [
    'D3D10_SVF_USERPACKED',
    'D3D10_SVF_USED',
    'D3D11_SVF_INTERFACE_POINTER',
    'D3D11_SVF_INTERFACE_PARAMETER',
])

D3D_SHADER_VARIABLE_TYPE = Enum('D3D_SHADER_VARIABLE_TYPE', [
    'D3D_SVT_VOID',
    'D3D_SVT_BOOL',
    'D3D_SVT_INT',
    'D3D_SVT_FLOAT',
    'D3D_SVT_STRING',
    'D3D_SVT_TEXTURE',
    'D3D_SVT_TEXTURE1D',
    'D3D_SVT_TEXTURE2D',
    'D3D_SVT_TEXTURE3D',
    'D3D_SVT_TEXTURECUBE',
    'D3D_SVT_SAMPLER',
    'D3D_SVT_SAMPLER1D',
    'D3D_SVT_SAMPLER2D',
    'D3D_SVT_SAMPLER3D',
    'D3D_SVT_SAMPLERCUBE',
    'D3D_SVT_PIXELSHADER',
    'D3D_SVT_VERTEXSHADER',
    'D3D_SVT_PIXELFRAGMENT',
    'D3D_SVT_VERTEXFRAGMENT',
    'D3D_SVT_UINT',
    'D3D_SVT_UINT8',
    'D3D_SVT_GEOMETRYSHADER',
    'D3D_SVT_RASTERIZER',
    'D3D_SVT_DEPTHSTENCIL',
    'D3D_SVT_BLEND',
    'D3D_SVT_BUFFER',
    'D3D_SVT_CBUFFER',
    'D3D_SVT_TBUFFER',
    'D3D_SVT_TEXTURE1DARRAY',
    'D3D_SVT_TEXTURE2DARRAY',
    'D3D_SVT_RENDERTARGETVIEW',
    'D3D_SVT_DEPTHSTENCILVIEW',
    'D3D_SVT_TEXTURE2DMS',
    'D3D_SVT_TEXTURE2DMSARRAY',
    'D3D_SVT_TEXTURECUBEARRAY',
    'D3D_SVT_HULLSHADER',
    'D3D_SVT_DOMAINSHADER',
    'D3D_SVT_INTERFACE_POINTER',
    'D3D_SVT_COMPUTESHADER',
    'D3D_SVT_DOUBLE',
    'D3D_SVT_RWTEXTURE1D',
    'D3D_SVT_RWTEXTURE1DARRAY',
    'D3D_SVT_RWTEXTURE2D',
    'D3D_SVT_RWTEXTURE2DARRAY',
    'D3D_SVT_RWTEXTURE3D',
    'D3D_SVT_RWBUFFER',
    'D3D_SVT_BYTEADDRESS_BUFFER',
    'D3D_SVT_RWBYTEADDRESS_BUFFER',
    'D3D_SVT_STRUCTURED_BUFFER',
    'D3D_SVT_RWSTRUCTURED_BUFFER',
    'D3D_SVT_APPEND_STRUCTURED_BUFFER',
    'D3D_SVT_CONSUME_STRUCTURED_BUFFER',
])

D3D10_SHADER_VARIABLE_TYPE = Enum('D3D10_SHADER_VARIABLE_TYPE', [
    'D3D10_SVT_VOID',
    'D3D10_SVT_BOOL',
    'D3D10_SVT_INT',
    'D3D10_SVT_FLOAT',
    'D3D10_SVT_STRING',
    'D3D10_SVT_TEXTURE',
    'D3D10_SVT_TEXTURE1D',
    'D3D10_SVT_TEXTURE2D',
    'D3D10_SVT_TEXTURE3D',
    'D3D10_SVT_TEXTURECUBE',
    'D3D10_SVT_SAMPLER',
    'D3D10_SVT_SAMPLER1D',
    'D3D10_SVT_SAMPLER2D',
    'D3D10_SVT_SAMPLER3D',
    'D3D10_SVT_SAMPLERCUBE',
    'D3D10_SVT_PIXELSHADER',
    'D3D10_SVT_VERTEXSHADER',
    'D3D10_SVT_PIXELFRAGMENT',
    'D3D10_SVT_VERTEXFRAGMENT',
    'D3D10_SVT_UINT',
    'D3D10_SVT_UINT8',
    'D3D10_SVT_GEOMETRYSHADER',
    'D3D10_SVT_RASTERIZER',
    'D3D10_SVT_DEPTHSTENCIL',
    'D3D10_SVT_BLEND',
    'D3D10_SVT_BUFFER',
    'D3D10_SVT_CBUFFER',
    'D3D10_SVT_TBUFFER',
    'D3D10_SVT_TEXTURE1DARRAY',
    'D3D10_SVT_TEXTURE2DARRAY',
    'D3D10_SVT_RENDERTARGETVIEW',
    'D3D10_SVT_DEPTHSTENCILVIEW',
    'D3D10_SVT_TEXTURE2DMS',
    'D3D10_SVT_TEXTURE2DMSARRAY',
    'D3D10_SVT_TEXTURECUBEARRAY',
])

D3D11_SHADER_VARIABLE_TYPE = Enum('D3D11_SHADER_VARIABLE_TYPE', [
    'D3D11_SVT_HULLSHADER',
    'D3D11_SVT_DOMAINSHADER',
    'D3D11_SVT_INTERFACE_POINTER',
    'D3D11_SVT_COMPUTESHADER',
    'D3D11_SVT_DOUBLE',
    'D3D11_SVT_RWTEXTURE1D',
    'D3D11_SVT_RWTEXTURE1DARRAY',
    'D3D11_SVT_RWTEXTURE2D',
    'D3D11_SVT_RWTEXTURE2DARRAY',
    'D3D11_SVT_RWTEXTURE3D',
    'D3D11_SVT_RWBUFFER',
    'D3D11_SVT_BYTEADDRESS_BUFFER',
    'D3D11_SVT_RWBYTEADDRESS_BUFFER',
    'D3D11_SVT_STRUCTURED_BUFFER',
    'D3D11_SVT_RWSTRUCTURED_BUFFER',
    'D3D11_SVT_APPEND_STRUCTURED_BUFFER',
    'D3D11_SVT_CONSUME_STRUCTURED_BUFFER',
])

D3D_SHADER_INPUT_FLAGS = Enum('D3D_SHADER_INPUT_FLAGS', [
    'D3D_SIF_USERPACKED',
    'D3D_SIF_COMPARISON_SAMPLER',
    'D3D_SIF_TEXTURE_COMPONENT_0',
    'D3D_SIF_TEXTURE_COMPONENT_1',
    'D3D_SIF_TEXTURE_COMPONENTS',
])

D3D10_SHADER_INPUT_FLAGS = Enum('D3D10_SHADER_INPUT_FLAGS', [
    'D3D10_SIF_USERPACKED',
    'D3D10_SIF_COMPARISON_SAMPLER',
    'D3D10_SIF_TEXTURE_COMPONENT_0',
    'D3D10_SIF_TEXTURE_COMPONENT_1',
    'D3D10_SIF_TEXTURE_COMPONENTS',
])

D3D_SHADER_INPUT_TYPE = Enum('D3D_SHADER_INPUT_TYPE', [
    'D3D_SIT_CBUFFER',
    'D3D_SIT_TBUFFER',
    'D3D_SIT_TEXTURE',
    'D3D_SIT_SAMPLER',
    'D3D_SIT_UAV_RWTYPED',
    'D3D_SIT_STRUCTURED',
    'D3D_SIT_UAV_RWSTRUCTURED',
    'D3D_SIT_BYTEADDRESS',
    'D3D_SIT_UAV_RWBYTEADDRESS',
    'D3D_SIT_UAV_APPEND_STRUCTURED',
    'D3D_SIT_UAV_CONSUME_STRUCTURED',
    'D3D_SIT_UAV_RWSTRUCTURED_WITH_COUNTER',
])

D3D10_SHADER_INPUT_TYPE = Enum('D3D10_SHADER_INPUT_TYPE', [
    'D3D10_SIT_CBUFFER',
    'D3D10_SIT_TBUFFER',
    'D3D10_SIT_TEXTURE',
    'D3D10_SIT_SAMPLER',
])

D3D11_SHADER_INPUT_TYPE = Enum('D3D11_SHADER_INPUT_TYPE', [
    'D3D11_SIT_UAV_RWTYPED',
    'D3D11_SIT_STRUCTURED',
    'D3D11_SIT_UAV_RWSTRUCTURED',
    'D3D11_SIT_BYTEADDRESS',
    'D3D11_SIT_UAV_RWBYTEADDRESS',
    'D3D11_SIT_UAV_APPEND_STRUCTURED',
    'D3D11_SIT_UAV_CONSUME_STRUCTURED',
    'D3D11_SIT_UAV_RWSTRUCTURED_WITH_COUNTER',
])

D3D_SHADER_CBUFFER_FLAGS = Enum('D3D_SHADER_CBUFFER_FLAGS', [
    'D3D_CBF_USERPACKED',
])

D3D10_SHADER_CBUFFER_FLAGS = Enum('D3D10_SHADER_CBUFFER_FLAGS', [
    'D3D10_CBF_USERPACKED',
])

D3D_CBUFFER_TYPE = Enum('D3D_CBUFFER_TYPE', [
    'D3D_CT_CBUFFER',
    'D3D_CT_TBUFFER',
    'D3D_CT_INTERFACE_POINTERS',
    'D3D_CT_RESOURCE_BIND_INFO',
])

D3D10_CBUFFER_TYPE = Enum('D3D10_CBUFFER_TYPE', [
    'D3D10_CT_CBUFFER',
    'D3D10_CT_TBUFFER',
])

D3D11_CBUFFER_TYPE = Enum('D3D11_CBUFFER_TYPE', [
    'D3D11_CT_CBUFFER',
    'D3D11_CT_TBUFFER',
    'D3D11_CT_INTERFACE_POINTERS',
    'D3D11_CT_RESOURCE_BIND_INFO',
])

D3D_NAME = Enum('D3D_NAME', [
    'D3D_NAME_UNDEFINED',
    'D3D_NAME_POSITION',
    'D3D_NAME_CLIP_DISTANCE',
    'D3D_NAME_CULL_DISTANCE',
    'D3D_NAME_RENDER_TARGET_ARRAY_INDEX',
    'D3D_NAME_VIEWPORT_ARRAY_INDEX',
    'D3D_NAME_VERTEX_ID',
    'D3D_NAME_PRIMITIVE_ID',
    'D3D_NAME_INSTANCE_ID',
    'D3D_NAME_IS_FRONT_FACE',
    'D3D_NAME_SAMPLE_INDEX',
    'D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR',
    'D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR',
    'D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR',
    'D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR',
    'D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR',
    'D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR',
    'D3D_NAME_TARGET',
    'D3D_NAME_DEPTH',
    'D3D_NAME_COVERAGE',
    'D3D_NAME_DEPTH_GREATER_EQUAL',
    'D3D_NAME_DEPTH_LESS_EQUAL',
])

D3D10_NAME = Enum('D3D10_NAME', [
    'D3D10_NAME_UNDEFINED',
    'D3D10_NAME_POSITION',
    'D3D10_NAME_CLIP_DISTANCE',
    'D3D10_NAME_CULL_DISTANCE',
    'D3D10_NAME_RENDER_TARGET_ARRAY_INDEX',
    'D3D10_NAME_VIEWPORT_ARRAY_INDEX',
    'D3D10_NAME_VERTEX_ID',
    'D3D10_NAME_PRIMITIVE_ID',
    'D3D10_NAME_INSTANCE_ID',
    'D3D10_NAME_IS_FRONT_FACE',
    'D3D10_NAME_SAMPLE_INDEX',
    'D3D10_NAME_TARGET',
    'D3D10_NAME_DEPTH',
    'D3D10_NAME_COVERAGE',
])

D3D11_NAME = Enum('D3D11_NAME', [
    'D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR',
    'D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR',
    'D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR',
    'D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR',
    'D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR',
    'D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR',
    'D3D11_NAME_DEPTH_GREATER_EQUAL',
    'D3D11_NAME_DEPTH_LESS_EQUAL',
])

D3D_RESOURCE_RETURN_TYPE = Enum('D3D_RESOURCE_RETURN_TYPE', [
    'D3D_RETURN_TYPE_UNORM',
    'D3D_RETURN_TYPE_SNORM',
    'D3D_RETURN_TYPE_SINT',
    'D3D_RETURN_TYPE_UINT',
    'D3D_RETURN_TYPE_FLOAT',
    'D3D_RETURN_TYPE_MIXED',
    'D3D_RETURN_TYPE_DOUBLE',
    'D3D_RETURN_TYPE_CONTINUED',
])

D3D10_RESOURCE_RETURN_TYPE = Enum('D3D10_RESOURCE_RETURN_TYPE', [
    'D3D10_RETURN_TYPE_UNORM',
    'D3D10_RETURN_TYPE_SNORM',
    'D3D10_RETURN_TYPE_SINT',
    'D3D10_RETURN_TYPE_UINT',
    'D3D10_RETURN_TYPE_FLOAT',
    'D3D10_RETURN_TYPE_MIXED',
])

D3D11_RESOURCE_RETURN_TYPE = Enum('D3D11_RESOURCE_RETURN_TYPE', [
    'D3D11_RETURN_TYPE_UNORM',
    'D3D11_RETURN_TYPE_SNORM',
    'D3D11_RETURN_TYPE_SINT',
    'D3D11_RETURN_TYPE_UINT',
    'D3D11_RETURN_TYPE_FLOAT',
    'D3D11_RETURN_TYPE_MIXED',
    'D3D11_RETURN_TYPE_DOUBLE',
    'D3D11_RETURN_TYPE_CONTINUED',
])

D3D_REGISTER_COMPONENT_TYPE = Enum('D3D_REGISTER_COMPONENT_TYPE', [
    'D3D_REGISTER_COMPONENT_UNKNOWN',
    'D3D_REGISTER_COMPONENT_UINT32',
    'D3D_REGISTER_COMPONENT_SINT32',
    'D3D_REGISTER_COMPONENT_FLOAT32',
])

D3D10_REGISTER_COMPONENT_TYPE = Enum('D3D10_REGISTER_COMPONENT_TYPE', [
    'D3D10_REGISTER_COMPONENT_UNKNOWN',
    'D3D10_REGISTER_COMPONENT_UINT32',
    'D3D10_REGISTER_COMPONENT_SINT32',
    'D3D10_REGISTER_COMPONENT_FLOAT32',
])

D3D_TESSELLATOR_DOMAIN = Enum('D3D_TESSELLATOR_DOMAIN', [
    'D3D_TESSELLATOR_DOMAIN_UNDEFINED',
    'D3D_TESSELLATOR_DOMAIN_ISOLINE',
    'D3D_TESSELLATOR_DOMAIN_TRI',
    'D3D_TESSELLATOR_DOMAIN_QUAD',
])

D3D11_TESSELLATOR_DOMAIN = Enum('D3D11_TESSELLATOR_DOMAIN', [
    'D3D11_TESSELLATOR_DOMAIN_UNDEFINED',
    'D3D11_TESSELLATOR_DOMAIN_ISOLINE',
    'D3D11_TESSELLATOR_DOMAIN_TRI',
    'D3D11_TESSELLATOR_DOMAIN_QUAD',
])

D3D_TESSELLATOR_PARTITIONING = Enum('D3D_TESSELLATOR_PARTITIONING', [
    'D3D_TESSELLATOR_PARTITIONING_UNDEFINED',
    'D3D_TESSELLATOR_PARTITIONING_INTEGER',
    'D3D_TESSELLATOR_PARTITIONING_POW2',
    'D3D_TESSELLATOR_PARTITIONING_FRACTIONAL_ODD',
    'D3D_TESSELLATOR_PARTITIONING_FRACTIONAL_EVEN',
])

D3D11_TESSELLATOR_PARTITIONING = Enum('D3D11_TESSELLATOR_PARTITIONING', [
    'D3D11_TESSELLATOR_PARTITIONING_UNDEFINED',
    'D3D11_TESSELLATOR_PARTITIONING_INTEGER',
    'D3D11_TESSELLATOR_PARTITIONING_POW2',
    'D3D11_TESSELLATOR_PARTITIONING_FRACTIONAL_ODD',
    'D3D11_TESSELLATOR_PARTITIONING_FRACTIONAL_EVEN',
])

D3D_TESSELLATOR_OUTPUT_PRIMITIVE = Enum('D3D_TESSELLATOR_OUTPUT_PRIMITIVE', [
    'D3D_TESSELLATOR_OUTPUT_UNDEFINED',
    'D3D_TESSELLATOR_OUTPUT_POINT',
    'D3D_TESSELLATOR_OUTPUT_LINE',
    'D3D_TESSELLATOR_OUTPUT_TRIANGLE_CW',
    'D3D_TESSELLATOR_OUTPUT_TRIANGLE_CCW',
])

D3D11_TESSELLATOR_OUTPUT_PRIMITIVE = Enum('D3D11_TESSELLATOR_OUTPUT_PRIMITIVE', [
    'D3D11_TESSELLATOR_OUTPUT_UNDEFINED',
    'D3D11_TESSELLATOR_OUTPUT_POINT',
    'D3D11_TESSELLATOR_OUTPUT_LINE',
    'D3D11_TESSELLATOR_OUTPUT_TRIANGLE_CW',
    'D3D11_TESSELLATOR_OUTPUT_TRIANGLE_CCW',
])

