/*
 * Copyright (c) 2021, 2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <cstddef>
#include <cstdint>

#if defined(ARM_COMPUTE_ENABLE_SVE) && defined(__ARM_FP16_ARGS) && defined(__ARM_FEATURE_FP16_VECTOR_ARITHMETIC)

namespace arm_conv {
namespace depthwise {

void sve_fp16_nhwc_3x3_s1_output4x4_mla_depthfirst_indirect_impl(
  const __fp16 *const *const input_ptrs,
  __fp16 *const *const outptrs,
  const void *params,
  unsigned int n_channels,
  const __fp16 activation_min,
  const __fp16 activation_max
)
{
  struct Args
  {
    __fp16 *const *outptrs;
    const void *params;
    const __fp16 min, max;
    const __fp16 *inptrs[36];

    Args(
      const __fp16 *const *const input_ptrs,
      __fp16 *const *const outptrs,
      const void *const params,
      const __fp16 min,
      const __fp16 max
    ) : outptrs(outptrs), params(params), min(min), max(max)
    {
      inptrs[0] = input_ptrs[14];
      inptrs[1] = input_ptrs[0];
      inptrs[2] = input_ptrs[5];
      inptrs[3] = input_ptrs[15];
      inptrs[4] = input_ptrs[30];
      inptrs[5] = input_ptrs[35];
      inptrs[6] = input_ptrs[20];
      inptrs[7] = input_ptrs[1];
      inptrs[8] = input_ptrs[4];
      inptrs[9] = input_ptrs[21];
      inptrs[10] = input_ptrs[6];
      inptrs[11] = input_ptrs[11];
      inptrs[12] = input_ptrs[24];
      inptrs[13] = input_ptrs[8];
      inptrs[14] = input_ptrs[29];
      inptrs[15] = input_ptrs[9];
      inptrs[16] = input_ptrs[31];
      inptrs[17] = input_ptrs[13];
      inptrs[18] = input_ptrs[34];
      inptrs[19] = input_ptrs[16];
      inptrs[20] = input_ptrs[2];
      inptrs[21] = input_ptrs[19];
      inptrs[22] = input_ptrs[3];
      inptrs[23] = input_ptrs[12];
      inptrs[24] = input_ptrs[22];
      inptrs[25] = input_ptrs[17];
      inptrs[26] = input_ptrs[18];
      inptrs[27] = input_ptrs[26];
      inptrs[28] = input_ptrs[23];
      inptrs[29] = input_ptrs[32];
      inptrs[30] = input_ptrs[27];
      inptrs[31] = input_ptrs[33];
      inptrs[32] = input_ptrs[7];
      inptrs[33] = input_ptrs[10];
      inptrs[34] = input_ptrs[25];
      inptrs[35] = input_ptrs[28];

    }
  };

  Args params_struct(input_ptrs, outptrs, params,
                     activation_min, activation_max);

  __asm__ __volatile__(
    "ptrue p3.b\n"
    "ldr x7, [%x[params_struct], %[offsetof_args_params]]\n"
    "add x8, %x[params_struct], %[offsetof_Args_inptrs]\n"
    "ld1h { z17.h }, p3/Z, [x7]\n"
    "cnth x17\n"
    "mov x16, #0x0\n"
    "ld1h { z0.h }, p3/Z, [x7, #1, MUL VL]\n"
    "ld1h { z1.h }, p3/Z, [x7, #2, MUL VL]\n"
    "whilelt p2.h, XZR, %x[n_channels]\n"
    "ld1h { z2.h }, p3/Z, [x7, #3, MUL VL]\n"
    "ld1h { z3.h }, p3/Z, [x7, #4, MUL VL]\n"
    "cmp x17, %x[n_channels]\n"
    "ld1h { z4.h }, p3/Z, [x7, #5, MUL VL]\n"
    "ld1h { z5.h }, p3/Z, [x7, #6, MUL VL]\n"
    "sub x15, XZR, x17\n"
    "ld1h { z6.h }, p3/Z, [x7, #7, MUL VL]\n"
    "addvl x7, x7, #16\n"
    "ldp x23, x22, [x8, #0x0]\n"
    "ldp x21, x20, [x8, #0x10]\n"
    "ldr x14, [%x[params_struct], %[offsetof_args_outptrs]]\n"
    "ld1rh { z16.h }, p3/Z, [%x[params_struct], %[offsetof_args_min]]\n"
    "ld1rh { z19.h }, p3/Z, [%x[params_struct], %[offsetof_args_max]]\n"
    "ld1h { z7.h }, p3/Z, [x7, #-8, MUL VL]\n"
    "ld1h { z8.h }, p3/Z, [x7, #-7, MUL VL]\n"
    "addvl x7, x7, #-6\n"
    "ld1h { z9.h }, p2/Z, [x23, x16, LSL #1]\n"
    "ld1h { z10.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ld1h { z11.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ld1h { z12.h }, p2/Z, [x20, x16, LSL #1]\n"
    "bge 2f\n"
    "1:"  // Channel loop
    "movprfx z20, z17\n fmla z20.h, p3/M, z4.h, z9.h\n"
    "movprfx z26, z17\n fmla z26.h, p3/M, z8.h, z9.h\n"
    "ldr x27, [x8, #0x20]\n"
    "ldr x24, [x8, #0x30]\n"
    "movprfx z24, z17\n fmla z24.h, p3/M, z3.h, z9.h\n"
    "movprfx z30, z17\n fmla z30.h, p3/M, z1.h, z9.h\n"
    "ldr x23, [x8, #0x28]\n"
    "ldr x22, [x8, #0x38]\n"
    "movprfx z31, z17\n fmla z31.h, p3/M, z0.h, z9.h\n"
    "movprfx z22, z17\n fmla z22.h, p3/M, z7.h, z9.h\n"
    "ldr x26, [x8, #0x40]\n"
    "ldr x21, [x8, #0x48]\n"
    "movprfx z27, z17\n fmla z27.h, p3/M, z6.h, z9.h\n"
    "fmla z20.h, p3/M, z5.h, z12.h\n"
    "ldr x25, [x8, #0x50]\n"
    "ldr x20, [x8, #0x58]\n"
    "movprfx z14, z17\n fmla z14.h, p3/M, z5.h, z9.h\n"
    "movprfx z23, z17\n fmla z23.h, p3/M, z2.h, z9.h\n"
    "ld1h { z25.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x13, [x8, #0x70]\n"
    "fmla z26.h, p3/M, z0.h, z10.h\n"
    "movprfx z9, z17\n fmla z9.h, p3/M, z2.h, z11.h\n"
    "ld1h { z28.h }, p2/Z, [x27, x16, LSL #1]\n"
    "ld1h { z21.h }, p2/Z, [x23, x16, LSL #1]\n"
    "fmla z24.h, p3/M, z4.h, z12.h\n"
    "fmla z30.h, p3/M, z2.h, z12.h\n"
    "ldr x24, [x8, #0x60]\n"
    "ldr x23, [x8, #0x68]\n"
    "fmla z31.h, p3/M, z1.h, z12.h\n"
    "fmla z22.h, p3/M, z8.h, z12.h\n"
    "inch x15\n"
    "mov p1.b, p2.b\n"
    "fmla z27.h, p3/M, z7.h, z12.h\n"
    "movprfx z15, z17\n fmla z15.h, p3/M, z6.h, z28.h\n"
    "ld1h { z10.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x28, [x8, #0x88]\n"
    "fmla z20.h, p3/M, z7.h, z25.h\n"
    "fmla z9.h, p3/M, z6.h, z12.h\n"
    "ldr x12, [x14, #0x0]\n"
    "ldr x11, [x14, #0x8]\n"
    "movprfx z11, z17\n fmla z11.h, p3/M, z3.h, z12.h\n"
    "movprfx z13, z17\n fmla z13.h, p3/M, z0.h, z12.h\n"
    "ld1h { z12.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ldr x22, [x8, #0x78]\n"
    "movprfx z28, z17\n fmla z28.h, p3/M, z8.h, z21.h\n"
    "fmla z24.h, p3/M, z6.h, z25.h\n"
    "ld1h { z29.h }, p2/Z, [x26, x16, LSL #1]\n"
    "ldr x21, [x8, #0x80]\n"
    "fmla z30.h, p3/M, z4.h, z25.h\n"
    "fmla z31.h, p3/M, z3.h, z25.h\n"
    "ldr x10, [x14, #0x10]\n"
    "ldr x9, [x14, #0x18]\n"
    "movprfx z18, z17\n fmla z18.h, p3/M, z1.h, z25.h\n"
    "movprfx z21, z17\n fmla z21.h, p3/M, z0.h, z25.h\n"
    "whilelt p0.h, x17, %x[n_channels]\n"
    "ld1h { z17.h }, p3/Z, [x7]\n"
    "fmla z14.h, p3/M, z8.h, z25.h\n"
    "fmla z23.h, p3/M, z5.h, z25.h\n"
    "fmla z15.h, p3/M, z2.h, z25.h\n"
    "fmla z26.h, p3/M, z1.h, z12.h\n"
    "ld1h { z25.h }, p2/Z, [x25, x16, LSL #1]\n"
    "ldr x27, [x8, #0x90]\n"
    "fmla z22.h, p3/M, z0.h, z12.h\n"
    "fmla z27.h, p3/M, z2.h, z29.h\n"
    "ld1h { z12.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x20, [x8, #0x98]\n"
    "fmla z20.h, p3/M, z8.h, z10.h\n"
    "fmla z9.h, p3/M, z1.h, z29.h\n"
    "ld1h { z29.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x26, [x8, #0xa0]\n"
    "fmla z24.h, p3/M, z7.h, z10.h\n"
    "fmla z11.h, p3/M, z6.h, z10.h\n"
    "fmla z30.h, p3/M, z5.h, z10.h\n"
    "fmla z31.h, p3/M, z4.h, z10.h\n"
    "fmla z13.h, p3/M, z3.h, z10.h\n"
    "fmla z18.h, p3/M, z2.h, z10.h\n"
    "fmla z21.h, p3/M, z1.h, z10.h\n"
    "fmla z28.h, p3/M, z0.h, z10.h\n"
    "ld1h { z10.h }, p2/Z, [x23, x16, LSL #1]\n"
    "ldr x25, [x8, #0xa8]\n"
    "fmla z26.h, p3/M, z3.h, z25.h\n"
    "fmla z14.h, p3/M, z0.h, z25.h\n"
    "fmla z23.h, p3/M, z6.h, z29.h\n"
    "fmla z15.h, p3/M, z3.h, z29.h\n"
    "ld1h { z25.h }, p2/Z, [x13, x16, LSL #1]\n"
    "ldr x24, [x8, #0xb0]\n"
    "fmla z22.h, p3/M, z4.h, z10.h\n"
    "fmla z27.h, p3/M, z3.h, z10.h\n"
    "fmla z20.h, p3/M, z1.h, z10.h\n"
    "fmla z9.h, p3/M, z5.h, z12.h\n"
    "fmla z11.h, p3/M, z2.h, z12.h\n"
    "fmla z24.h, p3/M, z0.h, z10.h\n"
    "ld1h { z12.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ldr x23, [x8, #0xb8]\n"
    "fmla z13.h, p3/M, z8.h, z25.h\n"
    "fmla z28.h, p3/M, z5.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x22, [x8, #0xc0]\n"
    "fmla z26.h, p3/M, z5.h, z10.h\n"
    "fmla z14.h, p3/M, z2.h, z10.h\n"
    "ld1h { z29.h }, p2/Z, [x28, x16, LSL #1]\n"
    "ldr x21, [x8, #0xc8]\n"
    "fmla z22.h, p3/M, z5.h, z12.h\n"
    "fmla z27.h, p3/M, z4.h, z12.h\n"
    "fmla z20.h, p3/M, z2.h, z12.h\n"
    "fmla z9.h, p3/M, z3.h, z12.h\n"
    "fmla z24.h, p3/M, z1.h, z12.h\n"
    "fmla z11.h, p3/M, z0.h, z12.h\n"
    "ld1h { z10.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x28, [x8, #0xd8]\n"
    "fmla z15.h, p3/M, z7.h, z25.h\n"
    "fmla z18.h, p3/M, z6.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x27, x16, LSL #1]\n"
    "ldr x20, [x8, #0xd0]\n"
    "fmla z26.h, p3/M, z7.h, z29.h\n"
    "fmla z22.h, p3/M, z6.h, z29.h\n"
    "fmla z14.h, p3/M, z4.h, z29.h\n"
    "fmla z20.h, p3/M, z3.h, z29.h\n"
    "fmla z23.h, p3/M, z1.h, z29.h\n"
    "fmla z30.h, p3/M, z0.h, z29.h\n"
    "ld1h { z29.h }, p2/Z, [x26, x16, LSL #1]\n"
    "ldr x27, [x8, #0xe0]\n"
    "fmla z27.h, p3/M, z8.h, z10.h\n"
    "fmla z21.h, p3/M, z8.h, z25.h\n"
    "fmla z28.h, p3/M, z7.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x25, x16, LSL #1]\n"
    "fmla z13.h, p3/M, z1.h, z10.h\n"
    "ldr x26, [x8, #0xe8]\n"
    "fmla z9.h, p3/M, z7.h, z10.h\n"
    "fmla z24.h, p3/M, z5.h, z10.h\n"
    "fmla z11.h, p3/M, z4.h, z10.h\n"
    "fmla z31.h, p3/M, z2.h, z10.h\n"
    "ld1h { z10.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x25, [x8, #0xf0]\n"
    "fmla z26.h, p3/M, z2.h, z29.h\n"
    "fmla z22.h, p3/M, z1.h, z29.h\n"
    "fmla z27.h, p3/M, z0.h, z29.h\n"
    "fmla z14.h, p3/M, z7.h, z25.h\n"
    "ld1h { z29.h }, p2/Z, [x23, x16, LSL #1]\n"
    "ldr x24, [x8, #0xf8]\n"
    "fmla z20.h, p3/M, z6.h, z25.h\n"
    "fmla z23.h, p3/M, z4.h, z25.h\n"
    "fmla z30.h, p3/M, z3.h, z25.h\n"
    "fmla z15.h, p3/M, z1.h, z25.h\n"
    "fmla z18.h, p3/M, z0.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x22, x16, LSL #1]\n"
    "fmla z13.h, p3/M, z4.h, z25.h\n"
    "ldr x23, [x8, #0x100]\n"
    "fmla z21.h, p3/M, z2.h, z25.h\n"
    "fmla z22.h, p3/M, z2.h, z10.h\n"
    "fmla z27.h, p3/M, z1.h, z10.h\n"
    "fmla z9.h, p3/M, z0.h, z10.h\n"
    "ld1h { z12.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x22, [x8, #0x108]\n"
    "fmla z26.h, p3/M, z6.h, z29.h\n"
    "fmla z14.h, p3/M, z3.h, z29.h\n"
    "fmla z23.h, p3/M, z0.h, z29.h\n"
    "fmla z24.h, p3/M, z8.h, z25.h\n"
    "ld1h { z10.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x21, [x8, #0x110]\n"
    "fmla z11.h, p3/M, z7.h, z25.h\n"
    "fmla z31.h, p3/M, z5.h, z25.h\n"
    "fmla z28.h, p3/M, z1.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x28, x16, LSL #1]\n"
    "fmla z13.h, p3/M, z2.h, z12.h\n"
    "ldr x20, [x8, #0x118]\n"
    "fmla z15.h, p3/M, z0.h, z10.h\n"
    "fmla z18.h, p3/M, z4.h, z25.h\n"
    "fmla z21.h, p3/M, z3.h, z25.h\n"
    "fmla z9.h, p3/M, z8.h, z12.h\n"
    "fmla z11.h, p3/M, z5.h, z12.h\n"
    "fmla z14.h, p3/M, z6.h, z10.h\n"
    "ld1h { z12.h }, p2/Z, [x27, x16, LSL #1]\n"
    "fmla z23.h, p3/M, z3.h, z10.h\n"
    "ld1h { z29.h }, p2/Z, [x26, x16, LSL #1]\n"
    "fmla z30.h, p3/M, z7.h, z25.h\n"
    "fmla z31.h, p3/M, z6.h, z25.h\n"
    "fmla z15.h, p3/M, z5.h, z25.h\n"
    "fmla z13.h, p3/M, z5.h, z12.h\n"
    "fmla z28.h, p3/M, z2.h, z12.h\n"
    "fmla z18.h, p3/M, z7.h, z29.h\n"
    "fmla z21.h, p3/M, z6.h, z29.h\n"
    "fmla z23.h, p3/M, z8.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x25, x16, LSL #1]\n"
    "fmla z15.h, p3/M, z8.h, z29.h\n"
    "ld1h { z29.h }, p2/Z, [x23, x16, LSL #1]\n"
    "fmla z30.h, p3/M, z8.h, z25.h\n"
    "fmla z31.h, p3/M, z7.h, z25.h\n"
    "fmla z13.h, p3/M, z6.h, z25.h\n"
    "fmla z18.h, p3/M, z5.h, z25.h\n"
    "fmla z21.h, p3/M, z4.h, z25.h\n"
    "fmla z28.h, p3/M, z3.h, z25.h\n"
    "ld1h { z25.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ldp x27, x26, [x8, #0x0]\n"
    "fmla z11.h, p3/M, z8.h, z12.h\n"
    "ld1h { z12.h }, p2/Z, [x24, x16, LSL #1]\n"
    "fmla z26.h, p3/M, z4.h, z29.h\n"
    "fmax z26.h, p3/M, z26.h, z16.h\n"
    "fmla z22.h, p3/M, z3.h, z29.h\n"
    "fmla z27.h, p3/M, z5.h, z25.h\n"
    "fmax z22.h, p3/M, z22.h, z16.h\n"
    "fmax z27.h, p3/M, z27.h, z16.h\n"
    "fmla z9.h, p3/M, z4.h, z25.h\n"
    "fmla z18.h, p3/M, z8.h, z12.h\n"
    "fmax z9.h, p3/M, z9.h, z16.h\n"
    "fmin z26.h, p3/M, z26.h, z19.h\n"
    "fmla z21.h, p3/M, z7.h, z12.h\n"
    "fmla z28.h, p3/M, z6.h, z12.h\n"
    "ld1h { z10.h }, p2/Z, [x21, x16, LSL #1]\n"
    "fmin z22.h, p3/M, z22.h, z19.h\n"
    "fmla z14.h, p3/M, z1.h, z29.h\n"
    "fmla z20.h, p3/M, z0.h, z29.h\n"
    "ld1h { z12.h }, p2/Z, [x20, x16, LSL #1]\n"
    "fmin z27.h, p3/M, z27.h, z19.h\n"
    "fmla z24.h, p3/M, z2.h, z25.h\n"
    "fmla z11.h, p3/M, z1.h, z25.h\n"
    "fmin z9.h, p3/M, z9.h, z19.h\n"
    "fmax z14.h, p3/M, z14.h, z16.h\n"
    "fmla z23.h, p3/M, z7.h, z10.h\n"
    "fmla z30.h, p3/M, z6.h, z10.h\n"
    "fmax z20.h, p3/M, z20.h, z16.h\n"
    "fmax z24.h, p3/M, z24.h, z16.h\n"
    "fmla z31.h, p3/M, z8.h, z12.h\n"
    "fmla z13.h, p3/M, z7.h, z12.h\n"
    "fmax z11.h, p3/M, z11.h, z16.h\n"
    "st1h { z26.h }, p1, [x12, x15, LSL #1]\n"
    "st1h { z22.h }, p1, [x11, x15, LSL #1]\n"
    "ldr x23, [x14, #0x20]\n"
    "ldr x22, [x14, #0x28]\n"
    "fmla z15.h, p3/M, z4.h, z10.h\n"
    "st1h { z27.h }, p1, [x10, x15, LSL #1]\n"
    "ldr x21, [x14, #0x30]\n"
    "fmla z18.h, p3/M, z3.h, z10.h\n"
    "fmla z21.h, p3/M, z5.h, z12.h\n"
    "st1h { z9.h }, p1, [x9, x15, LSL #1]\n"
    "ldr x20, [x14, #0x38]\n"
    "fmla z28.h, p3/M, z4.h, z12.h\n"
    "ldp x25, x24, [x8, #0x10]\n"
    "fmin z14.h, p3/M, z14.h, z19.h\n"
    "fmin z20.h, p3/M, z20.h, z19.h\n"
    "st1h { z14.h }, p1, [x23, x15, LSL #1]\n"
    "ldr x23, [x14, #0x40]\n"
    "fmin z24.h, p3/M, z24.h, z19.h\n"
    "fmin z11.h, p3/M, z11.h, z19.h\n"
    "st1h { z20.h }, p1, [x22, x15, LSL #1]\n"
    "ldr x22, [x14, #0x48]\n"
    "fmax z23.h, p3/M, z23.h, z16.h\n"
    "fmax z30.h, p3/M, z30.h, z16.h\n"
    "st1h { z24.h }, p1, [x21, x15, LSL #1]\n"
    "ldr x21, [x14, #0x50]\n"
    "fmax z31.h, p3/M, z31.h, z16.h\n"
    "fmax z13.h, p3/M, z13.h, z16.h\n"
    "st1h { z11.h }, p1, [x20, x15, LSL #1]\n"
    "ldr x20, [x14, #0x58]\n"
    "inch x16\n"
    "ld1h { z9.h }, p0/Z, [x27, x17, LSL #1]\n"
    "ld1h { z10.h }, p0/Z, [x26, x17, LSL #1]\n"
    "fmin z23.h, p3/M, z23.h, z19.h\n"
    "ld1h { z11.h }, p0/Z, [x25, x17, LSL #1]\n"
    "ld1h { z12.h }, p0/Z, [x24, x17, LSL #1]\n"
    "inch x17\n"
    "fmin z30.h, p3/M, z30.h, z19.h\n"
    "fmin z31.h, p3/M, z31.h, z19.h\n"
    "fmin z13.h, p3/M, z13.h, z19.h\n"
    "st1h { z23.h }, p1, [x23, x15, LSL #1]\n"
    "ldr x23, [x14, #0x60]\n"
    "fmax z15.h, p3/M, z15.h, z16.h\n"
    "fmax z18.h, p3/M, z18.h, z16.h\n"
    "st1h { z30.h }, p1, [x22, x15, LSL #1]\n"
    "ldr x22, [x14, #0x68]\n"
    "fmax z21.h, p3/M, z21.h, z16.h\n"
    "fmax z28.h, p3/M, z28.h, z16.h\n"
    "st1h { z31.h }, p1, [x21, x15, LSL #1]\n"
    "ldr x21, [x14, #0x70]\n"
    "st1h { z13.h }, p1, [x20, x15, LSL #1]\n"
    "ldr x20, [x14, #0x78]\n"
    "ld1h { z0.h }, p3/Z, [x7, #1, MUL VL]\n"
    "whilelt p2.h, x16, %x[n_channels]\n"
    "ld1h { z1.h }, p3/Z, [x7, #2, MUL VL]\n"
    "ld1h { z2.h }, p3/Z, [x7, #3, MUL VL]\n"
    "cmp x17, %x[n_channels]\n"
    "fmin z15.h, p3/M, z15.h, z19.h\n"
    "ld1h { z3.h }, p3/Z, [x7, #4, MUL VL]\n"
    "ld1h { z4.h }, p3/Z, [x7, #5, MUL VL]\n"
    "fmin z18.h, p3/M, z18.h, z19.h\n"
    "fmin z21.h, p3/M, z21.h, z19.h\n"
    "ld1h { z5.h }, p3/Z, [x7, #6, MUL VL]\n"
    "ld1h { z6.h }, p3/Z, [x7, #7, MUL VL]\n"
    "addvl x7, x7, #16\n"
    "fmin z28.h, p3/M, z28.h, z19.h\n"
    "st1h { z15.h }, p1, [x23, x15, LSL #1]\n"
    "ld1h { z7.h }, p3/Z, [x7, #-8, MUL VL]\n"
    "ld1h { z8.h }, p3/Z, [x7, #-7, MUL VL]\n"
    "addvl x7, x7, #-6\n"
    "st1h { z18.h }, p1, [x22, x15, LSL #1]\n"
    "st1h { z21.h }, p1, [x21, x15, LSL #1]\n"
    "st1h { z28.h }, p1, [x20, x15, LSL #1]\n"
    "blt 1b\n"
    "2:"  // Channel tail
    "movprfx z14, z17\n fmla z14.h, p3/M, z4.h, z9.h\n"
    "movprfx z18, z17\n fmla z18.h, p3/M, z8.h, z9.h\n"
    "ldr x27, [x8, #0x20]\n"
    "ldr x24, [x8, #0x30]\n"
    "movprfx z15, z17\n fmla z15.h, p3/M, z3.h, z9.h\n"
    "movprfx z30, z17\n fmla z30.h, p3/M, z1.h, z9.h\n"
    "ldr x23, [x8, #0x28]\n"
    "ldr x22, [x8, #0x38]\n"
    "movprfx z20, z17\n fmla z20.h, p3/M, z0.h, z9.h\n"
    "movprfx z13, z17\n fmla z13.h, p3/M, z7.h, z9.h\n"
    "ldr x26, [x8, #0x40]\n"
    "ldr x21, [x8, #0x48]\n"
    "movprfx z22, z17\n fmla z22.h, p3/M, z6.h, z9.h\n"
    "fmla z14.h, p3/M, z5.h, z12.h\n"
    "ldr x25, [x8, #0x50]\n"
    "ldr x20, [x8, #0x58]\n"
    "movprfx z27, z17\n fmla z27.h, p3/M, z5.h, z9.h\n"
    "movprfx z31, z17\n fmla z31.h, p3/M, z2.h, z9.h\n"
    "ld1h { z23.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x13, [x8, #0x70]\n"
    "fmla z18.h, p3/M, z0.h, z10.h\n"
    "movprfx z9, z17\n fmla z9.h, p3/M, z2.h, z11.h\n"
    "ld1h { z21.h }, p2/Z, [x27, x16, LSL #1]\n"
    "ld1h { z25.h }, p2/Z, [x23, x16, LSL #1]\n"
    "fmla z15.h, p3/M, z4.h, z12.h\n"
    "fmla z30.h, p3/M, z2.h, z12.h\n"
    "ldr x24, [x8, #0x60]\n"
    "ldr x23, [x8, #0x68]\n"
    "fmla z20.h, p3/M, z1.h, z12.h\n"
    "fmla z13.h, p3/M, z8.h, z12.h\n"
    "inch x15\n"
    "mov p0.b, p2.b\n"
    "fmla z22.h, p3/M, z7.h, z12.h\n"
    "movprfx z28, z17\n fmla z28.h, p3/M, z6.h, z21.h\n"
    "ld1h { z29.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x28, [x8, #0x88]\n"
    "fmla z14.h, p3/M, z7.h, z23.h\n"
    "fmla z9.h, p3/M, z6.h, z12.h\n"
    "ldr x12, [x14, #0x0]\n"
    "ldr x11, [x14, #0x8]\n"
    "movprfx z11, z17\n fmla z11.h, p3/M, z3.h, z12.h\n"
    "movprfx z10, z17\n fmla z10.h, p3/M, z0.h, z12.h\n"
    "ld1h { z12.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ldr x22, [x8, #0x78]\n"
    "movprfx z26, z17\n fmla z26.h, p3/M, z8.h, z25.h\n"
    "fmla z15.h, p3/M, z6.h, z23.h\n"
    "ld1h { z21.h }, p2/Z, [x26, x16, LSL #1]\n"
    "ldr x21, [x8, #0x80]\n"
    "fmla z30.h, p3/M, z4.h, z23.h\n"
    "fmla z20.h, p3/M, z3.h, z23.h\n"
    "ldr x10, [x14, #0x10]\n"
    "ldr x9, [x14, #0x18]\n"
    "movprfx z25, z17\n fmla z25.h, p3/M, z1.h, z23.h\n"
    "movprfx z24, z17\n fmla z24.h, p3/M, z0.h, z23.h\n"
    "fmla z27.h, p3/M, z8.h, z23.h\n"
    "fmla z31.h, p3/M, z5.h, z23.h\n"
    "fmla z28.h, p3/M, z2.h, z23.h\n"
    "fmla z18.h, p3/M, z1.h, z12.h\n"
    "ld1h { z23.h }, p2/Z, [x25, x16, LSL #1]\n"
    "ldr x27, [x8, #0x90]\n"
    "fmla z13.h, p3/M, z0.h, z12.h\n"
    "fmla z22.h, p3/M, z2.h, z21.h\n"
    "ld1h { z12.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x20, [x8, #0x98]\n"
    "fmla z14.h, p3/M, z8.h, z29.h\n"
    "fmla z9.h, p3/M, z1.h, z21.h\n"
    "ld1h { z21.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x26, [x8, #0xa0]\n"
    "fmla z15.h, p3/M, z7.h, z29.h\n"
    "fmla z11.h, p3/M, z6.h, z29.h\n"
    "fmla z30.h, p3/M, z5.h, z29.h\n"
    "fmla z20.h, p3/M, z4.h, z29.h\n"
    "fmla z10.h, p3/M, z3.h, z29.h\n"
    "fmla z25.h, p3/M, z2.h, z29.h\n"
    "fmla z24.h, p3/M, z1.h, z29.h\n"
    "fmla z26.h, p3/M, z0.h, z29.h\n"
    "ld1h { z29.h }, p2/Z, [x23, x16, LSL #1]\n"
    "ldr x25, [x8, #0xa8]\n"
    "fmla z18.h, p3/M, z3.h, z23.h\n"
    "fmla z27.h, p3/M, z0.h, z23.h\n"
    "fmla z31.h, p3/M, z6.h, z21.h\n"
    "fmla z28.h, p3/M, z3.h, z21.h\n"
    "ld1h { z21.h }, p2/Z, [x13, x16, LSL #1]\n"
    "ldr x24, [x8, #0xb0]\n"
    "fmla z13.h, p3/M, z4.h, z29.h\n"
    "fmla z22.h, p3/M, z3.h, z29.h\n"
    "fmla z14.h, p3/M, z1.h, z29.h\n"
    "fmla z9.h, p3/M, z5.h, z12.h\n"
    "fmla z11.h, p3/M, z2.h, z12.h\n"
    "fmla z15.h, p3/M, z0.h, z29.h\n"
    "ld1h { z17.h }, p2/Z, [x22, x16, LSL #1]\n"
    "ldr x23, [x8, #0xb8]\n"
    "fmla z10.h, p3/M, z8.h, z21.h\n"
    "fmla z26.h, p3/M, z5.h, z21.h\n"
    "ld1h { z23.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x22, [x8, #0xc0]\n"
    "fmla z18.h, p3/M, z5.h, z29.h\n"
    "fmla z27.h, p3/M, z2.h, z29.h\n"
    "ld1h { z21.h }, p2/Z, [x28, x16, LSL #1]\n"
    "ldr x21, [x8, #0xc8]\n"
    "fmla z13.h, p3/M, z5.h, z17.h\n"
    "fmla z22.h, p3/M, z4.h, z17.h\n"
    "fmla z14.h, p3/M, z2.h, z17.h\n"
    "fmla z9.h, p3/M, z3.h, z17.h\n"
    "fmla z15.h, p3/M, z1.h, z17.h\n"
    "fmla z11.h, p3/M, z0.h, z17.h\n"
    "ld1h { z29.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x28, [x8, #0xd8]\n"
    "fmla z28.h, p3/M, z7.h, z23.h\n"
    "fmla z25.h, p3/M, z6.h, z23.h\n"
    "ld1h { z23.h }, p2/Z, [x27, x16, LSL #1]\n"
    "ldr x20, [x8, #0xd0]\n"
    "fmla z18.h, p3/M, z7.h, z21.h\n"
    "fmla z13.h, p3/M, z6.h, z21.h\n"
    "fmla z27.h, p3/M, z4.h, z21.h\n"
    "fmla z14.h, p3/M, z3.h, z21.h\n"
    "fmla z31.h, p3/M, z1.h, z21.h\n"
    "fmla z30.h, p3/M, z0.h, z21.h\n"
    "ld1h { z21.h }, p2/Z, [x26, x16, LSL #1]\n"
    "ldr x27, [x8, #0xe0]\n"
    "fmla z22.h, p3/M, z8.h, z29.h\n"
    "fmla z24.h, p3/M, z8.h, z23.h\n"
    "fmla z26.h, p3/M, z7.h, z23.h\n"
    "ld1h { z23.h }, p2/Z, [x25, x16, LSL #1]\n"
    "fmla z10.h, p3/M, z1.h, z29.h\n"
    "ldr x26, [x8, #0xe8]\n"
    "fmla z9.h, p3/M, z7.h, z29.h\n"
    "fmla z15.h, p3/M, z5.h, z29.h\n"
    "fmla z11.h, p3/M, z4.h, z29.h\n"
    "fmla z20.h, p3/M, z2.h, z29.h\n"
    "ld1h { z29.h }, p2/Z, [x24, x16, LSL #1]\n"
    "ldr x25, [x8, #0xf0]\n"
    "fmla z18.h, p3/M, z2.h, z21.h\n"
    "fmla z13.h, p3/M, z1.h, z21.h\n"
    "fmla z22.h, p3/M, z0.h, z21.h\n"
    "fmla z27.h, p3/M, z7.h, z23.h\n"
    "ld1h { z21.h }, p2/Z, [x23, x16, LSL #1]\n"
    "ldr x24, [x8, #0xf8]\n"
    "fmla z14.h, p3/M, z6.h, z23.h\n"
    "fmla z31.h, p3/M, z4.h, z23.h\n"
    "fmla z30.h, p3/M, z3.h, z23.h\n"
    "fmla z28.h, p3/M, z1.h, z23.h\n"
    "fmla z25.h, p3/M, z0.h, z23.h\n"
    "ld1h { z17.h }, p2/Z, [x22, x16, LSL #1]\n"
    "fmla z10.h, p3/M, z4.h, z17.h\n"
    "ldr x23, [x8, #0x100]\n"
    "fmla z24.h, p3/M, z2.h, z17.h\n"
    "fmla z13.h, p3/M, z2.h, z29.h\n"
    "fmla z22.h, p3/M, z1.h, z29.h\n"
    "fmla z9.h, p3/M, z0.h, z29.h\n"
    "ld1h { z23.h }, p2/Z, [x21, x16, LSL #1]\n"
    "ldr x22, [x8, #0x108]\n"
    "fmla z18.h, p3/M, z6.h, z21.h\n"
    "fmla z27.h, p3/M, z3.h, z21.h\n"
    "fmla z31.h, p3/M, z0.h, z21.h\n"
    "fmla z15.h, p3/M, z8.h, z17.h\n"
    "ld1h { z29.h }, p2/Z, [x20, x16, LSL #1]\n"
    "ldr x21, [x8, #0x110]\n"
    "fmla z11.h, p3/M, z7.h, z17.h\n"
    "fmla z20.h, p3/M, z5.h, z17.h\n"
    "fmla z26.h, p3/M, z1.h, z17.h\n"
    "ld1h { z21.h }, p2/Z, [x28, x16, LSL #1]\n"
    "fmla z10.h, p3/M, z2.h, z23.h\n"
    "ldr x20, [x8, #0x118]\n"
    "fmla z28.h, p3/M, z0.h, z29.h\n"
    "fmla z25.h, p3/M, z4.h, z21.h\n"
    "fmla z24.h, p3/M, z3.h, z21.h\n"
    "fmla z9.h, p3/M, z8.h, z23.h\n"
    "fmla z11.h, p3/M, z5.h, z23.h\n"
    "fmla z27.h, p3/M, z6.h, z29.h\n"
    "ld1h { z23.h }, p2/Z, [x27, x16, LSL #1]\n"
    "fmla z31.h, p3/M, z3.h, z29.h\n"
    "ld1h { z17.h }, p2/Z, [x26, x16, LSL #1]\n"
    "fmla z30.h, p3/M, z7.h, z21.h\n"
    "fmla z20.h, p3/M, z6.h, z21.h\n"
    "fmla z28.h, p3/M, z5.h, z21.h\n"
    "fmla z10.h, p3/M, z5.h, z23.h\n"
    "fmla z26.h, p3/M, z2.h, z23.h\n"
    "fmla z25.h, p3/M, z7.h, z17.h\n"
    "fmla z24.h, p3/M, z6.h, z17.h\n"
    "fmla z31.h, p3/M, z8.h, z21.h\n"
    "ld1h { z21.h }, p2/Z, [x25, x16, LSL #1]\n"
    "fmla z28.h, p3/M, z8.h, z17.h\n"
    "ld1h { z12.h }, p2/Z, [x23, x16, LSL #1]\n"
    "fmla z30.h, p3/M, z8.h, z21.h\n"
    "fmla z20.h, p3/M, z7.h, z21.h\n"
    "fmla z10.h, p3/M, z6.h, z21.h\n"
    "fmla z25.h, p3/M, z5.h, z21.h\n"
    "fmla z24.h, p3/M, z4.h, z21.h\n"
    "fmla z26.h, p3/M, z3.h, z21.h\n"
    "ld1h { z21.h }, p2/Z, [x22, x16, LSL #1]\n"
    "fmla z11.h, p3/M, z8.h, z23.h\n"
    "ld1h { z29.h }, p2/Z, [x24, x16, LSL #1]\n"
    "fmla z18.h, p3/M, z4.h, z12.h\n"
    "fmax z18.h, p3/M, z18.h, z16.h\n"
    "fmla z13.h, p3/M, z3.h, z12.h\n"
    "fmla z22.h, p3/M, z5.h, z21.h\n"
    "fmax z13.h, p3/M, z13.h, z16.h\n"
    "fmax z22.h, p3/M, z22.h, z16.h\n"
    "fmla z9.h, p3/M, z4.h, z21.h\n"
    "fmla z25.h, p3/M, z8.h, z29.h\n"
    "fmax z9.h, p3/M, z9.h, z16.h\n"
    "fmin z18.h, p3/M, z18.h, z19.h\n"
    "fmla z24.h, p3/M, z7.h, z29.h\n"
    "fmla z26.h, p3/M, z6.h, z29.h\n"
    "ld1h { z23.h }, p2/Z, [x21, x16, LSL #1]\n"
    "fmin z13.h, p3/M, z13.h, z19.h\n"
    "fmla z27.h, p3/M, z1.h, z12.h\n"
    "fmla z14.h, p3/M, z0.h, z12.h\n"
    "ld1h { z29.h }, p2/Z, [x20, x16, LSL #1]\n"
    "fmin z22.h, p3/M, z22.h, z19.h\n"
    "fmla z15.h, p3/M, z2.h, z21.h\n"
    "fmla z11.h, p3/M, z1.h, z21.h\n"
    "fmin z9.h, p3/M, z9.h, z19.h\n"
    "fmax z27.h, p3/M, z27.h, z16.h\n"
    "fmla z31.h, p3/M, z7.h, z23.h\n"
    "fmla z30.h, p3/M, z6.h, z23.h\n"
    "fmax z14.h, p3/M, z14.h, z16.h\n"
    "fmax z15.h, p3/M, z15.h, z16.h\n"
    "fmla z20.h, p3/M, z8.h, z29.h\n"
    "fmla z10.h, p3/M, z7.h, z29.h\n"
    "fmax z11.h, p3/M, z11.h, z16.h\n"
    "st1h { z18.h }, p0, [x12, x15, LSL #1]\n"
    "st1h { z13.h }, p0, [x11, x15, LSL #1]\n"
    "ldr x23, [x14, #0x20]\n"
    "ldr x22, [x14, #0x28]\n"
    "fmla z28.h, p3/M, z4.h, z23.h\n"
    "st1h { z22.h }, p0, [x10, x15, LSL #1]\n"
    "ldr x21, [x14, #0x30]\n"
    "fmla z25.h, p3/M, z3.h, z23.h\n"
    "fmla z24.h, p3/M, z5.h, z29.h\n"
    "st1h { z9.h }, p0, [x9, x15, LSL #1]\n"
    "ldr x20, [x14, #0x38]\n"
    "fmla z26.h, p3/M, z4.h, z29.h\n"
    "fmin z27.h, p3/M, z27.h, z19.h\n"
    "fmin z14.h, p3/M, z14.h, z19.h\n"
    "fmin z15.h, p3/M, z15.h, z19.h\n"
    "st1h { z27.h }, p0, [x23, x15, LSL #1]\n"
    "ldr x23, [x14, #0x40]\n"
    "fmin z11.h, p3/M, z11.h, z19.h\n"
    "fmax z31.h, p3/M, z31.h, z16.h\n"
    "st1h { z14.h }, p0, [x22, x15, LSL #1]\n"
    "ldr x22, [x14, #0x48]\n"
    "fmax z30.h, p3/M, z30.h, z16.h\n"
    "fmax z20.h, p3/M, z20.h, z16.h\n"
    "st1h { z15.h }, p0, [x21, x15, LSL #1]\n"
    "ldr x21, [x14, #0x50]\n"
    "fmax z10.h, p3/M, z10.h, z16.h\n"
    "st1h { z11.h }, p0, [x20, x15, LSL #1]\n"
    "ldr x20, [x14, #0x58]\n"
    "fmin z31.h, p3/M, z31.h, z19.h\n"
    "fmin z30.h, p3/M, z30.h, z19.h\n"
    "fmin z20.h, p3/M, z20.h, z19.h\n"
    "st1h { z31.h }, p0, [x23, x15, LSL #1]\n"
    "ldr x23, [x14, #0x60]\n"
    "fmin z10.h, p3/M, z10.h, z19.h\n"
    "fmax z28.h, p3/M, z28.h, z16.h\n"
    "st1h { z30.h }, p0, [x22, x15, LSL #1]\n"
    "ldr x22, [x14, #0x68]\n"
    "fmax z25.h, p3/M, z25.h, z16.h\n"
    "fmax z24.h, p3/M, z24.h, z16.h\n"
    "st1h { z20.h }, p0, [x21, x15, LSL #1]\n"
    "ldr x21, [x14, #0x70]\n"
    "fmax z26.h, p3/M, z26.h, z16.h\n"
    "st1h { z10.h }, p0, [x20, x15, LSL #1]\n"
    "ldr x20, [x14, #0x78]\n"
    "fmin z28.h, p3/M, z28.h, z19.h\n"
    "fmin z25.h, p3/M, z25.h, z19.h\n"
    "fmin z24.h, p3/M, z24.h, z19.h\n"
    "st1h { z28.h }, p0, [x23, x15, LSL #1]\n"
    "fmin z26.h, p3/M, z26.h, z19.h\n"
    "st1h { z25.h }, p0, [x22, x15, LSL #1]\n"
    "st1h { z24.h }, p0, [x21, x15, LSL #1]\n"
    "st1h { z26.h }, p0, [x20, x15, LSL #1]\n"
    :
    : [n_channels] "r" ((unsigned long) n_channels), [offsetof_Args_inptrs] "I" (offsetof(Args, inptrs)), [offsetof_args_max] "I" (offsetof(Args, max)), [offsetof_args_min] "I" (offsetof(Args, min)), [offsetof_args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_args_params] "I" (offsetof(Args, params)), [params_struct] "r" (&params_struct)
    : "cc", "memory", "p0", "p1", "p2", "p3", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SVE) && defined(__ARM_FP16_ARGS) && defined(__ARM_FEATURE_FP16_VECTOR_ARITHMETIC)
