/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import org.cojen.classfile.Descriptor;
import org.cojen.util.Cache;
import org.cojen.util.SoftValueCache;
import org.cojen.util.WeakCanonicalSet;
import org.cojen.util.WeakIdentityCache;

public abstract class TypeDesc
extends Descriptor
implements Serializable {
    public static final int OBJECT_CODE = 0;
    public static final int VOID_CODE = 1;
    public static final int BOOLEAN_CODE = 4;
    public static final int CHAR_CODE = 5;
    public static final int FLOAT_CODE = 6;
    public static final int DOUBLE_CODE = 7;
    public static final int BYTE_CODE = 8;
    public static final int SHORT_CODE = 9;
    public static final int INT_CODE = 10;
    public static final int LONG_CODE = 11;
    public static final TypeDesc VOID;
    public static final TypeDesc BOOLEAN;
    public static final TypeDesc CHAR;
    public static final TypeDesc BYTE;
    public static final TypeDesc SHORT;
    public static final TypeDesc INT;
    public static final TypeDesc LONG;
    public static final TypeDesc FLOAT;
    public static final TypeDesc DOUBLE;
    public static final TypeDesc OBJECT;
    public static final TypeDesc STRING;
    static final WeakCanonicalSet<Descriptor> cInstances;
    private static final Cache<Class, TypeDesc> cClassesToInstances;
    private static final Cache<String, TypeDesc> cNamesToInstances;
    private static final Cache<String, TypeDesc> cDescriptorsToInstances;
    final transient String mDescriptor;

    static TypeDesc intern(TypeDesc type) {
        return cInstances.put(type);
    }

    public static TypeDesc forClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        TypeDesc type = cClassesToInstances.get(clazz);
        if (type == null || type.toClass() != clazz) {
            TypeDesc existing;
            if (clazz.isArray()) {
                type = TypeDesc.forClass(clazz.getComponentType()).toArrayType();
            } else if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    type = INT;
                } else if (clazz == Boolean.TYPE) {
                    type = BOOLEAN;
                } else if (clazz == Character.TYPE) {
                    type = CHAR;
                } else if (clazz == Byte.TYPE) {
                    type = BYTE;
                } else if (clazz == Long.TYPE) {
                    type = LONG;
                } else if (clazz == Float.TYPE) {
                    type = FLOAT;
                } else if (clazz == Double.TYPE) {
                    type = DOUBLE;
                } else if (clazz == Short.TYPE) {
                    type = SHORT;
                } else if (clazz == Void.TYPE) {
                    type = VOID;
                }
            } else {
                String name = clazz.getName();
                type = TypeDesc.intern(new ObjectType(TypeDesc.generateDescriptor(name), name));
            }
            if (type.toClass() != clazz) {
                type = new ObjectType(type.getDescriptor(), clazz.getName());
                ((ObjectType)type).setClass(clazz);
            }
            if ((existing = cClassesToInstances.putIfAbsent(clazz, type)) != null) {
                type = existing;
            }
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeDesc forClass(String name) throws IllegalArgumentException {
        TypeDesc type;
        block19: {
            if (name.length() < 1) {
                throw TypeDesc.invalidName(name);
            }
            type = cNamesToInstances.get(name);
            if (type != null) {
                return type;
            }
            int index1 = name.lastIndexOf(91);
            int index2 = name.lastIndexOf(93);
            if (index2 >= 0) {
                if (index2 + 1 != name.length() || index1 + 1 != index2) {
                    throw TypeDesc.invalidName(name);
                }
                try {
                    type = TypeDesc.forClass(name.substring(0, index1)).toArrayType();
                }
                catch (IllegalArgumentException e) {
                    throw TypeDesc.invalidName(name);
                }
            }
            if (index1 >= 0) {
                throw TypeDesc.invalidName(name);
            }
            switch (name.charAt(0)) {
                case 'v': {
                    if (!name.equals("void")) break;
                    type = VOID;
                    break block19;
                }
                case 'b': {
                    if (name.equals("boolean")) {
                        type = BOOLEAN;
                        break block19;
                    } else {
                        if (!name.equals("byte")) break;
                        type = BYTE;
                    }
                    break block19;
                }
                case 'c': {
                    if (!name.equals("char")) break;
                    type = CHAR;
                    break block19;
                }
                case 's': {
                    if (!name.equals("short")) break;
                    type = SHORT;
                    break block19;
                }
                case 'i': {
                    if (!name.equals("int")) break;
                    type = INT;
                    break block19;
                }
                case 'l': {
                    if (!name.equals("long")) break;
                    type = LONG;
                    break block19;
                }
                case 'f': {
                    if (!name.equals("float")) break;
                    type = FLOAT;
                    break block19;
                }
                case 'd': {
                    if (!name.equals("double")) break;
                    type = DOUBLE;
                    break block19;
                }
            }
            String desc = TypeDesc.generateDescriptor(name);
            type = name.indexOf(47) < 0 ? new ObjectType(desc, name) : new ObjectType(desc, name.replace('/', '.'));
            type = TypeDesc.intern(type);
        }
        cNamesToInstances.put(name, type);
        return type;
    }

    private static IllegalArgumentException invalidName(String name) {
        return new IllegalArgumentException("Invalid name: " + name);
    }

    public static TypeDesc forDescriptor(String desc) throws IllegalArgumentException {
        TypeDesc type = cDescriptorsToInstances.get(desc);
        if (type != null) {
            return type;
        }
        String rootDesc = desc;
        int cursor = 0;
        int dim = 0;
        try {
            char c;
            while ((c = rootDesc.charAt(cursor++)) == '[') {
                ++dim;
            }
            switch (c) {
                case 'V': {
                    type = VOID;
                    break;
                }
                case 'Z': {
                    type = BOOLEAN;
                    break;
                }
                case 'C': {
                    type = CHAR;
                    break;
                }
                case 'B': {
                    type = BYTE;
                    break;
                }
                case 'S': {
                    type = SHORT;
                    break;
                }
                case 'I': {
                    type = INT;
                    break;
                }
                case 'J': {
                    type = LONG;
                    break;
                }
                case 'F': {
                    type = FLOAT;
                    break;
                }
                case 'D': {
                    type = DOUBLE;
                    break;
                }
                case 'L': {
                    if (dim > 0) {
                        rootDesc = rootDesc.substring(dim);
                        cursor = 1;
                    }
                    StringBuffer name = new StringBuffer(rootDesc.length() - 2);
                    while ((c = rootDesc.charAt(cursor++)) != ';') {
                        if (c == '/') {
                            c = '.';
                        }
                        name.append(c);
                    }
                    type = TypeDesc.intern(new ObjectType(rootDesc, name.toString()));
                    break;
                }
                default: {
                    throw TypeDesc.invalidDescriptor(desc);
                }
            }
        }
        catch (NullPointerException e) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        catch (IndexOutOfBoundsException e) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        if (cursor != rootDesc.length()) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        while (--dim >= 0) {
            type = type.toArrayType();
        }
        cDescriptorsToInstances.put(desc, type);
        return type;
    }

    private static IllegalArgumentException invalidDescriptor(String desc) {
        return new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    private static String generateDescriptor(String classname) {
        int length = classname.length();
        char[] buf = new char[length + 2];
        buf[0] = 76;
        classname.getChars(0, length, buf, 1);
        for (int i = 1; i <= length; ++i) {
            char c = buf[i];
            if (c != '.') continue;
            buf[i] = 47;
        }
        buf[i] = 59;
        return new String(buf);
    }

    TypeDesc(String desc) {
        this.mDescriptor = desc;
    }

    public final String getDescriptor() {
        return this.mDescriptor;
    }

    public abstract String getRootName();

    public abstract String getFullName();

    public abstract int getTypeCode();

    public abstract boolean isPrimitive();

    public abstract boolean isDoubleWord();

    public abstract boolean isArray();

    public abstract int getDimensions();

    public abstract TypeDesc getComponentType();

    public abstract TypeDesc getRootComponentType();

    public abstract TypeDesc toArrayType();

    public abstract TypeDesc toObjectType();

    public abstract TypeDesc toPrimitiveType();

    public abstract Class toClass();

    public abstract Class toClass(ClassLoader var1);

    public String toString() {
        return this.mDescriptor;
    }

    public int hashCode() {
        return this.mDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TypeDesc) {
            return ((TypeDesc)other).mDescriptor.equals(this.mDescriptor);
        }
        return false;
    }

    Object writeReplace() throws ObjectStreamException {
        return new External(this.mDescriptor);
    }

    static {
        cInstances = new WeakCanonicalSet();
        cClassesToInstances = new WeakIdentityCache<Class, TypeDesc>(17);
        cNamesToInstances = new SoftValueCache<String, TypeDesc>(17);
        cDescriptorsToInstances = new SoftValueCache<String, TypeDesc>(17);
        VOID = TypeDesc.intern(new PrimitiveType("V", 1));
        BOOLEAN = TypeDesc.intern(new PrimitiveType("Z", 4));
        CHAR = TypeDesc.intern(new PrimitiveType("C", 5));
        BYTE = TypeDesc.intern(new PrimitiveType("B", 8));
        SHORT = TypeDesc.intern(new PrimitiveType("S", 9));
        INT = TypeDesc.intern(new PrimitiveType("I", 10));
        LONG = TypeDesc.intern(new PrimitiveType("J", 11));
        FLOAT = TypeDesc.intern(new PrimitiveType("F", 6));
        DOUBLE = TypeDesc.intern(new PrimitiveType("D", 7));
        OBJECT = TypeDesc.forClass("java.lang.Object");
        STRING = TypeDesc.forClass("java.lang.String");
    }

    private static class External
    implements Externalizable {
        private String mDescriptor;

        public External() {
        }

        public External(String desc) {
            this.mDescriptor = desc;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mDescriptor);
        }

        public void readExternal(ObjectInput in) throws IOException {
            this.mDescriptor = in.readUTF();
        }

        public Object readResolve() throws ObjectStreamException {
            return TypeDesc.forDescriptor(this.mDescriptor);
        }
    }

    private static class ArrayType
    extends ObjectType {
        private final transient TypeDesc mComponent;
        private final transient String mFullName;

        ArrayType(String desc, TypeDesc component) {
            super(desc, component.getRootName());
            this.mComponent = component;
            this.mFullName = component.getFullName().concat("[]");
        }

        public String getFullName() {
            return this.mFullName;
        }

        public boolean isArray() {
            return true;
        }

        public int getDimensions() {
            return this.mComponent.getDimensions() + 1;
        }

        public TypeDesc getComponentType() {
            return this.mComponent;
        }

        public TypeDesc getRootComponentType() {
            TypeDesc type = this.mComponent;
            while (type.isArray()) {
                type = type.getComponentType();
            }
            return type;
        }

        public TypeDesc toPrimitiveType() {
            return null;
        }

        public Class toClass(ClassLoader loader) {
            if (loader == null) {
                return this.arrayClass(this.getRootComponentType().toClass());
            }
            return this.arrayClass(this.getRootComponentType().toClass(loader));
        }

        private Class arrayClass(Class clazz) {
            if (clazz == null) {
                return null;
            }
            int dim = this.getDimensions();
            try {
                if (dim == 1) {
                    return Array.newInstance(clazz, 0).getClass();
                }
                return Array.newInstance(clazz, new int[dim]).getClass();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    private static class ObjectType
    extends TypeDesc {
        private final transient String mName;
        private transient TypeDesc mArrayType;
        private transient TypeDesc mPrimitiveType;
        private volatile transient SoftReference<Class> mClassRef;

        ObjectType(String desc, String name) {
            super(desc);
            this.mName = name;
        }

        public String getRootName() {
            return this.mName;
        }

        public String getFullName() {
            return this.mName;
        }

        public int getTypeCode() {
            return 0;
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isDoubleWord() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public int getDimensions() {
            return 0;
        }

        public TypeDesc getComponentType() {
            return null;
        }

        public TypeDesc getRootComponentType() {
            return null;
        }

        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                int length = this.mDescriptor.length();
                char[] buf = new char[length + 1];
                buf[0] = 91;
                this.mDescriptor.getChars(0, length, buf, 1);
                this.mArrayType = ObjectType.intern(new ArrayType(new String(buf), this));
            }
            return this.mArrayType;
        }

        public TypeDesc toObjectType() {
            return this;
        }

        public TypeDesc toPrimitiveType() {
            String name;
            if (this.mPrimitiveType == null && (name = this.mName).startsWith("java.lang.") && name.length() > 10) {
                switch (name.charAt(10)) {
                    case 'V': {
                        if (!name.equals("java.lang.Void")) break;
                        this.mPrimitiveType = VOID;
                        break;
                    }
                    case 'B': {
                        if (name.equals("java.lang.Boolean")) {
                            this.mPrimitiveType = BOOLEAN;
                            break;
                        }
                        if (!name.equals("java.lang.Byte")) break;
                        this.mPrimitiveType = BYTE;
                        break;
                    }
                    case 'C': {
                        if (!name.equals("java.lang.Character")) break;
                        this.mPrimitiveType = CHAR;
                        break;
                    }
                    case 'S': {
                        if (!name.equals("java.lang.Short")) break;
                        this.mPrimitiveType = SHORT;
                        break;
                    }
                    case 'I': {
                        if (!name.equals("java.lang.Integer")) break;
                        this.mPrimitiveType = INT;
                        break;
                    }
                    case 'L': {
                        if (!name.equals("java.lang.Long")) break;
                        this.mPrimitiveType = LONG;
                        break;
                    }
                    case 'F': {
                        if (!name.equals("java.lang.Float")) break;
                        this.mPrimitiveType = FLOAT;
                        break;
                    }
                    case 'D': {
                        if (!name.equals("java.lang.Double")) break;
                        this.mPrimitiveType = DOUBLE;
                    }
                }
            }
            return this.mPrimitiveType;
        }

        public final synchronized Class toClass() {
            Class clazz;
            if (this.mClassRef != null && (clazz = this.mClassRef.get()) != null) {
                return clazz;
            }
            clazz = this.toClass(null);
            this.mClassRef = new SoftReference<Class>(clazz);
            return clazz;
        }

        public Class toClass(ClassLoader loader) {
            TypeDesc type = this.toPrimitiveType();
            if (type != null) {
                switch (type.getTypeCode()) {
                    default: {
                        return Void.class;
                    }
                    case 4: {
                        return Boolean.class;
                    }
                    case 5: {
                        return Character.class;
                    }
                    case 6: {
                        return Float.class;
                    }
                    case 7: {
                        return Double.class;
                    }
                    case 8: {
                        return Byte.class;
                    }
                    case 9: {
                        return Short.class;
                    }
                    case 10: {
                        return Integer.class;
                    }
                    case 11: 
                }
                return Long.class;
            }
            try {
                if (loader == null) {
                    return Class.forName(this.mName);
                }
                return loader.loadClass(this.mName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        void setClass(Class clazz) {
            this.mClassRef = new SoftReference<Class>(clazz);
        }
    }

    private static class PrimitiveType
    extends TypeDesc {
        private final transient int mCode;
        private transient TypeDesc mArrayType;
        private transient TypeDesc mObjectType;

        PrimitiveType(String desc, int code) {
            super(desc);
            this.mCode = code;
        }

        public String getRootName() {
            switch (this.mCode) {
                default: {
                    return "void";
                }
                case 4: {
                    return "boolean";
                }
                case 5: {
                    return "char";
                }
                case 8: {
                    return "byte";
                }
                case 9: {
                    return "short";
                }
                case 10: {
                    return "int";
                }
                case 11: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: 
            }
            return "double";
        }

        public String getFullName() {
            return this.getRootName();
        }

        public int getTypeCode() {
            return this.mCode;
        }

        public boolean isPrimitive() {
            return true;
        }

        public boolean isDoubleWord() {
            return this.mCode == 7 || this.mCode == 11;
        }

        public boolean isArray() {
            return false;
        }

        public int getDimensions() {
            return 0;
        }

        public TypeDesc getComponentType() {
            return null;
        }

        public TypeDesc getRootComponentType() {
            return null;
        }

        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                char[] buf = new char[]{'[', this.mDescriptor.charAt(0)};
                this.mArrayType = PrimitiveType.intern(new ArrayType(new String(buf), this));
            }
            return this.mArrayType;
        }

        public TypeDesc toObjectType() {
            if (this.mObjectType == null) {
                switch (this.mCode) {
                    default: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Void");
                        break;
                    }
                    case 4: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Boolean");
                        break;
                    }
                    case 5: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Character");
                        break;
                    }
                    case 8: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Byte");
                        break;
                    }
                    case 9: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Short");
                        break;
                    }
                    case 10: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Integer");
                        break;
                    }
                    case 11: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Long");
                        break;
                    }
                    case 6: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Float");
                        break;
                    }
                    case 7: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Double");
                    }
                }
            }
            return this.mObjectType;
        }

        public TypeDesc toPrimitiveType() {
            return this;
        }

        public Class toClass() {
            switch (this.mCode) {
                default: {
                    return Void.TYPE;
                }
                case 4: {
                    return Boolean.TYPE;
                }
                case 5: {
                    return Character.TYPE;
                }
                case 8: {
                    return Byte.TYPE;
                }
                case 9: {
                    return Short.TYPE;
                }
                case 10: {
                    return Integer.TYPE;
                }
                case 11: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: 
            }
            return Double.TYPE;
        }

        public Class toClass(ClassLoader loader) {
            return this.toClass();
        }
    }
}

