/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.javancss;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.cobertura.javancss.FileUtil;
import net.sourceforge.cobertura.javancss.JavaParser;
import net.sourceforge.cobertura.javancss.ParseException;
import net.sourceforge.cobertura.javancss.TokenMgrError;
import net.sourceforge.cobertura.javancss.Util;

public class Javancss {
    private JavaParser _pJavaParser = null;
    private Vector _vJavaSourceFiles = new Vector();
    private String _sErrorMessage = null;
    private Vector _vMethodComplexities = new Vector();
    private Hashtable _htProcessedAtFiles = new Hashtable();

    public Javancss(String sJavaSourceFile_) {
        this._vJavaSourceFiles = new Vector();
        this._vJavaSourceFiles.addElement(sJavaSourceFile_);
        try {
            this._measureFiles(this._vJavaSourceFiles);
        }
        catch (Exception e) {
            System.out.println("Javancss.<init>(String).e: " + e);
        }
        catch (TokenMgrError pError) {
            System.out.println("Javancss.<init>(String).pError: " + pError);
        }
    }

    private void _measureFiles(Vector vJavaSourceFiles_) throws IOException, ParseException, TokenMgrError {
        Enumeration e = vJavaSourceFiles_.elements();
        while (e.hasMoreElements()) {
            String sJavaFileName = (String)e.nextElement();
            if (sJavaFileName.charAt(0) == '@') {
                if (sJavaFileName.length() <= 1) continue;
                String sFileName = sJavaFileName.substring(1);
                if (this._htProcessedAtFiles.get(sFileName = FileUtil.normalizeFileName(sFileName)) != null) continue;
                this._htProcessedAtFiles.put(sFileName, sFileName);
                String sJavaSourceFileNames = null;
                try {
                    sJavaSourceFileNames = FileUtil.readFile(sFileName);
                }
                catch (IOException pIOException) {
                    this._sErrorMessage = "File Read Error: " + sFileName;
                    throw pIOException;
                }
                Vector vTheseJavaSourceFiles = Util.stringToLines(sJavaSourceFileNames);
                this._measureFiles(vTheseJavaSourceFiles);
                continue;
            }
            try {
                this._measureSource(sJavaFileName);
            }
            catch (Throwable pThrowable) {
                // empty catch block
            }
        }
    }

    private void _measureSource(String sSourceFileName_) throws IOException, ParseException, TokenMgrError {
        sSourceFileName_ = FileUtil.normalizeFileName(sSourceFileName_);
        DataInputStream disSource = null;
        try {
            disSource = new DataInputStream(new FileInputStream(sSourceFileName_));
        }
        catch (IOException pIOException) {
            this._sErrorMessage = this._sErrorMessage == null ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFileName_;
            throw pIOException;
        }
        String sTempErrorMessage = this._sErrorMessage;
        try {
            this._measureSource(disSource);
        }
        catch (ParseException pParseException) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            sTempErrorMessage = sTempErrorMessage + "ParseException in " + sSourceFileName_ + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + pParseException.getMessage() + "\n";
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + "TokenMgrError in " + sSourceFileName_ + "\n" + pTokenMgrError.getMessage() + "\n";
            throw pTokenMgrError;
        }
    }

    private void _measureSource(DataInputStream disSource_) throws ParseException, TokenMgrError {
        try {
            this._pJavaParser = new JavaParser(disSource_);
            this._pJavaParser.compilationUnit();
            this._vMethodComplexities.addAll(this._pJavaParser.getMethodComplexities());
        }
        catch (ParseException pParseException) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            throw pTokenMgrError;
        }
    }

    public Vector getMethodComplexities() {
        return this._vMethodComplexities;
    }
}

