/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.util.ArrayList;
import net.sf.jiapi.reflect.Signature;

class TypeHelper {
    TypeHelper() {
    }

    static String typeToDescriptor(String typeName) {
        int idx = typeName.indexOf(91);
        String type = null;
        type = idx == -1 ? typeName : typeName.substring(0, idx).trim();
        StringBuffer dBuf = new StringBuffer();
        if (idx > 0) {
            for (int i = idx; i < typeName.length(); ++i) {
                if (typeName.charAt(i) != '[') continue;
                dBuf.append('[');
            }
        }
        if ("byte".equals(type)) {
            dBuf.append("B");
        } else if ("char".equals(type)) {
            dBuf.append("C");
        } else if ("double".equals(type)) {
            dBuf.append("D");
        } else if ("float".equals(type)) {
            dBuf.append("F");
        } else if ("int".equals(type)) {
            dBuf.append("I");
        } else if ("long".equals(type)) {
            dBuf.append("J");
        } else if ("short".equals(type)) {
            dBuf.append("S");
        } else if ("boolean".equals(type)) {
            dBuf.append("Z");
        } else if ("void".equals(type)) {
            dBuf.append("V");
        } else {
            dBuf.append('L');
            dBuf.append(type.replace('.', '/'));
            dBuf.append(';');
        }
        return dBuf.toString();
    }

    static String descriptorToType(String descriptor) {
        StringBuffer typeBuf = new StringBuffer();
        int i = 0;
        while (descriptor.charAt(i) == '[') {
            typeBuf.append("[]");
            ++i;
        }
        if (descriptor.charAt(i) == 'L') {
            String type = descriptor.substring(i + 1, descriptor.length() - 1);
            typeBuf.insert(0, type.replace('/', '.'));
        } else if ("B".equals(descriptor)) {
            typeBuf.insert(0, "byte");
        } else if ("C".equals(descriptor)) {
            typeBuf.insert(0, "char");
        } else if ("D".equals(descriptor)) {
            typeBuf.insert(0, "double");
        } else if ("F".equals(descriptor)) {
            typeBuf.insert(0, "float");
        } else if ("I".equals(descriptor)) {
            typeBuf.insert(0, "int");
        } else if ("J".equals(descriptor)) {
            typeBuf.insert(0, "long");
        } else if ("S".equals(descriptor)) {
            typeBuf.insert(0, "short");
        } else if ("Z".equals(descriptor)) {
            typeBuf.insert(0, "boolean");
        } else if ("V".equals(descriptor)) {
            return "void";
        }
        return typeBuf.toString();
    }

    static String[] descriptorsToTypes(String pDesc) {
        ArrayList<String> al = new ArrayList<String>();
        try {
            for (int i = 0; i < pDesc.length(); ++i) {
                StringBuffer typeBuf = new StringBuffer();
                while (pDesc.charAt(i) == '[') {
                    typeBuf.append("[]");
                    ++i;
                }
                if (pDesc.charAt(i) != 'L') {
                    String type = TypeHelper.descriptorToType("" + pDesc.charAt(i));
                    typeBuf.insert(0, type);
                    al.add(typeBuf.toString());
                    continue;
                }
                int start = i;
                while (pDesc.charAt(i) != ';') {
                    ++i;
                }
                String desc = pDesc.substring(start, i + 1);
                String typeName = TypeHelper.descriptorToType(desc);
                typeBuf.insert(0, typeName);
                al.add(typeBuf.toString());
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal descriptor: " + pDesc);
        }
        return al.toArray(new String[0]);
    }

    static String[] splitDescriptors(String pDesc) {
        ArrayList<String> al = new ArrayList<String>();
        String arrayPrefix = "";
        block5: for (int i = 0; i < pDesc.length(); ++i) {
            switch (pDesc.charAt(i)) {
                case '[': {
                    arrayPrefix = "[";
                    continue block5;
                }
                case 'L': {
                    int idx = pDesc.indexOf(59, i);
                    al.add(arrayPrefix + pDesc.substring(i, idx + 1));
                    arrayPrefix = "";
                    i = idx;
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    al.add(arrayPrefix + pDesc.charAt(i));
                    arrayPrefix = "";
                    continue block5;
                }
                default: {
                    System.out.println("**** Invalid descriptor " + pDesc.charAt(i));
                }
            }
        }
        return al.toArray(new String[0]);
    }

    static String signatureToDescriptor(Signature signature) {
        StringBuffer desc = new StringBuffer("(");
        String[] typeNames = signature.getParameters();
        for (int i = 0; i < typeNames.length; ++i) {
            desc.append(TypeHelper.typeToDescriptor(typeNames[i]));
        }
        desc.append(")");
        desc.append(TypeHelper.typeToDescriptor(signature.getReturnType()));
        return desc.toString();
    }
}

