/*
 *  player.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PLAYER_H
#define PLAYER_H

#include <gio/gio.h>
#include "ap_config.h"
#include "playlist.h"
#include "stream.h"
#include "log.h"

GstElement      *videofakesink;
GstElement      *audiofakesink;
GstElement      *pipeline;
void            (*done_playing_callback)();
Stream          **currentstream;
Stream          *current_stream;

static void     player_begin                  (Stream* stream);
void            player_set_position           (StartPlayingPosition position);
void            player_seek                   (gint64 seekposition);
void            player_init (void *callback_when_done, void *bus_call_dispatcher);
gboolean        player_get_ready              ();
void            player_clear_pipeline         ();
void            play_next                     ();
gboolean        player_pause                  ();
static void     player_start_playing          ();
gboolean        bus_call    (GstBus *bus, GstMessage *msg, gpointer user_data);
gboolean        player_update_stream_duration (Stream *stream);
gboolean        player_update_stream_position (Stream *stream);
gboolean        player_update_stream          ();

#endif /* PLAYER_H */
