//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_28.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot28(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[28] = {2.183595942166431e-02,1.966250167560543e-01,5.467457595545777e-01,1.073292764692550e+00,1.777931588693515e+00,
    2.662928318424790e+00,3.731190935013963e+00,4.986324374557585e+00,6.432701921917825e+00,8.075556568667009e+00,9.921097319421310e+00,1.197665731809708e+01,
    1.425088335946147e+01,1.675398028533747e+01,1.949802964803647e+01,2.249741105007468e+01,2.576936881615252e+01,2.933478986909120e+01,3.321929791927003e+01,
    3.745483826846005e+01,4.208205580020668e+01,4.715402124877787e+01,5.274239597000209e+01,5.894836984291936e+01,6.592397447421155e+01,7.391951917335301e+01,
    8.341342556883905e+01,9.563475086058828e+01};
  constexpr double aw[28] = {2.891750843351486e-01,2.429892709927226e-01,1.714772476212722e-01,1.015193927179864e-01,5.033839742481598e-02,
    2.085857414015774e-02,7.202052232041110e-03,2.064747563603152e-03,4.893729356570477e-04,9.539599104777372e-05,1.520108149228440e-05,1.965753400400977e-06,
    2.045446453646060e-07,1.695432425599157e-08,1.106200697688220e-09,5.601397850468629e-11,2.164192588501250e-12,6.250445629752320e-14,1.315856125139690e-15,
    1.956926178564817e-17,1.975666811539116e-19,1.285536389704850e-21,5.027099918729589e-24,1.070671358964358e-26,1.071799388321034e-29,3.962154089895823e-33,
    3.424984084388311e-37,2.183947379620196e-42};
  constexpr double x[10752] = {  1.518553016346517e-03, -1.331071149913149e-05,  8.743823026424275e-08, -5.100588626113865e-10,  2.785859311137760e-12,
 -1.458524788327101e-14,  7.410643243900884e-17, -3.680884936098844e-19,  1.795512479434817e-21, -8.627461794042155e-24,  4.091868769500638e-26, -1.918268041937369e-28,
  1.364025762318776e-02, -1.188495251864893e-04,  7.713817599846461e-07, -4.409510618774793e-09,  2.335234869225965e-11, -1.169746622915920e-13,  5.592103287385049e-16,
 -2.558692505794175e-18,  1.118624332370740e-20, -4.642361829523618e-23,  1.803225506106816e-25, -6.362318124332815e-28,  3.774145682550425e-02, -3.249248432530768e-04,
  2.058090900683745e-06, -1.128225817034027e-08,  5.592212978265045e-11, -2.532233724664090e-13,  1.037649205109255e-15, -3.710842960587108e-18,  1.034183521117329e-20,
 -1.099692195521645e-23, -1.254799576119074e-25,  1.323425436229062e-27,  7.353914171437918e-02, -6.217590168097132e-04,  3.793760275133746e-06, -1.945696845544786e-08,
  8.611800305194697e-11, -3.196931602986037e-13,  8.706484789240829e-16, -4.907492978721645e-19, -1.457102897258095e-20,  1.315111570350456e-22, -7.681572917809755e-25,
  3.408653490217152e-27,  1.206123236713153e-01, -9.952437761433807e-04,  5.768204008038805e-06, -2.684587347399448e-08,  9.843642806017801e-11, -2.298727396341293e-13,
 -2.494635822783863e-16,  6.873323574434909e-18, -4.820727768005054e-20,  2.207823795343734e-22, -5.973874873274241e-25, -7.087936488029099e-28,  1.784062551325185e-01,
 -1.427584525668206e-03,  7.737169593557145e-06, -3.136064918184274e-08,  8.148035837445969e-11,  3.774485439019948e-14, -1.989239120540161e-15,  1.357284622428077e-17,
 -5.254501803334201e-20,  5.358447614123536e-23,  9.640885626424982e-25, -8.908533805100134e-27,  2.462380411427396e-01, -1.898117629272659e-03,  9.448464116239654e-06,
 -3.133805641495791e-08,  3.215627263469628e-11,  4.181884872916446e-13, -3.447748980009994e-15,  1.314265970835158e-17, -2.685304189628405e-21, -3.303197050507503e-22,
  2.417652385965745e-24, -8.016502186028352e-27,  3.233036253938489e-01, -2.384266500256764e-03,  1.066922461988377e-05, -2.589498612832655e-08, -4.247899443599655e-11,
  7.764288266032250e-13, -3.611322456219750e-15,  2.543188060312652e-18,  7.996027942659378e-20, -5.771084149574541e-22,  1.414103944023300e-24,  7.842625965036230e-27,
  4.086861273212241e-01, -2.862595799102887e-03,  1.121150580965948e-05, -1.514412715873180e-08, -1.263813009284612e-10,  9.573209812547605e-13, -1.956548200840642e-15,
 -1.435640055661520e-17,  1.325030324898443e-19, -3.268703707468866e-22, -2.092954852257843e-24,  2.200256678294441e-26,  5.013654977665346e-01, -3.309917895276176e-03,
  1.095347719368810e-05, -2.258922429443545e-10, -1.984857481931920e-10,  8.499706836376037e-13,  1.141567827365295e-15, -2.792575308111980e-17,  9.773406028810617e-20,
  3.635368011343587e-22, -4.746768951111876e-24,  1.164435408608063e-26,  6.002294494235869e-01, -3.704402232603983e-03,  9.853916328648000e-06,  1.685453540371240e-08,
 -2.384351073600504e-10,  4.400431734000610e-13,  4.458785768149398e-15, -2.846114312563862e-17, -2.228926139754573e-20,  9.489405436025070e-22, -2.989506934434458e-24,
 -1.891729077755996e-26,  7.040856045538332e-01, -4.026636598622279e-03,  7.958327227460751e-06,  3.355989450842380e-08, -2.324664443733928e-10, -1.730618167403398e-13,
  6.452564523717321e-15, -1.291593762895918e-17, -1.544887506183320e-19,  8.417789005433318e-22,  2.500352564464292e-24, -3.509399537755197e-26,  8.116747861783969e-01,
 -4.260589749064367e-03,  5.395849964498080e-06,  4.726536922117360e-08, -1.777375360407127e-10, -8.039375239672714e-13,  6.028319947761575e-15,  1.201776880931612e-17,
 -2.025424826166694e-19, -1.479895189837679e-24,  6.576755907667526e-24, -1.246701988635369e-26,  9.216853601394716e-01, -4.394427538202697e-03,  2.367083158062711e-06,
  5.573401939533849e-08, -8.375989534210246e-11, -1.245420108819182e-12,  3.142345615678667e-15,  3.306713056770243e-17, -1.212533688898354e-19, -9.465849949156079e-22,
  4.746688900394924e-24,  2.792414334097352e-26,  1.032768514247084e+00, -4.421139737189279e-03, -8.760779635337804e-07,  5.753368842615935e-08,  2.960041674532166e-11,
 -1.345358619364883e-12, -1.096844202953137e-15,  3.821027935354637e-17,  4.255565840798548e-20, -1.200496524488797e-21, -1.697845633326568e-24,  4.012408747102221e-26,
  1.143554337542389e+00, -4.338942070036534e-03, -4.056581667109929e-06,  5.231425763100007e-08,  1.371057245051781e-10, -1.065515358603005e-12, -4.914174994881117e-15,
  2.423658520785751e-17,  1.797240305004489e-19, -5.319869230969006e-22, -6.591799997311914e-24,  9.104252091551643e-27,  1.252668538076912e+00, -4.151427523236288e-03,
 -6.901608225521779e-06,  4.088842600397313e-08,  2.147700265938916e-10, -4.982263220954890e-13, -6.711464827836288e-15, -1.033573164573840e-18,  1.991180754613241e-19,
  4.998324107403059e-22, -5.284475842305577e-24, -2.945953405740020e-26,  1.358749612309430e+00, -3.867452413257387e-03, -9.172024410381295e-06,  2.509555989594624e-08,
  2.462498962065513e-10,  1.670624999642240e-13, -5.836424764908939e-15, -2.351822052143964e-17,  9.536667642989796e-20,  1.049163567752267e-21,  5.140736670133818e-25,
 -3.288137150946278e-26,  1.460466254259821e+00, -3.500755598604121e-03, -1.068860723827327e-05,  7.469993995835853e-09,  2.271436575261510e-10,  7.148448321756369e-13,
 -2.873017803891713e-15, -3.157236464596376e-17, -5.057637241505164e-20,  7.416758346163491e-22,  4.847797190902975e-24, -2.518786594349137e-27,  1.556534769138861e+00,
 -3.069323021497140e-03, -1.135199790402909e-05, -9.225621997783678e-09,  1.659159401217346e-10,  9.838587060311611e-13,  6.983731514465012e-16, -2.285823936675451e-17,
 -1.372938857068248e-19, -3.948667906822006e-23,  4.011477824104734e-24,  2.278726904079896e-26,  1.645736235676611e+00, -2.594523744166357e-03, -1.115396844092564e-05,
 -2.251281112126364e-08,  8.115084477234615e-11,  9.241199360266169e-13,  3.280938564430936e-15, -4.918857360078274e-18, -1.196370991797011e-19, -5.831742881001804e-22,
 -1.761730640474243e-26,  1.777465569483419e-26,  1.726933145328241e+00, -2.100056986541085e-03, -1.017851616925989e-05, -3.065498077382950e-08, -4.056943801919413e-12,
  6.077634440028623e-13,  3.953166150773028e-15,  1.060069461239310e-17, -3.408257455242075e-20, -5.254282896143698e-22, -2.643265027780604e-24, -2.922715320976865e-27,
  1.799085236660891e+00, -1.610761497981682e-03, -8.592448662503886e-06, -3.296844732852818e-08, -6.887979799470365e-11,  1.903734749453971e-13,  2.846881112078182e-15,
  1.576671337558861e-17,  4.286477019090568e-20, -9.940083159791736e-23, -1.924321503828160e-24, -1.186202126600226e-26,  1.861264241842458e+00, -1.151348028692127e-03,
 -6.626354756388665e-06, -2.992280600752920e-08, -1.006355582399372e-10, -1.593132632224580e-13,  9.310002403711678e-16,  1.072183226947781e-17,  6.124581891078432e-20,
  2.168718747455873e-22,  1.541945473412033e-25, -4.538783485581586e-27,  1.912667274677405e+00, -7.451218820027558e-04, -4.548025061206680e-06, -2.300874190101867e-08,
 -9.796872061551623e-11, -3.300334357123863e-13, -6.353692938425564e-16,  1.951486378473591e-18,  3.025853694529141e-20,  2.054475304852691e-22,  9.938941626072430e-25,
  3.326664266177983e-27,  1.952628640996434e+00, -4.127646853907475e-04, -2.631336478396121e-06, -1.439912349118806e-08, -7.038219136852171e-11, -3.081557543595156e-13,
 -1.176653724814200e-15, -3.577529619893413e-18, -5.429913809437641e-21,  3.164998577359666e-23,  3.959448143775670e-25,  2.728681205949561e-27,  1.980630141372580e+00,
 -1.712404491452660e-04, -1.124206976842402e-06, -6.472529575993470e-09, -3.432866441446992e-11, -1.709105133462565e-13, -8.037447320865075e-16, -3.564466180250321e-18,
 -1.476281372337707e-20, -5.578778690899677e-23, -1.817133880469183e-25, -4.204801769177721e-28,  1.996313748945275e+00, -3.285122586068385e-05, -2.191718626604984e-07,
 -1.296576495113129e-09, -7.168690860667937e-12, -3.790742414826999e-14, -1.940189027367489e-16, -9.677285216479630e-19, -4.722909328390449e-21, -2.260745217961591e-23,
 -1.062772686746861e-25, -4.908724269429920e-28,  1.466671458872001e-03, -1.263495228737271e-05,  8.157564386741358e-08, -4.677255094677716e-10,  2.511137449127166e-12,
 -1.292415475080372e-14,  6.455981249608039e-17, -3.153014071530612e-19,  1.512460258178969e-21, -7.147674461098821e-24,  3.334729362029920e-26, -1.538115179124650e-28,
  1.317687524650309e-02, -1.128839489593714e-04,  7.206345520140736e-07, -4.053883425715401e-09,  2.114146548324201e-11, -1.043743814194204e-13,  4.923367465110135e-16,
 -2.226133818418927e-18,  9.638317048402638e-21, -3.974455106841022e-23,  1.542590953472559e-25, -5.499790305019354e-28,  3.647385043278330e-02, -3.089868299017184e-04,
  1.927909487785508e-06, -1.042670139827882e-08,  5.109847354921834e-11, -2.295296364486902e-13,  9.383129474845365e-16, -3.387100314887691e-18,  9.868570900072333e-21,
 -1.496675267852531e-23, -7.567395916362266e-26,  9.574593586040635e-28,  7.111135951984686e-02, -5.923199235820006e-04,  3.568336647165598e-06, -1.812910155251547e-08,
  7.993172797247845e-11, -2.990110077406501e-13,  8.510507918999037e-16, -8.869175211284622e-19, -1.035490853905487e-20,  1.036362380302928e-22, -6.292051359395715e-25,
  2.912440232121219e-27,  1.167216368811288e-01, -9.503603225049642e-04,  5.455350825143541e-06, -2.530793317359197e-08,  9.379382036833263e-11, -2.337175683767246e-13,
 -7.744565817526323e-17,  5.453205399056761e-18, -4.069420782708524e-20,  1.965368862216316e-22, -6.087536012191953e-25,  1.349002621985927e-28,  1.728173596776397e-01,
 -1.367170276275944e-03,  7.368680771719551e-06, -3.005339241854132e-08,  8.178764780091877e-11, -5.624380747460478e-15, -1.632400796193540e-15,  1.192898212955182e-17,
 -5.001087882048061e-20,  8.490033429338246e-23,  6.159020144485506e-25, -6.959937388265692e-27,  2.387943775092413e-01, -1.824024789487336e-03,  9.075756223695201e-06,
 -3.076101695038201e-08,  3.972229574271354e-11,  3.398383976764163e-13, -3.082616182255154e-15,  1.288443248580835e-17, -1.292221903129713e-20, -2.407797386564622e-22,
  2.057837426894597e-24, -8.227760351408032e-27,  3.139352841734544e-01, -2.300166067201161e-03,  1.035490406982475e-05, -2.645510142037595e-08, -2.780995303638882e-11,
  6.908819438661472e-13, -3.507332933558623e-15,  4.781017628780493e-18,  6.027409534401690e-20, -5.149029789524507e-22,  1.666719355047315e-24,  3.799352902303277e-27,
  3.974139306304882e-01, -2.773663608535098e-03,  1.101826689325129e-05, -1.701573615280965e-08, -1.077345850667579e-10,  9.060078000127643e-13, -2.301039575847200e-15,
 -1.031889943669963e-17,  1.194537222683033e-19, -3.921544651673092e-22, -1.195366810763296e-24,  1.869937163888215e-26,  4.883009901481372e-01, -3.222353608344599e-03,
  1.093227694679358e-05, -3.264439652978898e-09, -1.812738207677369e-10,  8.683494735817548e-13,  4.051439746777755e-16, -2.462443412188020e-17,  1.075383821191480e-19,
  1.851130213908740e-22, -4.148440759991702e-24,  1.521510495716076e-26,  5.855706934678240e-01, -3.624826033333864e-03,  1.003358950263489e-05,  1.311552284605077e-08,
 -2.286289709004033e-10,  5.374411926022584e-13,  3.656850586051514e-15, -2.865237034209307e-17,  9.541807430030740e-21,  8.151512955817853e-22, -3.640429589617534e-24,
 -1.075537118558228e-26,  6.881088524011060e-01, -3.961422545776905e-03,  8.338641858367106e-06,  2.982102300654703e-08, -2.344111245590156e-10, -2.307003783468827e-14,
  6.026383262973639e-15, -1.735840521212833e-17, -1.227525061108995e-19,  9.113966101757021e-22,  9.972509991909760e-25, -3.280945285518979e-26,  7.947222831522908e-01,
 -4.215203726634136e-03,  5.945466737470481e-06,  4.430090081941508e-08, -1.923460122392631e-10, -6.559505321161844e-13,  6.274425396619357e-15,  5.585093275278096e-18,
 -1.980173428226491e-19,  2.479448053293172e-22,  5.832487180926496e-24, -2.096905297861760e-26,  9.041497244784431e-01, -4.372840287585880e-03,  3.027042577149719e-06,
  5.419899799202949e-08, -1.078415329633673e-10, -1.159361830935475e-12,  4.009055218293642e-15,  2.868067339433787e-17, -1.516418158799821e-19, -7.349259006138906e-22,
  5.764522287789476e-24,  1.809143127614827e-26,  1.015074319272200e+00, -4.425380744961880e-03, -1.837236327047611e-07,  5.779097344517730e-08,  2.517287057252014e-12,
 -1.358730660624648e-12, -1.446174203779517e-17,  3.887096774164860e-17, -1.452270182029939e-21, -1.232391997920711e-21,  1.141460639258755e-25,  4.164170890018111e-26,
  1.126137690301463e+00, -4.368848006274132e-03, -3.416371765539313e-06,  5.433130086162052e-08,  1.146742609464531e-10, -1.174681676018931e-12, -4.158270636233183e-15,
  2.963142687089722e-17,  1.559536936190820e-19, -7.842759863533322e-22, -5.940084727619241e-24,  2.042137522000466e-26,  1.235955591174358e+00, -4.204620141304122e-03,
 -6.390686364788050e-06,  4.423628178013703e-08,  2.031961906134548e-10, -6.589136406451263e-13, -6.648799930972984e-15,  5.582879499692507e-18,  2.130106648519164e-19,
  2.643128747772283e-22, -6.441685842070402e-24, -2.262475962982571e-26,  1.343135052359530e+00, -3.939556838289666e-03, -8.847152689245965e-06,  2.905446029583526e-08,
  2.481389955315135e-10,  1.946599862873850e-14, -6.446521215620080e-15, -1.986113589457590e-17,  1.331420650532863e-19,  1.039066565300375e-21, -1.057880668011620e-24,
 -3.821481798698936e-26,  1.446292870492355e+00, -3.585843053004183e-03, -1.057670268570377e-05,  1.121461774400782e-08,  2.406785881421367e-10,  6.351272072023981e-13,
 -3.775423449994071e-15, -3.272654583156448e-17, -2.043540634374163e-20,  9.308153582345719e-22,  4.543162712385482e-24, -1.157411569722077e-26,  1.544075209628602e+00,
 -3.160535205184375e-03, -1.144612575718052e-05, -6.412865432078645e-09,  1.857063141781524e-10,  9.924426806324272e-13, -3.146816309283010e-18, -2.724146992890569e-17,
 -1.355874581844182e-19,  1.407803213783485e-22,  4.991873416672150e-24,  2.140574108218216e-26,  1.635177999279799e+00, -2.684812601404349e-03, -1.141570806266752e-05,
 -2.106231493005513e-08,  1.004071947926520e-10,  1.000757753820729e-12,  3.086465359559803e-15, -9.081663385760590e-18, -1.404409850252402e-19, -5.666319163549597e-22,
  8.847820113548173e-25,  2.326531507542769e-26,  1.718367731047708e+00, -2.182956700678138e-03, -1.054634731319933e-05, -3.061739632466045e-08,  9.070413552974253e-12,
  7.060598097690048e-13,  4.231726310261825e-15,  9.186802175539916e-18, -5.492378012409727e-20, -6.327939421747680e-22, -2.699364384858158e-24,  6.031431808582885e-28,
  1.792502179851337e+00, -1.681101993815718e-03, -8.994544402601044e-06, -3.403619916752345e-08, -6.435253311452623e-11,  2.641473729143557e-13,  3.306902573002760e-15,
  1.706522492344431e-17,  3.777056741883138e-20, -1.873001756096420e-22, -2.482214553713444e-24, -1.344604099384753e-26,  1.856550514965586e+00, -1.205822768048904e-03,
 -6.995190367588558e-06, -3.155714488819499e-08, -1.035728910346007e-10, -1.331380106906199e-13,  1.259829425723427e-15,  1.280737958368939e-17,  6.911044434442523e-20,
  2.184165817319780e-22, -9.356325944604789e-26, -6.819856082572581e-27,  1.909612231795996e+00, -7.826376565287939e-04, -4.833755411368122e-06, -2.462985466522001e-08,
 -1.047168564954635e-10, -3.445100690110444e-13, -5.660035954332450e-16,  3.046058686675865e-18,  3.840584473228892e-20,  2.481630326796886e-22,  1.142345758605616e-24,
  3.388871060819427e-27,  1.950934358880761e+00, -4.345261576373755e-04, -2.811091097522355e-06, -1.557611222696607e-08, -7.683591377606304e-11, -3.376159601347019e-13,
 -1.279062649521051e-15, -3.729751985152717e-18, -3.974514848345485e-21,  5.010938707620438e-23,  5.327926646230754e-25,  3.521060776853493e-27,  1.979926686818622e+00,
 -1.805543905421351e-04, -1.205289174578412e-06, -7.050216890283754e-09, -3.794814157416947e-11, -1.914533366584558e-13, -9.104756591296957e-16, -4.070448752855684e-18,
 -1.690642622008440e-20, -6.342147254838738e-23, -1.997910311083766e-25, -3.955319566134962e-28,  1.996178735921345e+00, -3.466884562768122e-05, -2.354448392940782e-07,
 -1.417603267353115e-09, -7.975690251788624e-12, -4.290689506699131e-14, -2.233596200371213e-16, -1.132748181774496e-18, -5.618803172047312e-21, -2.732391807775268e-23,
 -1.304218212578874e-25, -6.112283152419593e-28,  1.417402251933719e-03, -1.200413404377927e-05,  7.619574173620454e-08, -4.295338952782236e-10,  2.267460893934608e-12,
 -1.147542034068898e-14,  5.637203365718421e-17, -2.707749656698799e-19,  1.277609146265628e-21, -5.939779973417141e-24,  2.726609298417220e-26, -1.237615402783955e-28,
  1.273656942264285e-02, -1.073078630497915e-04,  6.739506676976809e-07, -3.731698454179065e-09,  1.916726446456481e-11, -9.327270894358110e-14,  4.341160913351347e-16,
 -1.939455578229635e-18,  8.312961377941292e-21, -3.403484328951626e-23,  1.317866011784922e-25, -4.730472676395693e-28,  3.526797640733274e-02, -2.940504779749096e-04,
  1.807546911766666e-06, -9.644658612990236e-09,  4.672557622554921e-11, -2.081130234618773e-13,  8.478105442807937e-16, -3.080434007457812e-18,  9.284634379408490e-21,
 -1.723795715239050e-23, -3.988841143221977e-26,  6.822319418117085e-28,  6.879782550374922e-02, -5.646221331803245e-04,  3.358267097395047e-06, -1.689693497057324e-08,
  7.415356898219878e-11, -2.789179566288148e-13,  8.221057609973148e-16, -1.163195241892288e-18, -7.047409175076959e-21,  8.089310988709576e-23, -5.112825717529751e-25,
  2.455208067083890e-27,  1.130055933493224e-01, -9.079071404365578e-04,  5.160505388745347e-06, -2.384467849858539e-08,  8.911251655130040e-11, -2.338847673372106e-13,
  5.804336185251207e-17,  4.259519091045146e-18, -3.405409185458910e-20,  1.724839514964607e-22, -5.899540099830329e-25,  6.770106901138166e-28,  1.674643247854960e-01,
 -1.309641168526106e-03,  7.015881372080351e-06, -2.874770825715948e-08,  8.130951688025224e-11, -4.097172133240111e-14, -1.320304105994198e-15,  1.038172355110340e-17,
 -4.658009919433268e-20,  1.039262592822695e-22,  3.476268517712459e-25, -5.280538988722125e-27,  2.316411685158209e-01, -1.752883973003295e-03,  8.710648965966902e-06,
 -3.007498408437707e-08,  4.580818423965669e-11,  2.701305930795881e-13, -2.728835148841960e-15,  1.234741414649925e-17, -2.019533531065722e-20, -1.656386680575533e-22,
  1.701720774250612e-24, -7.887208574160323e-27,  3.048982784504278e-01, -2.218603223150389e-03,  1.003521439773114e-05, -2.679404389838105e-08, -1.482217529627697e-11,
  6.085136657889985e-13, -3.349154965739634e-15,  6.426338811583277e-18,  4.296889349036283e-20, -4.458682728614231e-22,  1.762499477595368e-24,  7.065583331573229e-28,
  3.864942356911367e-01, -2.686362175350852e-03,  1.080432353472966e-05, -1.859761945621291e-08, -9.018790590903236e-11,  8.477343087624878e-13, -2.538632616180404e-15,
 -6.729943740294477e-18,  1.046640984062606e-19, -4.245805251538954e-22, -4.526633136722914e-25,  1.503584361983503e-26,  4.755861761824577e-01, -3.135100070164457e-03,
  1.087627558260534e-05, -6.025583922463776e-09, -1.638634132150150e-10,  8.701930236706447e-13, -2.353817019894772e-16, -2.110725774151137e-17,  1.113827788070318e-19,
  3.318332331905832e-23, -3.435924276820900e-24,  1.688483099165306e-26,  5.712328368671533e-01, -3.543989112755337e-03,  1.016939681023154e-05,  9.547946623035763e-09,
 -2.170671968287218e-10,  6.156390034054062e-13,  2.863065481908207e-15, -2.790639968729818e-17,  3.617261561629445e-20,  6.623087706656751e-22, -3.948156549740251e-24,
 -3.411462342823248e-27,  6.723987568886527e-01, -3.893345746493979e-03,  8.674000425806821e-06,  2.607443936393083e-08, -2.334677267645988e-10,  1.153173865238900e-13,
  5.490326137203036e-15, -2.075657790784359e-17, -8.956161308156400e-20,  9.235953223068680e-22, -3.547276402280123e-25, -2.834773177203565e-26,  7.779598874738433e-01,
 -4.165566811286179e-03,  6.458206020480232e-06,  4.112663479809746e-08, -2.039501536317548e-10, -5.041939514448812e-13,  6.343748090734116e-15, -5.655429606311133e-19,
 -1.851322590225215e-19,  4.608576440948468e-22,  4.770289715220181e-24, -2.685085034210055e-26,  8.867108714430602e-01, -4.346053454912842e-03,  3.666330242972571e-06,
  5.229352625729623e-08, -1.300044802752227e-10, -1.054078956660270e-12,  4.740526498970787e-15,  2.345068980164517e-17, -1.737853943336922e-19, -4.915672499907317e-22,
  6.324774494513430e-24,  7.312966154054554e-27,  9.973742470740362e-01, -4.424077946154202e-03,  5.091138946128258e-07,  5.761420370742771e-08, -2.457283831814349e-11,
 -1.346063222988100e-12,  1.066631997339391e-15,  3.811908577227375e-17, -4.529745475741674e-20, -1.191543029359693e-21,  1.912882415992020e-24,  3.952877376390783e-26,
  1.108611807145215e+00, -4.393541705862630e-03, -2.754179486155008e-06,  5.597300947076848e-08,  9.025264448629806e-11, -1.263987763962412e-12, -3.263283766189689e-15,
  3.412629028873824e-17,  1.236879301212873e-19, -1.000802979902688e-21, -4.812444155069551e-24,  3.053856531427057e-26,  1.219038298221028e+00, -4.253568078890011e-03,
 -5.840806937870399e-06,  4.737339171375211e-08,  1.884388792182423e-10, -8.158317761280132e-13, -6.395985131464082e-15,  1.249994422365571e-17,  2.176719972101489e-19,
 -1.059045131198214e-23, -7.232495615910526e-24, -1.289011751479897e-26,  1.327237573956812e+00, -4.008871977831268e-03, -8.474692699489193e-06,  3.301921254325344e-08,
  2.469387388561546e-10, -1.414082216432203e-13, -6.937439547077183e-15, -1.501360825900488e-17,  1.693719060664774e-19,  9.621037846970803e-22, -2.810099028600257e-24,
 -4.092583057429615e-26,  1.431781216999506e+00, -3.669851976404930e-03, -1.041861974533937e-05,  1.516185987771509e-08,  2.524005608234922e-10,  5.334792192793842e-13,
 -4.695640795139836e-15, -3.281042719602606e-17,  1.619557344170987e-20,  1.099409279687412e-21,  3.812045719931419e-24, -2.178739951238566e-26,  1.531249516716411e+00,
 -3.252360009502003e-03, -1.150459806700764e-05, -3.283045765492180e-09,  2.054901200767231e-10,  9.827298442810315e-13, -8.256040843589172e-16, -3.145885243836152e-17,
 -1.267064900662609e-19,  3.583475928444333e-22,  5.858275861100200e-24,  1.752539413194093e-26,  1.624254537403495e+00, -2.777120399432202e-03, -1.165814347252849e-05,
 -1.929174965447953e-08,  1.211398008524901e-10,  1.071255096076823e-12,  2.766255381871174e-15, -1.389322558208257e-17, -1.599413337615940e-19, -5.091628468532248e-22,
  2.027679159077266e-24,  2.861015101519930e-26,  1.709464840709519e+00, -2.268793537574000e-03, -1.091240120534523e-05, -3.035369835877118e-08,  2.422694128683074e-11,
  8.104876107875548e-13,  4.460778352185516e-15,  7.044044182389118e-18, -7.962928988464192e-20, -7.388736584184287e-22, -2.568033829180738e-24,  5.628986208876020e-27,
  1.785631248268760e+00, -1.754709160149237e-03, -9.408967880540067e-06, -3.501909908533723e-08, -5.823654827947999e-11,  3.493765840595541e-13,  3.800492977744436e-15,
  1.814565503830385e-17,  2.909449816466807e-20, -2.987960823703504e-22, -3.100781771975571e-24, -1.456597477214453e-26,  1.851612862479904e+00, -1.263327396843198e-03,
 -7.383901309182653e-06, -3.323384389391424e-08, -1.059029228259426e-10, -9.834169738289991e-14,  1.650570822432365e-15,  1.514336505661829e-17,  7.682648640044806e-20,
  2.078647671904448e-22, -4.551931329215934e-25, -9.726826403488411e-27,  1.906402428306821e+00, -8.225189441246298e-04, -5.139596167533247e-06, -2.636115244299826e-08,
 -1.117352363478813e-10, -3.569232266610946e-13, -4.621005188248372e-16,  4.427096587441089e-18,  4.819787005475053e-20,  2.968054385042672e-22,  1.288398488022765e-24,
  3.197680453392558e-27,  1.949150062812682e+00, -4.577839633627283e-04, -3.005609018853903e-06, -1.686120904165276e-08, -8.390373373403884e-11, -3.695792105423131e-13,
 -1.384973936489788e-15, -3.823641067728837e-18, -1.747148961214026e-21,  7.479489622883672e-23,  7.086681386853847e-25,  4.508142665594308e-27,  1.979184633847461e+00,
 -1.905457351635740e-04, -1.293665112492578e-06, -7.689246827697431e-09, -4.200527934641444e-11, -2.147357225181803e-13, -1.032376729445088e-15, -4.649560678062396e-18,
 -1.933750048130138e-20, -7.174482045448768e-23, -2.158787323813922e-25, -3.268390657488285e-28,  1.996036182532456e+00, -3.662268585246289e-05, -2.532510371593982e-07,
 -1.552381836840558e-09, -8.890112531370438e-12, -4.866939317739593e-14, -2.577491652102926e-16, -1.329350399670390e-18, -6.703229261045496e-21, -3.312087743058391e-23,
 -1.605334011748532e-25, -7.633957798132991e-28,  1.370573051344971e-03, -1.141458596502379e-05,  7.125166872803735e-08, -3.950195762179183e-10,  2.050890721683315e-12,
 -1.020904239721526e-14,  4.933199869194031e-17, -2.331124915328943e-19,  1.082164553107253e-21, -4.950629360157952e-24,  2.236491975344609e-26, -9.992117729489291e-29,
  1.231784474987905e-02, -1.020903039242816e-04,  6.309505681764188e-07, -3.439397705752552e-09,  1.740175014005363e-11, -8.347661690333519e-14,  3.833583691349378e-16,
 -1.692066959201110e-18,  7.177765728657365e-21, -2.915908235771995e-23,  1.124943153597197e-25, -4.053677701760728e-28,  3.411997978640276e-02, -2.800406462297774e-04,
  1.696162811594265e-06, -8.929270661336617e-09,  4.275997490498766e-11, -1.887676060209765e-13,  7.656227414101878e-16, -2.793507969129118e-18,  8.641983205670224e-21,
 -1.829806929509738e-23, -1.461232424351160e-26,  4.766904827049263e-28,  6.659181300225178e-02, -5.385472965561262e-04,  3.162441975805591e-06, -1.575404421298576e-08,
  6.876975632452848e-11, -2.596011805941247e-13,  7.867898944146413e-16, -1.345861185471891e-18, -4.478480029808451e-21,  6.247852872895741e-23, -4.124191806384073e-25,
  2.047101538583946e-27,  1.094547544295860e-01, -8.677437581105536e-04,  4.882770035202587e-06, -2.245618570090415e-08,  8.445779955697328e-11, -2.311780915905569e-13,
  1.629550463166421e-16,  3.264649472665327e-18, -2.826124826100564e-20,  1.495896098788966e-22, -5.524362027695719e-25,  9.974936586904555e-28,  1.623358605147580e-01,
 -1.254871964341318e-03,  6.678682231167254e-06, -2.745493729022091e-08,  8.019589971270623e-11, -6.933565221580142e-14, -1.049904651392647e-15,  8.953277369215422e-18,
 -4.264048697241856e-20,  1.136165805492465e-22,  1.470843610527787e-25, -3.880511295917408e-27,  2.247667354117400e-01, -1.684629532627666e-03,  8.354313820106396e-06,
 -2.930227447521167e-08,  5.058348046646504e-11,  2.087091975948710e-13, -2.392961717191903e-15,  1.161822453237592e-17, -2.501510185912413e-20, -1.043284505289576e-22,
  1.368778530574487e-24, -7.204844504250301e-27,  2.961823881332406e-01, -2.139610756826170e-03,  9.712650587797297e-06, -2.693814002569815e-08, -3.440382396030146e-12,
  5.304342277588584e-13, -3.152283310658912e-15,  7.558146745786453e-18,  2.818752904990344e-20, -3.754593807904398e-22,  1.741795176150256e-24, -1.512822483049827e-27,
  3.759202097864660e-01, -2.600843537159527e-03,  1.057304268468265e-05, -1.990835628017575e-08, -7.385585939877814e-11,  7.849101129114303e-13, -2.682497094055132e-15,
 -3.627516527643400e-18,  8.920283819171552e-20, -4.305391220720743e-22,  1.281905299157456e-25,  1.139566890351476e-26,  4.632192771833664e-01, -3.048422344649207e-03,
  1.078881048942450e-05, -8.508668277719783e-09, -1.465618327425076e-10,  8.578547760011055e-13, -7.764864904165683e-16, -1.754895737445823e-17,  1.102839626435670e-19,
 -8.926100707984933e-23, -2.685483178934220e-24,  1.700231005796298e-26,  5.572202343179350e-01, -3.462233720394403e-03,  1.026355141450098e-05,  6.176844107431627e-09,
 -2.041298072626074e-10,  6.751277610415658e-13,  2.101257598612242e-15, -2.639804441615743e-17,  5.715427774833113e-20,  5.032712322470206e-22, -3.959439509749453e-24,
  2.664852892063028e-27,  6.569660502037404e-01, -3.822765452426605e-03,  8.964579543926969e-06,  2.236436286570543e-08, -2.298923205823098e-10,  2.398177147851400e-13,
  4.873983671655921e-15, -2.309563963647307e-17, -5.685330105733737e-20,  8.861107702867709e-22, -1.476720560543444e-24, -2.248657942100091e-26,  7.614039978896178e-01,
 -4.111983271799314e-03,  6.931840408042310e-06,  3.779101633612484e-08, -2.125162058622779e-10, -3.527868698866660e-13,  6.247716621043188e-15, -6.189875347112069e-18,
 -1.654018879264664e-19,  6.269403041313925e-22,  3.511753618328074e-24, -2.988568341342718e-26,  8.693892412330841e-01, -4.314249645903839e-03,  4.280697042187171e-06,
  5.005119533899730e-08, -1.498984575757116e-10, -9.330698906392705e-13,  5.316980418992723e-15,  1.765568066959354e-17, -1.868793561807695e-19, -2.353097216168629e-22,
  6.410806585221672e-24, -3.283366058194215e-27,  9.796904476712979e-01, -4.417248272223013e-03,  1.197242433713447e-06,  5.700741851185368e-08, -5.115266953415913e-11,
 -1.307858862520159e-12,  2.107349117697831e-15,  3.600132938031454e-17, -8.640877891496996e-20, -1.081629175585255e-21,  3.542799770968495e-24,  3.404594764883143e-26,
  1.090997859489868e+00, -4.412865835841809e-03, -2.074686228562116e-06,  5.721089090836163e-08,  6.426926512076925e-11, -1.330427436308104e-12, -2.258000688430421e-15,
  3.747347076035172e-17,  8.454095135137287e-20, -1.163932635518074e-21, -3.287270457865622e-24,  3.831826978400996e-26,  1.201934244030366e+00, -4.297970649818418e-03,
 -5.254801211325905e-06,  5.024967346848696e-08,  1.706196161490606e-10, -9.643507083940346e-13, -5.948930477904409e-15,  1.940260352795864e-17,  2.119772016788529e-19,
 -3.078526155613653e-22, -7.543718819010302e-24, -9.771242300343450e-28,  1.311069094888696e+00, -4.075017704266074e-03, -8.054879026342085e-06,  3.693842911897650e-08,
  2.424148359910497e-10, -3.123077539413306e-13, -7.276910176409523e-15, -9.064760359679362e-18,  2.015493780594466e-19,  8.136253936894549e-22, -4.608650170599286e-24,
 -4.020757614461222e-26,  1.416936361418224e+00, -3.752403742578841e-03, -1.021211556095598e-05,  1.927919158701863e-08,  2.618692388927475e-10,  4.098556728949979e-13,
 -5.600929096152158e-15, -3.163154119313320e-17,  5.825965564046692e-20,  1.229611850219020e-21,  2.621442872665539e-24, -3.229161098684963e-26,  1.518055834464787e+00,
 -3.344497001687072e-03, -1.152362328810579e-05,  1.606487806163381e-10,  2.248729120004949e-10,  9.519005736714901e-13, -1.760946403772659e-15, -3.526041980461874e-17,
 -1.094179589349171e-19,  6.063255260575870e-22,  6.491281843885867e-24,  1.074872870361463e-26,  1.612958108030381e+00, -2.871276950126197e-03, -1.187729672137428e-05,
 -1.717864770801532e-08,  1.431942356143491e-10,  1.132382439019425e-12,  2.302962049584807e-15, -1.928642379697585e-17, -1.764948482359653e-19, -4.014624389610836e-22,
  3.390320818321476e-24,  3.312425434059103e-26,  1.700212772234210e+00, -2.357541864966296e-03, -1.127376586507775e-05, -2.983051086815804e-08,  4.152166125367740e-11,
  9.195998778491418e-13,  4.618200871614681e-15,  4.051082786012730e-18, -1.080014864557280e-19, -8.348003086769157e-22, -2.179737434029831e-24,  1.229636567156544e-26,
  1.778459185069474e+00, -1.831677096175747e-03, -9.834540660105132e-06, -3.588985325804581e-08, -5.029524561441173e-11,  4.467797350795628e-13,  4.319810586994697e-15,
  1.887937000660846e-17,  1.594925858198309e-20, -4.358027121888276e-22, -3.751602104079336e-24, -1.483989516809191e-26,  1.846438843854161e+00, -1.324022772177980e-03,
 -7.792931643878740e-06, -3.494172373635343e-08, -1.074378100770252e-10, -5.335525544731675e-14,  2.110098081798405e-15,  1.771713227533135e-17,  8.386966731210419e-20,
  1.800916862396729e-22, -9.595952795863829e-25, -1.331514701436504e-26,  1.903028071917791e+00, -8.649319869822388e-04, -5.466893977791915e-06, -2.820658110840301e-08,
 -1.189736204162375e-10, -3.663416159389018e-13, -3.148703869574650e-16,  6.150602347274962e-18,  5.984321924764496e-20,  3.510169596073247e-22,  1.417918703305199e-24,
  2.609862877957358e-27,  1.947269522788371e+00, -4.826615690380991e-04, -3.216248157861678e-06, -1.826464394196129e-08, -9.163640505618611e-11, -4.041069525583164e-13,
 -1.492372468907767e-15, -3.830589050736587e-18,  1.506577577905400e-21,  1.074487701787747e-22,  9.328716814189062e-25,  5.723211544941196e-27,  1.978401151310599e+00,
 -2.012759007167945e-04, -1.390114791619042e-06, -8.397080785089825e-09, -4.655868114102788e-11, -2.411473875799999e-13, -1.171627947117410e-15, -5.311378485700374e-18,
 -2.207891153933463e-20, -8.063345175215801e-23, -2.275668667619135e-25, -1.909354823636547e-28,  1.995885518277265e+00, -3.872570281429550e-05, -2.727663161970048e-07,
 -1.702759951221169e-09, -9.928505273210426e-12, -5.532742147936365e-14, -2.981625049412179e-16, -1.564239519661576e-18, -8.019741184968744e-21, -4.026747898276452e-23,
 -1.982006595233386e-25, -9.563460465487945e-28,  1.326025480293217e-03, -1.086299082312445e-05,  6.670178383435432e-08, -3.637765934078740e-10,  1.858040400789153e-12,
 -9.099645829821842e-15,  4.326404877427217e-17, -2.011703713836980e-19,  9.190393725938938e-22, -4.138062807686856e-24,  1.840153383076954e-26, -8.094005357890476e-29,
  1.191932386802792e-02, -9.720318090747345e-05,  5.912948455429714e-07, -3.173841716547243e-09,  1.582051633517743e-11, -7.481953548357342e-14,  3.390443193482471e-16,
 -1.478339431950895e-18,  6.204900773734497e-21, -2.499807384043898e-23,  9.598532405656775e-26, -3.464247736645526e-28,  3.302629323145140e-02, -2.668885985857747e-04,
  1.592995097291188e-06, -8.274341547575271e-09,  3.916219547335581e-11, -1.713006412328673e-13,  6.911765163487211e-16, -2.527578929444195e-18,  7.977341393182850e-21,
 -1.851129495682841e-23,  2.842978709761466e-27,  3.243513287335609e-28,  6.448705147594340e-02, -5.139856374910000e-04,  2.979827292824226e-06, -1.469425140508449e-08,
  6.376343459865612e-11, -2.411846579750212e-13,  7.474158444582800e-16, -1.456199178300997e-18, -2.505482456740977e-21,  4.767466114402360e-23, -3.303664352584451e-25,
  1.691164535532396e-27,  1.060602290180264e-01, -8.297368720841909e-04,  4.621251946961083e-06, -2.114160760612196e-08,  7.988024358228664e-11, -2.262676152634913e-13,
  2.424838805439818e-16,  2.442277815036647e-18, -2.326265841786371e-20,  1.284273534110801e-22, -5.045005782572708e-25,  1.159737930172795e-27,  1.574211756434324e-01,
 -1.202738644070102e-03,  6.356871820050436e-06, -2.618418316492015e-08,  7.857673487974377e-11, -9.167543858595893e-14, -8.176946631989547e-16,  7.655047906311087e-18,
 -3.848229665615012e-20,  1.164374691726890e-22,  2.218802295579186e-27, -2.746147957737411e-27,  2.181596791469245e-01, -1.619187475027759e-03,  8.007670478934713e-06,
 -2.846255680095190e-08,  5.420922285787077e-11,  1.550882775415791e-13, -2.079351004339573e-15,  1.076760948317640e-17, -2.785958745960177e-20, -5.567205528649451e-23,
  1.070344013148288e-24, -6.341310244672642e-27,  2.877772999253848e-01, -2.063202738711020e-03,  9.389399602801828e-06, -2.691235361296047e-08,  6.429371550436623e-12,
  4.574088794000656e-13, -2.929964208591198e-15,  8.257169693678887e-18,  1.590456206055061e-20, -3.076009017267906e-22,  1.640449477686366e-24, -2.981355984277623e-27,
  3.656844644692060e-01, -2.517233715388532e-03,  1.032755887583675e-05, -2.096799130235592e-08, -5.880807719736125e-11,  7.196196316420383e-13, -2.746422328456252e-15,
 -1.019107065876602e-18,  7.390728365896941e-20, -4.163977677437507e-22,  5.544352814067037e-25,  8.042259977690984e-27,  4.511975075439449e-01, -2.962558845069229e-03,
  1.067319899911255e-05, -1.071757331228058e-08, -1.296288492118965e-10,  8.337177629800029e-13, -1.219072556241180e-15, -1.409056621272627e-17,  1.053152987769808e-19,
 -1.819537020522701e-22, -1.956762025427731e-24,  1.596363566544424e-26,  5.435359086871737e-01, -3.379883301104626e-03,  1.031853086505857e-05,  3.021280285471425e-09,
 -1.901816858007944e-10,  7.169105256814130e-13,  1.390225019365370e-15, -2.430947120616883e-17,  7.246300973836491e-20,  3.487004372330614e-22, -3.735676629625637e-24,
  7.253600932458262e-27,  6.418200336109260e-01, -3.750037452658833e-03,  9.211060494085907e-06,  1.873058904943982e-08, -2.239795301434921e-10,  3.488566286054802e-13,
  4.206539178925896e-15, -2.441776851798629e-17, -2.623784949604142e-20,  8.091425843490766e-22, -2.324358237183742e-24, -1.599901240448393e-26,  7.450697641192509e-01,
 -4.054772867799528e-03,  7.364724413020726e-06,  3.434238875370708e-08, -2.180895291187178e-10, -2.054978026031955e-13,  6.003871351508114e-15, -1.109709976480609e-17,
 -1.406233449016671e-19,  7.408340224429932e-22,  2.180782836187031e-24, -3.018711245812699e-26,  8.522044783198109e-01, -4.277643757006501e-03,  4.866328196934250e-06,
  4.751061801925960e-08, -1.672472562088257e-10, -8.002118757784791e-13,  5.726694382763528e-15,  1.158903700857374e-17, -1.907959977095716e-19,  1.534897931733707e-23,
  6.053555969729641e-24, -1.268588964269715e-26,  9.620449207861133e-01, -4.404949858605694e-03,  1.875567436122940e-06,  5.598280302518500e-08, -7.672419567895519e-11,
 -1.245533422475719e-12,  3.071032758128614e-15,  3.264337964582399e-17, -1.224557172065903e-19, -9.122016386194258e-22,  4.868762210329556e-24,  2.584870411924962e-26,
  1.073317571185861e+00, -4.426701761254342e-03, -1.382872321212181e-06,  5.802374807084135e-08,  3.720519863054923e-11, -1.371762207393275e-12, -1.177329695479023e-15,
  3.948637644470495e-17,  4.069384481511579e-20, -1.260107944068786e-21, -1.488348446845288e-24,  4.286079510329915e-26,  1.184662167109965e+00, -4.337552181886825e-03,
 -4.636086708733229e-06,  5.281773215978404e-08,  1.499527741684470e-10, -1.099851575973011e-12, -5.312772475378793e-15,  2.595045523124087e-17,  1.954871037783705e-19,
 -6.066698769670415e-22, -7.302275201919199e-24,  1.202684822385163e-26,  1.294643045711138e+00, -4.137618291775497e-03, -7.588583116943765e-06,  4.075753531225399e-08,
  2.344055400905941e-10, -4.892448473396735e-13, -7.436299425752044e-15, -2.185512478261489e-18,  2.271045791140198e-19,  5.949727498299405e-22, -6.290065267733517e-24,
 -3.554944297542105e-26,  1.401764919135057e+00, -3.833103463385580e-03, -9.955379781077728e-06,  2.352707589364336e-08,  2.686516537594313e-10,  2.650573968944225e-13,
 -6.453729954092425e-15, -2.904169543748523e-17,  1.040437179700851e-19,  1.303107699126319e-21,  9.829309355433256e-25, -4.193866675358437e-26,  1.504493568932685e+00,
 -3.436615681142757e-03, -1.149948782077559e-05,  3.908280668857446e-09,  2.434063730791712e-10,  8.974166841140165e-13, -2.793614091124569e-15, -3.836166881064394e-17,
 -8.282646114484037e-20,  8.727654134125802e-22,  6.759216114075100e-24,  9.359174228621732e-28,  1.601281715184399e+00, -2.967079210381839e-03, -1.206893727680262e-05,
 -1.470355093550210e-08,  1.663475023116771e-10,  1.180522737701253e-12,  1.681903198168837e-15, -2.513641554488256e-17, -1.881459979406814e-19, -2.357166071142430e-22,
  4.917553341858856e-24,  3.593402744078672e-26,  1.690599975238357e+00, -2.449151125437836e-03, -1.162711938514017e-05, -2.901297499485064e-08,  6.102907660740628e-11,
  1.031378987503009e-12,  4.678615412129246e-15,  9.855807805211594e-20, -1.394723227539688e-19, -9.088407134293463e-22, -1.461837728935898e-24,  2.059156685432777e-26,
  1.770972378034527e+00, -1.912089098121297e-03, -1.026973362811380e-05, -3.661727882412843e-08, -4.027984528972640e-11,  5.568407665329839e-13,  4.853005810226337e-15,
  1.910849408005950e-17, -2.596552698125576e-21, -5.987283819292606e-22, -4.386985196445401e-24, -1.377364227680369e-26,  1.841015368948667e+00, -1.388072713516133e-03,
 -8.222572185742226e-06, -3.666633977334918e-08, -1.079567174727855e-10,  3.549023705785860e-15,  2.644666249454933e-15,  2.049606898046938e-17,  8.950994316367073e-20,
  1.287815063721110e-22, -1.637026091002814e-24, -1.758546265133791e-26,  1.899478683543048e+00, -9.100539747223231e-04, -5.817037364436175e-06, -3.016912168428521e-08,
 -1.263609027211961e-10, -3.716034369124755e-13, -1.138647934582343e-16,  8.278925267492666e-18,  7.352579407943110e-20,  4.097340845892244e-22,  1.509380016661675e-24,
  1.430856037137163e-27,  1.945285992414396e+00, -5.092938093788132e-04, -3.444494093720759e-06, -1.979746590976422e-08, -1.000853569755810e-10, -4.412016776489319e-13,
 -1.598318185204293e-15, -3.712769333262195e-18,  6.110825720755050e-21,  1.502141483411434e-22,  1.216127992430542e-24,  7.196900693348305e-27,  1.977573149318316e+00,
 -2.128129196157547e-04, -1.495513642355436e-06, -9.182183103860286e-09, -5.167529002881419e-11, -2.711336641712765e-13, -1.330686888827575e-15, -6.066118280134048e-18,
 -2.514704804563303e-20, -8.984316191614958e-23, -2.311985777723273e-25,  4.598789325370103e-29,  1.995726117868496e+00, -4.099235307479039e-05, -2.941903896379903e-07,
 -1.870872657935849e-09, -1.111031616214278e-11, -6.303930173403370e-14, -3.457833883182621e-16, -1.845681710052261e-18, -9.622827437658986e-21, -4.910504557830289e-23,
 -2.454630453750340e-25, -1.201716379042747e-27,  1.283613794223196e-03, -1.034634591614408e-05,  6.250900848036611e-08, -3.354493310756091e-10,  1.685991210348761e-12,
 -8.125711394349825e-15,  3.802158670852500e-17, -1.740092549938559e-19,  7.825032664291305e-22, -3.468518496301325e-24,  1.518603735893669e-26, -6.577549091264024e-29,
  1.153973657863118e-02, -9.262097428666022e-05,  5.546795282368124e-07, -2.932256147589525e-09,  1.440225591103249e-11, -6.715756271112528e-14,  3.003004362135747e-16,
 -1.293469364298633e-18,  5.370548629552145e-21, -2.144796595361812e-23,  8.189106776645321e-26, -2.954734507734540e-28,  3.198361261093698e-02, -2.545314087232704e-04,
  1.497352366076866e-06, -7.674276779871907e-09,  3.589647893615164e-11, -1.555334396187756e-13,  6.238782795329272e-16, -2.282918824588917e-18,  7.316093107055352e-21,
 -1.814765657447916e-23,  1.452474446048156e-26,  2.124061846042234e-28,  6.247769340927443e-02, -4.908353598996324e-04,  2.809461502666484e-06, -1.371166537309163e-08,
  5.911577816841734e-11, -2.237435222915238e-13,  7.057604583250958e-16, -1.511324551149241e-18, -1.009982017161010e-21,  3.585485359472146e-23, -2.628452502599457e-25,
  1.386118281882008e-27,  1.028136450219576e-01, -7.937602680103222e-04,  4.375072906699446e-06, -1.989938853779528e-08,  7.541820939108371e-11, -2.197073792966731e-13,
  3.011138549589986e-16,  1.768053425065267e-18, -1.899000269977571e-20,  1.092900131921437e-22, -4.519852017188288e-25,  1.212662776857254e-27,  1.527099709998037e-01,
 -1.153119283352090e-03,  6.050141222092777e-06, -2.494261932874292e-08,  7.656363830050090e-11, -1.088632981367248e-13, -6.199643935879404e-16,  6.490480250300031e-18,
 -3.431549271392567e-20,  1.143894812568558e-22, -9.809864483704394e-26, -1.850484020982401e-27,  2.118089099257189e-01, -1.556477350394704e-03,  7.671417733480101e-06,
 -2.757300591024099e-08,  5.683583764079772e-11,  1.086994602893173e-13, -1.790584500788390e-15,  9.851769093421561e-18, -2.915790724854362e-20, -1.816695205861139e-23,
  8.116824850130164e-25, -5.412851235807618e-27,  2.796726773800487e-01, -1.989376915240098e-03,  9.067358309805906e-06, -2.674003940448015e-08,  1.489334042148777e-11,
  3.899118723508420e-13, -2.693214236068800e-15,  8.601326976341990e-18,  5.977707435381495e-21, -2.448985679793316e-22,  1.488432480403066e-24, -3.839623278967052e-27,
  3.557791558127964e-01, -2.435634633236449e-03,  1.007076073754811e-05, -2.179736780070822e-08, -4.507581424629796e-11,  6.536166426303134e-13, -2.744066149519892e-15,
  1.110999225118577e-18,  5.939325326480194e-20, -3.880352083027696e-22,  8.424920560844787e-25,  5.132506584301484e-27,  4.395171806915852e-01, -2.877721699357722e-03,
  1.053268850399198e-05, -1.265995710155425e-08, -1.132770881803513e-10,  8.000998524166700e-13, -1.567511770490340e-15, -1.083904262567482e-17,  9.752101036915641e-20,
 -2.466646175118888e-22, -1.291981076247321e-24,  1.415714569363773e-26,  5.301816300142781e-01, -3.297240661796338e-03,  1.033700719921910e-05,  9.466527673447886e-11,
 -1.755635554551933e-10,  7.423805547916285e-13,  7.437087357413416e-16, -2.181795589297325e-17,  8.241286885340025e-20,  2.066692678925290e-22, -3.343489464052384e-24,
  1.033009567258202e-26,  6.269685990274111e-01, -3.675510258123933e-03,  9.414572903056792e-06,  1.520798512886448e-08, -2.160485862251232e-10,  4.415405644258207e-13,
  3.515330842056966e-15, -2.481051940552689e-17,  1.065589892789010e-21,  7.040071287538007e-22, -2.885486285374401e-24, -9.564224037754013e-27,  7.289710341654004e-01,
 -3.994266220239503e-03,  7.755785905091904e-06,  3.082779121584902e-08, -2.207862456785312e-10, -6.561682860185900e-14,  5.634267789111620e-15, -1.515606494538046e-17,
 -1.126994503166353e-19,  8.019499492941188e-22,  8.899799648769837e-25, -2.814139009146780e-26,  8.351753095850576e-01, -4.236479280327884e-03,  5.419896197909165e-06,
  4.471419356718734e-08, -1.818543605754868e-10, -6.595650607996199e-13,  5.966120034378009e-15,  5.537903999278563e-18, -1.860410828050034e-19,  2.439766999793109e-22,
  5.323639491782540e-24, -2.011876087337204e-26,  9.444593532001735e-01, -4.387280879236546e-03,  2.539187298744905e-06,  5.456023759694885e-08, -1.008261932340864e-10,
 -1.161332208251933e-12,  3.925530430139986e-15,  2.823901199565648e-17, -1.515410528953093e-19, -6.975451039683409e-22,  5.791364017008359e-24,  1.588466111138779e-26,
  1.055593059516064e+00, -4.434971573280344e-03, -6.839249490767427e-07,  5.839839207539638e-08,  9.577531872599039e-12, -1.386645783636280e-12, -6.036038630847751e-17,
  4.005499202719298e-17, -5.282001217073952e-21, -1.281412928156131e-21,  4.287942768052952e-25,  4.364161220577312e-26,  1.167241850465343e+00, -4.372066552765435e-03,
 -3.988626094652162e-06,  5.503433192696070e-08,  1.267430932699649e-10, -1.217954046932908e-12, -4.502259595822340e-15,  3.180149192952002e-17,  1.685517730204209e-19,
 -8.843556143654579e-22, -6.488905151353323e-24,  2.478762374874384e-26,  1.277974341738716e+00, -4.196307643404114e-03, -7.077344094641556e-06,  4.442004204794342e-08,
  2.228352960936608e-10, -6.676111739245660e-13, -7.392894223822266e-15,  5.373049838857434e-18,  2.436379402237552e-19,  3.143562034805959e-22, -7.677533911900640e-24,
 -2.687532984865830e-26,  1.386275110885682e+00, -3.911543781873442e-03, -9.647117372189480e-06,  2.785922672222561e-08,  2.723401689456319e-10,  1.008296161616937e-13,
 -7.213200955871576e-15, -2.495787501579696e-17,  1.511963795765377e-19,  1.303117363834894e-21, -1.036953990447794e-24, -4.940063248906244e-26,  1.490563506666734e+00,
 -3.528356441131180e-03, -1.142864195613476e-05,  7.942356233467160e-09,  2.605958172396474e-10,  8.172118201878688e-13, -3.899752186278907e-15, -4.045734833625076e-17,
 -4.656211133628553e-20,  1.140431656082122e-21,  6.532172983196364e-24, -1.167377890014617e-26,  1.589219244136221e+00, -3.064289425114957e-03, -1.222862496194544e-05,
 -1.185116568389476e-08,  1.903010602886137e-10,  1.211755836290554e-12,  8.928071351929506e-16, -3.125178421876765e-17, -1.927073392294267e-19, -7.131261834962220e-24,
  6.512549202484607e-24,  3.603199645755088e-26,  1.680615157392283e+00, -2.543542496110133e-03, -1.196871584125185e-05, -2.786539674263258e-08,  8.277701151967829e-11,
  1.143163952717340e-12,  4.613903397901104e-15, -4.897398180344445e-18, -1.729997784932881e-19, -9.464326614070453e-22, -3.472762012024159e-25,  3.025973607775752e-26,
  1.763156908692140e+00, -1.996014664233520e-03, -1.071261932908625e-05, -3.716615202977399e-08, -2.793510804081028e-11,  6.797028152765232e-13,  5.383391939055388e-15,
  1.864552410613038e-17, -2.744916672227979e-20, -7.856070136981058e-22, -4.935142073879234e-24, -1.076917870393975e-26,  1.835328688878974e+00, -1.455642610745662e-03,
 -8.672918047202006e-06, -3.838942976847811e-08, -1.072028428449424e-10,  7.423515378658193e-14,  3.259254328022687e-15,  2.342033136152839e-17,  9.276832655619515e-20,
  4.643213435786671e-23, -2.515852995559405e-24, -2.244356938732159e-26,  1.895743052925086e+00, -9.580733270347433e-04, -6.191442983286727e-06, -3.225041738010100e-08,
 -1.338000889954306e-10, -3.712745552944369e-13,  1.531857939138347e-16,  1.087950296558075e-17,  8.937349034979759e-20,  4.708436028355376e-22,  1.531375030520643e-24,
 -5.954881746496307e-28,  1.943192161329758e+00, -5.378279480504799e-04, -3.691969918783859e-06, -2.147154297731725e-08, -1.093012707776946e-10, -4.807813595860692e-13,
 -1.698654451208694e-15, -3.420662401292252e-18,  1.247493765408630e-20,  2.056879830529207e-22,  1.570335631165455e-24,  8.950521261678038e-27,  1.976697251174438e+00,
 -2.252322529127086e-04, -1.610845398299183e-06, -1.005416377060235e-08, -5.743156898353321e-11, -3.052023491233920e-13, -1.512302983418883e-15, -6.924348571652246e-18,
 -2.854648070919921e-20, -9.894979644966964e-23, -2.213276484959442e-25,  4.322601313474399e-28,  1.995557294827149e+00, -4.343879892453852e-05, -3.177505679768822e-07,
 -2.059193124863301e-09, -1.245846323426907e-11, -7.199475208610287e-14, -4.020533935533201e-16, -2.183900175158519e-18, -1.158086455646152e-20, -6.006767775678925e-23,
 -3.049453598376865e-25, -1.514630723387166e-27,  1.243203692077822e-03, -9.861928863568632e-06,  5.864026489038811e-08, -3.097256124831521e-10,  1.532221658926234e-12,
 -7.268942212437447e-15,  3.348192159597968e-17, -1.508552121274091e-19,  6.679077728192374e-22, -2.915186614372622e-24,  1.256902176695910e-26, -5.361933290755714e-29,
  1.117791010148354e-02, -8.832046853733885e-05,  5.208319826866947e-07, -2.712185644639714e-09,  1.312834059061896e-11, -6.036622950171991e-14,  2.663775874015378e-16,
 -1.133358256634342e-18,  4.654372945250131e-21, -1.841895886355184e-23,  6.987817506661040e-26, -2.516766127700684e-28,  3.098887484795349e-02, -2.429114224691436e-04,
  1.408607031633666e-06, -7.124026195075584e-09,  3.293049744843908e-11, -1.413015658741006e-13,  5.631368445002605e-16, -2.059128072547542e-18,  6.675248275800250e-21,
 -1.740564851415772e-23,  2.198337719695624e-26,  1.309661799071052e-28,  6.055828352667153e-02, -4.690020825071455e-04,  2.650451903862211e-06, -1.280070601325633e-08,
  5.480684848013065e-11, -2.073156054427966e-13,  6.631711456751836e-16, -1.524906252617146e-18,  1.055158222011145e-22,  2.648166146781521e-23, -2.076919325261693e-25,
  1.128248120286554e-27,  9.970712128650308e-02, -7.596946729790606e-04,  4.143376700497827e-06, -1.872744207395031e-08,  7.109999917127165e-11, -2.119517354202730e-13,
  3.426790345132223e-16,  1.219939422059645e-18, -1.536813850615765e-20,  9.227621629896958e-23, -3.988501831132224e-25,  1.193107459213734e-27,  1.481924296629021e-01,
 -1.105894744420194e-03,  5.758105594480388e-06, -2.373576807182825e-08,  7.425167604075485e-11, -1.216819527611632e-13, -4.529914677384918e-16,  5.457369491702420e-18,
 -3.028572579334283e-20,  1.090539233958632e-22, -1.636589679813421e-25, -1.160655722425181e-27,  2.057036696836714e-01, -1.496413902951459e-03,  7.346062332870820e-06,
 -2.664848363021504e-08,  5.860188369097539e-11,  6.892980018573464e-14, -1.527853970977412e-15,  8.914068573229163e-18, -2.928242121169969e-20,  9.809208668422343e-24,
  5.937905341982870e-25, -4.498527544130221e-27,  2.718582216812317e-01, -1.918116949407575e-03,  8.748153787785632e-06, -2.644278983636495e-08,  2.206479287322232e-11,
  3.281786480954360e-13, -2.450944495484496e-15,  8.662703088120094e-18, -1.809048150636599e-21, -1.888838468465864e-22,  1.309495155200352e-24, -4.227248324687456e-27,
  3.461960768232309e-01, -2.356126111294769e-03,  9.805284879665466e-06, -2.241756615042595e-08, -3.265848147606007e-11,  5.883344518129677e-13, -2.688401334327567e-15,
  2.794975590472957e-18,  4.607816958857622e-20, -3.505621957149325e-22,  1.013713083467090e-24,  2.737325145755443e-27,  4.281738128411538e-01, -2.794097478249734e-03,
  1.037041559613234e-05, -1.434651552310651e-08, -9.767409045467210e-11,  7.591817554055230e-13, -1.828714738226821e-15, -7.869242416162060e-18,  8.785522830046192e-20,
 -2.865217495661796e-22, -7.171541368134105e-25,  1.192654451570843e-26,  5.171580007548724e-01, -3.214586679846392e-03,  1.032178163936012e-05, -2.594803191918963e-09,
 -1.605853713703411e-10,  7.532027107363802e-13,  1.706667390953376e-16, -1.908658806424345e-17,  8.756074036891054e-20,  8.261089953005039e-23, -2.847175576934364e-24,
  1.201599086678867e-26,  6.124182649265116e-01, -3.599521757076550e-03,  9.576633681289654e-06,  1.182620239610665e-08, -2.064302494642911e-10,  5.175986265756777e-13,
  2.824760714569137e-15, -2.439390399459529e-17,  2.424717381359004e-20,  5.819505584495496e-22, -3.174670487822141e-24, -3.711035630328465e-27,  7.131203199168633e-01,
 -3.930800305628214e-03,  8.104504000997574e-06,  2.729190840367364e-08, -2.207827241592657e-10,  6.413250210385459e-14,  5.163784012571439e-15, -1.829601672901993e-17,
 -8.347780411533602e-20,  8.138034410334128e-22, -2.693530713441748e-25, -2.431395427658725e-26,  8.183194379917125e-01, -4.191024245620394e-03,  5.938598505222774e-06,
  4.170681394454127e-08, -1.936046701063742e-10, -5.151806285767677e-13,  6.039437818311946e-15, -2.356157440386869e-19, -1.736536476998873e-19,  4.375616236719396e-22,
  4.319212669709422e-24, -2.511342729489539e-26,  9.269549622569684e-01, -4.364377644840692e-03,  3.183481647745180e-06,  5.276658293908820e-08, -1.230495885580244e-10,
 -1.058200716607176e-12,  4.644883020181111e-15,  2.303380246814298e-17, -1.723428200194197e-19, -4.550314660982995e-22,  6.256738659157272e-24,  5.250636278120287e-27,
  1.037846669602149e+00, -4.437639351287761e-03,  1.686079760396511e-08,  5.833007098594416e-08, -1.807930443100710e-11, -1.374697469422051e-12,  1.051923250710548e-15,
  3.915490814011321e-17, -5.064658344129719e-20, -1.226483690634193e-21,  2.295408288517301e-24,  4.059180532084037e-26,  1.149693995028397e+00, -4.401301327355845e-03,
 -3.316868789030095e-06,  5.686179114689051e-08,  1.013786145342768e-10, -1.314744644230220e-12, -3.541436524391602e-15,  3.663800741716983e-17,  1.323373702930453e-19,
 -1.118662250364746e-21, -5.145351270235005e-24,  3.589860341764817e-26,  1.261079333735132e+00, -4.250734700025264e-03, -6.523383074432360e-06,  4.786901577777158e-08,
  2.077255536660572e-10, -8.423460117474065e-13, -7.132032741070925e-15,  1.328914664325063e-17,  2.491722184425585e-19, -1.302450117859874e-23, -8.602220992473139e-24,
 -1.463294869301250e-26,  1.370476803883784e+00, -3.987309310429300e-03, -9.286626540639608e-06,  3.222316893862866e-08,  2.725719966930361e-10, -8.008337301786464e-14,
 -7.837315168814904e-15, -1.938134487061209e-17,  1.968243774106970e-19,  1.216709775731716e-21, -3.312211896075678e-24, -5.333438816917113e-26,  1.476267927912509e+00,
 -3.619332254418233e-03, -1.130779465420305e-05,  1.223717024387707e-08,  2.759116531513716e-10,  7.098954388729602e-13, -5.046893260005896e-15, -4.124127296787906e-17,
 -9.652844155994527e-22,  1.387237766325027e-21,  5.700997078672461e-24, -2.636369358262026e-26,  1.576765603259411e+00, -3.162633670970173e-03, -1.235176736136598e-05,
 -8.611613603506788e-09,  2.146759761506879e-10,  1.221987414688056e-12, -6.823808419242836e-17, -3.736918904894038e-17, -1.878994145038066e-19,  2.843106878805333e-22,
  8.033094296573399e-24,  3.238531083018034e-26,  1.670247404310404e+00, -2.640605470117047e-03, -1.229438018708587e-05, -2.635210007734451e-08,  1.067331533443468e-10,
  1.251595031123077e-12,  4.394147115989975e-15, -1.097843132425666e-17, -2.069728336007478e-19, -9.306471514055429e-22,  1.212808004758273e-24,  4.071391786496709e-26,
  1.754998614191945e+00, -2.083506112883846e-03, -1.116082310055890e-05, -3.749716599345163e-08, -1.300737851484911e-11,  8.150423456915379e-13,  5.888641082559858e-15,
  1.727569718107222e-17, -5.938578138319745e-20, -9.910506612781691e-22, -5.296259290207770e-24, -5.159190493161731e-27,  1.829364393169611e+00, -1.526897665344086e-03,
 -9.143819291278483e-06, -4.008831855248422e-08, -1.048810638981751e-10,  1.606627398921624e-13,  3.956685002428490e-15,  2.639421819015338e-17,  9.237667981052047e-20,
 -7.547098123383613e-23, -3.617251614015255e-24, -2.764678286096273e-26,  1.891809193376515e+00, -1.009189847060489e-03, -6.591536897100877e-06, -3.445031338673649e-08,
 -1.411624025911809e-10, -3.636033260431660e-13,  5.004831591406163e-16,  1.402238281744899e-17,  1.074126175412408e-19,  5.307306061958439e-22,  1.439720927384680e-24,
 -3.794598798612094e-27,  1.940980103228095e+00, -5.684248167460405e-04, -3.960445934144539e-06, -2.329953503380133e-08, -1.193320692925230e-10, -5.226460044740230e-13,
 -1.787639982198457e-15, -2.890060537919938e-18,  2.111049474412637e-20,  2.769569019684433e-22,  2.007931587388865e-24,  1.098493023844262e-26,  1.975769761838072e+00,
 -2.386177144016194e-04, -1.737216800367005e-06, -1.102394111295122e-08, -6.391482076759839e-11, -3.439307773860198e-13, -1.719521004767317e-15, -7.896493296678495e-18,
 -3.226202781378980e-20, -1.072633399972071e-22, -1.899599805744263e-25,  1.036463301616181e-27,  1.995378294190938e+00, -4.608314638493761e-05, -3.437061714344727e-07,
 -2.270593545146503e-09, -1.400002939542586e-11, -8.242178600152117e-14, -4.687334829869070e-16, -2.591577848959299e-18, -1.397991820171047e-20, -7.370903174669033e-23,
 -3.800337725711419e-25, -1.914774706245599e-27,  1.204671255870232e-03, -9.407267581644572e-06,  5.506599092353456e-08, -2.863308301674651e-10,  1.394548418880075e-12,
 -6.513741903349074e-15,  2.954208733074093e-17, -1.310687081949992e-19,  5.714700596381357e-22, -2.456578819454088e-24,  1.043251673015391e-26, -4.384287131906788e-29,
  1.083276033603594e-02, -8.428051623042921e-05,  4.895073303464229e-07, -2.511453929973116e-09,  1.198246061456121e-11, -5.433773949048408e-14,  2.366327559546762e-16,
 -9.945091489093396e-19,  4.039039090061911e-21, -1.583384349109088e-23,  5.965054354067204e-26, -2.141877518079294e-28,  3.003923781262811e-02, -2.319757724812012e-04,
  1.326189112171664e-06, -6.619031331982653e-09,  3.023507118423088e-11, -1.284545835969355e-13,  5.083788399018915e-16, -1.855365944587630e-18,  6.065689061524523e-21,
 -1.642973438059980e-23,  2.638672023772649e-26,  7.243853971032310e-29,  5.872373021080664e-02, -4.483983032754396e-04,  2.501970822466737e-06, -1.195611665877728e-08,
  5.081624446753649e-11, -1.919106590114440e-13,  6.206534716126160e-16, -1.507786617152118e-18,  9.206720664399858e-22,  1.910049567110442e-23, -1.629360202353471e-25,
  9.126486125763737e-28,  9.673324021756828e-02, -7.274275566045821e-04,  3.925334584271667e-06, -1.762329685913362e-08,  6.694569968654604e-11, -2.033701482191159e-13,
  3.704304486409921e-16,  7.783327115900779e-19, -1.232086119517734e-20,  7.735557220061881e-23, -3.476572570243904e-25,  1.128163933668423e-27,  1.438592047206233e-01,
 -1.060949208620133e-03,  5.480322452308145e-06, -2.256775103860737e-08,  7.172114558932166e-11, -1.308260049099184e-13, -3.131724640562583e-16,  4.549688016372090e-18,
 -2.648841456001035e-20,  1.016499810908117e-22, -2.027694735370771e-25, -6.427037369895435e-28,  1.998335484098935e-01, -1.438908499547465e-03,  7.031945577454639e-06,
 -2.570173408205853e-08,  5.963346657074797e-11,  3.515102757173364e-14, -1.291294972359004e-15,  7.986893538414886e-18, -2.854712063980746e-20,  2.985828426277277e-23,
  4.148611942045597e-25, -3.647977376198360e-27,  2.643237237970708e-01, -1.849394492917943e-03,  8.433164999865618e-06, -2.604035832406405e-08,  2.805972698437502e-11,
  2.722541762648262e-13, -2.210151547180727e-15,  8.505759484291596e-18, -7.711203803309284e-21, -1.402579460222278e-22,  1.121492317155106e-24, -4.271202818866046e-27,
  3.369267418107488e-01, -2.278767886903630e-03,  9.533515896168435e-06, -2.284944455781456e-08, -2.152985709470283e-11,  5.249071741043238e-13, -2.591339258767850e-15,
  4.075578699579522e-18,  3.421140580139489e-20, -3.081933109912295e-22,  1.091091734839130e-24,  8.640439323351588e-28,  4.171622232371203e-01, -2.711848215464139e-03,
  1.018937384143309e-05, -1.579028585701839e-08, -8.294559357252979e-11,  7.129565165903125e-13, -2.011278770735632e-15, -5.227463232626333e-18,  7.714422745728941e-20,
 -3.054092784363837e-22, -2.445491512523677e-25,  9.550873980809193e-27,  5.044645451820587e-01, -3.132179511070600e-03,  1.027572515738494e-05, -5.043610130983797e-09,
 -1.455220003024432e-10,  7.512042265464069e-13, -3.242340673455066e-16, -1.625799142817562e-17,  8.861439174047474e-20, -2.047499936404588e-23, -2.303430689419614e-24,
  1.252666236943946e-26,  5.981742246252887e-01, -3.522396369403501e-03,  9.699083722763810e-06,  8.609587259617034e-09, -1.954551276701743e-10,  5.773026853462536e-13,
  2.155567526351729e-15, -2.330752613330448e-17,  4.288628435226174e-20,  4.532216078422998e-22, -3.225944164794643e-24,  1.205921811316210e-27,  6.975287803453892e-01,
 -3.864714174574446e-03,  8.410875411362507e-06,  2.377620032855290e-08, -2.183037069133611e-10,  1.816409467585641e-13,  4.618475251004502e-15, -2.050264508042632e-17,
 -5.462000157534017e-20,  7.830339385390056e-22, -1.232889188590875e-24, -1.934938718759651e-26,  8.016534529909445e-01, -4.141566922944318e-03,  6.420179682702760e-06,
  3.853457240658253e-08, -2.024625312868772e-10, -3.709255268343054e-13,  5.957636751814146e-15, -5.509371243196461e-18, -1.550663893773906e-19,  5.873342918871021e-22,
  3.151863733508413e-24, -2.752652351768492e-26,  9.095523483234393e-01, -4.336412033236871e-03,  3.804189661801891e-06,  5.063474222800300e-08, -1.430498689590212e-10,
 -9.396207596202232e-13,  5.210503353807027e-15,  1.730530311358423e-17, -1.841914906458771e-19, -2.032129264369659e-22,  6.259685415932063e-24, -4.963438789744213e-27,
  1.020100805371273e+00, -4.434711617863228e-03,  7.141841886432898e-07,  5.782259117213293e-08, -4.523310593549727e-11, -1.336518479752861e-12,  2.119079386340084e-15,
  3.684888075834192e-17, -9.273176587199646e-20, -1.100628530959512e-21,  3.950017280445129e-24,  3.410589588124338e-26,  1.132040077573473e+00, -4.425081363359862e-03,
 -2.625676666079224e-06,  5.826922871643857e-08,  7.431918218283132e-11, -1.386988770169885e-12, -2.462603869647079e-15,  4.019198503714979e-17,  8.876618445372932e-20,
 -1.290226441970856e-21, -3.373137443475015e-24,  4.408283197419388e-26,  1.243975736854321e+00, -4.300568890607468e-03, -5.929598921381132e-06,  5.104869179760292e-08,
  1.892017313156736e-10, -1.008151471650807e-12, -6.648857508001412e-15,  2.118773654348718e-17,  2.423927165890310e-19, -3.657701647143696e-22, -8.926904861005319e-24,
  1.938348504588305e-28,  1.354381534000723e+00, -4.059981660048986e-03, -8.873868033750918e-06,  3.656111648969748e-08,  2.690492630051605e-10, -2.739399075720922e-13,
 -8.285439649179374e-15, -1.241231652382474e-17,  2.376735419738001e-19,  1.037134138828540e-21, -5.661267708705326e-24, -5.259461871020466e-26,  1.461610711521778e+00,
 -3.709131145174090e-03, -1.113401495126064e-05,  1.675836674192472e-08,  2.888049556520427e-10,  5.749570998365224e-13, -6.194274317445141e-15, -4.043164299059671e-17,
  5.275892753434496e-20,  1.587514512874210e-21,  4.199514671500722e-24, -4.189568550078784e-26,  1.563916870696612e+00, -3.261800920421174e-03, -1.243369260860620e-05,
 -4.981736816454043e-09,  2.390111309424834e-10,  1.207125950274216e-12, -1.196757909596390e-15, -4.315352217065123e-17, -1.715552703855827e-19,  6.320564208781121e-22,
  9.293929237968442e-24,  2.410228031199732e-26,  1.659486313127259e+00, -2.740194441923013e-03, -1.259951471053679e-05, -2.443850282296585e-08,  1.327907524262517e-10,
  1.352586863092494e-12,  3.989078504015318e-15, -1.812456310026097e-17, -2.391431160910884e-19, -8.432333525341261e-22,  3.232649996584911e-24,  5.095647401798691e-26,
  1.746483163488516e+00, -2.174594810110710e-03, -1.161147456012499e-05, -3.756703832178137e-08,  4.744668493720986e-12,  9.619251902996337e-13,  6.340098792244563e-15,
  1.476331198416421e-17, -9.891062272715708e-20, -1.205085829164064e-21, -5.340893567884046e-24,  3.719985681092623e-27,  1.823107414778779e+00, -1.602000707614052e-03,
 -9.634824244654261e-06, -4.173529277904549e-08, -1.006566307615022e-10,  2.648221018653513e-13,  4.736486088722806e-15,  2.927640424156381e-17,  8.674818848207531e-20,
 -2.460177307027354e-22, -4.947246483823042e-24, -3.273714815241915e-26,  1.887664296245263e+00, -1.063614701198394e-03, -7.018729730471739e-06, -3.676629501948346e-08,
 -1.482804667295591e-10, -3.464737634059173e-13,  9.441800352723206e-16,  1.777600155895578e-17,  1.275038948248226e-19,  5.837055338914914e-22,  1.174354374369248e-24,
 -8.562204830599274e-27,  1.938641219171367e+00, -6.012600299210702e-04, -4.251848802157830e-06, -2.529482860213132e-08, -1.302201419321057e-10, -5.664342978144711e-13,
 -1.857489101809450e-15, -2.038511988710737e-18,  3.264907517828433e-20,  3.675960884602292e-22,  2.540629459102677e-24,  1.326277513178195e-26,  1.974786632440791e+00,
 -2.530625205336941e-04, -1.875874384642708e-06, -1.210392674464919e-08, -7.122464883998894e-11, -3.879727807140670e-13, -1.955666584851246e-15, -8.992025067566938e-18,
 -3.624711593465434e-20, -1.137060540072678e-22, -1.254995719837634e-25,  1.955222624660592e-27,  1.995188284195205e+00, -4.894572163309532e-05, -3.723537447793434e-07,
 -2.508418343457260e-09, -1.576711090671567e-11, -9.459527211679326e-14, -5.479814915714365e-16, -3.084498604109452e-18, -1.692864719234657e-20, -9.073717500562079e-23,
 -4.751060782676160e-25, -2.427799835200332e-27,  1.167902003016287e-03, -8.980113873588915e-06,  5.175972000376748e-08, -2.650229429035407e-10,  1.271076761007763e-12,
 -5.846783384471423e-15,  2.611544016880131e-17, -1.141197412107470e-19,  4.901022050021287e-22, -2.075415527367389e-24,  8.683051925575665e-27, -3.595523139062129e-29,
  1.050328401274241e-02, -8.048182878158092e-05,  4.604853107834134e-07, -2.328129240895340e-09,  1.095031544447380e-11, -4.897861393462026e-14,  2.105134758600834e-16,
 -8.739375303593846e-19,  3.509787667501030e-21, -1.362651872899088e-23,  5.094859276130858e-26, -1.821990354854044e-28,  2.913206206028155e-02, -2.216759401784959e-04,
  1.249580623061632e-06, -6.155177275804004e-09,  2.778389352732459e-11, -1.168554999616399e-13,  4.590585888272575e-16, -1.670518297354925e-18,  5.493862431092185e-21,
 -1.532378546078735e-23,  2.860958251821349e-26,  3.102199725985595e-29,  5.696927900138424e-02, -4.289428947938511e-04,  2.363251703576144e-06, -1.117296740713461e-08,
  4.712358820441703e-11, -1.775176705759993e-13,  5.789427497263875e-16, -1.468505891227906e-18,  1.500147664152373e-21,  1.333110638811211e-23, -1.268338716756913e-25,
  7.340167216651128e-28,  9.388502127752625e-02, -6.968528949000276e-04,  3.720149167918859e-06, -1.658421520634718e-08,  6.296874561357763e-11, -1.942603703183036e-13,
  3.871040871237298e-16,  4.260336517848255e-19, -9.774639405761998e-21,  6.441666783484196e-23, -2.999515058464633e-25,  1.037272834217519e-27,  1.397014051719572e-01,
 -1.018170574200459e-03,  5.216307116109266e-06, -2.144151161431382e-08,  6.903930191735128e-11, -1.369059068934693e-13, -1.971093238685984e-16,  3.758995834925413e-18,
 -2.298071125778798e-20,  9.309405800087023e-23, -2.222752707678168e-25, -2.644768967231956e-28,  1.941884951655171e-01, -1.383870355001151e-03,  6.729267529823244e-06,
 -2.474358410931010e-08,  6.004416172217461e-11,  6.741418271447929e-15, -1.080268386063584e-15,  7.093486761039367e-18, -2.721009258107140e-20,  4.347318452996732e-23,
  2.714150899595808e-25, -2.888712329030152e-27,  2.570591086955976e-01, -1.783171082371109e-03,  8.123545005763327e-06, -2.555064364534173e-08,  3.299350239374382e-11,
  2.220362255440991e-13, -1.976144368354367e-15,  8.186504970864072e-18, -1.199794607473125e-20, -9.911439502000195e-23,  9.370896485965658e-25, -4.079768746233616e-27,
  3.279624627167257e-01, -2.203601613087889e-03,  9.257591299202642e-06, -2.311327533302260e-08, -1.164379468159388e-11,  4.641981855236248e-13, -2.463503937197112e-15,
  5.001294839468115e-18,  2.390711323325492e-20, -2.642309301372325e-22,  1.096934608698358e-24, -5.226642118654104e-28,  4.064766298509166e-01, -2.631112653228053e-03,
  9.992389565644981e-06, -1.700600989640742e-08, -6.917962765382849e-11,  6.631981449263608e-13, -2.124748905730254e-15, -2.935871151603624e-18,  6.606838885929067e-20,
 -3.074773823490088e-22,  1.242831245929092e-25,  7.238098529399104e-27,  4.920998010465203e-01, -3.050254246743429e-03,  1.020172573995253e-05, -7.252341286732666e-09,
 -1.306109541661594e-10,  7.382790632626329e-13, -7.399899380401208e-16, -1.345083142116994e-17,  8.635119868080479e-20, -1.016504322581870e-22, -1.758312223910818e-24,
  1.212300984272012e-26,  5.842404049396914e-01, -3.444442708555236e-03,  9.784024603357176e-06,  5.577265593325592e-09, -1.834437370227977e-10,  6.213742435204683e-13,
  1.524446094065250e-15, -2.169883634903262e-17,  5.690346133124860e-20,  3.264468088318849e-22, -3.085141014044857e-24,  5.002381850631228e-27,  6.822062212283743e-01,
 -3.796344978036415e-03,  8.675371509757693e-06,  2.031822765252423e-08, -2.136098654926952e-10,  2.854236251783864e-13,  4.024092170205609e-15, -2.181054584532131e-17,
 -2.750917320183752e-20,  7.182840355871221e-22, -1.964715145938106e-24, -1.388126336503235e-26,  7.851927583758612e-01, -4.088411409449865e-03,  6.862938335756135e-06,
  3.524353030108873e-08, -2.084665162535604e-10, -2.303337654902654e-13,  5.737242957282894e-15, -1.011124070191538e-17, -1.319466700482986e-19,  6.890245889152055e-22,
  1.932821742279285e-24, -2.750928468486248e-26,  8.922713587078860e-01, -4.303588341191039e-03,  4.397476061727472e-06,  4.820255219350627e-08, -1.605559795251772e-10,
 -8.094251793208609e-13,  5.611775506071009e-15,  1.134185658717234e-17, -1.870778994224039e-19,  4.007499460041110e-23,  5.840153336673759e-24, -1.381610058076789e-26,
  1.002377760340579e+00, -4.426236975222355e-03,  1.402840696323724e-06,  5.688812611090545e-08, -7.137320735098167e-11, -1.273650119708296e-12,  3.103581301316276e-15,
  3.328078353621772e-17, -1.291714492160719e-19, -9.151435210036180e-22,  5.257611593601815e-24,  2.497596593195897e-26,  1.114302195489860e+00, -4.443271766057512e-03,
 -1.920236036460596e-06,  5.923359403714128e-08,  4.608101092955487e-11, -1.432309530819130e-12, -1.304606928582957e-15,  4.226718565554992e-17,  4.037167084308045e-20,
 -1.384787386729357e-21, -1.323508657528856e-24,  4.838638539919600e-26,  1.226682537973195e+00, -4.345505469555824e-03, -5.299544129641762e-06,  5.390616244938076e-08,
  1.674954991146224e-10, -1.159743105623685e-12, -5.949478366773476e-15,  2.866499972874408e-17,  2.228421572732359e-19, -7.180016770153974e-22, -8.568139433673603e-24,
  1.616573103512236e-26,  1.338002506793720e+00, -4.129144976433225e-03, -8.409521989378130e-06,  4.081116782170137e-08,  2.615583901969539e-10, -4.760687440412433e-13,
 -8.521231244483763e-15, -4.257529283144864e-18,  2.703885866596002e-19,  7.658010494648307e-22, -7.860745081312352e-24, -4.646370791102101e-26,  1.446597428322634e+00,
 -3.797319488670363e-03, -1.090483700949172e-05,  2.146278104458532e-08,  2.987269868115641e-10,  4.129541323923352e-13, -7.293923755776141e-15, -3.780040246847693e-17,
  1.124481794378454e-19,  1.714183052493025e-21,  2.026928474259047e-24, -5.655149672144847e-26,  1.550670443505234e+00, -3.361442751021009e-03, -1.246973788254857e-05,
 -9.664008290522691e-10,  2.627654485518906e-10,  1.163307470667433e-12, -2.477970056369219e-15, -4.820560961947138e-17, -1.418859234312802e-19,  1.021446303370818e-21,
  1.007757398403068e-23,  1.064877948379473e-26,  1.648322139541667e+00, -2.842125399851690e-03, -1.287911978465469e-05, -2.209242358079366e-08,  1.607541774942149e-10,
  1.441343107061033e-12,  3.370095182505190e-15, -2.623333868939849e-17, -2.666067501313130e-19, -6.663806533407420e-22,  5.672713527686230e-24,  5.953917160232231e-26,
  1.737596149378328e+00, -2.269287017371909e-03, -1.206116151322441e-05, -3.732881452236054e-08,  2.553625532210836e-11,  1.118648824809401e-12,  6.702346514737800e-15,
  1.086333172727213e-17, -1.460688569004710e-19, -1.412003714805198e-21, -4.912638368313297e-24,  1.640537827673342e-26,  1.816542044808976e+00, -1.681109530164908e-03,
 -1.014511523018500e-05, -4.329696672098544e-08, -9.415545195698796e-11,  3.886387009700985e-13,  5.593468128854281e-15,  3.186954803642865e-17,  7.397003903493068e-20,
 -4.740559841442802e-22, -6.485593342508554e-24, -3.696582688179624e-26,  1.883294685903469e+00, -1.121570171256353e-03, -7.474384397072678e-06, -3.919280930442375e-08,
 -1.549405565153238e-10, -3.173599316329832e-13,  1.502248685478429e-15,  2.220056286751042e-17,  1.492556035935706e-19,  6.213094520114294e-22,  6.564449607273209e-25,
 -1.535203589265010e-26,  1.936166175904276e+00, -6.365252687937766e-04, -4.568269619235997e-06, -2.747141964539032e-08, -1.419985839365501e-10, -6.115679592393187e-13,
 -1.897804567241337e-15, -7.612089460555741e-19,  4.785885154141257e-20,  4.815994966724675e-22,  3.177178651751552e-24,  1.568120293140028e-26,  1.973743420320906e+00,
 -2.686704839208431e-04, -2.028223634321540e-06, -1.330823497114423e-08, -7.947455189549647e-11, -4.380649811506337e-13, -2.224303201789956e-15, -1.021820692196264e-17,
 -4.040690548990712e-20, -1.166408623529599e-22, -1.129558442237285e-26,  3.323654880582643e-27,  1.994986346758791e+00, -5.204939290369257e-05, -4.040332380734685e-07,
 -2.776572435088958e-09, -1.779785721533020e-11, -1.088475882172047e-13, -6.424499682597745e-16, -3.682367372166225e-18, -2.056464406619094e-20, -1.120600044673940e-22,
 -5.958326432011475e-25, -3.087149172352227e-27,  1.132790037947131e-03, -8.578420153067148e-06,  4.869771659895533e-08, -2.455882009319891e-10,  1.160158849946319e-12,
 -5.256651558307943e-15,  2.312888163990480e-17, -9.956785102503895e-20,  4.212759519193758e-22, -1.757757280933097e-24,  7.246318215420484e-27, -2.957180499210169e-29,
  1.018855163373162e-02, -7.690679071749689e-05,  4.335675313034661e-07, -2.160494359663170e-09,  1.001934802710603e-11, -4.420768172115783e-14,  1.875445790461919e-16,
 -7.690950521316193e-19,  3.054060431544344e-21, -1.174057339257469e-23,  4.354693844805366e-26, -1.549667457465761e-28,  2.826489423570479e-02, -2.119673602929438e-04,
  1.178310521356883e-06, -5.728748799336272e-09,  2.555326938910897e-11, -1.063800239496160e-13,  4.146639818583251e-16, -1.503318233624465e-18,  4.963048338178038e-21,
 -1.416135093344948e-23,  2.930336481753877e-26,  2.303947704777864e-30,  5.529048804974992e-02, -4.105606309758415e-04,  2.233585204997631e-06, -1.044665175904552e-08,
  4.370888027539159e-11, -1.641106280763742e-13,  5.385621702197442e-16, -1.413741191014113e-18,  1.896113690914897e-21,  8.858320880884025e-24, -9.787463750528861e-26,
  5.871336035558836e-28,  9.115589547911046e-02, -6.678709083663453e-04,  3.527057017914331e-06, -1.560728870546385e-08,  5.917723556229652e-11, -1.848600078716243e-13,
  3.949866129446936e-16,  1.481210627321470e-19, -7.660875972873180e-21,  5.330154959051819e-23, -2.565575594249959e-25,  9.340090156948787e-28,  1.357105804689690e-01,
 -9.774507407341094e-04,  4.965545653498595e-06, -2.035901042963834e-08,  6.626198639660160e-11, -1.404535714516019e-13, -1.016613138208352e-16,  3.075501804460640e-18,
 -1.979137331674709e-20,  8.405613242235768e-23, -2.276771550328360e-25,  2.807561412392794e-30,  1.887588245729370e-01, -1.331207573364758e-03,  6.438108826615519e-06,
 -2.378314178578534e-08,  5.993531159086597e-11, -1.689848806245150e-14, -8.935920426475432e-16,  6.249663227190679e-18, -2.547842923946714e-20,  5.198850941916140e-23,
  1.591312044071842e-25, -2.232421605994396e-27,  2.500544723311322e-01, -1.719399857850542e-03,  7.820243065905316e-06, -2.498972158797383e-08,  3.697828195552014e-11,
  1.773129949064262e-13, -1.752784146476394e-15,  7.752369331934447e-18, -1.493380253003060e-20, -6.512933360809272e-23,  7.646419383446908e-25, -3.740539323501053e-27,
  3.192944175492769e-01, -2.130652802069654e-03,  8.979410289476801e-06, -2.322846768935153e-08, -2.939318403001952e-12,  4.068324861304733e-13, -2.314127293098343e-15,
  5.622529605600486e-18,  1.517616425303449e-20, -2.211247602986278e-22,  1.051386963884680e-24, -1.483122589819545e-27,  3.961107397555503e-01, -2.552007652098093e-03,
  9.782104872163597e-06, -1.800956669013290e-08, -5.643107159213814e-11,  6.114464428607381e-13, -2.179008468886719e-15, -9.972458649474110e-19,  5.515958891684108e-20,
 -2.967757042897423e-22,  3.954256581732012e-25,  5.128373649118729e-27,  4.800614118097076e-01, -2.969022964083213e-03,  1.010264279491257e-05, -9.225079332264807e-09,
 -1.160518792740970e-10,  7.163082302743902e-13, -1.078568822256118e-15, -1.075868996757776e-17,  8.155195456766569e-20, -1.615857132044609e-22, -1.246131585391431e-24,
  1.107252712906565e-26,  5.706195331891851e-01, -3.365951743282492e-03,  9.833757182752123e-06,  2.743370817417644e-09, -1.706984916227775e-10,  6.508859227369639e-13,
  9.439711073037226e-16, -1.971322594889078e-17,  6.649526277322899e-20,  2.083026121373244e-22, -2.802860393745436e-24,  7.640953406609342e-27,  6.671611100331677e-01,
 -3.726024366015503e-03,  8.898888500871177e-06,  1.695117587526888e-08, -2.069854919525939e-10,  3.745973436230296e-13,  3.404845549565539e-15, -2.229337311139117e-17,
 -3.198007871376394e-21,  6.290947457519500e-22, -2.455236084781510e-24, -8.462970260361613e-27,  7.689515178076105e-01, -4.031873218214912e-03,  7.265719844610671e-06,
  3.187858945873599e-08, -2.117215523516319e-10, -9.649103552999741e-14,  5.398837903838558e-15, -1.392407629725983e-17, -1.060377683828863e-19,  7.426055758046175e-22,
  7.613509790042296e-25, -2.544131697618395e-26,  8.751309651389757e-01, -4.266139663714933e-03,  4.959983063331719e-06,  4.551156208425464e-08, -1.753754183459318e-10,
 -6.716052639840612e-13,  5.846067375337540e-15,  5.422211032537150e-18, -1.815968256078569e-19,  2.593546963126910e-22,  5.074238587227304e-24, -2.061918851727869e-26,
  9.846995514637056e-01, -4.412304941227940e-03,  2.077819726846466e-06,  5.554672589863028e-08, -9.602840710314725e-11, -1.188477849490208e-12,  3.972922608648785e-15,
  2.866273028920671e-17, -1.580941563808739e-19, -6.859373998769586e-22,  6.124550983049512e-24,  1.426586317393078e-26,  1.096502901215477e+00, -4.455780093957234e-03,
 -1.205958861432232e-06,  5.974042389698984e-08,  1.721813462542895e-11, -1.449318664014984e-12, -1.105822893837182e-16,  4.275541282739096e-17, -9.917170292746267e-21,
 -1.394843491447213e-21,  8.202559819115243e-25,  4.832593325501198e-26,  1.209219882189618e+00, -4.385270579820561e-03, -4.637380393561490e-06,  5.639306047776211e-08,
  1.429418290508377e-10, -1.292119558147416e-12, -5.051373072120940e-15,  3.531790402498788e-17,  1.910388052496095e-19, -1.041867393187747e-21, -7.512819387993441e-24,
  3.155961813714247e-26,  1.321354575578194e+00, -4.194391868355756e-03, -7.895028636844958e-06,  4.490879674315059e-08,  2.499874166488552e-10, -6.810078905086169e-13,
 -8.515618433948436e-15,  4.771497023547384e-18,  2.918318980088122e-19,  4.135149364412232e-22, -9.668926590037729e-24, -3.485408999033326e-26,  1.431235419605903e+00,
 -3.883446153373920e-03, -1.061836507008024e-05,  2.629862240852395e-08,  3.051521414807864e-10,  2.256630948982594e-13, -8.292598840051717e-15, -3.320413922649843e-17,
  1.749839793070820e-19,  1.741756835549624e-21, -7.339261904869863e-25, -6.828196445447872e-26,  1.537025186452501e+00, -3.461173824199476e-03, -1.245535316859085e-05,
  3.420276584785160e-09,  2.853250576354662e-10,  1.087162821097481e-12, -3.885205434024898e-15, -5.207918967106590e-17, -9.779097370742942e-20,  1.428810066028221e-21,
  1.015533587051841e-23, -7.911122668007852e-27,  1.636745957653938e+00, -2.946172851242831e-03, -1.312783166957300e-05, -1.928561459287781e-08,  1.903252949738237e-10,
  1.512426467900273e-12,  2.512857897971204e-15, -3.509955798008964e-17, -2.858636805970330e-19, -3.852629968431477e-22,  8.420248249147202e-24,  6.459552403230033e-26,
  1.728323197854525e+00, -2.367559389112118e-03, -1.250588892968335e-05, -3.673241746363559e-08,  4.953949915946330e-11,  1.282578750742608e-12,  6.933178304091413e-15,
  5.339572023409536e-18, -2.002224857513686e-19, -1.589441983532905e-21, -3.837454017884847e-24,  3.312688328630825e-26,  1.809651958959854e+00, -1.764373677048171e-03,
 -1.067343678577509e-05, -4.473366988756353e-08, -8.496665679160293e-11,  5.338399409845655e-13,  6.516012795227828e-15,  3.391022845062240e-17,  5.183433408003036e-20,
 -7.668625074289489e-22, -8.171324146260419e-24, -3.921949734943362e-26,  1.878685776298780e+00, -1.183289113681315e-03, -7.959774912771303e-06, -4.172045553993374e-08,
 -1.608739870499984e-10, -2.732860527931241e-13,  2.194121237815450e-15,  2.733821478387123e-17,  1.719098353891852e-19,  6.315206994576435e-22, -2.134806428342593e-25,
 -2.464021709480644e-26,  1.933544838913981e+00, -6.744296231895644e-04, -4.911970182058039e-06, -2.984372651817187e-08, -1.546861769688372e-10, -6.571810463961790e-13,
 -1.894888337950612e-15,  1.073595534755136e-18,  6.765674104469327e-20,  6.231928124918851e-22,  3.919645978816298e-24,  1.803130867522390e-26,  1.972635243960766e+00,
 -2.855573705490164e-04, -2.195850801533955e-06, -1.465291864553271e-08, -8.879363075593813e-11, -4.950315622998067e-13, -2.529145362889111e-15, -1.157818306937183e-17,
 -4.457407289317970e-20, -1.136314957267447e-22,  1.763409953394760e-25,  5.329140412159666e-27,  1.994771466576279e+00, -5.541994637314548e-05, -4.391353538179672e-07,
 -3.079627962804417e-09, -2.013774933212294e-11, -1.255819234941413e-13, -7.554100846513238e-16, -4.409861811773143e-18, -2.506264806898192e-20, -1.388444570351093e-22,
 -7.495689358353255e-25, -3.936413855604749e-27,  1.099237291305067e-03, -8.200318889472746e-06,  4.585865921815463e-08, -2.278374847295881e-10,  1.060358562260886e-12,
 -4.733546394252713e-15,  2.052058503317647e-17, -8.704599472109257e-20,  3.629152025419010e-22, -1.492324266938501e-24,  6.063044273910539e-27, -2.439021501409884e-29,
  9.887701114586698e-03, -7.353929457602873e-05,  4.085750519783840e-07, -2.007020590159768e-09,  9.178516243837440e-12, -3.995436312043189e-14,  1.673169183716820e-16,
 -6.778044136519003e-19,  2.661175351770701e-21, -1.012797890988112e-23,  3.725128459970788e-26, -1.318224955063062e-28,  2.743545198157605e-02, -2.028090638295483e-04,
  1.111950152010989e-06, -5.336390565776974e-09,  2.352186951994680e-11, -9.691571990628813e-14,  3.747194878252571e-16, -1.352431592436020e-18,  4.474304276853359e-21,
 -1.299347141665186e-23,  2.894988288244919e-26, -1.705776262190652e-29,  5.368320540459183e-02, -3.931817447566214e-04,  2.112315361798028e-06, -9.772878422006015e-09,
  4.055275286019826e-11, -1.516530278259548e-13,  4.998697115506161e-16, -1.348670478035631e-18,  2.150428272056092e-21,  5.422898408103263e-24, -7.476995622167789e-26,
  4.671367564522212e-28,  8.853968096181060e-02, -6.403877835086519e-04,  3.345330231582355e-06, -1.468951454142993e-08,  5.557503223634435e-11, -1.753565580448036e-13,
  3.959767336926065e-16, -6.822739048175451e-20, -5.917122689148873e-21,  4.382983333467284e-23, -2.178043373763146e-25,  8.275457618102947e-28,  1.318787041139159e-01,
 -9.386857989568930e-04,  4.727505627239830e-06, -1.932139575865714e-08,  6.343513326554492e-11, -1.419289067065069e-13, -2.397139871953534e-17,  2.488840393968288e-18,
 -1.692870482085783e-20,  7.501031934242376e-23, -2.232968795097695e-25,  1.839070592530248e-28,  1.835352194740390e-01, -1.280828024120283e-03,  6.158450146189158e-06,
 -2.282798794063397e-08,  5.939658531837677e-11, -3.633517154011933e-14, -7.297267500998955e-16,  5.465345552611744e-18, -2.351438001348393e-20,  5.655921153474127e-23,
  7.342596297444147e-26, -1.680097172089254e-27,  2.433001121066756e-01, -1.658027106838294e-03,  7.524026143993154e-06, -2.437191182274028e-08,  4.012116849915616e-11,
  1.377950076003628e-13, -1.542720372716027e-15,  7.242561335124834e-18, -1.676650022637741e-20, -3.771577795324014e-23,  6.090968483888775e-25, -3.321048376870769e-27,
  3.109137112043116e-01, -2.059932686648007e-03,  8.700645385635125e-06, -2.321336678560322e-08,  4.654946111463715e-12,  3.532304093549937e-13, -2.151037202889037e-15,
  5.988775539949237e-18,  7.955067004340013e-21, -1.805759674814523e-22,  9.716486803125600e-25, -2.088964925256688e-27,  3.860578336305563e-01, -2.474629710668345e-03,
  9.560967021954152e-06, -1.881747986238375e-08, -4.472637715949830e-11,  5.590048695628778e-13, -2.183801854020905e-15,  6.003783137212179e-19,  4.480961707437691e-20,
 -2.770052868699839e-22,  5.797981071838388e-25,  3.303216177273593e-27,  4.683462179915190e-01, -2.888675112479348e-03,  9.981268802832310e-06, -1.096880372686339e-08,
 -1.020074718385227e-10,  6.870968548091781e-13, -1.344214551751082e-15, -8.250791808478496e-18,  7.495141500652466e-20, -2.020928113880092e-22, -7.898152975876847e-25,
  9.621579426215083e-27,  5.573132105922752e-01, -3.287195437580906e-03,  9.850723647220152e-06,  1.173843746947875e-10, -1.574976603952416e-10,  6.671642045401309e-13,
  4.227676972266212e-16, -1.748634239950962e-17,  7.206210147992684e-20,  1.034443757630812e-22, -2.428738675855201e-24,  9.196631924183378e-27,  6.524006043778021e-01,
 -3.654075304440126e-03,  9.082693040636483e-06,  1.370357131785150e-08, -1.987269170035339e-10,  4.488317316387468e-13,  2.782464147342494e-15, -2.205294294905833e-17,
  1.760562816355414e-20,  5.249379794328376e-22, -2.716600461054867e-24, -3.524525497945992e-27,  7.529426177874013e-01, -3.972274977038687e-03,  7.627896391591929e-06,
  2.848250700244243e-08, -2.123891079873420e-10,  2.804401092852007e-14,  4.965507324216182e-15, -1.688580002411063e-17, -7.901694198055353e-20,  7.516382186605907e-22,
 -2.834606559249250e-25, -2.184540764686726e-26,  8.581491564644352e-01, -4.224323917445425e-03,  5.488867315367159e-06,  4.260576174970122e-08, -1.873955219988814e-10,
 -5.301244561433070e-13,  5.918206087747739e-15, -2.021920028608647e-19, -1.688389575782246e-19,  4.427093995365103e-22,  4.061632509444577e-24, -2.499311932783551e-26,
  9.670877591529737e-01, -4.393044031812517e-03,  2.734394817004884e-06,  5.382555792896590e-08, -1.187825006385709e-10, -1.084089797795798e-12,  4.701283822839542e-15,
  2.325693024548025e-17, -1.782568340689254e-19, -4.316833930021996e-22,  6.507061538039462e-24,  3.150601897873626e-27,  1.078665029478688e+00, -4.462557743054125e-03,
 -4.883767418522282e-07,  5.978428466063711e-08, -1.169819019700457e-11, -1.437688750362672e-12,  1.074646467375284e-15,  4.164507188893336e-17, -5.903693850871155e-20,
 -1.320492097068357e-21,  2.865455605066725e-24,  4.396132805312916e-26,  1.191608939905075e+00, -4.419625880987441e-03, -3.947814440548819e-06,  5.846715181382259e-08,
  1.159706251024877e-10, -1.400831558224759e-12, -3.982921513192936e-15,  4.077599487977208e-17,  1.484944239390141e-19, -1.310539798594186e-21, -5.825583345271660e-24,
  4.460795125510425e-26,  1.304454195255051e+00, -4.255329585602669e-03, -7.332609548958961e-06,  4.878859434008045e-08,  2.343398343499332e-10, -8.827132287661977e-13,
 -8.249586144424009e-15,  1.427092303414446e-17,  2.994278243132812e-19,  6.091236945551386e-25, -1.085660220052353e-23, -1.843379700614547e-26,  1.415533857386886e+00,
 -3.967047467444018e-03, -1.027337392057976e-05,  3.120604523769241e-08,  3.076033874144680e-10,  1.617446087868315e-14, -9.134570716098673e-15, -2.661309424817457e-17,
  2.364121205584166e-19,  1.649909064101565e-21, -3.907375226870049e-24, -7.496773189309952e-26,  1.522981577145031e+00, -3.560573250769538e-03, -1.238621889630142e-05,
  8.153855730679204e-09,  3.060161334520059e-10,  9.761159778417632e-13, -5.378947238538836e-15, -5.430816858963946e-17, -3.918409254197092e-20,  1.821612787982594e-21,
  9.318640504328626e-24, -3.069559803408203e-26,  1.624749831376065e+00, -3.052067127177452e-03, -1.333997995867777e-05, -1.599549775688316e-08,  2.210919167364478e-10,
  1.559897569798253e-12,  1.400414097297772e-15, -4.439851637507329e-17, -2.929819874463360e-19,  8.696814492281645e-24,  1.127352090140792e-23,  6.398106388681735e-26,
  1.718650096079162e+00, -2.469354173389397e-03, -1.294104625356808e-05, -3.572549489230546e-08,  7.686317738774045e-11,  1.449991268206120e-12,  6.984191554099590e-15,
 -2.009499584564574e-18, -2.598019719072025e-19, -1.708015380749316e-21, -1.942179437285255e-24,  5.357213649128331e-26,  1.802420258018304e+00, -1.851930630164028e-03,
 -1.121801687604711e-05, -4.599889927696654e-08, -7.264825455352242e-11,  7.017776698468290e-13,  7.484101394470503e-15,  3.506075384196167e-17,  1.792800270647423e-20,
 -1.128175642989850e-21, -9.885452274546004e-24, -3.796919606697174e-26,  1.873822030392599e+00, -1.249014048041617e-03, -8.476034644204817e-06, -4.433503225550615e-08,
 -1.657478145379585e-10, -2.107989850900694e-13,  3.039999650501166e-15,  3.319911924473311e-17,  1.941992934415340e-19,  5.979276499536612e-22, -1.555085990196954e-24,
 -3.685238335753820e-26,  1.930766200038473e+00, -7.152009730581459e-04, -5.285386477640714e-06, -3.242631035297217e-08, -1.682807797807585e-10, -7.020311407706524e-13,
 -1.830919813212128e-15,  3.629419211473821e-18,  9.311067139309221e-20,  7.964571288685236e-22,  4.757541135281576e-24,  1.993991787964893e-26,  1.971456732127458e+00,
 -3.038524433579088e-04, -2.380547726030901e-06, -1.615623296509635e-08, -9.932836503203805e-11, -5.597862193551172e-13, -2.873906064543159e-15, -1.306813994681063e-17,
 -4.847437372229390e-20, -1.011100612119731e-22,  4.708115449195909e-25,  8.229043547377502e-27,  1.994542518580515e+00, -5.908652631334198e-05, -4.781103069968570e-07,
 -3.422953788235451e-09, -2.284117653984017e-11, -1.452889397517316e-13, -8.909090130458285e-16, -5.297984141662554e-18, -3.064519898158851e-20, -1.725936779787734e-22,
 -9.458656402401128e-25, -5.032341595943926e-27,  1.067152836551579e-03, -7.844104422626128e-06,  4.322336415294759e-08, -2.116031620013719e-10,  9.704217319079755e-13,
 -4.269035524036576e-15,  1.823812867633822e-17, -7.624750011026435e-20,  3.133102793818062e-22, -1.269961401857974e-24,  5.085800299264623e-27, -2.017194726880364e-29,
  9.599932049778444e-03, -7.036459393658132e-05,  3.853462620993755e-07, -1.866345130884432e-09,  8.418096120407566e-12, -3.615720344200415e-14,  1.494777751246907e-16,
 -5.982039186758017e-19,  2.322046411953415e-21, -8.747913309182090e-24,  3.189502967718315e-26, -1.121757404699968e-28,  2.664161020510828e-02, -1.941633556121372e-04,
  1.050109148644897e-06, -4.975071123956219e-09,  2.167050229470867e-11, -8.836111439483416e-14,  3.387871545215933e-16, -1.216516324690341e-18,  4.027164122277489e-21,
 -1.185459825065900e-23,  2.790275940027850e-26, -2.958410844752635e-29,  5.214354800619604e-02, -3.767415160185896e-04,  1.998835870719636e-06, -9.147659727920619e-09,
  3.763664313043396e-11, -1.401013713692271e-13,  4.630957872108715e-16, -1.277272040671379e-18,  2.296494170977657e-21,  2.812991955519005e-24, -5.643491671160130e-26,
  3.696547108621293e-28,  8.603055970199415e-02, -6.143153851371918e-04,  3.174277194795482e-06, -1.382785573764889e-08,  5.216267614611270e-11, -1.658960375859609e-13,
  3.916411182938552e-16, -2.339414141681153e-19, -4.487574218815160e-21,  3.581502305513446e-23, -1.836920504973422e-25,  7.238206684641291e-28,  1.281981566565946e-01,
 -9.017761424008968e-04,  4.501644938752890e-06, -1.832915088638596e-08,  6.059614068719110e-11, -1.417267501521864e-13,  3.852584155421848e-17,  1.988622125816801e-18,
 -1.438680194337740e-20,  6.627843265363986e-23, -2.124577151763574e-25,  2.994694320877236e-28,  1.785087303808065e-01, -1.232640071660234e-03,  5.890189438048067e-06,
 -2.188435724206445e-08,  5.850671148093895e-11, -5.209538720465262e-14, -5.869221723821887e-16,  4.745894293062115e-18, -2.144190591260633e-20,  5.815825996083401e-23,
  9.832691149189272e-27, -1.225996803906629e-27,  2.367865514989458e-01, -1.598993639779692e-03,  7.235499448286251e-06, -2.370986978895278e-08,  4.252292382454021e-11,
  1.031414982045229e-13, -1.347612257430638e-15,  6.688733299012221e-18, -1.771973856216053e-20, -1.614280582665278e-23,  4.728342052927054e-25, -2.870913362273030e-27,
  3.028114290407785e-01, -1.991439980051761e-03,  8.422756061986836e-06, -2.308511827849616e-08,  1.121701204966893e-11,  3.036407675064359e-13, -1.980712492280010e-15,
  6.146640117382458e-18,  2.130701416727118e-21, -1.436617985488020e-22,  8.717049875223665e-25, -2.413369203436812e-27,  3.763108440538243e-01, -2.399056547874651e-03,
  9.331223272613438e-06, -1.944650028106817e-08, -3.406823165007472e-11,  5.069483359913715e-13, -2.148382286868146e-15,  1.879462953444087e-18,  3.528561676699465e-20,
 -2.513733060589101e-22,  6.908338943498045e-25,  1.797432097582908e-27,  4.569503464046388e-01, -2.809378178039352e-03,  9.840298043701849e-06, -1.249281439485728e-08,
 -8.860548759453142e-11,  6.523275434084869e-13, -1.542791028874832e-15, -5.974049586213643e-18,  6.720511814421877e-20, -2.256942388064236e-22, -4.022411383710477e-25,
  7.978626880729179e-27,  5.443219902029419e-01, -3.208425836452808e-03,  9.837454154978247e-06, -2.295442374089779e-09, -1.440912121606557e-10,  6.716985853103911e-13,
 -3.413524135355474e-17, -1.513871368023799e-17,  7.413726976829523e-20,  1.463267636042639e-23, -2.007335532314615e-24,  9.819013617681913e-27,  6.379305923368647e-01,
 -3.580809337652838e-03,  9.228365524078916e-06,  1.059917347365249e-08, -1.891321066885531e-10,  5.082814499750735e-13,  2.175559138692046e-15, -2.120839568270641e-17,
  3.452192280234072e-20,  4.144622989710518e-22, -2.776798336030147e-24,  6.449752391550000e-28,  7.371776474428222e-01, -3.909942331530391e-03,  7.949336153693055e-06,
  2.509507776367197e-08, -2.106761740066401e-10,  1.412817117378959e-13,  4.461347080871990e-15, -1.898539090516426e-17, -5.238206991145662e-20,  7.223644493095757e-22,
 -1.147056446299789e-24, -1.729995169159387e-26,  8.413428477504377e-01, -4.178419629644097e-03,  5.981821571345181e-06,  3.953031811579180e-08, -1.965811890949838e-10,
 -3.887501750526748e-13,  5.839511659448906e-15, -5.320880379978302e-18, -1.502490360466866e-19,  5.824507202559451e-22,  2.911783961653594e-24, -2.687058042934232e-26,
  9.495633763516578e-01, -4.368619162271747e-03,  3.368203327724626e-06,  5.175792366827129e-08, -1.392866274053508e-10, -9.641017945157147e-13,  5.270641321687700e-15,
  1.735437771728582e-17, -1.891077414029678e-19, -1.717760345785541e-22,  6.412456079404571e-24, -7.248730014318147e-27,  1.060811520724851e+00, -4.463600467464677e-03,
  2.269683853632849e-07,  5.936887682276065e-08, -4.010088553103058e-11, -1.398161011071948e-12,  2.207292457948679e-15,  3.902106802059797e-17, -1.040643911167960e-19,
 -1.169326619707461e-21,  4.633834055604952e-24,  3.587920320429640e-26,  1.173871756538956e+00, -4.448372590257534e-03, -3.236015728790216e-06,  6.009375231111833e-08,
  8.709315726507054e-11, -1.482229087567271e-12, -2.782058273647586e-15,  4.473199807143506e-17,  9.762166961766687e-20, -1.501286278684967e-21, -3.644919216452040e-24,
  5.376501990292811e-26,  1.287319351223443e+00, -4.311586279892149e-03, -6.725266811714542e-06,  5.238619542207785e-08,  2.147436203247674e-10, -1.074828544478528e-12,
 -7.716458437725187e-15,  2.376789880431210e-17,  2.914885749713724e-19, -4.442310716572905e-22, -1.124095082775788e-23,  1.366873263799582e-27,  1.399503783246992e+00,
 -4.047652954511742e-03, -9.869400015543821e-06,  3.611813858422170e-08,  3.056788676818503e-10, -2.110887262165415e-13, -9.765148057752021e-15, -1.813421550991761e-17,
  2.921951415588930e-19,  1.427150330100956e-21, -7.229247581057606e-24, -7.476797671736439e-26,  1.508541843738436e+00, -3.659186944925135e-03, -1.225837497990682e-05,
  1.319875951292876e-08,  3.241238687374919e-10,  8.286951025036384e-13, -6.906776405313195e-15, -5.444394820185643e-17,  3.271146258138502e-20,  2.160027828352665e-21,
  7.418445718052817e-24, -5.586833017091210e-26,  1.612326995567812e+00, -3.159492233004993e-03, -1.350966686071422e-05, -1.220705903673829e-08,  2.525198094273159e-10,
  1.577533719257614e-12,  2.669869340334319e-17, -5.367649128946446e-17, -2.838892336280994e-19,  5.140939990936413e-22,  1.393513551191763e-23,  5.554948957369951e-26,
  1.708562940003513e+00, -2.574574197397890e-03, -1.336138692633932e-05, -3.425461482943980e-08,  1.075295533405945e-10,  1.615939999667203e-12,  6.802212248592289e-15,
 -1.131696724621391e-17, -3.220605023663136e-19, -1.731905921739878e-21,  9.157533576454824e-25,  7.661784877125173e-26,  1.794829524902613e+00, -1.943901340895478e-03,
 -1.177648219999758e-05, -4.703889321775064e-08, -5.673683343586788e-11,  8.932010086832748e-13,  8.467165927482814e-15,  3.490511864985453e-17, -3.019358847558684e-20,
 -1.555504616410879e-21, -1.143250016067316e-23, -3.127451645177953e-26,  1.868686924148490e+00, -1.318995783187349e-03, -9.024092213303362e-06, -4.701643202688892e-08,
 -1.691551869533446e-10, -1.259624876764230e-13,  4.059707059624580e-15,  3.974247340430440e-17,  2.141755450534535e-19,  4.989985543283426e-22, -3.503421745407383e-24,
 -5.223558498843962e-26,  1.927818299517022e+00, -7.590873825498387e-04, -5.691128121336077e-06, -3.523347436942289e-08, -1.827507344311716e-10, -7.443891938438398e-13,
 -1.683000158460407e-15,  7.106187347566823e-18,  1.254233958794058e-19,  1.004660186054503e-21,  5.658907622792303e-24,  2.078916437615910e-26,  1.970201966421362e+00,
 -3.237002175171610e-04, -2.584339990550205e-06, -1.783892777810541e-08, -1.112443850442348e-10, -6.333293579215650e-13, -3.262047378493732e-15, -1.467315157118613e-17,
 -5.167811365485285e-20, -7.392079396663421e-23,  9.187778779844483e-25,  1.237272829349737e-26,  1.994298253493867e+00, -6.308215199690533e-05, -5.214783020796600e-07,
 -3.812873095225040e-09, -2.597338737270073e-11, -1.685677051412815e-13, -1.053970376010826e-15, -6.385802555049541e-18, -3.759647016888256e-20, -2.152474598938374e-22,
 -1.197127675195220e-24, -6.448614077009265e-27,  1.036452275124347e-03, -7.508216844410922e-06,  4.077454423416737e-08, -1.967363834759384e-10,  8.892509238364137e-13,
 -3.855847547929161e-15,  1.623695883386199e-17, -6.691547793472395e-20,  2.710493244596736e-22, -1.083216452673461e-24,  4.276511399218082e-27, -1.672826447793482e-29,
  9.324500533647105e-03, -6.736917240417019e-05,  3.637350101913805e-07, -1.737251373970162e-09,  7.729512182000267e-12, -3.276261925646537e-14,  1.337226995994247e-16,
 -5.287003467112610e-19,  2.028943290880879e-21, -7.565721460197945e-24,  2.733588462920275e-26, -9.551120560444215e-29,  2.588138857157651e-02, -1.859955229554435e-04,
  9.924317450549488e-07, -4.642050411313747e-09,  1.998190347900427e-11, -8.062479664193167e-14,  3.064662301073350e-16, -1.094262616210772e-18,  3.620151194297692e-21,
 -1.076705927478806e-23,  2.641910965069931e-26, -3.716888399516732e-29,  5.066788227049097e-02, -3.611798886433366e-04,  1.892586528074179e-06, -8.567297789523866e-09,
  3.494290509867427e-11, -1.294078530039532e-13,  4.283732941201906e-16, -1.202569294088804e-18,  2.360823867937795e-21,  8.564612817797734e-25, -4.196516353234744e-26,
  2.908544744551499e-28,  8.362305538170278e-02, -5.895709652625081e-04,  3.013242699005241e-06, -1.301928808960104e-08,  4.893813969560231e-11, -1.565903399700698e-13,
  3.832643980943360e-16, -3.582719018656435e-19, -3.323083147840672e-21,  2.907509590692336e-23, -1.540137715163012e-25,  6.264417722379359e-28,  1.246617083759626e-01,
 -8.666265149911373e-04,  4.287419030235701e-06, -1.738222065431888e-08,  5.777510236471733e-11, -1.401838288857621e-13,  8.810913535191394e-17,  1.564807861033983e-18,
 -1.215035998174886e-20,  5.806636400432254e-23, -1.976606243774218e-25,  3.662841430172026e-28,  1.736707722702052e-01, -1.186553175416608e-03,  5.633157053476966e-06,
 -2.095730665606370e-08,  5.733431360862322e-11, -6.466249798472161e-14, -4.633283892961122e-16,  4.093229775181028e-18, -1.935308399332497e-20,  5.758631097031775e-23,
 -3.576995721731253e-26, -8.605723730799592e-28,  2.305045595023921e-01, -1.542236006038452e-03,  6.955125763780378e-06, -2.301469513610847e-08,  4.427716392485222e-11,
  7.298173140072805e-14, -1.168328899989514e-15,  6.115814557296994e-18, -1.798967364780963e-20,  3.766883514889805e-25,  3.563931410093758e-25, -2.424679566821784e-27,
  2.949786836436193e-01, -1.925162521161714e-03,  8.147003672269852e-06, -2.285958781624046e-08,  1.682841738075745e-11,  2.581721000178859e-13, -1.808382752004456e-15,
  6.138592199942236e-18, -2.439531167563893e-21, -1.109634343351423e-22,  7.624091718224098e-25, -2.524722250654599e-27,  3.668624274115811e-01, -2.325348707808079e-03,
  9.094920284321918e-06, -1.991326166136989e-08, -2.443998941682944e-11,  4.561380858508260e-13, -2.081270992820182e-15,  2.869276906878974e-18,  2.674921265313359e-20,
 -2.225299559445283e-22,  7.426987156431013e-25,  6.114879271565343e-28,  4.458692962732556e-01, -2.731278571270914e-03,  9.682302018499932e-06, -1.380819418688661e-08,
 -7.594153199775068e-11,  6.135286897022725e-13, -1.681196289394933e-15, -3.955933941339031e-18,  5.887061167147804e-20, -2.352572576054137e-22, -8.810012654950555e-26,
  6.306755568440900e-27,  5.316454576838351e-01, -3.129874557259912e-03,  9.796518884826002e-06, -4.493613803885207e-09, -1.306983819224553e-10,  6.660607657521095e-13,
 -4.248321154405654e-16, -1.277254256729437e-17,  7.332307551483438e-20, -5.700869160555607e-23, -1.575644744661921e-24,  9.697015995942741e-27,  6.237557427856966e-01,
 -3.506524307040031e-03,  9.337743032943225e-06,  7.657022238734877e-09, -1.784917432710354e-10,  5.535067024258804e-13,  1.599280747417504e-15, -1.988628253452083e-17,
  4.745957048529307e-20,  3.049834886278946e-22, -2.673478435840930e-24,  3.893511051166910e-27,  7.216668941510497e-01, -3.845200130852893e-03,  8.230363763425632e-06,
  2.175249780568523e-08, -2.068237535562703e-10,  2.418092136231149e-13,  3.910127069352647e-15, -2.025579336977867e-17, -2.737317243505140e-20,  6.627006747086075e-22,
 -1.800114483269049e-24, -1.236240086486517e-26,  8.247278064769141e-01, -4.128721613605435e-03,  6.437081524182905e-06,  3.633037361164476e-08, -2.029695004499649e-10,
 -2.509128906116050e-13,  5.626514505503484e-15, -9.773196546497361e-18, -1.274698400896362e-19,  6.752432687796335e-22,  1.730909926454493e-24, -2.645616142010502e-26,
  9.321466691970770e-01, -4.339228461288313e-03,  3.975313273198918e-06,  4.938210711408624e-08, -1.572679015554400e-10, -8.324631080704939e-13,  5.671262488636802e-15,
  1.125270169331115e-17, -1.907766121972180e-19,  7.562074762491319e-23,  5.893526796639926e-24, -1.600600447098132e-26,  1.042965244208912e+00, -4.458948026424593e-03,
  9.346327572195010e-07,  5.850679942742039e-08, -6.744796069828127e-11, -1.332488754359609e-12,  3.247205182858874e-15,  3.505615897888227e-17, -1.424705248727956e-19,
 -9.554192960624306e-22,  5.982815649953581e-24,  2.509206236178519e-26,  1.156031087497742e+00, -4.471354801058200e-03, -2.507518603128159e-06,  6.124688992035319e-08,
  5.688394284894795e-11, -1.533666363082628e-12, -1.494126075708159e-15,  4.696774313053544e-17,  4.153654278992475e-20, -1.598153020321137e-21, -1.167888708059478e-24,
  5.794944794517314e-26,  1.269969463412443e+00, -4.362817164654467e-03, -6.076758396832551e-06,  5.564030353219735e-08,  1.914543783671001e-10, -1.251001380052375e-12,
 -6.923390770080279e-15,  3.275336392591922e-17,  2.674736556166708e-19, -8.864655849500761e-22, -1.071664640804831e-23,  2.248955955462214e-26,  1.383158122859728e+00,
 -4.124791743695080e-03, -9.406818172442603e-06,  4.096233947630943e-08,  2.990779834412494e-10, -4.504434786088897e-13, -1.013471363395997e-14, -8.024079307629722e-18,
  3.375902113985883e-19,  1.074010704075519e-21, -1.036756477576975e-23, -6.650358968765341e-26,  1.493710091112218e+00, -3.756531044074465e-03, -1.206835761883500e-05,
  1.850781095366268e-08,  3.389175888378421e-10,  6.448313582236756e-13, -8.404483885719352e-15, -5.210099016755039e-17,  1.151534353248010e-19,  2.400167107995750e-21,
  4.407597162375720e-24, -8.065235210859918e-26,  1.599472044355622e+00, -3.268084425869957e-03, -1.363086982255640e-05, -7.914831086945888e-09,  2.839499348375927e-10,
  1.559133704105500e-12, -1.599849736053629e-15, -6.235272731751583e-17, -2.547996998276738e-19,  1.115826903519600e-21,  1.602066257418296e-23,  3.757072499976963e-26,
  1.698048302273902e+00, -2.683077753047302e-03, -1.376102456064438e-05, -3.226685091473287e-08,  1.414489557253286e-10,  1.774168835493041e-12,  6.331771636094366e-15,
 -2.260639943083635e-17, -3.828737531877251e-19, -1.620878469317995e-21,  4.806862089603727e-24,  1.000750755947670e-25,  1.786861900963339e+00, -2.040385066749864e-03,
 -1.234576947493206e-05, -4.779239956863922e-08, -3.676232415318765e-11,  1.107976970038998e-12,  9.421920281423809e-15,  3.295220613645424e-17, -9.472313564399324e-20,
 -2.036729835796060e-21, -1.252426285149281e-23, -1.688980775388332e-26,  1.863262917129157e+00, -1.393491474975375e-03, -9.604593214846953e-06, -4.973738267425359e-08,
 -1.706059020303597e-10, -1.438607366501397e-14,  5.270927163450846e-15,  4.685166377815294e-17,  2.290159910291719e-19,  3.076769679021165e-22, -6.196899480477645e-24,
 -7.065469642791247e-26,  1.924688142507281e+00, -8.063584678494345e-04, -6.131972084681053e-06, -3.827870676942495e-08, -1.980238299561041e-10, -7.819049625619410e-13,
 -1.422078206987112e-15,  1.174389014600760e-17,  1.658848991263451e-19,  1.249153118560234e-21,  6.557320803749421e-24,  1.961054075489966e-26,  1.968864416330223e+00,
 -3.452624554516007e-04, -2.809518750950581e-06, -1.972456742501705e-08, -1.247281174628556e-10, -7.167377192609244e-13, -3.696390291094399e-15, -1.636117980302336e-17,
 -5.353239524755805e-20, -2.470129856923548e-23,  1.584768150993213e-24,  1.822745637691873e-26,  1.994037281131473e+00, -6.744432654770905e-05, -5.698421032686804e-07,
 -4.256855837149334e-09, -2.961291160146716e-11, -1.961520773520849e-13, -1.250850234560821e-15, -7.722698571787411e-18, -4.628023421110237e-20, -2.693126122722243e-22,
 -1.519457869847321e-24, -8.280468921636486e-27,  1.007057182404050e-03, -7.191227687114546e-06,  3.849659774753577e-08, -1.831047511600079e-10,  8.158839953480496e-13,
 -3.487698908570092e-15,  1.447912048332627e-17, -5.883420434177035e-20,  2.349632356899348e-22, -9.260062478994194e-25,  3.604516063335759e-27, -1.390936902304129e-29,
  9.060714476962699e-03, -6.454062665202215e-05,  3.436089549474924e-07, -1.618651728121783e-09,  7.105191028170246e-12, -2.972382544353157e-14,  1.197885690525547e-16,
 -4.679289415820320e-19,  1.775286075602093e-21, -6.552007386886318e-24,  2.345267112708463e-26, -8.138357451557828e-29,  2.515294010653187e-02, -1.782735723410881e-04,
  9.385934570938591e-07, -4.334850477531693e-09,  1.844054381362472e-11, -7.362453983614234e-14,  2.773918684013947e-16, -9.844189363083648e-19,  3.251151435229052e-21,
 -9.744414250966052e-24,  2.468369206765153e-26, -4.122893229344296e-29,  4.925280614898007e-02, -3.464411153694251e-04,  1.793049842844245e-06, -8.028369260268202e-09,
  3.245487440174454e-11, -1.195224029846461e-13,  3.957614674535950e-16, -1.126829745610316e-18,  2.364344731276010e-21, -5.858741446477434e-25, -3.061318196275681e-26,
  2.274359520506269e-28,  8.131201242044919e-02, -5.660768731128403e-04,  2.861607562811662e-06, -1.226083614704748e-08,  4.589744564281516e-11, -1.475234640935935e-13,
  3.718932253822342e-16, -4.489999993945190e-19, -2.380872509484757e-21,  2.343895492369368e-23, -1.284420587920446e-25,  5.373770296642160e-28,  1.212625018774498e-01,
 -8.331460067749421e-04,  4.084286681910664e-06, -1.648011940406868e-08,  5.499590189807054e-11, -1.375854921397094e-13,  1.267839563309379e-16,  1.207948879067442e-18,
 -1.019829436618345e-20,  5.049369625546798e-23, -1.807451063759798e-25,  3.977060867789429e-28,  1.690131192081666e-01, -1.142478376798863e-03,  5.387128936858405e-06,
 -2.005087008528871e-08,  5.593879469728180e-11, -7.447513092849781e-14, -3.570788507433677e-16,  3.506756083384644e-18, -1.731402778172089e-20,  5.548820559146064e-23,
 -6.703881563349642e-26, -5.725373879131548e-28,  2.244451655101932e-01, -1.487687560587697e-03,  6.683243419074778e-06, -2.229604988386771e-08,  4.546993448844530e-11,
  4.693180670330960e-14, -1.005124982952095e-15,  5.542912239664035e-18, -1.774406924044568e-20,  1.262474387567004e-23,  2.590691160168757e-25, -2.004819618169129e-27,
  2.874066552495976e-01, -1.861078797278902e-03,  7.874467060716721e-06, -2.255132549780959e-08,  2.157170934366426e-11,  2.168211735656112e-13, -1.638154910284827e-15,
  6.002280766978104e-18, -5.912042285041143e-21, -8.268582079181187e-23,  6.517809353033419e-25, -2.483034418477877e-27,  3.577050294041185e-01, -2.253551153930651e-03,
  8.853907243871413e-06, -2.023400441274175e-08, -1.580975599040074e-11,  4.072411879517478e-13, -1.990110826797739e-15,  3.602843436866141e-18,  1.927675660400366e-20,
 -1.925659328398607e-22,  7.490343315948248e-25, -2.771685763276416e-28,  4.350980214475214e-01, -2.654502686391842e-03,  9.509711034846436e-06, -1.492732031941958e-08,
 -6.408235045212583e-11,  5.720558240803369e-13, -1.766863464196169e-15, -2.207748528698150e-18,  5.040044925921489e-20, -2.337068967635238e-22,  1.540761913193074e-25,
  4.723236444562330e-27,  5.192823133836637e-01, -3.051752641374992e-03,  9.730485959311657e-06, -6.478889026094617e-09, -1.175067337448769e-10,  6.518360461943145e-13,
 -7.500050341729350e-16, -1.047037968430968e-17,  7.023769858855036e-20, -1.116645833937308e-22, -1.162031933974950e-24,  9.029716401909207e-27,  6.098795639640886e-01,
 -3.431502521510837e-03,  9.412863652659126e-06,  4.891614773751028e-09, -1.670819566153664e-10,  5.853886794628979e-13,  1.065232314208397e-15, -1.821216412726542e-17,
  5.656225019761101e-20,  2.022141183734688e-22, -2.448291530128834e-24,  6.187173742067803e-27,  7.064193537425045e-01, -3.778368957198818e-03,  8.471714236635524e-06,
  1.848691168995551e-08, -2.010954988218579e-10,  3.287688578170025e-13,  3.334183397023245e-15, -2.076489315478338e-17, -4.929906784299177e-21,  5.812651897644872e-22,
 -2.236291910693321e-24, -7.512267610355826e-27,  8.083185960516002e-01, -4.075536645397086e-03,  6.853418825822128e-06,  3.304995147525447e-08, -2.066618456725151e-10,
 -1.195983842520752e-13,  5.299495160663724e-15, -1.345217468157553e-17, -1.021905186924818e-19,  7.217552147583958e-22,  6.115029307046882e-25, -2.415585519433282e-26,
  9.148570514064177e-01, -4.305099607645857e-03,  4.552275632710184e-06,  4.674011668064834e-08, -1.725340883438667e-10, -6.932576432014681e-13,  5.901595239239610e-15,
  5.235399812458865e-18, -1.839999734623230e-19,  2.951892132833376e-22,  5.037664822821354e-24, -2.248610668474744e-26,  1.025148824210389e+00, -4.448682980094329e-03,
  1.629374508452331e-06,  5.721899228678150e-08, -9.324169035042875e-11, -1.243322214134510e-12,  4.160120879848223e-15,  2.999491714009100e-17, -1.723240075387990e-19,
 -6.975638684184947e-22,  6.820812973107277e-24,  1.287447152447169e-26,  1.138110221516231e+00, -4.488461968337216e-03, -1.768112369819044e-06,  6.191014719955883e-08,
  2.595909804120803e-11, -1.553647390648140e-12, -1.691054387511673e-16,  4.737235705744460e-17, -1.622236977426050e-20, -1.593842570372029e-21,  1.374386465606423e-24,
  5.671444945503511e-26,  1.252425266222102e+00, -4.408710380228403e-03, -5.391549146449327e-06,  5.849471407023957e-08,  1.648518844301055e-10, -1.405222834098082e-12,
 -5.891842769429268e-15,  4.072148503782856e-17,  2.281388034938735e-19, -1.289282147178272e-21, -9.278044021335324e-24,  4.251505375780688e-26,  1.366511673766734e+00,
 -4.197999518392193e-03, -8.886898868956090e-06,  4.566224658958761e-08,  2.876250336087215e-10, -6.951192432031632e-13, -1.020293748729335e-14,  3.311921220452239e-18,
  3.681226603111615e-19,  6.050636381466311e-22, -1.295944433864450e-23, -4.999676288131942e-26,  1.478492411151592e+00, -3.852096438002816e-03, -1.181333904567026e-05,
  2.402221846839578e-08,  3.496814694645185e-10,  4.261150834739833e-13, -9.798532749966458e-15, -4.700689839569283e-17,  2.038172796169254e-19,  2.498935910790997e-21,
  3.781926569216107e-25, -1.015501076922331e-25,  1.586181123348352e+00, -3.377431708643580e-03, -1.369756799207263e-05, -3.124866595819806e-09,  3.146026411451085e-10,
  1.498907049117755e-12, -3.452939146386935e-15, -6.973712785536525e-17, -2.027643726951368e-19,  1.782131461848162e-21,  1.708828472784790e-23,  9.258991089230835e-27,
  1.687093420526053e+00, -2.794673535052996e-03, -1.413345062451284e-05, -2.971178477612332e-08,  1.783933079124730e-10,  1.917098763358048e-12,  5.518809184523656e-15,
 -3.574587586470926e-17, -4.366445897490562e-19, -1.334158205810849e-21,  9.678650905847945e-24,  1.205275449478643e-25,  1.778499184368443e+00, -2.141453491603978e-03,
 -1.292203554952706e-05, -4.819072761496958e-08, -1.226885865004422e-11,  1.344761243269702e-12,  1.029042733420944e-14,  2.865013508749375e-17, -1.771853244981668e-19,
 -2.546189745809937e-21, -1.277153366955605e-23,  7.470127190025393e-27,  1.857531432214262e+00, -1.472761994804095e-03, -1.021780594912416e-05, -5.246204454975945e-08,
 -1.695180248628548e-10,  1.286948262009562e-13,  6.686660026559672e-15,  5.430312230025296e-17,  2.348273271198177e-19, -8.336147926596113e-24, -9.754301164603400e-24,
 -9.129522069595499e-26,  1.921361610278280e+00, -8.573066848761542e-04, -6.610848585064790e-06, -4.157392408883944e-08, -2.139733097285897e-10, -8.114456501711766e-13,
 -1.011802017219108e-15,  1.782397174185758e-17,  2.157745313827311e-19,  1.527646298514319e-21,  7.333662469726865e-24,  1.495407077428408e-26,  1.967436865768930e+00,
 -3.687204322881698e-04, -3.058676553758819e-06, -2.183987467938432e-08, -1.399881148488940e-10, -8.111423588625782e-13, -4.178522581127462e-15, -1.807451226598712e-17,
 -5.306749119926799e-20,  5.694400074874891e-23,  2.556973954081527e-24,  2.640607989827366e-26,  1.993758051052330e+00, -7.221575629200378e-05, -6.239021651803092e-07,
 -4.763754513741394e-09, -3.385457677151550e-11, -2.289440551721796e-13, -1.489364805172677e-15, -9.371271309392476e-18, -5.716318054631337e-20, -3.380313909706751e-22,
 -1.933722149295091e-24, -1.065012300068854e-26,  9.788946077197728e-04, -6.891827194098436e-06,  3.637542338125452e-08, -1.705903034874978e-10,  7.494758339289300e-13,
 -3.159148519199558e-15,  1.293220641876405e-17, -5.182208723477452e-20,  2.040813295186369e-22, -7.933517904311299e-25,  3.045044588381750e-27, -1.159604167970004e-29,
  8.807929366181206e-03, -6.186756187045494e-05,  3.248481089111490e-07, -1.509572621367443e-09,  6.538434787751689e-12, -2.699991611833960e-14,  1.074476787503360e-16,
 -4.147194705713039e-19,  1.555470406714879e-21, -5.681849527619411e-24,  2.014238486810184e-26, -6.941094725167048e-29,  2.445454080037457e-02, -1.709679912842609e-04,
  8.882980979700722e-07, -4.051229148137385e-09,  1.703245380973288e-11, -6.728646100744187e-14,  2.512332550959077e-16, -8.858079032152103e-19,  2.917681686475417e-21,
 -8.793965749722634e-24,  2.282723410722709e-26, -4.282008287661193e-29,  4.789513255623234e-02, -3.324734289991230e-04,  1.699747837632537e-06, -7.527709355297457e-09,
  3.015689751728896e-11, -1.103942205609618e-13,  3.652647139396243e-16, -1.051725898950187e-18,  2.323478214179147e-21, -1.626048764597992e-24, -2.176556014989824e-26,
  1.765961156585747e-28,  7.909257615838000e-02, -5.437602697469933e-04,  2.718787877188339e-06, -1.154960024197571e-08,  4.303517109234045e-11, -1.387567545787806e-13,
  3.583746373594772e-16, -5.126338666761107e-19, -1.624071570886223e-21,  1.874996908814025e-23, -1.065892399216814e-25,  4.574686262798354e-28,  1.179940347923104e-01,
 -8.012480081670991e-04,  3.891714614624673e-06, -1.562202246892248e-08,  5.227717619567566e-11, -1.341720528094973e-13,  1.563012121840177e-16,  9.093269390257374e-19,
 -8.506406654099367e-21,  4.361728163637088e-23, -1.630296415066439e-25,  4.041453004056471e-28,  1.645278972254694e-01, -1.100328687782053e-03,  5.151838046795829e-06,
 -1.916819874051844e-08,  5.437123067418652e-11, -8.192753471096287e-14, -2.663500168234523e-16,  2.984105850990177e-18, -1.537014793413477e-20,  5.237262794941458e-23,
 -8.712240393139794e-26, -3.502551222987976e-28,  2.185996702068498e-01, -1.435279392729104e-03,  6.420082804940214e-06, -2.156228090574431e-08,  4.617958237948275e-11,
  2.460755038173418e-14, -8.577911641112331e-16,  4.984208295477659e-18, -1.712325433933696e-20,  2.133835962259843e-23,  1.793819818416962e-25, -1.624555563148990e-27,
  2.800866263336232e-01, -1.799159340940374e-03,  7.606058376380278e-06, -2.217356619094405e-08,  2.552846729167183e-11,  1.794982682929092e-13, -1.473152493133404e-15,
  5.770288497177608e-18, -8.445457743276317e-21, -5.876306163479359e-23,  5.454150991026204e-25, -2.338396084977499e-27,  3.488309442441024e-01, -2.183694826123634e-03,
  8.609841923860464e-06, -2.042436154990543e-08, -8.134053768346179e-12,  3.607525886580604e-13, -1.881596363402452e-15,  4.114527910673970e-18,  1.287887529883722e-20,
 -1.630507126000841e-22,  7.221615634247674e-25, -9.046401517030382e-28,  4.246310081219768e-01, -2.579158085423115e-03,  9.324801329231487e-06, -1.586343082273750e-08,
 -5.306937929523031e-11,  5.290838235401495e-13, -1.807355137201672e-15, -7.279794383963966e-19,  4.214406838362931e-20, -2.238189091925060e-22,  3.299799658493488e-25,
  3.303751518447701e-27,  5.072304543730548e-01, -2.974250718245071e-03,  9.641885426862622e-06, -8.255776164384473e-09, -1.046724651172823e-10,  6.305678411201119e-13,
 -1.012373042448834e-15, -8.295302320515448e-18,  6.547433570969548e-20, -1.504813268784728e-22, -7.862881913326868e-25,  8.004910312527563e-27,  5.963044684831948e-01,
 -3.356009363102738e-03,  9.455913553476906e-06,  2.313185099085252e-09, -1.551587492967909e-10,  6.050455613960603e-13,  5.815944663091639e-16, -1.630403561080904e-17,
  6.214921175360957e-20,  1.101997359879144e-22, -2.142276866814247e-24,  7.582785479800472e-27,  6.914427538193503e-01, -3.709762042526322e-03,  8.674482539684405e-06,
  1.532613674014554e-08, -1.937670248040643e-10,  4.018131321623624e-13,  2.753577165442593e-15, -2.060567135732081e-17,  1.431809197554820e-20,  4.865393128393838e-22,
 -2.467961893049763e-24, -3.117034657417830e-27,  7.921285364254633e-01, -4.019179246695673e-03,  7.230121791226351e-06,  2.973100234061787e-08, -2.078142514555976e-10,
  2.724174822307189e-15,  4.880980955731996e-15, -1.630384032375636e-17, -7.601425929500141e-20,  7.259564161754700e-22, -3.746985952942410e-25, -2.049286715479164e-26,
  8.977129740556734e-01, -4.266485809809530e-03,  5.096161246359332e-06,  4.387638373414151e-08, -1.849743764826184e-10, -5.505144469128685e-13,  5.967617657587285e-15,
 -4.456986043140347e-19, -1.699970120458757e-19,  4.755694786135273e-22,  3.952945970128776e-24, -2.638613126180793e-26,  1.007384472675204e+00, -4.432928687370770e-03,
  2.306248945938942e-06,  5.553389254695228e-08, -1.170449890734058e-10, -1.134045442256173e-12,  4.919382944527360e-15,  2.413229729353475e-17, -1.924221699303622e-19,
 -4.170615099942739e-22,  7.114539675145024e-24,  5.694568094540602e-28,  1.120132795871854e+00, -4.499630480099843e-03, -1.023723423354868e-06,  6.207713792739434e-08,
 -5.047520948766797e-12, -1.541899988179954e-12,  1.141530570937592e-15,  4.595059447958759e-17, -7.202305554591273e-20, -1.490490598008180e-21,  3.746471258035643e-24,
  5.031145193240097e-26,  1.234708665939710e+00, -4.448992371283505e-03, -4.674738037187850e-06,  6.090022754141122e-08,  1.354298142624013e-10, -1.532165042679583e-12,
 -4.656900506398529e-15,  4.721164938366079e-17,  1.755431016423645e-19, -1.617799907874120e-21, -7.027370450634107e-24,  5.902307920023572e-26,  1.349581064588418e+00,
 -4.266825830264348e-03, -8.311841638272275e-06,  5.013977911785021e-08,  2.712884067197657e-10, -9.375293554951791e-13, -9.942746487802528e-15,  1.533639400338232e-17,
  3.801024820346272e-19,  4.920719392076652e-23, -1.466037583850723e-23, -2.627976543802831e-26,  1.462896972687862e+00, -3.945354408004426e-03, -1.149126434453016e-05,
  2.967208992416268e-08,  3.557496729727528e-10,  1.759759900923725e-13, -1.100992275055455e-14, -3.905146489062982e-17,  2.929316011021313e-19,  2.420121609697107e-21,
 -4.415747072822818e-24, -1.147906877533415e-25,  1.572452121706339e+00, -3.487074428519804e-03, -1.370389168824130e-05,  2.143421874793257e-09,  3.435903924322266e-10,
  1.391935644438690e-12, -5.485830132782280e-15, -7.506697909246998e-17, -1.263005898583702e-19,  2.463282122069263e-21,  1.669268102257845e-23, -2.867162255233900e-26,
  1.675686405481800e+00, -2.909115823799883e-03, -1.447157868702019e-05, -2.654392876735161e-08,  2.179703879709881e-10,  2.035919216777433e-12,  4.315681619323892e-15,
 -5.040160278355256e-17, -4.763853180315378e-19, -8.364382874986000e-22,  1.530152844213314e-23,  1.333712071046219e-25,  1.769722953433006e+00, -2.247144135534248e-03,
 -1.350057036708949e-05, -4.815818873397676e-08,  1.715736387588120e-11,  1.600629047274082e-12,  1.099877565117385e-14,  2.141621231849719e-17, -2.778772841662562e-19,
 -3.040730667644904e-21, -1.169211390866756e-23,  4.364688088044695e-26,  1.851472847462020e+00, -1.557068474544188e-03, -1.086350958182630e-05, -5.514449015961848e-08,
 -1.652117936266346e-10,  3.082664805243024e-13,  8.311720753304728e-15,  6.172926047652060e-17,  2.264791359385031e-19, -4.850894902792459e-22, -1.423649539850812e-23,
 -1.122659380462108e-25,  1.917823366541596e+00, -9.122484637207894e-04, -7.130816440955663e-06, -4.512846334582988e-08, -2.304003749502427e-10, -8.289069342764880e-13,
 -4.073857832903012e-16,  2.566644206223333e-17,  2.761865105111227e-19,  1.831635400918000e-21,  7.791744648258906e-24,  4.742275877385761e-27,  1.965911329957825e+00,
 -3.942775046751070e-04, -3.334747391370356e-06, -2.421509157789142e-08, -1.572557813656966e-10, -9.176891695155397e-13, -4.707920208517653e-15, -1.971768100238162e-17,
 -4.886899802989991e-20,  1.855261518694915e-22,  3.954214611034143e-24,  3.769110848248761e-26,  1.993458830071762e+00, -7.744520334639491e-05, -6.844749059115369e-07,
 -5.344094005357085e-09, -3.881327747173416e-11, -2.680560613175421e-13, -1.779310915621654e-15, -1.141109363535826e-17, -7.084512271112081e-20, -4.255974875122822e-22,
 -2.466865938166810e-24, -1.371268106450679e-26,  9.518966224572896e-04, -6.608812978929614e-06,  3.439825769032231e-08, -1.590877707100000e-10,  6.892827654603168e-13,
 -2.865475402017965e-15,  1.156848478685612e-17, -4.572590990800618e-20,  1.775955271435822e-22, -6.811674704041202e-25,  2.578021849940409e-27, -9.693177729878544e-30,
  8.565544418697129e-03, -5.933949817950344e-05,  3.073435505594626e-07, -1.409141388872971e-09,  6.023311610910331e-12, -2.455507657545150e-14,  9.650270911348125e-17,
 -3.680674490049214e-19,  1.364718830584126e-21, -4.934127569870245e-24,  1.731755550341345e-26, -5.926802411730053e-29,  2.378458011964101e-02, -1.640515328602560e-04,
  8.412750933104074e-07, -3.789156359541840e-09,  1.574506486544844e-11, -6.154423031700527e-14,  2.276913972907974e-16, -7.973348789300118e-19,  2.617079615243713e-21,
 -7.918630696667855e-24,  2.094026680730948e-26, -4.272650534150054e-29,  4.659187406258382e-02, -3.192287384247823e-04,  1.612239043227965e-06, -7.062395627146759e-09,
  2.803433449400263e-11, -1.019729053655732e-13,  3.368473930886510e-16, -9.784648006891689e-19,  2.251025701472453e-21, -2.353891989572488e-24, -1.492221174595284e-26,
  1.359776158077292e-28,  7.696017416704037e-02, -5.225528498733127e-04,  2.584233971453830e-06, -1.088277624292755e-08,  4.034485545206967e-11, -1.303332856738585e-13,
  3.433891348340499e-16, -5.545889694039834e-19, -1.021162525513093e-21,  1.486751143967219e-23, -8.804823359890696e-26,  3.868088830986774e-28,  1.148501427270411e-01,
 -7.708501315132271e-04,  3.709181082934768e-06, -1.480684323991484e-08,  4.963315681191329e-11, -1.301446422847901e-13,  1.781787808384984e-16,  6.610215683271369e-19,
 -7.049297597718965e-21,  3.744963671637641e-23, -1.454304109743325e-25,  3.935564603133476e-28,  1.602075758116802e-01, -1.060019394621802e-03,  4.926984178082626e-06,
 -1.831168734487064e-08,  5.267524399358224e-11, -8.737113661306366e-14, -1.894023923970292e-16,  2.521728262011521e-18, -1.355068688297597e-20,  4.863245630709876e-23,
 -9.866636434557966e-26, -1.826142197703972e-28,  2.129596530008643e-01, -1.384941128559298e-03,  6.165781418641444e-06, -2.082054259404741e-08,  4.647685087430013e-11,
  5.634094705062933e-15, -7.257799728334445e-16,  4.449806225407145e-18, -1.624221191911811e-20,  2.718585432376516e-23,  1.154272186516458e-25, -1.290328441427181e-27,
  2.730100108601076e-01, -1.739368000736161e-03,  7.342538709932287e-06, -2.173825762207687e-08,  2.877779748239310e-11,  1.460490775406559e-13, -1.315657135439673e-15,
  5.470199059787705e-18, -1.019250674166805e-20, -3.894656023293998e-23,  4.469252366331091e-25, -2.130836703946999e-27,  3.402323677385439e-01, -2.115798139949084e-03,
  8.364198973841677e-06, -2.049919965703674e-08, -1.361034989016979e-12,  3.170181008466072e-13, -1.761463020793146e-15,  4.438223594537784e-18,  7.518160749988141e-21,
 -1.350949979579020e-22,  6.726532021159744e-25, -1.313247375769473e-27,  4.144623476431347e-01, -2.505334765468023e-03,  9.129687047459449e-06, -1.663024855383310e-08,
 -4.292236276660289e-11,  4.856077446921859e-13, -1.810049629456928e-15,  4.945202063024482e-19,  3.435578117148053e-20, -2.080855437378322e-22,  4.478408176364824e-25,
  2.089200779364620e-27,  4.954870552860854e-01, -2.897539433485276e-03,  9.533179249082608e-06, -9.831039664011903e-09, -9.232168996421436e-11,  6.037152157645871e-13,
 -1.216162798594331e-15, -6.292202759226453e-18,  5.957259890941707e-20, -1.752382359991227e-22, -4.604543267127814e-25,  6.785431307470383e-27,  5.830318430865455e-01,
 -3.280292301127480e-03,  9.469177907182455e-06, -7.194033062594097e-11, -1.429540580504171e-10,  6.137534950144593e-13,  1.534066608742401e-16, -1.426765659584083e-17,
  6.465658545073155e-20,  3.141438021789207e-23, -1.792527842254616e-24,  8.197999248117327e-27,  6.767435885831723e-01, -3.639682599161224e-03,  8.840070840648496e-06,
  1.229355007507074e-08, -1.851163035477240e-10,  4.610427504947002e-13,  2.185528976279862e-15, -1.988649713665226e-17,  3.003404116311893e-20,  3.862224110328297e-22,
 -2.520941658772962e-24,  5.800842128812551e-28,  7.761696811994325e-01, -3.959967665027091e-03,  7.566965631065267e-06,  2.641261513462780e-08, -2.066266282343156e-10,
  1.141387623586950e-13,  4.394317445643719e-15, -1.832272664106786e-17, -5.035538558233898e-20,  6.942099814680230e-22, -1.180021404784232e-24, -1.602506391693972e-26,
  8.807318319317574e-01, -4.223661552739369e-03,  5.604582140955220e-06,  4.083647808281649e-08, -1.945565540119622e-10, -4.080392336263473e-13,  5.881757444146875e-15,
 -5.583466922931174e-18, -1.503157285412659e-19,  6.098945153149063e-22,  2.753600604743596e-24, -2.772330244932107e-26,  9.896938313206162e-01, -4.411846586180905e-03,
  2.960692244278595e-06,  5.348635738922498e-08, -1.384941616735228e-10, -1.008579510333824e-12,  5.507015852859938e-15,  1.778932770111939e-17, -2.023390893335381e-19,
 -1.353852297536926e-22,  6.887822752166453e-24, -1.059844528199965e-26,  1.102122607225753e+00, -4.504844269658194e-03, -2.802939797804553e-07,  6.175159429013019e-08,
 -3.550888968303054e-11, -1.499372731538642e-12,  2.388044825820566e-15,  4.282042029677345e-17, -1.224754247836681e-19, -1.299231644143596e-21,  5.738556643546967e-24,
  3.963542391452325e-26,  1.216842577950939e+00, -4.483432593818323e-03, -3.931963690177315e-06,  6.281634573235470e-08,  1.037789788492861e-10, -1.627488400813576e-12,
 -3.265442775490580e-15,  5.184823335543537e-17,  1.129028092296512e-19, -1.843270983572032e-21, -4.166239748431618e-24,  6.997798754183695e-26,  1.332384684615195e+00,
 -4.330841571980569e-03, -7.684780910926557e-06,  5.431759429833574e-08,  2.501934388042655e-10, -1.169630248913374e-12, -9.343592870716864e-15,  2.741306088085336e-17,
  3.711137677332993e-19, -5.521536651696325e-22, -1.519839747589451e-23,  2.400816696776918e-27,  1.446934086746045e+00, -4.035763326090607e-03, -1.110097862630419e-05,
  3.537753221494002e-08,  3.565440532793503e-10, -1.002451700846456e-13, -1.195933353313949e-14, -2.832774159034632e-17,  3.756438068518354e-19,  2.140934251324413e-21,
 -9.559767186658346e-24, -1.169697179366915e-25,  1.558284859290554e+00, -3.596507155500329e-03, -1.364429241273306e-05,  7.855702574089096e-09,  3.699402581241910e-10,
  1.234682984205072e-12, -7.630056182427767e-15, -7.756410810986116e-17, -2.602392841611932e-20,  3.092916808374851e-21,  1.446156717462036e-23, -7.355890614322678e-26,
  1.663816467412634e+00, -3.026100145280844e-03, -1.476782012520287e-05, -2.272553896387577e-08,  2.596012206049406e-10,  2.120814713819758e-12,  2.687398439864945e-15,
 -6.599802975516930e-17, -4.940539620548549e-19, -1.059298078299203e-22,  2.122312134581235e-23,  1.331757049007541e-25,  1.760514717657260e+00, -2.357453097655244e-03,
 -1.407571814029421e-05, -4.761304338239553e-08,  5.185258934759904e-11,  1.870686439384389e-12,  1.145686620373061e-14,  1.068695816695795e-17, -3.951783918712941e-19,
 -3.456575719275301e-21, -8.745615293163054e-24,  9.230103998324385e-26,  1.845066503698050e+00, -1.646667882375807e-03, -1.154086359070681e-05, -5.772711558767669e-08,
 -1.569075002037424e-10,  5.292874476417258e-13,  1.013813615970322e-14,  6.857726977067319e-17,  1.975232449310243e-19, -1.158981301938858e-21, -1.958878185544038e-23,
 -1.301226772302964e-25,  1.914056759722791e+00, -9.715250924920828e-04, -7.695024523840932e-06, -4.894776257202272e-08, -2.470126469626970e-10, -8.289984948128856e-13,
  4.453488666774841e-16,  3.561972140623533e-17,  3.477436649978391e-19,  2.142724631814616e-21,  7.627627666294232e-24, -1.386388577327671e-26,  1.964278961357239e+00,
 -4.221620174919173e-04, -3.641051126777229e-06, -2.688434427594640e-08, -1.767850681357716e-10, -1.037473758113890e-12, -5.280666898437084e-15, -2.114061099153108e-17,
 -3.890578643417045e-20,  3.810503646645150e-22,  5.933682849514992e-24,  5.304351138535320e-26,  1.993137676047585e+00, -8.318849939565618e-05, -7.525148497527873e-07,
 -6.010429066889863e-09, -4.462870028472576e-11, -3.148646950585186e-13, -2.133006410262731e-15, -1.394357003225292e-17, -8.809799158366031e-20, -5.374298493961526e-22,
 -3.153486528106101e-24, -1.766164568837644e-26,  9.259999110570901e-04, -6.341079905118570e-06,  3.255353207657194e-08, -1.485030612631550e-10,  6.346492126859412e-13,
 -2.602575454346443e-15,  1.036417283474430e-17, -4.041610802330039e-20,  1.548313313861627e-22, -5.860929373777121e-25,  2.187120906231933e-27, -8.124788240157344e-30,
  8.332999092794884e-03, -5.694678674412383e-05,  2.909962837195988e-07, -1.316574793092753e-09,  5.554560777007343e-12, -2.235790686867427e-14,  8.678243548074189e-17,
 -3.271097536182358e-19,  1.198954556420566e-21, -4.290948953869388e-24,  1.490390074212441e-26, -5.067963250041180e-29,  2.314155233896468e-02, -1.574990206166212e-04,
  7.972770654617732e-07, -3.546792912651947e-09,  1.456706564993096e-11, -5.633833565787552e-14,  2.064967480498692e-16, -7.179914649159315e-19,  2.346635337950141e-21,
 -7.118330771404769e-24,  1.908349559477583e-26, -4.152972617828660e-29,  4.534022875587856e-02, -3.066623479207792e-04,  1.530115687437911e-06, -6.629731860683770e-09,
  2.607354232366723e-11, -9.420927453569632e-14,  3.104453423554339e-16, -9.078919298802101e-19,  2.156890869939852e-21, -2.841185816145744e-24, -9.678028118361925e-27,
  1.036108499347386e-28,  7.491049865496489e-02, -5.023905727845218e-04,  2.457429178596721e-06, -1.025766944198881e-08,  3.781932825241117e-11, -1.222815098011916e-13,
  3.274789668819260e-16, -5.793500637728137e-19, -5.453975298426343e-22,  1.166716141195860e-23, -7.241929923307750e-26,  3.250085612700716e-28,  1.118249825784887e-01,
 -7.418741073875034e-04,  3.536178620397547e-06, -1.403329767866728e-08,  4.707439947600107e-11, -1.256705321403764e-13,  1.937241669442997e-16,  4.559258537890066e-19,
 -5.801698360685594e-21,  3.197301008500819e-23, -1.285592232107549e-25,  3.718900044983254e-28,  1.560449583421258e-01, -1.021468288816395e-03,  4.712242351899410e-06,
 -1.748308665780426e-08,  5.088783749606827e-11, -9.111690248533788e-14, -1.246070196802071e-16,  2.115343556432524e-18, -1.187253294944626e-20,  4.456424444714797e-23,
 -1.038488174541686e-25, -5.953440502815958e-29,  2.075169764789955e-01, -1.336601618930162e-03,  5.920397451235273e-06, -2.007691662461562e-08,  4.642513814588767e-11,
 -1.034728807132603e-14, -6.083090434679031e-16,  3.946499863326846e-18, -1.519329088969040e-20,  3.075522442001124e-23,  6.512763600599000e-26, -1.003848914622456e-27,
  2.661683786985704e-01, -1.681663088757500e-03,  7.084533262741869e-06, -2.125610922906100e-08,  3.139523219190128e-11,  1.162732604410024e-13, -1.167245026855850e-15,
  5.124876603058119e-18, -1.129476591245024e-20, -2.287558436613178e-23,  3.583725148878205e-25, -1.891062153238679e-27,  3.319014445172815e-01, -2.049868412787446e-03,
  8.118279826627563e-06, -2.047250758326511e-08,  4.566763890814123e-12,  2.762571061093297e-13, -1.634519414961341e-15,  4.606064871753358e-18,  3.124377278269547e-21,
 -1.094244201443618e-22,  6.091832554531450e-25, -1.546270244041022e-27,  4.045858041468245e-01, -2.433106473080426e-03,  8.926316391502625e-06, -1.724166256818067e-08,
 -3.364288508019336e-11,  4.424501488317831e-13, -1.781912234906522e-15,  1.477666266403909e-18,  2.720645919733335e-20, -1.886423964234193e-22,  5.170649161722894e-25,
  1.093452589296252e-27,  4.840486470061084e-01, -2.821770093834279e-03,  9.406737051340185e-06, -1.121323424720904e-08, -8.055244729711623e-11,  5.726226008196083e-13,
 -1.366626412510092e-15, -4.489810061045034e-18,  5.300102018285369e-20, -1.880620414738373e-22, -1.900930266127919e-25,  5.502253328242134e-27,  5.700621215975245e-01,
 -3.204580280961938e-03,  9.454996397953671e-06, -2.260936271072483e-09, -1.306733186054610e-10,  6.128756882197205e-13, -2.170461175073940e-16, -1.219368098284198e-17,
  6.458421608830550e-20, -3.303654497913191e-23, -1.430144103609338e-24,  8.183318113623680e-27,  6.623271634912405e-01, -3.568421575297644e-03,  8.970135284059809e-06,
  9.408118780329420e-09, -1.754154108923020e-10,  5.069343397535789e-13,  1.644114353495005e-15, -1.872229994347283e-17,  4.213749559372278e-20,  2.868029748610805e-22,
 -2.429091676572695e-24,  3.454600088028342e-27,  7.604528102781059e-01, -3.898220127053703e-03,  7.864174265691991e-06,  2.313040405880307e-08, -2.033316170854576e-10,
  2.132865937195899e-13,  3.862406423759112e-15, -1.954463972643864e-17, -2.637069572311631e-20,  6.343008070410004e-22, -1.780795002321398e-24, -1.127571849844251e-26,
  8.639298871423643e-01, -4.176918234738519e-03,  6.075697819216524e-06,  3.766589408621580e-08, -2.013211006332068e-10, -2.692756530009436e-13,  5.661517430107214e-15,
 -1.002339463600010e-17, -1.266700400053155e-19,  6.957680938443029e-22,  1.547000730823387e-24, -2.678045387739094e-26,  9.720978258717434e-01, -4.385632859082197e-03,
  3.588591123546274e-06,  5.111641538128521e-08, -1.573075154621959e-10, -8.711682020852293e-13,  5.914109376097337e-15,  1.128858304584683e-17, -2.023923484095548e-19,
  1.279529612844326e-22,  6.212931540832877e-24, -1.967196590999085e-26,  1.084103421952366e+00, -4.504134460213913e-03,  4.563378928789116e-07,  6.094706557396792e-08,
 -6.482856302900292e-11, -1.428156419075422e-12,  3.525450661684368e-15,  3.820033574653566e-17, -1.647303491167932e-19, -1.038648004088820e-21,  7.191599363814902e-24,
  2.606562121164196e-26,  1.198850746756711e+00, -4.511847389831916e-03, -3.169291330370828e-06,  6.421265325729391e-08,  7.056494239802694e-11, -1.688092077640444e-12,
 -1.773281422758730e-15,  5.437337174120219e-17,  4.430405688687440e-20, -1.946612894715290e-21, -9.710625408522865e-25,  7.406234964296814e-26,  1.314942583602186e+00,
 -4.389646377730439e-03, -7.009761861930222e-06,  5.812164927349523e-08,  2.246273865611752e-10, -1.383346288706765e-12, -8.413589149179395e-15,  3.885407088011216e-17,
  3.404002843934988e-19, -1.149025662811818e-21, -1.442320463145100e-23,  3.282043827010758e-26,  1.430616243058994e+00, -4.122776308500907e-03, -1.064233736474516e-05,
  4.105035851122279e-08,  3.516119743421008e-10, -3.953606378515066e-13, -1.257321906291243e-14, -1.515771296814044e-17,  4.446130088484778e-19,  1.657887781851965e-21,
 -1.451113942063246e-23, -1.057818852248648e-25,  1.543681263468808e+00, -3.705181988920298e-03, -1.351372907437291e-05,  1.396160764039166e-08,  3.926267531629845e-10,
  1.025512695174321e-12, -9.796015851217097e-15, -7.651087263218529e-17,  9.482686407720450e-20,  3.592749185611241e-21,  1.018650063658518e-23, -1.206215458766791e-25,
  1.651474158530249e+00, -3.145259677464569e-03, -1.501419558040093e-05, -1.822974514022803e-08,  3.025035813796880e-10,  2.161353053495472e-12,  6.187776457734556e-16,
 -8.169367878646965e-17, -4.812083348979853e-19,  8.561971573411708e-22,  2.674747459656331e-23,  1.144658827197258e-25,  1.750856098968101e+00, -2.472327224054185e-03,
 -1.464081355260993e-05, -4.646907783240709e-08,  9.203232293078196e-11,  2.147695902709020e-12,  1.155992364967724e-14, -4.008314852828027e-18, -5.247809096407280e-19,
 -3.708308102536249e-21, -3.406098626293947e-24,  1.519398664464891e-25,  1.838290732010728e+00, -1.741807477790974e-03, -1.224825813099909e-05, -6.013906431311564e-08,
 -1.437295582042855e-10,  7.963146815084609e-13,  1.213937354421022e-14,  7.406778668550865e-17,  1.402821473456722e-19, -2.060624657215131e-21, -2.556176825552304e-23,
 -1.393867484975973e-25,  1.910043722423235e+00, -1.035503223252310e-03, -8.306655163633690e-06, -5.303166129193317e-08, -2.633981389628440e-10, -8.050111115463070e-13,
  1.610497326945998e-15,  4.803895937563453e-17,  4.301554276240351e-19,  2.427619654897906e-21,  6.394289240878371e-24, -4.452935646814739e-26,  1.962529943236929e+00,
 -4.526305832766893e-04, -3.981342218461004e-06, -2.988599076738200e-08, -1.988505171970354e-10, -1.171439260242983e-12, -5.887616915921792e-15, -2.211540890167176e-17,
 -2.030272712187232e-20,  6.707032595314797e-22,  8.698352672198056e-24,  7.357355282193971e-26,  1.992792407227791e+00, -8.950975514366273e-05, -8.291415513150855e-07,
 -6.777786774902102e-09, -5.147126527341716e-11, -3.710792373688647e-13, -2.565985615584864e-15, -1.709821255307380e-17, -1.099158723954181e-19, -6.805137367851560e-22,
 -4.037605252777658e-24, -2.273202240449108e-26,  9.011454003152465e-04, -6.087611040840360e-06,  3.083074671670895e-08, -1.387519459840233e-10,  5.849962542477695e-13,
 -2.366874157510002e-15,  9.298830760338859e-18, -3.578288538294611e-20,  1.352242244774179e-22, -5.053587866073330e-25,  1.859010354630285e-27, -6.830147200043383e-30,
  8.109769915727380e-03, -5.468053448785175e-05,  2.757162260626302e-07, -1.231168959337820e-09,  5.127510354238371e-12, -2.038084060069653e-14,  7.813806711920353e-17,
 -2.911039629271878e-19,  1.054694237051797e-21, -3.737163715901940e-24,  1.283824961659701e-26, -4.341502843473055e-29,  2.252404861629849e-02, -1.512871718290327e-04,
  7.560776594376659e-07, -3.322471409796286e-09,  1.348827261968829e-11, -5.161540500841966e-14,  1.874067850576767e-16, -6.468555123013260e-19,  2.103679768885164e-21,
 -6.391023890297133e-24,  1.729548599832126e-26, -3.966243271716269e-29,  4.413756718227933e-02, -2.947326981574261e-04,  1.453001075091721e-06, -6.227232350751736e-09,
  2.426184451410426e-11, -8.705593565892582e-14,  2.859747954898697e-16, -8.405742302984955e-19,  2.048664963686725e-21, -3.145140216963394e-24, -5.707125994109870e-27,
  7.785446969421657e-29,  7.293948992883799e-02, -4.832134037526817e-04,  2.337888463134767e-06, -9.671703745060257e-09,  3.545097042637703e-11, -1.146182795925389e-13,
  3.110721408528035e-16, -5.906145948388815e-19, -1.742251102819193e-22,  9.040047277815534e-24, -5.932688618399905e-26,  2.713821089158274e-28,  1.089130163030591e-01,
 -7.142456618341571e-04,  3.372216077322889e-06, -1.329995797962284e-08,  4.460841263744023e-11, -1.208879111373975e-13,  2.040570750919997e-16,  2.877270186562172e-19,
 -4.739361166825456e-21,  2.714991378760316e-23, -1.128028260444531e-25,  3.434848899827393e-28,  1.520331717070244e-01, -9.845958361254302e-04,  4.507269934115536e-06,
 -1.668360306542516e-08,  4.904017567273561e-11, -9.343819297457454e-14, -7.046085015337441e-17,  1.760286393750294e-18, -1.034336318270981e-20,  4.038592603240552e-23,
 -1.044320119983708e-25,  2.778155365211918e-29,  2.022637883170791e-01, -1.290189524379599e-03,  5.683921966600246e-06, -1.933652661983973e-08,  4.608086934360108e-11,
 -2.367458113858427e-14, -5.044440879593863e-16,  3.478450443737949e-18, -1.404917655897756e-20,  3.255088970859686e-23,  2.640409448458095e-26, -7.637321397701406e-28,
  2.595534756880586e-01, -1.625998409309741e-03,  6.832545835712530e-06, -2.073665583460734e-08,  3.345196785628891e-11,  8.993983049281135e-14, -1.028913536048970e-15,
  4.752876024822632e-18, -1.187964430508418e-20, -1.013149241255007e-23,  2.806502903326286e-25, -1.641673366724448e-27,  3.238303097228606e-01, -1.985903206097122e-03,
  7.873223690645736e-06, -2.035732562934510e-08,  9.710111452588343e-12,  2.385841005998943e-13, -1.504709335891226e-15,  4.647583886804309e-18, -3.930426674931453e-22,
 -8.645520076053607e-23,  5.385664457188528e-25, -1.644506724270280e-27,  3.949948768992907e-01, -2.362532035111800e-03,  8.716471256542989e-06, -1.771146456082265e-08,
 -2.521770736009362e-11,  4.002729993805924e-13, -1.729341088043651e-15,  2.243685814323319e-18,  2.079695414782467e-20, -1.672428712765289e-22,  5.472138744099089e-25,
  3.108886873037775e-28,  4.729111924183589e-01, -2.747075484323276e-03,  9.264817255055462e-06, -1.241227524417046e-08, -6.943720472647836e-11,  5.385003455760394e-13,
 -1.469622259114336e-15, -2.903117522642173e-18,  4.614886297150823e-20, -1.911966056945968e-22,  2.425757053671554e-26,  4.252873811435713e-27,  5.573948596315371e-01,
 -3.129083448689067e-03,  9.415723798160202e-06, -4.254044186845621e-09, -1.184943502729285e-10,  6.038015647845400e-13, -5.297889157911283e-16, -1.015635777451972e-17,
  6.245098918785228e-20, -8.315486960165077e-23, -1.079318813699510e-24,  7.698799671947031e-27,  6.481976480444817e-01, -3.496255832719692e-03,  9.066533871229445e-06,
  6.684550246190690e-09, -1.649237732949738e-10,  5.402636385258407e-13,  1.140187956348222e-15, -1.722711631842361e-17,  5.075618378202670e-20,  1.933368213473796e-22,
 -2.229449240717294e-24,  5.482961553881267e-27,  7.449874368570221e-01, -3.834251423745064e-03,  8.122375851168611e-06,  1.991607310307159e-08, -1.981836400554676e-10,
  2.993425778762129e-13,  3.306672047157154e-15, -2.003778016411366e-17, -4.925044159052511e-21,  5.545219682916974e-22, -2.174668172123746e-24, -6.684329052465963e-27,
  8.473222101893407e-01, -4.126559810448811e-03,  6.508207634997355e-06,  3.440895162711182e-08, -2.053728501936675e-10, -1.372016194865559e-13,  5.327951687760466e-15,
 -1.366639600002508e-17, -1.007863838800678e-19,  7.347791675189044e-22,  4.236857010967275e-25, -2.402533619482180e-26,  9.546165346527559e-01, -4.354514603390757e-03,
  4.186336858916593e-06,  4.846791459165230e-08, -1.732896488910365e-10, -7.261625371730286e-13,  6.140541926392463e-15,  4.931870811185432e-18, -1.935406872289743e-19,
  3.570733368211299e-22,  5.196599615978677e-24, -2.605131240313802e-26,  1.066098789778358e+00, -4.497578070462116e-03,  1.180552412926265e-06,  5.968625325404572e-08,
 -9.246216258829581e-11, -1.331338469185926e-12,  4.516047254428390e-15,  3.238820758370791e-17, -1.967066678899733e-19, -7.323767314186452e-22,  8.013768160042064e-24,
  1.123678442218771e-26,  1.180757552395966e+00, -4.534102897798676e-03, -2.393085468439258e-06,  6.506980493036957e-08,  3.650138482088086e-11, -1.712286037923116e-12,
 -2.415304535425181e-16,  5.466871529206435e-17, -2.569066194111940e-20, -1.920695356641161e-21,  2.243752993917102e-24,  7.088842468681023e-26,  1.297276342544063e+00,
 -4.442875706853373e-03, -6.291685326253983e-06,  6.148377223991571e-08,  1.950355053879430e-10, -1.571028695547397e-12, -7.180169288108320e-15,  4.897704027983024e-17,
  2.890777622136600e-19, -1.688433514145868e-21, -1.233980691077199e-23,  6.123443949777632e-26,  1.413958114346185e+00, -4.205849659818397e-03, -1.011629268356575e-05,
  4.659638220949311e-08,  3.406613389717958e-10, -7.005522423558039e-13, -1.279032556885913e-14, -9.591934022293060e-20,  4.927837608431592e-19,  9.907562392054771e-22,
 -1.866249187928275e-23, -8.068971925178433e-26,  1.528645529645002e+00, -3.812513397669988e-03, -1.330786412633502e-05,  2.039422305908574e-08,  4.106147252339251e-10,
  7.651656044546251e-13, -1.187589727045711e-14, -7.133952550969885e-17,  2.301007050870401e-19,  3.880944136812598e-21,  3.912009989250518e-24, -1.632300709635293e-25,
  1.638651627724947e+00, -3.266162702388269e-03, -1.520248527097037e-05, -1.304387305377175e-08,  3.456850234986836e-10,  2.147050687900850e-12, -1.878066586701041e-15,
 -9.638342711727907e-17, -4.300054684918245e-19,  2.016360671955069e-21,  3.095849716233900e-23,  7.294561722920917e-26,  1.740729045172487e+00, -2.591655853319357e-03,
 -1.518814126509448e-05, -4.463792906620998e-08,  1.377411989277649e-10,  2.421765720289588e-12,  1.119241349519766e-14, -2.294936561691308e-17, -6.589470762553333e-19,
 -3.691662313621852e-21,  4.719322698347218e-24,  2.178311929123893e-25,  1.831122905938105e+00, -1.842717995588203e-03, -1.298314614937988e-05, -6.229478385016487e-08,
 -1.247195251120475e-10,  1.112977786183151e-12,  1.426348948230645e-14,  7.716057167084853e-17,  4.622010209757539e-20, -3.205153747747575e-21, -3.161363310364927e-23,
 -1.322148199701252e-25,  1.905764669903317e+00, -1.104574836182130e-03, -8.968844505824693e-06, -5.737224683893245e-08, -2.789945019740512e-10, -7.485802341579329e-13,
  3.161762318075835e-15,  6.324704957861902e-17,  5.215698204974907e-19,  2.631692699623138e-21,  3.466839232079050e-24, -9.163317419574278e-26,  1.960653369322754e+00,
 -4.859717674390135e-04, -4.359862354298134e-06, -3.326291832555348e-08, -2.237427636809284e-10, -1.320221382466372e-12, -6.511796587460706e-15, -2.230485363577612e-17,
  1.095217719087942e-20,  1.090791230221445e-21,  1.250155147785646e-23,  1.004321000022525e-25,  1.992420566293587e+00, -9.648280812121860e-05, -9.156724477279765e-07,
 -7.664215969405575e-09, -5.954961970128249e-11, -4.388291487420842e-13, -3.097894893578563e-15, -2.104072827383590e-17, -1.375786154514213e-19, -8.638138741075471e-22,
 -5.174452742795598e-24, -2.919686690454446e-26,  8.772779229440201e-04, -5.847469562058038e-06,  2.922035923655854e-08, -1.297589121722289e-10,  5.398117924547561e-13,
 -2.155252609290627e-15,  8.354854434508829e-18, -3.173301310480147e-20,  1.183003974799942e-22, -4.366792444503714e-25,  1.582750341226889e-27, -5.760856731341933e-30,
  7.895367597490276e-03, -5.253253643696007e-05,  2.614213108345540e-07, -1.152290540380095e-09,  4.738005649761080e-12, -1.859964500697061e-14,  7.044011918409392e-17,
 -2.594108647245285e-19,  9.289567777248903e-22, -3.259957697922048e-24,  1.106669248655706e-26, -3.728335507187768e-29,  2.193074974172900e-02, -1.453944372687809e-04,
  7.174695856281541e-07, -3.114679158118765e-09,  1.249951350818313e-11, -4.732758661427914e-14,  1.702036233858506e-16, -5.830888441393868e-19,  1.885640830996561e-21,
 -5.733472117657831e-24,  1.559823540422374e-26, -3.745144094769003e-29,  4.298142028228476e-02, -2.834011274292566e-04,  1.380547153448923e-06, -5.852606747440930e-09,
  2.258749116576102e-11, -8.046767157251818e-14,  2.633392202166518e-16, -7.768662992148457e-19,  1.932097666696150e-21, -3.311290729252772e-24, -2.749706659634569e-27,
  5.733626261844272e-29,  7.104332086651609e-02, -4.649650667757402e-04,  2.225156961876905e-06, -9.122427135191917e-09,  3.323192059674934e-11, -1.073513398180603e-13,
  2.945026697916401e-16, -5.914182340167877e-19,  1.112494050943158e-22,  6.891657472070238e-24, -4.842981130631373e-26,  2.250681838167772e-28,  1.061089952057171e-01,
 -6.878943797188257e-04,  3.216820071863112e-06, -1.260529691067660e-08,  4.224019582972374e-11, -1.159101298848037e-13,  2.101310929979646e-16,  1.508639853317555e-19,
 -3.839623933735455e-21,  2.293080841485175e-23, -9.838640573061065e-26,  3.113936083220413e-28,  1.481656553711592e-01, -9.493252932143367e-04,  4.311712631566715e-06,
 -1.591398614453526e-08,  4.715830583797354e-11, -9.457388409645488e-14, -2.559381741867982e-17,  1.451758426278727e-18, -8.964188203286224e-21,  3.625228479802243e-23,
 -1.018212079014554e-25,  8.675759103734786e-29,  1.971925210374258e-01, -1.245633808026360e-03,  5.456289742935399e-06, -1.860364622362420e-08,  4.549394233056671e-11,
 -3.466219322097881e-14, -4.131642503378664e-16,  3.047767924008899e-18, -1.286587162887847e-20,  3.299594262237846e-23, -2.717328376745918e-27, -5.667614722753678e-28,
  2.531572398134322e-01, -1.572324174955770e-03,  6.586972490532222e-06, -2.018833120832396e-08,  3.501438157447717e-11,  6.679965220793649e-14, -9.011952695857135e-16,
  4.368921348585022e-18, -1.205905725353890e-20, -2.777245503032754e-25,  2.138097864263875e-25, -1.398589266364920e-27,  3.160111255117893e-01, -1.923891576932478e-03,
  7.630019184161117e-06, -2.016570834695123e-08,  1.413118492542290e-11,  2.040285127706872e-13, -1.375192145288032e-15,  4.589224047533761e-18, -3.135165824666514e-21,
 -6.636566570855700e-23,  4.659153487784138e-25, -1.644308694626714e-27,  3.856828573278691e-01, -2.293656680699499e-03,  8.501769718816622e-06, -1.805313661636525e-08,
 -1.762183495646946e-11,  3.595924818054317e-13, -1.658075751027560e-15,  2.817096286263106e-18,  1.517178068038939e-20, -1.452670764747195e-22,  5.472973939914980e-25,
 -2.769643580618245e-28,  4.620701586236593e-01, -2.673570816469654e-03,  9.109553114549229e-06, -1.343905156866100e-08, -5.902565593383313e-11,  5.024144935644280e-13,
 -1.531266263231016e-15, -1.535950811122110e-18,  3.932517123747323e-20, -1.868310131803050e-22,  1.856452162135324e-25,  3.103343524749809e-27,  5.450288098121614e-01,
 -3.053993170061682e-03,  9.353695827006408e-06, -6.054129049527824e-09, -1.065673486229270e-10,  5.878968695817280e-13, -7.866945542382718e-16, -8.213505740303914e-18,
  5.875999315862196e-20, -1.197705484633284e-22, -7.573227042743516e-25,  6.896681793881312e-27,  6.343581350445123e-01, -3.423446732544516e-03,  9.131276742107579e-06,
  4.133538236993269e-09, -1.538829528944903e-10,  5.620292007410969e-13,  6.814939625528682e-16, -1.550826979632182e-17,  5.617315275064621e-20,  1.094019730967507e-22,
 -1.958308843799103e-24,  6.718196526505728e-27,  7.297818273287145e-01, -3.768369869309583e-03,  8.342554110953680e-06,  1.679715072515288e-08, -1.914486488849290e-10,
  3.719700364668887e-13,  2.746286203285734e-15, -1.989326489077952e-17,  1.341258125334425e-20,  4.629052380561119e-22, -2.376247019404680e-24, -2.579472891172481e-27,
  8.309226382679444e-01, -4.072898545185506e-03,  6.901330842513614e-06,  3.110784506681334e-08, -2.068709490775368e-10, -1.426262297986448e-14,  4.904128584833762e-15,
 -1.646705951903907e-17, -7.427409323076070e-20,  7.316920789954417e-22, -5.488094712152490e-25, -2.002124910395918e-26,  9.372690732577454e-01, -4.318745634965376e-03,
  4.750862796434786e-06,  4.558713599629238e-08, -1.863315455340290e-10, -5.778190104681685e-13,  6.194133209224377e-15, -1.017959074153813e-18, -1.772323355695879e-19,
  5.407803916322923e-22,  3.963510871936843e-24, -2.951930333753882e-26,  1.048131864366889e+00, -4.485295844607452e-03,  1.887052287799732e-06,  5.800002867185116e-08,
 -1.179353954911932e-10, -1.212804319432440e-12,  5.331274253649228e-15,  2.573431801588096e-17, -2.172227309507210e-19, -4.062703566773548e-22,  8.186147406715594e-24,
 -3.212232967664728e-27,  1.162587807328123e+00, -4.550116904679633e-03, -1.609873389093587e-06,  6.538006432960728e-08,  2.320936910056747e-12, -1.699870100027169e-12,
  1.267447521027184e-15,  5.276357835130434e-17, -9.249000878339741e-20, -1.771015863069604e-21,  5.168349394671664e-24,  6.104368763954283e-26,  1.279408917189696e+00,
 -4.490207365143803e-03, -5.536222541204387e-06,  6.434409711012779e-08,  1.620079227683700e-10, -1.725910598956290e-12, -5.689089601627618e-15,  5.716543932363040e-17,
  2.201254426456720e-19, -2.120919826650801e-21, -9.118497707894317e-24,  8.397976949066329e-26,  1.396976525622722e+00, -4.284451888128735e-03, -9.524948923830276e-06,
  5.191822820531084e-08,  3.235897281551699e-10, -1.005742734412005e-12, -1.256794671539752e-14,  1.609341266940960e-17,  5.142498266088487e-19,  1.834552141379343e-22,
 -2.143013173875317e-23, -4.334782247436353e-26,  1.513184259267927e+00, -3.917884641634673e-03, -1.302326140651864e-05,  2.707033646769729e-08,  4.229108746521913e-10,
  4.571358494447085e-13, -1.374918435127710e-14, -6.172535265626844e-17,  3.708064202086362e-19,  3.883664228451613e-21, -3.998944714021071e-24, -1.937193769053894e-25,
  1.625342882836716e+00, -3.388311421195994e-03, -1.532441943728098e-05, -7.172778167249324e-09,  3.879489839087825e-10,  2.068113112404861e-12, -4.756797115605201e-15,
 -1.087379234449391e-16, -3.345104598219243e-19,  3.301239438185988e-21,  3.280519376513016e-23,  7.049362510077751e-27,  1.730116076880107e+00, -2.715262363787366e-03,
 -1.570892832021633e-05, -4.203225536338193e-08,  1.887978142098165e-10,  2.680168893456579e-12,  1.023501772759722e-14, -4.610573097042147e-17, -7.859634521917302e-19,
 -3.291995084548310e-21,  1.572619911928775e-23,  2.810710049074043e-25,  1.823539523708575e+00, -1.949605421898248e-03, -1.374185980449180e-05, -6.409288409359367e-08,
 -9.886135306627284e-11,  1.481279001425370e-12,  1.642554186287444e-14,  7.653842418926961e-17, -9.326379263341048e-20, -4.578430283693616e-21, -3.680592086904094e-23,
 -9.848988832253234e-26,  1.901198400159247e+00, -1.179156454505998e-03, -9.684573918425158e-06, -6.195117159794189e-08, -2.930537180171462e-10, -6.494726506393035e-13,
  5.180725631541314e-15,  8.147094743156639e-17,  6.176707006017449e-19,  2.671342795868488e-21, -1.980381941230664e-24, -1.598041968270690e-25,  1.958637107839817e+00,
 -5.225102073387873e-04, -4.781396108852204e-06, -3.706274047777747e-08, -2.517602379875408e-10, -1.483919369474486e-12, -7.124781675586974e-15, -2.122037482403349e-17,
  6.037224434898213e-20,  1.688727952948528e-21,  1.764374455810136e-23,  1.345500544759641e-25,  1.992019378040739e+00, -1.041929618639482e-04, -1.013663085288051e-06,
 -8.691471843929249e-09, -6.912011623288005e-11, -5.207760219139261e-13, -3.753645472934921e-15, -2.598339355077653e-17, -1.727315380376984e-19, -1.098752423800455e-21,
 -6.631818300321619e-24, -3.734909927762822e-26,  8.543459118222205e-04, -5.619791493813133e-06,  2.771368623944059e-08, -1.214561637642225e-10,  4.986420855697634e-13,
 -1.964984721844067e-15,  7.517049662085875e-18, -2.818718806716952e-20,  1.036609371262475e-22, -3.781666659744263e-25,  1.349300321388585e-27, -4.878685297483910e-30,
  7.689334401492276e-03, -5.049521484539694e-05,  2.480366880604439e-07, -1.079368949786208e-09,  4.382346945439809e-12, -1.699299055179526e-14,  6.357573571690459e-17,
 -2.314796612998479e-19,  8.191855015772850e-22, -2.848516201800294e-24,  9.542896846244992e-27, -3.213074821691965e-29,  2.136041949716001e-02, -1.398008558387069e-04,
  6.812628568832074e-07, -2.922042841055590e-09,  1.159252264497790e-11, -4.343198551944444e-14,  1.546917133486090e-16, -5.259335817813364e-19,  1.690075599202515e-21,
 -5.141822237379923e-24,  1.400101728165550e-26, -3.515394224968842e-29,  4.186946824401570e-02, -2.726316516440084e-04,  1.312432255404817e-06, -5.503745593386948e-09,
  2.103961285164144e-11, -7.440168168799941e-14,  2.424344985922547e-16, -7.169630808950053e-19,  1.811472497202474e-21, -3.375922402903737e-24, -6.015173830715629e-28,
  4.089362075603362e-29,  6.921838235537521e-02, -4.475928092077353e-04,  2.118808477366488e-06, -8.607514208789235e-09,  3.115423610923465e-11, -1.004813736488383e-13,
  2.780275395988050e-16, -5.842439042493852e-19,  3.267544641266392e-22,  5.140334701087056e-24, -3.942732567930527e-26,  1.850973901145844e-28,  1.034079447956277e-01,
 -6.627535584593854e-04,  3.069535957986408e-06, -1.194772419129565e-08,  3.997269823900326e-11, -1.108294411662245e-13,  2.127539717426589e-16,  4.047083294871106e-20,
 -3.081740707269600e-21,  1.925951317425531e-23, -8.542436829573814e-26,  2.776344792630739e-28,  1.444361500565311e-01, -9.155827803403872e-04,  4.125209504713375e-06,
 -1.517460519418592e-08,  4.526381572073994e-11, -9.473158139610401e-14,  1.123010235358309e-17,  1.185007887891086e-18, -7.731383182720352e-21,  3.226802084647276e-23,
 -9.712534571313923e-26,  1.234424643787383e-28,  1.922958899600675e-01, -1.202864146795459e-03,  5.237388861756608e-06, -1.788179967164473e-08,  4.470821559742422e-11,
 -4.359951252342345e-14, -3.334125022014683e-16,  2.654998934663928e-18, -1.168553158603717e-20,  3.243766680466717e-23, -2.404683023312141e-26, -4.088491065899592e-28,
  2.469718139303053e-01, -1.520587816913871e-03,  6.348114289541827e-06, -1.961854750935543e-08,  3.614377127423052e-11,  4.659536463049155e-14, -7.842583414025049e-16,
  3.984405891371291e-18, -1.192932071601404e-20,  7.111962259201411e-24,  1.573220042021632e-25, -1.172501706324219e-27,  3.084361127380070e-01, -1.863815235088850e-03,
  7.389516246582050e-06, -1.990871461824393e-08,  1.789204992530995e-11,  1.725524613243600e-13, -1.248432768715936e-15,  4.454128341504259e-18, -5.206169266339421e-21,
 -4.916010300128601e-23,  3.948577987106209e-25, -1.576753145599063e-27,  3.766428808184999e-01, -2.226513333975359e-03,  8.283670786112696e-06, -1.827968556399364e-08,
 -1.082127075352294e-11,  3.207953874413248e-13, -1.573156338489958e-15,  3.223112450750340e-18,  1.033203681441124e-20, -1.237535375093172e-22,  5.253304579915742e-25,
 -6.960783757160657e-28,  4.515205851642629e-01, -2.601354770372307e-03,  8.942943124285603e-06, -1.430508465878951e-08, -4.934764475877194e-11,  4.652840663531866e-13,
 -1.557654665824903e-15, -3.834783941163137e-19,  3.276299980935586e-20, -1.769826905274581e-22,  2.994062555233270e-25,  2.092431514522500e-27,  5.329619963987717e-01,
 -2.979482301393329e-03,  9.271200297317699e-06, -7.666243400904838e-09, -9.501576566970686e-11,  5.664647598037381e-13, -9.910347628504996e-16, -6.407443389709195e-18,
  5.397357291648950e-20, -1.442754200321559e-22, -4.751199417639066e-25,  5.909965275460226e-27,  6.208107047327636e-01, -3.350239105595459e-03,  9.166479860863886e-06,
  1.762080388013103e-09, -1.425129197995562e-10,  5.733805125186597e-13,  2.729156941048697e-16, -1.366224005809846e-17,  5.877484431939663e-20,  3.718807139301791e-23,
 -1.648427425928983e-24,  7.263840299239902e-27,  7.148430325580203e-01, -3.700874659494677e-03,  8.525997434953764e-06,  1.379688038544783e-08, -1.833949437982218e-10,
  4.312600061535723e-13,  2.197657109279940e-15, -1.921593110944324e-17,  2.834865265688456e-20,  3.666438004991163e-22, -2.411994247472069e-24,  8.281823365615574e-28,
  8.147437501612468e-01, -4.016250971708595e-03,  7.254776234615466e-06,  2.780186155707386e-08, -2.060178434041347e-10,  9.765910226986319e-14,  4.413696247270973e-15,
 -1.842825586831151e-17, -4.852842736548185e-20,  6.934675926808158e-22, -1.328289182079500e-24, -1.534419710073849e-26,  9.200734965016902e-01, -4.278602058148770e-03,
  5.279665349779131e-06,  4.252143639539124e-08, -1.964068745079809e-10, -4.301237007836429e-13,  6.089360270039602e-15, -6.349873863575732e-18, -1.552274660610555e-19,
  6.729501838218553e-22,  2.640011050503945e-24, -3.020798626410624e-26,  1.030225234167901e+00, -4.467449300494011e-03,  2.570953537395580e-06,  5.592619634260336e-08,
 -1.408577192377368e-10, -1.077003749853343e-12,  5.952768438861060e-15,  1.861186327300714e-17, -2.260242551425893e-19, -8.554661115583250e-23,  7.757763935589215e-24,
 -1.586519723160501e-26,  1.144366548121303e+00, -4.559859588007654e-03, -8.262050113774472e-07,  6.514736840852157e-08, -3.125458273092339e-11, -1.652114599927180e-12,
  2.694121176226552e-15,  4.882870607054300e-17, -1.519149923226976e-19, -1.514684889939470e-21,  7.538131060910709e-24,  4.596404499756592e-26,  1.261364457014805e+00,
 -4.531367231482419e-03, -4.749702227564998e-06,  6.665321721444673e-08,  1.262577862523600e-10, -1.842518070553371e-12, -4.001778029288886e-15,  6.292494051141535e-17,
  1.381429983307023e-19, -2.406897940443560e-21, -5.077367932831270e-24,  9.809894241685543e-26,  1.379690386782680e+00, -4.358073022467456e-03, -8.871581949465656e-06,
  5.691854309953815e-08,  3.005046805136414e-10, -1.300106432231015e-12, -1.188715173045806e-14,  3.248667590348421e-17,  5.050825593968464e-19, -6.988745042803862e-22,
 -2.235269299801987e-23,  2.372559262656445e-27,  1.497306569028167e+00, -4.020655749428770e-03, -1.265757583577985e-05,  3.389156139976591e-08,  4.286212667618766e-10,
  1.078842059914626e-13, -1.529067284628447e-14, -4.767042261319003e-17,  5.056377211578951e-19,  3.548361117074084e-21, -1.284693877915627e-23, -2.047138107676710e-25,
  1.611544054369573e+00, -3.511142449912915e-03, -1.537190768851895e-05, -6.419546419370541e-10,  4.279172448451172e-10,  1.916323305278023e-12, -7.931651239428876e-15,
 -1.172883136222312e-16, -1.921909028208803e-19,  4.595257060948684e-21,  3.125726577653111e-23, -8.047575024423814e-26,  1.719000568096164e+00, -2.842895827424827e-03,
 -1.619337997558401e-05, -3.856980826306042e-08,  2.447378935561784e-10,  2.907371202073003e-12,  8.575139801384584e-15, -7.300619166527077e-17, -8.900272152972610e-19,
 -2.400012293151462e-21,  2.921848423310837e-23,  3.282372237122029e-25,  1.815516326390309e+00, -2.062641254771656e-03, -1.451941610602867e-05, -6.541552166909910e-08,
 -6.512248065188507e-11,  1.900709027567337e-12,  1.849998712722595e-14,  7.062520608310607e-17, -2.854737239527423e-19, -6.119368901621175e-21, -3.971960973104469e-23,
 -2.672547296710538e-26,  1.896321999095499e+00, -1.259687351990946e-03, -1.045652568467272e-05, -6.673637412774303e-08, -3.046031038302504e-10, -4.954395546913439e-13,
  7.752890007567491e-15,  1.027445715821750e-16,  7.104898181342199e-19,  2.426007560115613e-21, -1.096384898148644e-23, -2.528409863556457e-25,  1.956467648177502e+00,
 -5.626111834402173e-04, -5.251328000152649e-06, -4.133781942082548e-08, -2.831953154826262e-10, -1.661764526538204e-12, -7.681724446166490e-15, -1.816727523300996e-17,
  1.354024244081665e-19,  2.524594677790658e-21,  2.445241658698584e-23,  1.761057728165067e-25,  1.991585699404686e+00, -1.127390825222170e-04, -1.124956550136681e-06,
 -9.885871706678112e-09, -8.049883195529016e-11, -6.202569927116474e-13, -4.564895115871219e-15, -3.219826248414107e-17, -2.174830467693903e-19, -1.399717491154383e-21,
 -8.490007687109528e-24, -4.745298821689952e-26,  8.323011217777140e-04, -5.403779193508747e-06,  2.630281605927061e-08, -1.137827474736298e-10,  4.610844396679062e-13,
 -1.793683804257738e-15,  6.772273758776175e-18, -2.507785175223208e-20,  9.096875732076968e-23, -3.282640317894755e-25,  1.151106110639875e-27, -4.154125652590954e-30,
  7.491241746512139e-03, -4.856156435359432e-05,  2.354940132443601e-07, -1.011889525969668e-09,  4.057235231333916e-12, -1.554208007211818e-14,  5.744639375634738e-17,
 -2.068354844199338e-19,  7.231812358118466e-22, -2.493753117552283e-24,  8.226499714813355e-27, -2.783994031546787e-29,  2.081189857037147e-02, -1.344879226043409e-04,
  6.472831998512026e-07, -2.743314777516053e-09,  1.075984700059754e-11, -3.989015401655541e-14,  1.406956526718236e-16, -4.747077504486556e-19,  1.514683936290363e-21,
 -4.612063459448959e-24,  1.250269568182786e-26, -3.299165542607320e-29,  4.079953020151791e-02, -2.623907616846208e-04,  1.248359011682246e-06, -5.178706631325089e-09,
  1.960817080120494e-11, -6.881771541264421e-14,  2.231527875523646e-16, -6.609418674843858e-19,  1.689901889064236e-21, -3.368125479623149e-24,  8.939912110483087e-28,
  2.750949942515071e-29,  6.746126964789781e-02, -4.310471785223623e-04,  2.018443955067612e-06, -8.124766441572299e-09,  2.921001697416713e-11, -9.400367661772157e-14,
  2.618408348099908e-16, -5.711160159493246e-19,  4.852848762851251e-22,  3.715572729317225e-24, -3.206326554148960e-26,  1.504115818103389e-28,  1.008051502397652e-01,
 -6.387600556399278e-04,  2.929928398550961e-06, -1.132561610610475e-08,  3.780720719977676e-11, -1.057202735677698e-13,  2.126062013897787e-16, -4.768757442597437e-20,
 -2.447051426332398e-21,  1.607678402136591e-23, -7.396173346519536e-26,  2.433643919322444e-28,  1.408386862088991e-01, -8.832973174369750e-04,  3.947397122927667e-06,
 -1.446551575983663e-08,  4.337442688924911e-11, -9.409080614365723e-14,  4.111601596313517e-17,  9.554512498679436e-19, -6.638292022138708e-21,  2.849840043397852e-23,
 -9.121701733667728e-26,  1.425332773954420e-28,  1.875668896550713e-01, -1.161811270624486e-03,  5.027069137643347e-06, -1.717385438486998e-08,  4.376201405671773e-11,
 -5.075051627432401e-14, -2.641336132167817e-16,  2.299527549249986e-18, -1.053906882597055e-20,  3.115462174109361e-23, -3.920949161427705e-26, -2.857777045779549e-28,
  2.409895554461133e-01, -1.470734697406302e-03,  6.116189063486885e-06, -1.903377742459719e-08,  3.689627141650707e-11,  2.906906595729332e-14, -6.779927293544241e-16,
  3.607881446712021e-18, -1.157188882758099e-20,  1.243446699302746e-23,  1.102765705131711e-25, -9.702804579565289e-28,  3.010975781985600e-01, -1.805649604868196e-03,
  7.152438034202276e-06, -1.959641933724685e-08,  2.105347340442706e-11,  1.440663068837451e-13, -1.126294637973174e-15,  4.262129046808270e-18, -6.708087578334720e-21,
 -3.472346214684136e-23,  3.277712616053688e-25, -1.467658280828947e-27,  3.678679734299795e-01, -2.161123861543078e-03,  8.063480882641249e-06, -1.840351872504120e-08,
 -4.775434367372719e-12,  2.841559886145900e-13, -1.478921652340305e-15,  3.486445581093144e-18,  6.246916917439464e-21, -1.034443173825071e-22,  4.880955711120020e-25,
 -9.759675207519508e-28,  4.412571479526264e-01, -2.530510597975415e-03,  8.766845237426840e-06, -1.502223429983212e-08, -4.041608267326998e-11,  4.278841762886818e-13,
 -1.554654623746591e-15,  5.654710893554442e-19,  2.662696575961980e-20, -1.634284139539509e-22,  3.720748707647325e-25,  1.236663118536233e-27,  5.211917884016696e-01,
 -2.905705670644702e-03,  9.170453385258910e-06, -9.097211149589889e-09, -8.393786304354450e-11,  5.407172748943419e-13, -1.147067131249218e-15, -4.766569514921426e-18,
  4.849741839238001e-20, -1.583900467481890e-22, -2.383685790748954e-25,  4.846173000639051e-27,  6.075564923325022e-01, -3.276860577143749e-03,  9.174322823001653e-06,
 -4.261557940825197e-10, -1.310096937164048e-10,  5.755533039334900e-13, -8.318173016433447e-17, -1.177212279256410e-17,  5.900412861257399e-20, -2.232503649260999e-23,
 -1.327347056017042e-24,  7.249673610641702e-27,  7.001769289048523e-01, -3.632053639947706e-03,  8.674247504404741e-06,  1.093424768879166e-08, -1.742853085831766e-10,
  4.776612656708848e-13,  1.674163417974021e-15, -1.811608605976074e-17,  3.982761348861716e-20,  2.717201114087711e-22, -2.315188259425329e-24,  3.436996259129365e-27,
  7.987968567665285e-01, -3.956934124378468e-03,  7.568703472475251e-06,  2.452677867638522e-08, -2.030479799917932e-10,  1.972431092037122e-13,  3.879637055798304e-15,
 -1.959321783501006e-17, -2.466968761045507e-20,  6.282589567440050e-22, -1.896936792859239e-24, -1.051727480027518e-26,  9.030467183262221e-01, -4.234377731612508e-03,
  5.770809177542658e-06,  3.931797688097549e-08, -2.035651070255145e-10, -2.866508648382288e-13,  5.845794232983864e-15, -1.091173502823679e-17, -1.294179478411072e-19,
  7.523094078384359e-22,  1.340292786193373e-24, -2.852275974635469e-26,  1.012400766430295e+00, -4.444237113863992e-03,  3.227860323175904e-06,  5.350807710985913e-08,
 -1.609311464415089e-10, -9.287017667607559e-13,  6.372596899314395e-15,  1.138814553119170e-17, -2.237154147705789e-19,  2.076793375641966e-22,  6.831884206027247e-24,
 -2.569378269394553e-26,  1.126118826408007e+00, -4.563353141785642e-03, -4.851480110983735e-08,  6.438692422506194e-08, -6.354258705966791e-11, -1.571646782695113e-12,
  3.985505849957282e-15,  4.315680863472506e-17, -2.005760739625671e-19, -1.177939031975276e-21,  9.165630097344849e-24,  2.766659509191624e-26,  1.243168103249285e+00,
 -4.566133984282332e-03, -3.938974182772814e-06,  6.837392757968669e-08,  8.859194932468185e-11, -1.916999691074517e-12, -2.191247673949700e-15,  6.592851654637944e-17,
  4.889775730470204e-20, -2.521780113912202e-21, -6.393907311604322e-25,  1.018502312621800e-25,  1.362120587854449e+00, -4.426233925923346e-03, -8.160618341144410e-06,
  6.150344188640126e-08,  2.717326331604233e-10, -1.572685568202061e-12, -1.075625504280217e-14,  4.807526129296506e-17,  4.639842568649905e-19, -1.576612844213522e-21,
 -2.118049519772621e-23,  5.083366058254968e-26,  1.481024165216748e+00, -4.120172943856203e-03, -1.220972399919366e-05,  4.074640464920787e-08,  4.270110087949763e-10,
 -2.731667663203080e-13, -1.638052397910941e-14, -2.956286289455412e-17,  6.219745478544684e-19,  2.856509562412088e-21, -2.164428517537338e-23, -1.907652646195759e-25,
  1.597253653327428e+00, -3.634029291726043e-03, -1.533730289519246e-05,  6.499863084006637e-09,  4.640711925171774e-10,  1.686021120427048e-12, -1.127528421292911e-14,
 -1.205589045917651e-16, -5.373844323799701e-21,  5.745590881805038e-21,  2.552250359131461e-23, -1.814336787146459e-25,  1.707367059294173e+00, -2.974223161155293e-03,
 -1.663076979105878e-05, -3.417839444970646e-08,  3.047608331540755e-10,  3.085355077851047e-12,  6.121019620188310e-15, -1.026151711939912e-16, -9.518395670795479e-19,
 -9.352775453957833e-22,  4.412201430353388e-23,  3.421832441243295e-25,  1.807028458137268e+00, -2.181951192911917e-03, -1.530931972580809e-05, -6.612859286643871e-08,
 -2.251436395519242e-11,  2.367191973320839e-12,  2.031429200964157e-14,  5.765817578713975e-17, -5.343712238485893e-19, -7.700044270365658e-21, -3.843748952293140e-23,
  9.374569627289609e-26,  1.891110755440581e+00, -1.346626437809004e-03, -1.128689552802486e-05, -7.167815899999715e-08, -3.124045694151217e-10, -2.722017891759847e-13,
  1.096042798110057e-14,  1.267692745954253e-16,  7.869522020244511e-19,  1.731779529248644e-21, -2.461357842131696e-23, -3.716700292959295e-25,  1.954129928361307e+00,
 -6.066856436800310e-04, -5.775698244555875e-06, -4.614500676038045e-08, -3.183125106665872e-10, -1.851649385209930e-12, -8.114647145244436e-15, -1.217549246240404e-17,
  2.458845911002635e-19,  3.671307864854421e-21,  3.322920711637119e-23,  2.235310380810819e-25,  1.991115960238356e+00, -1.222361354933714e-04, -1.251744423166783e-06,
 -1.127936805617549e-08, -9.407684306909838e-11, -7.414685187381907e-13, -5.571946078237013e-15, -4.003378686033825e-17, -2.745198915140197e-19, -1.784512502162029e-21,
 -1.083849860901578e-23, -5.963616928396026e-26,  8.110983761045584e-04, -5.198695492132126e-06,  2.498053133219106e-08, -1.066837877625183e-10,  4.267808875339578e-13,
 -1.639257059515543e-15,  6.109132689021931e-18, -2.234739147663131e-20,  7.993767670722205e-23, -2.856929173945444e-25,  9.817334045594704e-28, -3.565753266356071e-30,
  7.300688017139069e-03, -4.672510252376734e-05,  2.237308131264288e-07, -9.493875080494478e-10,  3.759724832398866e-12, -1.423032906110316e-14,  5.196592842984318e-17,
 -1.850689079671679e-19,  6.390439865076121e-22, -2.188105077403997e-24,  7.081433461149906e-27, -2.433408012411206e-29,  2.028409897254464e-02, -1.294384688995716e-04,
  6.153706225147465e-07, -2.577360605627976e-09,  9.994761907465701e-12, -3.666763309396866e-14,  1.280581254480524e-16, -4.288006972002867e-19,  1.357306949962653e-21,
 -4.140423335115516e-24,  1.109246791628206e-26, -3.118950108368850e-29,  3.976955471123318e-02, -2.526472368301827e-04,  1.188052422477570e-06, -4.875701925397147e-09,
  1.828390525234076e-11, -6.367812602945488e-14,  2.053853249045540e-16, -6.087959865011448e-19,  1.569553208766242e-21, -3.311596916511567e-24,  1.850428424342828e-27,
  1.623422290768151e-29,  6.576876958586464e-02, -4.152818112405326e-04,  1.923689968210796e-06, -7.672110721751227e-09,  2.739149951329449e-11, -8.790952171827383e-14,
  2.460854101271335e-16, -5.536818725304566e-19,  5.974701612255599e-22,  2.556148850640381e-24, -2.613051783789198e-26,  1.198278417176965e-28,  9.829614243312784e-02,
 -6.158541333607482e-04,  2.797581618227795e-06, -1.073733940272131e-08,  3.574367552746551e-11, -1.006420814258264e-13,  2.102577253054433e-16, -1.172836373164667e-19,
 -1.919051086664133e-21,  1.332236138286381e-23, -6.400996468605648e-26,  2.089545521206965e-28,  1.373675723816341e-01, -8.524008299921565e-04,  3.777912976372581e-06,
 -1.378651716737608e-08,  4.150452544925717e-11, -9.280607110350776e-14,  6.504398075584405e-17,  7.587492160570237e-19, -5.676491119629936e-21,  2.497752096781450e-23,
 -8.479202769790890e-26,  1.473583842146521e-28,  1.829987891660622e-01, -1.122407238538568e-03,  4.825149485526779e-06, -1.648210545376439e-08,  4.268863439480675e-11,
 -5.635416607823033e-14, -2.043020275473206e-16,  1.979896906987894e-18, -9.448493792778369e-21,  2.936397270855578e-23, -4.965356578606369e-26, -1.938278155626169e-28,
  2.352030433338110e-01, -1.422708731820452e-03,  5.891342190238041e-06, -1.843963653410849e-08,  3.732290275983411e-11,  1.396808671860891e-14, -5.820833577903318e-16,
  3.245514321474143e-18, -1.105464800435548e-20,  1.604505172407401e-23,  7.151995698519092e-26, -7.963323670872651e-28,  2.939879378212311e-01, -1.749364792539557e-03,
  6.919392571681555e-06, -1.923794171674387e-08,  2.367402539501859e-11,  1.184419868267153e-13, -1.010130851501473e-15,  4.029875822088927e-18, -7.737362487141285e-21,
 -2.286689387333985e-23,  2.660017337079890e-25, -1.338248717435559e-27,  3.593510937306078e-01, -2.097500262744935e-03,  7.842361603803116e-06, -1.843635567597569e-08,
  5.607540912696853e-13,  2.498525951249750e-13, -1.379036037351698e-15,  3.630443534230346e-18,  2.863467340040757e-21, -8.483658166664571e-23,  4.410480044703963e-25,
 -1.147142741169702e-27,  4.312742187158703e-01, -2.461107259250443e-03,  8.582974337316602e-06, -1.560245037709197e-08, -3.222975885114777e-11,  3.908534155153221e-13,
 -1.527755996965096e-15,  1.326364857655479e-18,  2.102255196064461e-20, -1.476744857306900e-22,  4.105144654614769e-25,  5.352335692177761e-28,  5.097149704241642e-01,
 -2.832800728836963e-03,  9.053580728260189e-06, -1.035524026057696e-08, -7.340874048212029e-11,  5.117561385527686e-13, -1.259672238030088e-15, -3.307326784711185e-18,
  4.267227188973851e-20, -1.639748104710493e-22, -4.860431526633179e-26,  3.785024323742964e-27,  5.945957576453936e-01, -3.203521211079087e-03,  9.157011239693133e-06,
 -2.430439078913693e-09, -1.195441921943870e-10,  5.698137744518850e-13, -3.865576121225832e-16, -9.906478699150160e-18,  5.732072631605537e-20, -6.914193471075147e-23,
 -1.016705364838055e-24,  6.811298698685717e-27,  6.857882673564666e-01, -3.562181482244037e-03,  8.789048950389644e-06,  8.224121898492803e-09, -1.643705909809091e-10,
  5.119066069269028e-13,  1.186100793326107e-15, -1.670263284617295e-17,  4.798449527312973e-20,  1.827240580657291e-22, -2.121526715809831e-24,  5.234807243175232e-27,
  7.830920060248722e-01, -3.895262108526605e-03,  7.843678265602807e-06,  2.131444107069546e-08, -1.982168166515239e-10,  2.837022257138541e-13,  3.323265830673725e-15,
 -2.003623755191891e-17, -3.517145947209831e-21,  5.444976574533611e-22, -2.257956712178024e-24, -5.967804869549226e-27,  8.862044498311243e-01, -4.186379751743540e-03,
  6.222917849505875e-06,  3.602258197038179e-08, -2.079221927368338e-10, -1.504607865944759e-13,  5.486417717326536e-15, -1.461183427646868e-17, -1.016641201986087e-19,
  7.817366371989811e-22,  1.564786248448853e-25, -2.504458070933031e-26,  9.946794667637864e-01, -4.415890974007687e-03,  3.853922094541477e-06,  5.079299031811916e-08,
 -1.779540750016430e-10, -7.727332425809022e-13,  6.592726984768462e-15,  4.399272725456795e-18, -2.116125028320460e-19,  4.561921625971498e-22,  5.546785018149045e-24,
 -3.214185526190166e-26,  1.107869503505309e+00, -4.560670324568202e-03,  7.170088392722028e-07,  6.312437377410617e-08, -9.392502692142850e-11, -1.462255838158972e-12,
  5.098180004559672e-15,  3.613268174074086e-17, -2.361409058926448e-19, -7.926432836469026e-22,  9.958598273808724e-24,  8.402257623614848e-27,  1.224845770301794e+00,
 -4.594342661489023e-03, -3.111254980062086e-06,  6.948245117761558e-08,  4.987613982755438e-11, -1.947344684339244e-12, -3.369755948868466e-16,  6.604446737306913e-17,
 -4.127691391503509e-20, -2.459000367169001e-21,  3.728264826741266e-24,  9.499005821588903e-26,  1.344289857600672e+00, -4.488495275382473e-03, -7.397572791002967e-06,
  6.558599530285548e-08,  2.378148827711334e-10, -1.813062801170993e-12, -9.211951777489975e-15,  6.185631524214166e-17,  3.926403328254914e-19, -2.365450224816568e-21,
 -1.793522568447537e-23,  9.551202294022899e-26,  1.464351377832574e+00, -4.215779316650361e-03, -1.168002423700956e-05,  4.751327408383509e-08,  4.175613027770906e-10,
 -6.738947552302714e-13, -1.691546377180764e-14, -8.197273238081555e-18,  7.072905583492482e-19,  1.832955593131139e-21, -2.923577755190498e-23, -1.499421115874382e-25,
  1.582472814758651e+00, -3.756287032558097e-03, -1.521369168790853e-05,  1.417891701605918e-08,  4.948128540289787e-10,  1.375084821089255e-12, -1.462094050067457e-14,
 -1.172418043815575e-16,  2.176438769306726e-19,  6.576618635936620e-21,  1.529387073748920e-23, -2.820600714239019e-25,  1.695201600045238e+00, -3.108822250976239e-03,
 -1.700959411384309e-05, -2.880162158962599e-08,  3.676863748995850e-10,  3.194320790177756e-12,  2.818906536881929e-15, -1.332430094589326e-16, -9.501672168221518e-19,
  1.123975140147925e-21,  5.856801266970102e-23,  3.045006198664877e-25,  1.798050674795222e+00, -2.307602274276238e-03, -1.610337465612089e-05, -6.608307137789147e-08,
  2.982456325200560e-11,  2.871909349178033e-12,  2.164559461963093e-14,  3.583717064303523e-17, -8.378278915655241e-19, -9.107495078546269e-21, -3.065900094187503e-23,
  2.688893567798484e-25,  1.885538091436491e+00, -1.440447442396161e-03, -1.217715420879334e-05, -7.670463329488710e-08, -3.149156661740804e-10,  3.633855472419702e-14,
  1.487034306685124e-14,  1.527248826893936e-16,  8.272723117545510e-19,  3.802766317953232e-22, -4.397799768883473e-23, -5.109745881568584e-25,  1.951607141564233e+00,
 -6.551956547230047e-04, -6.361252966167353e-06, -5.154495058907449e-08, -3.573154794009792e-10, -2.049470977241542e-12, -8.323590905258198e-15, -1.915879628238323e-18,
  4.044785343541897e-19,  5.211602986789167e-21,  4.413819578474072e-23,  2.717757084898907e-25,  1.990606092880369e+00, -1.328182656518194e-04, -1.396642207969292e-06,
 -1.291089809739072e-08, -1.103396705706275e-10, -8.897017239236985e-13, -6.826162248126576e-15, -4.993534634717042e-17, -3.472347950526515e-19, -2.274548547354878e-21,
 -1.376561503220637e-23, -7.366861179944124e-26,  7.906953353321982e-04, -5.003858419835468e-06,  2.374024017051947e-08, -1.001098160483163e-10,  3.954127088160170e-13,
 -1.499866783632360e-15,  5.517723937811936e-18, -1.994666396135422e-20,  7.032310964221606e-23, -2.494158525446271e-25,  8.355066213595265e-28, -3.100709152893287e-30,
  7.117296562364280e-03, -4.497982517241413e-05,  2.126899193847177e-07, -8.914427210058760e-10,  3.487181978260620e-12, -1.304309003027669e-14,  4.705882658090338e-17,
 -1.658272217805633e-19,  5.651207608011757e-22, -1.925397888735506e-24,  6.073929143112751e-27, -2.158842620713194e-29,  1.977599891334954e-02, -1.246365533230930e-04,
  5.853781217248190e-07, -2.423148244223937e-09,  9.291195467556688e-12, -3.373354182697116e-14,  1.166379665752006e-16, -3.876687841154312e-19,  1.215911290160999e-21,
 -3.723771646233341e-24,  9.748606436012218e-27, -3.003047346340311e-29,  3.877761094489168e-02, -2.433719729996440e-04,  1.131258078668197e-06, -4.593085814095144e-09,
  1.705828332675161e-11, -5.894786779382209e-14,  1.890243837979231e-16, -5.604622638752045e-19,  1.451812446629393e-21, -3.226328388856314e-24,  2.339124566603152e-27,
  6.072388026670487e-30,  6.413784864473866e-02, -4.002532338852679e-04,  1.834197228376929e-06, -7.247596588800968e-09,  2.569112532773987e-11, -8.218727047074433e-14,
  2.308624372378379e-16, -5.332824032820805e-19,  6.718718797558476e-22,  1.608024726369387e-24, -2.147873296137736e-26,  9.191994116541120e-29,  9.587668469390309e-02,
 -5.939793016272045e-04,  2.672099399261388e-06, -1.018127038711689e-08,  3.378099570809633e-11, -9.564181668758259e-14,  2.061827272428885e-16, -1.714963763352426e-19,
 -1.483410509689631e-21,  1.093561443652048e-23, -5.558233194480220e-26,  1.739252178917340e-28,  1.340173836464732e-01, -8.228281302540653e-04,  3.616398246416407e-06,
 -1.313720204979775e-08,  3.966563278502712e-11, -9.100979425871599e-14,  8.387647533172491e-17,  5.908465751227300e-19, -4.836798931573871e-21,  2.171414751489580e-23,
 -7.843222544033293e-26,  1.397262961937130e-28,  1.785851262410946e-01, -1.084585659705634e-03,  4.631424322310522e-06, -1.580835213355519e-08,  4.151683651309219e-11,
 -6.062537246291401e-14, -1.529417447753775e-16,  1.694060023415199e-18, -8.429004814415153e-21,  2.722793987386444e-23, -5.668647723487264e-26, -1.304405663651646e-28,
  2.296050828231547e-01, -1.376452928572053e-03,  5.673656393417170e-06, -1.784096404763368e-08,  3.746972105698228e-11,  1.049157152337372e-15, -4.960710504547348e-16,
  2.901493830591039e-18, -1.043356852221348e-20,  1.824937524581983e-23,  3.973314198743420e-26, -6.540237916306176e-28,  2.870997361662824e-01, -1.694926462171217e-03,
  6.690883986030690e-06, -1.884148595114848e-08,  2.580942592025132e-11,  9.552421632998427e-14, -9.008704373037015e-16,  3.771049599841980e-18, -8.382882945452850e-21,
 -1.336529304351202e-23,  2.100403372496004e-25, -1.206421147582546e-27,  3.510851700037846e-01, -2.035645794196868e-03,  7.621338340555773e-06, -1.838917074514477e-08,
  5.235113163380102e-12,  2.179832108001510e-13, -1.276536227153428e-15,  3.676512771083607e-18,  1.144406844281923e-22, -6.823613109494289e-23,  3.883017241378835e-25,
 -1.240003967355797e-27,  4.215659198728584e-01, -2.393200567442346e-03,  8.392902423613367e-06, -1.605756823320054e-08, -2.477597134455893e-11,  3.547041497319510e-13,
 -1.481976083014172e-15,  1.917230612487875e-18,  1.600590907609859e-20, -1.309575524974860e-22,  4.212473074244990e-25, -2.602294900004061e-29,  4.985278106251911e-01,
 -2.760888334668699e-03,  8.922602964742933e-06, -1.144957051830779e-08, -6.348266577580045e-11,  4.805615858325875e-13, -1.334048519557896e-15, -2.036331181365141e-18,
  3.677156670865834e-20, -1.628895851398566e-22,  9.553177683581203e-26,  2.778491214397226e-27,  5.819279554998010e-01, -3.130413435868771e-03,  9.116743923787227e-06,
 -4.252570633953729e-09, -1.082620979518530e-10,  5.574125204129935e-13, -6.386861469594046e-16, -8.119315525935265e-18,  5.417003577146596e-20, -1.040153614128882e-22,
 -7.323470411382046e-25,  6.074132628603400e-27,  6.716807291632259e-01, -3.491518254220352e-03,  8.872301278092032e-06,  5.677488360138466e-09, -1.538847557918016e-10,
  5.349399574188602e-13,  7.407989824578770e-16, -1.507778513845743e-17,  5.309392722690162e-20,  1.028277413759455e-22, -1.865734205762272e-24,  6.273547637632726e-27,
  7.676380008281295e-01, -3.831543045769562e-03,  8.080623503756719e-06,  1.819250715098129e-08, -1.917906217006396e-10,  3.567331894406831e-13,  2.763495430077985e-15,
 -1.985302686275825e-17,  1.440692158235618e-20,  4.501441706453185e-22, -2.430855569206773e-24, -2.008195737705911e-27,  8.695611551400051e-01, -4.134924062785122e-03,
  6.635151777879410e-06,  3.267876206394757e-08, -2.096495974195490e-10, -2.403796024799134e-14,  5.035968092702275e-15, -1.741567681949638e-17, -7.366280550653342e-20,
  7.672547756165063e-22, -8.468913552131996e-25, -2.043071096429682e-26,  9.770813560761556e-01, -4.382671055772698e-03,  4.445872312644513e-06,  4.783071303849794e-08,
 -1.918203926956345e-10, -6.137781942529348e-13,  6.623862044530920e-15, -2.069577791368397e-18, -1.915474047158360e-19,  6.486548739695520e-22,  4.054638932955226e-24,
 -3.512830681517757e-26,  1.089643052859715e+00, -4.551932009312993e-03,  1.464541870055673e-06,  6.139458874615217e-08, -1.218691463987028e-10, -1.328636428547752e-12,
  6.000364864772504e-15,  2.819688335886121e-17, -2.574668875542548e-19, -3.923829750768690e-22,  9.922372797432345e-24, -9.699891900772805e-27,  1.206423915492598e+00,
 -4.615886937074724e-03, -2.273962418162197e-06,  6.996907987134971e-08,  1.099704675182290e-11, -1.933470983905221e-12,  1.480720729082559e-15,  6.334394221694723e-17,
 -1.261461101428848e-19, -2.230444198157644e-21,  7.581091972355734e-24,  7.876655387260073e-26,  1.326222587463040e+00, -4.544465875163284e-03, -6.588944483152700e-06,
  6.908954435503421e-08,  1.994900348735543e-10, -2.012029552807564e-12, -7.317810070538221e-15,  7.292874852260996e-17,  2.956863010124704e-19, -2.987696357962208e-21,
 -1.292428906213376e-23,  1.301414127391906e-25,  1.447305149999297e+00, -4.306826464541984e-03, -1.107029538531484e-05,  5.406434267733284e-08,  4.000185511668025e-10,
 -1.080010005737646e-12, -1.681988020381803e-14,  1.525422264501083e-17,  7.507943452690090e-19,  5.491504724534306e-22, -3.448001585652304e-23, -8.491886543387138e-26,
  1.567205517760200e+00, -3.877179428161937e-03, -1.499519986202029e-05,  2.229577140066694e-08,  5.185446293258819e-10,  9.857983579803982e-13, -1.776992065636591e-14,
 -1.063968781595425e-16,  4.621808120426503e-19,  6.913938382413113e-21,  9.700829358344578e-25, -3.644081216513426e-25,  1.682492116227366e+00, -3.246176598326426e-03,
 -1.731779913549177e-05, -2.240520205571258e-08,  4.319295959467114e-10,  3.213823267685809e-12, -1.328121220213224e-15, -1.625240299596176e-16, -8.645297821120922e-19,
  3.709097729045079e-21,  6.992703957077598e-23,  1.998939885259800e-25,  1.788557606830921e+00, -2.439588596527743e-03, -1.689152067106084e-05, -6.511786430835576e-08,
  9.252199996734477e-11,  3.400104550910496e-12,  2.222286347268831e-14,  3.570930286127135e-18, -1.184351777735119e-18, -1.003407089738455e-20, -1.402544877981776e-23,
  4.943270281147749e-25,  1.879575516960400e+00, -1.541631966872566e-03, -1.312775081417621e-05, -8.171657106376380e-08, -3.102581668190274e-10,  4.475331405850907e-13,
  1.951662797171129e-14,  1.790305850451469e-16,  8.034898538587124e-19, -1.871264998326147e-21, -6.964663772051215e-23, -6.542767656458361e-25,  1.948880520076550e+00,
 -7.086602115799466e-04, -7.015482450347519e-06, -5.760075715937422e-08, -4.002985651588214e-10, -2.248232165429974e-12, -8.165255327553331e-15,  1.439421928237326e-17,
  6.268728660359601e-19,  7.228723942553312e-21,  5.699476922188001e-23,  3.094553578677342e-25,  1.990051448084943e+00, -1.446425514478883e-04, -1.562782985850205e-06,
 -1.482808539965995e-08, -1.298920619011900e-10, -1.071643117081231e-12, -8.393018655967342e-15, -6.246987189128450e-17, -4.398507630322742e-19, -2.894376394231168e-21,
 -1.733431295139730e-23, -8.853124193129614e-26,  7.710522860400695e-04, -4.818636451360728e-06,  2.257591488470786e-08, -9.401618170196562e-11,  3.666956676652420e-13,
 -1.373897272295121e-15,  4.989416735549911e-18, -1.783379796677734e-20,  6.191384279245648e-23, -2.186140368943393e-25,  7.070883233579736e-28, -2.757108002153544e-30,
  6.940713864170339e-03, -4.332016598895219e-05,  2.023189623128710e-07, -8.376748817634642e-10,  3.237248495050250e-12, -1.196741507744008e-14,  4.265874195939322e-17,
 -1.488073148892434e-19,  4.999566022119700e-22, -1.700806958689455e-24,  5.169700511996672e-27, -1.965768762581312e-29,  1.928663809217804e-02, -1.200673625646837e-04,
  5.571705162031537e-07, -2.279738000591847e-09,  8.643660717104086e-12, -3.106021184606454e-14,  1.063083374663274e-16, -3.508318315537198e-19,  1.088557337863302e-21,
 -3.360132176693057e-24,  8.434040832975252e-27, -2.994957015881884e-29,  3.782188054186462e-02, -2.345378246617655e-04,  1.077740522590311e-06, -4.329343694437295e-09,
  1.592344737301108e-11, -5.459445481481508e-14,  1.739645224007775e-16, -5.158442268391748e-19,  1.337386252384381e-21, -3.130386174999390e-24,  2.383308983486920e-27,
 -4.208725803641345e-30,  6.256564175063296e-02, -3.859206757022356e-04,  1.749639135142064e-06, -6.849392534725165e-09,  2.410159018071045e-11, -7.682327762771447e-14,
  2.162390924641205e-16, -5.110146626217500e-19,  7.151982573513496e-22,  8.217972409588449e-25, -1.803019038127860e-26,  6.475047440220618e-29,  9.354276008365925e-02,
 -5.730821626181255e-04,  2.553104872837379e-06, -9.655810008820478e-09,  3.191722804204198e-11, -9.075606924859806e-14,  2.007724686598441e-16, -2.130813632776544e-19,
 -1.128000610477774e-21,  8.854652348908737e-24, -4.873695369159910e-26,  1.366380942195489e-28,  1.307829501201909e-01, -7.945168785266133e-04,  3.462500025027600e-06,
 -1.251699879815825e-08,  3.786681989105328e-11, -8.881502332223522e-14,  9.836656186651671e-17,  4.479826065454368e-19, -4.110122893805967e-21,  1.869483067174851e-23,
 -7.268077311532925e-26,  1.194744819562537e-28,  1.743197007761017e-01, -1.048281866818437e-03,  4.445669097012200e-06, -1.515396665443750e-08,  4.027131143753277e-11,
 -6.375635964992042e-14, -1.091400817965539e-16,  1.439567102818969e-18, -7.490879230398699e-21,  2.485816365239821e-23, -6.154506464629765e-26, -9.516553228734308e-29,
  2.241887080832388e-01, -1.331909854408463e-03,  5.463160588963480e-06, -1.724190057090123e-08,  3.737803536497189e-11, -9.918757255989056e-15, -4.194028250112479e-16,
  2.578383825942714e-18, -9.754602662242490e-21,  1.929730950889821e-23,  1.344065694316845e-26, -5.474414412366666e-28,  2.804256626012924e-01, -1.642296623704140e-03,
  6.467323196979703e-06, -1.841439064697110e-08,  2.751209573945159e-11,  7.513969685508099e-14, -7.990979429594757e-16,  3.496618814596914e-18, -8.725264891820285e-21,
 -5.989099603499355e-24,  1.596281063785336e-25, -1.088801074732902e-27,  3.430631330971798e-01, -1.975556023024044e-03,  7.401309434897841e-06, -1.827216124423368e-08,
  9.296739904311852e-12,  1.885798981635306e-13, -1.173891145014838e-15,  3.643760838301978e-18, -2.075779638518450e-21, -5.381098286461227e-23,  3.326290077384229e-25,
 -1.285389362728845e-27,  4.121261748478349e-01, -2.326834323703178e-03,  8.198061008695937e-06, -1.639914436890068e-08, -1.803293327502945e-11,  3.198345504755932e-13,
 -1.421808590093355e-15,  2.357229497496837e-18,  1.159318346917223e-20, -1.142692029725050e-22,  4.099229522372310e-25, -4.724494091049357e-28,  4.876261253379515e-01,
 -2.690073638555943e-03,  8.779425270873309e-06, -1.239015997900593e-08, -5.419555979456915e-11,  4.479877936894957e-13, -1.375467128877065e-15, -9.525056247575787e-19,
  3.100323731064515e-20, -1.569021525872638e-22,  1.970882199285790e-25,  1.851451575175751e-27,  5.695518060008803e-01, -3.057712213673062e-03,  9.055684906412899e-06,
 -5.896484862645259e-09, -9.728454987452097e-11,  5.395481922773733e-13, -8.423590933622283e-16, -6.450933711401331e-18,  4.996022687081518e-20, -1.282273058010342e-22,
 -4.850544768798936e-25,  5.141028232431083e-27,  6.578569864432364e-01, -3.420308362521591e-03,  8.926014007561664e-06,  3.301748614949900e-09, -1.430413564020580e-10,
  5.478479038994193e-13,  3.428640696751060e-16, -1.333340414373492e-17,  5.552040283083605e-20,  3.387272031308814e-23, -1.579348750686962e-24,  6.641449500921954e-27,
  7.524424283473027e-01, -3.766076419732463e-03,  8.280768293039420e-06,  1.518435023371125e-08, -1.840374153504115e-10,  4.164528576766328e-13,  2.216366663681423e-15,
 -1.915160064523013e-17,  2.884976867726833e-20,  3.521377179416254e-22, -2.446368952193602e-24,  1.161501213441708e-27,  8.531300244023284e-01, -4.080331287387964e-03,
  7.007175504325246e-06,  2.932691906875862e-08, -2.089624923319926e-10,  9.073248816868502e-14,  4.519424225442858e-15, -1.933915560072437e-17, -4.685454027877295e-20,
  7.168868485971654e-22, -1.634294298636951e-24, -1.533106035290456e-26,  9.596253661257274e-01, -4.344861255165438e-03,  5.001048913785165e-06,  4.467198788342378e-08,
 -2.025144077351498e-10, -4.561708979236269e-13,  6.483816731108656e-15, -7.797205104960222e-18, -1.656508859028420e-19,  7.797611028016203e-22,  2.501795524197049e-24,
 -3.498454048782026e-26,  1.071463374086369e+00, -4.537303849928663e-03,  2.188726635278617e-06,  5.924017659508567e-08, -1.469426939073298e-10, -1.176094858853269e-12,
  6.672948726229086e-15,  1.980740804934352e-17, -2.645949939949604e-19, -8.761594022756804e-24,  9.147628316719244e-24, -2.493208459055697e-26,  1.187929302363278e+00,
 -4.630720052763388e-03, -1.434545953585456e-06,  6.983820202121220e-08, -2.717600000806535e-11, -1.877178206213949e-12,  3.186221183235966e-15,  5.808746053026476e-17,
 -2.002060723169931e-19, -1.864295394412099e-21,  1.055747420011977e-23,  5.563143575844108e-26,  1.307944624154288e+00, -4.593809988370879e-03, -5.742075816993653e-06,
  7.195062997255672e-08,  1.576636637829151e-10, -2.162186397589363e-12, -5.160151340325082e-15,  8.058166405226606e-17,  1.802696635245270e-19, -3.383135544788389e-21,
 -6.703749467283423e-24,  1.498599143746315e-25,  1.429904979569405e+00, -4.392686717323431e-03, -1.038390483135979e-05,  6.027009897441066e-08,  3.744302495713661e-10,
 -1.475838245142403e-12, -1.605536750823547e-14,  3.932382733812608e-17,  7.450471177425465e-19, -8.815857816135990e-22, -3.645999609743970e-23, -3.161954698087714e-27,
  1.551458772229449e+00, -3.995928442921350e-03, -1.467729744281867e-05,  3.072606134165557e-08,  5.337641190020515e-10,  5.254716135020278e-13, -2.050469151022850e-14,
 -8.764958905996225e-17,  7.077604059243540e-19,  6.615495712272387e-21, -1.622186529147285e-23, -4.094087929105256e-25,  1.669228794530199e+00, -3.385672090403296e-03,
 -1.754308516470757e-05, -1.498345036680608e-08,  4.955031464567100e-10,  3.124357201194911e-12, -6.242094550379216e-15, -1.874982182940531e-16, -6.789544274377005e-19,
  6.634999096980498e-21,  7.507203744389598e-23,  2.208835285824490e-26,  1.778524081735621e+00, -2.577815897127129e-03, -1.766171509436587e-05, -6.306456432433301e-08,
  1.658421170845103e-10,  3.930033980696400e-12,  2.173745155979887e-14, -4.016928567493323e-17, -1.549764018220897e-18, -1.008615309181647e-20,  1.327859675133174e-23,
  7.486266035117352e-25,  1.873192616597049e+00, -1.650659904752543e-03, -1.413775186021218e-05, -8.658189110171504e-08, -2.962027950745050e-10,  9.789090020681112e-13,
  2.487514972215129e-14,  2.030681445922598e-16,  6.786966371419933e-19, -5.270058894933806e-21, -1.011261815469176e-22, -7.677606867403047e-25,  1.945929095547275e+00,
 -7.676612743678796e-04, -7.746638042144989e-06, -6.437571778736822e-08, -4.471774288424930e-10, -2.436838209639401e-12, -7.438963241439617e-15,  3.908487995107878e-17,
  9.314746802690682e-19,  9.785733499991434e-21,  7.089657085610458e-23,  3.144580157734527e-25,  1.989446694297449e+00, -1.578935971511318e-04, -1.753934081795757e-06,
 -1.708939039475394e-08, -1.534895769251968e-10, -1.295757198401637e-12, -1.035589202330404e-14, -7.835394789389255e-17, -5.575056812826630e-19, -3.669773314857560e-21,
 -2.153134754047703e-23, -1.015997229995947e-25,  7.521319477530572e-04, -4.642444214663525e-06,  2.148203733708070e-08, -8.836253422461500e-11,  3.403758620613788e-13,
 -1.259926628909126e-15,  4.516662221064045e-18, -1.597325074591795e-20,  5.452427769377456e-23, -1.926848970962474e-25,  5.908816297155414e-28, -2.550050324149590e-30,
  6.770607859888078e-03, -4.174095998915287e-05,  1.925699174897769e-07, -7.877394500868604e-10,  3.007809904754308e-12, -1.099185187536472e-14,  3.870718778854101e-17,
 -1.337501273473843e-19,  4.422446655726859e-22, -1.510962117790227e-24,  4.329314216188707e-27, -1.873456440149347e-29,  1.881511336812620e-02, -1.157171211105486e-04,
  5.306233919730529e-07, -2.146273707452416e-09,  8.047194671508875e-12, -2.862286452664248e-14,  9.695498403152749e-17, -3.178709174887120e-19,  9.733446148026713e-22,
 -3.049474203682117e-24,  7.086186427291394e-27, -3.171110348223129e-29,  3.690065006848196e-02, -2.261194593344665e-04,  1.027281738479245e-06, -4.083081624661499e-09,
  1.487216438094224e-11, -5.058789743268029e-14,  1.601032195496499e-16, -4.748331305980203e-19,  1.226333317798219e-21, -3.042132843017241e-24,  1.940648147154634e-27,
 -1.643570994917947e-29,  6.104944182348891e-02, -3.722458927936037e-04,  1.669710374233562e-06, -6.475781658507048e-09,  2.261587649301343e-11, -7.180263168966269e-14,
  2.022545757610653e-16, -4.877890792893579e-19,  7.324121447673716e-22,  1.492074050618013e-25, -1.581312190425059e-26,  3.531408506098577e-29,  9.129055934606189e-02,
 -5.531122572884598e-04,  2.440240149969417e-06, -9.159395622203999e-09,  3.014978890273801e-11, -8.601292282157203e-14,  1.943461497298517e-16, -2.444423058797944e-19,
 -8.429839081952527e-22,  7.013330236592031e-24, -4.364229253551131e-26,  9.353655852382378e-29,  1.276593456785240e-01, -7.674075286390531e-04,  3.315873062770439e-06,
 -1.192520780846102e-08,  3.611506918065281e-11, -8.631796383664773e-14,  1.091659728455062e-16,  3.266755526046203e-19, -3.488254404359316e-21,  1.588346562377113e-23,
 -6.814925698113536e-26,  8.340491524701463e-29,  1.701965676482461e-01, -1.013433048413246e-03,  4.267645039147538e-06, -1.451995577987421e-08,  3.897311901991747e-11,
 -6.591830438830064e-14, -7.205701795136563e-17,  1.213694215494123e-18, -6.641269508895487e-21,  2.231625216289144e-23, -6.552153461141553e-26, -9.134148994750722e-29,
  2.189471831795431e-01, -1.289022032608915e-03,  5.259837821129649e-06, -1.664596198763985e-08,  3.708467175611208e-11, -1.915271625891065e-14, -3.514732290280632e-16,
  2.277409829460171e-18, -9.055819455129261e-21,  1.937535757511310e-23, -9.074866743168081e-27, -4.840500761595581e-28,  2.739585644908338e-01, -1.591434337983984e-03,
  6.249037976800123e-06, -1.796318406931736e-08,  2.883087275164483e-11,  5.710450213736561e-14, -7.051256960437484e-16,  3.215100973747605e-18, -8.837225255018066e-21,
 -5.340632243578080e-25,  1.137430645349192e-25, -1.004175156618218e-27,  3.352779452073311e-01, -1.917219805703498e-03,  7.183055585622616e-06, -1.809473684459426e-08,
  1.279482197995149e-11,  1.616216073960865e-13, -1.073069351388582e-15,  3.548797487297739e-18, -3.787195343545242e-21, -4.164606264814322e-23,  2.753885529791128e-25,
 -1.317434031205802e-27,  4.029487538954571e-01, -2.262041425303905e-03,  7.999745262786384e-06, -1.663832866417227e-08, -1.197192919856994e-11,  2.865414053334987e-13,
 -1.351208549931671e-15,  2.665509421768634e-18,  7.768593202839912e-21, -9.840067428957770e-23,  3.808228924122402e-25, -8.413446433763471e-28,  4.770053400078515e-01,
 -2.620447036008782e-03,  8.625830419289683e-06, -1.318741161504859e-08, -4.556751886365394e-11,  4.147634872781335e-13, -1.389085295554523e-15, -4.911217970338989e-20,
  2.551396342360994e-20, -1.476445422401027e-22,  2.596001450410374e-25,  1.000706847897974e-27,  5.574653636864826e-01, -2.985575414407835e-03,  8.975940154856074e-06,
 -7.367866604661989e-09, -8.670946782561895e-11,  5.173403278815559e-13, -1.001321245070828e-15, -4.929385597925649e-18,  4.504656422095950e-20, -1.434095931693856e-22,
 -2.817809124409918e-25,  4.081327066437852e-27,  6.443187663230803e-01, -3.348779838758446e-03,  8.952265710490367e-06,  1.101066360077824e-09, -1.320313103032908e-10,
  5.517980845341729e-13, -5.498405267539204e-18, -1.154886212082254e-17,  5.567298294694974e-20, -2.347901399891725e-23, -1.289757211242981e-24,  6.434053134869920e-27,
  7.375116991584423e-01, -3.699150831865560e-03,  8.445596631449889e-06,  1.230909388448156e-08, -1.752192796256670e-10,  4.633260821663460e-13,  1.694818466637625e-15,
 -1.804431739399636e-17,  3.978447694252454e-20,  2.560409786555050e-22, -2.341923517964581e-24,  3.432254969494512e-27,  8.369229628940291e-01, -4.022922853759410e-03,
  7.339116597645768e-06,  2.600374286253076e-08, -2.061078181273817e-10,  1.925546517190768e-13,  3.960719675141120e-15, -2.043942029297025e-17, -2.237221053866952e-20,
  6.395205244415044e-22, -2.197557847750026e-24, -1.033254156740882e-26,  9.423292543477615e-01, -4.302764331215648e-03,  5.517397472067279e-06,  4.136714024540505e-08,
 -2.101023770787849e-10, -3.037515963582661e-13,  6.195623881205215e-15, -1.263255408975911e-17, -1.361438059426463e-19,  8.496670684769508e-22,  1.012761389508640e-24,
 -3.235399148818940e-26,  1.053353621855623e+00, -4.516992207047250e-03,  2.884754693566757e-06,  5.670979121393051e-08, -1.688230971647978e-10, -1.010243399742125e-12,
  7.109460130092983e-15,  1.140357245695911e-17, -2.586220800476746e-19,  3.315747364163084e-22,  7.787008897136227e-24, -3.620941960100331e-26,  1.169388762960156e+00,
 -4.638854402194387e-03, -6.003204264061767e-07,  6.910773154383203e-08, -6.382712232576958e-11, -1.781974446126257e-12,  4.713494747545067e-15,  5.069286315977137e-17,
 -2.591996901698642e-19, -1.400796492437360e-21,  1.242122422140661e-23,  2.873959157746786e-26,  1.289483035395062e+00, -4.636253406540537e-03, -4.864979263956702e-06,
  7.412134734035497e-08,  1.133671443518009e-10, -2.258416800252769e-12, -2.841707008306559e-15,  8.436289395682159e-17,  5.525932803846347e-20, -3.517451844403076e-21,
  4.108103053936456e-27,  1.520819921306874e-25,  1.412172811405123e+00, -4.472765523437007e-03, -9.625759072269193e-06,  6.600433500750041e-08,  3.411631453175886e-10,
 -1.845299535693505e-12, -1.462729116295862e-14,  6.237733491279456e-17,  6.872591852691417e-19, -2.317066767669055e-21, -3.467769953574575e-23,  8.399361022267607e-26,
  1.535242762674164e+00, -4.111726166624047e-03, -1.425708531489823e-05,  3.932283897339180e-08,  5.391677773552315e-10,  6.682720793104025e-15, -2.260709825519063e-14,
 -6.135138980389184e-17,  9.298728288451905e-19,  5.604485473335766e-21, -3.427014170101520e-23, -4.012447540124276e-25,  1.655404474520521e+00, -3.526596513373670e-03,
 -1.767328753485837e-05, -6.565468685862321e-09,  5.560552655036191e-10,  2.909333833470596e-12, -1.175618393374132e-14, -2.048254885277725e-16, -3.864134872376019e-19,
  9.590036079800146e-21,  7.091321525546177e-23, -2.200150089858453e-25,  1.767925509587038e+00, -2.722085452425270e-03, -1.839988467846357e-05, -5.975442685781174e-08,
  2.495383141493556e-10,  4.432301828345397e-12,  1.986495693413657e-14, -9.539997546196041e-17, -1.894693337697675e-18, -8.822776233138685e-21,  5.163760001632314e-23,
  9.874299887575914e-25,  1.866357081221786e+00, -1.767996709114971e-03, -1.520441348616565e-05, -9.113009835750826e-08, -2.701821879548186e-10,  1.646392785674085e-12,
  3.083063778871604e-14,  2.209029670968701e-16,  4.078570277029570e-19, -1.000732627179772e-20, -1.359396210481708e-22, -7.942214694964237e-25,  1.942729435010195e+00,
 -8.328498103279349e-04, -8.563714252113648e-06, -7.192971411830320e-08, -4.975920375980354e-10, -2.598526855305312e-12, -5.870269628659237e-15,  7.510240161867370e-17,
  1.338037288146607e-18,  1.288566570467628e-20,  8.362122644777121e-23,  2.477163709234170e-25,  1.988785696517956e+00, -1.727891708516732e-04, -1.974642837942042e-06,
 -1.976683268257900e-08, -1.820788007592814e-10, -1.572769707764248e-12, -1.282066246479869e-14, -9.848304683531775e-17, -7.062212328873493e-19, -4.622902789433781e-21,
 -2.616672394550995e-23, -1.071346485438484e-25,  7.338992961659315e-04, -4.474738612939328e-06,  2.045355012881610e-08, -8.311236756346326e-11,  3.162260934111775e-13,
 -1.156702839849529e-15,  4.092826525462764e-18, -1.433511655475134e-20,  4.798625246640408e-23, -1.712705088239290e-25,  4.800369443414739e-28, -2.524188362012773e-30,
  6.606666403789940e-03, -4.023741040443921e-05,  1.833986993052835e-07, -7.413239589007714e-10,  2.796967302637691e-12, -1.010626936012943e-14,  3.515236145875418e-17,
 -1.204368016701507e-19,  3.907684337365076e-22, -1.354303907464728e-24,  3.499824198136908e-27, -1.926640428110425e-29,  1.836057477493303e-02, -1.115730089758938e-04,
  5.056221485005316e-07, -2.021974785823004e-09,  7.497303412217305e-12, -2.639932947463211e-14,  8.847452687916782e-17, -2.884284757013802e-19,  8.683191405351478e-22,
 -2.795107142153399e-24,  5.595801288644928e-27, -3.674524130929593e-29,  3.601230403597091e-02, -2.180932236752373e-04,  9.796797628654476e-07, -3.853016725479420e-09,
  1.389777677356602e-11, -4.690063037180789e-14,  1.473409225265003e-16, -4.373294304540621e-19,  1.117998724051746e-21, -2.983540610202387e-24,  8.638426888265554e-28,
 -3.369960953821830e-29,  5.958669000163087e-02, -3.591930032502981e-04,  1.594125570487605e-06, -6.125156911805380e-09,  2.122727234446649e-11, -6.710976993655627e-14,
  1.889245540614546e-16, -4.643855745764391e-19,  7.266822032579484e-22, -4.623093442017834e-25, -1.503019784108463e-26, -1.553312885688564e-30,  8.911646945244904e-02,
 -5.340219154408968e-04,  2.333165828142539e-06, -8.690510019093419e-09,  2.847560432010825e-11, -8.143357464372585e-14,  1.871597047384413e-16, -2.677078684276821e-19,
 -6.210708861217757e-22,  5.334757408705855e-24, -4.069250863106466e-26,  3.756505542082482e-29,  1.246418769135669e-01, -7.414432610767883e-04,  3.176181114936779e-06,
 -1.136103233375348e-08,  3.441558762312645e-11, -8.360032133115802e-14,  1.168323979679994e-16,  2.236804618674879e-19, -2.964770657245678e-21,  1.321533906922805e-23,
 -6.569451363565360e-26,  2.307303926741748e-29,  1.662100290914566e-01, -9.799783460397741e-04,  4.097103209316143e-06, -1.390701563496698e-08,  3.764009087784394e-11,
 -6.726316235121546e-14, -4.093174676308660e-17,  1.013513676602522e-18, -5.886091425219076e-21,  1.960744132656202e-23, -7.019259892500693e-26, -1.292533959469301e-28,
  2.138740015596439e-01, -1.247732281169102e-03,  5.063632338190627e-06, -1.605610889520675e-08,  3.662226250883752e-11, -2.685496892083908e-14, -2.916586397908774e-16,
  1.998672572529854e-18, -8.369906163252478e-21,  1.859285134995135e-23, -3.001175942936075e-26, -4.792096198837283e-28,  2.676914577226874e-01, -1.542296344032880e-03,
  6.036282324520263e-06, -1.749364283594610e-08,  2.981085935838829e-11,  4.122981545877177e-14, -6.190590718004597e-16,  2.932794684365655e-18, -8.785078814813713e-21,
  3.144817676045261e-24,  7.038621135875821e-26, -9.794320427879174e-28,  3.277226248997397e-01, -1.860620191455009e-03,  6.967249275694462e-06, -1.786552599701088e-08,
  1.577768977027788e-11,  1.370453322933112e-13, -9.756105768998131e-16,  3.405630925200931e-18, -5.102268619892409e-21, -3.180423548327152e-23,  2.162540980937428e-25,
 -1.380052688955168e-27,  3.940273155682115e-01, -2.198844935118846e-03,  7.799119493898284e-06, -1.678576904230354e-08, -6.559214102189956e-12,  2.550329325391714e-13,
 -1.273605989499075e-15,  2.860287101195054e-18,  4.490518550909088e-21, -8.400931194944317e-23,  3.362333474190904e-25, -1.187540775307672e-27,  4.666605462256816e-01,
 -2.552085164100744e-03,  8.463474877085871e-06, -1.385193999601747e-08, -3.760528474436603e-11,  3.814963592547649e-13, -1.379814516680990e-15,  6.843672627401205e-19,
  2.039409964559008e-20, -1.366194663706555e-22,  2.857540975824776e-25,  1.894035104905237e-28,  5.456660848428252e-01, -2.914144358088449e-03,  8.879538740421065e-06,
 -8.673793419305584e-09, -7.661333688256363e-11,  4.918103929962755e-13, -1.119952886033692e-15, -3.572343438075855e-18,  3.972118266451791e-20, -1.514237778426710e-22,
 -1.273989865504717e-25,  2.917656503468083e-27,  6.310669173055312e-01, -3.277143936250316e-03,  8.953167372813868e-06, -9.232604178651697e-10, -1.210218251994538e-10,
  5.479858951890382e-13, -3.041199447500616e-16, -9.790263514459956e-18,  5.396581598605901e-20, -6.958158778438197e-23, -1.020555511626672e-24,  5.722506311437494e-27,
  7.228510945295807e-01, -3.631042164179392e-03,  8.576797198434170e-06,  9.581758536004252e-09, -1.655861487571187e-10,  4.980905738040598e-13,  1.208659673642843e-15,
 -1.664149001670032e-17,  4.735645847861079e-20,  1.658424797614848e-22, -2.158414425412863e-24,  4.747735045054494e-27,  8.209505949105736e-01, -3.963017477380117e-03,
  7.631518443014315e-06,  2.274179552281283e-08, -2.013528390713826e-10,  2.806840267617713e-13,  3.381728541970604e-15, -2.080473960790634e-17, -1.028866308285117e-21,
  5.438780700837906e-22, -2.552519925528181e-24, -5.939730707365227e-27,  9.252095380624300e-01, -4.256697086398769e-03,  5.993458671949502e-06,  3.796485229554625e-08,
 -2.147215334274745e-10, -1.597649822359380e-13,  5.785558286666914e-15, -1.649464553454459e-17, -1.051592098740730e-19,  8.628751597118932e-22, -3.211603646649871e-25,
 -2.808630491286752e-26,  1.035336052270515e+00, -4.491239494270299e-03,  3.548428696998962e-06,  5.385634535015844e-08, -1.873006101809550e-10, -8.367068348680654e-13,
  7.315101765633382e-15,  3.375505155574232e-18, -2.414847341697835e-19,  6.088329529077984e-22,  6.025298690619474e-24, -4.316290040560065e-26,  1.150828964384601e+00,
 -4.640359821811745e-03,  2.216900318403357e-07,  6.780799324329783e-08, -9.822543009297443e-11, -1.652798151737681e-12,  6.009887938501372e-15,  4.168949222326551e-17,
 -3.004544327096073e-19, -8.867873768978346e-22,  1.307937172680243e-23,  1.343521722923140e-27,  1.270865854304737e+00, -4.671588032988340e-03, -3.966140208636913e-06,
  7.557097460983167e-08,  6.770867092490050e-11, -2.298188700618792e-12, -4.737510255982357e-16,  8.411808883677999e-17, -6.978086976562784e-20, -3.386722872862668e-21,
  6.421273929775236e-24,  1.368736246338279e-25,  1.394132880652051e+00, -4.546513517210901e-03, -8.802233345751418e-06,  7.114926088231682e-08,  3.009005587504335e-10,
 -2.172997049730287e-12, -1.258723315611705e-14,  8.277599058817949e-17,  5.799909326920327e-19, -3.605898949872924e-21, -2.918502029018159e-23,  1.632680957712924e-25,
  1.518570939987713e+00, -4.223748883252693e-03, -1.373354366761514e-05,  4.792059170682182e-08,  5.337547146486053e-10, -5.529631552120148e-13, -2.388010477171163e-14,
 -2.866550926332585e-17,  1.102841705861407e-18,  3.896473764885553e-21, -5.062628110849514e-23, -3.320823285312432e-25,  1.641015036109005e+00, -3.668142396296399e-03,
 -1.769682673053168e-05,  2.779608107750915e-09,  6.109501157317945e-10,  2.557304802308235e-12, -1.760873969228739e-14, -2.111431370405607e-16,  6.821152068505188e-21,
  1.215232723837810e-20,  5.517013659461618e-23, -4.981354181991782e-25,  1.756738333196977e+00, -2.872077967548205e-03, -1.908997567997026e-05, -5.502777670545124e-08,
  3.426989786922821e-10,  4.869878131804618e-12,  1.630053741973062e-14, -1.606250505069618e-16, -2.164154281138505e-18, -5.833986620290942e-21,  9.893607626844907e-23,
  1.141740400594495e-24,  1.859034797773347e+00, -1.894076977033844e-03, -1.632268950871759e-05, -9.514726248237123e-08, -2.293479038417466e-10,  2.461654225937397e-12,
  3.713660925399132e-14,  2.270736795511503e-16, -5.848858248098282e-20, -1.611717504167520e-20, -1.685174927975804e-22, -6.503978235753641e-25,  1.939255353341910e+00,
 -9.049514912275274e-04, -9.476377305330598e-06, -8.031379810632438e-08, -5.507741974136771e-10, -2.708888385709444e-12, -3.093510877698898e-15,  1.260060293395783e-16,
  1.864349032057339e-18,  1.640159578179486e-20,  9.071307083260694e-23,  4.543477554239630e-26,  1.988061370057040e+00, -1.895871510327587e-04, -2.230419254276589e-06,
 -2.294944033642243e-08, -2.168483909037621e-10, -1.916270832033714e-12, -1.592108726544353e-14, -1.239560572052891e-16, -8.926063922205758e-19, -5.761810774740314e-21,
 -3.068215497220084e-23, -9.354120417641643e-26,  7.163214011319551e-04, -4.315015316233433e-06,  1.948581292172025e-08, -7.823261889769043e-11,  2.940426759922605e-13,
 -1.063123654181707e-15,  3.712039338296335e-18, -1.289472214839977e-20,  4.213896726771197e-23, -1.543395666400182e-25,  3.646934763514122e-28, -2.776454727054579e-30,
  6.448595854890998e-03, -3.880505865422753e-05,  1.747647959324794e-07, -6.981447681811464e-10,  2.603012446415408e-12, -9.301710557068102e-15,  3.194804864052708e-17,
 -1.086869646089060e-19,  3.443236273945807e-22, -1.231901796955841e-24,  2.599375604205736e-27, -2.216277191475079e-29,  1.792222185030984e-02, -1.076230867019125e-04,
  4.820611349879918e-07, -1.906129143686326e-09,  6.989912391359575e-12, -2.436980446831156e-14,  8.077269836517081e-17, -2.622123579963672e-19,  7.713111826778249e-22,
 -2.606285118249940e-24,  3.765793268179637e-27, -4.773593207492876e-29,  3.515531843250965e-02, -2.104370202409191e-04,  9.347474054784725e-07, -3.637968357311798e-09,
  1.299415459701887e-11, -4.350744732174099e-14,  1.355804437312374e-16, -4.032686329946452e-19,  1.010792328422481e-21, -2.985805112339869e-24, -1.178617234440257e-27,
 -6.152219236768080e-29,  5.817496650460646e-02, -3.467283328281252e-04,  1.522617999293862e-06, -5.796016133778698e-09,  1.992937911204420e-11, -6.272900605415621e-14,
  1.762439775700393e-16, -4.415150173706118e-19,  6.990750019909816e-22, -1.078998421136301e-24, -1.619242690584811e-26, -5.509999053166640e-29,  8.701706273859522e-02,
 -5.157661101385238e-04,  2.231560403275333e-06, -8.247688252480177e-09,  2.689123310067347e-11, -7.703377108491317e-14,  1.794122892848962e-16, -2.848214817605884e-19,
 -4.581129598900154e-22,  3.718454894651340e-24, -4.071896241074603e-26, -4.468543233434213e-29,  1.217260723779508e-01, -7.165699067423573e-04,  3.043097945997525e-06,
 -1.082360469173569e-08,  3.277207467313727e-11, -8.073148627055142e-14,  1.218351434576653e-16,  1.359131613966627e-19, -2.536305898106092e-21,  1.058167055425295e-23,
 -6.673023107464571e-26, -7.922037621577160e-29,  1.623546267440776e-01, -9.478589215514093e-04,  3.933787929297513e-06, -1.331558038801059e-08,  3.628719535753192e-11,
 -6.792563523614054e-14, -1.508815164919310e-17,  8.358982737715558e-19, -5.232344655391259e-21,  1.666167023845881e-23, -7.783696582552885e-26, -2.316663224613726e-28,
  2.089628842942339e-01, -1.207983997633348e-03,  4.874455863099195e-06, -1.547481132227765e-08,  3.601954422045147e-11, -3.321287871907257e-14, -2.393467960142686e-16,
  1.741271256233954e-18, -7.727393965677414e-21,  1.695379382085189e-23, -5.255028284515439e-26, -5.637339658012500e-28,  2.616175348704469e-01, -1.494837614178147e-03,
  5.829245124675317e-06, -1.701085221857098e-08,  3.049336940103053e-11,  2.732617184293937e-14, -5.408561333793241e-16,  2.653942006180028e-18, -8.631683498999003e-21,
  5.084499752571290e-24,  2.602374825011205e-26, -1.059457766758366e-27,  3.203902686654096e-01, -1.805735250762590e-03,  6.754464038648300e-06, -1.759239582702471e-08,
  1.829207421587144e-11,  1.147555194099013e-13, -8.826996469459296e-16,  3.225587763055667e-18, -6.106471777950898e-21, -2.440535400819581e-23,  1.525459263218881e-25,
 -1.538756696654563e-27,  3.853554440001132e-01, -2.137259103191605e-03,  7.597223597889343e-06, -1.685154449377193e-08, -1.757661367869107e-12,  2.254409786387463e-13,
 -1.191942974539535e-15,  2.958081281300248e-18,  1.694672009832192e-21, -7.171694697517010e-23,  2.754253188737429e-25, -1.595996182168392e-27,  4.565865547292819e-01,
 -2.485051918619104e-03,  8.293887469928983e-06, -1.439437662806556e-08, -3.030459877028322e-11,  3.486800378157742e-13, -1.352239310175855e-15,  1.260493435029594e-18,
  1.568133408936962e-20, -1.252671820573776e-22,  2.756441048680891e-25, -6.664451397588374e-28,  5.341508923759392e-01, -2.843544491171855e-03,  8.768418116382528e-06,
 -9.822409054524024e-09, -6.705329896432462e-11,  4.638697818219207e-13, -1.203008583563952e-15, -2.389240131888490e-18,  3.420577298172447e-20, -1.543242760943780e-22,
 -2.716357992848481e-26,  1.605983822975119e-27,  6.181014766926931e-01, -3.205595001790839e-03,  8.930830292385568e-06, -2.772418175055477e-09, -1.101563026962905e-10,
  5.375900439839230e-13, -5.545006210560147e-16, -8.110840894357657e-18,  5.078393299333159e-20, -1.056856686204955e-22, -7.934277992017064e-25,  4.515625034629172e-27,
  7.084648202667342e-01, -3.562012135051018e-03,  8.676215450423206e-06,  7.013495458631950e-09, -1.553710955879510e-10,  5.216830374633503e-13,  7.646948112159231e-16,
 -1.504680108619815e-17,  5.182471337264637e-20,  8.384921758345028e-23, -1.939038984331976e-24,  5.049180505339765e-27,  8.052222809504932e-01, -3.900928037316214e-03,
  7.885289111773735e-06,  1.956927141259949e-08, -1.949746738942778e-10,  3.548687744986923e-13,  2.801535243875051e-15, -2.054454022936486e-17,  1.665988470224496e-20,
  4.376250668717050e-22, -2.735729680185480e-24, -2.596431946499317e-27,  9.082814476718841e-01, -4.206985703003718e-03,  6.428342180869033e-06,  3.451112622754236e-08,
 -2.165675528658444e-10, -2.680548419855583e-14,  5.281235508983095e-15, -1.936753513885016e-17, -7.461171513674556e-20,  8.267506413913828e-22, -1.449043252188423e-24,
 -2.315741292988532e-26,  1.017431888712824e+00, -4.460319115607633e-03,  4.176202705685122e-06,  5.073521808611671e-08, -2.022758879789812e-10, -6.608616096906513e-13,
  7.305035501883046e-15, -3.958591452049072e-18, -2.156970873652173e-19,  8.107222592614588e-22,  4.047582095478119e-24, -4.614276179056979e-26,  1.132276184581022e+00,
 -4.635360694645928e-03,  1.024891885078016e-06,  6.598015254664323e-08, -1.297501951902620e-10, -1.495665508831260e-12,  7.038509126324487e-15,  3.166478769725458e-17,
 -3.230173470334437e-19, -3.700708093191971e-22,  1.257308625670972e-23, -2.380469181341717e-26,  1.252121808717839e+00, -4.699674824425752e-03, -3.054305112534639e-06,
  7.628678022264895e-08,  2.182020174126951e-11, -2.281657975180341e-12,  1.832384135626570e-15,  7.999524631953409e-17, -1.856984602935808e-19, -3.017337346195401e-21,
  1.182795518021724e-23,  1.067292478196239e-25,  1.375811509255246e+00, -4.613437780037138e-03, -7.921040867555487e-06,  7.560040068935792e-08,  2.546177194699302e-10,
 -2.445308297356868e-12, -1.003070372183097e-14,  9.904862581302110e-17,  4.310741491654709e-19, -4.610478045330512e-21, -2.061557324712099e-23,  2.219231542333817e-25,
  1.501460053318515e+00, -4.331172906783662e-03, -1.310772250936992e-05,  5.634085374789749e-08,  5.169203198722658e-10, -1.131614438959661e-12, -2.417052087338241e-14,
  8.452304684870392e-18,  1.203439918595047e-18,  1.612620269277880e-21, -6.264456049496138e-23, -2.057867220727680e-25,  1.626059768075966e+00, -3.809413682557185e-03,
 -1.760321225987967e-05,  1.293901260973745e-08,  6.573931362367801e-10,  2.064193930948545e-12, -2.344915916015501e-14, -2.035469836124556e-16,  4.780011742215149e-19,
  1.383948375528943e-20,  2.723690413797964e-23, -7.650122037890362e-25,  1.744940541124532e+00, -3.027338360006076e-03, -1.971413144739290e-05, -4.874582878395866e-08,
  4.436032128237855e-10,  5.199131128588819e-12,  1.080794075282351e-14, -2.323754053700186e-16, -2.290715049465357e-18, -8.613034700054999e-22,  1.495839045672858e-22,
  1.124640576581505e-24,  1.851190012914044e+00, -2.029283877305143e-03, -1.748468661889284e-05, -9.837238752573404e-08, -1.706905716434243e-10,  3.428434187964096e-12,
  4.337167036644797e-14,  2.145671328572506e-16, -7.660724044847952e-19, -2.333096747348209e-20, -1.891474814971809e-22, -2.334616167152754e-25,  1.935477604540417e+00,
 -9.847715198063490e-04, -1.049481455349707e-05, -8.956231324739833e-08, -6.053713787414117e-10, -2.733482525955543e-12,  1.363638110643508e-15,  1.958107077232956e-16,
  2.519663104715244e-18,  1.996320699852042e-20,  8.422294797075547e-23, -3.884029859995365e-25,  1.987265503300042e+00, -2.085941146838589e-04, -2.527965342923841e-06,
 -2.674761969204715e-08, -2.592935266191578e-10, -2.343454143559967e-12, -1.982465969849059e-14, -1.560825272326279e-16, -1.123010965715004e-18, -7.059301039721667e-21,
 -3.379602041239311e-23, -3.848650201614254e-26,  6.993672780155053e-04, -4.162805584056995e-06,  1.857456328092583e-08, -7.369331544835677e-11,  2.736426131741001e-13,
 -9.782200015741563e-16,  3.369048733710768e-18, -1.163260760765837e-20,  3.681442170827063e-23, -1.423629443134223e-25,  2.289852818312916e-28, -3.488527557854120e-30,
  6.296119779257569e-03, -3.743975708923895e-05,  1.666309409543780e-07, -6.579441952899203e-10,  2.424405528197571e-12, -8.570271445000261e-15,  2.905253513539645e-17,
 -9.836011760789970e-20,  3.015971038362009e-22, -1.149100045960011e-24,  1.490564820673325e-27, -2.909030246325303e-29,  1.749930025198348e-02, -1.038562269347248e-04,
  4.598428672639768e-07, -1.798086833724978e-09,  6.521321101785411e-12, -2.251665976189715e-14,  7.376237653171712e-17, -2.390069621898383e-19,  6.796426035029137e-22,
 -2.503057422414705e-24,  1.238306424177655e-27, -6.945078428236278e-29,  3.432825472842890e-02, -2.031301940696718e-04,  8.923110714742967e-07, -3.436850053067898e-09,
  1.215564881039898e-11, -4.038545969667197e-14,  1.247254988654801e-16, -3.726581943165373e-19,  9.016941609333609e-22, -3.099314657315123e-24, -4.844558921978804e-27,
 -1.094997787553376e-28,  5.681198209308479e-02, -3.348202706927123e-04,  1.454938358017538e-06, -5.486957045056462e-09,  1.871610908480294e-11, -5.864501228475401e-14,
  1.641879782268078e-16, -4.198971480303485e-19,  6.477903069946746e-22, -1.797479730854310e-24, -2.035719450025080e-26, -1.413877541825905e-28,  8.498908661394231e-02,
 -4.983023171179656e-04,  2.135119610694541e-06, -7.829522712448530e-09,  2.539296257560948e-11, -7.282512037533719e-14,  1.712499044635409e-16, -2.976594289543031e-19,
 -3.543440975255208e-22,  2.016132142960186e-24, -4.535694895554500e-26, -1.770603044595159e-28,  1.189076721481588e-01, -6.927358638691724e-04,  2.916308043863662e-06,
 -1.031200852852501e-08,  3.118694766063164e-11, -7.777061393232186e-14,  1.245579900870979e-16,  6.032185873617880e-20, -2.204651386754320e-21,  7.797583726686539e-24,
 -7.375689589052542e-26, -2.561800480759166e-28,  1.586251334786768e-01, -9.170179991951595e-04,  3.777439661683115e-06, -1.274586541463877e-08,  3.492686180355113e-11,
 -6.802527701034656e-14,  6.058668724370741e-18,  6.774365887021975e-19, -4.691481052264347e-21,  1.329231492729805e-23, -9.215234867851314e-26, -4.416858575497051e-28,
  2.042077772743396e-01, -1.169721396787035e-03,  4.692193116075437e-06, -1.490410870230843e-08,  3.530165054497711e-11, -3.839952874666472e-14, -1.939645074031734e-16,
  1.503302792165345e-18, -7.161347336687164e-21,  1.430101710629890e-23, -8.175829747017579e-26, -7.944440678898251e-28,  2.557301712695542e-01, -1.449011842813947e-03,
  5.628058079899457e-06, -1.651926669085421e-08,  3.091594593387089e-11,  1.520631098542593e-14, -4.703843457854506e-16,  2.380763212580364e-18, -8.441660695017192e-21,
  5.132797359587310e-24, -2.549916065127870e-26, -1.320898689869709e-27,  3.132740693097851e-01, -1.752538830907950e-03,  6.545183420893990e-06, -1.728248249648178e-08,
  2.038253490166698e-11,  9.463167128804035e-14, -7.952433649936732e-16,  3.017163562001842e-18, -6.892304938653794e-21, -1.974414658119422e-23,  7.791884380172251e-26,
 -1.897626262616487e-27,  3.769266822118237e-01, -2.077290333915782e-03,  7.394980161897330e-06, -1.684512257136517e-08,  2.471822631536378e-12,  1.978320773549088e-13,
 -1.108731298204076e-15,  2.972981641088376e-18, -7.071617866465587e-22, -6.226239224407617e-23,  1.929174711246276e-25, -2.201239992067560e-27,  4.467779443291358e-01,
 -2.419399473187663e-03,  8.118470161005161e-06, -1.482521175496785e-08, -2.365240100713941e-11,  3.167024313324868e-13, -1.310583445779458e-15,  1.692195923118285e-18,
  1.136051709028731e-20, -1.151166212574079e-22,  2.242410673572001e-25, -1.719628711859926e-27,  5.229162377661882e-01, -2.773886165586667e-03,  8.644413106639815e-06,
 -1.082263198212174e-08, -5.806942674853550e-11,  4.343133412132665e-13, -1.255419145670180e-15, -1.383643669041355e-18,  2.864358683827925e-20, -1.544400961870059e-22,
  9.762501441458870e-27,  7.857339133409835e-30,  6.054217380373675e-01, -3.134310585969449e-03,  8.887338533315985e-06, -4.449701638473538e-09, -9.955504398886316e-11,
  5.217366958349422e-13, -7.594664901148248e-16, -6.552394486629182e-18,  4.645157120694553e-20, -1.339297145948638e-22, -6.318591866640067e-25,  2.715277910781468e-27,
  6.943560655896539e-01, -3.492307225864277e-03,  8.745808928412239e-06,  4.611884533764718e-09, -1.447870558076151e-10,  5.351696505313157e-13,  3.669514004703434e-16,
 -1.335465572332335e-17,  5.349943464270977e-20,  1.057288559209642e-23, -1.730881377684230e-24,  4.207035069043546e-27,  7.897461465612464e-01, -3.836958870336364e-03,
  8.101648315703433e-06,  1.650991451494785e-08, -1.872511546151174e-10,  4.152766943224373e-13,  2.235968514935787e-15, -1.978065282465863e-17,  3.042343599087902e-20,
  3.265803912249625e-22, -2.802955024070661e-24, -7.441303300844223e-28,  8.915588980199212e-01, -4.153961334807822e-03,  6.821689312130508e-06,  3.104845435033510e-08,
 -2.158813708512480e-10,  9.319393355906490e-14,  4.709901970414275e-15, -2.129199649987376e-17, -4.612472696212252e-20,  7.498092243472483e-22, -2.364947670465786e-24,
 -1.863384720817366e-26,  9.996612084496164e-01, -4.424530165399794e-03,  4.765201389303718e-06,  4.740254042457119e-08, -2.137528024956430e-10, -4.876228186304261e-13,
  7.102149979387011e-15, -1.036666007715887e-17, -1.840880324305548e-19,  9.318459268186154e-22,  2.008630938003748e-24, -4.616405686859347e-26,  1.113756101819642e+00,
 -4.624032016666670e-03,  1.803241061127403e-06,  6.367430146861820e-08, -1.579085237705304e-10, -1.317278849750900e-12,  7.779086779551247e-15,  2.120968927899942e-17,
 -3.275998840453387e-19,  1.053569408502454e-22,  1.104426038747989e-23, -4.494701122616949e-26,  1.233280042164249e+00, -4.720445013649166e-03, -2.138265115751504e-06,
  7.627397582572611e-08, -2.319564001267115e-11, -2.211570727724110e-12,  3.973429226014379e-15,  7.241473581852273e-17, -2.847775528085723e-19, -2.461721003240393e-21,
  1.565423148376112e-23,  6.580446508930499e-26,  1.357236859883263e+00, -4.673111828785183e-03, -6.991046391812188e-06,  7.927092380643240e-08,  2.035362128693501e-10,
 -2.651364651242435e-12, -7.090193493128945e-15,  1.100480007611102e-16,  2.527092553825774e-19, -5.229045997433500e-21, -1.010656535534165e-23,  2.501590969693227e-25,
  1.483930116008683e+00, -4.433191647658992e-03, -1.238285646601695e-05,  6.439916146741070e-08,  4.885289291905991e-10, -1.704479362936667e-12, -2.338952477942665e-14,
  4.739268733321324e-17,  1.214631103678113e-18, -1.027328113210352e-21, -6.813654552254401e-23, -3.924083147301668e-26,  1.610541701628341e+00, -3.949436567657865e-03,
 -1.738357625555313e-05,  2.375509540049839e-08,  6.925984804171163e-10,  1.435216945614612e-12, -2.885833301389416e-14, -1.801389917896949e-16,  9.871172329760731e-19,
  1.419073512600519e-20, -1.111210879818343e-23, -9.614762302325207e-25,  1.732512237762285e+00, -3.187262568637004e-03, -2.025302480832345e-05, -4.080458402501689e-08,
  5.496099412204288e-10,  5.372175322085457e-12,  3.279306302447792e-15, -3.049259936349827e-16, -2.202602269742106e-18,  6.052104679382260e-21,  1.940935347114912e-22,
  8.500793414497259e-25,  1.842785587917816e+00, -2.173924084125489e-03, -1.867909015696276e-05, -1.004963481564136e-07, -9.124384953567712e-11,  4.537850139354149e-12,
  4.889961149712080e-14,  1.751454301560504e-16, -1.742856846500413e-18, -3.089980894636124e-20, -1.835558087244154e-22,  5.553379273302608e-25,  1.931363556778685e+00,
 -1.073197821675127e-03, -1.162947079625173e-05, -9.968179756555521e-08, -6.592196706488109e-10, -2.625165446103060e-12,  8.087573738971803e-15,  2.885439317981258e-16,
  3.293065718458608e-18,  2.278740845122493e-20,  5.120942481685141e-23, -1.184151325463134e-24,  1.986388542090798e+00, -2.301759887010689e-04, -2.875463619521071e-06,
 -3.129868220071214e-08, -3.112965404240605e-10, -2.875994711343377e-12, -2.473815489121476e-14, -1.963474392753492e-16, -1.401602928912491e-18, -8.412374924410247e-21,
 -3.286023503494157e-23,  9.962018664078322e-26,  6.830077511535040e-04, -4.017673385052433e-06,  1.771588149511790e-08, -6.946726400578713e-11,  2.548610701823384e-13,
 -9.011429473358129e-16,  3.059068878158872e-18, -1.053510022071204e-20,  3.181403116216844e-23, -1.366372635452270e-25,  4.670320348686531e-29, -4.949066917320929e-30,
  6.148977756298414e-03, -3.613764422992458e-05,  1.589628173679887e-07, -6.204879830177527e-10,  2.259755102316165e-12, -7.905006903869712e-15,  2.642741501869943e-17,
 -8.936208174886751e-20,  2.609641890312476e-22, -1.118485649444376e-24, -5.840547839531456e-29, -4.267498964392795e-29,  1.709109863535899e-02, -1.002620519768206e-04,
  4.388773165489497e-07, -1.697254407714956e-09,  6.088161157702080e-12, -2.082429455509671e-14,  6.736114567224005e-17, -2.186971537081044e-19,  5.895982720552235e-22,
 -2.524757194445465e-24, -2.612544665906217e-27, -1.093120370009516e-28,  3.352975431683633e-02, -1.961534283105522e-04,  8.522096760051035e-07, -3.248662193983285e-09,
  1.137704495509694e-11, -3.751410503919550e-14,  1.146779277815073e-16, -3.456372274427165e-19,  7.852811365835190e-22, -3.410733701493073e-24, -1.132832577488508e-26,
 -1.924379669432359e-28,  5.549557008649630e-02, -3.234391347541594e-04,  1.390853596948210e-06, -5.196672356643302e-09,  1.758167345778532e-11, -5.484330958928221e-14,
  1.527101388896151e-16, -4.003746630106265e-19,  5.665949749123501e-22, -2.773339477345376e-24, -2.947952203139720e-26, -2.851817217281932e-28,  8.302945382228182e-02,
 -4.815903796942997e-04,  2.043555713535976e-06, -7.434666876660800e-09,  2.397687866921645e-11, -6.881636343518838e-14,  1.627650050615247e-16, -3.082058012236430e-19,
 -3.168020106137147e-22, -1.076565155767045e-26, -5.758209509195301e-26, -3.966751226745650e-28,  1.161826177300034e-01, -6.698920102316670e-04,  2.795507087255201e-06,
 -9.825297806609662e-09,  2.966152593359923e-11, -7.476868765047869e-14,  1.252973098683356e-16, -6.331494310508101e-21, -1.980451240176696e-21,  4.543861526970136e-24,
 -9.113098047116991e-26, -5.595171152213709e-28,  1.550165451064061e-01, -8.874008866514810e-04,  3.627797401248177e-06, -1.219790562020756e-08,  3.356926087595739e-11,
 -6.766879898402694e-14,  2.299172834887264e-17,  5.342105466052121e-19, -4.284858484224040e-21,  9.119384814532857e-24, -1.192995339718428e-25, -8.282510465698452e-28,
  1.996028475416829e-01, -1.132889706968565e-03,  4.516706645100211e-06, -1.434566529649545e-08,  3.449038607843381e-11, -4.257501128687121e-14, -1.550078436908170e-16,
  1.281670910570428e-18, -6.714828147828631e-21,  1.021491284538391e-23, -1.259362299594895e-25, -1.261611306292495e-27,  2.500229292606196e-01, -1.404771874599821e-03,
  5.432802920291602e-06, -1.602276980956216e-08,  3.111242241322120e-11,  4.686658825096393e-15, -4.074791608380970e-16,  2.113268208705958e-18, -8.290463785862140e-21,
  2.811818005516205e-24, -9.461947877432446e-26, -1.882018234063157e-27,  3.063673314604379e-01, -1.701001241407544e-03,  6.339809529466921e-06, -1.694222960121876e-08,
  2.209102132115958e-11,  7.653403542188333e-14, -7.139540993073516e-16,  2.785665301905451e-18, -7.568683966703229e-21, -1.847549074852265e-23, -1.966463137524081e-26,
 -2.611688918742152e-27,  3.687345616634096e-01, -2.018938094716450e-03,  7.193201949069173e-06, -1.677533783175649e-08,  6.169089563311155e-12,  1.722168681245315e-13,
 -1.026132135695803e-15,  2.915774420145897e-18, -2.835336392713690e-21, -5.674065462950586e-23,  7.591094254679040e-26, -3.201708218314042e-27,  4.372291067811319e-01,
 -2.355169285149688e-03,  7.938500522839756e-06, -1.515466998257103e-08, -1.762885823879593e-11,  2.858543146632297e-13, -1.258724086586758e-15,  1.990985421414758e-18,
  7.355992802176322e-21, -1.080570096083535e-22,  1.179377927465941e-25, -3.207450164691937e-27,  5.119581597517524e-01, -2.705265492490455e-03,  8.509248170152164e-06,
 -1.168390111668965e-08, -4.968708512378976e-11,  4.038168174539585e-13, -1.282164294920747e-15, -5.559641197319380e-19,  2.308566505729131e-20, -1.546218304956585e-22,
 -3.437292265790577e-26, -2.128915102096653e-27,  5.930263177406535e-01, -3.063451756045577e-03,  8.824725804370078e-06, -5.960154230832277e-09, -8.931659429716498e-11,
  5.014712400135934e-13, -9.228816823443370e-16, -5.147772791750843e-18,  4.119767196562624e-20, -1.575179487550805e-22, -5.666725591332788e-25,  8.456895786358673e-29,
  6.805270656096899e-01, -3.422157950108914e-03,  8.787606408429579e-06,  2.381273633572003e-09, -1.340248832427762e-10,  5.396826561516487e-13,  1.695268894931798e-17,
 -1.164961479928033e-17,  5.267365034441836e-20, -5.550701491417606e-23, -1.589395745760022e-24,  1.965716499535230e-27,  7.745291211569589e-01, -3.771403490990788e-03,
  8.282074196907500e-06,  1.358306981406995e-08, -1.784532389757269e-10,  4.624137388382649e-13,  1.697352797290685e-15, -1.864068510923701e-17,  4.015570160150406e-20,
  2.139292745153612e-22, -2.830551116630425e-24, -8.832974798458274e-28,  8.750544767295526e-01, -4.097956033695208e-03,  7.173626994967550e-06,  2.761519977046069e-08,
 -2.129361645956965e-10,  1.989349334201227e-13,  4.096981021963820e-15, -2.235589454833827e-17, -2.102234178993111e-20,  6.398413240038781e-22, -3.111640119040185e-24,
 -1.565793970153715e-26,  9.820428506201865e-01, -4.384192054661749e-03,  5.313219476168838e-06,  4.391362687223038e-08, -2.218275614565542e-10, -3.212886259213621e-13,
  6.734542851934511e-15, -1.570917965908719e-17, -1.495816774064820e-19,  9.719304713568298e-22,  5.776923468670200e-27, -4.479679902338208e-26,  1.095293601664303e+00,
 -4.606594608268910e-03,  2.551337415849087e-06,  6.094732507940515e-08, -1.823451129022597e-10, -1.124632461443026e-12,  8.227347420496434e-15,  1.086825343885246e-17,
 -3.163798688648032e-19,  5.023556091697822e-22,  8.684400431167550e-24, -6.161042115302256e-26,  1.214369833397333e+00, -4.733899617530388e-03, -1.226645203346713e-06,
  7.555484547733467e-08, -6.631484819729787e-11, -2.092984271252981e-12,  5.861029117818864e-15,  6.200961255880566e-17, -3.615534183958046e-19, -1.791187368153896e-21,
  1.752984291200774e-23,  1.883448471784343e-26,  1.338438653191379e+00, -4.725183918609195e-03, -6.022032782110481e-06,  8.209510110232694e-08,  1.490608383554787e-10,
 -2.783815563637024e-12, -3.924366429612860e-15,  1.150663533273666e-16,  5.984867191102483e-20, -5.412683666463056e-21,  8.711227550963383e-25,  2.428088710085903e-25,
  1.466004301983692e+00, -4.529033246173824e-03, -1.156439008326669e-05,  7.191293727094871e-08,  4.489558280217543e-10, -2.245564913211041e-12, -2.152768896604395e-14,
  8.514291160712413e-17,  1.128654028251157e-18, -3.734458211642207e-21, -6.591323760108250e-23,  1.396228620035928e-25,  1.594467892040840e+00, -4.087174617526829e-03,
 -1.703120482912552e-05,  3.502702982555222e-08,  7.139886966386314e-10,  6.861265527851093e-13, -3.338429731009361e-14, -1.405479781535277e-16,  1.479484942074817e-18,
  1.286897722893869e-20, -5.548167863689108e-23, -1.030308508877201e-24,  1.719436259775219e+00, -3.351087714727398e-03, -2.068636604473069e-05, -3.115004376898647e-08,
  6.571088015778101e-10,  5.340715476912087e-12, -6.201567804963084e-15, -3.703601762501929e-16, -1.837282578791761e-18,  1.441465977250206e-20,  2.197643770080531e-22,
  2.640209729060091e-25,  1.833783363003903e+00, -2.328198128839729e-03, -1.989059995811618e-05, -1.011648882811695e-07,  1.160917794343566e-11,  5.762910522517044e-12,
  5.284591987620174e-14,  1.002253546488269e-16, -2.978612571963642e-18, -3.742795404311257e-20, -1.340528128734079e-22,  1.762266651240380e-24,  1.926876859845458e+00,
 -1.171201529270306e-03, -1.289062785995501e-05, -1.106358215753918e-07, -7.090627445355411e-10, -2.321435936395798e-12,  1.776755503771410e-14,  4.073212685138585e-16,
  4.134677404455321e-18,  2.345089505645592e-20, -2.754705438351558e-23, -2.492239247957007e-24,  1.985419326441093e+00, -2.547712978187018e-04, -3.282940259174549e-06,
 -3.677380863614972e-08, -3.752263205667080e-10, -3.541039978345023e-12, -3.091106842969560e-14, -2.462853088075481e-16, -1.726418400576041e-18, -9.566896047658803e-21,
 -2.272136536644338e-23,  3.961030958188724e-25,  6.672153282979613e-04, -3.879212783863253e-06,  1.690615888776402e-08, -6.552977901125581e-11,  2.375490694235076e-13,
 -8.311545918410718e-16,  2.777599196594291e-18, -9.595857558575493e-21,  2.687037494506708e-23, -1.397847737244277e-25, -2.225698919266839e-28, -7.489973858159847e-30,
  6.006924279551183e-03, -3.489512225665145e-05,  1.517287901017835e-07, -5.855630753632560e-10,  2.107799589289714e-12, -7.299868275050074e-15,  2.403610926399038e-17,
 -8.165994710711487e-20,  2.201503091946435e-22, -1.164436718402152e-24, -2.408376320881396e-27, -6.592895312084833e-29,  1.669694577000996e-02, -9.683087676859302e-05,
  4.190812620278028e-07, -1.603089922111171e-09,  5.687356595015593e-12, -1.927906227095107e-14,  6.148789825742562e-17, -2.013148469785245e-19,  4.955121096001868e-22,
 -2.742860930697112e-24, -8.776534855890278e-27, -1.758044423529404e-28,  3.275853335489462e-02, -1.894886481976169e-04,  8.142936422122607e-07, -3.072485432356497e-09,
  1.065351583282138e-11, -3.487524633275116e-14,  1.053327031016578e-16, -3.225788726033957e-19,  6.519823060950667e-22, -4.068660810536087e-24, -2.254892125886648e-26,
 -3.272231414510062e-28,  5.422367890099516e-02, -3.125570461233603e-04,  1.330145807455174e-06, -4.923945152804858e-09,  1.652055981487640e-11, -5.131084439534877e-14,
  1.417366918529574e-16, -3.840966869420562e-19,  4.419661014369796e-22, -4.264051567283769e-24, -4.672672380841278e-26, -5.147446039390595e-28,  8.113523323117115e-02,
 -4.655923795216721e-04,  1.956596752020803e-06, -7.061838145433422e-09,  2.263891000816982e-11, -6.501472321214139e-14,  1.539898641125116e-16, -3.188336624588850e-19,
 -3.636765854769920e-22, -2.755377228732421e-24, -8.219114402662577e-26, -7.460601589461036e-28,  1.135470423213652e-01, -6.479916124809918e-04,  2.680402201516355e-06,
 -9.362513181441743e-09,  2.819617271001271e-11, -7.177071624040957e-14,  1.242520463517044e-16, -6.784778530410130e-20, -1.889566909808269e-21,  2.773513749368503e-25,
 -1.257557139948112e-25, -1.048857141414281e-27,  1.515240720326557e-01, -8.589549787099666e-04,  3.484600631792148e-06, -1.167158966234084e-08,  3.222253558630580e-11,
 -6.695272832932876e-14,  3.607233493899336e-17,  4.013458748890043e-19, -4.052736615593006e-21,  3.450089005204672e-24, -1.688446273823132e-25, -1.471249175917424e-27,
  1.951424789069732e-01, -1.097435330325408e-03,  4.347841016641208e-06, -1.380082148261983e-08,  3.360446661913857e-11, -4.588853680550690e-14, -1.220816371201417e-16,
  1.071587328521987e-18, -6.453009721821332e-21,  3.856995085958100e-24, -1.978408152105704e-25, -2.069780069891486e-27,  2.444895608307723e-01, -1.362070077840199e-03,
  5.243517900805388e-06, -1.552473295848751e-08,  3.111299883933099e-11, -4.412698095201587e-15, -3.520127789610703e-16,  1.848685761493087e-18, -8.279608825919964e-21,
 -2.887137201267991e-24, -1.975807679973692e-25, -2.878698607398376e-27,  2.996634844666947e-01, -1.651089873022119e-03,  6.138671080278428e-06, -1.657743279138298e-08,
  2.345652684450804e-11,  6.030712632169076e-14, -6.394487048087095e-16,  2.532430424087272e-18, -8.278521205885781e-21, -2.188350657946329e-23, -1.597989661576040e-25,
 -3.857252799250456e-27,  3.607726282933228e-01, -1.962195764134233e-03,  6.992599531785637e-06, -1.665038822645451e-08,  9.373707246605315e-12,  1.485572707599207e-13,
 -9.460653001597982e-16,  2.792646996419366e-18, -4.861082757641173e-21, -5.694750936809259e-23, -9.804898983724383e-26, -4.822879975468134e-27,  4.279342876840341e-01,
 -2.292393076245040e-03,  7.755135512496711e-06, -1.539261701329282e-08, -1.220922786074449e-11,  2.563369376454512e-13, -1.200261088035011e-15,  2.164736727239929e-18,
  3.511596474475446e-21, -1.067496561491853e-22, -6.856497315900379e-26, -5.405683747663598e-27,  5.012723394917280e-01, -2.637765246351332e-03,  8.364532488827185e-06,
 -1.241595958703928e-08, -4.191931958466230e-11,  3.729363899742395e-13, -1.288228908312106e-15,  9.321935043999436e-20,  1.746471881861195e-20, -1.586784229961531e-22,
 -1.901850910635790e-25, -5.114633099271776e-27,  5.809132200548627e-01, -2.993163576942371e-03,  8.744956505712212e-06, -7.310234174183658e-09, -7.951958915402867e-11,
  4.777360017783902e-13, -1.049446687144345e-15, -3.924604333991952e-18,  3.511079791883169e-20, -1.811297676735272e-22, -6.414084113623116e-25, -3.692018886270903e-27,
  6.669791661040801e-01, -3.351778432550833e-03,  8.803671270561442e-06,  3.231393274555481e-10, -1.232526078580048e-10,  5.363634360775433e-13, -2.860259226863909e-16,
 -1.000819030222431e-17,  4.954270183440203e-20, -1.183866268451128e-22, -1.583470780280214e-24, -2.002058043163124e-27,  7.595769851111384e-01, -3.704542732966728e-03,
  8.428251408011098e-06,  1.080384277321241e-08, -1.688390988271778e-10,  4.970384712564686e-13,  1.194404771888349e-15, -1.725443838234303e-17,  4.580483943997421e-20,
  9.934852346526269e-23, -2.917660530326054e-24, -3.518790654507794e-27,  8.587794480554813e-01, -4.039299070753797e-03,  7.484715538879338e-06,  2.424517925766311e-08,
 -2.080251994328741e-10,  2.896952725336203e-13,  3.464881837090948e-15, -2.268540698090403e-17, -3.911653528259052e-22,  5.019177597939073e-22, -3.782023671804538e-24,
 -1.532264400662008e-26,  9.645943455940749e-01, -4.339639213943477e-03,  5.818703517801012e-06,  4.032160268338553e-08, -2.266753305990129e-10, -1.654465323207753e-13,
  6.232911420887767e-15, -1.993974906864535e-17, -1.150596148651071e-19,  9.331019426632720e-22, -1.940377059806132e-24, -4.388324533155642e-26,  1.076912604440630e+00,
 -4.583309674517375e-03,  3.264492914524183e-06,  5.786067366000393e-08, -2.028443828546857e-10, -9.246494483536662e-13,  8.393085147287905e-15,  1.094949704850370e-18,
 -2.927327363789930e-19,  7.914853277584447e-22,  5.678302498776760e-24, -7.450610554001032e-26,  1.195420321178978e+00, -4.740107313061627e-03, -3.277083408747730e-07,
  7.416713929970902e-08, -1.066342406756889e-10, -1.932846439128458e-12,  7.426598451242834e-15,  4.954427339658245e-17, -4.133453974511523e-19, -1.087749238184476e-21,
  1.728738820671130e-23, -2.980132618200660e-26,  1.319447855845468e+00, -4.769383330665710e-03, -5.024432625737228e-06,  8.403064367780071e-08,  9.270400656236586e-11,
 -2.839300949969947e-12, -7.048234733000605e-16,  1.138908690978336e-16, -1.318937726111887e-19, -5.174293982658076e-21,  1.073666793408298e-23,  2.001075844036424e-25,
  1.447708771815333e+00, -4.617978021190637e-03, -1.065990569465973e-05,  7.870975024624235e-08,  3.990914885388105e-10, -2.729682279773088e-12, -1.866180487633305e-14,
  1.186149413173405e-16,  9.486876403276682e-19, -6.199045610008517e-21, -5.616472929691630e-23,  2.971997866178109e-25,  1.577849631530501e+00, -4.221547999955527e-03,
 -1.654202914069537e-05,  4.651585964365075e-08,  7.194096358597628e-10, -1.565603101671262e-13, -3.659074870319910e-14, -8.630821812215723e-17,  1.892017132097162e-18,
  9.758800581928754e-21, -9.932509580169652e-23, -9.338571639396383e-25,  1.705698822600764e+00, -3.517887064211263e-03, -2.099359535514818e-05, -1.979351392804989e-08,
  7.615626795208959e-10,  5.061333669814099e-12, -1.730458410471670e-14, -4.191450842655170e-16, -1.159479951826863e-18,  2.319697882208622e-20,  2.129144638224925e-22,
 -6.179611772591423e-25,  1.824144648933247e+00, -2.492166474217537e-03, -2.109943528917780e-05, -9.998742057688155e-08,  1.397166514959305e-10,  7.052839879590241e-12,
  5.410887742187309e-14, -1.750622781955018e-17, -4.399909432957404e-18, -4.080251123855179e-20, -2.338965512603161e-23,  3.307253662697116e-24,  1.921977118642355e+00,
 -1.279833294329495e-03, -1.428777357557084e-05, -1.223249297922664e-07, -7.502229127371989e-10, -1.742437072694300e-12,  3.114889561956238e-14,  5.526811149000117e-16,
  4.927969836996759e-18,  1.963271434078328e-20, -1.774947895561362e-22, -4.432600931593748e-24,  1.984344767868429e+00, -2.829076806360892e-04, -3.762722030070090e-06,
 -4.338676527440743e-08, -4.540579850606558e-10, -4.372223725563801e-12, -3.863328181986251e-14, -3.071743098673648e-16, -2.081704217703398e-18, -9.981512573593052e-21,
  6.244727767440926e-24,  9.837217232240096e-25,  6.519640850238143e-04, -3.747045569076606e-06,  1.614206917531124e-08, -6.185844631059178e-11,  2.215713201327583e-13,
 -7.676239842566451e-16,  2.520180325794830e-18, -8.818943476226020e-21,  2.158938111970849e-23, -1.562890714253766e-25, -6.293751242920914e-28, -1.114353305366812e-29,
  5.869727743390458e-03, -3.370883653793534e-05,  1.448996634827010e-07, -5.529756813565007e-10,  1.967389632151774e-12, -6.749682880283732e-15,  2.184178810665968e-17,
 -7.531065714209230e-20,  1.757148725348545e-22, -1.327987306906829e-24, -6.012266000027514e-27, -9.915990126683548e-29,  1.631620787424839e-02, -9.355365682027543e-05,
  4.003776995777690e-07, -1.515098571811648e-09,  5.316084725954482e-12, -1.786929679296534e-14,  5.605764946375828e-17, -1.871227575917814e-19,  3.883516152452948e-22,
 -3.274705164403760e-24, -1.850373429327156e-26, -2.698618157349172e-28,  3.201337797365249e-02, -1.831189327374415e-04,  7.784239735139589e-07, -2.907474894935505e-09,
  9.980570730881950e-12, -3.245343270838603e-14,  9.656914397621874e-17, -3.042642924079305e-19,  4.853348638215730e-22, -5.310951623480568e-24, -4.094535193511029e-26,
 -5.158486035179276e-28,  5.299436507214804e-02, -3.021478122485181e-04,  1.272611162976084e-06, -4.667644736024253e-09,  1.552749620851538e-11, -4.803677805632441e-14,
  1.311540546153346e-16, -3.728200858067894e-19,  2.485621811568931e-22, -6.674727010031348e-24, -7.613891611774054e-26, -8.335603095393281e-28,  7.930364112609457e-02,
 -4.502725134859117e-04,  1.873985762018760e-06, -6.709820198599718e-09,  2.137484272308268e-11, -6.142752571275050e-14,  1.448797481386569e-16, -3.327650219342279e-19,
 -5.311695165797672e-22, -6.834253915956627e-24, -1.252957961239359e-25, -1.230493905827049e-27,  1.109972614404870e-01, -6.269902341851251e-04,  2.570712030025897e-06,
 -8.922696477091814e-09,  2.679038959027645e-11, -6.881832457930109e-14,  1.214997847987095e-16, -1.292263716053484e-19, -1.982951859808641e-21, -5.865459868708197e-24,
 -1.863771620710150e-25, -1.731424652946215e-27,  1.481431309267974e-01, -8.316297468743825e-04,  3.347590892636541e-06, -1.116669093302440e-08,  3.089297320140381e-11,
 -6.596673001526100e-14,  4.550296680575092e-17,  2.722007221508135e-19, -4.067964607692980e-21, -4.850273758854339e-24, -2.528213726288951e-25, -2.380113363480088e-27,
  1.908212669904165e-01, -1.063305971944429e-03,  4.185426412404050e-06, -1.327064159428317e-08,  3.265970638670024e-11, -4.848170789664310e-14, -9.495927866286315e-17,
  8.655884250578736e-19, -6.481432742208778e-21, -6.199119413460391e-24, -3.134640432580361e-25, -3.231641928284569e-27,  2.391240088610153e-01, -1.320858668684449e-03,
  5.060203600696891e-06, -1.502807297438374e-08,  3.094429927330918e-11, -1.226994257194514e-14, -3.039868913451647e-16,  1.580278858769936e-18, -8.559918465784183e-21,
 -1.372370758813900e-23, -3.548622336127311e-25, -4.329649336224791e-27,  2.931560929484794e-01, -1.602769754611682e-03,  5.942030879586696e-06, -1.619328950242433e-08,
  2.451478724734558e-11,  4.578053810693495e-14, -5.723787240172934e-16,  2.253318135908159e-18, -9.226755329925527e-21, -3.216816293708038e-23, -3.676500590714849e-25,
 -5.663915995101088e-27,  3.530344652870644e-01, -1.907051418943838e-03,  6.793788872410138e-06, -1.647784717119308e-08,  1.212403169712309e-11,  1.267705229535769e-13,
 -8.703651308314103e-16,  2.603081521191829e-18, -7.038619373429199e-21, -6.574718573974087e-23, -3.586663889467284e-25, -7.110533285173740e-27,  4.188876235210331e-01,
 -2.231093779105066e-03,  7.569416191697847e-06, -1.554849509851449e-08, -7.365591698317970e-12,  2.282671387534730e-13, -1.138659699332014e-15,  2.214576883038005e-18,
 -4.455309586815670e-22, -1.150777457360747e-22, -3.695596740163358e-25, -8.376363146699863e-27,  4.908541520498237e-01, -2.571455798597598e-03,  8.211757420652256e-06,
 -1.302867677306799e-08, -3.476925154913580e-11,  3.421080274529291e-13, -1.278666671592337e-15,  5.587189018343347e-19,  1.155127746860690e-20, -1.718803731577844e-22,
 -4.984089222245930e-25, -9.013336564048203e-27,  5.690798998838330e-01, -2.923575728373963e-03,  8.649910591201373e-06, -8.507513475880387e-09, -7.022500741739545e-11,
  4.513513633806628e-13, -1.144623787829546e-15, -2.910740585361700e-18,  2.807665242748530e-20, -2.114243466037297e-22, -9.095461727096950e-25, -8.648771129768409e-27,
  6.537128894150517e-01, -3.281366264018875e-03,  8.796069231137784e-06, -1.563549335993411e-09, -1.126157764007785e-10,  5.263108273993895e-13, -5.447894286940855e-16,
 -8.503502882908875e-18,  4.410537736398092e-20, -1.850556981630669e-22, -1.791506566006364e-24, -7.682184434183327e-27,  7.448944234674685e-01, -3.636643296670221e-03,
  8.542021616786256e-06,  8.183339603174868e-09, -1.586499382596474e-10,  5.200748153048402e-13,  7.321760179983543e-16, -1.575436407824314e-17,  4.723126845572138e-20,
 -2.181593076720824e-23, -3.178392419922909e-24, -8.688011000204751e-27,  8.427437705892552e-01, -3.978313692072941e-03,  7.755892515657879e-06,  2.096742972904210e-08,
 -2.014511132141875e-10,  3.652443441441637e-13,  2.832015627124080e-15, -2.243936744816401e-17,  1.478723151753207e-20,  3.365492354848779e-22, -4.506665135549990e-24,
 -1.808015354491476e-26,  9.473318651268419e-01, -4.291216004207163e-03,  6.280718515534124e-06,  3.667625674489552e-08, -2.285356066283007e-10, -2.294205988983266e-14,
  5.627972999874021e-15, -2.310295014445929e-17, -8.333107188752933e-20,  8.167633653441501e-22, -3.882581767972721e-24, -4.469489668209732e-26,  1.058635915384694e+00,
 -4.554472926922962e-03,  3.938773104847945e-06,  5.447815593680239e-08, -2.193259017211300e-10, -7.238782904324784e-13,  8.297157433265872e-15, -7.779370988464999e-18,
 -2.609700748050046e-19,  9.498903979342437e-22,  2.168500010991256e-24, -8.457562674036937e-26,  1.176460240556872e+00, -4.739200834393172e-03,  5.508173580134684e-07,
  7.216186465676005e-08, -1.434042804316193e-10, -1.739487347870831e-12,  8.623704980576915e-15,  3.582073159268314e-17, -4.405008492125325e-19, -4.364151035972832e-22,
  1.494191899325293e-23, -7.603933901813189e-26,  1.300296347837083e+00, -4.805524421653470e-03, -4.009039295646964e-06,  8.505977402967631e-08,  3.600395131409329e-11,
 -2.818595057512149e-12,  2.397714390460727e-15,  1.067888596199937e-16, -3.084893170619640e-19, -4.588136243303254e-21,  1.804542967886289e-23,  1.281258953266709e-25,
  1.429072430769287e+00, -4.699374947223837e-03, -9.678953098650016e-06,  8.463531804891465e-08,  3.403048282076748e-10, -3.134501553977827e-12, -1.495205583561258e-14,
  1.449965009703908e-16,  6.885674213378958e-19, -8.148446871652495e-21, -4.053559676353632e-23,  4.025893469460294e-25,  1.560702577814454e+00, -4.351456343931511e-03,
 -1.591503532930011e-05,  5.795295513706917e-08,  7.073375323997180e-10, -1.056601026939224e-12, -3.811285473916774e-14, -2.098601173343171e-17,  2.162501484968217e-18,
  5.030471241292982e-21, -1.351574491819138e-22, -6.689052123379750e-25,  1.691290174885008e+00, -3.686571244130177e-03, -2.115475118107082e-05, -6.825318092319886e-09,
  8.576674465231288e-10,  4.501826964083212e-12, -2.942322946949646e-14, -4.413145896104830e-16, -1.804109738051654e-19,  3.086404806603344e-20,  1.626803008356907e-22,
 -1.679600353322194e-24,  1.813830861387859e+00, -2.665712173112835e-03, -2.228098928972092e-05, -9.655341208170575e-08,  2.936318912672709e-10,  8.328304643799347e-12,
  5.142722370135824e-14, -1.816726232120508e-16, -5.846181513813840e-18, -3.834696834672914e-20,  1.578430522060896e-22,  4.901692654172101e-24,  1.916619593181573e+00,
 -1.400213497355882e-03, -1.582869740300197e-05, -1.345610782469377e-07, -7.762477843709489e-10, -7.907493229067909e-13,  4.892576621901986e-14,  7.198910195291074e-16,
  5.453537596306458e-18,  7.920329799849042e-21, -4.267045155904580e-22, -6.978010637055867e-24,  1.983149452648372e+00, -3.152225135459832e-04, -4.330009960010638e-06,
 -5.140469057446673e-08, -5.515114165296981e-10, -5.410488420833520e-12, -4.821987547892946e-14, -3.793895617281694e-16, -2.423663364079988e-18, -8.588544355587390e-21,
  7.141414707572753e-23,  2.089376739581131e-24,  6.372295581838553e-04, -3.620819099546788e-06,  1.542054245356257e-08, -5.843292133110835e-11,  2.068040630503219e-13,
 -7.100301517886789e-16,  2.282035577543085e-18, -8.223992886709221e-21,  1.538118392003099e-23, -1.924077325933424e-25, -1.202590365876467e-27, -1.464926316047738e-29,
  5.737169507882721e-03, -3.257565701078833e-05,  1.384484602473882e-07, -5.225496209211427e-10,  1.837470288669085e-12, -6.250195018138457e-15,  1.980423945568929e-17,
 -7.050827981467280e-20,  1.224318729420805e-22, -1.666068775533242e-24, -1.112832092665885e-26, -1.310154501161558e-28,  1.594828614882312e-02, -9.042194067521206e-05,
  3.826952990915760e-07, -1.432828962102342e-09,  4.971735006274088e-12, -1.658549681797471e-14,  5.097330934453172e-17, -1.767495867060589e-19,  2.540092947035527e-22,
 -4.281504116739539e-24, -3.250447359913833e-26, -3.598919477664553e-28,  3.129313982670261e-02, -1.770284335543926e-04,  7.444713903636799e-07, -2.752855253715679e-09,
  9.353996875226345e-12, -3.023644021433239e-14,  8.823590264136096e-17, -2.921567327796744e-19,  2.586524689098817e-22, -7.461077461275539e-24, -6.789897088342833e-26,
 -6.961665573741193e-28,  5.180578672843274e-02, -2.921868183354012e-04,  1.218058905835501e-06, -4.426723192431129e-09,  1.459739568491189e-11, -4.501369442427091e-14,
  1.207856886757750e-16, -3.693762680523610e-19, -5.629408747768562e-23, -1.055232930713490e-23, -1.200015206555879e-25, -1.138249278303093e-27,  7.753203298437378e-02,
 -4.355969769603709e-04,  1.795479965595915e-06, -6.377465401704460e-09,  2.018029761123063e-11, -5.806440622240999e-14,  1.352798220018550e-16, -3.547812757007989e-19,
 -8.818422734426087e-22, -1.307866141036499e-23, -1.903632002368617e-25, -1.694086402799822e-27,  1.085297639221809e-01, -6.068456439709990e-04,  2.466166639143817e-06,
 -8.504904102133236e-09,  2.544285187635197e-11, -6.595317063774886e-14,  1.169501553509194e-16, -1.976600523314144e-19, -2.348606900449907e-21, -1.505571519503395e-23,
 -2.779963802558724e-25, -2.386745239397339e-27,  1.448693364562755e-01, -8.053767178815121e-04,  3.216512987467742e-06, -1.068289637882393e-08,  2.958509968619376e-11,
 -6.479814564100179e-14,  5.126070261783303e-17,  1.370582622813269e-19, -4.452448235984367e-21, -1.734053093084642e-23, -3.781962639307720e-25, -3.256917479989580e-27,
  1.866340137996804e-01, -1.030450742459089e-03,  4.029281667543627e-06, -1.275595937706064e-08,  3.166912281790064e-11, -5.049362975769822e-14, -7.367900726501357e-17,
  6.518916970615146e-19, -6.967909462966996e-21, -2.194511953482297e-23, -4.821981533922475e-25, -4.358473326729068e-27,  2.339204071652088e-01, -1.281089991685527e-03,
  4.882828035282615e-06, -1.453530929523238e-08,  3.062936534752614e-11, -1.906617112411996e-14, -2.636700260278720e-16,  1.295316720129823e-18, -9.359579495755533e-21,
 -3.218417614732689e-23, -5.786458007245581e-25, -5.742078377719787e-27,  2.868388652335449e-01, -1.556004052607736e-03,  5.750092679696992e-06, -1.579445356569275e-08,
  2.529796026060458e-11,  3.276601545046945e-14, -5.136167256508924e-16,  1.936172869901745e-18, -1.071479937145844e-20, -5.242588058019798e-23, -6.582858497309333e-25,
 -7.421887965436472e-27,  3.455137128173981e-01, -1.853488561453620e-03,  6.597298672067310e-06, -1.626469004217114e-08,  1.445631708365840e-11,  1.067286415896313e-13,
 -8.010114729724764e-16,  2.336551039980836e-18, -9.745726403278327e-21, -8.706491112640304e-23, -7.236434628857343e-25, -9.324034366888816e-27,  4.100831749950882e-01,
 -2.171286443353450e-03,  7.382273057752153e-06, -1.563128563212038e-08, -3.068529592721039e-12,  2.016778439298379e-13, -1.077498736135324e-15,  2.130405445820647e-18,
 -4.951672102603435e-21, -1.381482945619421e-22, -8.051079932153716e-25, -1.122866383288501e-26,  4.806987141153105e-01, -2.506396063753371e-03,  8.052295857616413e-06,
 -1.353190889905039e-08, -2.823251278527100e-11,  3.116436507573943e-13, -1.258810069765885e-15,  8.246606649584890e-19,  4.898168184424090e-21, -2.009430064619938e-22,
 -9.823818730348544e-25, -1.275044308470357e-26,  5.575233228945028e-01, -2.854803229266868e-03,  8.541371814268701e-06, -9.560415942221763e-09, -6.147879754451086e-11,
  4.229966047995770e-13, -1.214745242146375e-15, -2.141926923636213e-18,  1.970474592597922e-20, -2.569462757758166e-22, -1.402208348054863e-24, -1.347195508032956e-26,
  6.407280004409032e-01, -3.211102597042625e-03,  8.766840374058950e-06, -3.281980599296579e-09, -1.022387990001287e-10,  5.105315206221410e-13, -7.642327957475547e-16,
 -7.213324165104134e-18,  3.605539587961556e-20, -2.652901332765328e-22, -2.262926899624300e-24, -1.345923595333109e-26,  7.304850846880403e-01, -3.567956680233665e-03,
  8.625337237597339e-06,  5.728960392061706e-09, -1.481075742888733e-10,  5.325227382065615e-13,  3.119155608712436e-16, -1.428092296843838e-17,  4.404882955654146e-20,
 -1.584010184649905e-22, -3.693836118749289e-24, -1.448440801582072e-26,  8.269561270295308e-01, -3.915314331915446e-03,  7.988414808149589e-06,  1.780613143111950e-08,
 -1.935171158746004e-10,  4.257364735791090e-13,  2.211902002920231e-15, -2.180874465411740e-17,  2.345529547223957e-20,  1.391455837443397e-22, -5.392794030025000e-24,
 -2.197984132039611e-26,  9.302701922568311e-01, -4.239271945748663e-03,  6.698902195767402e-06,  3.302313016144247e-08, -2.276975780082369e-10,  1.040913771234429e-13,
  4.947942282551523e-15, -2.533293713494426e-17, -5.720122686188722e-20,  6.216787541260206e-22, -5.880014531976861e-24, -4.571309088637739e-26,  1.040485098802751e+00,
 -4.520408477681182e-03,  4.571012734710894e-06,  5.086384984789094e-08, -2.318345346937044e-10, -5.282720356240800e-13,  7.967637770325332e-15, -1.557395182848692e-17,
 -2.261299658455198e-19,  9.600414844087847e-22, -1.703248984585669e-24, -9.024191844024889e-26,  1.157517676139522e+00, -4.731372101374443e-03,  1.401882150309694e-06,
  6.960063571483222e-08, -1.760513759994036e-10, -1.522086082170762e-12,  9.427760067942681e-15,  2.158140043965350e-17, -4.463710321453242e-19,  8.230589882837395e-23,
  1.071800797733472e-23, -1.137362087192223e-25,  1.281016578273256e+00, -4.833508332782395e-03, -2.986713047440281e-06,  8.518898331826196e-08, -1.955669500149028e-11,
 -2.726431746319125e-12,  5.225817979257682e-15,  9.442327075410207e-17, -4.595402211558949e-19, -3.778889129655068e-21,  2.177647245433323e-23,  4.060618707521865e-26,
  1.410126624259488e+00, -4.772656397926928e-03, -8.632788075364603e-06,  8.956059915877611e-08,  2.743668356144987e-10, -3.442423569951534e-12, -1.062980013285215e-14,
  1.620599106828423e-16,  3.704595968249534e-19, -9.399818183059682e-21, -2.177030946897322e-23,  4.388062007942971e-25,  1.543046785390971e+00, -4.475804418250389e-03,
 -1.515255401322654e-05,  6.905154299164362e-08,  6.770518132434755e-10, -1.970412515095416e-12, -3.771217880812720e-14,  5.001699350018097e-17,  2.240174134446953e-18,
 -8.549469194966770e-22, -1.561999907380790e-22, -2.698289105832367e-25,  1.676205233191937e+00, -3.855897010657331e-03, -2.115148347944023e-05,  7.575085981592354e-09,
  9.396426453439561e-10,  3.647803022588563e-12, -4.168580209430770e-14, -4.282175716860032e-16,  1.027155227458638e-18,  3.558119828629673e-20,  6.574156381917914e-23,
 -2.695483940331922e-24,  1.802804308788482e+00, -2.848501698808105e-03, -2.340573333933482e-05, -9.045783765357224e-08,  4.720140116092798e-10,  9.479155106336400e-12,
  4.352501702536987e-14, -3.891739473779389e-16, -7.057464339295562e-18, -2.733631636446463e-20,  4.008069856228244e-22,  6.004263082585123e-24,  1.910754954293290e+00,
 -1.533513899699258e-03, -1.751824577671255e-05, -1.470365532476218e-07, -7.785853198629143e-10,  6.452023516819512e-13,  7.154155869131627e-14,  8.950224423796520e-16,
  5.349963055609900e-18, -1.611047340777447e-20, -7.950639428724977e-22, -9.738937577418448e-24,  1.981815152518099e+00, -3.524886805239976e-04, -5.003596201770509e-06,
 -6.116120299286696e-08, -6.722008286947231e-10, -6.704265296616856e-12, -5.996995343245617e-14, -4.611337855105130e-16, -2.654800281330390e-18, -3.386877829875403e-21,
  2.031440266211291e-22,  4.085898777778214e-24,  };
  constexpr double w[10752] = {  1.101083002710989e-01, -5.229315545248714e-04,  2.650505109786504e-06, -1.403474513095300e-08,  7.616491251243493e-11,
 -4.179494882106981e-13,  2.299735423438397e-15, -1.263035340831650e-17,  6.907153969108551e-20, -3.757334492420048e-22,  2.032356237573327e-24, -1.093107677243421e-26,
  1.091316605787018e-01, -8.347214850669470e-04,  7.337342823160817e-06, -6.286704211652996e-08,  5.148757800660510e-10, -4.055056731742003e-12,  3.093220261933089e-14,
 -2.297587707585042e-16,  1.668254411965510e-18, -1.187504848582271e-20,  8.305426076077502e-23, -5.717387772924907e-25,  1.072147096015184e-01, -1.438319368233177e-03,
  1.899539236166887e-05, -2.238851565445896e-07,  2.430204953329370e-09, -2.480357986145548e-11,  2.410450284108612e-13, -2.249277508138142e-15,  2.027542254420595e-17,
 -1.773576454414760e-19,  1.510825641154836e-21, -1.256767621294760e-23,  1.044271965639262e-01, -2.295640775912707e-03,  4.174394877530313e-05, -6.448185045344430e-07,
  8.930343799862713e-09, -1.140097747289188e-10,  1.364562102564541e-12, -1.548653681017531e-14,  1.680157551796491e-16, -1.753119297992330e-18,  1.767541206161660e-20,
 -1.728207211309858e-22,  1.008668458262820e-01, -3.353997047765188e-03,  8.072492818802874e-05, -1.589178582755642e-06,  2.736519459644393e-08, -4.266100676320532e-10,
  6.148706192336686e-12, -8.308949153986179e-14,  1.063275363826358e-15, -1.298076372692666e-17,  1.520498471124067e-19, -1.716372134250652e-21,  9.665204600323404e-02,
 -4.550739848227676e-03,  1.410811307499691e-04, -3.460547061905071e-06,  7.261547083370211e-08, -1.357347500285676e-09,  2.316348337926942e-11, -3.668387946434675e-13,
  5.454380821783125e-15, -7.679914757517252e-17,  1.030825000521521e-18, -1.325685195960176e-20,  9.191353341735072e-02, -5.818454842532354e-03,  2.269111410322591e-04,
 -6.801574692749147e-06,  1.710320238222757e-07, -3.776128567224720e-09,  7.525353818891616e-11, -1.378836309472581e-12,  2.353277790588602e-14, -3.777611157787384e-16,
  5.746202537196061e-18, -8.329930634456187e-20,  8.678597514515829e-02, -7.090085972046940e-03,  3.403802704410318e-04, -1.225528504550974e-05,  3.639297353307377e-07,
 -9.367902066762409e-09,  2.154423549843792e-10, -4.516907540573289e-12,  8.757711290431275e-14, -1.587086600254939e-15,  2.710362870536398e-17, -4.389193506569717e-19,
  8.140026746662042e-02, -8.303448129268037e-03,  4.811256425002317e-04, -2.048654854369814e-05,  7.090316364764871e-07, -2.103207054771081e-08,  5.523052987308692e-10,
 -1.312079752218583e-11,  2.863626032572260e-13, -5.808035257572374e-15,  1.104430371830996e-16, -1.982273982803308e-18,  7.587717226510377e-02, -9.404734845680147e-03,
  6.460300146436269e-04, -3.207306249041652e-05,  1.278191004061406e-06, -4.322839596956300e-08,  1.283731167806385e-09, -3.424934368998221e-11,  8.344450708677367e-13,
 -1.879335291360399e-14,  3.949653254769293e-16, -7.801167028502244e-18,  7.032266362704470e-02, -1.035081276099718e-02,  8.293692558157603e-04, -4.738436087581907e-05,
  2.150269879682012e-06, -8.209611456199663e-08,  2.732355994706089e-09, -8.119352077639337e-11,  2.191330173179279e-12, -5.440729048920045e-14,  1.255079943466926e-15,
 -2.710183805922846e-17,  6.482509937414276e-02, -1.111027869449848e-02,  1.023277641027001e-03, -6.647176706282612e-05,  3.399157949563879e-06, -1.451543341594919e-07,
  5.369043657258430e-09, -1.763256755551627e-10,  5.233597351520070e-12, -1.422779133848789e-13,  3.579430756455906e-15, -8.398516536125051e-17,  5.945410938910843e-02,
 -1.166340773130765e-02,  1.218433852150397e-03, -8.899091267438225e-05,  5.078281848556710e-06, -2.404415321883626e-07,  9.805509563450599e-09, -3.532885547276483e-10,
  1.145337007381692e-11, -3.387324434403543e-13,  9.237279573411190e-15, -2.341365666400911e-16,  5.426093131059562e-02, -1.200122364372502e-02,  1.404853149446062e-03,
 -1.141722763909132e-04,  7.204167340229073e-06, -3.750745092886467e-07,  1.673720534591782e-08, -6.569577546536493e-10,  2.311076528655239e-11, -7.390024504167002e-13,
  2.171743778754524e-14, -5.913660380584251e-16,  4.927983445700192e-02, -1.212397118748318e-02,  1.572676026316042e-03, -1.408461342883163e-04,  9.742295298714939e-06,
 -5.533775650565516e-07,  2.682563005454543e-08, -1.139410555171995e-09,  4.322115337667092e-11, -1.485454280202213e-12,  4.677956633429176e-14, -1.361136780397807e-15,
  4.453024994629103e-02, -1.203926935440569e-02,  1.712864992564725e-03, -1.675187734847356e-04,  1.259842215116100e-05, -7.749024990575305e-07,  4.052532199927040e-08,
 -1.850644710731044e-09,  7.523848772171868e-11, -2.763395941600619e-12,  9.274936696683409e-14, -2.868813732082478e-15,  4.001925427722506e-02, -1.176018844400629e-02,
  1.817751284540872e-03, -1.924889152790422e-04,  1.561772660582567e-05, -1.032773750242868e-06,  5.788137616646107e-08, -2.824155060415819e-09,  1.223350555330138e-10,
 -4.775025897361738e-12,  1.699091670735288e-13, -5.558564506599913e-15,  3.574411617279351e-02, -1.130343720038371e-02,  1.881404896752613e-03, -2.139883515707097e-04,
  1.859280858373865e-05, -1.312807841836620e-06,  7.834203144734896e-08, -4.059473134419307e-09,  1.862920582425714e-10, -7.685735790088902e-12,  2.884415909183957e-13,
 -9.931567498536130e-15,  3.169469375978415e-02, -1.068778341081899e-02,  1.899828754803429e-03, -2.303292149082394e-04,  2.128003135996486e-05, -1.593757487817320e-06,
  1.006405455453422e-07, -5.505800911109361e-09,  2.661877127694880e-10, -1.154634858197976e-11,  4.547309003201308e-13, -1.639953200544401e-14,  2.785554627691538e-02,
 -9.932773006313182e-03,  1.870997876766436e-03, -2.400416756139174e-04,  2.342230286898975e-05, -1.848836081169912e-06,  1.227960381073488e-07, -7.052107046281939e-09,
  3.572446754133921e-10, -1.620820488332750e-11,  6.665449333794549e-13, -2.505899023708308e-14,  2.420769156324417e-02, -9.057765344893947e-03,  1.794776052310315e-03,
 -2.419892892843811e-04,  2.477539809950881e-05, -2.048431930441284e-06,  1.422631367760515e-07, -8.528785223842671e-09,  4.502970264238606e-10, -2.126029209395914e-11,
  9.085136727688426e-13, -3.544007367915662e-14,  2.072999260710841e-02, -8.081268602126220e-03,  1.672746674902838e-03, -2.354536428214422e-04,  2.513446677832845e-05,
 -2.163679989398660e-06,  1.562288118981299e-07, -9.723910361149376e-09,  5.322876513096146e-10, -2.602208416811640e-11,  1.149968021068719e-12, -4.633156812733683e-14,
  1.740019247406000e-02, -7.020538724714726e-03,  1.507992652728052e-03, -2.201844155117060e-04,  2.435745462859102e-05, -2.170374897740827e-06,  1.620192843220044e-07,
 -1.041359972761673e-08,  5.879837971615408e-10, -2.961707073671796e-11,  1.347122763764141e-12, -5.580186500722634e-14,  1.419563890020417e-02, -5.891396213745741e-03,
  1.304854903497605e-03, -1.964148061606992e-04,  2.238269787014077e-05, -2.052619834756056e-06,  1.575495169448209e-07, -1.040190479493533e-08,  6.027445647811745e-10,
 -3.112955131918796e-11,  1.450512112546481e-12, -6.149713192951624e-14,  1.109375229663996e-02, -4.708214869735106e-03,  1.068691883342310e-03, -1.648451411832598e-04,
  1.923878208332098e-05, -1.805625647771780e-06,  1.417307247312301e-07, -9.562253558547865e-09,  5.657957171988520e-10, -2.981710854085844e-11,  1.416699473658835e-12,
 -6.120133192630934e-14,  8.072307765455981e-03, -3.484047245337229e-03,  8.056564949237354e-04, -1.265994707156099e-04,  1.504574829333606e-05, -1.437198002958197e-06,
  1.147526207473360e-07, -7.870883568556042e-09,  4.732012149234424e-10, -2.532438845706919e-11,  1.221264541224936e-12, -5.351961686850282e-14,  5.109734923886602e-03,
 -2.230918291748448e-03,  5.225138757527974e-04, -8.316302938099329e-05,  1.000796303581022e-05, -9.676730229836681e-07,  7.817895926628697e-08, -5.423741070295443e-09,
  3.296888806464160e-10, -1.783277470742079e-11,  8.688689653991604e-13, -3.845544813879782e-14,  2.188474959945105e-03, -9.615767382447456e-04,  2.268132535228723e-04,
 -3.635599190144287e-05,  4.405585314603986e-06, -4.288595399321703e-07,  3.487501212357925e-08, -2.434835041840991e-09,  1.489120803208604e-10, -8.102339512653583e-12,
  3.970314871223028e-13, -1.766919270512505e-14,  1.080579439277176e-01, -5.023810809357759e-04,  2.489133549174330e-06, -1.288009549605584e-08,  6.833045335066531e-11,
 -3.667618339716753e-13,  1.975102753487100e-15, -1.062169042344906e-17,  5.689963429240377e-20, -3.032870335162572e-22,  1.607815413680002e-24, -8.477020478006798e-27,
  1.059055841317422e-01, -7.789062263551306e-04,  6.629814987002944e-06, -5.523958673685404e-08,  4.407068610017011e-10, -3.384223656465345e-12,  2.518636886625217e-14,
 -1.826195925847954e-16,  1.294954558163278e-18, -9.005690085254523e-21,  6.155814095214644e-23, -4.142863165075533e-25,  1.017492290756954e-01, -1.296477461617764e-03,
  1.652666248022106e-05, -1.886762930985423e-07,  1.987238110349514e-09, -1.970644839025443e-11,  1.862660788313591e-13, -1.691959382523692e-15,  1.485719466381936e-17,
 -1.266779516273164e-19,  1.052399081702487e-21, -8.541660501149903e-24,  9.586674493086390e-02, -1.990373844720077e-03,  3.479357912304545e-05, -5.185323817983458e-07,
  6.945428810785285e-09, -8.590999709705147e-11,  9.976153159086411e-13, -1.099696733723727e-14,  1.159893726021464e-16, -1.177530792813263e-18,  1.155906219545389e-20,
 -1.101054826193077e-22,  8.863139336599382e-02, -2.777634880996427e-03,  6.402424727183252e-05, -1.212302151619172e-06,  2.013841579355882e-08, -3.035075953680600e-10,
  4.235880954185956e-12, -5.550104347616103e-14,  6.894064645560342e-16, -8.177406694365627e-18,  9.314223809525828e-20, -1.023150213165253e-21,  8.046877499368334e-02,
 -3.570328583109298e-03,  1.057188902415581e-04, -2.488837542561870e-06,  5.028780934413468e-08, -9.072547163036610e-10,  1.497067341732365e-11, -2.295928249620579e-13,
  3.309915918883373e-15, -4.523591911945798e-17,  5.898979477078429e-19, -7.376746994912698e-21,  7.181221200466444e-02, -4.288282223033611e-03,  1.595044419847760e-04,
 -4.582854493020294e-06,  1.108348106983174e-07, -2.359379016477922e-09,  4.542345275892100e-11, -8.053148410543434e-13,  1.331727937507198e-14, -2.073759911457260e-16,
  3.063157204239422e-18, -4.315995288525652e-20,  6.306335358978776e-02, -4.868915076700022e-03,  2.228761989432758e-04, -7.688249745592443e-06,  2.194706389529365e-07,
 -5.444439416389211e-09,  1.209123477911280e-10, -2.452090787160080e-12,  4.605332468740728e-14, -8.094393527755135e-16,  1.342146727673341e-17, -2.112404099600731e-19,
  5.456284644099565e-02, -5.272782574092699e-03,  2.915045632005185e-04, -1.189545316571970e-05,  3.958160280594998e-07, -1.131631179954219e-08,  2.869951692244215e-10,
 -6.595751483590045e-12,  1.394637999290770e-13, -2.743904445848107e-15,  5.067152419935753e-17, -8.841438940932992e-19,  4.657331550820076e-02, -5.484588318264975e-03,
  3.599755900109479e-04, -1.714338626515957e-05,  6.573317552465222e-07, -2.144001069885976e-08,  6.152514701611683e-10, -1.588841517844491e-11,  3.752375815370661e-13,
 -8.202546796438001e-15,  1.675079188463634e-16, -3.218273062116923e-18,  3.927437851054730e-02, -5.510401988149568e-03,  4.227275506790531e-04, -2.320301520346733e-05,
  1.014335548880677e-06, -3.739033439682165e-08,  1.203755101304067e-09, -3.465682586872681e-11,  9.075214458681983e-13, -2.188940727661207e-14,  4.910962373502599e-16,
 -1.032441409093832e-17,  3.276752668437747e-02, -5.372414874279831e-03,  4.749305395290541e-04, -2.969900331172146e-05,  1.465552551863112e-06, -6.051667104573279e-08,
  2.168302319527960e-09, -6.908466804332796e-11,  1.992040107283586e-12, -5.267365119713258e-14,  1.290338975813014e-15, -2.951000210003135e-17,  2.708770368868901e-02,
 -5.102712860605065e-03,  5.131179895656623e-04, -3.616357784954644e-05,  1.995639272845694e-06, -9.154119854256247e-08,  3.622592890814900e-09, -1.268352476698770e-10,
  4.000897283983896e-12, -1.152638171546253e-13,  3.065106154899322e-15, -7.583350922070522e-17,  2.221827353833149e-02, -4.737331648438871e-03,  5.354804802715553e-04,
 -4.210754458179131e-05,  2.575565635310686e-06, -1.301990070699671e-07,  5.649453916320531e-09, -2.159036266020355e-10,  7.403650003458289e-12, -2.310202284219902e-13,
  6.631462986607819e-15, -1.765448543759607e-16,  1.810655830895994e-02, -4.311438885775137e-03,  5.418327019469336e-04, -4.709031951843460e-05,  3.165860075547770e-06,
 -1.750317785759960e-07,  8.269349333946311e-09, -3.427172359459446e-10,  1.269840313056389e-11, -4.267099441940356e-13,  1.315044182624204e-14, -3.747734223716592e-16,
  1.467794439971462e-02, -3.856025719811335e-03,  5.333351137317465e-04, -5.077382975124786e-05,  3.721887979118010e-06, -2.234078304399179e-07,  1.141489420300048e-08,
 -5.098138003141380e-10,  2.029010472094186e-11, -7.301692080884794e-13,  2.403144037154982e-14, -7.294554585879560e-16,  1.184742901067482e-02, -3.396105531333152e-03,
  5.120819921489568e-04, -5.295187347033624e-05,  4.199848249988332e-06, -2.717763328771446e-07,  1.491957221845343e-08, -7.136855640637985e-10,  3.033412026694337e-11,
 -1.162662820511579e-12,  4.065414287778592e-14, -1.307867986435837e-15,  9.528220230403514e-03, -2.950167895333453e-03,  4.806621139056268e-04, -5.355400496792180e-05,
  4.562152249935072e-06, -3.160985132004342e-07,  1.852536765286410e-08, -9.434619480660401e-10,  4.258356626006927e-11, -1.729084120106221e-12,  6.390620665550929e-14,
 -2.168319782740468e-15,  7.637527932893206e-03, -2.530524471672357e-03,  4.417706996310568e-04, -5.262881662566769e-05,  4.781212664296202e-06, -3.523569655859050e-07,
  2.190891228003023e-08, -1.180952639799734e-09,  5.628918474434981e-11, -2.408529185268115e-12,  9.361874948168582e-14, -3.334025309704084e-15,  6.099981491928130e-03,
 -2.144180045640458e-03,  3.979161502942543e-04, -5.031449106456548e-05,  4.841219499607593e-06, -3.770365732753201e-07,  2.472094716411550e-08, -1.402235257392162e-09,
  7.019448424928780e-11, -3.148544305472803e-12,  1.280658573310646e-13, -4.764167813822934e-15,  4.849224942438279e-03, -1.793923659826378e-03,  3.512336168177447e-04,
 -4.680478206141224e-05,  4.738008643097177e-06, -3.874933581873037e-07,  2.663100734670373e-08, -1.580569087237592e-09,  8.264699823363182e-11, -3.865993978380978e-12,
  1.637349512546330e-13, -6.332527197421640e-15,  3.828229433227153e-03, -1.479422681163829e-03,  3.033953207819170e-04, -4.231699651879079e-05,  4.477494537600932e-06,
 -3.821674859329608e-07,  2.736890485526049e-08, -1.690088494160071e-09,  9.181601155318849e-11, -4.455978967798692e-12,  1.955399301912665e-13, -7.825213787017822e-15,
  2.988782699855272e-03, -1.198189118793721e-03,  2.555958830197090e-04, -3.706614283200036e-05,  4.073294860170769e-06, -3.606381434464688e-07,  2.675644517261323e-08,
 -1.709572007179055e-09,  9.597836946335446e-11, -4.807999207235496e-12,  2.175366768017921e-13, -8.965352604659122e-15,  2.290508881673447e-03, -9.463576138223394e-04,
  2.085878801127066e-04, -3.124704789870890e-05,  3.544149950070456e-06, -3.235493797069300e-07,  2.472585337001598e-08, -1.625617151688216e-09,  9.381600840298376e-11,
 -4.826356256064828e-12,  2.240437064477530e-13, -9.464433903994911e-15,  1.699667060820817e-03, -7.192635468549325e-04,  1.627454672426420e-04, -2.502443699932580e-05,
  2.911600859983966e-06, -2.724520679821399e-07,  2.132448329715582e-08, -1.434731723156804e-09,  8.466595686178266e-11, -4.450356295168143e-12,  2.109244355631886e-13,
 -9.090149167797570e-15,  1.187889127656243e-03, -5.118398717272419e-04,  1.181394560962177e-04, -1.852990627826702e-05,  2.198211515320172e-06, -2.096088677329499e-07,
  1.670772935018313e-08, -1.144101570496856e-09,  6.867477773526152e-11, -3.669644831104917e-12,  1.767058788247706e-13, -7.732748146180192e-15,  7.309670897422840e-04,
 -3.188738467062061e-04,  7.461517077790391e-05, -1.186457760427916e-05,  1.426486749881168e-06, -1.378036875452382e-07,  1.112354434814242e-08, -7.710534206060404e-10,
  4.683095576686840e-11, -2.531054929298102e-12,  1.232256907619480e-13, -5.449795098354147e-15,  3.081482801907800e-04, -1.353443517714054e-04,  3.191111621568989e-05,
 -5.112867466438029e-06,  6.193110045883485e-07, -6.026149478785466e-08,  4.898491153472166e-09, -3.418568668975830e-10,  2.089946661059328e-11, -1.136710540148012e-12,
  5.568037919321488e-14, -2.477055388763215e-15,  1.060872923778906e-01, -4.830682124752230e-04,  2.340898139113023e-06, -1.184301214370245e-08,  6.144617342770109e-11,
 -3.227321689582420e-13,  1.701629514319676e-15, -8.963876797700951e-18,  4.705445346979561e-20, -2.458468476472355e-22,  1.277801125249727e-24, -6.606448945459069e-27,
  1.028920007656292e-01, -7.284042732993394e-04,  6.007116048876390e-06, -4.869856769115338e-08,  3.786759232217001e-10, -2.836711847695601e-12,  2.060761362717208e-14,
 -1.459265566159267e-16,  1.011008858950960e-18, -6.872215960317371e-21,  4.592949571746449e-23, -3.023191060356107e-25,  9.681413193313287e-02, -1.172808547056376e-03,
  1.444106055684146e-05, -1.598058162628097e-07,  1.634236409649842e-09, -1.575477777854738e-11,  1.449155900806089e-13, -1.282052665015175e-15,  1.097199619263293e-17,
 -9.123006883016163e-20,  7.394833950468931e-22, -5.858687096915057e-24,  8.842504328531541e-02, -1.735148231589852e-03,  2.918519611318414e-05, -4.199478473783592e-07,
  5.443727723637654e-09, -6.527899163319245e-11,  7.358759549104776e-13, -7.883007917399684e-15,  8.087286860071867e-17, -7.991984013445757e-19,  7.641745091469798e-21,
 -7.094560469621515e-23,  7.846027396761888e-02, -2.318581654586872e-03,  5.122614386625296e-05, -9.336118927207672e-07,  1.497081535176732e-08, -2.182502368079235e-10,
  2.951108004314093e-12, -3.751081451443040e-14,  4.524917437711133e-16, -5.217112202221201e-18,  5.780820644323001e-20, -6.181909849028160e-22,  6.770745113588730e-02,
 -2.831625614012160e-03,  8.013942458016813e-05, -1.811859771314244e-06,  3.527097656923482e-08, -6.144894388852211e-10,  9.809228441973489e-12, -1.457443693175516e-13,
  2.038075494574826e-15, -2.704655700958397e-17,  3.427911557120629e-19, -4.169649749524622e-21,  5.690113182025134e-02, -3.205312890025640e-03,  1.137659688270926e-04,
 -3.134646925033276e-06,  7.294481309546517e-08, -1.497783007814052e-09,  2.786773542318241e-11, -4.782369397589766e-13,  7.665266649310836e-15, -1.158254280450127e-16,
  1.661832184963938e-18, -2.276493065440046e-20,  4.664393381836629e-02, -3.402601460837568e-03,  1.485465302649192e-04, -4.910819703811119e-06,  1.347980321719318e-07,
 -3.223542795610018e-09,  6.915024920586385e-11, -1.356817911676377e-12,  2.468988842080953e-14, -4.209650217546885e-16,  6.778494400645272e-18, -1.037063011405769e-19,
  3.736377243575136e-02, -3.419113802685922e-03,  1.803489385011376e-04, -7.053528642493138e-06,  2.256739173627465e-07, -6.219265353155577e-09,  1.523461919752282e-10,
 -3.387483915866858e-12,  6.939987096607737e-14, -1.324643571531841e-15,  2.375818734435720e-17, -4.030268767157899e-19,  2.930687951025658e-02, -3.276910998913081e-03,
  2.054458913696882e-04, -9.384127476421034e-06,  3.461602405955483e-07, -1.088828576715559e-08,  3.019190573009249e-10, -7.546594353317362e-12,  1.727586908869536e-13,
 -3.665219073570310e-15,  7.272745605215695e-17, -1.359095970573368e-18,  2.255865777025150e-02, -3.014489129712882e-03,  2.212972928208058e-04, -1.166544601535842e-05,
  4.911293856947506e-07, -1.747507859393719e-08,  5.440906013457455e-10, -1.517416668055367e-11,  3.854566244644198e-13, -9.030337236828681e-15,  1.970061783696160e-16,
 -4.031580286019643e-18,  1.708083338422531e-02, -2.676315268623710e-03,  2.269256375867864e-04, -1.365283791200101e-05,  6.498395621794613e-07, -2.593689115165630e-08,
  8.998717489119307e-10, -2.780593710206779e-11,  7.786566490338030e-13, -2.002009831480789e-14,  4.773994540812154e-16, -1.063895017587113e-17,  1.275362041109760e-02,
 -2.304344730382770e-03,  2.228558674132869e-04, -1.514518615931100e-05,  8.077040387858268e-07, -3.587441533467828e-08,  1.376914572641909e-09, -4.682535573555689e-11,
  1.436537531683152e-12, -4.029758182875077e-14,  1.044524872876088e-15, -2.521465248684006e-17,  9.414391874376402e-03, -1.932678803943877e-03,  2.107361396022988e-04,
 -1.602022725660162e-05,  9.491611645811623e-07, -4.655605147908547e-08,  1.963051522806963e-09, -7.300052936287236e-11,  2.438809246843007e-12, -7.422046539718771e-14,
  2.079979723640066e-15, -5.411164500556602e-17,  6.888051558775117e-03, -1.585369686008666e-03,  1.928189377047173e-04, -1.624655190487319e-05,  1.060694653325100e-06,
 -5.703445862809260e-08,  2.624216138596557e-09, -1.060475562069753e-10,  3.835570599346777e-12, -1.259411939038239e-13,  3.796049404422566e-15, -1.059008725382925e-16,
  5.007641054957147e-03, -1.276653418054095e-03,  1.714666332527630e-04, -1.587370676535191e-05,  1.133106008235917e-06, -6.631910897721084e-08,  3.307961003573957e-09,
 -1.443838086223777e-10,  5.621345188780008e-12, -1.980727131542162e-13,  6.388399702752315e-15, -1.901837469873959e-16,  3.626027504287105e-03, -1.012634565330614e-03,
  1.487848213319259e-04, -1.500803511672340e-05,  1.162529695909226e-06, -7.355115464463481e-08,  3.951723593345888e-09, -1.851826359199652e-10,  7.717337745959035e-12,
 -2.902580376620001e-13,  9.966814469817494e-15, -3.151031999990496e-16,  2.620687559419784e-03, -7.935356172751251e-04,  1.264178129868248e-04, -1.378376304795042e-05,
  1.150171314815799e-06, -7.813255960586760e-08,  4.493351393856433e-09, -2.247366935945325e-10,  9.969325137477950e-12, -3.981254340280838e-13,  1.448147353142701e-14,
 -4.838803743354527e-16,  1.893867769041180e-03, -6.158851552249961e-04,  1.054887811205076e-04, -1.233713648867797e-05,  1.101121863625749e-06, -7.978358532913021e-08,
  4.880877446199575e-09, -2.590307815267233e-10,  1.216362780847591e-11, -5.130618470851611e-13,  1.967002071209404e-14, -6.913146760074506e-16,  1.370116653699841e-03,
 -4.743060133422542e-04,  8.664092197039904e-05, -1.078800475773308e-05,  1.022754310921857e-06, -7.852887349220689e-08,  5.079185485460135e-09, -2.843641331447226e-10,
  1.405758753202748e-11, -6.229993166855430e-13,  2.504868824276781e-14, -9.215415614096939e-16,  9.926693441026564e-04, -3.627935423353562e-04,  7.013201425262996e-05,
 -9.229883235466794e-06,  9.231606244877227e-07, -7.463175081475176e-08,  5.072532833511796e-09, -2.978661320415062e-10,  1.541659651950251e-11, -7.140858950773719e-13,
  2.995874025814302e-14, -1.148198960171202e-15,  7.196384845052746e-04, -2.755173519758831e-04,  5.594402999603473e-05, -7.727221086854704e-06,  8.099256722304478e-07,
 -6.850423027160983e-08,  4.863253123277536e-09, -2.978053922618322e-10,  1.604859454140806e-11, -7.728450957936088e-13,  3.366233724172092e-14, -1.337501431935851e-15,
  5.205352019908920e-04, -2.072465327761052e-04,  4.388332357345488e-05, -6.317570150141586e-06,  6.893528829991952e-07, -6.061772978471123e-08,  4.467860523804811e-09,
 -2.836680385599710e-10,  1.582898214707829e-11, -7.883172706380649e-13,  3.546680775112477e-14, -1.453808802122406e-15,  3.733430898759473e-04, -1.535121886320240e-04,
  3.365966693774639e-05, -5.016316692698092e-06,  5.661171689564373e-07, -5.143125445914026e-08,  3.912067449949576e-09, -2.560454164861291e-10,  1.471269726842471e-11,
 -7.537398905230021e-13,  3.484888538655999e-14, -1.466471097355333e-15,  2.621841033232814e-04, -1.106064022915944e-04,  2.494148131997537e-05, -3.822152176439231e-06,
  4.432450423013996e-07, -4.134440158131341e-08,  3.226025511267518e-09, -2.164065974439695e-10,  1.273402671127616e-11, -6.675040146443928e-13,  3.155233053549180e-14,
 -1.356330508916243e-15,  1.755187094276642e-04, -7.549157778181684e-05,  1.738980443861169e-05, -2.722140188280867e-06,  3.223030051387996e-07, -3.067520174416958e-08,
  2.440646236186768e-09, -1.668354667463695e-10,  9.997322014223075e-12, -5.333330428037442e-13,  2.564118018040997e-14, -1.120363269361936e-15,  1.047850272927043e-04,
 -4.566998800212115e-05,  1.067592727171299e-05, -1.695883832960903e-06,  2.036972403038849e-07, -1.965906690492186e-08,  1.585411016309170e-09, -1.097973566165871e-10,
  6.662866796172855e-12, -3.598007215372329e-13,  1.750271269621282e-14, -7.734634861677706e-16,  4.342915448182108e-05, -1.906740067276698e-05,  4.493673735838857e-06,
 -7.196641403015533e-07,  8.713282441553104e-08, -8.474690106307927e-09,  6.885903928299206e-10, -4.803542017462536e-11,  2.935452942789287e-12, -1.595939343711493e-13,
  7.814462604252809e-15, -3.475100355917610e-16,  1.041915967955255e-01, -4.648932551343251e-04,  2.204474784468169e-06, -1.090937396731479e-08,  5.538043695084861e-11,
 -2.847426130477705e-13,  1.470458008700200e-15, -7.590418567043654e-18,  3.905807254668973e-20, -2.000989850627149e-22,  1.020018470821379e-24, -5.173201196597372e-27,
  1.000709363766746e-01, -6.825860201604399e-04,  5.457297298295566e-06, -4.306808074370821e-08,  3.265745199653289e-10, -2.387721171069660e-12,  1.693979459827300e-14,
 -1.172025444716869e-16,  7.937087224005672e-19, -5.275531302684516e-21,  3.448783683148075e-23, -2.221122439502272e-25,  9.234240692194290e-02, -1.064529006841240e-03,
  1.267045971572951e-05, -1.360013565252951e-07,  1.351205772321733e-09, -1.267074095940910e-11,  1.134777915092152e-13, -9.782567619905262e-16,  8.163422067227906e-18,
 -6.622331185103043e-20,  5.239657879218306e-22, -4.053858871976788e-24,  8.192146445581110e-02, -1.520436807480746e-03,  2.462825092082651e-05, -3.424033660722619e-07,
  4.298285220677522e-09, -4.999884020570647e-11,  5.474452436049649e-13, -5.702024020058158e-15,  5.692681388029522e-17, -5.478568600744806e-19,  5.104863390073886e-21,
 -4.621113962215741e-23,  6.993995203321041e-02, -1.949822211927755e-03,  4.132751033096215e-05, -7.254803814514549e-07,  1.123677588594058e-08, -1.585498788886859e-10,
  2.078184726943909e-12, -2.563810110981186e-14,  3.004852394154493e-16, -3.369097297942645e-18,  3.633142777193035e-20, -3.783798586713576e-22,  5.753788763082842e-02,
 -2.268743088261940e-03,  6.141549690739255e-05, -1.334316778515211e-06,  2.503944217337092e-08, -4.214816270264873e-10,  6.512042953764279e-12, -9.377982735229471e-14,
  1.272594868819966e-15, -1.640507097320124e-17,  2.021531494408565e-19, -2.392673604547504e-21,  4.568718391508919e-02, -2.427868474073272e-03,  8.227074558518525e-05,
 -2.174935007936976e-06,  4.872119384127209e-08, -9.653657357611630e-10,  1.736554162708778e-11, -2.885670467957184e-13,  4.484510657420444e-15, -6.577561342745863e-17,
  9.169604846655761e-19, -1.221569774727718e-20,  3.508301950098089e-02, -2.417655620266931e-03,  1.006900730453659e-04, -3.191119362121848e-06,  8.425412073214342e-08,
 -1.942880572085989e-09,  4.026920974788907e-11, -7.646771874146289e-13,  1.348514348385210e-14, -2.230922913194473e-16,  3.489265979323571e-18, -5.190197965113518e-20,
  2.611247780054244e-02, -2.261814520312142e-03,  1.138317260135044e-04, -4.267409065031374e-06,  1.313002292404441e-07, -3.488474401634546e-09,  8.254961474494455e-11,
 -1.776138294783860e-12,  3.526124273547899e-14, -6.530113737652135e-16,  1.137623965912651e-17, -1.876376067230948e-19,  1.888711728584918e-02, -2.003934652512912e-03,
  1.199844864156152e-04, -5.255976488633253e-06,  1.865153285510666e-07, -5.657596500482242e-09,  1.515876669305401e-10, -3.667376178493754e-12,  8.137766315395792e-14,
 -1.675632131368523e-15,  3.230592757310994e-17, -5.872028082431714e-19,  1.331349700217242e-02, -1.693044833986258e-03,  1.188832697069976e-04, -6.016649990117432e-06,
  2.438967838780860e-07, -8.375140542261353e-09,  2.521419971242870e-10, -6.810760042728462e-12,  1.678054287972694e-13, -3.817901945174207e-15,  8.098107145694718e-17,
 -1.612927282799555e-18,  9.174542964632510e-03, -1.372424984949915e-03,  1.115412416219564e-04, -6.453324969631084e-06,  2.961484728972960e-07, -1.142095033694150e-08,
  3.835671385571067e-10, -1.149112946314239e-11,  3.124209319067118e-13, -7.808497543565667e-15,  1.812068775712860e-16, -3.933975017603825e-18,  6.201553975145825e-03,
 -1.073520729955340e-03,  9.976668204484490e-05, -6.533363309210509e-06,  3.365326623577668e-07, -1.446544096847876e-08,  5.382288024026788e-10, -1.777065144703897e-11,
  5.300021414807335e-13, -1.447087375401057e-14,  3.654748636627327e-16, -8.605008022022640e-18,  4.126495754731125e-03, -8.146237099614082e-04,  8.560172486610938e-05,
 -6.285879561534757e-06,  3.604783337493275e-07, -1.714472172548635e-08,  7.020690666783829e-10, -2.539042915420502e-11,  8.259564170497292e-13, -2.450336653347037e-14,
  6.700821474238362e-16, -1.702724200830869e-17,  2.712861386771577e-03, -6.027617517788712e-04,  7.087185358271039e-05, -5.783923899789416e-06,  3.663997531531134e-07,
 -1.914652819565337e-08,  8.573364883082092e-10, -3.375982078725891e-11,  1.191169424115251e-12, -3.819508160682274e-14,  1.125334917596905e-15, -3.071515364387285e-17,
  1.768760190685344e-03, -4.370201410405888e-04,  5.693273658637272e-05, -5.120128261595983e-06,  3.555846155677398e-07, -2.027574592700898e-08,  9.865181701908555e-10,
 -4.204954531460885e-11,  1.600404921521548e-12, -5.517886048409372e-14,  1.742922629624254e-15, -5.085813259020464e-17,  1.147957030386869e-03, -3.119252416984131e-04,
  4.460725193222809e-05, -4.384721965136169e-06,  3.313866520262066e-07, -2.048060434849376e-08,  1.076049686066572e-09, -4.935951545425760e-11,  2.015399844265074e-12,
 -7.433083071070367e-14,  2.504801372064696e-15, -7.777340012078768e-17,  7.443166535079615e-04, -2.201370864389349e-04,  3.425291837227575e-05, -3.651046901214761e-06,
  2.981361030709351e-07, -1.983874495457050e-08,  1.118622735658692e-09, -5.490239769297206e-11,  2.391848147223317e-12, -9.387729516382080e-14,  3.358355786227408e-15,
 -1.104377829553430e-16,  4.837251692744270e-04, -1.542248639766546e-04,  2.588952708375370e-05, -2.969532443792009e-06,  2.601466008507074e-07, -1.851641336738537e-08,
  1.113618953544843e-09, -5.814338117172723e-11,  2.687924472659541e-12, -1.116875407529731e-13,  4.220652900444961e-15, -1.462999999173154e-16,  3.159833788099658e-04,
 -1.076228327616288e-04,  1.933256699366508e-05, -2.368290153709773e-06,  2.210383275436400e-07, -1.671899387955646e-08,  1.065938722967315e-09, -5.886126797534569e-11,
  2.871619441553827e-12, -1.256595238090048e-13,  4.991161998918308e-15, -1.814910623680199e-16,  2.078843928943235e-04, -7.499571597316792e-05,  1.430207301481083e-05,
 -1.857477044296550e-06,  1.834244641544894e-07, -1.464793222224082e-08,  9.839349436264401e-10, -5.712928705928206e-11,  2.924956690100440e-12, -1.340791783624532e-13,
  5.569177471201059e-15, -2.114060856934313e-16,  1.378447542684945e-04, -5.224812115017328e-05,  1.049703026788438e-05, -1.434876874277792e-06,  1.488905279183535e-07,
 -1.247198681557059e-08,  8.772163977514954e-10, -5.323951120688875e-11,  2.844548052078483e-12, -1.358592757001598e-13,  5.870839812866426e-15, -2.314987104377272e-16,
  9.200326969127176e-05, -3.635974372821251e-05,  7.638077616521702e-06, -1.091029997830409e-06,  1.181507421276864e-07, -1.031388466668776e-08,  7.548676586933298e-10,
 -4.760452779113355e-11,  2.639192877406963e-12, -1.306195482070192e-13,  5.841467019201247e-15, -2.380700514905164e-16,  6.151554913818436e-05, -2.516340476143902e-05,
  5.486554005164578e-06, -8.131388305840480e-07,  9.127374980694143e-08, -8.249122138144596e-09,  6.243257830929011e-10, -4.066569789193685e-11,  2.325889954225622e-12,
 -1.186260944822869e-13,  5.461129237360944e-15, -2.288633496265076e-16,  4.073978866374228e-05, -1.712918879255862e-05,  3.848461577664338e-06, -5.876149525542759e-07,
  6.790331528121287e-08, -6.312142463140774e-09,  4.909006195326327e-10, -3.282571932523698e-11,  1.925654392468820e-12, -1.006431797757094e-13,  4.743805577876349e-15,
 -2.033640862882803e-16,  2.604767373054804e-05, -1.118151627046157e-05,  2.570201050522342e-06, -4.014729881004711e-07,  4.743577186107267e-08, -4.505600176112360e-09,
  3.577856886728743e-10, -2.441117589222192e-11,  1.460141102189266e-12, -7.775855581857732e-14,  3.732097298299531e-15, -1.628046068527274e-16,  1.505441843796963e-05,
 -6.555090690684492e-06,  1.530698885766016e-06, -2.428934627212872e-07,  2.914403063488665e-08, -2.809857455459957e-09,  2.263775052670139e-10, -1.566269608145597e-11,
  9.495810494565099e-13, -5.123206921920808e-14,  2.490040823986506e-15, -1.099448899595959e-16,  6.126705566215280e-06, -2.688796382397080e-06,  6.333827607688887e-07,
 -1.013889126539347e-07,  1.226988261852059e-08, -1.192844997012160e-09,  9.687836502936947e-11, -6.755186603249723e-12,  4.126340641939143e-13, -2.242460323093223e-14,
  1.097564580280425e-15, -4.878939713478158e-17,  1.023664869698490e-01, -4.477664640299333e-04,  2.078696908391915e-06, -1.006699811933116e-08,  5.002198220571370e-11,
 -2.518671526773203e-13,  1.274395037031101e-15, -6.448366833801514e-18,  3.253725214286194e-20, -1.635049279810198e-22,  8.177136969294883e-25, -4.069520108643694e-27,
  9.742475667255959e-02, -6.409095725398614e-04,  4.970324211912862e-06, -3.820390060971793e-08,  2.826339532362518e-10, -2.017842523509913e-12,  1.398694676349191e-14,
 -9.459431228071816e-17,  6.264356250323218e-19, -4.073077358978247e-21,  2.605554137487141e-23, -1.642508582200933e-25,  8.827717677490204e-02, -9.693442085741863e-04,
  1.116025160594281e-05, -1.162702164630144e-07,  1.122950647164194e-09, -1.024851571784865e-11,  8.941235359558579e-14, -7.514514181104222e-16,  6.117311677803181e-18,
 -4.843709497773361e-20,  3.742459375533766e-22, -2.828755852795011e-24,  7.620930245938379e-02, -1.338748643616389e-03,  2.090121919463295e-05, -2.809675485086810e-07,
  3.417754431246801e-09, -3.858709448309420e-11,  4.105863036517975e-13, -4.160179549503847e-15,  4.043741976088771e-17, -3.791652974453762e-19,  3.444389047870413e-21,
 -3.041471612889849e-23,  6.275078481967075e-02, -1.651193311050387e-03,  3.360398878593497e-05, -5.685758641707024e-07,  8.511569414835936e-09, -1.163040853164157e-10,
  1.478527514856149e-12, -1.771229566732142e-14,  2.017882556460043e-16, -2.201134705561078e-18,  2.311024836595054e-20, -2.344946378278463e-22,  4.935299011544771e-02,
 -1.835245191018769e-03,  4.755455668913244e-05, -9.934475326006797e-07,  1.798166180673859e-08, -2.925955213162120e-10,  4.377584153495889e-12, -6.113043540707328e-14,
  8.053290831510982e-16, -1.008855994430985e-17,  1.209143479103981e-19, -1.393047252593400e-21,  3.714369123284231e-02, -1.862180004310828e-03,  6.027811036476935e-05,
 -1.529690898757998e-06,  3.300250539647177e-08, -6.312939371756493e-10,  1.098371869853430e-11, -1.768031338953365e-13,  2.664994438328543e-15, -3.795446241415567e-17,
  5.142626948519049e-19, -6.664478966587149e-21,  2.680976273753292e-02, -1.745036544319329e-03,  6.935486349372597e-05, -2.107892097843857e-06,  5.355053316316341e-08,
 -1.191146785824715e-09,  2.386115914411068e-11, -4.386288291453673e-13,  7.498406237978239e-15, -1.203943311095822e-16,  1.829429898926385e-18, -2.646267046853773e-20,
  1.860642130208723e-02, -1.524961316575721e-03,  7.323270660496811e-05, -2.631981729909177e-06,  7.789142172614929e-08, -1.995501655504468e-09,  4.562422528762271e-11,
 -9.500475274920774e-13,  1.827982244071996e-14, -3.285022746728861e-16,  5.559487181129543e-18, -8.916715514077740e-20,  1.245338967504718e-02, -1.253082829520730e-03,
  7.164048309247657e-05, -3.009530911417134e-06,  1.027399471356894e-07, -3.005400862610374e-09,  7.781238183285833e-11, -1.822153125399442e-12,  3.919288250238180e-14,
 -7.832549766058862e-16,  1.467295760190824e-17, -2.594059072475031e-19,  8.065402385396906e-03, -9.753146304162458e-04,  6.548098119960070e-05, -3.180883847076841e-06,
  1.241298390321490e-07, -4.113028288504592e-09,  1.197185641291057e-10, -3.131693792264547e-12,  7.483117210651104e-14, -1.653276752239973e-15,  3.409109861001726e-17,
 -6.607858952061019e-19,  5.073401104408669e-03, -7.238833166904830e-04,  5.635759517501628e-05, -3.134094986719043e-06,  1.386183843927657e-07, -5.163653638950831e-09,
  1.678223476156542e-10, -4.873290266998732e-12,  1.286062121254381e-13, -3.123879346481370e-15,  7.053323651940567e-17, -1.491397446636351e-18,  3.112306738652691e-03,
 -5.155980413149618e-04,  4.600879921630405e-05, -2.901459794065599e-06,  1.442728386071251e-07, -5.998643793727870e-09,  2.162781778766656e-10, -6.930053759644847e-12,
  2.008559973494416e-13, -5.335812181695661e-15,  1.312610630577766e-16, -3.013307819893483e-18,  1.870219518031129e-03, -3.546072967224711e-04,  3.587641492823257e-05,
 -2.542740468671826e-06,  1.410443480981599e-07, -6.500567439193554e-09,  2.583725153338933e-10, -9.082419281528716e-12,  2.875455818884419e-13, -8.311739225766260e-15,
  2.216990854266074e-16, -5.500154641699889e-18,  1.106035450362069e-03, -2.369232442562184e-04,  2.690199960668796e-05, -2.124576177762484e-06,  1.304827797129702e-07,
 -6.621447837159659e-09,  2.883467689451265e-10, -1.105690035994099e-11,  3.803547411891734e-13, -1.190337953940354e-14,  3.426240505545652e-16, -9.144595542860517e-18,
  6.469125198275575e-04, -1.547005727515297e-04,  1.952605335999068e-05, -1.704188354620107e-06,  1.150417508416828e-07, -6.385475392654959e-09,  3.028252903920356e-10,
 -1.259598008263769e-11,  4.683287621650914e-13, -1.578959377023945e-14,  4.881422466509757e-16, -1.395318380958650e-17,  3.761071803431491e-04, -9.930370175669704e-05,
  1.380589555073300e-05, -1.321044099954700e-06,  9.732095640955634e-08, -5.870174991388077e-09,  3.013516903875783e-10, -1.352071093120537e-11,  5.404982272026476e-13,
 -1.953398276574454e-14,  6.455642785792073e-16, -1.967359327571287e-17,  2.184536491623214e-04, -6.302728929713835e-05,  9.567466146720751e-06, -9.959113275174763e-07,
  7.950575034871946e-08, -5.177685645782175e-09,  2.860016435534932e-10, -1.376366482778811e-11,  5.884364928259755e-13, -2.268238770000549e-14,  7.975033876412133e-16,
 -2.579331123573390e-17,  1.273826669027851e-04, -3.977063273536894e-05,  6.536138534154465e-06, -7.345161404863253e-07,  6.310021881319238e-08, -4.408051963151384e-09,
  2.604122393755461e-10, -1.336580469958193e-11,  6.078478255926577e-13, -2.486324435271499e-14,  9.255106102449399e-16, -3.162002865670831e-17,  7.490573200863646e-05,
 -2.507498635241491e-05,  4.424995211195683e-06, -5.328177596422204e-07,  4.891389092109351e-08, -3.641667923823381e-09,  2.286869144668493e-10, -1.244615404882283e-11,
  5.988116127484166e-13, -2.585604400835609e-14,  1.013917378702635e-15, -3.641817020982506e-17,  4.458692392310801e-05, -1.586331102069889e-05,  2.981823448870528e-06,
 -3.818480793522419e-07,  3.719949306669484e-08, -2.932294471224092e-09,  1.945282386769197e-10, -1.116049220196021e-11,  5.648900876992781e-13, -2.561096487161869e-14,
  1.052603448176534e-15, -3.955380933162734e-17,  2.693311677377982e-05, -1.009941804832990e-05,  2.006159054246478e-06, -2.711990917458575e-07,  2.784087379340620e-08,
 -2.308205306034954e-09,  1.607488773516916e-10, -9.663865119790434e-12,  5.116476735693806e-13, -2.422395657525167e-14,  1.038013845172848e-15, -4.060205291242268e-17,
  1.651803383592826e-05, -6.476074590186041e-06,  1.348886215791057e-06, -1.910680839131387e-07,  2.052416758137215e-08, -1.777705731600242e-09,  1.291363996679790e-10,
 -8.085272636414967e-12,  4.451530485525620e-13, -2.188547224069433e-14,  9.725038173108186e-16, -3.939208336622021e-17,  1.025381899364965e-05, -4.171034879679981e-06,
  9.039681498690760e-07, -1.331769655351245e-07,  1.486273685779699e-08, -1.335790466715690e-09,  1.005566191176046e-10, -6.516071302587234e-12,  3.708440925707596e-13,
 -1.882391296879632e-14,  8.626185810990288e-16, -3.599148663172443e-17,  6.380157741453213e-06, -2.672871449889038e-06,  5.981552034951154e-07, -9.097443767698817e-08,
  1.047283654721226e-08, -9.699577671797984e-10,  7.516749800756683e-11, -5.009200600125340e-12,  2.928907856291570e-13, -1.525943250098849e-14,  7.170655580995938e-16,
 -3.065043692788714e-17,  3.883762346053851e-06, -1.663700251954394e-06,  3.815403147891124e-07, -5.946112338846262e-08,  7.009887655084769e-09, -6.643802541418883e-10,
  5.264755165181702e-11, -3.584818169250834e-12,  2.140069059651984e-13, -1.137538093306757e-14,  5.449851192970196e-16, -2.373243770862563e-17,  2.167998809508527e-06,
 -9.430325241347347e-07,  2.199587096712039e-07, -3.486344305150771e-08,  4.178470615916976e-09, -4.024192261327743e-10,  3.238685290848712e-11, -2.238502127125307e-12,
  1.355791063307844e-13, -7.307792247134833e-15,  3.548523585590580e-16, -1.565406756432655e-17,  8.652045854724475e-07, -3.795428727662359e-07,  8.936279659265065e-08,
 -1.429770134656228e-08,  1.729433149937652e-09, -1.680501416697222e-10,  1.364198584824135e-11, -9.507989003360639e-13,  5.805258219705594e-14, -3.153486186004954e-15,
  1.542802763926484e-16, -6.855273909608507e-18,  1.006079338893446e-01, -4.316068710311773e-04,  1.962534029188570e-06, -9.305342676552559e-09,  4.527645483645634e-11,
 -2.233358898416885e-13,  1.107575624968627e-15, -5.495374781877709e-18,  2.719913770366145e-20, -1.341103310705103e-22,  6.582293640836244e-25, -3.215508709499349e-27,
  9.493784470503358e-02, -6.029068425729751e-04,  4.537735202772803e-06, -3.398723463477415e-08,  2.454305870867107e-10, -1.711802928943115e-12,  1.159826195469673e-14,
 -7.670663390645486e-17,  4.969464058109968e-19, -3.162053598217333e-21,  1.980121032719516e-23, -1.222259595138946e-25,  8.456993901761901e-02, -8.853525777522617e-04,
  9.866407296115881e-06, -9.983295042958805e-08,  9.378428466686165e-10, -8.334500342794320e-12,  7.086939872317287e-14, -5.809348631263594e-16,  4.615537799784608e-18,
 -3.568664453597654e-20,  2.693716801960579e-22, -1.989926478413014e-24,  7.116861310163247e-02, -1.184151063555191e-03,  1.783387765574993e-05, -2.319591350772383e-07,
  2.735823405052154e-09, -2.999634464979486e-11,  3.103406354154830e-13, -3.060402643821196e-15,  2.897578965019115e-17, -2.648301635826057e-19,  2.346395387735577e-21,
 -2.021890079119138e-23,  5.664351381759766e-02, -1.407502938400711e-03,  2.752724262594440e-05, -4.492277796160278e-07,  6.503644860223993e-09, -8.610839591193432e-11,
  1.062235839688942e-12, -1.236290107413012e-14,  1.369692308551167e-16, -1.454189746423100e-18,  1.487118325933921e-20, -1.470703660477267e-22,  4.270374227420348e-02,
 -1.498013555833208e-03,  3.718333093895086e-05, -7.473814197163382e-07,  1.305546631547417e-08, -2.054662146785652e-10,  2.978140096702514e-12, -4.034542299955837e-14,
  5.162121090907107e-16, -6.286712968524418e-18,  7.331290348415880e-20, -8.224437027278742e-22,  3.055468012836457e-02, -1.445277820263217e-03,  4.471558701078268e-05,
 -1.089859744729761e-06,  2.265665022585290e-08, -4.185875079158661e-10,  7.047036449352384e-12, -1.099253224329248e-13,  1.607678598564276e-15, -2.223971498798443e-17,
  2.929713577692896e-19, -3.694437094459921e-21,  2.079750245764949e-02, -1.278438017705889e-03,  4.850530414940319e-05, -1.414286773999647e-06,  3.458427385667702e-08,
 -7.422950509003278e-10,  1.437614001954893e-11, -2.559051901859256e-13,  4.241959636260537e-15, -6.611868854280674e-17,  9.763342620040656e-19, -1.373665131050286e-20,
  1.350461743063543e-02, -1.046935471212320e-03,  4.798006047445051e-05, -1.653486750937071e-06,  4.707677084883503e-08, -1.163199989226570e-09,  2.570101582940413e-11,
 -5.180493120844906e-13,  9.662292629219836e-15, -1.685233781965343e-16,  2.771015125200048e-18, -4.322308425166972e-20,  8.392747555210646e-03, -8.004569810280996e-04,
  4.369234658095476e-05, -1.760183591147607e-06,  5.780928092168925e-08, -1.630921899667033e-09,  4.080585368817993e-11, -9.249764904628712e-13,  1.928637162164793e-14,
 -3.741024429195128e-16,  6.809791510729793e-18, -1.171024141204886e-19,  5.010633864551979e-03, -5.757538731459030e-04,  3.694681996870042e-05, -1.722345391433284e-06,
  6.469434756556556e-08, -2.068267695879507e-09,  5.819911853695837e-11, -1.474241076805845e-12,  3.416118710899851e-14, -7.328390623019624e-16,  1.468954300406000e-17,
 -2.770654288274020e-19,  2.885825434982874e-03, -3.923823284637029e-04,  2.924750591511016e-05, -1.562734266086569e-06,  6.659435294521217e-08, -2.395517627648076e-09,
  7.532533483427895e-11, -2.119672377974775e-12,  5.428504981759500e-14, -1.281240502856473e-15,  2.814090178884548e-17, -5.794242715357640e-19,  1.610887692762342e-03,
 -2.551225409070462e-04,  2.184279098666736e-05, -1.325720138440222e-06,  6.360363675353036e-08, -2.556968747806764e-09,  8.929733306544022e-11, -2.775823548899088e-12,
  7.815655543899270e-14, -2.019473908820406e-15,  4.837379403003991e-17, -1.082428658864330e-18,  8.760104275302493e-04, -1.593393729798834e-04,  1.550688794881565e-05,
 -1.059983264647356e-06,  5.683403928686098e-08, -2.536844574729178e-09,  9.781421471109891e-11, -3.340459907694336e-12,  1.028789244143182e-13, -2.896245806285814e-15,
  7.531693722981671e-17, -1.823561915935456e-18,  4.666845810357391e-04, -9.625455927707274e-05,  1.054376001439450e-05, -8.050727162646880e-07,  4.789842371269781e-08,
 -2.358712867051123e-09,  9.982789633400981e-11, -3.725401009574060e-12,  1.248704152361577e-13, -3.811979787219740e-15,  1.071381928635876e-16, -2.794787316465163e-18,
  2.450181375702559e-04, -5.663369639608392e-05,  6.917822855192905e-06, -5.853642797772163e-07,  3.837533138472036e-08, -2.071757738618329e-09,  9.569294384026202e-11,
 -3.881468649289734e-12,  1.408885719666186e-13, -4.641932028374265e-15,  1.403727631327239e-16, -3.928295278541488e-18,  1.275730450696501e-04, -3.268554588253270e-05,
  4.412548018370367e-06, -4.105835304660426e-07,  2.945576408925294e-08, -1.732478264020941e-09,  8.682920619395103e-11, -3.807533578831189e-12,  1.489109299393251e-13,
 -5.270016493598175e-15,  1.706945129239155e-16, -5.102433875891717e-18,  6.630008716860137e-05, -1.863584632193214e-05,  2.756586236662783e-06, -2.799206350752714e-07,
  2.182558609467221e-08, -1.389771732817441e-09,  7.513952222396469e-11, -3.542768381919882e-12,  1.485257260234465e-13, -5.618757220476090e-15,  1.940278162463670e-16,
 -6.167911202963154e-18,  3.461628619267426e-05, -1.057055069556352e-05,  1.698848573892192e-06, -1.868520138763925e-07,  1.572555079318580e-08, -1.077223219645881e-09,
  6.245774982704495e-11, -3.148779825725540e-12,  1.407654288819508e-13, -5.663983424962936e-15,  2.075377795768540e-16, -6.984108473771217e-18,  1.827151358900206e-05,
 -6.004918540288469e-06,  1.039949513547698e-06, -1.229629832388084e-07,  1.109307001738228e-08, -8.122183418780665e-10,  5.019745070194756e-11, -2.690546153458669e-12,
  1.275672494353234e-13, -5.431454750982791e-15,  2.101392012793729e-16, -7.450994813917269e-18,  9.805160193136522e-06, -3.437158804789600e-06,  6.362254049453442e-07,
 -8.026458112169984e-08,  7.707705311947923e-09, -5.992523873099772e-10,  3.923296770154843e-11, -2.222585439944630e-12,  1.111406490330321e-13, -4.980616845757309e-15,
  2.024288168759282e-16, -7.525694661252565e-18,  5.373821830066946e-06, -1.991966962547748e-06,  3.909174045451638e-07, -5.222264392974223e-08,  5.300161330661243e-09,
 -4.346238117766606e-10,  2.995122944964702e-11, -1.782512502996664e-12,  9.346440083328360e-14, -4.384126572211413e-15,  1.861933984036744e-16, -7.220918470758932e-18,
  3.015387728582883e-06, -1.172108800728132e-06,  2.419142534338958e-07, -3.396053981760100e-08,  3.616448092472904e-09, -3.106348432898804e-10,  2.238495623969714e-11,
 -1.390781866445489e-12,  7.600885687671626e-14, -3.710468444727741e-15,  1.637583063403339e-16, -6.589951037731070e-18,  1.730440801732443e-06, -6.996756604948025e-07,
  1.506555747743035e-07, -2.205354160663251e-08,  2.445970677941952e-09, -2.185204642204475e-10,  1.635556094651437e-11, -1.053996636780825e-12,  5.966745383867388e-14,
 -3.013276073607781e-15,  1.374094924632913e-16, -5.706289752705767e-18,  1.007612609001535e-06, -4.204772205129673e-07,  9.369784513007044e-08, -1.419070697375446e-08,
  1.626935032810800e-09, -1.500864650219533e-10,  1.158684120673286e-11, -7.693292499764540e-13,  4.482487483618323e-14, -2.327446323813888e-15,  1.090144226975941e-16,
 -4.645180725014128e-18,  5.820057905687535e-07, -2.487528053248115e-07,  5.690550391779479e-08, -8.846548092969702e-09,  1.040414521370662e-09, -9.837857583578920e-11,
  7.778320299994611e-12, -5.284863495508634e-13,  3.148384091466227e-14, -1.670137559927137e-15,  7.985996393479981e-17, -3.471184582895085e-18,  3.130095128857888e-07,
 -1.360019145453124e-07,  3.168304413619836e-08, -5.015607133916775e-09,  6.004122180287544e-10, -5.775699745702530e-11,  4.643058007817267e-12, -3.205665386924975e-13,
  1.939520222065778e-14, -1.044344306464478e-15,  5.066123192445689e-17, -2.232754645031879e-18,  1.223152803174208e-07, -5.363192719052343e-08,  1.262104576965623e-08,
 -2.018266645916364e-09,  2.440015009109338e-10, -2.369781158510780e-11,  1.922792414046428e-12, -1.339472809746577e-13,  8.174518584385300e-15, -4.438455810876002e-16,
  2.170483557908065e-17, -9.640093727694995e-19,  9.891221669374867e-02, -4.163412703903395e-04,  1.855073594639114e-06, -8.615259464829848e-09,  4.106358168688232e-11,
 -1.985064546731129e-13,  9.651992283019372e-16, -4.697432472519050e-18,  2.281290540202329e-20, -1.104032858760962e-22,  5.319532309302976e-25, -2.551601270200382e-27,
  9.259632900255332e-02, -5.681720982722308e-04,  4.152367004338808e-06, -3.031980878960532e-08,  2.138130004204746e-10, -1.457521079398881e-12,  9.657027045956161e-15,
 -6.248274870050718e-17,  3.961632368976061e-19, -2.467824175806478e-21,  1.513365880149615e-23, -9.150356511926258e-26,  8.117914807266149e-02, -8.109703020730928e-04,
  8.753228966141676e-06, -8.607381597801246e-08,  7.869254107598579e-10, -6.813255861002815e-12,  5.649173835092934e-14, -4.518734234981164e-16,  3.505387652824824e-18,
 -2.647690198482011e-20,  1.953241141234861e-22, -1.410772686926707e-24,  6.670071558341384e-02, -1.051913039429001e-03,  1.529444506973318e-05, -1.926080483200577e-07,
  2.203943615662633e-09, -2.347989050138616e-11,  2.363169839500976e-13, -2.269211823261576e-15,  2.093698739659186e-17, -1.866040825404418e-19,  1.613186420653664e-21,
 -1.357056013850489e-23,  5.142213213757188e-02, -1.207201375078040e-03,  2.270821311162714e-05, -3.576710153435876e-07,  5.010742896496329e-09, -6.431795014639012e-11,
  7.703174069179766e-13, -8.714251198790551e-15,  9.393104514049964e-17, -9.710439960033302e-19,  9.676200760494230e-21, -9.330446711265030e-23,  3.725445151252636e-02,
 -1.233158986698790e-03,  2.934407653996606e-05, -5.678380565614156e-07,  9.578220216877410e-09, -1.458708010742341e-10,  2.049366923375043e-12, -2.694571386535017e-14,
  3.349839622020391e-16, -3.967625284023985e-18,  4.503574933362475e-20, -4.921231296329683e-22,  2.541411954398504e-02, -1.134285134958722e-03,  3.356318063590133e-05,
 -7.860886450690375e-07,  1.575405423350624e-08, -2.812463230348576e-10,  4.583459867493878e-12, -6.931168527974707e-14,  9.839267615119343e-16, -1.322530171726976e-17,
  1.694397480877787e-19, -2.079751912218034e-21,  1.636428216305215e-02, -9.498919856422109e-04,  3.441871441411906e-05, -9.631451014506780e-07,  2.267908901555566e-08,
 -4.698694349113547e-10,  8.800945084327062e-12, -1.517518817701382e-13,  2.439857271999718e-15, -3.692844869962799e-17,  5.300415468990487e-19, -7.255355117921586e-21,
  9.974885145256959e-03, -7.312299551808120e-04,  3.198633346258675e-05, -1.057224481099727e-06,  2.896537525077923e-08, -6.904252736297532e-10,  1.474566286175261e-11,
 -2.877722236918208e-13,  5.203869278997090e-15, -8.810470550654326e-17,  1.407773624982494e-18, -2.135906936068107e-20,  5.775541271237440e-03, -5.218553148928467e-04,
  2.719443585956110e-05, -1.050665560397840e-06,  3.320013811267012e-08, -9.034212784435546e-10,  2.184566898960804e-11, -4.793870310393377e-13,  9.690381936642212e-15,
 -1.824560387719836e-16,  3.227448135175656e-18, -5.398653067345635e-20,  3.189112805817716e-03, -3.479673606055207e-04,  2.133650198275568e-05, -9.543559949306293e-07,
  3.450122885258891e-08, -1.064151361749848e-09,  2.894694901913942e-11, -7.100218772881993e-13,  1.595439724776653e-14, -3.323157850389193e-16,  6.474937904820259e-18,
 -1.188344395687646e-19,  1.686956837622329e-03, -2.183904206841944e-04,  1.557719582938388e-05, -7.994092063078875e-07,  3.281305320832119e-08, -1.139556523219878e-09,
  3.466092702025227e-11, -9.450265855142824e-13,  2.348296395633361e-14, -5.384553553629753e-16,  1.150256185762416e-17, -2.305910109804414e-19,  8.592415921885650e-04,
 -1.299578346859548e-04,  1.066808245724134e-05, -6.228199067751037e-07,  2.881769138170044e-08, -1.119715391300700e-09,  3.786354320327509e-11, -1.141466221444678e-12,
  3.121256421737787e-14, -7.842112373480725e-16,  1.828604329565991e-17, -3.987234483985529e-19,  4.238241888399947e-04, -7.386636705437673e-05,  6.908893767290016e-06,
 -4.551490362812838e-07,  2.357501160105420e-08, -1.018566880534575e-09,  3.807978726953186e-11, -1.262837438398528e-12,  3.781762827511616e-14, -1.036449780739420e-15,
  2.626754641719734e-17, -6.204387039605266e-19,  2.037313483521774e-04, -4.040705153424395e-05,  4.265672929672532e-06, -3.146332645927415e-07,  1.812034265440878e-08,
 -8.653206583743140e-10,  3.557096818185465e-11, -1.291117041861621e-12,  4.214484031772298e-14, -1.254349625991552e-15,  3.440664923227957e-17, -8.767928026786994e-19,
  9.610013904038471e-05, -2.144096331614405e-05,  2.531772818999536e-06, -2.074967575335314e-07,  1.319914116164698e-08, -6.925249869038236e-10,  3.113139420549397e-11,
 -1.230530656738556e-12,  4.357644654845521e-14, -1.402204340085479e-15,  4.145244915403349e-17, -1.135070255181233e-18,  4.481273117115150e-05, -1.112615637080782e-05,
  1.456802658185732e-06, -1.316787143290027e-07,  9.190722556065611e-09, -5.266460467306781e-10,  2.574768582421714e-11, -1.102646994209514e-12,  4.215943992388173e-14,
 -1.460067362238678e-15,  4.631881382528606e-17, -1.357248716276530e-18,  2.082031676359605e-05, -5.693812814793968e-06,  8.197098997664738e-07, -8.111335471536336e-08,
  6.170843802317252e-09, -3.838507572848806e-10,  2.029579182787051e-11, -9.367816800026059e-13,  3.848218288424547e-14, -1.427689973172413e-15,  4.838815628125710e-17,
 -1.510872783937460e-18,  9.715986196664714e-06, -2.898114572031790e-06,  4.549507913137785e-07, -4.892209091922479e-08,  4.029587231157670e-09, -2.704223772972184e-10,
  1.537491391876278e-11, -7.607403313981341e-13,  3.340481688029031e-14, -1.321235922056516e-15,  4.762170512887463e-17, -1.577479274401493e-18,  4.590945047990063e-06,
 -1.479577712062598e-06,  2.511896911916956e-07, -2.913525559429587e-08,  2.580525356570517e-09, -1.856505197017895e-10,  1.128262174057080e-11, -5.951018631176605e-13,
  2.778495362802167e-14, -1.165693103551816e-15,  4.446650985404987e-17, -1.555440092736706e-18,  2.213422395575173e-06, -7.637095736531952e-07,  1.390715064424212e-07,
 -1.726853231523812e-08,  1.633185654240789e-09, -1.251355422775828e-10,  8.078947310111064e-12, -4.515992999501148e-13,  2.229475363508312e-14, -9.869093899280829e-16,
  3.964120490141723e-17, -1.457185629746134e-18,  1.096169812213404e-06, -4.013290272963870e-07,  7.774548902070457e-08, -1.025547235736962e-08,  1.028243576628697e-09,
 -8.333851013986127e-11,  5.679153258074880e-12, -3.343805262597018e-13,  1.735348425328294e-14, -8.060053623425115e-16,  3.390829163732976e-17, -1.303144478267283e-18,
  5.602852851803139e-07, -2.157837480047141e-07,  4.410130205308027e-08, -6.131767451699886e-09,  6.469315495258007e-10, -5.507422474296082e-11,  3.934896536827909e-12,
 -2.424748114608781e-13,  1.314762921135658e-14, -6.369798292326622e-16,  2.790905012926918e-17, -1.115321922304780e-18,  2.959164207237870e-07, -1.188726217143569e-07,
  2.541747782207291e-08, -3.695156824403780e-09,  4.071071253213846e-10, -3.613769172700062e-11,  2.688151656675668e-12, -1.722083462748693e-13,  9.693524841176716e-15,
 -4.868671573920857e-16,  2.208559545988147e-17, -9.125601705749811e-19,  1.605739915944996e-07, -6.672488076726075e-08,  1.480061546335145e-08, -2.231415638290486e-09,
  2.547013145906793e-10, -2.339672061042612e-11,  1.798873841686996e-12, -1.189703398129690e-13,  6.905621127955184e-15, -3.572599097534911e-16,  1.667517816802265e-17,
 -7.081627987620207e-19,  8.769192471166476e-08, -3.738857544900878e-08,  8.530227144603240e-09, -1.322583953375902e-09,  1.551421638382640e-10, -1.463306891478339e-11,
  1.154173455557140e-12, -7.823625028884634e-14,  4.650380985503228e-15, -2.461590824966085e-16,  1.174600794330024e-17, -5.095327695981893e-19,  4.531473875462433e-08,
 -1.966574961207741e-08,  4.575307099718066e-09, -7.233448885661183e-10,  8.647942122588811e-11, -8.308555799842144e-12,  6.671139931050950e-13, -4.600515666056809e-14,
  2.780302515835815e-15, -1.495434395240429e-16,  7.246716011787004e-18, -3.190545086033514e-19,  1.731165599561583e-08, -7.587009248328879e-09,  1.784456879536390e-09,
 -2.852006662899318e-10,  3.446107023663509e-11, -3.345133255037578e-12,  2.712762192336551e-13, -1.888829546030652e-14,  1.152141937532726e-15, -6.252676190339695e-17,
  3.056229426849693e-18, -1.356787200420662e-19,  9.727589341062753e-02, -4.019033385621137e-04,  1.755505528927811e-06, -7.988787851866664e-09,  3.731485789259333e-11,
 -1.768410499238330e-13,  8.433218536810376e-16, -4.027114839854509e-18,  1.919582727952182e-20, -9.120868251884274e-23,  4.315490995334420e-25, -2.033154067679213e-27,
  9.038785345896518e-02, -5.363524923930555e-04,  3.808132608800420e-06, -2.711998146706024e-08,  1.868456242079005e-10, -1.245392207101366e-12,  8.072424860301704e-15,
 -5.111759680220246e-17,  3.173135733558966e-19, -1.935846038575634e-21,  1.162960252249112e-23, -6.890245975666091e-26,  7.806906602130333e-02, -7.448718678188577e-04,
  7.791618657322557e-06, -7.450354967799980e-08,  6.632554202191608e-10, -5.597437803513167e-12,  4.527648992937923e-14, -3.535572793788007e-16,  2.679089054392335e-18,
 -1.977618995315733e-20,  1.426409481503670e-22, -1.007688432903143e-24,  6.272393799326795e-02, -9.382369818665642e-04,  1.318017263928946e-05, -1.608138917626097e-07,
  1.786281772718630e-09, -1.850081913355637e-11,  1.812313821686547e-13, -1.695338546555662e-15,  1.525002060437900e-17, -1.325975793898439e-19,  1.118933387775033e-21,
 -9.192692585281900e-24,  4.693127802856076e-02, -1.041432582421766e-03,  1.885778340175756e-05, -2.868627449519252e-07,  3.891123587592140e-09, -4.844848225770429e-11,
  5.636336432384572e-13, -6.200427046737163e-15,  6.505323037500157e-17, -6.551064519475204e-19,  6.363439599188152e-21, -5.985105266063005e-23,  3.275157122642300e-02,
 -1.023262877149208e-03,  2.336125889125172e-05, -4.354897932491780e-07,  7.097281616706163e-09, -1.046489747808172e-10,  1.425740381569319e-12, -1.820223853724424e-14,
  2.199586495555144e-16, -2.534718705339406e-18,  2.801482327578407e-20, -2.982961085302526e-22,  2.135977830485760e-02, -8.996185396564261e-04,  2.547458378686737e-05,
 -5.736474018304001e-07,  1.108863711217490e-08, -1.913713706264392e-10,  3.020339335195824e-12, -4.429591033932066e-14,  6.105713821074021e-16, -7.977071799171850e-18,
  9.942808699954521e-20, -1.188261064804127e-21,  1.305006766165971e-02, -7.152507412379271e-04,  2.476163018923456e-05, -6.652827135468998e-07,  1.509062422980867e-08,
 -3.019090528430719e-10,  5.471007756595668e-12, -9.140759702484313e-14,  1.425896327061811e-15, -2.096268334923161e-17,  2.925399517000462e-19, -3.896791964228520e-21,
  7.491278969263301e-03, -5.191443476096006e-04,  2.168017530743447e-05, -6.874532741507072e-07,  1.812925619574721e-08, -4.169869257164833e-10,  8.610545037880648e-12,
 -1.627349017276558e-13,  2.853783772765053e-15, -4.691090545727554e-17,  7.285223751010815e-19, -1.075322108536106e-20,  4.054527069713904e-03, -3.469098041262764e-04,
  1.725857467288587e-05, -6.395271607365135e-07,  1.944567146574040e-08, -5.104402241663338e-10,  1.193058001261580e-11, -2.534825552967476e-13,  4.968053375547551e-15,
 -9.080821278997561e-17,  1.561073434019227e-18, -2.540258479696058e-20,  2.077484754112445e-03, -2.151021559572986e-04,  1.260003253128419e-05, -5.407010420129194e-07,
  1.881216458493011e-08, -5.597922727223885e-10,  1.472013859987309e-11, -3.496190560575984e-13,  7.618071128563199e-15, -1.540657165280718e-16,  2.917889995313350e-18,
 -5.210731407745366e-20,  1.012513721624208e-03, -1.246969963298208e-04,  8.507290165022528e-06, -4.192021947591573e-07,  1.657022493820513e-08, -5.554762616077780e-10,
  1.634043980925196e-11, -4.315999430750335e-13,  1.040468193505739e-14, -2.317474505626588e-16,  4.814387881027495e-18, -9.395530969474593e-20,  4.719342557023357e-04,
 -6.809803486882603e-05,  5.356221252804395e-06, -3.006439400600137e-07,  1.341036606819433e-08, -5.034349363750451e-10,  1.647869088731819e-11, -4.816471558889396e-13,
  1.278709136207064e-14, -3.123165634585300e-16,  7.087435450409315e-18, -1.505563401631565e-19,  2.116652224101061e-04, -3.530661356486893e-05,  3.171137444166791e-06,
 -2.012050223163100e-07,  1.006183580069182e-08, -4.205789246299209e-10,  1.523877570601648e-11, -4.905319963587045e-13,  1.427801379458128e-14, -3.808047387785229e-16,
  9.402211600151729e-18, -2.165750759209045e-19,  9.198246776674846e-05, -1.752075666378447e-05,  1.780779858491106e-06, -1.267782284318873e-07,  7.062645196948759e-09,
 -3.268528797816436e-10,  1.304229557968407e-11, -4.601850349480958e-13,  1.462102377718070e-14, -4.240539236192073e-16,  1.134672482957374e-17, -2.823440970736972e-19,
  3.902848779619264e-05, -8.393775204241489e-06,  9.570691491899892e-07, -7.590046677368390e-08,  4.680771779081028e-09, -2.384922489190012e-10,  1.042677275153552e-11,
 -4.013587949649211e-13,  1.385799204268789e-14, -4.352502667839997e-16,  1.257151548209634e-17, -3.366484184053324e-19,  1.630555107400719e-05, -3.917612050828412e-06,
  4.969182013855714e-07, -4.358609972458782e-08,  2.956900809806477e-09, -1.649305448277033e-10,  7.859460643499585e-12, -3.284618855695290e-13,  1.226906243556045e-14,
 -4.155189995443665e-16,  1.290254001329432e-17, -3.703876333171545e-19,  6.768811507744925e-06, -1.798492653777821e-06,  2.516936340268202e-07, -2.424363386318651e-08,
  1.797779475575729e-09, -1.091422662903869e-10,  5.638727300900993e-12, -2.545778819776595e-13,  1.023937560887294e-14, -3.722800977151712e-16,  1.237537169446033e-17,
 -3.792951219432038e-19,  2.818939518315274e-06, -8.202589978929659e-07,  1.256233597885099e-07, -1.319263791630033e-08,  1.062415924960155e-09, -6.978300326859009e-11,
  3.887105698140959e-12, -1.886070565209795e-13,  8.128485191809193e-15, -3.157941164692069e-16,  1.118849446096484e-17, -3.645720301955007e-19,  1.189456719232377e-06,
 -3.754550814042568e-07,  6.241469712852898e-08, -7.094157151775007e-09,  6.162768237840449e-10, -4.352436022891754e-11,  2.598825388023392e-12, -1.347808716727959e-13,
  6.192026701150461e-15, -2.557930588148774e-16,  9.613795206283375e-18, -3.315446081542257e-19,  5.135021858114487e-07, -1.742040986316936e-07,  3.117589803038757e-08,
 -3.806453251888175e-09,  3.542304196781545e-10, -2.672523540970400e-11,  1.700121355919130e-12, -9.370020114213403e-14,  4.563660746328856e-15, -1.994145059970152e-16,
  7.910895085459541e-18, -2.873558592201181e-19,  2.288677985880684e-07, -8.268741737351577e-08,  1.579791979046202e-08, -2.055990748903625e-09,  2.034822520415352e-10,
 -1.628831134175760e-11,  1.096839707829397e-12, -6.384826097106346e-14,  3.277563270565621e-15, -1.506450621158797e-16,  6.274233966704440e-18, -2.388191564036537e-19,
  1.060796423677101e-07, -4.044978442643332e-08,  8.180408077136232e-09, -1.125720938435228e-09,  1.175937519001862e-10, -9.915792296984935e-12,  7.019989206167650e-13,
 -4.288040216567217e-14,  2.305611861733166e-15, -1.108052851216194e-16,  4.817454653854516e-18, -1.910963652202740e-19,  5.132385356573449e-08, -2.047277939867944e-08,
  4.344643144225051e-09, -6.269523717311812e-10,  6.857988383577450e-11, -6.045797917691692e-12,  4.467574870251031e-13, -2.843895611248309e-14,  1.591088956358700e-15,
 -7.944805593048325e-17,  3.583798597499632e-18, -1.472855382592560e-19,  2.583856877543132e-08, -1.068791257704541e-08,  2.359009167487185e-09, -3.539166366437952e-10,
  4.020567305917516e-11, -3.676392229822006e-12,  2.814199827186777e-13, -1.853342050843009e-14,  1.071408237633268e-15, -5.521302733765255e-17,  2.567434405228904e-18,
 -1.086428478362438e-19,  1.329020099515514e-08, -5.651475825611475e-09,  1.285656741543820e-09, -1.987645382311693e-10,  2.325044758365733e-11, -2.187077234198908e-12,
  1.720560390999433e-13, -1.163374317337932e-14,  6.898486688131464e-16, -3.643130378188131e-17,  1.734525707374675e-18, -7.508152883549541e-20,  6.579494439429409e-09,
 -2.851721594815472e-09,  6.625235451805866e-10, -1.045953375038100e-10,  1.248762499962523e-11, -1.198149061183591e-12,  9.607771952528134e-14, -6.617372284773213e-15,
  3.994350782247250e-16, -2.145925719983056e-17,  1.038721534537726e-18, -4.568266163504843e-20,  2.453130104022243e-09, -1.074557253940589e-09,  2.525892832480649e-10,
 -4.034662139838203e-11,  4.872328236556325e-12, -4.726911119098655e-13,  3.831225086196155e-14, -2.666161807216485e-15,  1.625449027695568e-16, -8.816834330108195e-18,
  4.307424349343837e-19, -1.911324584116812e-20,  9.569577498025487e-02, -3.882328683454043e-04,  1.663109046332069e-06, -7.418982128924181e-09,  3.397164691976595e-11,
 -1.578879429534930e-13,  7.386915245837082e-16, -3.462220256030029e-18,  1.620263850217574e-20, -7.560905655589884e-23,  3.513908097408256e-25, -1.626535975304539e-27,
  8.830138182879560e-02, -5.071401955648108e-04,  3.499840868470209e-06, -2.431965458150169e-08,  1.637648952572589e-10, -1.067743442007028e-12,  6.773419180519536e-15,
 -4.199443541573181e-17,  2.553146117791962e-19, -1.526007920564674e-21,  8.983952632288778e-24, -5.217493994746218e-26,  7.520882611521079e-02, -6.859428240243519e-04,
  6.957736725668753e-06, -6.473121208912029e-08,  5.614185658791189e-10, -4.620530213612634e-12,  3.647746545009986e-14, -2.781974899264552e-16,  2.059999518080349e-18,
 -1.486683823942573e-20,  1.048814845613622e-22, -7.249734634085125e-25,  5.917030166979306e-02, -8.400554610539788e-04,  1.141040214074067e-05, -1.349723898581908e-07,
  1.456183234212109e-09, -1.466987603019529e-11,  1.399335860750677e-13, -1.275808906196251e-15,  1.119340504927946e-17, -9.498712636699788e-20,  7.827267799130471e-22,
 -6.282590172156187e-24,  4.304687344254094e-02, -9.033504847264391e-04,  1.575923144324124e-05, -2.316766051921366e-07,  3.044492699941927e-09, -3.678954044730048e-11,
  4.159426281249394e-13, -4.451662570738726e-15,  4.548059649892584e-17, -4.463351066706366e-19,  4.227904069305077e-21, -3.880157312956430e-23,  2.900173250695742e-02,
 -8.554936487899590e-04,  1.875323316981908e-05, -3.369779421834545e-07,  5.308976175705784e-09, -7.582896080038192e-11,  1.002306342817206e-12, -1.243057768264844e-14,
  1.460729428966433e-16, -1.638364478531893e-18,  1.763846105826535e-20, -1.830694569142011e-22,  1.812920467213226e-02, -7.206080748339205e-04,  1.954071342341745e-05,
 -4.232952281204644e-07,  7.896004728122764e-09, -1.317990672567109e-10,  2.015350299172706e-12, -2.867660501549115e-14,  3.839548194910435e-16, -4.877579194773688e-18,
  5.916563154282904e-20, -6.886744926998838e-22,  1.053993260105623e-02, -5.454031438738881e-04,  1.804861472185831e-05, -4.657896158138978e-07,  1.018213014721867e-08,
 -1.967859277186749e-10,  3.451293826527773e-12, -5.589254852792272e-14,  8.461975107686591e-16, -1.208705798727699e-17,  1.640467208861391e-19, -2.127031742345830e-21,
  5.715547263635639e-03, -3.743374175422814e-04,  1.492847810217512e-05, -4.542566899035881e-07,  1.153434030043370e-08, -2.560736144128628e-10,  5.113887273437431e-12,
 -9.362169144493285e-14,  1.592508396419024e-15, -2.542196159204456e-17,  3.837964076414357e-19, -5.512176949721090e-21,  2.900979333385092e-03, -2.349348715699995e-04,
  1.115864524336475e-05, -3.966341748058059e-07,  1.160674368669415e-08, -2.939503207990677e-10,  6.642022756264090e-12, -1.366522183485820e-13,  2.597155009361512e-15,
 -4.609062403736602e-17,  7.701176260100727e-19, -1.219224583171449e-20,  1.383824518521615e-03, -1.358795297862064e-04,  7.602272759022446e-06, -3.129694056636179e-07,
  1.047944715502106e-08, -3.008521858779707e-10,  7.647770758893482e-12, -1.758911126558363e-13,  3.716596314921063e-15, -7.298016697860898e-17,  1.343542114100568e-18,
 -2.334564867558709e-20,  6.233852288947322e-04, -7.297712393237642e-05,  4.760223947144257e-06, -2.251659116488315e-07,  8.569531706195189e-09, -2.772561969724984e-10,
  7.887185098612275e-12, -2.017935060307618e-13,  4.718994516143783e-15, -1.020897877603411e-16,  2.062276664780619e-18, -3.917562111950243e-20,  2.666850586502597e-04,
 -3.667696375706899e-05,  2.762446091094161e-06, -1.490089682901776e-07,  6.405269540734272e-09, -2.322538499968920e-10,  7.356840390195728e-12, -2.084275539366308e-13,
  5.371231036511783e-15, -1.275030826657961e-16,  2.815328929821938e-18, -5.825129052679829e-20,  1.090445602075387e-04, -1.738861937801364e-05,  1.498567481829376e-06,
 -9.151787939868796e-08,  4.416263335363738e-09, -1.785075558042908e-10,  6.265777732726285e-12, -1.956990718787679e-13,  5.534588856209452e-15, -1.435988062909470e-16,
  3.452958176690021e-18, -7.754068650952187e-20,  4.293044260090585e-05, -7.843587449776060e-06,  7.668021134901842e-07, -5.264905671129797e-08,  2.835147153724832e-09,
 -1.270773227194756e-10,  4.919369890812095e-12, -1.686439367211257e-13,  5.212794240342870e-15, -1.472590768111573e-16,  3.842069491183721e-18, -9.331300851295110e-20,
  1.640938956273195e-05, -3.397308992270613e-06,  3.736402791239615e-07, -2.864603116633256e-08,  1.711267127669907e-09, -8.460917066749817e-11,  3.595071297168422e-12,
 -1.346796330700180e-13,  4.531237442531358e-15, -1.388314372469921e-16,  3.915711847190359e-18, -1.024920959252573e-19,  6.146372267422863e-06, -1.427036904474437e-06,
  1.751431811874778e-07, -1.489203350789168e-08,  9.810527511770179e-10, -5.322083873592441e-11,  2.470035770296700e-12, -1.006629525591147e-13,  3.670821169580917e-15,
 -1.214952477568175e-16,  3.690390112512364e-18, -1.037226336766221e-19,  2.279231214088863e-06, -5.875573901144945e-07,  7.983361015162270e-08, -7.476975272501985e-09,
  5.399026738305918e-10, -3.196019077838368e-11,  1.612014119919312e-12, -7.113217530559640e-14,  2.799117060626378e-15, -9.966156070779776e-17,  3.247153622284402e-18,
 -9.762679095123872e-20,  8.460734687766389e-07, -2.398358888439447e-07,  3.579061566524228e-08, -3.666606462301027e-09,  2.883944516411819e-10, -1.852250614987752e-11,
  1.009939327326198e-12, -4.801429396723138e-14,  2.029353328670666e-15, -7.738374704217415e-17,  2.693091246862669e-18, -8.626228156208332e-20,  3.180920531378264e-07,
 -9.821565232215751e-08,  1.596838332086958e-08, -1.776633824799415e-09,  1.512233992109945e-10, -1.047451394345770e-11,  6.139385473751773e-13, -3.128124102757040e-14,
  1.412969439473385e-15, -5.743095226496485e-17,  2.125208113236889e-18, -7.220749601479658e-20,  1.225735615625771e-07, -4.083851026735685e-08,  7.174803288215044e-09,
 -8.605091940257981e-10,  7.872170300618837e-11, -5.842985374130096e-12,  3.659438742796412e-13, -1.986985847344272e-14,  9.540411757191617e-16, -4.112180742187823e-17,
  1.610084102356967e-18, -5.775530189326774e-20,  4.897036543182375e-08, -1.744215379091304e-08,  3.283490333720772e-09, -4.212207161998864e-10,  4.111638772320836e-11,
 -3.248032616345942e-12,  2.159694520121833e-13, -1.242053040213962e-14,  6.302431015696139e-16, -2.864765207181101e-17,  1.180513385393551e-18, -4.447873172130242e-20,
  2.048855121410091e-08, -7.729200301759547e-09,  1.545548731635351e-09, -2.103481350213060e-10,  2.174046759074827e-11, -1.814586534285407e-12,  1.272151753911177e-13,
 -7.698267645747471e-15,  4.102256973558031e-16, -1.954616484679569e-17,  8.428229713803263e-19, -3.316970952261053e-20,  9.037141171459654e-09, -3.577541949195869e-09,
  7.530661846732195e-10, -1.078071386947200e-10,  1.170205125047992e-11, -1.024004959633173e-12,  7.513368836187456e-14, -4.750270906153700e-15,  2.640359928505927e-16,
 -1.310183687812887e-17,  5.874667057436633e-19, -2.400499282564283e-20,  4.201357935682341e-09, -1.729255783136558e-09,  3.796345200607394e-10, -5.665495016385980e-11,
  6.403208044342177e-12, -5.826241818623477e-13,  4.438767694384645e-14, -2.909956842860726e-15,  1.674900890402975e-16, -8.595182502860501e-18,  3.980751114159687e-19,
 -1.678002272538389e-20,  2.026945467030497e-09, -8.594622709830438e-10,  1.949073542221172e-10, -3.003948649127491e-11,  3.503273613015405e-12, -3.285805866663549e-13,
  2.577686564343841e-14, -1.738236353512102e-15,  1.028058167408249e-16, -5.415725425274484e-18,  2.572304795640395e-19, -1.110905464330015e-20,  9.583250687826998e-10,
 -4.147887441035356e-10,  9.621833334633668e-11, -1.516728125356875e-11,  1.808132410790926e-12, -1.732352362119162e-13,  1.387216126314794e-14, -9.541663290739467e-16,
  5.752045510762274e-17, -3.086371614379950e-18,  1.492138539824315e-19, -6.554772121633293e-21,  3.480624028299933e-10, -1.523805856749261e-10,  3.579728881758889e-11,
 -5.714463955613274e-12,  6.896706701073973e-13, -6.686904942729291e-14,  5.416691355906823e-15, -3.767367707933700e-16,  2.295547539669471e-17, -1.244495303242600e-18,
  6.076757922780294e-20, -2.695063022511864e-21,  9.416890214536652e-02, -3.752751007199190e-04,  1.577241365489694e-06, -6.899766532874386e-09,  3.098361417567373e-11,
 -1.412664850545605e-13,  6.486175030583186e-16, -2.984707805971910e-18,  1.371738491039581e-20, -6.288497640066680e-23,  2.871434544461798e-25, -1.306286843681127e-27,
  8.632703102258919e-02, -4.802658354906275e-04,  3.223049289941624e-06, -2.186180647335883e-08,  1.439449682407926e-10, -9.184166825185077e-13,  5.704166838868992e-15,
 -3.463824200742133e-17,  2.063297983426355e-19, -1.208632231524836e-21,  6.975398665304517e-24, -3.972214981800172e-26,  7.257166573367048e-02, -6.332420493437952e-04,
  6.231955966665657e-06, -5.644275373987927e-08,  4.771681007991585e-10, -3.831563495180037e-12,  2.953578689520952e-14, -2.200895912781078e-16,  1.593210883800384e-18,
 -1.124572909408708e-20,  7.762607134124416e-23, -5.252041550329839e-25,  5.598291955734091e-02, -7.548760069724425e-04,  9.921404496628853e-06, -1.138496208267201e-07,
  1.193672759812934e-09, -1.170262267675561e-11,  1.087516542497121e-13, -9.667916606753462e-16,  8.276662785996710e-18, -6.857567068125871e-20,  5.520265559356677e-22,
 -4.330515902491813e-24,  3.966911133965418e-02, -7.876216034646133e-04,  1.324875025805897e-05, -1.883482596227409e-07,  2.399222687924322e-09, -2.815197571598653e-11,
  3.094705249362738e-13, -3.223801331351497e-15,  3.208587832339373e-17, -3.069843977248688e-19,  2.836818860928367e-21, -2.541322230164127e-23,  2.585609602803523e-02,
 -7.203060028275480e-04,  1.517304430409804e-05, -2.629694388657706e-07,  4.007273029825090e-09, -5.547207641384106e-11,  7.117106711501885e-13, -8.578100562717949e-15,
  9.806422851438658e-17, -1.070957024517443e-18,  1.123502154091456e-20, -1.137040688844181e-22,  1.553004125876632e-02, -5.826373463258609e-04,  1.514002255790432e-05,
 -3.156689375579395e-07,  5.685210835605073e-09, -9.182489206240232e-11,  1.360962385590899e-12, -1.879610516828056e-14,  2.445478292467072e-16, -3.021753908023068e-18,
  3.568360459058482e-20, -4.046610150927264e-22,  8.615247287107919e-03, -4.208748982515917e-04,  1.331999161977406e-05, -3.303425794997598e-07,  6.962216801122459e-09,
 -1.300358600301979e-10,  2.208053021570744e-12, -3.467282310005406e-14,  5.096356476509995e-16, -7.075056684594704e-18,  9.341321601140547e-20, -1.179271725717416e-21,
  4.426495390089002e-03, -2.739265191638619e-04,  1.043507937955443e-05, -3.048080662533717e-07,  7.454390409614622e-09, -1.597890704298734e-10,  3.087001005172267e-12,
 -5.475885204175358e-14,  9.037187750289909e-16, -1.401316622907963e-17,  2.057048859164268e-19, -2.875278861208116e-21,  2.113565639088416e-03, -1.619434838652330e-04,
  7.344144372625027e-06, -2.504468342214418e-07,  7.054623212889903e-09, -1.724095891167830e-10,  3.766838302535351e-12, -7.505813712966233e-14,  1.383538476939049e-15,
 -2.384215168191389e-17,  3.872524957480300e-19, -5.965477493264592e-21,  9.416508233304539e-04, -8.763340215358479e-05,  4.682354145050285e-06, -1.849224110692975e-07,
  5.959307643626841e-09, -1.650670239714391e-10,  4.056618421446552e-12, -9.034912728047061e-14,  1.851398342683292e-15, -3.530024527693867e-17,  6.317194095375682e-19,
 -1.068111065373404e-20,  3.933366537572863e-04, -4.373541904371288e-05,  2.726639642301032e-06, -1.237820792740482e-07,  4.535275295206075e-09, -1.416028973050521e-10,
  3.895119154386670e-12, -9.652564801106653e-14,  2.189529527603805e-15, -4.600461696192289e-17,  9.035973345191673e-19, -1.670711113234128e-20,  1.549138395192832e-04,
 -2.028689062842222e-05,  1.462346845471547e-06, -7.577431668903467e-08,  3.137976353532829e-09, -1.098716580186750e-10,  3.367164817136114e-12, -9.244757142516199e-14,
  2.312094067929702e-15, -5.333285581276664e-17,  1.145615097667765e-18, -2.308360373744656e-20,  5.790703122501971e-05, -8.817936213717261e-06,  7.286252769637759e-07,
 -4.280427257695048e-08,  1.992218218843852e-09, -7.783723771699933e-11,  2.645803500707960e-12, -8.015245858419731e-14,  2.201749699070573e-15, -5.555582924485862e-17,
  1.300629104334784e-18, -2.846596164071353e-20,  2.070182932327901e-05, -3.623429260056374e-06,  3.404070160366373e-07, -2.252428504672697e-08,  1.171701153994814e-09,
 -5.083547311985862e-11,  1.908185876473057e-12, -6.352641184306905e-14,  1.909463382415862e-15, -5.251747667366877e-17,  1.335493461677583e-18, -3.164572402469184e-20,
  7.140691951526466e-06, -1.421225533830536e-06,  1.506088952730240e-07, -1.115265235009767e-08,  6.448615806712610e-10, -3.091703886696466e-11,  1.275901568486395e-12,
 -4.648984197097552e-14,  1.523250826926517e-15, -4.550288971037010e-17,  1.252597400364320e-18, -3.203068742535020e-20,  2.400324397655367e-06, -5.377734865613039e-07,
  6.378830847927125e-08, -5.252363598850434e-09,  3.356951620826932e-10, -1.769690709204400e-11,  7.993088624394514e-13, -3.174268386053141e-14,  1.129305424189973e-15,
 -3.650452845398804e-17,  1.083988052709770e-18, -2.981215080429625e-20,  7.952021755075889e-07, -1.985991992078858e-07,  2.616647970380994e-08, -2.380237799639292e-09,
  1.671959932075645e-10, -9.641790642224245e-12,  4.743708193252367e-13, -2.044213686550479e-14,  7.864246819861119e-16, -2.740092358751228e-17,  8.744469129995586e-19,
 -2.577309268924706e-20,  2.628791833577430e-07, -7.249156463666623e-08,  1.052763556057301e-08, -1.050907937620616e-09,  8.064792078977331e-11, -5.059924067374234e-12,
  2.698156235695951e-13, -1.255795902738349e-14,  5.201105853092039e-16, -1.945171741878257e-17,  6.644797897087770e-19, -2.090803814968512e-20,  8.788953266935102e-08,
 -2.650958226572618e-08,  4.210195195051870e-09, -4.580083131539953e-10,  3.815823572865966e-11, -2.589647220379778e-12,  1.488620738717166e-13, -7.445274916437063e-15,
  3.303879825867159e-16, -1.320273104236837e-17,  4.806778680692616e-19, -1.607938406632555e-20,  3.013941251663772e-08, -9.850102915839116e-09,  1.696936993670857e-09,
 -1.997077325987873e-10,  1.794230612898351e-11, -1.308945636088371e-12,  8.063905751177875e-14, -4.310127028506816e-15,  2.038572272531068e-16, -8.661132473431614e-18,
  3.344693668102771e-19, -1.184025906890899e-20,  1.075143704887394e-08, -3.771340639777023e-09,  6.988277318615299e-10, -8.828479774916929e-11,  8.491906920000937e-12,
 -6.614605148115627e-13,  4.339494311932257e-14, -2.463805181888784e-15,  1.234909621927594e-16, -5.547585518491652e-18,  2.260410416697962e-19, -8.425213115709401e-21,
  4.041757363151954e-09, -1.507196581147463e-09,  2.977457862752757e-10, -4.004585057917028e-11,  4.092034505613196e-12, -3.378367255632629e-13,  2.343853638127739e-14,
 -1.404242668853438e-15,  7.411650767084143e-17, -3.499224985633553e-18,  1.495651832218081e-19, -5.836928368072207e-21,  1.617173230027913e-09, -6.349434880314008e-10,
  1.324882048736320e-10, -1.880438467260794e-11,  2.024290951000608e-12, -1.757343462475087e-13,  1.279608096409046e-14, -8.031334701855302e-16,  4.432949806956177e-17,
 -2.184987217741598e-18,  9.734355443763466e-20, -3.953240166430492e-21,  6.908460520068845e-10, -2.828217399005867e-10,  6.173016494482360e-11, -9.159778476518865e-12,
  1.029535258168353e-12, -9.317952781437909e-14,  7.062782977478691e-15, -4.607573842882210e-16,  2.639578494776616e-17, -1.348477715142861e-18,  6.218367814555346e-20,
 -2.610398981027259e-21,  3.112495400236956e-10, -1.315652786157909e-10,  2.973495883855823e-11, -4.567423288331347e-12,  5.309283110744972e-13, -4.964068310044895e-14,
  3.882507830006135e-15, -2.610531914158701e-16,  1.539663091197956e-17, -8.089102709087001e-19,  3.832194900448910e-20, -1.650936089618109e-21,  1.400574326528271e-10,
 -6.053006165714264e-11,  1.401799803530449e-11, -2.206089553015384e-12,  2.625735101997541e-13, -2.511796402219443e-14,  2.008367279686702e-15, -1.379421756167879e-16,
  8.304086238003641e-18, -4.449754880973091e-19,  2.148504501859839e-20, -9.426392427233413e-22,  4.945171962993911e-11, -2.163728716030553e-11,  5.079749986705532e-12,
 -8.103727870815191e-13,  9.774004100678859e-14, -9.470730593558090e-15,  7.667023482590890e-16, -5.329322899991164e-17,  3.245402250988000e-18, -1.758451811309759e-19,
  8.581647503814356e-21, -3.803962361040511e-22,  9.269252484344223e-02, -3.629801404140290e-04,  1.497328022389361e-06, -6.425813094500830e-09,  2.830743111183959e-11,
 -1.266549399863552e-13,  5.708659163914900e-16, -2.579864107118239e-18,  1.164714297679561e-20, -5.246992512455163e-23,  2.354518855013853e-25, -1.053040630849351e-27,
  8.445592846527612e-02, -4.554930041024681e-04,  2.973943398818897e-06, -1.969851224684757e-08,  1.268707671332194e-10, -7.924473991196160e-13,  4.820555709351165e-15,
 -2.868124932898978e-17,  1.674472372465117e-19, -9.616322286936899e-22,  5.442408018019674e-24, -3.039936510880106e-26,  7.013429503957991e-02, -5.859714478132714e-04,
  5.598041501213174e-06, -4.938459581404296e-08,  4.071545176563170e-10, -3.191247381502776e-12,  2.403019945091358e-14, -1.750275256234743e-16,  1.239105575239799e-18,
 -8.557515123237124e-21,  5.781814939879039e-23, -3.830309232519751e-25,  5.311394145587013e-02, -6.806617840555643e-04,  8.662513354809655e-06, -9.649015733808514e-08,
  9.836735408220538e-10, -9.389634034209227e-12,  8.504665617301349e-14, -7.375228240246025e-16,  6.163427380271136e-18, -4.987926967674590e-20,  3.923902692630751e-22,
 -3.009584228403501e-24,  3.671715847361643e-02, -6.900600427836717e-04,  1.120154431687391e-05, -1.540901898712697e-07,  1.903703493001806e-09, -2.170133727174946e-11,
  2.320614938093520e-13, -2.353989411407724e-15,  2.283355737890779e-17, -2.130668528990277e-19,  1.921528305232541e-21, -1.680876695196856e-23,  2.319908980515564e-02,
 -6.105328721612525e-04,  1.236829523043891e-05, -2.068762433446500e-07,  3.050878943311445e-09, -4.095141122903649e-11,  5.102266101896834e-13, -5.979101103172632e-15,
  6.652324435765602e-17, -7.076567934538731e-19,  7.236600791470970e-21, -7.143876770322571e-23,  1.341975401199716e-02, -4.752517692395600e-04,  1.184246657130028e-05,
 -2.377870785600506e-07,  4.136891250510209e-09, -6.468446600248666e-11,  9.296544024944206e-13, -1.246704226432955e-14,  1.576766439719618e-16, -1.895781262092914e-18,
  2.180157560981426e-20, -2.409494862219892e-22,  7.122196138400191e-03, -3.284581478900843e-04,  9.946928428535172e-06, -2.371732569417156e-07,  4.821406153330186e-09,
 -8.706168260759378e-11,  1.431848503848059e-12, -2.180913409760419e-14,  3.113188918257000e-16, -4.201760129418820e-18,  5.398423979298661e-20, -6.637271191712837e-22,
  3.477157489628699e-03, -2.032681719313810e-04,  7.399287923567492e-06, -2.075465906546300e-07,  4.890395465578842e-09, -1.012471090231552e-10,  1.892813552439563e-12,
 -3.254175401005133e-14,  5.212049232096142e-16, -7.852247423410047e-18,  1.121032326447042e-19, -1.525312001332528e-21,  1.566663792077022e-03, -1.135262836563291e-04,
  4.916391023582916e-06, -1.608801856834137e-07,  4.363082826897902e-09, -1.029197999113772e-10,  2.174669948952545e-12, -4.197617608922141e-14,  7.505625241927927e-16,
 -1.256182599388306e-17,  1.983682206119046e-19, -2.973771734087655e-21,  6.539769697366788e-04, -5.765027579863549e-05,  2.941479772560657e-06, -1.114475515168442e-07,
  3.456828610682886e-09, -9.239104948567004e-11,  2.195304964864535e-12, -4.735249919272632e-14,  9.410828037497213e-16, -1.742429162890409e-17,  3.031299482913104e-19,
 -4.987482560952911e-21,  2.541081701114275e-04, -2.681652875858844e-05,  1.597429949579481e-06, -6.958878894549746e-08,  2.454355446786737e-09, -7.394774049504119e-11,
  1.966811449582433e-12, -4.720693502802680e-14,  1.038639063740894e-15, -2.119421888148631e-17,  4.047462116858007e-19, -7.283622301477214e-21,  9.242102991304452e-05,
 -1.151406074231150e-05,  7.939217485494838e-07, -3.950502700466065e-08,  1.575682737407461e-09, -5.326254699242398e-11,  1.578955146650300e-12, -4.200438251185927e-14,
  1.019358069902075e-15, -2.284505058138843e-17,  4.773164316954376e-19, -9.364722702411687e-21,  3.167341626692026e-05, -4.600832284636672e-06,  3.642447882439097e-07,
 -2.057299459268237e-08,  9.231203489241129e-10, -3.484931658904928e-11,  1.146753763513275e-12, -3.368532924886947e-14,  8.985054033532455e-16, -2.204240428451830e-17,
  5.022858215701834e-19, -1.071137139764058e-20,  1.030806187099763e-05, -1.726305822295072e-06,  1.557118419667776e-07, -9.922240745504397e-09,  4.983025426034169e-10,
 -2.091550235719341e-11,  7.608936833631300e-13, -2.458869981164895e-14,  7.184018193606525e-16, -1.922950402426878e-17,  4.764258819691125e-19, -1.101045318213851e-20,
  3.214947660701247e-06, -6.143168876955903e-07,  6.266084864120423e-08, -4.477765544466212e-09,  2.504112298268075e-10, -1.163376600331203e-11,  4.660125896533430e-13,
 -1.650568166550755e-14,  5.263919259906606e-16, -1.532321278401477e-17,  4.114895863859054e-19, -1.027505173889459e-20,  9.711079555096299e-07, -2.096470908717907e-07,
  2.400533149248877e-08, -1.912217712741690e-09,  1.184652898590616e-10, -6.063927541913256e-12,  2.663438330159463e-13, -1.029988254267961e-14,  3.572650727038013e-16,
 -1.127188961781390e-17,  3.270271177318411e-19, -8.795805688519057e-21,  2.875435825297246e-07, -6.947084507656719e-08,  8.864619029647407e-09, -7.823316906749281e-10,
  5.340480209609377e-11, -2.997467562013126e-12,  1.437306219764746e-13, -6.044030418509398e-15,  2.271494064684005e-16, -7.739567934391385e-18,  2.417623617345519e-19,
 -6.980916022038116e-21,  8.460587211263034e-08, -2.266326114015305e-08,  3.198866704442923e-09, -3.107897805817972e-10,  2.324571994504982e-11, -1.423341642857469e-12,
  7.415947035546778e-14, -3.376191185909904e-15,  1.369135200192259e-16, -5.018230316069978e-18,  1.681454740117220e-19, -5.193752369002728e-21,  2.511331671770218e-08,
 -7.389271812644694e-09,  1.144906286448129e-09, -1.216388870820916e-10,  9.908724430926131e-12, -6.582292126413585e-13,  3.707413408079097e-14, -1.818560694216052e-15,
  7.921547585037490e-17, -3.109846321017907e-18,  1.113125859610617e-19, -3.663444294865495e-21,  7.642902753307893e-09, -2.447053709406226e-09,  4.128907813856167e-10,
 -4.762861064446081e-11,  4.198067371508138e-12, -3.007315933420512e-13,  1.820775165179168e-14, -9.571887584857418e-16,  4.456051263427920e-17, -1.864719627246410e-18,
  7.097223797539682e-20, -2.477754993171135e-21,  2.425145064098493e-09, -8.368524112822779e-10,  1.524751357766736e-10, -1.895057334857800e-11,  1.794522964193746e-12,
 -1.377080787826634e-13,  8.906334021077671e-15, -4.988238683287303e-16,  2.467840119227814e-17, -1.094890687949275e-18,  4.408267158595248e-20, -1.624428359857951e-21,
  8.153717353351188e-10, -3.002891211955083e-10,  5.855372237192374e-11, -7.775958882883694e-12,  7.849465255477809e-13, -6.405297599505249e-14,  4.394574435153581e-15,
 -2.604921669586850e-16,  1.360926423197311e-17, -6.362803292677246e-19,  2.694281661101242e-20, -1.042101748709265e-21,  2.944266652400105e-10, -1.145736073978015e-10,
  2.368206092315051e-11, -3.330279336427954e-12,  3.553207674247536e-13, -3.058367308671827e-14,  2.208784929010301e-15, -1.375498726642841e-16,  7.535408291484406e-18,
 -3.687588436371340e-19,  1.631590139679273e-20, -6.582608748320108e-22,  1.149777230004308e-10, -4.679568262391802e-11,  1.014983373720990e-11, -1.496784382483057e-12,
  1.672318855794024e-13, -1.504886651126643e-14,  1.134402676011058e-15, -7.361592087452794e-17,  4.196024743162226e-18, -2.133254850943125e-19,  9.791695027896828e-21,
 -4.092214835876162e-22,  4.814704707724695e-11, -2.028300066511275e-11,  4.567280723763327e-12, -6.990036325016425e-13,  8.096747956737032e-14, -7.544590970693617e-15,
  5.881545663474983e-16, -3.942268996300591e-17,  2.318120642950655e-18, -1.214385110749265e-19,  5.737195872841219e-21, -2.465070477861990e-22,  2.054418049191213e-11,
 -8.864428651329896e-12,  2.049233650688277e-12, -3.219280960142848e-13,  3.825050905392219e-14, -3.652969542251469e-15,  2.916123072628999e-16, -1.999799558547881e-17,
  1.202078471250584e-18, -6.432097220332504e-20,  3.101353748870872e-21, -1.358884936410042e-22,  7.036061606588431e-12, -3.076691089165683e-12,  7.218132762163325e-13,
 -1.150713260195578e-13,  1.386945280630474e-14, -1.343017380082337e-15,  1.086535028485452e-16, -7.547712559131441e-18,  4.593521425160217e-19, -2.487418853876717e-20,
  1.213214192911582e-21, -5.374758778708041e-23,  9.126408379053340e-02, -3.513024434402535e-04,  1.422854532388411e-06, -5.992438402275475e-09,  2.590569948526840e-11,
 -1.137805588100550e-13,  5.035761273814890e-16, -2.235647339163249e-18,  9.917160146449914e-21, -4.391598963689489e-23,  1.937078336113929e-25, -8.519994299515103e-28,
  8.268008963646974e-02, -4.326136416441310e-04,  2.749237471547124e-06, -1.778934809938038e-08,  1.121167022307707e-10, -6.858160205069129e-13,  4.087577801789491e-15,
 -2.383730363418863e-17,  1.364450439508010e-19, -7.684774268964913e-22,  4.266374524516562e-24, -2.338184852512360e-26,  6.787637488187848e-02, -5.434514854433140e-04,
  5.042504099016678e-06, -4.335097687833561e-08,  3.487218595246177e-10, -2.669120715479383e-12,  1.964123599469542e-14, -1.398898931705279e-16,  9.689024484475356e-19,
 -6.549408184353987e-21,  4.332789120965082e-23, -2.811474049852200e-25,  5.052292106215113e-02, -6.157392305951494e-04,  7.593207941763932e-06, -8.214946177396574e-08,
  8.147278719740920e-10, -7.575591961581210e-12,  6.690747148632465e-14, -5.662354889277787e-16,  4.621070723903909e-18, -3.654180774591056e-20,  2.810323748594918e-22,
 -2.108177284827991e-24,  3.412512203751491e-02, -6.073573355461036e-04,  9.521817074750694e-06, -1.268215501073550e-07,  1.520431118237962e-09, -1.684682652982241e-11,
  1.753240458907270e-13, -1.732542056381112e-15,  1.638530189803936e-17, -1.491784145685110e-19,  1.313451208336134e-21, -1.122324222964608e-23,  2.094022303691965e-02,
 -5.207449204408816e-04,  1.015364622384910e-05, -1.640019468464464e-07,  2.341894613298856e-09, -3.049608687847420e-11,  3.691496892701984e-13, -4.207716771815590e-15,
  4.558029239174286e-17, -4.724758444136853e-19,  4.711492361943593e-21, -4.538414516428464e-23,  1.169162277008893e-02, -3.908915765927015e-04,  9.347097051451137e-06,
 -1.808432445456473e-07,  3.040743165495324e-09, -4.604904778477227e-11,  6.420461025263736e-13, -8.363803046333592e-15,  1.028679779463989e-16, -1.203874829856243e-18,
  1.348704912495856e-20, -1.453143028554185e-22,  5.951180297480062e-03, -2.590767717886745e-04,  7.511769578345300e-06, -1.722825211640624e-07,  3.379627889530388e-09,
 -5.902562697346231e-11,  9.405939995852657e-13, -1.390150139728482e-14,  1.927841988512671e-16, -2.530403449890389e-18,  3.164544862345675e-20, -3.790280057912307e-22,
  2.768393356508151e-03, -1.528451881158780e-04,  5.318607369163425e-06, -1.433105268946325e-07,  3.254658773986417e-09, -6.510215774037626e-11,  1.178132781270522e-12,
 -1.963685041566350e-14,  3.053149881486785e-16, -4.470211286025797e-18,  6.208295103017534e-20, -8.224605077365209e-22,  1.180484197310612e-03, -8.087046286724557e-05,
  3.344958462838409e-06, -1.050579033819103e-07,  2.743839740938479e-09, -6.248652030499924e-11,  1.277199558643010e-12, -2.388635897002159e-14,  4.143916245448598e-16,
 -6.737031368138347e-18,  1.034504015758824e-19, -1.509453473581830e-21,  4.631327673621555e-04, -3.865151138444973e-05,  1.883160536649704e-06, -6.845443485034017e-08,
  2.043886449603231e-09, -5.271667859635960e-11,  1.211227560397988e-12, -2.530528452751775e-14,  4.878100923818716e-16, -8.771401059745295e-18,  1.483566340329813e-19,
 -2.375484581669922e-21,  1.679250303017121e-04, -1.680748916935422e-05,  9.564019177701759e-07, -3.997590172685802e-08,  1.357150396416532e-09, -3.945715375781699e-11,
  1.014727748208515e-12, -2.358914920303793e-14,  5.034081795252060e-16, -9.976361948633629e-18,  1.852355778407064e-19, -3.244288398772529e-21,  5.657819195884372e-05,
 -6.699670717188134e-06,  4.416913155687877e-07, -2.109930006651528e-08,  8.103627131781937e-10, -2.644082369211844e-11,  7.581029150315424e-13, -1.953840626023975e-14,
  4.600335287876852e-16, -1.001563935559896e-17,  2.035221986245484e-19, -3.887514566867388e-21,  1.782964192852719e-05, -2.467928253616377e-06,  1.870781834940491e-07,
 -1.015401384359723e-08,  4.390764891964744e-10, -1.601095802679220e-11,  5.098834754639035e-13, -1.451896752585427e-14,  3.759539634262915e-16, -8.964889010826088e-18,
  1.987943327454094e-19, -4.129724846501983e-21,  5.296471167267335e-06, -8.476829327444311e-07,  7.334910208392240e-08, -4.498087878265456e-09,  2.179638150745838e-10,
 -8.846483394739616e-12,  3.117705362708798e-13, -9.775670865661822e-15,  2.775150264007107e-16, -7.226651289320707e-18,  1.743822064465273e-19, -3.929180772337145e-21,
  1.496951897699275e-06, -2.742469854518842e-07,  2.689809853798550e-08, -1.853361407640727e-09,  1.001709081434259e-10, -4.506737819844529e-12,  1.751223725589883e-13,
 -6.026085183836644e-15,  1.869610418949608e-16, -5.300957536279104e-18,  1.388030561343626e-19, -3.382996648731115e-21,  4.069593181775411e-07, -8.453578097694613e-08,
  9.333324736821324e-09, -7.185459977668745e-10,  4.311162111676402e-11, -2.141050239298992e-12,  9.138477378321095e-14, -3.439007199782521e-15,  1.162274616835651e-16,
 -3.577069557409303e-18,  1.013392685420131e-19, -2.664140620560586e-21,  1.077830261468175e-07, -2.515355173189280e-08,  3.104579227854165e-09, -2.655296818742002e-10,
  1.759782139000990e-11, -9.604737106690462e-13,  4.484919431525117e-14, -1.838929475660050e-15,  6.746654437138197e-17, -2.246425786185558e-18,  6.864106123574356e-20,
 -1.940561131271214e-21,  2.822125600056073e-08, -7.332238696775454e-09,  1.004554780914000e-09, -9.487987672976604e-11,  6.909354912477310e-12, -4.124727526614758e-13,
  2.097943140805906e-14, -9.334576830399181e-16,  3.703483315956819e-17, -1.329319013080876e-18,  4.365797839748420e-20, -1.322902589906905e-21,  7.427314610127558e-09,
 -2.128778188567737e-09,  3.213665823157245e-10, -3.330575076787878e-11,  2.649851759446226e-12, -1.721272613451980e-13,  9.490413215007835e-15, -4.561615442895696e-16,
  1.948850253967848e-17, -7.510262053366612e-19,  2.640895249077548e-20, -8.545116677265746e-22,  2.001062657136263e-09, -6.268177376710369e-10,  1.034566465563786e-10,
 -1.168410378442234e-11,  1.009281430443885e-12, -7.092464189551521e-14,  4.216230458796247e-15, -2.178126006387196e-16,  9.972278704279649e-18, -4.107088767511751e-19,
  1.539505357223454e-20, -5.296767479245468e-22,  5.627407755346980e-10, -1.908044438217793e-10,  3.414477495242782e-11, -4.170586115119241e-12,  3.884215736716977e-13,
 -2.933762073631640e-14,  1.868928316587691e-15, -1.031733718188475e-16,  5.034355405682764e-18, -2.204275579599674e-19,  8.763479010746189e-21, -3.190532675372945e-22,
  1.684365608262630e-10, -6.120420168670432e-11,  1.176843922524110e-11, -1.541743678498060e-12,  1.536145874516183e-13, -1.237984579768836e-14,  8.393029596733025e-16,
 -4.918734881003159e-17,  2.541956925122050e-18, -1.176148369725415e-19,  4.930942090475796e-21, -1.889127708599246e-22,  5.460150735955497e-11, -2.104350716357293e-11,
  4.305457881182753e-12, -5.994431000725199e-13,  6.334598667197977e-14, -5.402504085464498e-15,  3.867581815254958e-16, -2.388327630327413e-17,  1.297917277466315e-18,
 -6.302888872393239e-20,  2.768264089268047e-21, -1.109009936969360e-22,  1.938597169074427e-11, -7.840046611941819e-12,  1.688925888290909e-12, -2.474014880866661e-13,
  2.746346293752501e-14, -2.456100454211198e-15,  1.840471488315188e-16, -1.187580875163811e-17,  6.732316091477782e-19, -3.404901479329238e-20,  1.555071230512041e-21,
 -6.468104399955473e-23,  7.507333784592104e-12, -3.150995635135808e-12,  7.066992396862328e-13, -1.077308262318615e-13,  1.243110249914025e-14, -1.154080950155072e-15,
  8.965156207845535e-17, -5.988822016058952e-18,  3.510109039202056e-19, -1.833109617262266e-20,  8.634444115625571e-22, -3.699326486246382e-23,  3.025444075867279e-12,
 -1.303131630029651e-12,  3.006702911095831e-13, -4.714387123934422e-14,  5.591055327461741e-15, -5.329916520625797e-16,  4.247433634817413e-17, -2.907916516518380e-18,
  1.745140834040067e-19, -9.323498045504776e-21,  4.488812978722253e-22, -1.964005551515941e-23,  1.002631595965473e-12, -4.381379920265456e-13,  1.027150486744971e-13,
 -1.636277815019733e-14,  1.970767446600791e-15, -1.907002787906565e-16,  1.541754585684879e-17, -1.070278987369896e-18,  6.509471495003127e-20, -3.522696625489509e-21,
  1.717109114320425e-22, -7.602592429371743e-24,  8.988119398899276e-02, -3.402003666574566e-04,  1.353359194008091e-06, -5.595516093039896e-09,  2.374605545338755e-11,
 -1.024114579235184e-13,  4.451934682458345e-16, -1.942168694161987e-18,  8.467077702545183e-21, -3.686764901830916e-23,  1.598749288816306e-25, -6.918066071454986e-28,
  8.099231259971131e-02, -4.114441437396072e-04,  2.546092525744411e-06, -1.610009959626995e-08,  9.932978303179568e-11, -5.952545350087867e-13,  3.477325350613741e-15,
 -1.988267903284113e-17,  1.116191102695454e-19, -6.167282700962164e-22,  3.359708275773153e-24, -1.807179436245349e-26,  6.578008309356624e-02, -5.051013442235844e-04,
  4.554087526960912e-06, -3.817414566475353e-08,  2.997532956380009e-10, -2.241436977475499e-12,  1.612519360274915e-14, -1.123457452542938e-16,  7.615545851138273e-19,
 -5.040329523328643e-21,  3.266041678942437e-23, -2.076485724656577e-25,  4.817551046455814e-02, -5.587261088981126e-04,  6.680896964929225e-06, -7.024376796622805e-08,
  6.780710729759385e-10, -6.144500200953577e-12,  5.293983114126564e-14, -4.374089025753792e-16,  3.487400217045324e-18, -2.695636803465641e-20,  2.027458941299528e-22,
 -1.488043779469539e-24,  3.183895519134784e-02, -5.368808756880303e-04,  8.135498891408402e-06, -1.049770099137862e-07,  1.221929351621739e-09, -1.316655659532604e-11,
  1.334131921548780e-13, -1.284891736818948e-15,  1.185259512063524e-17, -1.053271363753573e-19,  9.056988584794891e-22, -7.562322984331102e-24,  1.900807943078912e-02,
 -4.467942628722951e-04,  8.391773887755109e-06, -1.309669171639183e-07,  1.811815253805035e-09, -2.289997536490304e-11,  2.694348910160192e-13, -2.988495790232770e-15,
  3.153183247496716e-17, -3.186166395101324e-19,  3.099341832267666e-21, -2.914131276101087e-23,  1.026494769334581e-02, -3.240331187196508e-04,  7.441006592828477e-06,
 -1.387953832613930e-07,  2.256649255680947e-09, -3.311481936077745e-11,  4.481048061500667e-13, -5.672675391124596e-15,  6.787361380404857e-17, -7.734583170353700e-19,
  8.444119945535634e-21, -8.872318356011541e-23,  5.023156835142498e-03, -2.064152772348462e-04,  5.733506151907173e-06, -1.265468393727576e-07,  2.396604267000612e-09,
 -4.050134932886640e-11,  6.255942318972700e-13, -8.974885391637083e-15,  1.209565840643344e-16, -1.544469405258845e-18,  1.880689127125833e-20, -2.195013077720686e-22,
  2.232349576361117e-03, -1.163797949886459e-04,  3.872870477586328e-06, -1.002848758073841e-07,  2.195963037761911e-09, -4.245409828120452e-11,  7.439359017810427e-13,
 -1.202517359247257e-14,  1.815520539395398e-16, -2.583996828571848e-18,  3.491926510814568e-20, -4.505170395105945e-22,  9.034780653569131e-04, -5.849243784629300e-05,
  2.311263847691117e-06, -6.969189515017454e-08,  1.753350648887856e-09, -3.855957199259920e-11,  7.625885899776247e-13, -1.382178161852556e-14,  2.326997676285765e-16,
 -3.675634714327288e-18,  5.489348424527090e-20, -7.797124288221566e-22,  3.341455689567488e-04, -2.638704967482097e-05,  1.227654375662192e-06, -4.282002210359143e-08,
  1.230867486377692e-09, -3.064124643032699e-11,  6.808638443616325e-13, -1.377981138573751e-14,  2.576874493406625e-16, -4.500424435116523e-18,  7.401198797613122e-20,
 -1.153403443413250e-21,  1.134110217989540e-04, -1.075834557698046e-05,  5.846789038637250e-07, -2.344705165969121e-08,  7.662074024463984e-10, -2.149620347958780e-11,
  5.345433091708191e-13, -1.203586899280955e-14,  2.491412757672033e-16, -4.795189916432756e-18,  8.656677534043985e-20, -1.475638057860680e-21,  3.550830878824828e-05,
 -3.993070555132583e-06,  2.516013192639263e-07, -1.153531416355557e-08,  4.265419297916233e-10, -1.343207237121155e-11,  3.724384386250449e-13, -9.298433008193056e-15,
  2.123924225115661e-16, -4.491730739119271e-18,  8.876203882496036e-20, -1.650516106653754e-21,  1.032070338382986e-05, -1.359882251241247e-06,  9.864171987498893e-08,
 -5.142760334232493e-09,  2.142354737319911e-10, -7.543704491410684e-12,  2.324373561256282e-13, -6.414525578894680e-15,  1.612087356260542e-16, -3.735778505681239e-18,
  8.059729171782731e-20, -1.630703896701431e-21,  2.806280238438184e-06, -4.287156363865611e-07,  3.555811307119465e-08, -2.097230467778563e-09,  9.800562276947239e-11,
 -3.844616247802123e-12,  1.312051159096733e-13, -3.990257788347531e-15,  1.100266842509619e-16, -2.786476003290255e-18,  6.546674979258634e-20, -1.437730263521822e-21,
  7.204846068991862e-07, -1.263859143101057e-07,  1.190770320118921e-08, -7.904828963724696e-10,  4.126339843079001e-11, -1.796700060561305e-12,  6.768882604956198e-14,
 -2.261760703788705e-15,  6.823305697772661e-17, -1.883492560677990e-18,  4.806804924985186e-20, -1.143024766100494e-21,  1.766123675778495e-07, -3.524960871099784e-08,
  3.748305339394943e-09, -2.786286914221364e-10,  1.617658296251385e-11, -7.788626324845812e-13,  3.228240389671596e-14, -1.181451842308039e-15,  3.888191868965318e-17,
 -1.166625820369041e-18,  3.225595751373768e-20, -8.284213458380950e-22,  4.188515510528417e-08, -9.427616058213373e-09,  1.124108941705143e-09, -9.307364278548756e-11,
  5.982851576447567e-12, -3.172522757101713e-13,  1.441437616606961e-14, -5.758524447699733e-16,  2.060937882248330e-17, -6.701557167529656e-19,  2.001753980077935e-20,
 -5.537441127882077e-22,  9.760704929845678e-09, -2.455902824640539e-09,  3.261648655132641e-10, -2.991284888987894e-11,  2.118590824412688e-12, -1.231894623487992e-13,
  6.111125606933665e-15, -2.655196847029487e-16,  1.029828538836752e-17, -3.617205165215386e-19,  1.163586301302587e-20, -3.456501212648462e-22,  2.275466340367805e-09,
 -6.343297724104928e-10,  9.317619760693774e-11, -9.408342892642000e-12,  7.302825271409409e-13, -4.633858919287085e-14,  2.498652388464910e-15, -1.175786398367271e-16,
  4.922671351901771e-18, -1.860716390371585e-19,  6.423025654287117e-21, -2.041815545633224e-22,  5.415291929543189e-10, -1.657234010789901e-10,  2.672159501168840e-11,
 -2.951113913249836e-12,  2.495514039504135e-13, -1.718524125457555e-14,  1.002114707079012e-15, -5.082807304341008e-17,  2.286685839295194e-18, -9.261367939410374e-20,
  3.416370764139677e-21, -1.157554851991711e-22,  1.345068678044554e-10, -4.475555144700283e-11,  7.856884665000385e-12, -9.420865610830837e-13,  8.620407632419141e-14,
 -6.402374973266839e-15,  4.013690036682943e-16, -2.182105104288335e-17,  1.049323603268677e-18, -4.530746107197788e-20,  1.777383188112535e-21, -6.388882035988470e-23,
  3.567812471573831e-11, -1.277765345897205e-11,  2.420279327990006e-12, -3.124874545097654e-13,  3.070386181797482e-14, -2.441683937070899e-15,  1.634448148715790e-16,
 -9.463131006290340e-18,  4.834092071047445e-19, -2.212055965623327e-20,  9.176133049466420e-22, -3.480105372207773e-23,  1.032718154774014e-11, -3.938665836807756e-12,
  7.970081463681119e-13, -1.097796408610956e-13,  1.148169656980987e-14, -9.695925057911072e-16,  6.875933237706535e-17, -4.207914605981532e-18,  2.267119602957975e-19,
 -1.091906533486762e-20,  4.758022604813756e-22, -1.891826408826117e-23,  3.314635843068588e-12, -1.331256971098514e-12,  2.846695186003610e-13, -4.139826119966878e-14,
  4.563506107552517e-15, -4.053950875389371e-16,  3.018393181266024e-17, -1.935733575514980e-18,  1.090933962102131e-19, -5.486560827199789e-21,  2.492366879539212e-22,
 -1.031357310008616e-23,  1.180708822454263e-12, -4.935825518468082e-13,  1.102187189691936e-13, -1.673001987976768e-14,  1.922487811185751e-15, -1.777698247490155e-16,
  1.375684412663747e-17, -9.156115096615987e-19,  5.347691491033332e-20, -2.783389916443177e-21,  1.306834951193087e-22, -5.581759885608596e-24,  4.474543937693662e-13,
 -1.923617735836178e-13,  4.429055992961421e-14, -6.930164831163093e-15,  8.202299527936773e-16, -7.803987194012155e-17,  6.207387492399164e-18, -4.242107743324776e-19,
  2.541429989363933e-20, -1.355512881880247e-21,  6.515702829615186e-23, -2.846465511848030e-24,  1.431067125203950e-13, -6.249215098290276e-14,  1.463894246838439e-14,
 -2.330196462672789e-15,  2.804379996198866e-16, -2.711609300437047e-17,  2.190656801315997e-18, -1.519667289056844e-19,  9.236313108096645e-21, -4.995032302046756e-22,
  2.433209724387331e-23, -1.076640932487032e-24,  8.854162992813851e-02, -3.296357709341222e-04,  1.288426861923015e-06, -5.231402460666399e-09,  2.180042107344437e-11,
 -9.234995008177350e-14,  3.944149345301849e-16, -1.691280856530331e-18,  7.247982363599814e-21, -3.104166266080213e-23,  1.323565755034629e-25, -5.637107308359920e-28,
  7.938608688334034e-02, -3.918220668514096e-04,  2.362048309726038e-06, -1.460171163663462e-08,  8.821615864008791e-11, -5.180953166548336e-13,  2.967454258942498e-15,
 -1.664164382734623e-17,  9.165594896849752e-20, -4.969743604536577e-22,  2.657363952852811e-24, -1.403334485216195e-26,  6.382975266130339e-02, -4.704227455908461e-04,
  4.123360052191990e-06, -3.371671764833756e-08,  2.585533543235964e-10, -1.889585790119384e-12,  1.329511018870218e-14, -9.064392181807506e-17,  6.015728963287791e-19,
 -3.899698672880306e-21,  2.475913386446585e-23, -1.542848794560816e-25,  4.604241046057123e-02, -5.084751096337966e-04,  5.899223964330464e-06, -6.031266550548124e-08,
  5.669561465701354e-10, -5.009146935064389e-12,  4.211930871938056e-14, -3.398933426567641e-16,  2.648446312664054e-18, -2.001803865723906e-20,  1.472953630593332e-22,
 -1.058065260291471e-24,  2.981406560648858e-02, -4.765223568845824e-04,  6.984921940576355e-06, -8.737032216415624e-08,  9.879107462598737e-10, -1.035677345217420e-11,
  1.022224760269421e-13, -9.598874816867605e-16,  8.640017608098963e-18, -7.496862658197146e-20,  6.298167903494394e-22, -5.140455391928578e-24,  1.734586983388461e-02,
 -3.854863287193126e-04,  6.980056176623982e-06, -1.053170530066677e-07,  1.412249430936725e-09, -1.733345468110745e-11,  1.983160094286212e-13, -2.141373538833615e-15,
  2.201534493298019e-17, -2.169316369661962e-19,  2.059204233773513e-21, -1.890510294300600e-23,  9.078127541387131e-03, -2.706002252159213e-04,  5.971999732495536e-06,
 -1.074529339065865e-07,  1.690199555318063e-09, -2.404446556905720e-11,  3.159153257857429e-13, -3.887980182191476e-15,  4.527278883481483e-17, -5.025300859064956e-19,
  5.348192746760517e-21, -5.481746539194493e-23,  4.280459590837121e-03, -1.660262563348700e-04,  4.420713856965652e-06, -9.394379452074247e-08,  1.718424783846029e-09,
 -2.811188667642696e-11,  4.210624670182919e-13, -5.865693909703784e-15,  7.685295483793564e-17, -9.549535942296319e-19,  1.132578361179372e-20, -1.288465189756094e-22,
  1.821940144497027e-03, -8.967195480746520e-05,  2.855100508784459e-06, -7.107571234286474e-08,  1.501212935765135e-09, -2.806079871284738e-11,  4.763003068175321e-13,
 -7.468835551399372e-15,  1.095279570421344e-16, -1.515817665956319e-18,  1.993707148033750e-20, -2.505624329048337e-22,  7.017953738811428e-04, -4.292337336176420e-05,
  1.620728395196076e-06, -4.693127483260917e-08,  1.137712794203007e-09, -2.416874786228777e-11,  4.626081725397359e-13, -8.127884289364191e-15,  1.328253374024547e-16,
 -2.038870260580250e-18,  2.962030965656576e-20, -4.096466849376844e-22,  2.454033126026799e-04, -1.832777548976704e-05,  8.143082375817829e-07, -2.725704945723971e-08,
  7.544448591197611e-10, -1.813022260675147e-11,  3.896793733114468e-13, -7.641138934308920e-15,  1.386384779999736e-16, -2.352047464181686e-18,  3.761491853468178e-20,
 -5.705880807880165e-22,  7.820675311083772e-05, -7.026619468034748e-06,  3.646625239359190e-07, -1.403028547319866e-08,  4.413333296482660e-10, -1.194874433324390e-11,
  2.873200948457751e-13, -6.266389091116595e-15,  1.258255836388889e-16, -2.352110203981795e-18,  4.128701629197708e-20, -6.849977211204992e-22,  2.282533661550521e-05,
 -2.435586472089646e-06,  1.466212398790230e-07, -6.450516918900277e-09,  2.296110973090996e-10, -6.977838847679249e-12,  1.870940261119001e-13, -4.524626738027217e-15,
  1.002572518182894e-16, -2.059448927375948e-18,  3.957485148498594e-20, -7.163357971679032e-22,  6.137896779320522e-06, -7.690916717582036e-07,  5.335348441791537e-08,
 -2.670863526143058e-09,  1.071546312207565e-10, -3.642624382095811e-12,  1.085702886378959e-13, -2.903218264872137e-15,  7.080280726510412e-17, -1.594227692687417e-18,
  3.345776768226806e-20, -6.591996347623044e-22,  1.532088135481289e-06, -2.231556771929684e-07,  1.772781382420809e-08, -1.005048161903058e-09,  4.527260378789203e-11,
 -1.715841031497326e-12,  5.668274955959925e-14, -1.671458353295168e-15,  4.475224851772738e-17, -1.101921605228208e-18,  2.519958930470945e-20, -5.392463553018419e-22,
  3.582426938282837e-07, -6.009265524083545e-08,  5.433622640100081e-09, -3.472563736882986e-10,  1.749580292808860e-11, -7.368647469909789e-13,  2.690098480457336e-14,
 -8.724250861054714e-16,  2.558091289018782e-17, -6.871770065417310e-19,  1.708578150423864e-20, -3.962439408761305e-22,  7.934891438884209e-08, -1.519474710482139e-08,
  1.554450403254993e-09, -1.114648074613318e-10,  6.257046332358203e-12, -2.918578375211113e-13,  1.173945915275645e-14, -4.175648651256661e-16,  1.337405440526422e-17,
 -3.910004401826691e-19,  1.054531967273095e-20, -2.644529270226277e-22,  1.687460989200755e-08, -3.657668596236680e-09,  4.207983688043217e-10, -3.369269429906054e-11,
  2.098653979629942e-12, -1.080274660151455e-13,  4.772042714828184e-15, -1.856118971068818e-16,  6.475759226458109e-18, -2.055067459952638e-19,  5.997019028607081e-21,
 -1.622303474498008e-22,  3.501646348581637e-09, -8.518997279266402e-10,  1.095276739661073e-10, -9.742130952950127e-12,  6.703622017745527e-13, -3.793015371823880e-14,
  1.833551617813118e-15, -7.772864588566715e-17,  2.944839163215468e-18, -1.011434602840202e-19,  3.184558221603505e-21, -9.267663494180371e-23,  7.226661446943447e-10,
 -1.956366971015549e-10,  2.792308786898347e-11, -2.743630333557398e-12,  2.075346945558424e-13, -1.285040705324631e-14,  6.770019879019928e-16, -3.116097963157332e-17,
  1.277405897777377e-18, -4.732210299119914e-20,  1.602351567533638e-21, -5.000708610687196e-23,  1.516366421030490e-10, -4.526923212918812e-11,  7.121264075980420e-12,
 -7.681255304936629e-13,  6.351420437804803e-14, -4.281742810861412e-15,  2.446758347269616e-16, -1.217322290334382e-17,  5.376801325026429e-19, -2.139766532358836e-20,
  7.761797393939112e-22, -2.588009905491959e-23,  3.315984967893519e-11, -1.081324373096554e-11,  1.859863933171603e-12, -2.186670843069878e-13,  1.963728749548367e-14,
 -1.432678311142022e-15,  8.830321411089765e-17, -4.723676654991310e-18,  2.236704421778122e-19, -9.516214091624482e-21,  3.680877044394730e-22, -1.305401389145274e-23,
  7.759987847831890e-12, -2.736038493930508e-12,  5.099604762372596e-13, -6.482312385614687e-14,  6.274973343617232e-15, -4.919600274429871e-16,  3.248788713233888e-17,
 -1.856810779897833e-18,  9.368845809624400e-20, -4.236873833515635e-21,  1.737849894215004e-22, -6.520321005596802e-24,  1.994724279139357e-12, -7.521767950166678e-13,
  1.504050834207184e-13, -2.047802182290404e-14,  2.118081264262007e-15, -1.769744401761814e-16,  1.242359779372515e-17, -7.529694513808531e-19,  4.019472943216990e-20,
 -1.918859180494456e-21,  8.291163201210946e-23, -3.270154270437153e-24,  5.753417115122898e-13, -2.293391101404635e-13,  4.864838813342412e-14, -7.019310838573117e-15,
  7.679342640730800e-16, -6.772615374699945e-17,  5.007776483932636e-18, -3.190360005524504e-19,  1.786673006747191e-20, -8.931413993182390e-22,  4.033850379846834e-23,
 -1.660041166204673e-24,  1.874365950180986e-13, -7.801277878821470e-14,  1.733809157332202e-14, -2.619478812262615e-15,  2.996568296817534e-16, -2.758921544349231e-17,
  2.126180797555482e-18, -1.409515852324956e-19,  8.201183995330255e-21, -4.253107868173156e-22,  1.989950771808574e-23, -8.471288206962862e-25,  6.648512800712085e-14,
 -2.852275083723582e-14,  6.552314553469173e-15, -1.022933906464673e-15,  1.208062240009911e-16, -1.146976095215605e-17,  9.104712546781328e-19, -6.210027288391724e-20,
  3.713454393757010e-21, -1.977078962779134e-22,  9.487086757515715e-24, -4.137710559384860e-25,  2.046129380436560e-14, -8.928391089628060e-15,  2.089754513772196e-15,
 -3.323648474119750e-16,  3.996716113341547e-17, -3.861416858751891e-18,  3.117144830232686e-19, -2.160748562659782e-20,  1.312312583242438e-21, -7.092011668054295e-23,
  3.452330884933443e-24, -1.526564676923610e-25,  8.724331227801212e-02, -3.195736707508254e-04,  1.227683544973039e-06, -4.896873040773126e-09,  2.004437702897117e-11,
 -8.342705052015974e-14,  3.501451826622820e-16, -1.476250199692815e-18,  6.220095019384162e-21, -2.621157520530886e-23,  1.098956874570555e-25, -4.609426218172171e-28,
  7.785551452628547e-02, -3.736033308646658e-04,  2.194966693957345e-06, -1.326943145912392e-08,  7.853034337445702e-11, -4.521524055584243e-13,  2.540000030146889e-15,
 -1.397554443274387e-17,  7.553829409868588e-20, -4.020605766706102e-22,  2.110777707824125e-24, -1.094691672790010e-26,  6.201156860383632e-02, -4.389867047731011e-04,
  3.742387327237487e-06, -2.986568627279273e-08,  2.237576001502153e-10, -1.598907416223581e-12,  1.100676944977767e-14, -7.346119566991976e-17,  4.774884818371860e-19,
 -3.032742171573122e-21,  1.887217374078302e-23, -1.152993347364543e-25,  4.409852194642597e-02, -4.640293862535041e-04,  5.226763198942821e-06, -5.199097872437003e-08,
  4.761577734794148e-10, -4.103538276522037e-12,  3.368807046181433e-14, -2.656214743611294e-16,  2.023520537988687e-18, -1.496109624705572e-20,  1.077349760326734e-22,
 -7.576755504435647e-25,  2.801345442646176e-02, -4.245829645589125e-04,  6.024890141599367e-06, -7.309614222417025e-08,  8.032831286001365e-10, -8.197044189566064e-12,
  7.884288690686394e-14, -7.221367878964610e-16,  6.344958249736040e-18, -5.377635283544504e-20,  4.415396627927880e-22, -3.523864663873064e-24,  1.590811088893324e-02,
 -3.343417284211144e-04,  5.841172648024249e-06, -8.525485156570646e-08,  1.108702293317972e-09, -1.322044994560958e-11,  1.471509603325935e-13, -1.547433129181407e-15,
  1.550777696679153e-17, -1.490679609103334e-19,  1.381299115453397e-21, -1.238658597645632e-23,  8.083716225590717e-03, -2.275562775587934e-04,  4.830194278316966e-06,
 -8.387917069037615e-08,  1.277092128689842e-09, -1.762050158902112e-11,  2.248835329164676e-13, -2.691715760300360e-15,  3.051442436656318e-17, -3.300442776627523e-19,
  3.425230146563714e-21, -3.425849869446124e-23,  3.680553975883545e-03, -1.347418571566287e-04,  3.441440452223575e-06, -7.044905420880919e-08,  1.245250639282542e-09,
 -1.972825399901483e-11,  2.866495061771349e-13, -3.879018027021459e-15,  4.942586650711327e-17, -5.978461626237446e-19,  6.908074183550220e-21, -7.662514876550866e-23,
  1.504057095849625e-03, -6.987339836560488e-05,  2.129621733744301e-06, -5.098951108023693e-08,  1.039221055944451e-09, -1.878847677696980e-11,  3.090217607398618e-13,
 -4.702391668580156e-15,  6.700162132094685e-17, -9.019075823561055e-19,  1.154870913961726e-20, -1.414180331871187e-22,  5.528597124680748e-04, -3.193395864341528e-05,
  1.152583842054555e-06, -3.206115979043019e-08,  7.491513871428460e-10, -1.537726540744060e-11,  2.849453441348332e-13, -4.854344254186849e-15,  7.702151291083163e-17,
 -1.149190871507698e-18,  1.624411119010628e-20, -2.187799248891975e-22,  1.833067387107042e-04, -1.294102324961039e-05,  5.491513620974820e-07, -1.764325869486864e-08,
  4.703264605968733e-10, -1.091297886365301e-11,  2.269250131779337e-13, -4.312013861194252e-15,  7.591987156120899e-17, -1.251376986617872e-18,  1.946392354814876e-20,
 -2.874308793921373e-22,  5.501684165288541e-05, -4.678724326261527e-06,  2.318492896818647e-07, -8.558456866902621e-09,  2.591597547596501e-10, -6.771736147845371e-12,
  1.574724793074249e-13, -3.326977706351692e-15,  6.480660569257951e-17, -1.176705088777420e-18,  2.008450851982741e-20, -3.243448813052132e-22,  1.501464257588714e-05,
 -1.518998513438072e-06,  8.733890115564148e-08, -3.686556104731596e-09,  1.263133037827773e-10, -3.704264055399267e-12,  9.604025416738189e-14, -2.249735683578998e-15,
  4.835671637515427e-17, -9.648069348835404e-19,  1.802809397417333e-20, -3.176407633119661e-22,  3.747058920544551e-06, -4.460567875675115e-07,  2.957868709063540e-08,
 -1.421264625557676e-09,  5.490224717057883e-11, -1.801426522911476e-12,  5.192944422656569e-14, -1.345318205833760e-15,  3.183314324509657e-17, -6.963477127716926e-19,
  1.421414415216881e-20, -2.726759215446838e-22,  8.611938969072226e-07, -1.194578120543256e-07,  9.083007213508978e-09, -4.947168746737319e-10,  2.147162966377347e-11,
 -7.859399882679156e-13,  2.512466454227231e-14, -7.181452292402228e-16,  1.866530063797049e-17, -4.467210513138206e-19,  9.941403399869082e-21, -2.072394724685968e-22,
  1.839040720222165e-07, -2.946061800704729e-08,  2.554198249630493e-09, -1.570366342659956e-10,  7.631940579031979e-12, -3.107449281969909e-13,  1.098798225154523e-14,
 -3.457156839061506e-16,  9.848493152935458e-18, -2.573583785864357e-19,  6.231863553113765e-21, -1.409028025945260e-22,  3.689246682382186e-08, -6.768409438393455e-09,
  6.654299736169998e-10, -4.598811127707435e-11,  2.494095627077561e-12, -1.126276622479804e-13,  4.393619974288181e-15, -1.518005792081586e-16,  4.729174898874371e-18,
 -1.346504861262256e-19,  3.540651305886404e-21, -8.665948250471360e-23,  7.047421899378827e-09, -1.468792848623786e-09,  1.628390369507689e-10, -1.259528464658614e-11,
  7.595129211556844e-13, -3.791956909931578e-14,  1.627349353294949e-15, -6.158294746941743e-17,  2.093090001350597e-18, -6.478510418039116e-20,  1.845863623281819e-21,
 -4.880300495738503e-23,  1.303360768178815e-09, -3.061047883747798e-10,  3.804802757790477e-11, -3.278404273114789e-12,  2.189416108897290e-13, -1.204305714440744e-14,
  5.667913831980188e-16, -2.342432374034200e-17,  8.662139528712270e-19, -2.907055819638076e-20,  8.952630509585414e-22, -2.550753707268016e-23,  2.380760057214190e-10,
 -6.248789298655762e-11,  8.654135679111651e-12, -8.264125564747189e-13,  6.084947150544609e-14, -3.672865119620581e-15,  1.888725540037301e-16, -8.495659652640088e-18,
  3.407159901446679e-19, -1.236050147055562e-20,  4.102369662002691e-22, -1.256006787391230e-23,  4.397919850004021e-11, -1.278818158502882e-11,  1.959887716762499e-12,
 -2.062085464820595e-13,  1.665346007773154e-14, -1.097844703405431e-15,  6.141649251606981e-17, -2.994473471725993e-18,  1.297392338600553e-19, -5.069039929838775e-21,
  1.806695118253185e-22, -5.923657554093593e-24,  8.442587248832452e-12, -2.694280999122597e-12,  4.534356338500258e-13, -5.220959794358114e-14,  4.596418322828527e-15,
 -3.290673990719307e-16,  1.992103565093258e-17, -1.047581521474979e-18,  4.880167731114886e-20, -2.044233150448680e-21,  7.790348694475695e-23, -2.723827580508302e-24,
  1.735553755541048e-12, -6.017023262208491e-13,  1.102267490908470e-13, -1.377942592840315e-14,  1.312776427406122e-15, -1.013713624817725e-16,  6.598237426459780e-18,
 -3.719555171224665e-19,  1.852265854122099e-20, -8.272097261838653e-22,  3.352567694736882e-23, -1.243559863661642e-24,  3.940156052861547e-13, -1.467579073055931e-13,
  2.897063171387547e-14, -3.895446131579402e-15,  3.981193231335014e-16, -3.288664151477301e-17,  2.283626998515000e-18, -1.369756201338289e-19,  7.239859649177161e-21,
 -3.423686606701793e-22,  1.466018070245273e-23, -5.732522243110296e-25,  1.014989939924657e-13, -4.012766321318942e-14,  8.438068446431847e-15, -1.207159797434163e-15,
  1.309887730374848e-16, -1.146202602752221e-17,  8.411983457482771e-19, -5.320951679231439e-20,  2.959587825014861e-21, -1.469859197723873e-22,  6.597358672596891e-24,
 -2.698911879617734e-25,  3.005829479859078e-14, -1.245063753515632e-14,  2.752835562207730e-15, -4.137957651090563e-16,  4.710491210396413e-17, -4.316583297849045e-18,
  3.311677860929959e-19, -2.186003103981220e-20,  1.266696040025641e-21, -6.543278609393681e-23,  3.049991128621699e-24, -1.293740497458954e-25,  9.928645663100013e-15,
 -4.249827446393903e-15,  9.738618993749911e-16, -1.516648236068753e-16,  1.786875877257595e-17, -1.692644934144068e-18,  1.340675605681089e-19, -9.125060498670320e-21,
  5.445559855996195e-22, -2.893652978415314e-23,  1.385949469758205e-24, -6.033944212862913e-26,  2.930981302045864e-15, -1.277921800880872e-15,  2.988398877480111e-16,
 -4.748649931644121e-17,  5.705293446026326e-18, -5.507458924563375e-19,  4.442244244377876e-20, -3.076816505734104e-21,  1.867228182924164e-22, -1.008330193855964e-23,
  4.904887921247823e-25, -2.167333919784486e-26,  8.598429590288385e-02, -3.099819241373010e-04,  1.170791708388565e-06, -4.589068407197947e-09,  1.845663537555597e-11,
 -7.549793686275520e-14,  3.114607491896369e-16, -1.291494741498222e-18,  5.350951245321561e-21, -2.219573358944916e-23,  9.149820395384647e-26, -3.782496296266341e-28,
  7.639524146900223e-02, -3.566598361635827e-04,  2.042984385719711e-06, -1.208210648868363e-08,  7.006655569119558e-11, -3.956278553267559e-13,  2.180460934594451e-15,
 -1.177450747087389e-17,  6.247464019609670e-20, -3.265198170380895e-22,  1.683501871384222e-24, -8.576899530270443e-27,  6.031331302190684e-02, -4.104226374692209e-04,
  3.404469196463843e-06, -2.652770655940082e-08,  1.942629799259489e-10, -1.357797220417395e-12,  9.148341610207251e-15, -5.979209776988263e-17,  3.807588876885935e-19,
 -2.370245717020090e-21,  1.446100718144394e-23, -8.664689810533084e-26,  4.232225626412941e-02, -4.245872967401527e-04,  4.646009957861803e-06, -4.498749439710736e-08,
  4.016055223797231e-10, -3.377425817698165e-12,  2.708180954724164e-14, -2.087157478076789e-16,  1.555081422239278e-18, -1.125084746146160e-20,  7.931396689698849e-23,
 -5.462851956815338e-25,  2.640625833922923e-02, -3.796857893228194e-04,  5.219756760204247e-06, -6.145881184602586e-08,  6.567381359859644e-10, -6.526183547220806e-12,
  6.119721370973304e-14, -5.469462153494475e-16,  4.692810632483701e-18, -3.886418242353103e-20,  3.119760001634802e-22, -2.435433141465718e-24,  1.465812410264678e-02,
 -2.914219307594026e-04,  4.916407963486669e-06, -6.945278465955678e-08,  8.763700221329636e-10, -1.015729046362073e-11,  1.100338330438820e-13, -1.127365170910637e-15,
  1.101722958334776e-17, -1.033478431566599e-19,  9.351494981790634e-22, -8.193540436428955e-24,  7.244856752620610e-03, -1.926185520358290e-04,  3.935499924126424e-06,
 -6.599550060954801e-08,  9.730762213274680e-10, -1.302747449608013e-11,  1.615724830550252e-13, -1.881607173778258e-15,  2.077443269454545e-17, -2.190235170518527e-19,
  2.217303437816222e-21, -2.164747463177290e-23,  3.191736957347543e-03, -1.102809095279581e-04,  2.703692342087986e-06, -5.334172364368617e-08,  9.115295617119734e-10,
 -1.399142343088335e-11,  1.972894154109461e-13, -2.594381047201452e-15,  3.215947694357613e-17, -3.787911914944950e-19,  4.265628858501407e-21, -4.614597528683270e-23,
  1.255126702561601e-03, -5.502739914857081e-05,  1.606305130197207e-06, -3.700592914967782e-08,  7.280872435245006e-10, -1.273677112930524e-11,  2.030618820472375e-13,
 -2.999578999274171e-15,  4.153901758135104e-17, -5.440189835764104e-19,  6.783611126272019e-21, -8.095806533832618e-23,  4.413882128779717e-04, -2.406962444683401e-05,
  8.307078766093096e-07, -2.220518293846640e-08,  5.002754167562659e-10, -9.925295997804894e-12,  1.781056069284328e-13, -2.942871732890424e-15,  4.534639204939481e-17,
 -6.578071577337177e-19,  9.049056951901116e-21, -1.187125951892915e-22,  1.391491107231927e-04, -9.281610638630880e-06,  3.762382232837746e-07, -1.160479786497384e-08,
  2.980091510755060e-10, -6.677897443827581e-12,  1.343714829829576e-13, -2.474798761438772e-15,  4.229087982438178e-17, -6.773695431912674e-19,  1.024863508878257e-20,
 -1.473579519789833e-22,  3.944854438224652e-05, -3.173345129220860e-06,  1.501455758579467e-07, -5.317943086041801e-09,  1.550360168950729e-10, -3.910139738654732e-12,
  8.794443585819071e-14, -1.800096686000061e-15,  3.401950600776043e-17, -6.000356443329229e-19,  9.959676208441541e-21, -1.565646033767564e-22,  1.009788262522149e-05,
 -9.677964535873312e-07,  5.313541010058284e-08, -2.151627609599120e-09,  7.095894453465106e-11, -2.008071270278122e-12,  5.034341841139305e-14, -1.142294070076388e-15,
  2.381754280962097e-17, -4.615609212850306e-19,  8.386438672063792e-21, -1.438296130866047e-22,  2.346032645934892e-06, -2.650689021298768e-07,  1.679394914373941e-08,
 -7.743396800452505e-10,  2.879482355965575e-11, -9.117906325429395e-13,  2.541762838751597e-14, -6.378778090208478e-16,  1.464291577954400e-17, -3.111533045368226e-19,
  6.176904287230690e-21, -1.153603012218379e-22,  4.979942896577518e-07, -6.571125175756244e-08,  4.778963204777409e-09, -2.499475738514806e-10,  1.044849088124461e-11,
 -3.692525208683064e-13,  1.141959109210200e-14, -3.163150710754511e-16,  7.978903639095373e-18, -1.855719729617694e-19,  4.017886593096153e-21, -8.157571937373483e-23,
  9.740196511826652e-08, -1.488221753016697e-08,  1.236086922218253e-09, -7.306180561323923e-11,  3.423212567356800e-12, -1.346818422977615e-13,  4.610723031879272e-15,
 -1.406822386800043e-16,  3.892171437157006e-18, -9.890631981822835e-20,  2.331691776743724e-21, -5.138135479303289e-23,  1.774206357850003e-08, -3.114074930021508e-09,
  2.939139375999297e-10, -1.956025562238622e-11,  1.024142684500710e-12, -4.474468329977409e-14,  1.691861613710889e-15, -5.674868246387131e-17,  1.718781295154844e-18,
 -4.763691391072274e-20,  1.220712305402685e-21, -2.914741124191981e-23,  3.050475179519197e-09, -6.103577296537289e-10,  6.513026933793018e-11, -4.861558537291223e-12,
  2.835540121408563e-13, -1.371986498328391e-14,  5.716043057560202e-16, -2.103089481752541e-17,  6.959064758859177e-19, -2.099561060887416e-20,  5.837399161118681e-22,
 -1.507573923787047e-23,  5.034189702149151e-10, -1.139503325582321e-10,  1.367478584183534e-11, -1.140106904355785e-12,  7.381956859965491e-14, -3.943709802701762e-15,
  1.805484542728678e-16, -7.268490476477730e-18,  2.621516048476412e-19, -8.590601122497095e-21,  2.585909276794460e-22, -7.208550596874899e-24,  8.140417960563928e-11,
 -2.068108998893139e-11,  2.775218448151387e-12, -2.572369419466307e-13,  1.841590905319456e-14, -1.082456330252617e-15,  5.428079175438472e-17, -2.383915789214892e-18,
  9.345386231403321e-20, -3.317441087003785e-21,  1.078397150357620e-22, -3.236734589644811e-24,  1.322402861336665e-11, -3.739242245376982e-12,  5.575036502096460e-13,
 -5.714232227730914e-14,  4.501924045481157e-15, -2.898977655592214e-16,  1.586061084725974e-17, -7.571161567348274e-19,  3.214822227715878e-20, -1.232129479593652e-21,
  4.311527352108113e-23, -1.389016812668509e-24,  2.222735680049164e-12, -6.931471831217283e-13,  1.139839429006256e-13, -1.283685063936610e-14,  1.106596435906905e-15,
 -7.765687450802301e-17,  4.612806107582813e-18, -2.382320602076357e-19,  1.090880034699959e-20, -4.495168724438259e-22,  1.686416035004200e-23, -5.808825291963778e-25,
  3.997336870050081e-13, -1.360904761432444e-13,  2.447270023447840e-14, -3.005191686562837e-15,  2.814752253976034e-16, -2.138618960068290e-17,  1.370746986576603e-18,
 -7.614696340732105e-20,  3.739354859204309e-21, -1.647859394707356e-22,  6.594077901690933e-24, -2.416405017470388e-25,  7.970948584856774e-14, -2.929496457493379e-14,
  5.703145047086762e-15, -7.565964017048535e-16,  7.633526832743238e-17, -6.228711861516118e-18,  4.274880072216613e-19, -2.535725568720123e-20,  1.326097107252753e-21,
 -6.207797215419825e-23,  2.632571815972654e-24, -1.019952240509634e-25,  1.822158761144430e-14, -7.139559889403139e-15,  1.487126512162744e-15, -2.107896321203617e-16,
  2.267045431821541e-17, -1.966989594783492e-18,  1.431936441539195e-19, -8.987985443017788e-21,  4.962569646432888e-22, -2.447368906595452e-23,  1.091138123820734e-24,
 -4.435276364547670e-26,  4.873601270787621e-15, -2.008142075792969e-15,  4.414984031428552e-16, -6.599753012868265e-17,  7.472908390187163e-18, -6.813086171364030e-19,
  5.201524803038846e-20, -3.417492612103830e-21,  1.971489820383218e-22, -1.014073230925625e-23,  4.707671070917618e-25, -1.989161845788410e-26,  1.490864115265984e-15,
 -6.365630624534812e-16,  1.454761894127106e-16, -2.259532408933106e-17,  2.655246795768388e-18, -2.508976462524544e-19,  1.982525921181393e-20, -1.346290067272006e-21,
  8.016684373172526e-23, -4.250967706687060e-24,  2.031962420182778e-25, -8.829470785575129e-27,  4.206856609689405e-16, -1.832626617759507e-16,  4.281462772831402e-17,
 -6.796850643002942e-18,  8.158464317027631e-19, -7.868392609783697e-20,  6.340940586563586e-21, -4.388150716190356e-22,  2.660835021405327e-23, -1.435738941529831e-24,
  6.978547685813647e-26, -3.081318768811573e-27,  8.476275904377116e-02, -3.008309577267439e-04,  1.117446178693612e-06, -4.305447722402276e-09,  1.701859506299403e-11,
 -6.843818592293802e-14,  2.775808529990407e-16, -1.132373973632137e-18,  4.613962732106304e-21, -1.884799055507320e-23,  7.637440041920250e-26, -3.115468733701502e-28,
  7.500039776975587e-02, -3.408774275080817e-04,  1.904473296295250e-06, -1.102160689705498e-08,  6.265172769713773e-11, -3.470375334291643e-13,  1.877084796238786e-15,
 -9.951100973935873e-18,  5.184637459383368e-20, -2.661549159910044e-22,  1.348043838715711e-24, -6.748673227441199e-27,  5.872414984373467e-02, -3.844093633576476e-04,
  3.103926962444040e-06, -2.362536242046364e-08,  1.691738240376971e-10, -1.157025371976024e-12,  7.632669855615385e-15, -4.886848287848706e-17,  3.049850066075909e-19,
 -1.861356738035203e-21,  1.113747200254732e-23, -6.546660406550360e-26,  4.069497191253902e-02, -3.894742938262590e-04,  4.142594252150008e-06, -3.906876988355042e-08,
  3.401108223744816e-10, -2.792321171533505e-12,  2.187766317458519e-14, -1.648654034547701e-16,  1.201806641980039e-18, -8.511186024020195e-21,  5.875808598257470e-23,
 -3.964763198053198e-25,  2.496660015236152e-02, -3.407085514389740e-04,  4.541235568262410e-06, -5.192030725364979e-08,  5.397438333294293e-10, -5.225466728774416e-12,
  4.779079577254973e-14, -4.169485101935309e-16,  3.494705523152783e-18, -2.829007104591569e-20,  2.220984715414983e-22, -1.696472012589607e-24,  1.356613777887588e-02,
 -2.552005854623966e-04,  4.160839350047067e-06, -5.692260406446328e-08,  6.972676571676804e-10, -7.858630952786095e-12,  8.289166675127958e-14, -8.277731700912681e-16,
  7.891365586948110e-18, -7.226531659530061e-20,  6.387529027435118e-22, -5.470040554843328e-24,  6.532684061467757e-03, -1.640561766090207e-04,  3.229007699980662e-06,
 -5.231663550965411e-08,  7.473960473657300e-10, -9.713551304559639e-12,  1.171211144395538e-13, -1.327568745285701e-15,  1.428043810588655e-17, -1.468076895261328e-19,
  1.450251336057979e-21, -1.382499444132076e-23,  2.790142379708702e-03, -9.098354766398085e-05,  2.142634728480835e-06, -4.076136988653998e-08,  6.737180157517152e-10,
 -1.002341491658797e-11,  1.372178029441793e-13, -1.754129576853992e-15,  2.116076144901234e-17, -2.427842962666782e-19,  2.665348617375544e-21, -2.812990993955350e-23,
  1.058161604843056e-03, -4.377297407691182e-05,  1.224509829414930e-06, -2.715569221647369e-08,  5.159894194941257e-10, -8.737322425752849e-12,  1.350754794382838e-13,
 -1.937570225951448e-15,  2.608675632586693e-17, -3.324969580850890e-19,  4.038599886369520e-21, -4.698629922650628e-23,  3.568874070303266e-04, -1.836744085503747e-05,
  6.064037300974237e-07, -1.558189756818593e-08,  3.386033332325381e-10, -6.495209013437426e-12,  1.129048686602087e-13, -1.809906090683507e-15,  2.709155461700227e-17,
 -3.821855642017457e-19,  5.117778240503612e-21, -6.541110478216419e-23,  1.072628717206812e-04, -6.756795388412003e-06,  2.616913707984076e-07, -7.750966515972960e-09,
  1.917916065848754e-10, -4.151578896713163e-12,  8.085574597141914e-14, -1.443691106832127e-15,  2.394979147371219e-17, -3.728289594624226e-19,  5.488133716763266e-21,
 -7.684350634847136e-23,  2.880587186719359e-05, -2.190547244382880e-06,  9.896249713920842e-08, -3.363464424385421e-09,  9.441735923495066e-11, -2.298802344408360e-12,
  5.001394803023038e-14, -9.919270646383910e-16,  1.818986747394709e-17, -3.116948442785711e-19,  5.031738815718724e-21, -7.700338130366421e-23,  6.937041933795632e-06,
 -6.293645400541852e-07,  3.298889023697649e-08, -1.281429355123924e-09,  4.067670585985568e-11, -1.110828068001399e-12,  2.693002350028982e-14, -5.918938503721619e-16,
  1.197210087501076e-17, -2.253526148077339e-19,  3.981615606968556e-21, -6.646915702440130e-23,  1.505079008131044e-06, -1.612506991124087e-07,  9.757200167530345e-09,
 -4.316019740361782e-10,  1.544776093238804e-11, -4.720084860414174e-13,  1.272305319906253e-14, -3.092778590476199e-16,  6.887169169762937e-18, -1.421526229778520e-19,
  2.744226939394360e-21, -4.989195864034913e-23,  2.959947800937256e-07, -3.711264408968865e-08,  2.580045805660996e-09, -1.295226183032979e-10,  5.213197030839631e-12,
 -1.778286510317895e-13,  5.319150905241746e-15, -1.427499170654831e-16,  3.493919705866317e-18, -7.895268654089736e-20,  1.662822273759063e-21, -3.287519571411912e-23,
  5.318457061985593e-08, -7.740779362125650e-09,  6.154287913241292e-10, -3.494978726113178e-11,  1.577891521876474e-12, -5.996101240943475e-14,  1.986580083244060e-15,
 -5.876120825516076e-17,  1.578341255911251e-18, -3.899056758613078e-20,  8.946285320467896e-22, -1.920801195401724e-23,  8.820663405211703e-09, -1.479056973321833e-09,
  1.338780922603705e-10, -8.572782747302670e-12,  4.330391204966541e-13, -1.829338877359691e-14,  6.700791300307536e-16, -2.180913082934033e-17,  6.418767584790970e-19,
 -1.730939090552941e-20,  4.320773559692490e-22, -1.006061088792634e-23,  1.368115804482944e-09, -2.623922381696324e-10,  2.691727704133893e-11, -1.937025795137365e-12,
  1.091827777679214e-13, -5.115869703259515e-15,  2.067705102605204e-16, -7.391822513602689e-18,  2.379833318874700e-19, -6.994640661467589e-21,  1.896643558373743e-22,
 -4.782227029649302e-24,  2.017872559173559e-10, -4.394822111295468e-11,  5.085184305813062e-12, -4.097574269113607e-13,  2.569631633787540e-14, -1.332078962976247e-15,
  5.927270379472041e-17, -2.322585537815757e-18,  8.164161387357997e-20, -2.610506430133577e-21,  7.675761464854676e-23, -2.092186672922543e-24,  2.890220574660979e-11,
 -7.095181586569088e-12,  9.212050905973044e-13, -8.277601589649009e-14,  5.755318738710863e-15, -3.290821024171403e-16,  1.607664656768245e-17, -6.887615400649386e-19,
  2.637074984337003e-20, -9.152668488167707e-22,  2.911888844275202e-23, -8.561791783051584e-25,  4.126044459433437e-12, -1.132606033156262e-12,  1.640362366973931e-13,
 -1.635710144794246e-14,  1.255634015770683e-15, -7.889263448561737e-17,  4.216907478915432e-18, -1.968907250113554e-19,  8.185973880711388e-21, -3.074992938942366e-22,
  1.055561654855865e-23, -3.338857658338893e-25,  6.058845874404843e-13, -1.843347694628084e-13,  2.957612561057314e-14, -3.253581788872411e-15,  2.743001588085300e-16,
 -1.884748194740084e-17,  1.097341760795962e-18, -5.560454916585364e-20,  2.500443217678470e-21, -1.012703057349409e-22,  3.737113219771004e-24, -1.267133784857743e-25,
  9.495237875313652e-14, -3.170047122269635e-14,  5.588464039382397e-15, -6.732790261055677e-16,  6.192647285590977e-17, -4.624635425889724e-18,  2.915963786144281e-19,
 -1.594799423942512e-20,  7.716181599429057e-22, -3.352580611434361e-23,  1.323569967897916e-24, -4.788164284464351e-26,  1.654013654616439e-14, -5.991290631306423e-15,
  1.149005151292302e-15, -1.502336362508338e-16,  1.494884195583414e-17, -1.203786165473323e-18,  8.158723632135634e-20, -4.782011543876715e-21,  2.472523605083094e-22,
 -1.144960106306909e-23,  4.805483047652314e-25, -1.843540555556864e-26,  3.333363648380493e-15, -1.293333586825245e-15,  2.666250252535733e-16, -3.741419985464953e-17,
  3.985328759804391e-18, -3.426220954937508e-19,  2.472492947343232e-20, -1.539046880392505e-21,  8.430331440539440e-23, -4.126164292140047e-24,  1.826361958624542e-25,
 -7.372878322671608e-27,  7.996969187977573e-16, -3.276163361204357e-16,  7.158408174978095e-17, -1.063621463898742e-17,  1.197352647529303e-18, -1.085574960945445e-19,
  8.244041505064682e-21, -5.389107286895087e-22,  3.093888760743572e-23, -1.584076698860915e-24,  7.321503462725102e-26, -3.080645598736538e-27,  2.252075683921518e-16,
 -9.589698799328046e-17,  2.185093126446508e-17, -3.383991747451001e-18,  3.965437627014989e-19, -3.736863384737627e-20,  2.945123364289424e-21, -1.995012411044289e-22,
  1.185142328843872e-23, -6.270129674576599e-25,  2.990607191913129e-26, -1.296807863787809e-27,  6.051054673632594e-17, -2.633561363555486e-17,  6.146305179133792e-18,
 -9.747266905805813e-19,  1.168817889210090e-19, -1.126161231726267e-20,  9.066880292557921e-22, -6.268864505484882e-23,  3.797883336352956e-24, -2.047520195239284e-25,
  9.943952023853809e-27, -4.387170813044635e-28,  8.357699353858526e-02, -2.920935224567194e-04,  1.067370565699803e-06, -4.043748833571420e-09,  1.571396616499924e-11,
 -6.214064554148121e-14,  2.478434850808370e-16, -9.950197952598720e-19,  3.987274575627334e-21, -1.605047651661467e-23,  6.389351860971455e-26, -2.576566081062756e-28,
  7.366654537261495e-02, -3.261541490502460e-04,  1.778007212454868e-06, -1.007234901207835e-08,  5.613984092852040e-11, -3.051520869400324e-13,  1.620311680284678e-15,
 -8.435469092467640e-18,  4.316790907954359e-20, -2.177288728143259e-22,  1.083564071140261e-24, -5.332161697428217e-27,  5.723444241696124e-02, -3.606676460205276e-04,
  2.835930679082557e-06, -2.109419844456263e-08,  1.477597712250101e-10, -9.892172558743485e-13,  6.391493833553390e-15, -4.010045275494702e-17,  2.453468375712506e-19,
 -1.468495846971589e-21,  8.620078726329427e-24, -4.972201921604508e-26,  3.920051224984260e-02, -3.581203970871850e-04,  3.704665023901330e-06, -3.404673444710923e-08,
  2.891624377841271e-10, -2.318574002280765e-12,  1.775682548105649e-14, -1.308884514831233e-16,  9.338206661454945e-19, -6.475684453353613e-21,  4.379404975192844e-23,
 -2.895861660057779e-25,  2.367267704919045e-02, -3.067315879675753e-04,  3.966750025994135e-06, -4.406191487467275e-08,  4.458201784165132e-10, -4.206828642113368e-12,
  3.754018799693112e-14, -3.198343945942932e-16,  2.619692431949652e-18, -2.073626095587870e-20,  1.592669078772981e-22, -1.190722390595728e-24,  1.260783559008076e-02,
 -2.244677788559244e-04,  3.539848874289748e-06, -4.692300793069535e-08,  5.582495282243249e-10, -6.121066075648474e-12,  6.289085784917846e-14, -6.123780471505033e-16,
  5.697097755273102e-18, -5.094858523154879e-20,  4.400513604532828e-22, -3.684397738191347e-24,  5.924416125718158e-03, -1.405458533155507e-04,  2.667009444875520e-06,
 -4.177150928469551e-08,  5.784706812227550e-10, -7.301580311655633e-12,  8.562572798933037e-14, -9.450500840308824e-16,  9.907912052614927e-18, -9.935388989945908e-20,
  9.580352865293073e-22, -8.920266065646866e-24,  2.457632470949795e-03, -7.562991502639767e-05,  1.712096847045885e-06, -3.142211533580232e-08,  5.025673044095617e-10,
 -7.250453957989859e-12,  9.640202977249703e-14, -1.198451167684244e-15,  1.407459861357195e-17, -1.573498957361401e-19,  1.684553854898237e-21, -1.734963049658190e-23,
  9.007800010702083e-04, -3.515224106185891e-05,  9.429338299844323e-07, -2.013857467833033e-08,  3.697110114653646e-10, -6.062242808357881e-12,  9.091178099105153e-14,
 -1.266773385809903e-15,  1.658698457997222e-17, -2.058141841638954e-19,  2.435776145049877e-21, -2.763340180273683e-23,  2.920539948790040e-04, -1.418103708987800e-05,
  4.480737856810899e-07, -1.107186753778070e-08,  2.321485227379593e-10, -4.307085879786393e-12,  7.254824720927262e-14, -1.128623626243530e-15,  1.641550061436551e-17,
 -2.252639342570405e-19,  2.937018283267165e-21, -3.658066276738848e-23,  8.389979348626081e-05, -4.988831304068009e-06,  1.846591379892898e-07, -5.253448555394305e-09,
  1.252910951140447e-10, -2.620554830773810e-12,  4.941178915865641e-14, -8.555141034613091e-16,  1.378068806332132e-17, -2.085435149330430e-19,  2.987231853379789e-21,
 -4.073827067872113e-23,  2.140359082369666e-05, -1.537724998548313e-06,  6.633582204013970e-08, -2.163756989410016e-09,  5.849547991504039e-11, -1.375108107096313e-12,
  2.894491861238676e-14, -5.563277485982303e-16,  9.900613220641204e-18, -1.648436331489875e-19,  2.588420774008869e-21, -3.856724791634773e-23,  4.863667838524707e-06,
 -4.173833860720645e-07,  2.088359653549836e-08, -7.781600075106411e-10,  2.377644917628289e-11, -6.266166998527274e-13,  1.469081060073562e-14, -3.127894146279703e-16,
  6.137782839724654e-18, -1.122242150437097e-19,  1.928194960526146e-21, -3.133412927306273e-23,  9.884956001269944e-07, -1.003308524769938e-07,  5.796093153502328e-09,
 -2.459184514913765e-10,  8.470774718799394e-12, -2.497340271044578e-13,  6.508723107044645e-15, -1.532452678668076e-16,  3.310251781161980e-18, -6.636247314204429e-20,
  1.245763446015118e-21, -2.204694940460937e-23,  1.806762325018154e-07, -2.150253765000713e-08,  1.428111193216838e-09, -6.878918176452791e-11,  2.665083880872008e-12,
 -8.772787857437489e-14,  2.537504892023858e-15, -6.596722846121998e-17,  1.566418222733081e-18, -3.438573667186953e-20,  7.043433029925838e-22, -1.355814162209894e-23,
  2.991612939645104e-08, -4.142474109395838e-09,  3.150127544465512e-10, -1.717798472709372e-11,  7.469554375346591e-13, -2.740523794903177e-14,  8.784106098458620e-16,
 -2.518021610275336e-17,  6.564461880143408e-19, -1.576024133024711e-20,  3.518563466363542e-22, -7.358625680533102e-24,  4.530650362468646e-09, -7.247518487084911e-10,
  6.285244162517768e-11, -3.869533484109178e-12,  1.884533440327048e-13, -7.693305261831769e-15,  2.728563262200831e-16, -8.613229086757407e-18,  2.462291251481327e-19,
 -6.458007775249327e-21,  1.569705469593881e-22, -3.562814049251752e-24,  6.355283010310074e-10, -1.166533693491742e-10,  1.149083276963561e-11, -7.964359120730554e-13,
  4.334804012011683e-14, -1.965475629295386e-15,  7.701424997429895e-17, -2.673423216873967e-18,  8.369798041168151e-20, -2.395186607061898e-21,  6.330889710938121e-23,
 -1.557683914889181e-24,  8.393415776378583e-11, -1.755982221106004e-11,  1.956442532779937e-12, -1.521917390184346e-13,  9.234673269398233e-15, -4.641068385418812e-16,
  2.005503426767190e-17, -7.643243228279095e-19,  2.616621728492426e-20, -8.158410098940953e-22,  2.341710102836968e-23, -6.237243234493132e-25,  1.065917072687949e-11,
 -2.524079905537902e-12,  3.166156005786036e-13, -2.754490191957702e-14,  1.857884255860088e-15, -1.032342125112311e-16,  4.908607513922239e-18, -2.049639353641248e-19,
  7.658072042241900e-21, -2.596722890307208e-22,  8.079480590549447e-24, -2.325569631629756e-25,  1.336907081280484e-12, -3.556395358827145e-13,  4.995816730898857e-14,
 -4.839946443782701e-15,  3.615601696552114e-16, -2.214073511067153e-17,  1.154995187942131e-18, -5.269611043999229e-20,  2.143280881767342e-21, -7.884146375283579e-23,
  2.652809973839858e-24, -8.232340889816803e-26,  1.711996992200481e-13, -5.073085466703935e-14,  7.929861874979461e-15, -8.509348414646690e-16,  7.007273080752201e-17,
 -4.708795178202266e-18,  2.684319102278474e-19, -1.333211846595504e-20,  5.882009110760984e-22, -2.339378601148512e-23,  8.484468470683108e-25, -2.829613661615179e-26,
  2.329671471100003e-14, -7.615594384129888e-15,  1.314292671004727e-15, -1.551471359469267e-16,  1.399644012733009e-17, -1.026226435677385e-18,  6.358837219404117e-20,
 -3.420646818031931e-21,  1.629147491842281e-22, -6.972956427535883e-24,  2.713722829913413e-25, -9.684123739542957e-27,  3.526105829450151e-15, -1.257288541270807e-15,
  2.372432123064505e-16, -3.053833471077984e-17,  2.993707657780132e-18, -2.376811128662878e-19,  1.589340302435795e-20, -9.196918363836541e-22,  4.697624238638895e-23,
 -2.150233470421958e-24,  8.925336044041390e-26, -3.388144833015158e-27,  6.222672349347486e-16, -2.388634778924393e-16,  4.869178887922754e-17, -6.758468536964786e-18,
  7.124242151801045e-19, -6.064115386415579e-20,  4.334849173919690e-21, -2.674094463886200e-22,  1.452256409411473e-23, -7.050102260462887e-25,  3.096361910111496e-26,
 -1.240740957036263e-27,  1.329367261178213e-16, -5.411697854264665e-17,  1.174479428413395e-17, -1.733579256510490e-18,  1.939192426735984e-19, -1.747531670570112e-20,
  1.319455914925082e-21, -8.577868547290616e-23,  4.898775830556249e-24, -2.495661616572101e-25,  1.147986158383054e-26, -4.808443828485471e-28,  3.424234036031802e-17,
 -1.453743420115597e-17,  3.301749884613604e-18, -5.097030340158392e-19,  5.954449166336305e-20, -5.594682209952572e-21,  4.396885128288370e-22, -2.970399152936222e-23,
  1.760026312189462e-24, -9.288678270590025e-26,  4.419898004467828e-27, -1.912277285506430e-28,  8.723769301057510e-18, -3.792978137108681e-18,  8.842368280996977e-19,
 -1.400736227382750e-19,  1.677841398192800e-20, -1.614914578322680e-21,  1.298873531604129e-22, -8.971661177427725e-24,  5.430192010129809e-25, -2.924862136329970e-26,
  1.419231812034223e-27, -6.256189632016062e-29,  8.242539596512026e-02, -2.837444760763851e-04,  1.020314129241013e-06, -3.801953910174453e-09,  1.452845129676101e-11,
 -5.651282736760315e-14,  2.216857569620969e-16, -8.762001791063565e-19,  3.452852681706981e-21, -1.370797807524689e-23,  5.354831015459924e-26, -2.141155355075877e-28,
  7.238963235628151e-02, -3.123987445579475e-04,  1.662333679998578e-06, -9.220900591939294e-09,  5.040731939096862e-11, -2.689497835013276e-13,  1.402336505542335e-15,
 -7.171580608592761e-18,  3.605646663969551e-20, -1.787341615603631e-22,  8.741905091442425e-25, -4.229998333164647e-27,  5.583559838799722e-02, -3.389539827495123e-04,
  2.596358344077124e-06, -1.888034875600170e-08,  1.294228228913460e-10, -8.484545523863906e-13,  5.371099827120166e-15, -3.303271267456054e-17,  1.981944471401583e-19,
 -1.163736186562877e-21,  6.703489696000647e-24, -3.795464736280913e-26,  3.782482432425288e-02, -3.300420477118271e-04,  3.322405286336144e-06, -2.976914033459333e-08,
  2.467723201204125e-10, -1.933215923661427e-12,  1.447752758804480e-14, -1.044215174080253e-16,  7.293828981517008e-19, -4.954320289941128e-21,  3.283228428447538e-23,
 -2.128171411696682e-25,  2.250603313965614e-02, -2.769973873780390e-04,  3.478179919764850e-06, -3.755581501563565e-08,  3.700140483485861e-10, -3.404503899399172e-12,
  2.965442917954047e-14, -2.468143623445541e-16,  1.976270721445546e-18, -1.530134968589658e-20,  1.150136117477282e-22, -8.418852595285770e-25,  1.176323864683345e-02,
 -1.982582470897564e-04,  3.026575399165076e-06, -3.889385615209405e-08,  4.496328331889940e-10, -4.798424510153559e-12,  4.804333965255564e-14, -4.563135479099506e-16,
  4.144270964555896e-18, -3.620568201956495e-20,  3.056742630029586e-22, -2.503016586139320e-24,  5.401938591531120e-03, -1.210678813462988e-04,  2.216804040540428e-06,
 -3.358096746477210e-08,  4.510179160133152e-10, -5.531330967841275e-12,  6.311396327716502e-14, -6.785334051603673e-16,  6.935825273539151e-18, -6.786479627081693e-20,
  6.389753006800022e-22, -5.812846286682262e-24,  2.180297699472584e-03, -6.331496059585233e-05,  1.378870719283992e-06, -2.442595921209539e-08,  3.782190219402044e-10,
 -5.293394676667121e-12,  6.838397496760695e-14, -8.270518481347912e-16,  9.459012264312779e-18, -1.030765535781886e-19,  1.076460355190403e-21, -1.082235770639491e-23,
  7.738581688103074e-04, -2.848336079167502e-05,  7.331155895443809e-07, -1.508567049524572e-08,  2.676951379098983e-10, -4.252245803522534e-12,  6.188067604218489e-14,
 -8.378801379055063e-16,  1.067325503108612e-17, -1.289665142316705e-19,  1.487586038821361e-21, -1.646086018958114e-23,  2.417387927821600e-04, -1.107073350644980e-05,
  3.349344191077525e-07, -7.961787149650840e-09,  1.611363612267397e-10, -2.892541224494535e-12,  4.722688421365356e-14, -7.132196178365729e-16,  1.008276237140899e-17,
 -1.346264302030309e-19,  1.709471186904283e-21, -2.075311326537096e-23,  6.654309459562077e-05, -3.733246259141756e-06,  1.321045754409684e-07, -3.610976192838275e-09,
  8.302936363271339e-11, -1.678485356276846e-12,  3.064862268054135e-14, -5.146946021610590e-16,  8.052136744173050e-18, -1.184811701355307e-19,  1.651835046278842e-21,
 -2.194486783965643e-23,  1.616960468909166e-05, -1.096856832663711e-06,  4.518793530414626e-08, -1.414818388110883e-09,  3.684246085604737e-11, -8.363988950493876e-13,
  1.703637836843528e-14, -3.173825888674996e-16,  5.482370748921954e-18, -8.870648914117431e-20,  1.355045342538578e-21, -1.966009877751105e-23,  3.477146602220145e-06,
 -2.820404102122988e-07,  1.346943276708287e-08, -4.814601969424860e-10,  1.416110824816718e-11, -3.602010358901317e-13,  8.167384280494266e-15, -1.684719171818625e-16,
  3.207423392000949e-18, -5.697012301741691e-20,  9.519374592027477e-22, -1.505934455245447e-23,  6.640337555199248e-07, -6.379305319197552e-08,  3.517411166739986e-09,
 -1.431249006872656e-10,  4.744238066435935e-12, -1.349506564953601e-13,  3.400634398619534e-15, -7.754932938860421e-17,  1.624903385996884e-18, -3.163946664777034e-20,
  5.775387120860082e-22, -9.949129565771085e-24,  1.131591864962153e-07, -1.276922426701005e-08,  8.098079511248352e-10, -3.741444254094246e-11,  1.394958266864879e-12,
 -4.430345232613919e-14,  1.238991325846449e-15, -3.119732193697530e-17,  7.185933923835824e-19, -1.532203977666223e-20,  3.052086573331336e-22, -5.719429990517195e-24,
  1.732092643334888e-08, -2.278994916176342e-09,  1.656424869919457e-10, -8.668969458328176e-12,  3.629125423411547e-13, -1.285104575287000e-14,  3.983803133020130e-16,
 -1.106413321654326e-17,  2.798820355326964e-19, -6.528867540504024e-21,  1.417939156493256e-22, -2.887890977291067e-24,  2.402629325480629e-09, -3.661432397933461e-10,
  3.039379177282801e-11, -1.797762351464449e-12,  8.436427095332035e-14, -3.326484635483787e-15,  1.141813082940501e-16, -3.494320126906757e-18,  9.698945045664462e-20,
 -2.473148152494346e-21,  5.851325024786282e-23, -1.294169613784020e-24,  3.056363892199919e-10, -5.360734829575242e-11,  5.064750173793305e-12, -3.377945437938468e-13,
  1.773904741030554e-14, -7.777865235404253e-16,  2.952744257071195e-17, -9.947300235423228e-19,  3.026706480269207e-20, -8.429053389021969e-22,  2.170693223563511e-23,
 -5.209316597994159e-25,  3.622441313951302e-11, -7.267440510207987e-12,  7.786406532028420e-13, -5.840961591336652e-14,  3.425958080050288e-15, -1.667786771934644e-16,
  6.993334446567237e-18, -2.590354224975101e-19,  8.630771646521622e-21, -2.622323238015236e-22,  7.343098459085537e-24, -1.910142793070700e-25,  4.084432517377199e-12,
 -9.312868575954658e-13,  1.126971788001088e-13, -9.480551919323988e-15,  6.196351598733459e-16, -3.342487736000766e-17,  1.545406503206367e-18, -6.283932335835313e-20,
  2.289337444778737e-21, -7.578181076133658e-23,  2.304299687695272e-24, -6.488452819731028e-26,  4.501612068864630e-13, -1.158383657711498e-13,  1.575828154960398e-14,
 -1.481198869615180e-15,  1.075471276925033e-16, -6.411461427095359e-18,  3.260785177338817e-19, -1.452331176545956e-20,  5.773326080975439e-22, -2.077929557067660e-23,
  6.847649387709712e-25, -2.083178505090633e-26,  5.020223760599445e-14, -1.446368346747875e-14,  2.199124268594541e-15, -2.298666280169663e-16,  1.846530632877666e-17,
 -1.212090015212514e-18,  6.757975849740590e-20, -3.286487372753263e-21,  1.421215140155593e-22, -5.545620642960626e-24,  1.975020738028370e-25, -6.473472543473887e-27,
  5.912726854408256e-15, -1.889504061922235e-15,  3.187509162481235e-16, -3.681794876743799e-17,  3.253719661697816e-18, -2.339508576828585e-19,  1.423044506578437e-20,
 -7.521694682676624e-22,  3.522985681499117e-23, -1.484084250340886e-24,  5.688804756526207e-26, -2.000974792966876e-27,  7.735692013316651e-16, -2.711505796619713e-16,
  5.027633845056249e-17, -6.363519358784126e-18,  6.139005298708024e-19, -4.800354000513222e-20,  3.163889992886339e-21, -1.805873489183131e-22,  9.104521103654015e-24,
 -4.115963726247348e-25,  1.688388336473993e-26, -6.337525194210503e-28,  1.187239631869373e-16, -4.504197597278459e-17,  9.069906965130398e-18, -1.244058346192303e-18,
  1.296607232202976e-19, -1.091828315906834e-20,  7.725209608872271e-22, -4.719354123880464e-23,  2.539368224871195e-24, -1.221935954565802e-25,  5.321784161527927e-27,
 -2.115522810687677e-28,  2.241336573144328e-17, -9.060825102913027e-18,  1.951896801089122e-18, -2.860301859749373e-19,  3.177430511060051e-20, -2.844506823523045e-21,
  2.134230858341959e-22, -1.379185179358721e-23,  7.831638547594402e-25, -3.968173990780992e-26,  1.815903353515783e-27, -7.568706614773129e-29,  5.243794266408596e-18,
 -2.218918415767519e-18,  5.021703250124932e-19, -7.725108368129219e-20,  8.994256627737941e-21, -8.423602433703849e-22,  6.599773265954912e-23, -4.445503337486853e-24,
  2.626670348862934e-25, -1.382533591616486e-26,  6.561777177548776e-28, -2.832041687541282e-29,  1.260828553294155e-18, -5.475955508173965e-19,  1.275048817386130e-19,
 -2.017416540696819e-20,  2.413705582152732e-21, -2.320562549604633e-22,  1.864394333281274e-23, -1.286434412576762e-24,  7.778396042800383e-26, -4.185582603139965e-27,
  2.029057718114752e-28, -8.936281729560377e-30,  8.130645960637539e-02, -2.757605891532888e-04,  9.760490293145505e-07, -3.578259786072963e-09,  1.344947475341395e-11,
 -5.147472859177074e-14,  1.986276862098285e-16, -7.732090607740069e-19,  2.995749903919150e-21, -1.174358209984690e-23,  4.492681565873839e-26, -1.790370069925288e-28,
  7.116595276048347e-02, -2.995293648082619e-04,  1.556350211107185e-06, -8.455652801839947e-09,  4.534926878188851e-11, -2.375786911077613e-13,  1.216764324173547e-15,
 -6.114323454386964e-18,  3.020907524773502e-20, -1.472200954492280e-22,  7.077776284897101e-25, -3.368966619209064e-27,  5.451993733753713e-02, -3.190554153868782e-04,
  2.381680628269241e-06, -1.693863445984037e-08,  1.136714236863194e-10, -7.299674148810795e-13,  4.529027727274552e-15, -2.731214760447191e-17,  1.607496857666176e-19,
 -9.262112467408587e-22,  5.237061947297453e-24, -2.911366004961544e-26,  3.655564319843534e-02, -3.048274226704460e-04,  2.987648369201146e-06, -2.611216773162011e-08,
  2.113587432433754e-10, -1.618359614685217e-12,  1.185538221551883e-14, -8.369872180335205e-17,  5.725729129052875e-19, -3.810670378022666e-21,  2.475363650834336e-23,
 -1.573306019595967e-25,  2.145097579253232e-02, -2.508789180981156e-04,  3.060903651696029e-06, -3.214386881510391e-08,  3.085161411530762e-10, -2.769059973954164e-12,
  2.355211978610586e-14, -1.915670442622133e-16,  1.500024420986158e-18, -1.136391406085633e-20,  8.361996066129414e-23, -5.994654586055923e-25,  1.101583846242386e-02,
 -1.757971559665549e-04,  2.600038599548831e-06, -3.240891935867373e-08,  3.642324538041409e-10, -3.784845043183678e-12,  3.694290319440341e-14, -3.423912183270808e-16,
  3.036776750648791e-18, -2.592617081328286e-20,  2.140285830599646e-22, -1.714558661055413e-24,  4.950746519878357e-03, -1.048305618417210e-04,  1.853729442261096e-06,
 -2.717342884829373e-08,  3.541203758557035e-10, -4.221595854777216e-12,  4.688746441667369e-14, -4.912042984947143e-16,  4.897152181750517e-18, -4.677138125805839e-20,
  4.301321196702350e-22, -3.824261961338709e-24,  1.947378728776739e-03, -5.336106865529057e-05,  1.118843326082281e-06, -1.913952464013676e-08,  2.870507612124095e-10,
 -3.899018062158795e-12,  4.896057046789838e-14, -5.762748198088545e-16,  6.420824642768005e-18, -6.822296965340384e-20,  6.952209652742163e-22, -6.824840968674310e-24,
  6.706029528020977e-04, -2.327571130285557e-05,  5.752209429046615e-07, -1.140954864488568e-08,  1.957839191082479e-10, -3.013954699255788e-12,  4.257802874628617e-14,
 -5.604176007492611e-16,  6.947281216679482e-18, -8.177116497030061e-20,  9.195464069771666e-22, -9.927402490773960e-24,  2.022662592050278e-04, -8.733622634543957e-06,
  2.531353834782635e-07, -5.791015061056148e-09,  1.131734163097272e-10, -1.966325642621260e-12,  3.112988116822086e-14, -4.565194823892020e-16,  6.274714559843565e-18,
 -8.154118655819565e-20,  1.008640681226809e-21, -1.193820428036387e-23,  5.347816792898195e-05, -2.829466530175918e-06,  9.575311050416319e-08, -2.515520621083696e-09,
  5.578327410023135e-11, -1.090267269377605e-12,  1.928434565653576e-14, -3.141955770631254e-16,  4.775140643610511e-18, -6.833391295709154e-20,  9.274520356204168e-22,
 -1.200539802448656e-23,  1.241029459165156e-05, -7.943841507510299e-07,  3.125945646614668e-08, -9.396466443603727e-10,  2.357456163916312e-11, -5.169568566823993e-13,
  1.019149295575180e-14, -1.840674319078132e-16,  3.086712940347121e-18, -4.854386285783650e-20,  7.215010751841698e-22, -1.019482305825243e-23,  2.532699305206005e-06,
 -1.940287198424092e-07,  8.844214957983776e-09, -3.032814745796226e-10,  8.587927013533017e-12, -2.108535304970517e-13,  4.624506804987174e-15, -9.242686529702438e-17,
  1.707430028039648e-18, -2.946403524031049e-20,  4.788382196826581e-22, -7.374818481561625e-24,  4.558462589992672e-07, -4.141291958235026e-08,  2.178866771831900e-09,
 -8.501939535211645e-11,  2.711914346608238e-12, -7.442832377569486e-14,  1.813406317081288e-15, -4.005407505023631e-17,  8.141003717082731e-19, -1.539657964491147e-20,
  2.732860657664419e-22, -4.582600478695035e-24,  7.265422560830381e-08, -7.765374796134864e-09,  4.700321463264582e-10, -2.082405485390613e-11,  7.470295646384725e-13,
 -2.288773578481434e-14,  6.187922252736536e-16, -1.508958819026393e-17,  3.371231168777144e-19, -6.981435897792842e-21,  1.352257735909645e-22, -2.466691704707560e-24,
  1.031368163222338e-08, -1.287869447346842e-09,  8.940617987351035e-11, -4.488611382518451e-12,  1.808432505894084e-13, -6.178842005082642e-15,  1.852034894485704e-16,
 -4.982235248900885e-18,  1.222657005467315e-19, -2.770613712704514e-21,  5.852283008556696e-23, -1.160524618081246e-24,  1.314500586879051e-09, -1.905700873502081e-10,
  1.512871444113722e-11, -8.591496844267381e-13,  3.882742868483314e-14, -1.478017424243825e-15,  4.907902698922773e-17, -1.455570780295649e-18,  3.921287585592395e-20,
 -9.717940244489512e-22,  2.237290553172887e-23, -4.820425396087238e-25,  1.520897572094271e-10, -2.545064989348823e-11,  2.303734501945060e-12, -1.477205995037493e-13,
  7.479215874612777e-15, -3.169099928520142e-16,  1.164954574751741e-17, -3.806600035343695e-19,  1.125127596826765e-20, -3.047811870821180e-22,  7.643732738670424e-24,
 -1.788407716631467e-25,  1.621714063665199e-11, -3.114669959765456e-12,  3.204877883941704e-13, -2.315871745605243e-14,  1.311821938513356e-15, -6.180663103628936e-17,
  2.512982681100926e-18, -9.040289348295216e-20,  2.929660027111400e-21, -8.668802775625712e-23,  2.366815306825070e-24, -6.009458460193486e-26,  1.626353467354955e-12,
 -3.564091096626837e-13,  4.154721048769371e-14, -3.375436405922203e-15,  2.135390476741559e-16, -1.117138738600463e-17,  5.017900438968538e-19, -1.985241038686799e-20,
  7.046677944202700e-22, -2.275437687093530e-23,  6.756911552493443e-25, -1.860005458487650e-26,  1.576127964275679e-13, -3.915952100567883e-14,  5.150699978049447e-15,
 -4.690710299166925e-16,  3.306202659315091e-17, -1.916650664783794e-18,  9.493634976243877e-20, -4.123827193575977e-21,  1.600762852382955e-22, -5.632354960082707e-24,
  1.816389382248409e-25, -5.412876721218000e-27,  1.529378325551611e-14, -4.276172779520544e-15,  6.313895488763827e-16, -6.419286961015641e-17,  5.023672622704993e-18,
 -3.217293870117605e-19,  1.752438172617194e-20, -8.335937574728633e-22,  3.529867454680079e-23, -1.350093894897935e-24,  4.717420574766883e-26, -1.518360514299450e-27,
  1.554637421168305e-15, -4.848367885791996e-16,  7.982392986271130e-17, -9.008995638143408e-18,  7.788851552411549e-19, -5.485423338669608e-20,  3.271704337169641e-21,
 -1.697388355378386e-22,  7.810723340107947e-24, -3.235394733018450e-25,  1.220460071520665e-26, -4.227762390933763e-28,  1.749417086250157e-16, -6.019220452463145e-17,
  1.095172861096741e-17, -1.361250236815215e-18,  1.290791077781269e-19, -9.929762230523262e-21,  6.444115157460850e-22, -3.624510875615784e-23,  1.802016828017460e-24,
 -8.039142515177215e-26,  3.256289988415072e-27, -1.207677438194819e-28,  2.318895044605599e-17, -8.685252827278137e-18,  1.725718066458115e-18, -2.336707126835262e-19,
  2.405637985604924e-20, -2.002175994991850e-21,  1.401012687209945e-22, -8.469186651229922e-24,  4.511701662345188e-25, -2.150463718387883e-26,  9.281314091743475e-28,
 -3.657915894987757e-29,  3.837586358973296e-18, -1.539507314766213e-18,  3.289519455039416e-19, -4.782376446058304e-20,  5.272451197333979e-21, -4.686036416263172e-22,
  3.491859645874971e-23, -2.241827883939268e-24,  1.265132787883091e-25, -6.372490829634450e-27,  2.899810202547876e-28, -1.202204750937473e-29,  8.093325125811613e-19,
 -3.412291848538689e-19,  7.692257924282260e-20, -1.178795350237216e-20,  1.367395428424869e-21, -1.276122967876168e-22,  9.964608636141403e-24, -6.690477098981569e-25,
  3.941048272892440e-26, -2.068300117258241e-27,  9.789245542257512e-29, -4.213812805306256e-30,  1.827152922989566e-19, -7.926217595967618e-20,  1.843180931453415e-20,
 -2.912562730065653e-21,  3.480307698266512e-22, -3.341938783427729e-23,  2.681845376899193e-24, -1.848387411941231e-25,  1.116407743694856e-26, -6.001135614101346e-28,
  2.906251373127023e-29, -1.278715132307220e-30,  8.021876715000659e-02, -2.681203717259551e-04,  9.343679074862450e-07, -3.371052307032940e-09,  1.246595155897632e-11,
 -4.695700834549855e-14,  1.782587583483593e-16, -6.837774095231877e-19,  2.603510003683167e-21, -1.009534193497283e-23,  3.768912457302110e-26, -1.510220610341750e-28,
  6.999211122566892e-02, -2.874724505451848e-04,  1.459084090516637e-06, -7.766546735159059e-09,  4.087639556716590e-11, -2.103262327092492e-13,  1.058337518183012e-15,
 -5.227244880147788e-18,  2.538496692021649e-20, -1.216630427391225e-22,  5.749877903303834e-25, -2.693781984553182e-27,  5.328057746360380e-02, -3.007851786178382e-04,
  2.188866137442085e-06, -1.523103054984776e-08,  1.000999765137436e-10, -6.298957838238168e-13,  3.831565168793836e-15, -2.266360238639624e-17,  1.308874239866580e-19,
 -7.402478678105050e-22,  4.109667682804821e-24, -2.243756055670853e-26,  3.538222939734880e-02, -2.821244934677009e-04,  2.693572664647940e-06, -2.297466708102198e-08,
  1.816572001690154e-10, -1.360003034933166e-12,  9.748995221872239e-15, -6.739299174861247e-17,  4.516614124598007e-19, -2.946167376334053e-21,  1.876491053442379e-23,
 -1.169797735202148e-25,  2.049410480630035e-02, -2.278546963089197e-04,  2.703061921784368e-06, -2.762167894509887e-08,  2.583794848597730e-10, -2.263107682122649e-12,
  1.880307214835128e-14, -1.495145825165360e-16,  1.145276051931518e-18, -8.492309819231211e-21,  6.119359743834644e-23, -4.297732030985501e-25,  1.035192003414712e-02,
 -1.564588594732084e-04,  2.243747478222179e-06, -2.714167425500659e-08,  2.966786020223393e-10, -3.003084621553697e-12,  2.858709047143517e-14, -2.586325263607123e-16,
  2.240943438518361e-18, -1.870240278024362e-20,  1.510150282861442e-22, -1.183881158454730e-24,  4.559146758679906e-03, -9.121477172939687e-05,  1.559043600028789e-06,
 -2.212619341392496e-08,  2.799127223243567e-10, -3.245077998038929e-12,  3.509643815023330e-14, -3.584183477103568e-16,  3.486415938521748e-18, -3.251252246114582e-20,
  2.921407944933185e-22, -2.539276621214801e-24,  1.750484248564889e-03, -4.525647877186083e-05,  9.143453166659129e-07, -1.511180647788643e-08,  2.196249626364815e-10,
 -2.896466086069095e-12,  3.536729595897397e-14, -4.052745941306119e-16,  4.400566487187776e-18, -4.560531484606963e-20,  4.536235984784185e-22, -4.349487168145506e-24,
  5.859060821878069e-04, -1.917259412446060e-05,  4.552786940164326e-07, -8.708632655079418e-09,  1.445716737804231e-10, -2.157746839660300e-12,  2.960223299881479e-14,
 -3.788802787951572e-16,  4.572308871544583e-18, -5.243965699538197e-20,  5.750792853776101e-22, -6.058989925667992e-24,  1.709816434836147e-04, -6.958470234910099e-06,
  1.933306054402185e-07, -4.258229187275868e-09,  8.038937827017496e-11, -1.352367141582267e-12,  2.076719037564673e-14, -2.958327164991975e-16,  3.954475902247897e-18,
 -5.002944418827663e-20,  6.030135683015012e-22, -6.960133993915620e-24,  4.352059697818354e-05, -2.170521097093519e-06,  7.027645419696964e-08, -1.774991487594820e-09,
  3.797402431503792e-11, -7.177862968776472e-13,  1.230193684087714e-14, -1.945111801746356e-16,  2.872543841356432e-18, -3.998827603378668e-20,  5.284728739751782e-22,
 -6.666793340607973e-24,  9.669611846297455e-06, -5.837066397763441e-07,  2.194436594626443e-08, -6.334474446654629e-10,  1.531541113735664e-11, -3.244815118199637e-13,
  6.192880661591855e-15, -1.084572510950615e-16,  1.766033540459784e-18, -2.700032437627786e-20,  3.905266586426836e-22, -5.374934001238353e-24,  1.877962203009735e-06,
 -1.357818706361518e-07,  5.907487041277861e-09, -1.943610439072870e-10,  5.299298531179110e-12, -1.256088371364766e-13,  2.665107192077223e-15, -5.161738777291560e-17,
  9.253643877423377e-19, -1.551572832705821e-20,  2.452737399453759e-22, -3.678074884695335e-24,  3.195044718629513e-07, -2.742474228750349e-08,  1.376587593791053e-09,
 -5.150685732133370e-11,  1.581009593787233e-12, -4.186641564391569e-14,  9.863106571573118e-16, -2.110174496474651e-17,  4.160539200633178e-19, -7.642871390215185e-21,
  1.319180354300037e-22, -2.153272032613967e-24,  4.777743418221496e-08, -4.831660603276373e-09,  2.790206620755525e-10, -1.185108078676540e-11,  4.089972235070251e-13,
 -1.208735562984693e-14,  3.159011045200718e-16, -7.459991670521699e-18,  1.616470932726980e-19, -3.251026785753664e-21,  6.122696180369912e-23, -1.087098961008499e-24,
  6.310353191620485e-09, -7.469136259113928e-10,  4.949531980243310e-11, -2.382744771828495e-12,  9.236109469464192e-14, -3.044057795810745e-15,  8.820302761297869e-17,
 -2.297890159380556e-18,  5.469573285217446e-20, -1.203809776779954e-21,  2.472654918895080e-23, -4.773378851659716e-25,  7.413828065683592e-10, -1.021089931857719e-10,
  7.745653531870961e-12, -4.220611562374006e-13,  1.836002203902534e-14, -6.744425957082145e-16,  2.165739607789294e-17, -6.222509849615955e-19,  1.626510241470086e-20,
 -3.916442140220914e-22,  8.771193740345907e-24, -1.840458376105437e-25,  7.826253755279987e-11, -1.247543797226747e-11,  1.080752809321798e-12, -6.657144024946973e-14,
  3.247424930759790e-15, -1.328943197383359e-16,  4.727718977466687e-18, -1.497658198714044e-19,  4.298086183780665e-21, -1.132006574192884e-22,  2.763645296348057e-24,
 -6.301546132904533e-26,  7.528481811690451e-12, -1.381836476646335e-12,  1.363784584371882e-13, -9.483141983199764e-15,  5.183074365728212e-16, -2.361596623201154e-17,
  9.303778741345201e-19, -3.248501862093645e-20,  1.023279782208278e-21, -2.947058688559199e-23,  7.840898395230584e-25, -1.942187308190775e-26,  6.729496066226405e-13,
 -1.414800412661594e-13,  1.586414690522416e-14, -1.243184913118478e-15,  7.604279112195779e-17, -3.854447702251836e-18,  1.680482584231460e-19, -6.463554377634033e-21,
  2.233585108695459e-22, -7.030637468047029e-24,  2.037463534534375e-25, -5.479436519736608e-27,  5.740895289878107e-14, -1.374512794795510e-14,  1.745232175610947e-15,
 -1.537758211881444e-16,  1.050860330795208e-17, -5.917315866096573e-19,  2.851605984425991e-20, -1.206882739611387e-21,  4.570543528868809e-23, -1.570804451201010e-24,
  4.953383428660356e-26, -1.444857835742004e-27,  4.845138578019557e-15, -1.312176933195786e-15,  1.878353831185725e-16, -1.854738360915560e-17,  1.412167674571562e-18,
 -8.812757852600025e-20,  4.684251608803413e-21, -2.177153369864995e-22,  9.018599609177770e-24, -3.377967339376815e-25,  1.156999176612705e-26, -3.653808604129144e-28,
  4.240813168487494e-16, -1.288339736262776e-16,  2.066738942761967e-17, -2.275699181041924e-18,  1.922184459048087e-19, -1.324272872120100e-20,  7.735791954776935e-22,
 -3.935044277056126e-23,  1.777183449748479e-24, -7.231707445854481e-26,  2.682123664388182e-27, -9.142426968191517e-29,  4.085439453614872e-17, -1.377628819974854e-17,
  2.455926657541652e-18, -2.993603265236987e-19,  2.786618798840040e-20, -2.106476449760412e-21,  1.344564288311406e-22, -7.444638354331365e-24,  3.646502866563910e-25,
 -1.603884083152170e-26,  6.409596509823590e-28, -2.346886046152768e-29,  4.644767168879419e-18, -1.715355431430234e-18,  3.359088328564443e-19, -4.485012245485193e-20,
  4.556097049934855e-21, -3.744271712740968e-22,  2.588784271450306e-23, -1.547224616818351e-24,  8.153826142028890e-26, -3.846778978027001e-27,  1.644135163331350e-28,
 -6.420046054195527e-30,  6.681851538778187e-19, -2.657890199140532e-19,  5.628569108090647e-20, -8.112080940261487e-21,  8.869379318635381e-22, -7.820892186607603e-23,
  5.784301004766419e-24, -3.687269893505052e-25,  2.066821163015586e-26, -1.034394400238843e-27,  4.678359124268695e-29, -1.928341774598048e-30,  1.259911958763817e-19,
 -5.290728719729047e-20,  1.187533958670427e-20, -1.812148004964854e-21,  2.093562374577565e-22, -1.946262055877565e-23,  1.514140113215930e-24, -1.013064215020450e-25,
  5.947561018003114e-27, -3.111409051007586e-28,  1.468163129672097e-29, -6.301537399612567e-31,  2.655581013022093e-20, -1.150515005667064e-20,  2.671655382456134e-21,
 -4.215788064576884e-22,  5.030712001745251e-23, -4.824354970113202e-24,  3.866559389960621e-25, -2.661674972518283e-26,  1.605743154290259e-27, -8.621784750443730e-29,
  4.170861495618253e-30, -1.833217478419075e-31,  7.916098404433454e-02, -2.608039181340679e-04,  8.950817551031269e-07, -3.178884098391688e-09,  1.156808995315310e-11,
 -4.289945878553884e-14,  1.602267285724272e-16, -6.060016246900011e-19,  2.265675704906084e-21, -8.713809565398896e-24,  3.154694171214869e-26, -1.291222856619974e-28,
  6.886499179742782e-02, -2.761617646549120e-04,  1.369675186667611e-06, -7.144844693435617e-09,  3.691247430678264e-11, -1.865945883629116e-13,  9.227190407411639e-16,
 -4.480786686952547e-18,  2.139204855070982e-20, -1.008684532825949e-22,  4.686070831847471e-25, -2.162561945428304e-27,  5.211133826471388e-02, -2.839790378093055e-04,
  2.015303252209144e-06, -1.372542543711804e-08,  8.837258094361203e-11, -5.451034365532651e-13,  3.251831139131395e-15, -1.887169467755794e-17,  1.069742200154460e-19,
 -5.940137369628472e-22,  3.238890647994197e-24, -1.737142043210301e-26,  3.429514964262761e-02, -2.616312730932199e-04,  2.434457643711910e-06, -2.027365307825644e-08,
  1.566520938882422e-10, -1.147131047793981e-12,  8.049368453806047e-15, -5.450144806136053e-17,  3.579561065981123e-19, -2.289155843307951e-21,  1.430031326624086e-23,
 -8.746118383342036e-26,  1.962393063906387e-02, -2.074890497043093e-04,  2.394988260708488e-06, -2.382653754101316e-08,  2.173112323277708e-10, -1.858196002281934e-12,
  1.508695262597826e-14, -1.173195424918456e-16,  8.794088028642416e-19, -6.384525176713011e-21,  4.506511066477317e-23, -3.101542529413200e-25,  9.760029985914548e-03,
 -1.397353175891004e-04,  1.944660855778572e-06, -2.284035656805779e-08,  2.429306155932774e-10, -2.396374551942472e-12,  2.225586216954819e-14, -1.966238177498565e-16,
  1.664910065689130e-18, -1.358749914246762e-20,  1.073464357609492e-22, -8.237814779799707e-25,  4.217652116949131e-03, -7.973299519900803e-05,  1.318398590396819e-06,
 -1.812423501092859e-08,  2.226822566609127e-10, -2.511591126033086e-12,  2.646157818824516e-14, -2.635266117443777e-16,  2.501911535742736e-18, -2.278877581090837e-20,
  2.001329003469960e-22, -1.701131066416969e-24,  1.583018248112710e-03, -3.861146601246221e-05,  7.523154662964587e-07, -1.201871289455091e-08,  1.693408573411317e-10,
 -2.169311286921955e-12,  2.576720090387899e-14, -2.875659585020997e-16,  3.043993026329913e-18, -3.077924935795505e-20,  2.989229701358062e-22, -2.800275331875875e-24,
  5.158897955433739e-04, -1.591210120199512e-05,  3.633457245917002e-07, -6.705454418484746e-09,  1.077405566711691e-10, -1.559661192767627e-12,  2.078704549193253e-14,
 -2.588057075414695e-16,  3.041449096221882e-18, -3.399992566918795e-20,  3.637197309986288e-22, -3.740842939152691e-24,  1.459457919316085e-04, -5.596247146642356e-06,
  1.491372744838621e-07, -3.163876314959306e-09,  5.772261346209688e-11, -9.405664356119167e-13,  1.401473632005751e-14, -1.939906913173324e-16,  2.522687387129136e-18,
 -3.107973688654683e-20,  3.651208808513320e-22, -4.110779286599358e-24,  3.584130100112624e-05, -1.684175422956583e-06,  5.219564285777746e-08, -1.267891758375507e-09,
  2.617813823172308e-11, -4.787058032933446e-13,  7.952177405134438e-15, -1.220553471699565e-16,  1.751985131364926e-18, -2.373122721035980e-20,  3.054540467582926e-22,
 -3.756154655804693e-24,  7.643044345700085e-06, -4.348368399922991e-07,  1.562270926845040e-08, -4.331705417875374e-10,  1.009564221520400e-11, -2.067088271538068e-13,
  3.820217188937769e-15, -6.489046856126796e-17,  1.026208903860677e-18, -1.525543646008705e-20,  2.147662426705722e-22, -2.879669916600994e-24,  1.416392017985155e-06,
 -9.658045809033722e-08,  4.011031809462479e-09, -1.266315807444680e-10,  3.325005840441936e-12, -7.609909756114951e-14,  1.562275857972384e-15, -2.932630577455248e-17,
  5.102830899958064e-19, -8.314585408010195e-21,  1.278664784278965e-22, -1.867166011079353e-24,  2.284490190409720e-07, -1.851051474014178e-08,  8.863263803376606e-10,
 -3.179993461824394e-11,  9.393526639128147e-13, -2.400263452786209e-14,  5.468022870296939e-16, -1.133234593097168e-17,  2.167607773031954e-19, -3.867897025211475e-21,
  6.492323442795494e-23, -1.031607433959702e-24,  3.215025921833179e-08, -3.073110634839250e-09,  1.692566842756897e-10, -6.890905736542158e-12,  2.287639078470030e-13,
 -6.521073988983009e-15,  1.647401062969139e-16, -3.767273643413674e-18,  7.917026433761292e-20, -1.546314011971441e-21,  2.831473609063879e-23, -4.893200039603200e-25,
  3.963725778012077e-09, -4.441760631335158e-10,  2.808033439556406e-11, -1.295770449650105e-12,  4.831121263991578e-14, -1.535611587069625e-15,  4.300556366001417e-17,
 -1.084858918085141e-18,  2.504252063597039e-20, -5.352479187165268e-22,  1.068950664900071e-23, -2.008603493473107e-25,  4.306990880118255e-10, -5.627607283933423e-11,
  4.075870334488638e-12, -2.129819037086235e-13,  8.914059712585379e-15, -3.158756861831676e-16,  9.805729989865745e-18, -2.728549695511475e-19,  6.918284050347556e-21,
 -1.618110977742992e-22,  3.524390820047005e-24, -7.200262746897250e-26,  4.161709459002295e-11, -6.309581307281904e-12,  5.225934404584233e-13, -3.089861569570560e-14,
  1.451265407501684e-15, -5.732711165043164e-17,  1.972702879599753e-18, -6.055610942255792e-20,  1.686685331972197e-21, -4.317389701182317e-23,  1.025662115333702e-24,
 -2.278307911715385e-26,  3.622510389822227e-12, -6.343370231204778e-13,  5.997324294895097e-14, -4.008968339845247e-15,  2.112386065528150e-16, -9.300889159041525e-18,
  3.548000404537707e-19, -1.201622649040301e-20,  3.677084695969534e-22, -1.030179037120199e-23,  2.669533173384953e-25, -6.447598574455510e-27,  2.893305448687440e-13,
 -5.824657486393521e-14,  6.273211139096816e-15, -4.736022189075151e-16,  2.798038269502912e-17, -1.372851776923590e-18,  5.804711521650458e-20, -2.168806683927234e-21,
  7.291068940113338e-23, -2.235594449844930e-24,  6.318492849370888e-26, -1.659075352219357e-27,  2.176150065531725e-14, -5.010951871372630e-15,  6.131922908556111e-16,
 -5.220221560723991e-17,  3.454428777562178e-18, -1.887289335410056e-19,  8.839652795920361e-21, -3.641730123851298e-22,  1.344321076481571e-23, -4.509074238786898e-25,
  1.389268809163942e-26, -3.963586519160931e-28,  1.597649656839312e-15, -4.182533725627934e-16,  5.794538266999462e-17, -5.548556308977890e-18,  4.104493303523909e-19,
 -2.492876380558466e-20,  1.291539325674004e-21, -5.859101904352974e-23,  2.371891542490260e-24, -8.691911687772416e-26,  2.915719778914425e-27, -9.026862305455699e-29,
  1.201871385453861e-16, -3.549886897124325e-17,  5.539073413108989e-18, -5.941234930427093e-19,  4.895817843677037e-20, -3.295252905431672e-21,  1.883029456131514e-22,
 -9.381093410669057e-24,  4.153879484872909e-25, -1.658852483129565e-26,  6.043443690362266e-28, -2.025266123387852e-29,  9.869814227381229e-18, -3.256149409545780e-18,
  5.678513727726502e-19, -6.777991856847214e-20,  6.185356003795267e-21, -4.588801630393387e-22,  2.877549825908975e-23, -1.566725401167502e-24,  7.552861968672739e-26,
 -3.272220516450194e-27,  1.289014680543071e-28, -4.655733457506397e-30,  9.558509243029048e-19, -3.476012192434598e-19,  6.699746341684869e-20, -8.810020947684401e-21,
  8.820972944061631e-22, -7.150479846186799e-23,  4.880067542179172e-24, -2.880998696630127e-25,  1.500679759780598e-26, -7.001942167963683e-28,  2.961375561509104e-29,
 -1.144885358264618e-30,  1.184889880971889e-19, -4.669244058765748e-20,  9.790989096023214e-21, -1.397700020429726e-21,  1.514332603741599e-22, -1.323828353769319e-23,
  9.711103518732510e-25, -6.142565264113322e-26,  3.417815076927314e-27, -1.698616041452085e-28,  7.631643922073293e-30, -3.125885013279562e-31,  1.979967554335689e-20,
 -8.277507135292832e-21,  1.849077968942676e-21, -2.808514686478860e-22,  3.230184949447872e-23, -2.990149881875429e-24,  2.316853509942471e-25, -1.544178056465082e-26,
  9.032535009667984e-28, -4.708861275463694e-29,  2.214594292671959e-30, -9.475446628760603e-32,  3.871872103093587e-21, -1.675112108479466e-21,  3.883855955867980e-22,
 -6.119261844991778e-23,  7.291338416714133e-24, -6.982291757657694e-25,  5.588410650125900e-26, -3.841908362229800e-27,  2.314829408731387e-28, -1.241402343411869e-29,
  5.998381717966549e-31, -2.633516595036818e-32,  7.813185244254019e-02, -2.537927678872911e-04,  8.580180302964083e-07, -3.000455262261272e-09,  1.074722192239785e-11,
 -3.924972258051843e-14,  1.442282202135815e-16, -5.382864085095704e-19,  1.973371106572230e-21, -7.560371004772999e-24,  2.624335212049234e-26, -1.128727949562790e-28,
  6.778173034364833e-02, -2.655375515266164e-04,  1.287361279721404e-06, -6.582938320179844e-09,  3.339225867814177e-11, -1.658807524735666e-13,  8.063195046447884e-16,
 -3.850901875617273e-18,  1.807645161901048e-20, -8.389665595860670e-23,  3.830319588421110e-25, -1.743531308703188e-27,  5.100665670951121e-02, -2.684921967428475e-04,
  1.858735407528337e-06, -1.239461324783906e-08,  7.821006910853565e-11, -4.730324607965988e-13,  2.768303311981383e-15, -1.576708825271568e-17,  8.774870349437453e-20,
 -4.785320784749565e-22,  2.563291864941212e-24, -1.350863889093073e-26,  3.328609301334437e-02, -2.430878158513367e-04,  2.205487938141308e-06, -1.794076067167479e-08,
  1.355240922298970e-10, -9.710367001679209e-13,  6.672048907796434e-15, -4.426211399942544e-17,  2.849787817413464e-19, -1.787233380682775e-21,  1.095375030516118e-23,
 -6.574223569340174e-26,  1.883056331376618e-02, -1.894164107283998e-04,  2.128766086753913e-06, -2.062825807185523e-08,  1.835176766286854e-10, -1.532549129657371e-12,
  1.216376154753301e-14, -9.253307314625788e-17,  6.789745568394620e-19, -4.827757984710357e-21,  3.339037435348769e-23, -2.252590939976439e-25,  9.230556131857635e-03,
 -1.252117535409328e-04,  1.692405451705362e-06, -1.930963405965076e-08,  1.999278870548675e-10, -1.922703158073242e-12,  1.742826133335940e-14, -1.504103957397027e-16,
  1.245048631938777e-18, -9.939293278465271e-21,  7.685339354299122e-23, -5.774973425366996e-25,  3.918517816456972e-03, -6.999880544497714e-05,  1.120732907289213e-06,
 -1.493102278858828e-08,  1.782472636010762e-10, -1.956717504409834e-12,  2.009057874646388e-14, -1.951820951745726e-16,  1.809234710927446e-18, -1.610134335862702e-20,
  1.382451951121620e-22, -1.149472009088271e-24,  1.439756948255190e-03, -3.312687167169452e-05,  6.230176985560360e-07, -9.625300497668186e-09,  1.315393840349801e-10,
 -1.637460478902733e-12,  1.892764109360354e-14, -2.058004696531545e-16,  2.124453801829032e-18, -2.096565741113608e-20,  1.988671870561140e-22, -1.820660952572149e-24,
  4.575837624313426e-04, -1.330009783914857e-05,  2.922755076307572e-07, -5.206324518991639e-09,  8.100163321232895e-11, -1.137770952277250e-12,  1.473734500787422e-14,
 -1.785484605963448e-16,  2.043989851861074e-18, -2.227837782614796e-20,  2.325521309729011e-22, -2.335462772320379e-24,  1.257269648538687e-04, -4.540633936547167e-06,
  1.161458759609033e-07, -2.374224904181071e-09,  4.187794816048111e-11, -6.612127721506741e-13,  9.563175321772339e-15, -1.286673011655950e-16,  1.628260744556448e-18,
 -1.954069891597847e-20,  2.238076844552507e-22, -2.458499489688559e-24,  2.985254124435715e-05, -1.321014231540086e-06,  3.920876616107954e-08, -9.163221665420771e-10,
  1.826539763780258e-11, -3.232414165022274e-13,  5.206192320802886e-15, -7.759221884868600e-17,  1.082835184483693e-18, -1.427536390674062e-20,  1.789998550118713e-22,
 -2.146104798387243e-24,  6.124239182972937e-06, -3.281859864662813e-07,  1.127201287867203e-08, -3.002890736034268e-10,  6.748368276435518e-12, -1.335698270705559e-13,
  2.390988297659810e-15, -3.940067544966309e-17,  6.053021831844144e-19, -8.751293492897947e-21,  1.199386515262808e-22, -1.567002410843334e-24,  1.085762123858435e-06,
 -6.976981550678447e-08,  2.766337042588129e-09, -8.381934920454042e-11,  2.119937349762611e-12, -4.685782463522770e-14,  9.309523083213812e-16, -1.694040840306426e-17,
  2.861461403671007e-19, -4.531635815741828e-21,  6.780638069636682e-23, -9.642958080382522e-25,  1.664892417196561e-07, -1.272313170005524e-08,  5.811088729745850e-10,
 -1.999295341456157e-11,  5.683944358762651e-13, -1.401596109570266e-14,  3.087896165789535e-16, -6.199837768613093e-18,  1.150564942709048e-19, -1.994478191728968e-21,
  3.255853954131988e-23, -5.036482139912660e-25,  2.211855536870045e-08, -1.996272420052017e-09,  1.048322113026245e-10, -4.090537402701421e-12,  1.306225725374280e-13,
 -3.591387354096855e-15,  8.770023660829809e-17, -1.942090011478291e-18,  3.958309964080545e-20, -7.508051513824849e-22,  1.336692958201090e-23, -2.248331966078104e-25,
  2.553705938777450e-09, -2.706048762687432e-10,  1.631237479622522e-11, -7.213104432188197e-13,  2.586180944042590e-14, -7.926693341437394e-16,  2.145309860672509e-17,
 -5.239504250986096e-19,  1.172810472181345e-20, -2.434059753861573e-22,  4.725908670506060e-24, -8.642706883162050e-26,  2.575029295126578e-10, -3.187595574743591e-11,
  2.202631397414854e-12, -1.103183575034712e-13,  4.440639073337163e-15, -1.517449391187470e-16,  4.552581693792336e-18, -1.226566806354658e-19,  3.015988126967843e-21,
 -6.850404625645026e-23,  1.450794217549515e-24, -2.885187510729566e-26,  2.285239930186468e-11, -3.290120426101599e-12,  2.602821186149984e-13, -1.476102118711064e-14,
  6.671508486168294e-16, -2.542513243816415e-17,  8.459129892078638e-19, -2.515235406796973e-20,  6.796761763532419e-22, -1.690227649199886e-23,  3.905956388143166e-25,
 -8.449540590884497e-27,  1.805723227938023e-12, -3.011402223718211e-13,  2.724133793776647e-14, -1.748867174667638e-15,  8.876750014722110e-17, -3.774268285903737e-18,
  1.393230056615468e-19, -4.574206557013803e-21,  1.359065502907229e-22, -3.702050022941866e-24,  9.338975377429734e-26, -2.198347846754661e-27,  1.292292053856962e-13,
 -2.486418219752347e-14,  2.568434223114134e-15, -1.865881744040194e-16,  1.063651777738062e-17, -5.047107549931911e-19,  2.067893719391219e-20, -7.499677348310010e-22,
  2.451012540628654e-23, -7.315905794149850e-25,  2.015300371925926e-26, -5.163414833217986e-28,  8.586600816326153e-15, -1.897722168267770e-15,  2.234467122667428e-16,
 -1.835363082201228e-17,  1.174655728738762e-18, -6.219846108048138e-20,  2.828613837594524e-21, -1.133290304403498e-22,  4.074304576434177e-24, -1.332645921241244e-25,
  4.008652508759057e-27, -1.117792442308410e-28,  5.487533034217922e-16, -1.385792096529616e-16,  1.854837537990182e-17, -1.719703098219151e-18,  1.234271240254264e-19,
 -7.286586221211664e-21,  3.675448043958578e-22, -1.625718437883128e-23,  6.425253236032818e-25, -2.301485895285309e-26,  7.554533766898888e-28, -2.290935338646729e-29,
  3.543543673846984e-17, -1.015504049920084e-17,  1.538468339672112e-18, -1.604864713241434e-19,  1.288311990393053e-20, -8.460286302081044e-22,  4.723441831758248e-23,
 -2.302016146704878e-24,  9.983001319656283e-26, -3.908618277574516e-27,  1.397419466780223e-28, -4.599916652910649e-30,  2.471062829322808e-18, -7.961188800970900e-19,
  1.355863258597066e-19, -1.582324267931929e-20,  1.413584370086224e-21, -1.027880329602652e-22,  6.324661097979813e-24, -3.382394773279105e-25,  1.603133834136928e-26,
 -6.834472859613071e-28,  2.651386678870641e-29, -9.438236212489108e-31,  2.024910079814501e-19, -7.240202276048269e-20,  1.371563163469825e-20, -1.773920160532345e-21,
  1.748438804136972e-22, -1.396429969430136e-23,  9.397506371058837e-25, -5.474715077270417e-26,  2.816069482878982e-27, -1.298356232441217e-28,  5.429398800987631e-30,
 -2.076623435738941e-31,  2.143468450193639e-20, -8.359464217933397e-21,  1.733970397979675e-21, -2.449468463217991e-22,  2.627501086805689e-23, -2.275330497614158e-24,
  1.654214929468915e-25, -1.037506411419461e-26,  5.726657466066946e-28, -2.824493926912226e-29,  1.259868894864853e-30, -5.125155996159215e-32,  3.144118090250160e-21,
 -1.307948054569997e-21,  2.906346762388212e-22, -4.391665390710108e-23,  5.026178760339711e-24, -4.630909098569515e-25,  3.572215917759657e-26, -2.370832387374425e-27,
  1.381244466304227e-28, -7.173344664712445e-30,  3.361452218560526e-31, -1.433310454560099e-32,  5.664797150997652e-22, -2.447028206702156e-22,  5.664049289702572e-23,
 -8.909232586889375e-24,  1.059860975621781e-24, -1.013366813263631e-25,  8.098622360766540e-27, -5.559688294291357e-28,  3.345248714273645e-29, -1.791645610195040e-30,
  8.646227805462763e-32, -3.791445384116343e-33,  7.713018567466140e-02, -2.470697807157534e-04,  8.230189911571731e-07, -2.834596592775091e-09,  9.995657246848674e-12,
 -3.596221829996092e-14,  1.300007435588293e-16, -4.793002036717095e-19,  1.718928839149691e-21, -6.606449877978133e-24,  2.152879446953731e-26, -1.024430532641396e-28,
  6.673969011329603e-02, -2.555458051188121e-04,  1.211465503894601e-06, -6.074187180426208e-09,  3.025975280793801e-11, -1.477603115602013e-13,  7.061586977595054e-16,
 -3.317966661716122e-18,  1.531441581873292e-20, -7.000658301846440e-23,  3.138794810329153e-25, -1.412658792202069e-27,  4.996151481182441e-02, -2.541966780587125e-04,
  1.717207310255108e-06, -1.121547205954136e-08,  6.937962771838299e-11, -4.115888617825968e-13,  2.363681074476425e-15, -1.321608151983870e-17,  7.223242875888742e-20,
 -3.869599215014733e-22,  2.036841401786099e-24, -1.054971186405193e-26,  3.234771622317208e-02, -2.262696277748104e-04,  2.002595313127885e-06, -1.591944428474358e-08,
  1.176093474709407e-10, -8.248056749097771e-13,  5.551279365220704e-15, -3.609302333740088e-17,  2.278748601106046e-19, -1.401855671624850e-21,  8.432002253734056e-24,
 -4.967230480174444e-26,  1.810545770487113e-02, -1.733287522380261e-04,  1.897882279201059e-06, -1.792216027477060e-08,  1.555881710888655e-10, -1.269406625485424e-12,
  9.852619667903836e-15, -7.334710209190722e-17,  5.270064387875977e-19, -3.671041019948433e-21,  2.488637385028363e-23, -1.646108355276668e-25,  8.755393169645643e-03,
 -1.125477736275727e-04,  1.478683826709753e-06, -1.639704886358374e-08,  1.653374137856864e-10, -1.550771259544616e-12,  1.372471935340920e-14, -1.157469085100643e-16,
  9.369498757439816e-19, -7.318814761086650e-21,  5.540393014298503e-23, -4.077671300150997e-25,  3.655384292850006e-03, -6.170396079782463e-05,  9.574609921990581e-07,
 -1.236769019201316e-08,  1.435236490709550e-10, -1.534082356405142e-12,  1.535594909997780e-14, -1.455853072339851e-16,  1.318034976024196e-18, -1.146437821109457e-20,
  9.626355766311616e-23, -7.831856272922429e-25,  1.316533642329506e-03, -2.857130357472037e-05,  5.191360608563654e-07, -7.759811819388623e-09,  1.029029833146599e-10,
 -1.245310180710901e-12,  1.401361797846155e-14, -1.485029476121734e-16,  1.495468524866839e-18, -1.440864981361044e-20,  1.335250308429908e-22, -1.195026517115142e-24,
  4.086930706612844e-04, -1.119137739783943e-05,  2.368827480995537e-07, -4.074699947249791e-09,  6.141350111272477e-11, -8.373574149119546e-13,  1.054484804338296e-14,
 -1.243611860609769e-16,  1.387286075381988e-18, -1.474729610600990e-20,  1.502532639902231e-22, -1.473827033237606e-24,  1.092571732155201e-04, -3.714968624838574e-06,
  9.127634564482867e-08, -1.798628137960074e-09,  3.068491720592930e-11, -4.696340767396878e-13,  6.595390233656363e-15, -8.628207757715388e-17,  1.062880075637492e-18,
 -1.242879429391235e-20,  1.388220386233814e-22, -1.488240773799710e-24,  2.513260163535200e-05, -1.046809999129273e-06,  2.977316885193855e-08, -6.696794192858320e-10,
  1.289246352639984e-11, -2.208779207482798e-13,  3.450338780791280e-15, -4.994795388809025e-17,  6.778827963761516e-19, -8.700189488058436e-21,  1.063019003759049e-22,
 -1.242911369998992e-24,  4.971372595334016e-06, -2.507726868094482e-07,  8.237393176614043e-09, -2.109076482756710e-10,  4.571635414062314e-12, -8.749701876782047e-14,
  1.517477406427021e-15, -2.426574911848454e-17,  3.622265813144031e-19, -5.094348863467761e-21,  6.798477684492776e-23, -8.656456142161938e-25,  8.453031784398780e-07,
 -5.114989308664818e-08,  1.936625304062778e-09, -5.632806066809441e-11,  1.372558483181003e-12, -2.930613522077068e-14,  5.635898107616812e-16, -9.943583529410310e-18,
  1.630788936517286e-19, -2.510598434462855e-21,  3.655621652939064e-23, -5.063813411150287e-25,  1.235681390329688e-07, -8.898272721321651e-09,  3.876681484099002e-10,
 -1.279084111469725e-11,  3.500217117577283e-13, -8.330437513242052e-15,  1.775140308334365e-16, -3.453285482237530e-18,  6.218469708807995e-20, -1.047301437380869e-21,
  1.662874104530860e-23, -2.504418026306242e-25,  1.554369743535590e-08, -1.323229439881586e-09,  6.624070946623156e-11, -2.477037767011425e-12,  7.608401161143290e-14,
 -2.017705425831192e-15,  4.762853314321855e-17, -1.021386686545448e-18,  2.019058242596900e-20, -3.719279462741617e-22,  6.438146796152156e-24, -1.054005344412334e-25,
  1.686009322746584e-09, -1.687394636607540e-10,  9.694844069397769e-12, -4.106909729638675e-13,  1.415788195644999e-14, -4.183890375952305e-16,  1.094189238428308e-17,
 -2.587074469827865e-19,  5.614959834178952e-21, -1.131473690347966e-22,  2.135588516275655e-24, -3.800810701309099e-26,  1.583004811673232e-10, -1.853950566814098e-11,
  1.221416100570385e-12, -5.860792756310338e-14,  2.268149868462213e-15, -7.472208459743840e-17,  2.166053613487087e-18, -5.649256352302590e-20,  1.346837274732249e-21,
 -2.970270233288945e-23,  6.115323056772243e-25, -1.183621004470202e-26,  1.294759373647603e-11, -1.767438435963766e-12,  1.334272552132321e-13, -7.253060351717229e-15,
  3.152792650855867e-16, -1.158677927468935e-17,  3.725728621822756e-19, -1.072658728728172e-20,  2.811149741087319e-22, -6.789576328268186e-24,  1.525770948446232e-25,
 -3.213379246118106e-27,  9.318932946215086e-13, -1.477520081391363e-13,  1.277340164541249e-14, -7.868544811372215e-16,  3.844333369241366e-17, -1.577405571739107e-18,
  5.631314869950270e-20, -1.791339997301702e-21,  5.165048459298718e-23, -1.367300560864196e-24,  3.356292167241932e-26, -7.696678559477318e-28,  5.994378113054113e-14,
 -1.100168353597847e-14,  1.088466465854448e-15, -7.600208004172398e-17,  4.176300157561376e-18, -1.914841529649004e-19,  7.596401902456710e-21, -2.672294210421658e-22,
  8.484547844406519e-24, -2.463756580510891e-25,  6.610895375119380e-27, -1.651783162747484e-28,  3.527145371712601e-15, -7.466424262924547e-16,  8.445225187786377e-17,
 -6.683748976922904e-18,  4.132289609551799e-19, -2.118370096150679e-20,  9.344793622949909e-22, -3.637819632036617e-23,  1.272640405946057e-24, -4.056025641061230e-26,
  1.190266192683026e-27, -3.241589849026437e-29,  1.964606853639906e-16, -4.775487607911925e-17,  6.164153113276281e-18, -5.524993202196246e-19,  3.842078016608530e-20,
 -2.201958116783733e-21,  1.080132174774717e-22, -4.653318705677103e-24,  1.793736902217257e-25, -6.274372307894336e-27,  2.013523923558704e-28, -5.976046253298348e-30,
  1.088265351071210e-17, -3.019462879188692e-18,  4.433092518341999e-19, -4.489982849080735e-20,  3.505987721110486e-21, -2.243267054553931e-22,  1.222116583445173e-23,
 -5.819803063654735e-25,  2.469104475311533e-26, -9.468149977445663e-28,  3.318764057468225e-29, -1.072084307950541e-30,  6.423056604915656e-19, -2.016835904633212e-19,
  3.348343691980752e-20, -3.814263182049054e-21,  3.330808799360247e-22, -2.370607736510286e-23,  1.429464967037045e-24, -7.500055757359475e-26,  3.491064038598820e-27,
 -1.463013765996657e-28,  5.584022676051265e-30, -1.957288986065854e-31,  4.424831708939457e-20, -1.553044866763258e-20,  2.887090943916700e-21, -3.667363356376198e-22,
  3.553624903754511e-23, -2.792919418808766e-24,  1.851234325828964e-25, -1.063121651671916e-26,  5.394774995517141e-28, -2.455517299690386e-29,  1.014396566299865e-30,
 -3.835291076687869e-32,  3.962725861179485e-21, -1.527773966980744e-21,  3.131267637536898e-22, -4.372581738718275e-23,  4.639269732849641e-24, -3.976028279052048e-25,
  2.862478137563992e-26, -1.778764844006050e-27,  9.732474178530062e-29, -4.760569435230287e-30,  2.106821782149433e-31, -8.507002288939620e-33,  5.050475720312474e-22,
 -2.089429518769664e-22,  4.615641102289735e-23, -6.934781726318342e-24,  7.893569834157350e-25, -7.235252995698811e-26,  5.553854509741117e-27, -3.668924389480566e-28,
  2.128113838814813e-29, -1.100604022849362e-30,  5.137050074673436e-32, -2.182203481277506e-33,  8.319384210305602e-23, -3.587657914910453e-23,  8.288906096947986e-24,
 -1.301426569899981e-24,  1.545482695819947e-25, -1.475191020961704e-26,  1.177036320035307e-27, -8.067820346165434e-29,  4.847187973299941e-30, -2.592366443422699e-31,
  1.249336637533270e-32, -5.471318166168721e-34,  7.615486319394023e-02, -2.406190241875927e-04,  7.899402169942458e-07, -2.680254964652935e-09,  9.306557218187187e-12,
 -3.299724370739969e-14,  1.173157982813132e-16, -4.279423047155665e-19,  1.495526509450993e-21, -5.833859753695980e-24,  1.712605203215459e-26, -9.900853949349047e-29,
  6.573644003364042e-02, -2.461376301855241e-04,  1.141385571035757e-06, -5.612782574150431e-09,  2.746677613584375e-11, -1.318742076685162e-13,  6.197542101279075e-16,
 -2.865922619200293e-18,  1.300594093405289e-20, -5.861323497395926e-23,  2.576845913738545e-25, -1.152044853204832e-27,  4.897137688211573e-02, -2.409790971728698e-04,
  1.589020092528178e-06, -1.016829127125275e-08,  6.168645710300770e-11, -3.590522582435266e-13,  2.024003757144141e-15, -1.111267268562511e-17,  5.966310334649584e-20,
 -3.140566170224993e-22,  1.624887906014328e-24, -8.272866644107661e-27,  3.147351292562867e-02, -2.109822171748284e-04,  1.822330651503344e-06, -1.416275412100864e-08,
  1.023677508359379e-10, -7.029226360594462e-13,  4.635616285915206e-15, -2.954744551174012e-17,  1.829872198738556e-19, -1.104511967795143e-21,  6.522133827487199e-24,
 -3.771664882579642e-26,  1.744120403125205e-02, -1.589654870744129e-04,  1.696954800767664e-06, -1.562367225996046e-08,  1.324076705109160e-10, -1.055798304027210e-12,
  8.016423925385562e-15, -5.841860828253963e-17,  4.111499071297818e-19, -2.806566315114390e-21,  1.865437275543552e-23, -1.210071189030033e-25,  8.327675362552713e-03,
 -1.014626357127803e-04,  1.296823225664862e-06, -1.398292054113785e-08,  1.373699368954529e-10, -1.257109932162841e-12,  1.086680772044942e-14, -8.958519966525769e-17,
  7.093894156954187e-19, -5.423690176177224e-21,  4.020867933713014e-23, -2.899293126981723e-25,  3.423000075743813e-03, -5.460109181537875e-05,  8.218757586733685e-07,
 -1.029804568790109e-08,  1.162203470770525e-10, -1.210046585691672e-12,  1.181292714554169e-14, -1.093310258075775e-16,  9.670578557084274e-19, -8.223711788915093e-21,
  6.755145857134468e-23, -5.379158719352332e-25,  1.210002019891888e-03, -2.476447723582279e-05,  4.351306528667722e-07, -6.295662211703255e-09,  8.104928323985557e-11,
 -9.539175548391260e-13,  1.045431961518434e-14, -1.080112335913728e-16,  1.061445335031793e-18, -9.987685586797494e-21,  9.045227631044800e-23, -7.916008369161946e-25,
  3.674300183436210e-04, -9.476385517430119e-06,  1.933708998270852e-07, -3.213410199902718e-09,  4.693905062265325e-11, -6.215020130549698e-13,  7.612015989092182e-15,
 -8.741846275427926e-17,  9.505723069379031e-19, -9.858407739440823e-21,  9.806630558502519e-23, -9.397928489645952e-25,  9.573193209716362e-05, -3.063407494983822e-06,
  7.235437172415570e-08, -1.374967726849294e-09,  2.269768026144099e-11, -3.368701777804718e-13,  4.595355786742363e-15, -5.847336347604090e-17,  7.013992809534535e-19,
 -7.994032476895837e-21,  8.709832830771763e-23, -9.115012896674426e-25,  2.137537891387823e-05, -8.375712072091362e-07,  2.284228649353282e-08, -4.946760704476329e-10,
  9.201243563214882e-12, -1.526635876396081e-13,  2.313686849661175e-15, -3.254258622878955e-17,  4.296417240612596e-19, -5.369656933346618e-21,  6.394626420232139e-23,
 -7.293195651236167e-25,  4.085646223433567e-06, -1.938748212837642e-07,  6.093461325888698e-09, -1.499916585999231e-10,  3.136967930650746e-12, -5.807342809716749e-14,
  9.760938381922792e-16, -1.515043410903319e-17,  2.198055454358667e-19, -3.007855150298744e-21,  3.909405667544985e-23, -4.852274663741725e-25,  6.678825001638609e-07,
 -3.802750257088244e-08,  1.375257482295974e-09, -3.840621747612428e-11,  9.018720692219317e-13, -1.860573648408061e-14,  3.464263871136206e-16, -5.927451175402156e-18,
  9.440632009756570e-20, -1.413103910275924e-21,  2.002634198111333e-23, -2.702489438230596e-25,  9.332506204734918e-08, -6.326988576696119e-09,  2.629508915034346e-10,
 -8.321120198362777e-12,  2.192136978285641e-13, -5.036275211903876e-15,  1.038166557373718e-16, -1.957100007764887e-18,  3.420139906885166e-20, -5.597020226764420e-22,
  8.644632925109349e-24, -1.267721987336479e-25,  1.114800412788403e-08, -8.942135707823548e-10,  4.266609875413407e-11, -1.528971544344413e-12,  4.517488369848676e-14,
 -1.155593716368372e-15,  2.637012154694857e-17, -5.476661970271621e-19,  1.050067866653645e-20, -1.878631803721971e-22,  3.161986239979695e-24, -5.038600912612578e-26,
  1.139658085573837e-09, -1.075970808735069e-10,  5.889846079522252e-12, -2.389794832508468e-13,  7.920279932476097e-15, -2.256519443421678e-16,  5.702190307493334e-18,
 -1.305133099219352e-19,  2.746466160637080e-21, -5.373384571744240e-23,  9.858717544792408e-25, -1.707464485118192e-26,  9.997237801498024e-11, -1.106200097713650e-11,
  6.944130205885635e-13, -3.190989449243916e-14,  1.186955172249162e-15, -3.768959666338645e-17,  1.055442610306200e-18, -2.664221348958179e-20,  6.157575547868577e-22,
 -1.318311302081815e-23,  2.638213650673965e-25, -4.968933941794364e-27,  7.562726711362361e-12, -9.773084214284691e-13,  7.034324883763556e-14, -3.662997928370103e-15,
  1.530622421884047e-16, -5.422358811891577e-18,  1.684491648052415e-19, -4.694365201220351e-21,  1.192801497285469e-22, -2.797171108751560e-24,  6.110989796753583e-26,
 -1.252666827578515e-27,  4.975717683059567e-13, -7.487059080978095e-14,  6.178870026981511e-15, -3.649100631813134e-16,  1.714897829127517e-17, -6.786446957186122e-19,
  2.341811170786487e-20, -7.214096304710442e-22,  2.017675356763183e-23, -5.188488299272679e-25,  1.238785836790294e-26, -2.766390266708834e-28,  2.886428317997195e-14,
 -5.043502349877103e-15,  4.772540106965072e-16, -3.199456605501926e-17,  1.693123690205648e-18, -7.495016394047324e-20,  2.876847970772127e-21, -9.809820401215020e-23,
  3.023937668973383e-24, -8.537489159764382e-26,  2.230170175219736e-27, -5.431141835911674e-29,  1.508290768331038e-15, -3.051629997155062e-16,  3.310417699174660e-17,
 -2.520970507709226e-18,  1.503882847005263e-19, -7.456176507353487e-21,  3.187485788499477e-22, -1.204608643997473e-23,  4.097421325535851e-25, -1.271475773867240e-26,
  3.637454063642965e-28, -9.668600445671981e-30,  7.335028900238797e-17, -1.712345158462415e-17,  2.127664293173632e-18, -1.840745988247827e-19,  1.238531107025247e-20,
 -6.882400726634841e-22,  3.279416359247862e-23, -1.374603997588201e-24,  5.162969243624080e-26, -1.761997629375453e-27,  5.523340799511023e-29, -1.603071841088816e-30,
  3.485391752325690e-18, -9.341423568732618e-19,  1.326531432275673e-19, -1.302272966994241e-20,  9.876114243369354e-22, -6.148355733476020e-23,  3.264326416624327e-24,
 -1.517122555883283e-25,  6.289996521648346e-27, -2.359877827441568e-28,  8.101853791461939e-30, -2.566051549220550e-31,  1.736406956947718e-19, -5.302585752315208e-20,
  8.565170196021758e-21, -9.507545720386269e-22,  8.102886524559150e-23, -5.636578545116501e-24,  3.326391986841240e-25, -1.710151879230280e-26,  7.808689638390158e-28,
 -3.213350118154897e-29,  1.205450870948063e-30, -4.156566961552077e-32,  9.995056029209746e-21, -3.437427369471144e-21,  6.260174639770596e-22, -7.797955455146610e-23,
  7.417890807720063e-24, -5.729472299142658e-25,  3.735932033132924e-26, -2.112528533079572e-27,  1.056438422559586e-28, -4.742479995879537e-30,  1.933643778279352e-31,
 -7.220639314911710e-33,  7.501648833444730e-22, -2.855461495691296e-22,  5.775568320082425e-23, -7.963342948335570e-24,  8.347956613247063e-25, -7.073676564850689e-26,
  5.038269738198602e-27, -3.099287205377067e-28,  1.679627542206734e-29, -8.141795061144474e-31,  3.572478817893187e-32, -1.430874715959829e-33,  8.216494016792057e-23,
 -3.378345960558915e-23,  7.414249933376413e-24, -1.106913137146734e-24,  1.252364933117172e-25, -1.141367739604347e-26,  8.713944931709833e-28, -5.727098046375395e-29,
  3.305868613718761e-30, -1.701877412444866e-31,  7.909000106115801e-33, -3.345919368861817e-34,  1.226880265042001e-23, -5.280939685900425e-24,  1.217629151915287e-24,
 -1.907959799004743e-25,  2.261395264478612e-26, -2.154558670304107e-27,  1.716061198019473e-28, -1.174264538891536e-29,  7.043666575141525e-31, -3.761275671408759e-32,
  1.809993479808312e-33, -7.915479215758722e-35,  7.520482595010373e-02, -2.344256724881293e-04,  7.586492933696846e-07, -2.536480607512426e-09,  8.673824703928056e-12,
 -3.032023488147956e-14,  1.059727298316766e-16, -3.833221142835403e-19,  1.296780398992464e-21, -5.236987524418696e-24,  1.267073535383555e-26, -1.055321601350493e-28,
  6.476973539997823e-02, -2.372686835480295e-04,  1.076584498955051e-06, -5.193632331472665e-09,  2.497176811314466e-11, -1.179179081134020e-13,  5.450314513784870e-16,
 -2.481599674252614e-18,  1.106976726081337e-20, -4.925603848205687e-23,  2.116532342305905e-25, -9.489918844307608e-28,  4.803213501380488e-02, -2.287387648193220e-04,
  1.472693792053991e-06, -9.236219058745915e-09,  5.496704152967028e-11, -3.140042996130742e-13,  1.737963793977382e-15, -9.372484226182752e-18,  4.944433470044867e-20,
 -2.557903950992968e-22,  1.301226606777067e-24, -6.513013021606160e-27,  3.065770292642379e-02, -1.970565706516120e-04,  1.661759817111630e-06, -1.263156272649487e-08,
  8.935810248013361e-11, -6.009691225827596e-13,  3.884629498034895e-15, -2.428077595010225e-17,  1.475468062321009e-19, -8.739967696194065e-22,  5.068674388826390e-24,
 -2.877300026365447e-26,  1.683135477170990e-02, -1.461053096051165e-04,  1.521517446804737e-06, -1.366415438802836e-08,  1.130904581288364e-10, -8.816345193865189e-13,
  6.550678375023966e-15, -4.674418107819389e-17,  3.223541616696940e-19, -2.156852449673200e-21,  1.406067840511815e-23, -8.946183651239064e-26,  7.941561631180529e-03,
 -9.172368826852854e-05,  1.141429677928182e-06, -1.197277772998007e-08,  1.146451228712173e-10, -1.024011925048982e-12,  8.648952174133392e-15, -6.972170250363065e-17,
  5.402566746793391e-19, -4.044090342531914e-21,  2.937018390124402e-23, -2.075314798888723e-25,  3.217005392886159e-03, -4.849052411983772e-05,  7.087049310333965e-07,
 -8.617704778752701e-09,  9.462353105264663e-11, -9.600306710915628e-13,  9.143859835284204e-15, -8.264353470243781e-17,  7.144327700534564e-19, -5.941562706128359e-21,
  4.775896855553541e-23, -3.723307509215207e-25,  1.117457048001635e-03, -2.156494461835131e-05,  3.667753588048397e-07, -5.138831291769770e-09,  6.425351161915830e-11,
 -7.357763249652137e-13,  7.856089320160662e-15, -7.916244368138674e-17,  7.594136915098301e-19, -6.980737380088091e-21,  6.180178853833196e-23, -5.290302713702040e-25,
  3.323910470817110e-04, -8.071778675104704e-06,  1.589359543955585e-07, -2.552673975469877e-09,  3.615409434516249e-11, -4.650517013396615e-13,  5.541764594779264e-15,
 -6.199559626646741e-17,  6.573330293114412e-19, -6.652965684800815e-21,  6.463331474704900e-23, -6.053096577012916e-25,  8.453956121836063e-05, -2.544872903374833e-06,
  5.782939462492535e-08, -1.060225947286433e-09,  1.694260553663744e-11, -2.439361111238735e-13,  3.233439775571794e-15, -4.003205548668341e-17,  4.677297973424550e-19,
 -5.197318389835132e-21,  5.525333390266148e-23, -5.646149326348395e-25,  1.835622556994481e-05, -6.762885075132472e-07,  1.769772419884099e-08, -3.691492801858803e-10,
  6.636780865622969e-12, -1.066782324686550e-13,  1.569100051064689e-15, -2.144990794960284e-17,  2.755651211070705e-19, -3.354664729877266e-21,  3.894804680958908e-23,
 -4.334077296212877e-25,  3.397340778029761e-06, -1.515541392978672e-07,  4.560142634962771e-09, -1.079502093475887e-10,  2.179120064732000e-12, -3.903311871854546e-14,
  6.360079106971243e-16, -9.584713757598006e-18,  1.351862833999941e-19, -1.800388347776083e-21,  2.279550963899690e-23, -2.758557108247162e-25,  5.351701529369209e-07,
 -2.864923489178309e-08,  9.900054978541400e-10, -2.655228177772589e-11,  6.010394321008159e-13, -1.198375748879683e-14,  2.160847961104053e-16, -3.586402168699889e-18,
  5.548351431616821e-20, -8.076394234533201e-22,  1.114215757815256e-23, -1.465049120923924e-25,  7.166700724246731e-08, -4.570028917848571e-09,  1.812105153292845e-10,
 -5.500751712723325e-12,  1.395335319151365e-13, -3.095065654362297e-15,  6.173024058986691e-17, -1.127881396384328e-18,  1.913120330350120e-20, -3.042587062861217e-22,
  4.571854018770334e-24, -6.529082483146932e-26,  8.152889798167734e-09, -6.155443056834605e-10,  2.799116435066815e-11, -9.612846509272773e-13,  2.732231448004517e-14,
 -6.742291065173996e-16,  1.487482130789207e-17, -2.992091439294294e-19,  5.564867515212170e-21, -9.669984491271334e-23,  1.582664469318551e-24, -2.454885500457752e-26,
  7.879881513038262e-10, -7.009520828111410e-11,  3.654585066020190e-12, -1.420079528112759e-13,  4.524388971686536e-15, -1.242683706632418e-16,  3.034214285688701e-18,
 -6.722814290287159e-20,  1.371664006144724e-21, -2.605503611382620e-23,  4.646822955272435e-25, -7.831590204587206e-27,  6.479999270711631e-11, -6.764980474355843e-12,
  4.044174968568598e-13, -1.779120189690316e-14,  6.359260269037638e-16, -1.945924125348929e-17,  5.263409183382291e-19, -1.285756963493505e-20,  2.880450176636953e-22,
 -5.986105376798491e-24,  1.164270558956047e-25, -2.133613265795828e-27,  4.550067008718352e-12, -5.557623294538863e-13,  3.810828948466660e-14, -1.899897118530758e-15,
  7.628412510931113e-17, -2.604082138308719e-18,  7.813301141935816e-20, -2.107075016264380e-21,  5.189532970523358e-23, -1.181312876998400e-24,  2.508422531333075e-26,
 -5.003519585765118e-28,  2.746572605610157e-13, -3.915337551512237e-14,  3.081235818658544e-15, -1.743191414184711e-16,  7.874885244872174e-18, -3.003944973403864e-19,
  1.001458162743208e-20, -2.986288157882695e-22,  8.098308887537532e-24, -2.022152829818275e-25,  4.694253592416953e-27, -1.020470261799226e-28,  1.442058065613354e-14,
 -2.394179012585108e-15,  2.163969237617237e-16, -1.391350326709432e-17,  7.084556202094916e-19, -3.025559121025073e-20,  1.122844409628138e-21, -3.708999675618997e-23,
  1.109379219545317e-24, -3.043577726332380e-26,  7.735851798687770e-28, -1.835276571544266e-29,  6.713361207127933e-16, -1.295407849242725e-16,  1.345584829447351e-17,
 -9.846929479691735e-19,  5.661510266758728e-20, -2.712009267852100e-21,  1.122519957494804e-22, -4.114868930626514e-24,  1.359826213212171e-25, -4.105499623803749e-27,
  1.144196701021286e-28, -2.966414947837778e-30,  2.857057135886837e-17, -6.390748171888224e-18,  7.629921795329631e-19, -6.361598268040249e-20,  4.135848325062014e-21,
 -2.225644424369869e-22,  1.029001782604660e-23, -4.192225419563127e-25,  1.532764049978743e-26, -5.098981976860812e-28,  1.559982568650677e-29, -4.423980134806771e-31,
  1.165304184152031e-18, -3.009784448041090e-19,  4.125708751500555e-20, -3.918974930418566e-21,  2.882040367425013e-22, -1.743267521859687e-23,  9.008269576862273e-25,
 -4.081141528983989e-26,  1.651684030058152e-27, -6.056569348738000e-29,  2.034597624177636e-30, -6.312252449205941e-32,  4.890601641086184e-20, -1.449150566323018e-20,
  2.272856689373943e-21, -2.453983259108748e-22,  2.037820482635252e-23, -1.383438785722015e-24,  7.979318125384333e-26, -4.014625373934253e-27,  1.796073624784325e-28,
 -7.249562154273069e-30,  2.670198594952093e-31, -9.048576366149131e-33,  2.338963265313605e-21, -7.866408879056538e-22,  1.400908831745409e-22, -1.708358047647891e-23,
  1.592929657686247e-24, -1.207446563319377e-25,  7.735174581314370e-27, -4.301631483306044e-28,  2.117578733775958e-29, -9.365655885291821e-31,  3.765215048366783e-32,
 -1.387389856539908e-33,  1.457216634585253e-22, -5.468664592452968e-23,  1.090072773758432e-23, -1.482109281827938e-24,  1.533281842097103e-25, -1.283144132845100e-26,
  9.032622705097249e-28, -5.495268025864745e-29,  2.947173405479485e-30, -1.414586382269893e-31,  6.149333852428346e-33, -2.441369994068807e-34,  1.355675882601610e-23,
 -5.535703254684592e-24,  1.206052087572426e-24, -1.787918732288203e-25,  2.009338428264788e-26, -1.819676810141599e-27,  1.380966977513706e-28, -9.025011189962964e-30,
  5.181779126080594e-31, -2.654166178867375e-32,  1.227568146320053e-33, -5.169854115231725e-35,  1.817609380302566e-24, -7.807489614084802e-25,  1.796142464956333e-25,
 -2.808266869553223e-26,  3.321431431197424e-27, -3.158108549852086e-28,  2.510507949454610e-29, -1.714721513419605e-30,  1.026743677607574e-31, -5.473545239097458e-33,
  2.629744236898034e-34, -1.148283704680751e-35,  7.427907214741515e-02, -2.284759151367514e-04,  7.290246397522100e-07, -2.402416028452532e-09,  8.092007593900336e-12,
 -2.790116737386064e-14,  9.579296909940336e-17, -3.447531956517151e-19,  1.116207836811570e-21, -4.828223034753438e-24,  7.603610297880832e-27, -1.282135460065655e-28,
  6.383750066024063e-02, -2.288986843195235e-04,  1.016582614247314e-06, -4.812263111047208e-09,  2.273878935657208e-11, -1.056325244941737e-13,  4.802505335986165e-16,
 -2.154183337734644e-18,  9.439325414258062e-21, -4.157646339803001e-23,  1.734412147791604e-25, -7.957684311773486e-28,  4.714006159865387e-02, -2.173860649552049e-04,
  1.366935861372633e-06, -8.404806892368522e-09,  4.908369922781278e-11, -2.752716953997259e-13,  1.496369461706494e-15, -7.928089778683189e-18,  4.110763565925323e-20,
 -2.090455501950939e-22,  1.045957419454549e-24, -5.146539770044752e-27,  2.989513795139558e-02, -1.843453833940757e-04,  1.518378602015619e-06, -1.129314450279985e-08,
  7.821860119753175e-11, -5.153905586301760e-13,  3.266403948049402e-15, -2.002591682862845e-17,  1.194468094390262e-19, -6.944509469605516e-22,  3.957558892661903e-24,
 -2.204410961171943e-26,  1.627028106395797e-02, -1.345595755510390e-04,  1.367848902053938e-06, -1.198765141217188e-08,  9.692964799431030e-11, -7.390266975622514e-13,
  5.375314599267170e-15, -3.756989910747353e-17,  2.539498386470344e-19, -1.665864485231529e-21,  1.065568796430261e-23, -6.649885744477494e-26,  7.592061881899887e-03,
 -8.313724708525499e-05,  1.008121229669551e-06, -1.029164968864035e-08,  9.609205770028681e-11, -8.380368339296805e-13,  6.918411607513445e-15, -5.455286778958031e-17,
  4.137869620569128e-19, -3.033357737184124e-21,  2.158816512580390e-23, -1.495123791475877e-25,  3.033762134310071e-03, -4.321018240605431e-05,  6.137792929786173e-07,
 -7.246152292068072e-09,  7.744256666048020e-11, -7.659480836690438e-13,  7.120205145435270e-15, -6.286513384729661e-17,  5.313112715161845e-19, -4.322543297217480e-21,
  3.401069143450220e-23, -2.596520438484464e-25,  1.036698402449086e-03, -1.886098406870621e-05,  3.108233457544836e-07, -4.218962014254760e-09,  5.125717136527815e-11,
 -5.712989344563252e-13,  5.945133493471482e-15, -5.844707068961770e-17,  5.475144901447517e-19, -4.918196695295678e-21,  4.257756672529686e-23, -3.565907906581734e-25,
  3.024659114028675e-04, -6.913648171673884e-06,  1.314896185018023e-07, -2.041940380451886e-09,  2.805388399176506e-11, -3.507076295039875e-13,  4.067644229070929e-15,
 -4.434188018743077e-17,  4.585879702987619e-19, -4.530983698621401e-21,  4.300196700568853e-23, -3.936735122389420e-25,  7.521081219828429e-05, -2.128865368076708e-06,
  4.658486099482758e-08, -8.243103808734019e-10,  1.275717536264495e-11, -1.782517713123925e-13,  2.296738477934771e-15, -2.767606407165379e-17,  3.150708281880886e-19,
 -3.414319880937272e-21,  3.542746094802383e-23, -3.535853700031648e-25,  1.590853011295576e-05, -5.507704781334195e-07,  1.384076632671771e-08, -2.781708034362018e-10,
  4.835864439772170e-12, -7.533225258114058e-14,  1.075745831804004e-15, -1.429714641965262e-17,  1.787810126454288e-19, -2.120564648458159e-21,  2.400874136565510e-23,
 -2.607324225519566e-25,  2.856647121541567e-06, -1.197162494713421e-07,  3.450630584328284e-09, -7.858339432945151e-11,  1.531654839601984e-12, -2.655469700988597e-14,
  4.195850600105322e-16, -6.141077832441106e-18,  8.422761554390472e-20, -1.091973478041323e-21,  1.347181922787282e-23, -1.589834767586331e-25,  4.346042271376761e-07,
 -2.185675830691607e-08,  7.219960696162922e-10, -1.860212665895473e-11,  4.060238179580636e-13, -7.826200830988431e-15,  1.366984294232685e-16, -2.201316985599147e-18,
  3.308709787221484e-20, -4.684734748483218e-22,  6.292841976566235e-24, -8.063613630821380e-26,  5.591618036731015e-08, -3.350657946509095e-09,  1.267881168929516e-10,
 -3.692540546998129e-12,  9.020820218738061e-14, -1.932315020965393e-15,  3.729613160786657e-17, -6.605878233808344e-19,  1.087761121904775e-20, -1.681482415452991e-22,
  2.458476564723559e-24, -3.419537211771144e-26,  6.074797282689285e-09, -4.312365958627868e-10,  1.868953726986549e-11, -6.151312377655575e-13,  1.682086704175529e-14,
 -4.004720764782070e-16,  8.542913375744608e-18, -1.664555203332499e-19,  3.003329295709771e-21, -5.069471592160468e-23,  8.068789381454268e-25, -1.218362202848925e-26,
  5.568053035207005e-10, -4.661030784108941e-11,  2.314074534061425e-12, -8.610479072218733e-14,  2.637133899883342e-15, -6.982931111613741e-17,  1.647458463312439e-18,
 -3.533625163273228e-20,  6.990414240661442e-22, -1.289210535490530e-23,  2.235035571310091e-25, -3.665573075794198e-27,  4.306877606044008e-11, -4.236304775246657e-12,
  2.410578060358865e-13, -1.014944765154606e-14,  3.485439672939544e-16, -1.027664879396671e-17,  2.684568725357350e-19, -6.345733460267744e-21,  1.377867865096290e-22,
 -2.779268246244034e-24,  5.253158664623103e-26, -9.365964748737525e-28,  2.817159562392251e-12, -3.247254936396684e-13,  2.119648219276084e-14, -1.011244899749034e-15,
  3.900079227224076e-17, -1.282521166485685e-18,  3.715624548437898e-20, -9.694241571246311e-22,  2.313796743662578e-23, -5.111615477901733e-25,  1.054752043532671e-26,
 -2.046871789281708e-28,  1.566091448199003e-13, -2.111283433704358e-14,  1.582771415251914e-15, -8.571613860830325e-17,  3.720104288300275e-18, -1.367200144075063e-19,
  4.401646960631094e-21, -1.270020647140661e-22,  3.338154351752939e-24, -8.091041746630541e-26,  1.825613352586302e-27, -3.862052594803899e-29,  7.470352143986602e-15,
 -1.176126901531444e-15,  1.014051966329548e-16, -6.246985653499860e-18,  3.058101513441278e-19, -1.259051660111507e-20,  4.514913813509804e-22, -1.443861846560871e-23,
  4.188164596503895e-25, -1.115968725385925e-26,  2.758539070630030e-28, -6.372479288803957e-30,  3.109326523216192e-16, -5.709501180499970e-17,  5.669794888484240e-18,
 -3.982057027374351e-19,  2.204209220633753e-20, -1.019185451801342e-21,  4.080864842855410e-23, -1.449886620114025e-24,  4.651612733625698e-26, -1.365430517403062e-27,
  3.704788032326262e-29, -9.362379985839567e-31,  1.161250751515015e-17, -2.482955522873801e-18,  2.843089571005750e-19, -2.280974506299088e-20,  1.430935344096601e-21,
 -7.448143908162626e-23,  3.337630735894133e-24, -1.320314909255310e-25,  4.694725582688793e-27, -1.521033622018405e-28,  4.537887985552351e-30, -1.256452902231642e-31,
  4.070898493476368e-19, -1.010746933041637e-19,  1.334667625170210e-20, -1.224524801880116e-21,  8.718818086002532e-23, -5.116799416462682e-24,  2.570140498478230e-25,
 -1.133682885587483e-26,  4.473726236160246e-28, -1.601684419539427e-29,  5.259677137448252e-31, -1.596930510275726e-32,  1.437452269742270e-20, -4.122882567544950e-21,
  6.265368084316585e-22, -6.567429679626157e-23,  5.304901563263553e-24, -3.509299613390234e-25,  1.975421620258749e-26, -9.713787565450624e-28,  4.252793494746222e-29,
 -1.681801934194003e-30,  6.075501955137595e-32, -2.021308019450901e-33,  5.683111558423721e-22, -1.865123682117194e-22,  3.241617776563793e-23, -3.863016292141790e-24,
  3.524949566488704e-25, -2.618252231465159e-26,  1.645632211303154e-27, -8.988784285049189e-29,  4.350675099762581e-30, -1.893701949422048e-31,  7.498832104326764e-33,
 -2.723891862805937e-34,  2.911307465448596e-23, -1.075449427517239e-23,  2.109362127820906e-24, -2.824110721804477e-25,  2.879464645437007e-26, -2.377003016420356e-27,
  1.651910539365925e-28, -9.929057826810245e-30,  5.264709459028971e-31, -2.499927897965706e-32,  1.075756181945100e-33, -4.230150196804855e-35,  2.272004574582990e-24,
 -9.205654363390017e-25,  1.989313199544715e-25, -2.925956356140579e-26,  3.263879331797465e-27, -2.935074222274774e-28,  2.212726780262426e-29, -1.437067919337757e-30,
  8.202527697772300e-32, -4.178106737721609e-33,  1.922262905068232e-34, -8.055460500975998e-36,  2.706424711305085e-25, -1.159866084487481e-25,  2.661686690121135e-26,
 -4.151421245348136e-27,  4.898560425028286e-28, -4.647309000678269e-29,  3.686494541247661e-30, -2.512854766581246e-31,  1.501756609884223e-32, -7.991151959829431e-34,
  3.832607645776708e-35, -1.670732462729466e-36,  7.337665334990577e-02, -2.227568745762568e-04,  7.009544612014643e-07, -2.277286391171109e-09,  7.556212843645793e-12,
 -2.571409577463670e-14,  8.661416164357575e-17, -3.117686267793773e-19,  9.463990810843700e-22, -4.649204536847868e-24,  9.818726131811070e-28, -1.786936368084123e-28,
  6.293781403780557e-02, -2.209909836763064e-04,  9.609506372109933e-07, -4.464737349560683e-09,  2.073668400928524e-11, -9.479752147266253e-14,  4.239463662352030e-16,
 -1.874800350318435e-18,  8.059333355668534e-21, -3.530447896420458e-23,  1.409286779288735e-25, -6.900119589232064e-28,  4.629176785931217e-02, -2.068410641287552e-04,
  1.270614655159248e-06, -7.661632797629212e-09,  4.392015281163906e-11, -2.418806968614682e-13,  1.291722918565783e-15, -6.725403503957206e-18,  3.428357814941697e-20,
 -1.714032392027976e-22,  8.439163174693932e-25, -4.080223143156329e-27,  2.918122123331088e-02, -1.727199066911748e-04,  1.390042990386071e-06, -1.012003314374047e-08,
  6.865144622127910e-11, -4.433157053170962e-13,  2.755639398642257e-15, -1.657486958052860e-17,  9.707703781186334e-20, -5.539453293010004e-22,  3.104786798216893e-24,
 -1.694837137433077e-26,  1.575305307793201e-02, -1.241669062300373e-04,  1.232836340033632e-06, -1.054835373197999e-08,  8.335850195590100e-11, -6.217769585369612e-13,
  4.428666250122830e-15, -3.032617679075014e-17,  2.009948934152852e-19, -1.292825657547655e-21,  8.118575063282273e-24, -4.967700697128078e-26,  7.274895958596139e-03,
 -7.554135706983599e-05,  8.933210330718324e-07, -8.879734710239980e-09,  8.087533929547237e-11, -6.889237119143539e-13,  5.561009013710100e-15, -4.290429927111300e-17,
  3.186656149378913e-19, -2.288269182744257e-21,  1.596527194935823e-23, -1.083784024935394e-25,  2.870219441308859e-03, -3.862780574982349e-05,  5.337829460036251e-07,
 -6.120903835900588e-09,  6.369922757920863e-11, -6.143995461367594e-13,  5.576365342422468e-15, -4.811121149883055e-17,  3.976643339527518e-19, -3.165752010077061e-21,
  2.439034196489396e-23, -1.823825928913413e-25,  9.659255967062755e-04, -1.656378616067231e-05,  2.647631060510901e-07, -3.483025430368640e-09,  4.113504495214835e-11,
 -4.464266981916915e-13,  4.529461774177566e-15, -4.345919265171434e-17,  3.976775882691667e-19, -3.491856742074497e-21,  2.956916891847993e-23, -2.423524824779183e-25,
  2.767700760079408e-04, -5.952614300963560e-06,  1.094641359016424e-07, -1.644281370007046e-09,  2.192336982177292e-11, -2.664644230323323e-13,  3.009181469124869e-15,
 -3.197608209765263e-17,  3.226701575435416e-19, -3.113139439511519e-21,  2.887196404965489e-23, -2.584437177259834e-25,  6.738262546108277e-05, -1.792536141033945e-06,
  3.780920695500743e-08, -6.459652545241770e-10,  9.686027279764960e-12, -1.313944085746160e-13,  1.646268967330282e-15, -1.931472158623482e-17,  2.143118734915540e-19,
 -2.265592148272404e-21,  2.295072068271585e-23, -2.237816905725945e-25,  1.390747619589719e-05, -4.521872137159169e-07,  1.092143858850825e-08, -2.115726807432454e-10,
  3.558036648605439e-12, -5.373614946622849e-14,  7.452450883216390e-16, -9.632580214152897e-18,  1.172784462409443e-19, -1.355736432351283e-21,  1.497233119116138e-23,
 -1.587220820890734e-25,  2.427558963507802e-06, -9.550367553167488e-08,  2.638767446944353e-09, -5.783194423296504e-11,  1.088765783158101e-12, -1.827640844741966e-14,
  2.801282202101604e-16, -3.983065359938835e-18,  5.313777662168112e-20, -6.708054310935051e-22,  8.065780917833402e-24, -9.284595860417371e-26,  3.574569404735812e-07,
 -1.687408701276390e-08,  5.331084753656199e-10, -1.319867075954250e-11,  2.778728550373312e-13, -5.179442102335401e-15,  8.765911791002647e-17, -1.369973986861808e-18,
  2.001076948396391e-20, -2.756511947157045e-22,  3.605969729568764e-24, -4.503900946091613e-26,  4.429265606706353e-08, -2.491708050533741e-09,  9.000420509835576e-11,
 -2.515392204914894e-12,  5.919656139137919e-14, -1.224813022750884e-15,  2.288280750266933e-17, -3.929769242904938e-19,  6.283151306403810e-21, -9.442164459621193e-23,
  1.343510178736931e-24, -1.820325545319639e-26,  4.607872629511230e-09, -3.072148059537264e-10,  1.269063677512585e-11, -4.003418087249252e-13,  1.053390869369611e-14,
 -2.419982478416839e-16,  4.992284426984774e-18, -9.423689634638757e-20,  1.649705947589158e-21, -2.705243710679651e-23,  4.187754634578853e-25, -6.156253158478032e-27,
  4.017337668361705e-10, -3.160712720352586e-11,  1.494032856981058e-12, -5.323091940806895e-14,  1.567240844076819e-15, -4.000971431580578e-17,  9.121286042609959e-19,
 -1.894026621044122e-20,  3.633083981170622e-22, -6.505666426897613e-24,  1.096386728445736e-25, -1.749832040605292e-27,  2.932490856267959e-11, -2.713825231008176e-12,
  1.469302181409553e-13, -5.919443688068857e-15,  1.952781916601449e-16, -5.547338076920980e-18,  1.399461774295718e-19, -3.200809345675522e-21,  6.735770426108985e-23,
 -1.318640649579293e-24,  2.421995556168282e-26, -4.200973521309083e-28,  1.793299969197371e-12, -1.947602033019091e-13,  1.209408693906347e-14, -5.518997987434734e-16,
  2.043881290358857e-17, -6.473070680936137e-19,  1.810397362153765e-20, -4.568890893276793e-22,  1.056596381524597e-23, -2.264985857112881e-25,  4.540910438838885e-27,
 -8.571912415387059e-29,  9.216283739932267e-14, -1.172891981486426e-14,  8.368179704438820e-16, -4.335191887993126e-17,  1.806622115390916e-18, -6.394165051506109e-20,
  1.987205724180054e-21, -5.546052916269468e-23,  1.412446525609101e-24, -3.322118154892360e-26,  7.283548630615268e-28, -1.499005159173362e-29,  4.009857434996204e-15,
 -5.974590891597909e-16,  4.907746725988270e-17, -2.894071661796747e-18,  1.361016267882159e-19, -5.398434669429496e-21,  1.869438807335549e-22, -5.784874079500081e-24,
  1.626486582592047e-25, -4.207250893903855e-27,  1.010960087334151e-28, -2.273062680609409e-30,  1.497919350699355e-16, -2.611649734586236e-17,  2.475557862278744e-18,
 -1.666592632544877e-19,  8.872361601300816e-21, -3.956286485479206e-22,  1.531189432414968e-23, -5.268730772560043e-25,  1.639892701929451e-26, -4.677141345180169e-28,
  1.234705214888916e-29, -3.039620988337333e-31,  4.925567507895062e-18, -1.004265070176370e-18,  1.100829575856431e-19, -8.485387600615367e-21,  5.129813411465521e-22,
 -2.579642624868360e-23,  1.119232141024062e-24, -4.294843602874304e-26,  1.483844860628775e-27, -4.678083079408463e-29,  1.359915753939069e-30, -3.673421690951631e-32,
  1.487069953547465e-19, -3.540100290991992e-20,  4.493699768388804e-21, -3.975052670780672e-22,  2.735977853956493e-23, -1.555667892289248e-24,  7.585728842561396e-26,
 -3.253949072881453e-27,  1.250665470187951e-28, -4.367237300546553e-30,  1.400539437638158e-31, -4.157593355103847e-33,  4.415943778020354e-21, -1.222816649814999e-21,
  1.796505044491355e-22, -1.824646506755446e-23,  1.431166129118715e-24, -9.210749698092881e-26,  5.052871473204327e-27, -2.425130121499905e-28,  1.037735222863469e-29,
 -4.016006870882594e-31,  1.421354769676853e-32, -4.637875993921330e-34,  1.437016439517755e-22, -4.591237475972333e-23,  7.771048584684272e-24, -9.032493379625970e-25,
  8.051711831164433e-26, -5.851201685119416e-27,  3.602899425831537e-28, -1.930367584155066e-29,  9.174901208058883e-31, -3.925598109206210e-32,  1.529480843077219e-33,
 -5.471209366003076e-35,  5.996723553880031e-24, -2.176621707478317e-24,  4.193613379282136e-25, -5.520040194340876e-26,  5.539046899233227e-27, -4.504463605813652e-28,
  3.086660955338719e-29, -1.830912889186262e-30,  9.588043474960315e-32, -4.499773520919838e-33,  1.915013312908989e-34, -7.452186730338563e-36,  3.874356810450805e-25,
 -1.556132659825684e-25,  3.332129695032653e-26, -4.858123835766611e-27,  5.374337880927956e-28, -4.795253925668858e-29,  3.588591761182600e-30, -2.314549657510709e-31,
  1.312519164915888e-32, -6.644604262468548e-34,  3.039379358226107e-35, -1.266749706685228e-36,  4.052558302291869e-26, -1.732308890815114e-26,  3.964350162539829e-27,
 -6.166487299759054e-28,  7.257473567018848e-29, -6.868289545508865e-30,  5.435556170437468e-31, -3.696851617318938e-32,  2.204684272578312e-33, -1.170802000769773e-34,
  5.604511195234119e-36, -2.438715416320880e-37,  7.249667090017559e-02, -2.172565317096505e-04,  6.743358075295736e-07, -2.160391204579406e-09,  7.062028265432745e-12,
 -2.373684276065013e-14,  7.828342363044629e-17, -2.841709850409413e-19,  7.776241866139109e-22, -4.791632179531457e-24, -8.809385040466611e-27, -2.760542143231118e-28,
  6.206889377058838e-02, -2.135121861804381e-04,  9.093036875292113e-07, -4.147582521246828e-09,  1.893837442691178e-11, -8.522473596832473e-14,  3.748788890510649e-16,
 -1.636207203865907e-18,  6.882713410153597e-21, -3.025447547847943e-23,  1.119719516848008e-25, -6.351612841896149e-28,  4.548416754720502e-02, -1.970323160044431e-04,
  1.182737041508315e-06, -6.995988723741773e-09,  3.937791647778866e-11, -2.130205900030216e-13,  1.117887522991780e-15, -5.720877482899868e-18,  2.867981775465009e-20,
 -1.409761937025692e-22,  6.835270323989895e-25, -3.243056095998339e-27,  2.851183867410671e-02, -1.620673024182484e-04,  1.274911766512723e-06, -9.089098868433844e-09,
  6.041063275801159e-11, -3.824160895787012e-13,  2.332198418854011e-15, -1.376489199705225e-17,  7.920198544351216e-20, -4.434477393447931e-22,  2.448398911502185e-24,
 -1.305690213040112e-26,  1.527533996876861e-02, -1.147887719397654e-04,  1.113866086805067e-06, -9.308603192093555e-09,  7.192064445154513e-11, -5.249926315378712e-13,
  3.663005512365234e-15, -2.458036735679504e-17,  1.598080126638765e-19, -1.007873285715340e-21,  6.219277758607641e-24, -3.726851770013731e-26,  6.986378539506107e-03,
 -6.880001997712808e-05,  7.940959810090513e-07, -7.689094170782122e-09,  6.833984782542265e-11, -5.687949759390150e-13,  4.490894265457273e-15, -3.391054349986064e-17,
  2.467202314185446e-19, -1.735671260313698e-21,  1.187809137739923e-23, -7.901431644073932e-26,  2.723806842858978e-03, -3.463490819370756e-05,  4.660640846803532e-07,
 -5.193181975356604e-09,  5.264745611989404e-11, -4.953931333197808e-13,  4.391528748813415e-15, -3.703577384234254e-17,  2.994831016384804e-19, -2.333489589242859e-21,
  1.761075097792587e-23, -1.289945875482085e-25,  9.036568989990564e-04, -1.460231994958974e-05,  2.266391847546962e-07, -2.890775836198571e-09,  3.320198340993591e-11,
 -3.509923819047985e-13,  3.473380241509511e-15, -3.253587936804856e-17,  2.909196968076962e-19, -2.497662308235428e-21,  2.069496745694826e-23, -1.660290601004355e-25,
  2.545939945412867e-04, -5.150244525497953e-06,  9.167346325439629e-08, -1.332502460683733e-09,  1.724938112538895e-11, -2.039173604061949e-13,  2.243028100967510e-15,
 -2.324139676416267e-17,  2.289086790928594e-19, -2.157240261211338e-21,  1.955636605336189e-23, -1.712097480327321e-25,  6.077180748854287e-05, -1.518620849939492e-06,
  3.090724521085878e-08, -5.100360290853890e-10,  7.413144754336605e-12, -9.766822214921629e-14,  1.190366920964093e-15, -1.360215708931661e-17,  1.471489629881624e-19,
 -1.517954981843566e-21,  1.501674090029823e-23, -1.430835541489456e-25,  1.225865686635258e-05, -3.740791991222241e-07,  8.691586615190093e-09, -1.623546906757269e-10,
  2.642340147521199e-12, -3.870401477202836e-14,  5.214875448098560e-16, -6.557390127253373e-18,  7.775741917360636e-20, -8.762907265662190e-22,  9.442243309474056e-24,
 -9.773577045634566e-26,  2.083753548518917e-06, -7.689890702638134e-08,  2.038330595337274e-09, -4.300535708039208e-11,  7.823406593108912e-13, -1.271976533381466e-14,
  1.891793085370296e-16, -2.613971625268945e-18,  3.393010560071429e-20, -4.171842966302860e-22,  4.890133997391640e-24, -5.491970383394557e-26,  2.975844150208264e-07,
 -1.317436393691872e-08,  3.983193208458316e-10, -9.478957021653247e-12,  1.925534900255220e-13, -3.471837775764134e-15,  5.695092129125723e-17, -8.640298742051761e-19,
  1.226773459954910e-20, -1.644490501278721e-22,  2.095503560847555e-24, -2.551683450394968e-26,  3.559522167602831e-08, -1.877996666458353e-09,  6.478132981530567e-11,
 -1.737747376615574e-12,  3.940622985715371e-14, -7.877514467275434e-16,  1.424906017464756e-17, -2.373185593230813e-19,  3.685018739715299e-21, -5.384586742887161e-23,
  7.457523851766132e-25, -9.844205798819983e-27,  3.555245995620844e-09, -2.223704930691270e-10,  8.756942895470097e-12, -2.648093476115902e-13,  6.705756102949650e-15,
 -1.486778586387532e-16,  2.966616525552999e-18, -5.426036162566849e-20,  9.217522181757630e-22, -1.468635416431974e-23,  2.211426925658545e-25, -3.165368813680993e-27,
  2.956946215534639e-10, -2.183755417585197e-11,  9.827220875703841e-13, -3.352638177417235e-14,  9.489713905738277e-16, -2.335833061781090e-17,  5.146158794681958e-19,
 -1.034600740718784e-20,  1.924429387967899e-22, -3.346133080447337e-24,  5.482166605791165e-26, -8.514936839468547e-28,  2.043581152527450e-11, -1.776782699133161e-12,
  9.149967336870953e-14, -3.526669131314131e-15,  1.117534704931850e-16, -3.058512868777215e-18,  7.451247917241349e-20, -1.648963191094578e-21,  3.363041641242030e-23,
 -6.389674946111521e-25,  1.140437995074699e-26, -1.924329621611924e-28,  1.172541308517590e-12, -1.197889747601508e-13,  7.072245803875467e-15, -3.085880337507524e-16,
  1.097092448338198e-17, -3.345621921758024e-19,  9.031626754044259e-21, -2.204422083429617e-22,  4.938798361786266e-24, -1.027174878822080e-25,  2.000557810306295e-27,
 -3.673025737728413e-29,  5.592550789351329e-14, -6.706514490907830e-15,  4.549743628150668e-16, -2.253381355233534e-17,  9.012814604457149e-19, -3.070801215343131e-20,
  9.209649109353356e-22, -2.485421017257113e-23,  6.131396040943326e-25, -1.399047456757099e-26,  2.979702976940428e-28, -5.964514817493938e-30,  2.228462082846233e-15,
 -3.135929046970253e-16,  2.451262021347016e-17, -1.382463380786333e-18,  6.241301684458775e-20, -2.383596033643249e-21,  7.966785925737219e-23, -2.384307183504132e-24,
  6.495038401738279e-26, -1.630288592769194e-27,  3.806553036445455e-29, -8.326963089347454e-31,  7.502041109889922e-17, -1.239120144928802e-17,  1.119443259069605e-18,
 -7.215461474550964e-20,  3.690740960267861e-21, -1.585772071958949e-22,  5.927793510384432e-24, -1.974068341944376e-25,  5.957024165200317e-27, -1.649786229453328e-28,
  4.234936054746811e-30, -1.015065475500191e-31,  2.180100213711121e-18, -4.227948293295730e-19,  4.428463937575671e-20, -3.274751825100820e-21,  1.905394075826278e-22,
 -9.246633189366451e-24,  3.880366263344837e-25, -1.443051379675388e-26,  4.840092141846426e-28, -1.483641689619185e-29,  4.199197811741290e-31, -1.105786788314703e-32,
  5.683532331427893e-20, -1.293796883283249e-20,  1.575391692009246e-21, -1.341199090710045e-22,  8.909694148790624e-24, -4.901430260024038e-25,  2.317247870959432e-26,
 -9.655074584370400e-28,  3.610482902192709e-29, -1.228415946600487e-30,  3.843458506603153e-32, -1.114531290400918e-33,  1.419970018657795e-21, -3.785763458578105e-22,
  5.364595191433897e-23, -5.268837557643307e-24,  4.005703332078046e-25, -2.504056487738527e-26,  1.336750516088698e-27, -6.253512343703162e-29,  2.612114017686409e-30,
 -9.880844452318843e-32,  3.422321224796937e-33, -1.094080720514966e-34,  3.790007350314308e-23, -1.175825373470229e-23,  1.933733856272229e-24, -2.187774723755562e-25,
  1.901686251000299e-26, -1.349793269237344e-27,  8.130058469992526e-29, -4.266642463766724e-30,  1.988762070011312e-31, -8.354206485813457e-33,  3.198913902541536e-34,
 -1.125690732573871e-35,  1.276849675976292e-24, -4.544680793981594e-25,  8.584795421951047e-26, -1.109060336549350e-26,  1.093514637429783e-27, -8.747712191766723e-29,
  5.902717016380485e-30, -3.451081606728106e-31,  1.782872701838435e-32, -8.260963322526400e-34,  3.473604141521730e-35, -1.336488093858207e-36,  6.735574227332572e-26,
 -2.678739111698730e-26,  5.677303823482461e-27, -8.196229910314290e-28,  8.983381885316360e-29, -7.945862192143197e-30,  5.897945134363460e-31, -3.774915924740239e-32,
  2.125256068958032e-33, -1.068624101393118e-34,  4.856934363878574e-36, -2.012122344812693e-37,  6.106305605580368e-27, -2.602690593072841e-27,  5.937794846421064e-28,
 -9.208367162778166e-29,  1.080639795935697e-29, -1.019900796531951e-30,  8.050612882668203e-32, -5.461995097331620e-33,  3.249788993270699e-34, -1.722000286346886e-35,
  8.225770252424509e-37, -3.572203505836437e-38,  7.163827262159543e-02, -2.119636585855621e-04,  6.490737248664758e-07, -2.051097222378497e-09,  6.605448777088624e-12,
 -2.195087260929364e-14,  7.064844474455676e-17, -2.621412597590087e-19,  5.954682722838688e-22, -5.430571814315824e-24, -2.436187735359396e-26, -4.444093827683858e-28,
  6.122908577404942e-02, -2.064318158445638e-04,  8.612960748712519e-07, -3.857730787626295e-09,  1.732026418473856e-11, -7.675349718705440e-14,  3.319906535992722e-16,
 -1.432576901716651e-18,  5.867476202011473e-21, -2.633107891005589e-23,  8.417346622231261e-26, -6.385755522976790e-28,  4.471444508654424e-02, -1.878958309214048e-04,
  1.102429440725372e-06, -6.398620284383914e-09,  3.537333946741259e-11, -1.880143055148429e-13,  9.698246154298752e-16, -4.879315324511521e-18,  2.406432217709573e-20,
 -1.162828624356269e-22,  5.559616357097896e-25, -2.580313116765063e-27,  2.788329973662519e-02, -1.522884154840860e-04,  1.171399111375291e-06, -8.180800203594943e-09,
  5.329223971791896e-11, -3.307960386812273e-13,  1.979992528056636e-15, -1.146801907328181e-17,  6.487092034552417e-20, -3.560617657257309e-22,  1.942768335025291e-24,
 -1.005064992147853e-26,  1.483332588772170e-02, -1.063058618600554e-04,  1.008735592504300e-06, -8.237319164462109e-09,  6.224701510084039e-11, -4.447935223190722e-13,
  3.041219219057240e-15, -2.000206231389600e-17,  1.276341446423927e-19, -7.889856998336601e-22,  4.792201927856148e-24, -2.804184074362855e-26,  6.723324772820490e-03,
 -6.279856827218506e-05,  7.080301962103401e-07, -6.681115161837792e-09,  5.796923094486038e-11, -4.715699334279034e-13,  3.643152681668262e-15, -2.692993187824266e-17,
  1.920125290172086e-19, -1.323362090549765e-21,  8.890849795330185e-24, -5.790307826406761e-26,  2.592348822286591e-03, -3.114206561019085e-05,  4.084907285628331e-07,
 -4.424693071107061e-09,  4.371484742907054e-11, -4.014305541387668e-13,  3.476975288879716e-15, -2.867081847844949e-17,  2.268996579997171e-19, -1.730660412315530e-21,
  1.280079143141063e-23, -9.183214179974705e-26,  8.486662286463824e-04, -1.291943831858653e-05,  1.949194787368302e-07, -2.411465421009754e-09,  2.694705952143832e-11,
 -2.775890508586356e-13,  2.680251657475938e-15, -2.451860258597303e-17,  2.142976143890600e-19, -1.799362931313163e-21,  1.459350683136479e-23, -1.146158653549136e-25,
  2.353647594429674e-04, -4.476417098400493e-06,  7.721369279692445e-08, -1.086421466651523e-09,  1.366064105689053e-11, -1.571327656776851e-13,  1.684141798454517e-15,
 -1.702150669057653e-17,  1.636847332431023e-19, -1.507165124742104e-21,  1.335980061462413e-23, -1.144159321149449e-25,  5.515574015791908e-05, -1.293967219325699e-06,
  2.543870973343977e-08, -4.056209179507983e-10,  5.717168500551463e-12, -7.318428426978794e-14,  8.679743959432260e-16, -9.663086875732157e-18,  1.019520266962204e-19,
 -1.026568293386467e-21,  9.920494669622445e-24, -9.239332727480677e-26,  1.089000880542753e-05, -3.116755174993479e-07,  6.973493935482222e-09, -1.256475879561692e-10,
  1.979883001021073e-12, -2.813716278558909e-14,  3.684482059004144e-16, -4.508655398104306e-18,  5.208663207856386e-20, -5.724060096250882e-22,  6.019529131583757e-24,
 -6.085256262275027e-26,  1.805779609477269e-06, -6.246156922146388e-08,  1.589712018276440e-09, -3.229922215831996e-11,  5.679996605373879e-13, -8.947701052542022e-15,
  1.291750420806187e-16, -1.735023019317704e-18,  2.191860130383994e-20, -2.625553139252493e-22,  3.001002411669039e-24, -3.289017765045999e-26,  2.506072122293521e-07,
 -1.039525728637510e-08,  3.009854232760681e-10, -6.886823477581026e-12,  1.350333261546260e-13, -2.355911501360293e-15,  3.746778568227971e-17, -5.519751477548839e-19,
  7.619949914223152e-21, -9.942480815449412e-23,  1.234368527481868e-24, -1.465703115039178e-26,  2.900136028679049e-08, -1.433526388560482e-09,  4.724598913531692e-11,
 -1.216747767764846e-12,  2.659468911657832e-14, -5.137924978148917e-16,  9.000225484396136e-18, -1.454085039123742e-19,  2.193266552031369e-21, -3.116819983975968e-23,
  4.202517477711750e-25, -5.405672714150910e-27,  2.788055458328572e-09, -1.634050311565508e-10,  6.136107306510993e-12, -1.778995389685967e-13,  4.336479406099792e-15,
 -9.281110531369542e-17,  1.791545456062980e-18, -3.175615668038988e-20,  5.235750260318311e-22, -8.106742301736034e-24,  1.187547061768151e-25, -1.655295221467826e-27,
  2.218424991138245e-10, -1.535851109986287e-11,  6.580221806492914e-13, -2.149637781554246e-14,  5.850216760576619e-16, -1.388574490116601e-17,  2.956728093396244e-19,
 -5.755832650764899e-21,  1.038296002694428e-22, -1.753182359722461e-24,  2.792599148412096e-26, -4.221484354905292e-28,  1.456214245991340e-11, -1.187756066462028e-12,
  5.816593583468782e-14, -2.144565912961895e-15,  6.527492066392009e-17, -1.721131014679691e-18,  4.049304207126544e-20, -8.670663811832415e-22,  1.713852704323027e-23,
 -3.160322749946030e-25,  5.481152168513387e-27, -8.997234926027103e-29,  7.867160984403434e-13, -7.548041212424868e-14,  4.234690384585418e-15, -1.766221595825666e-16,
  6.026890184916135e-18, -1.769470198412415e-19,  4.610066070633351e-21, -1.088135773706385e-22,  2.361543625963511e-24, -4.764801927712779e-26,  9.014459048993491e-28,
 -1.609563614608947e-29,  3.495959050230352e-14, -3.943099037266123e-15,  2.541524538729903e-16, -1.202762026232515e-17,  4.615301164262571e-19, -1.513304378426649e-20,
  4.378541485863956e-22, -1.142334317499627e-23,  2.729119646109165e-25, -6.039887679359748e-27,  1.249361219597455e-28, -2.431865709812229e-30,  1.281145780028468e-15,
 -1.699196271659921e-16,  1.262487279981394e-17, -6.804206087891627e-19,  2.947067914192907e-20, -1.083097139252379e-21,  3.492363042949376e-23, -1.010433498460629e-24,
  2.665728966960659e-26, -6.490358309547299e-28,  1.472006619003261e-29, -3.131760400540551e-31,  3.903591104500789e-17, -6.093981944397374e-18,  5.239419399329675e-19,
 -3.229735271404285e-20,  1.585836847877257e-21, -6.560260950593652e-23,  2.366889609402084e-24, -7.623578340002565e-26,  2.229066379283474e-27, -5.991129610321302e-29,
  1.494618028508338e-30, -3.486129782362460e-32,  1.006670405964943e-18, -1.852196051870608e-19,  1.850431666070108e-20, -1.310818104924697e-21,  7.331497068388948e-23,
 -3.429766237137142e-24,  1.390787214709542e-25, -5.008008648714764e-27,  1.629326251365369e-28, -4.852231645251635e-30,  1.336139886668786e-31, -3.427660282830799e-33,
  2.273687746936779e-20, -4.935492677829988e-21,  5.752464708554918e-22, -4.704884832106516e-23,  3.011942060875946e-24, -1.600901461671561e-25,  7.328944541634239e-27,
 -2.962755418084773e-28,  1.076766185086533e-29, -3.566004463141661e-31,  1.087519907223878e-32, -3.077812157745680e-34,  4.785460838465824e-22, -1.224822067567453e-22,
  1.670060344646045e-23, -1.582859692483121e-24,  1.164309985935556e-25, -7.058030556828597e-27,  3.661042908790436e-28, -1.667088448611821e-29,  6.788743730434078e-31,
 -2.507077612332063e-32,  8.488421756145648e-34, -2.655883249581935e-35,  1.044959787433970e-23, -3.139286643159354e-24,  5.004151601154393e-25, -5.498918233095572e-26,
  4.651882784867782e-27, -3.219337720308002e-28,  1.893716862642593e-29, -9.720082467706561e-31,  4.437173806289349e-32, -1.827647625087832e-33,  6.869589028027563e-35,
 -2.375411728975108e-36,  2.818200470589249e-25, -9.814156764656218e-26,  1.813804403877254e-26, -2.295414619961637e-27,  2.220020086748535e-28, -1.744230779582991e-29,
  1.157298210034073e-30, -6.660318369126308e-32,  3.390225298169856e-33, -1.549148573966164e-34,  6.429101357217081e-36, -2.443310944480426e-37,  1.196429719000418e-26,
 -4.705242280509119e-27,  9.857534732234899e-28, -1.407489150869341e-28,  1.526730423007204e-29, -1.337334099943221e-30,  9.836588871022556e-32, -6.242304240356190e-33,
  3.486360460988826e-34, -1.739885414641111e-35,  7.852124154489647e-37, -3.231431724416405e-38,  9.265439091854011e-28, -3.936391952151844e-28,  8.949358959612130e-29,
 -1.383200231776790e-29,  1.618040075932873e-30, -1.522460985515424e-31,  1.198309642320730e-32, -8.107954764524117e-34,  4.811701894447488e-35, -2.543428694440451e-36,
  1.212162424499496e-37, -5.252573112541438e-39,  7.080064977670396e-02, -2.068677575502706e-04,  6.250804853928824e-07, -1.948832515224049e-09,  6.182802749068183e-12,
 -2.034142457139410e-14,  6.354428724000439e-17, -2.464445755079261e-19,  3.771038970697201e-22, -6.864335606534337e-24, -4.915392550676302e-26, -6.946002948649487e-28,
  6.041685256095893e-02, -1.997220211304299e-04,  8.166167594325117e-07, -3.592467471825506e-09,  1.586172892824080e-11, -6.924670456489313e-14,  2.943689367009037e-16,
 -1.259390295487994e-18,  4.973265573224210e-21, -2.354064150885730e-23,  5.488936966749722e-26, -7.011277716483838e-28,  4.398002755542645e-02, -1.793741854107326e-04,
  1.028921721741940e-06, -5.861509424114799e-09,  3.183517881937375e-11, -1.662946680001503e-13,  8.433846431822055e-16, -4.172155975879163e-18,  2.025258345787657e-20,
 -9.615053370202053e-23,  4.545148746784039e-25, -2.049840081732045e-27,  2.729228654144956e-02, -1.432958920745305e-04,  1.078135313580457e-06, -7.378574925921602e-09,
  4.712667161757639e-11, -2.869062275722420e-13,  1.686125301039281e-15, -9.583063276946389e-18,  5.335167108694479e-20, -2.864616624757209e-22,  1.554363647808769e-24,
 -7.696773432720713e-27,  1.442363921633465e-02, -9.861508848553551e-05,  9.155822573523906e-07, -7.308750576403322e-09,  5.403795107840401e-11, -3.780884083359564e-13,
  2.534322024578655e-15, -1.633750963979231e-17,  1.024038095948136e-19, -6.197937482598112e-22,  3.717736380106122e-24, -2.112058586208256e-26,  6.482972570663317e-03,
 -5.743993974493289e-05,  6.331253413456763e-07, -5.824552406956485e-09,  4.935452191985430e-11, -3.925300930742277e-13,  2.968436129400848e-15, -2.148383560670213e-17,
  1.502037878843906e-19, -1.013825715465193e-21,  6.697126377358898e-24, -4.261497519429635e-26,  2.473996152386506e-03, -2.807521662571360e-05,  3.593400678477883e-07,
 -3.785209314195688e-09,  3.645969327193313e-11, -3.268502947281210e-13,  2.767138402081494e-15, -2.231545836533775e-17,  1.729158532528137e-19, -1.291100604733902e-21,
  9.366595391076303e-24, -6.577424165348892e-26,  7.999337342973069e-04, -1.146890356174838e-05,  1.683963181944689e-07, -2.021451873225674e-09,  2.198669543480029e-11,
 -2.207824187259544e-13,  2.080747493516341e-15, -1.859402075530245e-17,  1.589168040625923e-19, -1.305228721857257e-21,  1.036685109271297e-23, -7.970472593901387e-26,
  2.186168899359743e-04, -3.907365429192002e-06,  6.539104446744508e-08, -8.909483351025184e-10,  1.088643387746382e-11, -1.218873814943560e-13,  1.273395594331427e-15,
 -1.255768319017024e-17,  1.179450516782728e-19, -1.061340634072729e-21,  9.202365247689876e-24, -7.710857258637058e-26,  5.035812091451039e-05, -1.108476593540203e-06,
  2.107523529764666e-08, -3.248096407227997e-10,  4.441650535888611e-12, -5.526263172470501e-14,  6.380298856568421e-16, -6.922638935563661e-18,  7.125644345892267e-20,
 -7.005266228432646e-22,  6.615040117179653e-24, -6.023260590408501e-26,  9.746040997605375e-06, -2.614199691900421e-07,  5.638667822841284e-09, -9.803071187923036e-11,
  1.496239939175991e-12, -2.063846887028022e-14,  2.627460800326754e-16, -3.129893300521873e-18,  3.523809977924237e-20, -3.777307859341226e-22,  3.877877277193684e-24,
 -3.829602160977898e-26,  1.579115449710457e-06, -5.115232254377412e-08,  1.251247545004337e-09, -2.448961122391329e-11,  4.164879765257710e-13, -6.359180495474958e-15,
  8.914309542549680e-17, -1.164254073534511e-18,  1.431878005241037e-20, -1.671459058914095e-22,  1.863402016194673e-24, -1.993431166290929e-26,  2.133660531042538e-07,
 -8.284500133546459e-09,  2.298968524351955e-10, -5.059176428113133e-12,  9.578499951739267e-14, -1.617589942735999e-15,  2.494940412358209e-17, -3.570090956908431e-19,
  4.793198904394366e-21, -6.089076023954448e-23,  7.367094997762189e-25, -8.532064682405696e-27,  2.393998875899766e-08, -1.107439663540778e-09,  3.489355425825403e-11,
 -8.629570750357821e-13,  1.818608311046234e-14, -3.396448388752386e-16,  5.763377486113311e-18, -9.034691062961491e-20,  1.324067587263491e-21, -1.830341140937585e-23,
  2.403106681704879e-25, -3.012647586663994e-27,  2.220589341248972e-09, -1.218030967527593e-10,  4.363176038762039e-12, -1.213008844672311e-13,  2.846954433236405e-15,
 -5.883093325995093e-17,  1.098855287297881e-18, -1.888021496063215e-20,  3.021751210750363e-22, -4.547457681361329e-24,  6.481686304855011e-26, -8.799308320906346e-28,
  1.695027597616049e-10, -1.098588227735033e-11,  4.481771082410571e-13, -1.402091135756311e-14,  3.669323456965562e-16, -8.399532652850026e-18,  1.728863250612442e-19,
 -3.259292451314552e-21,  5.702621389833416e-23, -9.351786809800252e-25,  1.448415629318996e-26, -2.131162969440424e-28,  1.060078964507083e-11, -8.099229060993623e-13,
  3.771249682630318e-14, -1.330005888799244e-15,  3.888474894762101e-17, -9.878309767560645e-19,  2.244492623601133e-20, -4.650517458947061e-22,  8.909259299553216e-24,
 -1.594510631331340e-25,  2.687376336050524e-27, -4.291453366703123e-29,  5.411295317684530e-13, -4.867592429516009e-14,  2.593993354333805e-15, -1.033922877601109e-16,
  3.385790005254446e-18, -9.569409824508411e-20,  2.405982107971342e-21, -5.491467588382843e-23,  1.154415358275916e-24, -2.259493167815707e-26,  4.152092945479477e-28,
 -7.209450941605736e-30,  2.249052632860531e-14, -2.381437523234205e-15,  1.457301828861173e-16, -6.586730582566345e-18,  2.424044212489225e-19, -7.646926738379122e-21,
  2.134047154803666e-22, -5.381292778542764e-24,  1.244811898884747e-25, -2.671556452636713e-27,  5.366177120908117e-29, -1.015521669769446e-30,  7.612213439754813e-16,
 -9.495680926957472e-17,  6.699043474015017e-18, -3.447712878942060e-19,  1.431820093682147e-20, -5.061506601102537e-22,  1.573812236841965e-23, -4.400345282542382e-25,
  1.123908998988350e-26, -2.653437895497962e-28,  5.843652731399009e-30, -1.208791652648433e-31,  2.108742519182876e-17, -3.104127372876671e-18,  2.536315949409708e-19,
 -1.493669773510847e-20,  7.034289803927473e-22, -2.799644536930559e-23,  9.742802128421355e-25, -3.033335201701191e-26,  8.589011397784154e-28, -2.239192108767661e-29,
  5.426259799770518e-31, -1.231043246548732e-32,  4.847581711534687e-19, -8.439750079945121e-20,  8.027931133799278e-21, -5.440143971923862e-22,  2.921437280914238e-23,
 -1.316128127774729e-24,  5.152326947986555e-26, -1.794892618026653e-27,  5.659962332804023e-29, -1.636387758497547e-30,  4.380939398359128e-32, -1.094119349896523e-33,
  9.522902066533532e-21, -1.965471762993346e-21,  2.188036977797960e-22, -1.716220672139040e-23,  1.057158895071064e-24, -5.421671438955805e-26,  2.400545860169049e-27,
 -9.404841206224108e-29,  3.318510790266839e-30, -1.068716157823087e-31,  3.173936308908497e-33, -8.759106960770968e-35,  1.692181291976263e-22, -4.145166948167072e-23,
  5.425069907005127e-24, -4.951505546854133e-25,  3.517444104640806e-26, -2.064318505696449e-27,  1.038874346018722e-28, -4.598320738357160e-30,  1.823215848002715e-31,
 -6.565604180240829e-33,  2.170598121116950e-34, -6.639805424156908e-36,  3.018506376166589e-24, -8.754833877031738e-25,  1.349177090613870e-25, -1.436715712673812e-26,
  1.180479401369216e-27, -7.950808886758482e-29,  4.559918791003584e-30, -2.285638783589649e-31,  1.020391265937396e-32, -4.115683035233278e-34,  1.516645734214476e-35,
 -5.147312081772912e-37,  6.466649028173403e-26, -2.197784217558659e-26,  3.964877636131353e-27, -4.905033179270371e-28,  4.644583438871865e-29, -3.577896055496193e-30,
  2.330629153734722e-31, -1.318392095896833e-32,  6.603436256303979e-34, -2.972038627788010e-35,  1.215969688797061e-36, -4.559664690662018e-38,  2.176743025865431e-27,
 -8.452417294164480e-28,  1.747823498575137e-28, -2.464821383471869e-29,  2.642724009460883e-30, -2.289865309274107e-31,  1.667267976990709e-32, -1.048052154259862e-33,
  5.801630769147298e-35, -2.871304945519656e-36,  1.285724756823510e-37, -5.252537419586376e-39,  1.416990472224568e-28, -5.997903638075920e-29,  1.358284468457105e-29,
 -2.091403056625825e-30,  2.437696603657785e-31, -2.285922448153324e-32,  1.793467466184081e-33, -1.209829280943879e-34,  7.159349719558579e-36, -3.774200372405746e-37,
  1.794155729784883e-38, -7.755805646016310e-40,  6.998303425709410e-02, -2.019590062976876e-04,  6.022748809868238e-07, -1.853081762109057e-09,  5.790671974208037e-12,
 -1.889804692229272e-14,  5.677255554993120e-17, -2.387753736914414e-19,  8.646898403142665e-23, -9.525218456412361e-24, -8.589770844517092e-26, -9.664400107925877e-28,
  5.963076327226424e-02, -1.933573139226904e-04,  7.749853843350770e-07, -3.349387100357031e-09,  1.454467675232272e-11, -6.258779132393801e-14,  2.612092933902129e-16,
 -1.113443367539153e-18,  4.157649663584882e-21, -2.198822657534731e-23,  2.209980075809487e-26, -7.857352752702460e-28,  4.327855998683568e-02, -1.714157507352367e-04,
  9.615334883537008e-07, -5.377692377445052e-09,  2.870260067527998e-11, -1.473851247494845e-13,  7.351411011309932e-16, -3.576115498593721e-18,  1.709789921244842e-20,
 -7.964105707929196e-23,  3.740764160364896e-25, -1.621585896838458e-27,  2.673580990561455e-02, -1.350125849595121e-04,  9.939340978503542e-07, -6.668342346921721e-09,
  4.177244086263616e-11, -2.494753255554331e-13,  1.440232636963468e-15, -8.029439216333491e-18,  4.408189636714251e-20, -2.304827188074888e-22,  1.258027889146689e-24,
 -5.850442501036029e-27,  1.404329273248632e-02, -9.162710610130113e-05,  8.328256508752192e-07, -6.501481873974064e-09,  4.704919655805097e-11, -3.224034246372849e-13,
  2.119588930680974e-15, -1.339060519827785e-17,  8.255920529504830e-20, -4.880269568586407e-22,  2.908534541783533e-24, -1.590729089440630e-26,  6.262918347154907e-03,
 -5.264166357406165e-05,  5.677216791576266e-07, -5.094009199309817e-09,  4.217028974227870e-11, -3.279950200407842e-13,  2.429041643928205e-15, -1.721302709625458e-17,
  1.181087594628695e-19, -7.799075595799152e-22,  5.079740511264958e-24, -3.148203322738452e-26,  2.367170424872683e-03, -2.537274347356016e-05,  3.172130992888044e-07,
 -3.250743640167719e-09,  3.053924732263638e-11, -2.673521986921987e-13,  2.213268972541543e-15, -1.745881438725906e-17,  1.325371054480450e-19, -9.684389311521656e-22,
  6.900187361097729e-24, -4.738141186651418e-26,  7.566068524241382e-04, -1.021310112482096e-05,  1.461122312193114e-07, -1.702443844341571e-09,  1.803105071547665e-11,
 -1.765581434784966e-13,  1.624778948789144e-15, -1.418684883000342e-17,  1.186187468890625e-19, -9.530062324758495e-22,  7.417838850453778e-24, -5.581828054244323e-26,
  2.039699218868456e-04, -3.424216527995865e-06,  5.566938613158278e-08, -7.347191707925913e-10,  8.727883455202541e-12, -9.515169903761549e-14,  9.693463859337659e-16,
 -9.329873020442589e-18,  8.561918340851161e-20, -7.530876155893225e-22,  6.389822226013513e-24, -5.239013651156187e-26,  4.623833405127612e-05, -9.543363481278167e-07,
  1.756997023242720e-08, -2.618148115809295e-10,  3.475063544487363e-12, -4.203985491335680e-14,  4.726637646773164e-16, -4.999635363205175e-18,  5.022413656952924e-20,
 -4.821997495214627e-22,  4.450876399089839e-24, -3.963001878454854e-26,  8.783665302669591e-06, -2.206384071512004e-07,  4.593350537093945e-09, -7.707806213365260e-11,
  1.140039884386747e-12, -1.526835690412356e-14,  1.890472195087092e-16, -2.192920907623548e-18,  2.406849459657091e-20, -2.517250113361130e-22,  2.523594849588329e-24,
 -2.435142376254089e-26,  1.392812985858468e-06, -4.221352100372317e-08,  9.935063494242460e-10, -1.873724852985582e-11,  3.083039219916015e-13, -4.564243979983029e-15,
  6.214761695846346e-17, -7.895000589027809e-19,  9.455656071631970e-21, -1.075917349057034e-22,  1.170230040987870e-24, -1.222258979664809e-26,  1.835556916845920e-07,
 -6.664375319711060e-09,  1.774112834676233e-10, -3.756007781920132e-12,  6.869302722445001e-14, -1.123266030602758e-15,  1.680762076009585e-17, -2.336735676976341e-19,
  3.052036305020379e-21, -3.775796330019441e-23,  4.453008886181925e-25, -5.031116105765203e-27,  2.000930172993215e-08, -8.652379328311719e-10,  2.608195371252624e-11,
 -6.195886327267786e-13,  1.259387308192978e-14, -2.274409277577746e-16,  3.739650956267279e-18, -5.689589422680340e-20,  8.103633952135933e-22, -1.089937187852430e-23,
  1.393727957750497e-25, -1.703230175755633e-27,  1.794954963616230e-09, -9.202669155272234e-11,  3.146238510963900e-12, -8.389151224045758e-14,  1.896305450038235e-15,
 -3.784458141205979e-17,  6.841449696028007e-19, -1.139661500121185e-20,  1.770993320263786e-22, -2.590900721918888e-24,  3.593853736446472e-26, -4.752540426551587e-28,
  1.317902181334743e-10, -7.985106408169498e-12,  3.102616109467517e-13, -9.296156299340466e-15,  2.339892564781807e-16, -5.166697915964439e-18,  1.028148981719895e-19,
 -1.877386812879926e-21,  3.186450552311680e-23, -5.075745214024043e-25,  7.644844596173966e-27, -1.094981066516909e-28,  7.876584933712062e-12, -5.628177538585873e-13,
  2.491736451349252e-14, -8.405436765282167e-16,  2.360659690177345e-17, -5.778387238056885e-19,  1.268082696077985e-20, -2.542591156858431e-22,  4.721368232678691e-24,
 -8.201809821392247e-26,  1.343369763628429e-27, -2.087035997525425e-29,  3.812031262738433e-13, -3.209326471346449e-14,  1.624059909351053e-15, -6.184959962361972e-17,
  1.943554333657586e-18, -5.287818564206858e-20,  1.282963708865744e-21, -2.831524922976850e-23,  5.765606003406369e-25, -1.094669004196705e-26,  1.953830569776757e-28,
 -3.298926849729106e-30,  1.487562881575825e-14, -1.475865492358127e-15,  8.569198709523333e-17, -3.697628144440453e-18,  1.304751569241336e-19, -3.959170518943001e-21,
  1.065515154896910e-22, -2.596530859531577e-24,  5.814803161558105e-26, -1.210009154763191e-27,  2.359772264536555e-29, -4.341158098574945e-31,  4.670057714634311e-16,
 -5.467312579583470e-17,  3.658849454399948e-18, -1.796986485751987e-19,  7.152059823560381e-21, -2.430853464083241e-22,  7.286151181634142e-24, -1.968054528402293e-25,
  4.865043484008514e-27, -1.113435170086476e-28,  2.380423940776200e-30, -4.786208255990373e-32,  1.181672942588366e-17, -1.636239805449465e-18,  1.268853893841174e-19,
 -7.131952975895371e-21,  3.218931473288385e-22, -1.231766624792853e-23,  4.132189931327929e-25, -1.242915373932344e-26,  3.406496928932624e-28, -8.610242590687557e-30,
  2.025899756094372e-31, -4.468504286422158e-33,  2.433125229336813e-19, -3.997642557218604e-20,  3.614190560633607e-21, -2.339783486407644e-22,  1.205086869907272e-23,
 -5.223167334487966e-25,  1.972314662659811e-26, -6.642040526019995e-28,  2.028579852039678e-29, -5.689917986905727e-31,  1.480043667421417e-32, -3.596270453134801e-34,
  4.175928796079687e-21, -8.170565565646218e-22,  8.669022937857745e-23, -6.509680977957052e-24,  3.852621751331470e-25, -1.903972506163482e-26,  8.143841821862789e-28,
 -3.088814729682271e-29,  1.057102055188213e-30, -3.307415301555217e-32,  9.556995473698794e-34, -2.569654677406384e-35,  6.284265301353130e-23, -1.468586353852313e-23,
  1.840222491521474e-24, -1.614002222649505e-25,  1.105242333965424e-26, -6.269433244035711e-28,  3.056559327470940e-29, -1.313280475735684e-30,  5.063531616911365e-32,
 -1.775961905221853e-33,  5.726641498652339e-35, -1.710852829248536e-36,  9.154321007184427e-25, -2.555059359528699e-25,  3.796262990196636e-26, -3.908252738650768e-27,
  3.112382216188295e-28, -2.036287387551275e-29,  1.136668967233048e-30, -5.555113207689838e-32,  2.421804228329037e-33, -9.552388300324716e-35,  3.446714246349940e-36,
 -1.146756947976417e-37,  1.547331433507618e-26, -5.117928234440455e-27,  8.989665605607214e-28, -1.084705600313996e-28,  1.003551386841051e-29, -7.565741455554264e-31,
  4.830238793791879e-32, -2.681573970750272e-33,  1.319737726150344e-34, -5.842770015348225e-36,  2.353779570693416e-37, -8.698860633006831e-39,  4.067548856204924e-28,
 -1.556753272099998e-28,  3.171959159512133e-29, -4.411129211572320e-30,  4.668199300079120e-31, -3.996016742944770e-32,  2.876746801333502e-33, -1.789317395341265e-34,
  9.807626584699709e-36, -4.809253739458701e-37,  2.134925745248620e-38, -8.651264528828809e-40,  2.186353054685017e-29, -9.215737580157245e-30,  2.077741004019361e-30,
 -3.185512056016753e-31,  3.697963306724279e-32, -3.454532103898169e-33,  2.700629722562446e-34, -1.815649702822248e-35,  1.071035513184836e-36, -5.629332973852683e-38,
  2.668499295902048e-39, -1.150481388683532e-40,  };
  int offset = -28;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 28;
    if (std::isnan(t)) {
      fill_n(rr+offset, 28, 0.5);
      fill_n(ww+offset, 28, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 28; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=28; ++j) {
        const int boxof = it*336+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
