MACRO(SET_COMPONENT_NAME COMPONENT NAME DESCRIPTION)
	STRING(TOUPPER ${COMPONENT} CURRENT_COMPONENT)
	SET(CPACK_COMPONENT_${CURRENT_COMPONENT}_DISPLAY_NAME ${NAME})
	SET(CPACK_COMPONENT_${CURRENT_COMPONENT}_DESCRIPTION  ${DESCRIPTION})
ENDMACRO()

MACRO(SET_COMPONENT_DEPENDENCIES COMPONENT DEPENDENCIES)
	## Dependencies of components seem to be currently broken for PackageMaker.
	## Or we do something completely wrong...
	IF (NOT APPLE)
		STRING(TOUPPER ${COMPONENT} CURRENT_COMPONENT)
		SET(CPACK_COMPONENT_${CURRENT_COMPONENT}_DEPENDS ${DEPENDENCIES})
	ENDIF()
ENDMACRO()


IF (UNIX AND NOT APPLE)
	## libraries
	SET(COMPONENT_LIBBALL "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_LIBVIEW "libVIEW${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## development
	SET(COMPONENT_LIBBALL_DEV "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")
	SET(COMPONENT_LIBVIEW_DEV "libVIEW${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")

	## Python bindings
	SET(COMPONENT_PYTHON_BINDINGS_BALL "python-ball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_PYTHON_BINDINGS_VIEW "python-ballview${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## Documentation
	SET(COMPONENT_DOCUMENTATION_EXAMPLES "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc")
	SET(COMPONENT_DOCUMENTATION_HTML "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc")
	SET(COMPONENT_DOCUMENTATION_PDF  "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc")

	## applications
	SET(COMPONENT_BALLVIEW "BALLView${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_QUEASY   "QuEasy${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
ELSEIF(APPLE)
	## libraries
	SET(COMPONENT_LIBBALL "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_LIBVIEW "libVIEW${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## development
	SET(COMPONENT_LIBBALL_DEV "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")
	SET(COMPONENT_LIBVIEW_DEV "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")

	## Python bindings
	SET(COMPONENT_PYTHON_BINDINGS_BALL "python-ball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_PYTHON_BINDINGS_VIEW "python-ballview${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## Documentation
	SET(COMPONENT_DOCUMENTATION_EXAMPLES "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-examples")
	SET(COMPONENT_DOCUMENTATION_HTML "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-html")
	SET(COMPONENT_DOCUMENTATION_PDF  "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-pdf")

	## applications
	SET(COMPONENT_BALLVIEW "BALLView${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_QUEASY   "QuEasy${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
ELSEIF(WIN32)
	## libraries
	SET(COMPONENT_LIBBALL "Runtime")
	SET(COMPONENT_LIBVIEW "Runtime")

	## development
	SET(COMPONENT_LIBBALL_DEV "Development")
	SET(COMPONENT_LIBVIEW_DEV "Development")

	## Python bindings
	SET(COMPONENT_PYTHON_BINDINGS_BALL "PythonBindings")
	SET(COMPONENT_PYTHON_BINDINGS_VIEW "PythonBindings")

	## Documentation
	SET(COMPONENT_DOCUMENTATION_EXAMPLES "DocumentationExamples")
	SET(COMPONENT_DOCUMENTATION_HTML "DocumentationHTML")
	SET(COMPONENT_DOCUMENTATION_PDF  "DocumentationPDF")

	## applications
	SET(COMPONENT_BALLVIEW "BALLView")
	SET(COMPONENT_QUEASY   "QuEasy")
ELSE()
	## libraries
	SET(COMPONENT_LIBBALL "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_LIBVIEW "libVIEW${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## development
	SET(COMPONENT_LIBBALL_DEV "libBALL${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")
	SET(COMPONENT_LIBVIEW_DEV "libVIEW${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-dev")

	## Python bindings
	SET(COMPONENT_PYTHON_BINDINGS_BALL "python-ball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_PYTHON_BINDINGS_VIEW "python-ballview${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")

	## Documentation
	SET(COMPONENT_DOCUMENTATION_EXAMPLES "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-examples")
	SET(COMPONENT_DOCUMENTATION_HTML "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-html")
	SET(COMPONENT_DOCUMENTATION_PDF  "libball${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}-doc-pdf")

	## applications
	SET(COMPONENT_BALLVIEW "BALLView${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
	SET(COMPONENT_QUEASY   "QuEasy${BALL_PACKAGE_VERSION_MAJOR}.${BALL_PACKAGE_VERSION_MINOR}")
ENDIF()

INCLUDE(source/EXTENSIONS/BALLPluginComponents.cmake)

## Note: On MacOS X, it is necessary to have the applications (COMPONENT_BALLVIEW, COMPONENT_QUEASY) at the 
##       *end* of this list; otherwise, the automatic fixing of import library names will omit all components 
##       that come after it
SET(BALL_COMPONENTS
 ${COMPONENT_LIBBALL} 
 ${COMPONENT_LIBVIEW} 
 ${COMPONENT_LIBBALL_DEV} 
 ${COMPONENT_LIBVIEW_DEV}
 ${COMPONENT_PYTHON_BINDINGS_BALL}
 ${COMPONENT_PYTHON_BINDINGS_VIEW}
 ${COMPONENT_DOCUMENTATION_EXAMPLES}
 ${COMPONENT_DOCUMENTATION_HTML}
 ${COMPONENT_DOCUMENTATION_PDF}
 ${COMPONENT_PLUGINS}
 ${COMPONENT_BALLVIEW}
 "Unspecified"
)

IF (BALL_BUILD_QUEASY)
	LIST(APPEND BALL_COMPONENTS ${COMPONENT_QUEASY})
ENDIF()

LIST(REMOVE_DUPLICATES BALL_COMPONENTS)

SET_COMPONENT_NAME(${COMPONENT_LIBBALL} 
	"BALL libraries and runtime"
	"The Biochemical Algorithms Library (BALL) is a rapid application development framework written in C++. It offers a variety of data structures and algorithms for all kinds of applications arising in molecular modelling."
)

IF (NOT COMPONENT_LIBBALL STREQUAL ${COMPONENT_LIBVIEW})

	SET_COMPONENT_NAME(${COMPONENT_LIBVIEW} 
		"VIEW library"
		"The VIEW library contains BALL's functionality for molecular visualization."
	)
	SET_COMPONENT_DEPENDENCIES(${COMPONENT_LIBVIEW} ${COMPONENT_LIBBALL})

ENDIF()

SET_COMPONENT_NAME(${COMPONENT_LIBBALL_DEV}
	"Development components for BALL"
	"Files required for developing with BALL (C++ - header files, ...)"
)
SET_COMPONENT_DEPENDENCIES(${COMPONENT_LIBBALL_DEV} ${COMPONENT_LIBBALL})

IF (NOT COMPONENT_LIBBALL_DEV STREQUAL ${COMPONENT_LIBVIEW_DEV})

	SET_COMPONENT_NAME(${COMPONENT_LIBVIEW_DEV}
		"Development components for VIEW"
		"Files required for developing with VIEW (C++ - header files, ...)"
	)

	SET_COMPONENT_DEPENDENCIES(${COMPONENT_LIBVIEW_DEV} "${COMPONENT_LIBVIEW} ${COMPONENT_LIBBALL_DEV}")

ENDIF()

SET_COMPONENT_NAME(${COMPONENT_PYTHON_BINDINGS_BALL} 
	"BALL Python bindings"
	"The Python bindings can be used to develop fully functional BALL-based applications completely in Python. In addition, they allow to freely script BALLView"
)
SET_COMPONENT_DEPENDENCIES(${COMPONENT_PYTHON_BINDINGS_BALL} ${COMPONENT_LIBBALL})

IF (NOT COMPONENT_PYTHON_BINDINGS_BALL STREQUAL ${COMPONENT_PYTHON_BINDINGS_VIEW})

	SET_COMPONENT_NAME(${COMPONENT_PYTHON_BINDINGS_VIEW} 
		"BALL Python bindings"
		"The Python bindings can be used to develop fully functional BALL-based applications completely in Python. In addition, they allow to freely script BALLView"
	)
	SET_COMPONENT_DEPENDENCIES(${COMPONENT_PYTHON_BINDINGS_VIEW} "${COMPONENT_LIBVIEW} ${COMPONENT_PYTHON_BINDINGS_BALL}")

ENDIF()

SET_COMPONENT_NAME(${COMPONENT_DOCUMENTATION_HTML}
	"BALL html Documentation"
	"This package contains the full documentation to the BALL and VIEW libraries in html format"
)
SET_COMPONENT_DEPENDENCIES(${COMPONENT_DOCUMENTATION_HTML} ${COMPONENT_LIBBALL})

IF (NOT COMPONENT_DOCUMENTATION_HTML STREQUAL ${COMPONENT_DOCUMENTATION_PDF})

	SET_COMPONENT_NAME(${COMPONENT_DOCUMENTATION_PDF}
		"BALL PDF Documentation"
		"This package contains the full documentation to the BALL and VIEW libraries in PDF format"
	)
	SET_COMPONENT_DEPENDENCIES(${COMPONENT_DOCUMENTATION_PDF} ${COMPONENT_LIBBALL})

ENDIF()

IF (NOT COMPONENT_DOCUMENTATION_EXAMPLES STREQUAL ${COMPONENT_DOCUMENTATION_PDF})

	SET_COMPONENT_NAME(${COMPONENT_DOCUMENTATION_EXAMPLES}
		"BALL Usage Examples"
		"This package contains a number of examples showing the use of BALL as a library and python module"
	)
	SET_COMPONENT_DEPENDENCIES(${COMPONENT_DOCUMENTATION_EXAMPLES} ${COMPONENT_LIBBALL})

ENDIF()

SET_COMPONENT_NAME(${COMPONENT_BALLVIEW} 
	"BALLView"
	"BALLView is a feature-rich molecular viewing and modelling application based on BALL."
)
SET_COMPONENT_DEPENDENCIES(${COMPONENT_BALLVIEW} "${COMPONENT_LIBVIEW}")

IF (BALL_BUILD_QUEASY)
	SET_COMPONENT_NAME(${COMPONENT_QUEASY} 
		"QuEasy"
		"QuEasy is a frontend to BALL's QSAR capabilities"
	)
	SET_COMPONENT_DEPENDENCIES(${COMPONENT_QUEASY} "${COMPONENT_LIBVIEW}")
ENDIF()

SET(CPACK_COMPONENTS_ALL ${BALL_COMPONENTS})
