(**************************************************************************)
(*  Copyright © 2009-2013 Stéphane Glondu <steph@glondu.net>              *)
(*            © 2010-2013 Mehdi Dogguy <mehdi@dogguy.org>                 *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU Affero General Public License as        *)
(*  published by the Free Software Foundation, either version 3 of the    *)
(*  License, or (at your option) any later version, with the additional   *)
(*  exemption that compiling, linking, and/or using OpenSSL is allowed.   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  Affero General Public License for more details.                       *)
(*                                                                        *)
(*  You should have received a copy of the GNU Affero General Public      *)
(*  License along with this program.  If not, see                         *)
(*  <http://www.gnu.org/licenses/>.                                       *)
(**************************************************************************)

type frontend = {
  name : string;
  main : unit -> unit;
  anon_fun: string -> unit;
  help : (Arg.key * Arg.spec * Arg.doc) list
}

val spec : (Arg.key * Arg.spec * Arg.doc) list ref

val register_frontend : frontend -> unit
val get_frontend : string -> frontend
val get_selected_frontend : unit -> frontend
val set_selected_frontend : frontend -> unit
val available_frontends : unit -> string list

val to_string : string -> Ben.Types.expr -> string
val to_string_l : string -> Ben.Types.expr -> string list
val to_expr_l : string list -> Ben.Types.expr

val read_config : ?multi:bool -> Ben.Types.source -> Ben.Types.config
val read_ben_file : string -> Ben.Types.config
