//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Plot2D/IntensityDataWidget.h
//! @brief     Defines class IntensityDataWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAWIDGET_H
#define BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"
#include <QAction>

class IntensityDataCanvas;
class IntensityDataPropertyWidget;
class IntensityDataFFTPresenter;

//! A common widget to display color map (IntensityDataCanvas) and properties
//! (ItemPropertyWidget) of intensity data item.

class IntensityDataWidget : public DataAccessWidget {
    Q_OBJECT
public:
    IntensityDataWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_item) override;

    QList<QAction*> actionList() override;

private:
    void onContextMenuRequest(const QPoint& point);
    void onFFTAction();

    IntensityDataCanvas* m_intensityCanvas;
    IntensityDataPropertyWidget* m_propertyWidget;
    IntensityDataFFTPresenter* m_fftPresenter;
    QAction* m_togglePropertiesAction;
};

#endif // BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAWIDGET_H
