//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/SampleView.h
//! @brief     Defines class SampleView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEVIEW_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEVIEW_H

#include <QMainWindow>

class DocksController;
class Item3D;
class ProjectDocument;
class RealspacePanel;
class SampleListView;

class SampleView : public QMainWindow {
    Q_OBJECT
public:
    enum ESubWindows { PYTHONPANEL, REALSPACEPANEL, SAMPLE_LIST };

    SampleView(QWidget* parent, ProjectDocument* document);

    void toggleRealspaceView();
    void fillViewMenu(QMenu* menu);

private:
    void showEvent(QShowEvent*) override;

    void resetLayout();
    void updateSingleSampleMode();

    //! Show the item in the real space view
    //!
    //! If the real space view is not visible at the moment, it will be shown.
    void onRequestViewInRealspace(Item3D* item);

    void onAboutToRemoveItem(Item3D* item);

    void onSingleSampleModeChanged(bool newState);

    DocksController* m_docks = nullptr;
    ProjectDocument* m_document = nullptr;
    RealspacePanel* m_realspacePanel = nullptr;
    SampleListView* m_sampleSelectionView = nullptr;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEVIEW_H
