+++
title = "PlatonicTetrahedron"
+++

### PlatonicTetrahedron

A regular tetrahedron.

<img src="https://upload.wikimedia.org/wikipedia/commons/f/fc/Tetrahedron.svg" width="30%" >

<!--
<img src="../3d/PlatonicTetrahedron.png" width="30%">
<img src="../cut/PlatonicTetrahedron_xy.svg" width="30%">
<img src="../cut/PlatonicTetrahedron_xz.svg" width="30%">
-->

#### Constructor

```python
PlatonicTetrahedron(L)
```

Parameters:
- L, length of the edge

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "PlatonicTetrahedron" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V= \dfrac{\sqrt{2}}{12}L^3. $$

#### Related shapes

More general:
- [Pyramid3](/py/sample/particle/ff/hard/pyramid3), if not regular and/or truncated.

#### Example

Scattering by uncorrelated, oriented tetrahedra for horizontal incidence:

<img src="/img/auto/ff/PlatonicTetrahedron.png">

Generated by {{% ref-ex "ff/PlatonicTetrahedron.py" %}}.

#### History

Introduced in BornAgain 1.20.

Name chosen to disambiguate from "Tetrahedron", which up to BornAgain 1.19 stood for a trigonal pyramid (Pyramid3).



