//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/SpecularDataItem.h
//! @brief     Defines class SpecularDataItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DATA_SPECULARDATAITEM_H
#define BORNAGAIN_GUI_MODEL_DATA_SPECULARDATAITEM_H

#include "GUI/Model/Data/DataItem.h"
#include <qcustomplot.h>

class SpecularDataItem : public DataItem {
    Q_OBJECT
public:
    static constexpr auto M_TYPE{"SpecularData"};

    SpecularDataItem();

    // TODO: consider using index-based functions for axes' handlers

    void setDatafield(Datafield* data) override;

    // Returns min and max range of x-axis as given by IntensityData
    double xMin() const override;
    double xMax() const override;

    // Returns min and max range of y-axis as given by data
    double yMin() const override;
    double yMax() const override;
    QPair<double, double> dataRange() const;

    // Logarithmic Y scale
    bool isLog() const;
    void setLog(bool islog);

    //! Updates data on the change of axes units
    void updateCoords(const ICoordSystem&) override;

    //! Returns dimensions and axesbins of data
    std::vector<int> shape() const override;

    //! Set axes viewport to original data.
    void resetView() override;

    // Line type for plotting
    QCPGraph::LineStyle lineStyle();
    void setLineStyle(QCPGraph::LineStyle lineStyle);

    // Color for plotting
    QColor color();
    void setColor(Qt::GlobalColor color);

    // Line thickness for plotting
    double thickness();
    void setThickness(double thickness);

    // Scatter shape for plotting
    QCPScatterStyle::ScatterShape scatter();
    void setScatter(QCPScatterStyle::ScatterShape scatter);

    // Scatter size for plotting
    double scatterSize();
    void setScatterSize(double scatterSize);

    void setSimuPlotStyle();
    void setDiffPlotStyle();
    void setRealPlotStyle();

    // write/read

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

private:
    void updateAxesZoomLevel();

    QString m_lineType;
    QColor m_color;
    double m_thickness;
    QString m_scatterType;
    double m_scatterSize;
};

#endif // BORNAGAIN_GUI_MODEL_DATA_SPECULARDATAITEM_H
