//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/InterferenceForm.h
//! @brief     Defines class InterferenceForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_INTERFERENCEFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_INTERFERENCEFORM_H

#include <QGroupBox>

class GroupBoxCollapser;
class ParticleLayoutItem;
class QComboBox;
class SampleEditorController;

//! Form for editing interference functions
class InterferenceForm : public QGroupBox {
    Q_OBJECT
public:
    InterferenceForm(QWidget* parent, ParticleLayoutItem* layoutItem, SampleEditorController* ec);

    ParticleLayoutItem* layoutItem() const;
    void onInterferenceTypeChanged();

private:
    void createInterferenceWidgets();
    void updateTitle();

    GroupBoxCollapser* m_collapser = nullptr;
    QComboBox* m_interferenceTypeCombo;
    ParticleLayoutItem* m_layoutItem;
    SampleEditorController* m_ec;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_INTERFERENCEFORM_H
