//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      PyCore/Sample/ImportMultiLayer.h
//! @brief     Declares createMultiLayerFromPython.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_PYTHON
#error this header requires Python support
#endif
#ifdef SWIG
#error no need to expose this header to Swig
#endif
#ifndef BORNAGAIN_PYCORE_SAMPLE_IMPORTMULTILAYER_H
#define BORNAGAIN_PYCORE_SAMPLE_IMPORTMULTILAYER_H

#include "PyCore/Embed/PyObjectPtr.h"
#include <string>

namespace PyInterpreter {

//! Creates a core object by running python code in embedded interpreter.
void* pyscript2object(const std::string& script, const std::string& functionName,
                      const std::string& typeName, const std::string& path = "");

} // namespace PyInterpreter

#endif // BORNAGAIN_PYCORE_SAMPLE_IMPORTMULTILAYER_H
