#include "GUI/Support/Util/String.h"
#include "Tests/GTestWrapper/google_test.h"
#include <QStringList>
#include <QVector>

TEST(TestUtilsString, suggestName)
{
    EXPECT_EQ(GUI::Util::String::suggestName({"A", "B", "C"}, "A"), "A (2)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A", "B", "C"}, "D"), "D");
    EXPECT_EQ(GUI::Util::String::suggestName({"A (1)", "A (19)"}, "A"), "A (20)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A (x)"}, "A"), "A");

    EXPECT_EQ(GUI::Util::String::suggestName({"A", "A (2)"}, "A (2)"), "A (3)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A", "A (X)"}, "A (X)"), "A (X) (2)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A", "A (3)"}, "A (2)"), "A (4)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A"}, "A (2)"), "A (2)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A"}, "A (7)"), "A (7)");

    EXPECT_EQ(GUI::Util::String::suggestName({"A (0)"}, "A"), "A (1)");
    EXPECT_EQ(GUI::Util::String::suggestName({"A, A (0)"}, "A"), "A (1)");
}
