/*
 * Decompiled with CFR 0.152.
 */
package plan;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.writer.AbstractProjectWriter;
import plan.schema.ActualEffort;
import plan.schema.Appointment;
import plan.schema.Calendar;
import plan.schema.CompletionEntry;
import plan.schema.Day;
import plan.schema.Estimate;
import plan.schema.Interval;
import plan.schema.Locale;
import plan.schema.ObjectFactory;
import plan.schema.Plan;
import plan.schema.Progress;
import plan.schema.Project;
import plan.schema.Relation;
import plan.schema.Resource;
import plan.schema.ResourceGroup;
import plan.schema.ResourceRequest;
import plan.schema.ResourcegroupRequest;
import plan.schema.Schedule;
import plan.schema.Schedules;
import plan.schema.StandardWorktime;
import plan.schema.Task;
import plan.schema.UsedEffort;
import plan.schema.Weekday;

public final class PlanWriter
extends AbstractProjectWriter {
    private String m_encoding;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private Plan m_plan;
    private Project m_planProject;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private static Map<RelationType, String> RELATIONSHIP_TYPES = new HashMap<RelationType, String>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (this.m_encoding != null) {
                marshaller.setProperty("jaxb.encoding", (Object)this.m_encoding);
            }
            this.m_factory = new ObjectFactory();
            this.m_plan = this.m_factory.createPlan();
            this.writePlan();
            marshaller.marshal((Object)this.m_plan, outputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException(jAXBException.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_planProject = null;
            this.m_plan = null;
        }
    }

    private void writePlan() throws JAXBException {
        this.m_plan.setEditor("mpxjConverter");
        this.m_plan.setVersion("0.6.5");
        this.m_plan.setMime("application/x-vnd.kde.plan");
        this.m_planProject = this.m_factory.createProject();
        this.m_plan.getProjectOrPlanOrSchedule().add(this.m_planProject);
        this.writeProject();
        this.writeStandardWorktime();
        this.writeLocale();
        this.writeCalendars();
        this.writeResourceGroups();
        this.writeTasks();
        this.writeRelations();
        this.writeSchedules();
    }

    private void writeProject() {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        this.m_planProject.setId(projectHeader.getUniqueID());
        String string = projectHeader.getProjectTitle();
        if (string == null) {
            string = projectHeader.getName();
        }
        List list = this.m_projectFile.getChildTasks();
        if (string == null && !list.isEmpty()) {
            string = ((net.sf.mpxj.Task)list.get(0)).getName();
        }
        if (string == null) {
            string = "Imported project";
        }
        this.m_planProject.setLeader(projectHeader.getManager());
        this.m_planProject.setName(string);
        this.m_planProject.setStartTime(this.getDateTimeString(this.m_projectFile.getStartDate()));
        this.m_planProject.setEndTime(this.getDateTimeString(this.m_projectFile.getFinishDate()));
        String string2 = "MustStartOn";
        if (projectHeader.getScheduleFrom() == ScheduleFrom.FINISH) {
            string2 = "MustFinishOn";
        }
        this.m_planProject.setScheduling(string2);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        this.m_planProject.setTimezone(calendar.getTimeZone().getID());
    }

    private void writeStandardWorktime() {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        StandardWorktime standardWorktime = this.m_factory.createStandardWorktime();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(standardWorktime);
        standardWorktime.setDay(this.getMinutesString(projectHeader.getMinutesPerDay().longValue()));
        standardWorktime.setWeek(this.getMinutesString(projectHeader.getMinutesPerWeek().longValue()));
        standardWorktime.setMonth(this.getMinutesString(projectHeader.getMinutesPerDay().longValue() * 22L));
        standardWorktime.setYear(this.getMinutesString(projectHeader.getMinutesPerDay().longValue() * 220L));
    }

    private void writeLocale() {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        Locale locale = this.m_factory.createLocale();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(locale);
        locale.setCurrencySymbol(projectHeader.getCurrencySymbol());
        locale.setCurrencyDigits(this.getIntegerString(projectHeader.getCurrencyDigits()));
    }

    private void writeCalendars() throws JAXBException {
        for (ProjectCalendar projectCalendar : this.m_projectFile.getBaseCalendars()) {
            Calendar calendar = this.m_factory.createCalendar();
            this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(calendar);
            this.writeCalendar(projectCalendar, calendar);
        }
    }

    private void writeWeekday(ProjectCalendar projectCalendar, net.sf.mpxj.Day day, Weekday weekday) throws JAXBException {
        int[] nArray = new int[]{-1, 6, 0, 1, 2, 3, 4, 5};
        weekday.setDay(this.getIntegerString(nArray[day.getValue()]));
        weekday.setState(this.getWorkingDayString(projectCalendar, day));
        if (projectCalendar.getWorkingDay(day) == DayType.WORKING) {
            for (DateRange dateRange : projectCalendar.getCalendarHours(day)) {
                Date date = dateRange.getStart();
                Date date2 = dateRange.getEnd();
                if (date == null || date2 == null) continue;
                Interval interval = this.m_factory.createInterval();
                weekday.getInterval().add(interval);
                interval.setStart(this.getTimeString(date));
                interval.setLength(this.getIntegerString(date2.getTime() - date.getTime()));
            }
        }
    }

    private void writeCalendar(ProjectCalendar projectCalendar, Calendar calendar) throws JAXBException {
        Object object;
        calendar.setId(this.getIntegerString(projectCalendar.getUniqueID()));
        calendar.setName(this.getString(projectCalendar.getName()));
        Weekday weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.MONDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.TUESDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.WEDNESDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.THURSDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.FRIDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.SATURDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        weekday = this.m_factory.createWeekday();
        this.writeWeekday(projectCalendar, net.sf.mpxj.Day.SUNDAY, weekday);
        calendar.getCalendarOrWeekdayOrDay().add(weekday);
        for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
            object = projectCalendarException.getFromDate();
            Date date = projectCalendarException.getToDate();
            while (DateUtility.getDayStartDate((Date)object).getTime() == DateUtility.getDayEndDate((Date)date).getTime()) {
                System.out.println("Day: " + projectCalendarException);
                Day day = this.m_factory.createDay();
                calendar.getCalendarOrWeekdayOrDay().add(day);
                day.setDate(this.getDateString(projectCalendarException.getFromDate()));
                day.setState(projectCalendarException.getWorking() ? "2" : "1");
            }
        }
        for (ProjectCalendarException projectCalendarException : projectCalendar.getDerivedCalendars()) {
            object = this.m_factory.createCalendar();
            calendar.getCalendarOrWeekdayOrDay().add(object);
            this.writeCalendar((ProjectCalendar)projectCalendarException, (Calendar)object);
        }
    }

    private void writeResourceGroups() {
        ResourceGroup resourceGroup = this.m_factory.createResourceGroup();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(resourceGroup);
        resourceGroup.setId("UniqueWorkResourceGroupId");
        resourceGroup.setName("Resources");
        resourceGroup.setType("Work");
        ResourceGroup resourceGroup2 = this.m_factory.createResourceGroup();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(resourceGroup2);
        resourceGroup2.setId("UniqueMaterialResourceGroupId");
        resourceGroup2.setName("Materials");
        resourceGroup2.setType("Material");
        ResourceGroup resourceGroup3 = this.m_factory.createResourceGroup();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(resourceGroup3);
        resourceGroup3.setId("UniqueCostResourceGroupId");
        resourceGroup3.setName("Cost");
        resourceGroup3.setType("Material");
        for (net.sf.mpxj.Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getType() == ResourceType.WORK) {
                this.writeResource(resource, resourceGroup);
                continue;
            }
            if (resource.getType() == ResourceType.MATERIAL) {
                this.writeResource(resource, resourceGroup2);
                continue;
            }
            this.writeResource(resource, resourceGroup3);
        }
    }

    private void writeResource(net.sf.mpxj.Resource resource, ResourceGroup resourceGroup) {
        Resource resource2 = this.m_factory.createResource();
        resourceGroup.getResource().add(resource2);
        ProjectCalendar projectCalendar = resource.getResourceCalendar();
        if (projectCalendar != null) {
            resource2.setCalendarId(this.getIntegerString(projectCalendar.getUniqueID()));
        }
        resource2.setEmail(resource.getEmailAddress());
        resource2.setId(this.getResourceId(resource));
        resource2.setName(this.getString(resource.getName()));
        resource2.setInitials(resource.getInitials());
        resource2.setType(resource.getType() == ResourceType.MATERIAL ? "Material" : "Work");
        resource2.setUnits("100");
        Rate rate = resource.getStandardRate();
        if (rate != null) {
            resource2.setNormalRate(Double.toString(rate.getAmount()));
        }
        if ((rate = resource.getOvertimeRate()) != null) {
            resource2.setOvertimeRate(Double.toString(rate.getAmount()));
        }
    }

    private void writeTasks() throws JAXBException {
        for (net.sf.mpxj.Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task, this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams());
        }
    }

    private void writeTask(net.sf.mpxj.Task task, List<Object> list) throws JAXBException {
        Task task2 = this.m_factory.createTask();
        list.add(task2);
        task2.setId(this.getTaskId(task));
        task2.setWbs(task.getWBS());
        task2.setName(this.getString(task.getName()));
        task2.setScheduling(this.getSchedulingString(task.getConstraintType()));
        this.writeEstimate(task, task2);
        this.writeRequests(task, task2);
        this.writeTaskSchedules(task, task2);
        String string = task.getNotes();
        if (string != null) {
            task2.setDescription(string);
        }
        this.writeProgress(task, task2);
        for (net.sf.mpxj.Task task3 : task.getChildTasks()) {
            this.writeTask(task3, task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress());
        }
    }

    private void writeRequests(net.sf.mpxj.Task task, Task task2) {
        System.out.println("writeRequests: " + task + ", " + task2);
        if (task.getMilestone() || !task.getChildTasks().isEmpty()) {
            return;
        }
        ResourcegroupRequest resourcegroupRequest = null;
        ResourcegroupRequest resourcegroupRequest2 = null;
        ResourcegroupRequest resourcegroupRequest3 = null;
        for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
            System.out.println("writeRequests: " + resourceAssignment + " : " + resourceAssignment.getResource());
            if (resourceAssignment.getResource() == null) continue;
            ResourcegroupRequest resourcegroupRequest4 = null;
            if (resourceAssignment.getResource().getType() == ResourceType.MATERIAL) {
                if (resourcegroupRequest2 == null) {
                    resourcegroupRequest2 = this.m_factory.createResourcegroupRequest();
                    task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(resourcegroupRequest2);
                    resourcegroupRequest2.setGroupId("UniqueMaterialResourceGroupId");
                }
                resourcegroupRequest4 = resourcegroupRequest2;
            } else if (resourceAssignment.getResource().getType() == ResourceType.WORK) {
                if (resourcegroupRequest == null) {
                    resourcegroupRequest = this.m_factory.createResourcegroupRequest();
                    task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(resourcegroupRequest);
                    resourcegroupRequest.setGroupId("UniqueWorkResourceGroupId");
                }
                resourcegroupRequest4 = resourcegroupRequest;
            } else if (resourceAssignment.getResource().getType() == ResourceType.COST) {
                if (resourcegroupRequest3 == null) {
                    resourcegroupRequest3 = this.m_factory.createResourcegroupRequest();
                    task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(resourcegroupRequest3);
                    resourcegroupRequest3.setGroupId("UniqueCostResourceGroupId");
                }
                resourcegroupRequest4 = resourcegroupRequest;
            }
            if (resourcegroupRequest4 == null) continue;
            this.writeRequest(resourceAssignment, resourcegroupRequest4);
        }
    }

    private void writeRequest(ResourceAssignment resourceAssignment, ResourcegroupRequest resourcegroupRequest) {
        ResourceRequest resourceRequest = this.m_factory.createResourceRequest();
        resourcegroupRequest.getResourceRequest().add(resourceRequest);
        resourceRequest.setResourceId(this.getResourceId(resourceAssignment.getResource()));
        resourceRequest.setUnits(this.getIntegerString(resourceAssignment.getUnits()));
    }

    private void writeEstimate(net.sf.mpxj.Task task, Task task2) {
        Estimate estimate = this.m_factory.createEstimate();
        task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(estimate);
        estimate.setType(this.getEstimateType(task.getType()));
        if (task.getMilestone()) {
            estimate.setExpected("0");
            estimate.setOptimistic("0");
            estimate.setPessimistic("0");
        } else {
            Duration duration = task.getDuration();
            if (task.getType() == TaskType.FIXED_DURATION) {
                switch (duration.getUnits()) {
                    case MINUTES: 
                    case HOURS: 
                    case DAYS: 
                    case WEEKS: 
                    case MONTHS: 
                    case YEARS: {
                        estimate.setCalendarId(this.getIntegerString(((ProjectCalendar)this.m_projectFile.getBaseCalendars().get(0)).getUniqueID()));
                        break;
                    }
                }
            } else {
                switch (duration.getUnits()) {
                    case ELAPSED_MINUTES: {
                        duration = duration.convertUnits(TimeUnit.MINUTES, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case ELAPSED_HOURS: {
                        duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case ELAPSED_DAYS: {
                        duration = duration.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case ELAPSED_WEEKS: {
                        duration = duration.convertUnits(TimeUnit.WEEKS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case ELAPSED_MONTHS: {
                        duration = duration.convertUnits(TimeUnit.MONTHS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case ELAPSED_YEARS: {
                        duration = duration.convertUnits(TimeUnit.YEARS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                }
            }
            estimate.setUnit(this.getUnitString(duration));
            String string = this.getEstimateString(duration);
            estimate.setExpected(string);
            estimate.setOptimistic(string);
            estimate.setPessimistic(string);
        }
    }

    private void writeProgress(net.sf.mpxj.Task task, Task task2) {
        if (task.getActualStart() == null) {
            return;
        }
        Progress progress = this.m_factory.createProgress();
        task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(progress);
        progress.setEntrymode("EnterEffortPerResource");
        progress.setStarted("1");
        progress.setStartTime(this.getDateTimeString(task.getActualStart()));
        if (task.getActualFinish() != null) {
            progress.setFinished("1");
            progress.setFinishTime(this.getDateTimeString(task.getActualFinish()));
        }
        this.writeCompletion(task, progress);
        this.writeUsedEffort(task, progress);
    }

    private void writeCompletion(net.sf.mpxj.Task task, Progress progress) {
        CompletionEntry completionEntry = this.m_factory.createCompletionEntry();
        progress.getCompletionEntryOrUsedEffort().add(completionEntry);
        Date date = task.getActualStart();
        if (task.getActualFinish() != null) {
            date = task.getActualFinish();
        }
        completionEntry.setDate(this.getDateTimeString(date));
        completionEntry.setPercentFinished(this.getIntegerString(task.getPercentageWorkComplete()));
        Duration duration = task.getActualWork();
        completionEntry.setPerformedEffort(this.getDurationString(duration));
        duration = task.getRemainingWork();
        completionEntry.setRemainingEffort(this.getDurationString(duration));
    }

    private void writeUsedEffort(net.sf.mpxj.Task task, Progress progress) {
        List list = task.getResourceAssignments();
        if (list.isEmpty()) {
            return;
        }
        UsedEffort usedEffort = this.m_factory.createUsedEffort();
        progress.getCompletionEntryOrUsedEffort().add(usedEffort);
        for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
            Resource resource = this.m_factory.createResource();
            usedEffort.getResource().add(resource);
            resource.setId(this.getResourceId(resourceAssignment.getResource()));
            this.writeActualEffort(resourceAssignment, resource);
        }
    }

    private void writeActualEffort(ResourceAssignment resourceAssignment, Resource resource) {
        if (resourceAssignment.getActualStart() == null) {
            return;
        }
        ActualEffort actualEffort = this.m_factory.createActualEffort();
        resource.getActualEffort().add(actualEffort);
        List list = resourceAssignment.getTimephasedComplete();
        if (list.isEmpty()) {
            Date date = resourceAssignment.getActualStart();
            if (resourceAssignment.getActualFinish() != null) {
                date = resourceAssignment.getActualFinish();
            }
            actualEffort.setDate(this.getDateTimeString(date));
            actualEffort.setOvertimeEffort(this.getDurationString(resourceAssignment.getOvertimeWork()));
            actualEffort.setNormalEffort(this.getDurationString(resourceAssignment.getActualWork()));
        } else {
            for (TimephasedResourceAssignment timephasedResourceAssignment : list) {
                this.writeActualEffort(timephasedResourceAssignment, actualEffort);
            }
        }
    }

    private void writeActualEffort(TimephasedResourceAssignment timephasedResourceAssignment, ActualEffort actualEffort) {
        Date date = DateUtility.getDayStartDate((Date)timephasedResourceAssignment.getStart());
        long l = DateUtility.getDayEndDate((Date)timephasedResourceAssignment.getFinish()).getTime();
        while (date.getTime() < l) {
            actualEffort.setDate(this.getDateString(date));
            actualEffort.setNormalEffort(this.getDurationString(timephasedResourceAssignment.getWorkPerDay()));
            date = this.addDays(date, 1);
        }
    }

    private void writeTaskSchedules(net.sf.mpxj.Task task, Task task2) {
        Schedules schedules = this.m_factory.createSchedules();
        task2.getTaskOrEstimateOrDocumentsOrResourcegroupRequestOrSchedulesOrProgress().add(schedules);
        Schedule schedule = this.m_factory.createSchedule();
        schedules.getPlanOrSchedule().add(schedule);
        this.writeTaskSchedule(task, schedule);
    }

    private void writeTaskSchedule(net.sf.mpxj.Task task, Schedule schedule) {
        schedule.setId("1");
        schedule.setName("Plan");
        schedule.setType("Expected");
        schedule.setStart(this.getDateTimeString(task.getStart()));
        schedule.setEnd(this.getDateTimeString(task.getFinish()));
        schedule.setDuration(this.getDurationString(task.getStart(), task.getFinish()));
        schedule.setEarlystart(this.getDateTimeString(task.getEarlyStart()));
        schedule.setEarlyfinish(this.getDateTimeString(task.getEarlyFinish()));
        schedule.setLatestart(this.getDateTimeString(task.getLateStart()));
        schedule.setLatefinish(this.getDateTimeString(task.getLateFinish()));
        schedule.setPositiveFloat(this.getDurationString(task.getTotalSlack()));
        schedule.setFreeFloat(this.getDurationString(task.getFreeSlack()));
        schedule.setNotScheduled("0");
        schedule.setSchedulingConflict("0");
        schedule.setResourceError("0");
        schedule.setResourceOverbooked("0");
        schedule.setResourceNotAvailable("0");
        schedule.setInCriticalPath("0");
    }

    private void writeRelations() {
        for (net.sf.mpxj.Task task : this.m_projectFile.getAllTasks()) {
            List list = task.getPredecessors();
            if (list == null) continue;
            for (net.sf.mpxj.Relation relation : list) {
                net.sf.mpxj.Task task2 = relation.getSourceTask();
                net.sf.mpxj.Task task3 = relation.getTargetTask();
                Relation relation2 = this.m_factory.createRelation();
                relation2.setParentId(this.getTaskId(task3));
                relation2.setChildId(this.getTaskId(task2));
                relation2.setLag(this.getDurationString(relation.getLag()));
                relation2.setType(RELATIONSHIP_TYPES.get(relation.getType()));
                this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(relation2);
            }
        }
    }

    private void writeSchedules() {
        Schedules schedules = this.m_factory.createSchedules();
        this.m_planProject.getWbsDefinitionOrLocaleOrAccountsOrCalendarOrStandardWorktimeOrResourceGroupOrTaskOrRelationOrSchedulesOrResourceTeams().add(schedules);
        Plan plan = this.m_factory.createPlan();
        schedules.getPlanOrSchedule().add(plan);
        this.writePlan(plan);
        Schedule schedule = this.m_factory.createSchedule();
        plan.getProjectOrPlanOrSchedule().add(schedule);
        this.writeSchedule(schedule);
        this.writeAppointments(schedule);
    }

    private void writePlan(Plan plan) {
        plan.setId("1");
        plan.setName("Plan");
    }

    private void writeSchedule(Schedule schedule) {
        schedule.setId("1");
        schedule.setName("Plan");
        schedule.setType("Expected");
    }

    private void writeAppointments(Schedule schedule) {
        Date date = null;
        Date date2 = null;
        HashMap hashMap = new HashMap();
        for (ResourceAssignment resourceAssignment : this.m_projectFile.getAllResourceAssignments()) {
            net.sf.mpxj.Task task = resourceAssignment.getTask();
            net.sf.mpxj.Resource resource = resourceAssignment.getResource();
            if (task != null && resource != null) {
                Appointment appointment = this.m_factory.createAppointment();
                schedule.getCriticalpathListOrAppointment().add(appointment);
                appointment.setTaskId(this.getTaskId(task));
                appointment.setResourceId(this.getResourceId(resource));
                this.writeIntervals(appointment, resourceAssignment);
            }
            if (DateUtility.compare((Date)task.getStart(), (Date)date) < 0) {
                date = task.getStart();
            }
            if (DateUtility.compare((Date)date2, (Date)task.getFinish()) <= 0) continue;
            date2 = task.getFinish();
        }
        if (date == null) {
            date = this.m_projectFile.getStartDate();
        }
        if (date2 == null) {
            date2 = this.m_projectFile.getFinishDate();
        }
        schedule.setStart(this.getDateTimeString(date));
        schedule.setEnd(this.getDateTimeString(date2));
        schedule.setDuration(this.getDurationString(date, date2));
    }

    private void writeIntervals(Appointment appointment, ResourceAssignment resourceAssignment) {
        Date date = resourceAssignment.getStart();
        Date date2 = resourceAssignment.getFinish();
        ProjectCalendar projectCalendar = resourceAssignment.getCalendar();
        Date date3 = DateUtility.getCanonicalTime((Date)date2);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        Boolean bl = false;
        while (date.getTime() <= date2.getTime()) {
            Date date4 = DateUtility.getCanonicalTime((Date)date);
            calendar.setTime(date);
            net.sf.mpxj.Day day = net.sf.mpxj.Day.getInstance((int)calendar.get(7));
            ProjectCalendarHours projectCalendarHours = projectCalendar.getHours(day);
            for (DateRange dateRange : projectCalendarHours) {
                Date date5 = dateRange.getStart();
                Date date6 = dateRange.getEnd();
                Date date7 = PlanWriter.setTime(date, date5);
                Date date8 = new Date(date7.getTime() + date6.getTime() - date5.getTime());
                if (date7.getTime() < date.getTime()) {
                    date7 = date;
                }
                if (date8.getTime() > date2.getTime()) {
                    date8 = date2;
                }
                if (date7.getTime() >= date8.getTime()) continue;
                Interval interval = this.m_factory.createInterval();
                appointment.getInterval().add(interval);
                interval.setStart(this.getDateTimeString(date7));
                interval.setEnd(this.getDateTimeString(date8));
                interval.setLoad(this.getIntegerString(resourceAssignment.getUnits()));
                bl = true;
            }
            calendar.setTime(date);
            calendar.add(5, 1);
            date = DateUtility.getDayStartDate((Date)calendar.getTime());
        }
        if (!bl.booleanValue()) {
            System.out.println("writeIntervals: No intervals! " + resourceAssignment);
        }
    }

    private String getDateTime(Date date) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (date != null) {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date);
            stringBuffer.append(this.m_fourDigitFormat.format(calendar.get(1)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(2) + 1));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(5)));
            stringBuffer.append("T");
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(11)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(12)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(13)));
            stringBuffer.append("Z");
        }
        return stringBuffer.toString();
    }

    private String getIntegerString(Number number) {
        return number == null ? null : Integer.toString(number.intValue());
    }

    private String getIntegerString(int n) {
        return Integer.toString(n);
    }

    private boolean isWorkingDay(ProjectCalendar projectCalendar, net.sf.mpxj.Day day) {
        boolean bl = false;
        switch (projectCalendar.getWorkingDay(day)) {
            case WORKING: {
                bl = true;
                break;
            }
            case NON_WORKING: {
                bl = false;
                break;
            }
            case DEFAULT: {
                bl = this.isWorkingDay(projectCalendar.getBaseCalendar(), day);
            }
        }
        return bl;
    }

    private String getWorkingDayString(ProjectCalendar projectCalendar, net.sf.mpxj.Day day) {
        String string = null;
        switch (projectCalendar.getWorkingDay(day)) {
            case WORKING: {
                string = "2";
                break;
            }
            case NON_WORKING: {
                string = "1";
                break;
            }
            case DEFAULT: {
                string = "0";
            }
        }
        return string;
    }

    private String getTimeString(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.m_twoDigitFormat.format(n));
        stringBuffer.append(':');
        stringBuffer.append(this.m_twoDigitFormat.format(n2));
        stringBuffer.append(':');
        stringBuffer.append(this.m_twoDigitFormat.format(n3));
        return stringBuffer.toString();
    }

    private String getDateString(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.m_fourDigitFormat.format(n));
        stringBuffer.append('-');
        stringBuffer.append(this.m_twoDigitFormat.format(n2));
        stringBuffer.append('-');
        stringBuffer.append(this.m_twoDigitFormat.format(n3));
        return stringBuffer.toString();
    }

    private String getDateTimeString(Date date) {
        String string = null;
        if (date != null) {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date);
            Integer n = calendar.getTimeZone().getOffset(calendar.getTime().getTime()) / 60000;
            StringBuffer stringBuffer = new StringBuffer(23);
            stringBuffer.append(this.m_fourDigitFormat.format(calendar.get(1)));
            stringBuffer.append('-');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(2) + 1));
            stringBuffer.append('-');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(5)));
            stringBuffer.append('T');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(11)));
            stringBuffer.append(':');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(12)));
            stringBuffer.append(':');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(13)));
            stringBuffer.append(n < 0 ? (char)'-' : '+');
            stringBuffer.append(this.m_twoDigitFormat.format(n / 60));
            stringBuffer.append(':');
            stringBuffer.append(this.m_twoDigitFormat.format(n % 60));
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getMinutesString(long l) {
        long l2 = l % 60L;
        long l3 = l / 60L;
        return Long.toString(l3) + 'h' + Long.toString(l2) + 'm';
    }

    private String getDurationString(long l) {
        long l2 = l % 1000L;
        long l3 = (l /= 1000L) % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = (l /= 60L) % 24L;
        long l6 = l /= 24L;
        String string = Long.toString(l6) + ' ' + Long.toString(l5) + ':' + Long.toString(l4) + ':' + Long.toString(l3) + '.' + Long.toString(l2);
        return string;
    }

    private String getDurationString(Date date, Date date2) {
        if (date == null || date2 == null) {
            return this.getDurationString(0L);
        }
        return this.getDurationString(date2.getTime() - date.getTime());
    }

    private String getDurationString(Duration duration) {
        double d = 0.0;
        if (duration != null) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    d = duration.getDuration() * 60.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    d = duration.getDuration() * 3600.0;
                    break;
                }
                case DAYS: {
                    double d2 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    d = duration.getDuration() * (d2 * 60.0);
                    break;
                }
                case ELAPSED_DAYS: {
                    d = duration.getDuration() * 86400.0;
                    break;
                }
                case WEEKS: {
                    double d3 = this.m_projectFile.getProjectHeader().getMinutesPerWeek().doubleValue();
                    d = duration.getDuration() * (d3 * 60.0);
                    break;
                }
                case ELAPSED_WEEKS: {
                    d = duration.getDuration() * 604800.0;
                    break;
                }
                case MONTHS: {
                    double d4 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double d5 = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (d5 * d4 * 60.0);
                    break;
                }
                case ELAPSED_MONTHS: {
                    d = duration.getDuration() * 2592000.0;
                    break;
                }
                case YEARS: {
                    double d6 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double d7 = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (12.0 * d7 * d6 * 60.0);
                    break;
                }
                case ELAPSED_YEARS: {
                    d = duration.getDuration() * 3.1536E7;
                    break;
                }
            }
        }
        return this.getDurationString((long)(d * 1000.0));
    }

    private String getEstimateString(Duration duration) {
        double d = duration.getDuration();
        return "" + d;
    }

    private String getUnitString(Duration duration) {
        String string = "d";
        if (duration != null) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    string = "m";
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    string = "h";
                    break;
                }
                case DAYS: 
                case ELAPSED_DAYS: {
                    string = "d";
                    break;
                }
                case WEEKS: 
                case ELAPSED_WEEKS: {
                    string = "w";
                    break;
                }
                case MONTHS: 
                case ELAPSED_MONTHS: {
                    string = "M";
                    break;
                }
                case YEARS: 
                case ELAPSED_YEARS: {
                    string = "Y";
                    break;
                }
            }
        }
        return string;
    }

    private String getEstimateType(TaskType taskType) {
        String string = "Effort";
        if (taskType != null && taskType == TaskType.FIXED_DURATION) {
            string = "Duration";
        }
        return string;
    }

    private String getString(String string) {
        return string == null ? "" : string;
    }

    private String getResourceId(net.sf.mpxj.Resource resource) {
        return resource.getGUID() == null ? this.getIntegerString(resource.getUniqueID()) : resource.getGUID().toString();
    }

    private String getTaskId(net.sf.mpxj.Task task) {
        return task.getGUID() == null ? this.getIntegerString(task.getUniqueID()) : task.getGUID().toString();
    }

    private String getSchedulingString(ConstraintType constraintType) {
        String string = "ASAP";
        switch (constraintType) {
            case AS_SOON_AS_POSSIBLE: {
                string = "ASAP";
                break;
            }
            case AS_LATE_AS_POSSIBLE: {
                string = "ALAP";
                break;
            }
            case MUST_START_ON: {
                string = "MustStartOn";
                break;
            }
            case MUST_FINISH_ON: {
                string = "MustFinishOn";
                break;
            }
            case START_NO_EARLIER_THAN: {
                string = "StartNotEarlier";
                break;
            }
            case START_NO_LATER_THAN: {
                string = "ASAP";
                break;
            }
            case FINISH_NO_EARLIER_THAN: {
                string = "ALAP";
                break;
            }
            case FINISH_NO_LATER_THAN: {
                string = "FinishNotLater";
                break;
            }
        }
        return string;
    }

    public static Date setTime(Date date, Date date2) {
        Date date3;
        if (date2 == null) {
            date3 = date;
        } else {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date2);
            calendar.set(6, 1);
            calendar.set(1, 1970);
            calendar.set(14, 0);
            Date date4 = calendar.getTime();
            date3 = DateUtility.getDayStartDate((Date)date);
            long l = date4.getTime();
            date3 = new Date(date3.getTime() + l);
        }
        return date3;
    }

    public Date addDays(Date date, int n) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "Finish-Finish");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "Finish-Start");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "Finish-Start");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "Start-Start");
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"plan.schema", (ClassLoader)PlanWriter.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

