#!
#! \addtogroup CamiTKMacros
#!
#! camitk_init_test is a macro to initialize a group of test (for the same command)
#! It is used to initialize a series of tests for a given target.
#! Usually this is placed in the same CMakeLists.txt as the add_executable() cmake instruction or
#! camitk_application() macro
#!
#! It does few useful things:
#! - check if the target (name of the executable to run) is properly defined
#! - initialize test id (then automatically incremented in camitk_test_declare
#! - initialize test output directory
#!
#! Usage:
#! \code
#! camitk_init_test(target)
#! \endcode
#!
#! \param target (required)   The executable target to use during all the test series
#!
#! Example invocation:
#!
#! \code
#!
#! add_executable(myprogram)
#!
#! ...
#! # Start the test series for myprogram
#! camitk_init_test(myprogram)
#! camitk_add_test(...) # will be called myprogram_1
#! ...
#! camitk_add_test(...) # myprogram_2
#!
#! \endcode
#
#! @sa camitk_add_test
macro(camitk_init_test)
    parse_arguments(CAMITK_INIT_TEST
        ""  # possible lists
        ""
        ${ARGN}
    )

    set(CAMITK_TEST_ID "0")
    set(CAMITK_TEST_LIST "")

    # check for executable
    if(NOT CAMITK_INIT_TEST_DEFAULT_ARGS)
        message(FATAL_ERROR "Initializing test ${CAMITK_TEST_BASENAME} cannot proceed: please specify the target in brackets")
    else()
        if(NOT TARGET ${CAMITK_INIT_TEST_DEFAULT_ARGS})
        message(FATAL_ERROR "Initializing test ${CAMITK_TEST_BASENAME} cannot proceed: ${CAMITK_INIT_TEST_DEFAULT_ARGS} is not a proper target")
        endif()
    endif()

    set(CAMITK_TEST_BASENAME ${CAMITK_INIT_TEST_DEFAULT_ARGS})
    message(STATUS "Initializing test series for ${CAMITK_TEST_BASENAME}")

    set(CAMITK_INIT_TEST_EXECUTABLE ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${CAMITK_INIT_TEST_DEFAULT_ARGS})

endmacro()
