/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file OffComponent.h
 * @brief Component class for .off files.
 * @author Sonia Selmi
 * @date July 30 2012
 */

#ifndef OFF_COMPONENT_H
#define OFF_COMPONENT_H

#include <MeshComponent.h>

/**
 * @class OffComponent
 * @brief The manager of the .off
 */
class OffComponent : public camitk::MeshComponent {

    Q_OBJECT

public:

    Q_PROPERTY(int nbPoints READ getNbPoints);

    Q_PROPERTY(int nbElements READ getNbElements);

    /// default constructor
    OffComponent(const QString & file) throw(camitk::AbortException);

    /// methods needed to manage the read-only static properties
    int getNbPoints();

    /// total number of elements
    int getNbElements();

private:

    /// create and initialize dynamic properties
    void initDynamicProperties();
    
    /// number of elements (i.e., cells)
    int nbElements;

    /// number of points
    int nbPoints;
};

#endif
