/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2023 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef EXPORTASMDL_H
#define EXPORTASMDL_H

#include <Action.h>

#include <MeshComponent.h>
#include <QLineEdit>

class ExportAsMDL : public camitk::Action {
    Q_OBJECT
public:

    /// Default Constructor
    ExportAsMDL(camitk::ActionExtension*);

    /// Default Destructor
    virtual ~ExportAsMDL();

    // Reimplemented from Action parent class
    virtual QWidget* getWidget();

public slots:
    /** this method is automatically called when the action is triggered.
      * Call getTargets() method to get the list of components to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of ExportAsMDL (or a subclass).
      */
    virtual camitk::Action::ApplyStatus apply();

    /// slot opening a QFileDialog to provide the output file path in a .mdl format
    void outputMDL();

    /// slot retrieving text edited in the output file QLineEdit
    void outputFileChanged(const QString&);

private:
    /// helper method to simplify the target component processing
    ApplyStatus process(camitk::MeshComponent*);

    /// output file
    QString filename;

    /// output file editor
    QLineEdit* outputfile;

    /// export MeshComponent in MDL format
    void saveMeshComponentToMDL(camitk::MeshComponent*);

};

#endif // EXPORTASMDL_H

