/* 

Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

C.a.R. is a free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

C.a.R. is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
package rene.zirkel.tools;

// file: Binder.java
import java.awt.event.MouseEvent;

import rene.gui.Global;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;

public class JSmacroTool extends ObjectConstructor implements Selector {

    ObjectConstructor OC;
    String MSG;
    String TYPE;

    public JSmacroTool(final ZirkelCanvas zc, final String msg, String type, final ObjectConstructor oc) {
        OC=oc;
        MSG=msg;
        TYPE=type;
        zc.repaint();
    }

    @Override
    public void mousePressed(final MouseEvent e, final ZirkelCanvas zc) {
        ConstructionObject o=null;
        if (TYPE.equals("Point")) {
            o=zc.selectCreatePoint(e.getX(), e.getY(), e.isAltDown());
            Global.setJSO(o);
        } else if (TYPE.equals("Segment")) {
            o=zc.selectSegment(e.getX(), e.getY());
            Global.setJSO(o);
        } else if (TYPE.equals("Line")) {
            o=zc.selectLine(e.getX(), e.getY());
            Global.setJSO(o);
        } else if (TYPE.equals("Circle")) {
            o=zc.selectCircle(e.getX(), e.getY());
            Global.setJSO(o);
        } else if (TYPE.equals("Expression")) {
            o=zc.selectObject(e.getX(), e.getY());
            Global.setJSO(o);
        }
        if (Global.getJSO()!=null) {
            o.setSelected(true);
        } else {
            Global.setJSquit(true);
        }
    }

    @Override
    public void mouseMoved(final MouseEvent e, final ZirkelCanvas zc,
            final boolean simple) {
        if (TYPE.equals("Point")) {
            zc.indicateCreatePoint(e.getX(), e.getY(), true);
        } else {
            zc.indicateWithSelector(e.getX(), e.getY(), this);
        }
    }

    public boolean isAdmissible(final ZirkelCanvas zc,
            final ConstructionObject o) {
        if ((o instanceof PointObject)&&(TYPE.equals("Point"))) {
            return true;
        } else if ((o instanceof PrimitiveLineObject)&&(TYPE.equals("Line"))) {
            return true;
        } else if ((o instanceof PrimitiveCircleObject)&&(TYPE.equals("Circle"))) {
            return true;
        } else if ((o instanceof SegmentObject)&&(TYPE.equals("Segment"))) {
            return true;
        } else if ((o instanceof ExpressionObject)&&(TYPE.equals("Expression"))) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void showStatus(final ZirkelCanvas zc) {
        zc.showStatus(MSG);
    }

    @Override
    public void reset(final ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(OC);
        zc.validate();
        zc.repaint();
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}
