#pragma once

#include "common/Log.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Function declaration macros - to move into glplatform.h */

#if defined(_WIN32) && !defined(APIENTRY)
#define WIN32_LEAN_AND_MEAN 1
#ifndef WINAPI
#define WINAPI __stdcall
#endif
#define APIENTRY WINAPI
#endif

#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef APIENTRYP
#define APIENTRYP APIENTRY *
#endif
#ifndef GLAPI
#define GLAPI extern
#endif

/* -------------------------------- DATA TYPES ------------------------------- */

#include <stddef.h>
#ifndef GLEXT_64_TYPES_DEFINED
/* This code block is duplicated in glxext.h, so must be protected */
#define GLEXT_64_TYPES_DEFINED
/* Define int32_t, int64_t, and uint64_t types for UST/MSC */
/* (as used in the GL_EXT_timer_query extension). */
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
#elif defined(__sun__) || defined(__digital__)
#include <inttypes.h>
#if defined(__STDC__)
#if defined(__arch64__) || defined(_LP64)
typedef long int int64_t;
typedef unsigned long int uint64_t;
#else
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#endif /* __arch64__ */
#endif /* __STDC__ */
#elif defined( __VMS ) || defined(__sgi)
#include <inttypes.h>
#elif defined(__SCO__) || defined(__USLC__)
#include <stdint.h>
#elif defined(__UNIXOS2__) || defined(__SOL64__)
typedef long int int32_t;
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#elif defined(_WIN32) && defined(__GNUC__)
#include <stdint.h>
#elif defined(_WIN32)
typedef __int32 int32_t;
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#else
/* Fallback if nothing above works */
#include <inttypes.h>
#endif
#endif
typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef void GLvoid;
typedef signed char GLbyte;
typedef short GLshort;
typedef int GLint;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned int GLuint;
typedef int GLsizei;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef char GLchar;
typedef unsigned short GLhalf;
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
typedef int64_t GLint64;
typedef uint64_t GLuint64;
typedef struct __GLsync *GLsync;
typedef void (APIENTRY *GLDEBUGPROCARB)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);

/* ----------------------------------- ENUMS --------------------------------- */

/* GL_VERSION_1_1 */

#define GL_DEPTH_BUFFER_BIT 0x00000100
#define GL_STENCIL_BUFFER_BIT 0x00000400
#define GL_COLOR_BUFFER_BIT 0x00004000
#define GL_FALSE 0
#define GL_TRUE 1
#define GL_POINTS 0x0000
#define GL_LINES 0x0001
#define GL_LINE_LOOP 0x0002
#define GL_LINE_STRIP 0x0003
#define GL_TRIANGLES 0x0004
#define GL_TRIANGLE_STRIP 0x0005
#define GL_TRIANGLE_FAN 0x0006
#define GL_NEVER 0x0200
#define GL_LESS 0x0201
#define GL_EQUAL 0x0202
#define GL_LEQUAL 0x0203
#define GL_GREATER 0x0204
#define GL_NOTEQUAL 0x0205
#define GL_GEQUAL 0x0206
#define GL_ALWAYS 0x0207
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA_SATURATE 0x0308
#define GL_NONE 0
#define GL_FRONT_LEFT 0x0400
#define GL_FRONT_RIGHT 0x0401
#define GL_BACK_LEFT 0x0402
#define GL_BACK_RIGHT 0x0403
#define GL_FRONT 0x0404
#define GL_BACK 0x0405
#define GL_LEFT 0x0406
#define GL_RIGHT 0x0407
#define GL_FRONT_AND_BACK 0x0408
#define GL_NO_ERROR 0
#define GL_INVALID_ENUM 0x0500
#define GL_INVALID_VALUE 0x0501
#define GL_INVALID_OPERATION 0x0502
#define GL_OUT_OF_MEMORY 0x0505
#define GL_CW 0x0900
#define GL_CCW 0x0901
#define GL_POINT_SIZE 0x0B11
#define GL_POINT_SIZE_RANGE 0x0B12
#define GL_POINT_SIZE_GRANULARITY 0x0B13
#define GL_LINE_SMOOTH 0x0B20
#define GL_LINE_WIDTH 0x0B21
#define GL_LINE_WIDTH_RANGE 0x0B22
#define GL_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_POLYGON_MODE 0x0B40
#define GL_POLYGON_SMOOTH 0x0B41
#define GL_CULL_FACE 0x0B44
#define GL_CULL_FACE_MODE 0x0B45
#define GL_FRONT_FACE 0x0B46
#define GL_DEPTH_RANGE 0x0B70
#define GL_DEPTH_TEST 0x0B71
#define GL_DEPTH_WRITEMASK 0x0B72
#define GL_DEPTH_CLEAR_VALUE 0x0B73
#define GL_DEPTH_FUNC 0x0B74
#define GL_STENCIL_TEST 0x0B90
#define GL_STENCIL_CLEAR_VALUE 0x0B91
#define GL_STENCIL_FUNC 0x0B92
#define GL_STENCIL_VALUE_MASK 0x0B93
#define GL_STENCIL_FAIL 0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define GL_STENCIL_REF 0x0B97
#define GL_STENCIL_WRITEMASK 0x0B98
#define GL_VIEWPORT 0x0BA2
#define GL_DITHER 0x0BD0
#define GL_BLEND_DST 0x0BE0
#define GL_BLEND_SRC 0x0BE1
#define GL_BLEND 0x0BE2
#define GL_LOGIC_OP_MODE 0x0BF0
#define GL_COLOR_LOGIC_OP 0x0BF2
#define GL_DRAW_BUFFER 0x0C01
#define GL_READ_BUFFER 0x0C02
#define GL_SCISSOR_BOX 0x0C10
#define GL_SCISSOR_TEST 0x0C11
#define GL_COLOR_CLEAR_VALUE 0x0C22
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_DOUBLEBUFFER 0x0C32
#define GL_STEREO 0x0C33
#define GL_LINE_SMOOTH_HINT 0x0C52
#define GL_POLYGON_SMOOTH_HINT 0x0C53
#define GL_UNPACK_SWAP_BYTES 0x0CF0
#define GL_UNPACK_LSB_FIRST 0x0CF1
#define GL_UNPACK_ROW_LENGTH 0x0CF2
#define GL_UNPACK_SKIP_ROWS 0x0CF3
#define GL_UNPACK_SKIP_PIXELS 0x0CF4
#define GL_UNPACK_ALIGNMENT 0x0CF5
#define GL_PACK_SWAP_BYTES 0x0D00
#define GL_PACK_LSB_FIRST 0x0D01
#define GL_PACK_ROW_LENGTH 0x0D02
#define GL_PACK_SKIP_ROWS 0x0D03
#define GL_PACK_SKIP_PIXELS 0x0D04
#define GL_PACK_ALIGNMENT 0x0D05
#define GL_MAX_TEXTURE_SIZE 0x0D33
#define GL_MAX_VIEWPORT_DIMS 0x0D3A
#define GL_SUBPIXEL_BITS 0x0D50
#define GL_TEXTURE_1D 0x0DE0
#define GL_TEXTURE_2D 0x0DE1
#define GL_POLYGON_OFFSET_UNITS 0x2A00
#define GL_POLYGON_OFFSET_POINT 0x2A01
#define GL_POLYGON_OFFSET_LINE 0x2A02
#define GL_POLYGON_OFFSET_FILL 0x8037
#define GL_POLYGON_OFFSET_FACTOR 0x8038
#define GL_TEXTURE_BINDING_1D 0x8068
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_TEXTURE_WIDTH 0x1000
#define GL_TEXTURE_HEIGHT 0x1001
#define GL_TEXTURE_INTERNAL_FORMAT 0x1003
#define GL_TEXTURE_BORDER_COLOR 0x1004
#define GL_TEXTURE_RED_SIZE 0x805C
#define GL_TEXTURE_GREEN_SIZE 0x805D
#define GL_TEXTURE_BLUE_SIZE 0x805E
#define GL_TEXTURE_ALPHA_SIZE 0x805F
#define GL_DONT_CARE 0x1100
#define GL_FASTEST 0x1101
#define GL_NICEST 0x1102
#define GL_BYTE 0x1400
#define GL_UNSIGNED_BYTE 0x1401
#define GL_SHORT 0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT 0x1404
#define GL_UNSIGNED_INT 0x1405
#define GL_FLOAT 0x1406
#define GL_DOUBLE 0x140A
#define GL_CLEAR 0x1500
#define GL_AND 0x1501
#define GL_AND_REVERSE 0x1502
#define GL_COPY 0x1503
#define GL_AND_INVERTED 0x1504
#define GL_NOOP 0x1505
#define GL_XOR 0x1506
#define GL_OR 0x1507
#define GL_NOR 0x1508
#define GL_EQUIV 0x1509
#define GL_INVERT 0x150A
#define GL_OR_REVERSE 0x150B
#define GL_COPY_INVERTED 0x150C
#define GL_OR_INVERTED 0x150D
#define GL_NAND 0x150E
#define GL_SET 0x150F
#define GL_TEXTURE 0x1702
#define GL_COLOR 0x1800
#define GL_DEPTH 0x1801
#define GL_STENCIL 0x1802
#define GL_STENCIL_INDEX 0x1901
#define GL_DEPTH_COMPONENT 0x1902
#define GL_RED 0x1903
#define GL_GREEN 0x1904
#define GL_BLUE 0x1905
#define GL_ALPHA 0x1906
#define GL_RGB 0x1907
#define GL_RGBA 0x1908
#define GL_POINT 0x1B00
#define GL_LINE 0x1B01
#define GL_FILL 0x1B02
#define GL_KEEP 0x1E00
#define GL_REPLACE 0x1E01
#define GL_INCR 0x1E02
#define GL_DECR 0x1E03
#define GL_VENDOR 0x1F00
#define GL_RENDERER 0x1F01
#define GL_VERSION 0x1F02
#define GL_EXTENSIONS 0x1F03
#define GL_NEAREST 0x2600
#define GL_LINEAR 0x2601
#define GL_NEAREST_MIPMAP_NEAREST 0x2700
#define GL_LINEAR_MIPMAP_NEAREST 0x2701
#define GL_NEAREST_MIPMAP_LINEAR 0x2702
#define GL_LINEAR_MIPMAP_LINEAR 0x2703
#define GL_TEXTURE_MAG_FILTER 0x2800
#define GL_TEXTURE_MIN_FILTER 0x2801
#define GL_TEXTURE_WRAP_S 0x2802
#define GL_TEXTURE_WRAP_T 0x2803
#define GL_PROXY_TEXTURE_1D 0x8063
#define GL_PROXY_TEXTURE_2D 0x8064
#define GL_REPEAT 0x2901
#define GL_R3_G3_B2 0x2A10
#define GL_RGB4 0x804F
#define GL_RGB5 0x8050
#define GL_RGB8 0x8051
#define GL_RGB10 0x8052
#define GL_RGB12 0x8053
#define GL_RGB16 0x8054
#define GL_RGBA2 0x8055
#define GL_RGBA4 0x8056
#define GL_RGB5_A1 0x8057
#define GL_RGBA8 0x8058
#define GL_RGB10_A2 0x8059
#define GL_RGBA12 0x805A
#define GL_RGBA16 0x805B

/* Matrix Mode */
#define GL_MATRIX_MODE				0x0BA0
#define GL_MODELVIEW				0x1700
#define GL_PROJECTION				0x1701
#define GL_TEXTURE				0x1702

/* Alpha testing */
#define GL_ALPHA_TEST				0x0BC0
#define GL_ALPHA_TEST_REF			0x0BC2
#define GL_ALPHA_TEST_FUNC			0x0BC1

/* Texture mapping */
#define GL_TEXTURE_ENV				0x2300
#define GL_TEXTURE_ENV_MODE			0x2200
#define GL_TEXTURE_1D				0x0DE0
#define GL_TEXTURE_2D				0x0DE1
#define GL_TEXTURE_WRAP_S			0x2802
#define GL_TEXTURE_WRAP_T			0x2803
#define GL_TEXTURE_MAG_FILTER			0x2800
#define GL_TEXTURE_MIN_FILTER			0x2801
#define GL_TEXTURE_ENV_COLOR			0x2201
#define GL_TEXTURE_GEN_S			0x0C60
#define GL_TEXTURE_GEN_T			0x0C61
#define GL_TEXTURE_GEN_R			0x0C62
#define GL_TEXTURE_GEN_Q			0x0C63
#define GL_TEXTURE_GEN_MODE			0x2500
#define GL_TEXTURE_BORDER_COLOR			0x1004
#define GL_TEXTURE_WIDTH			0x1000
#define GL_TEXTURE_HEIGHT			0x1001
#define GL_TEXTURE_BORDER			0x1005
#define GL_TEXTURE_COMPONENTS			0x1003
#define GL_TEXTURE_RED_SIZE			0x805C
#define GL_TEXTURE_GREEN_SIZE			0x805D
#define GL_TEXTURE_BLUE_SIZE			0x805E
#define GL_TEXTURE_ALPHA_SIZE			0x805F
#define GL_TEXTURE_LUMINANCE_SIZE		0x8060
#define GL_TEXTURE_INTENSITY_SIZE		0x8061
#define GL_NEAREST_MIPMAP_NEAREST		0x2700
#define GL_NEAREST_MIPMAP_LINEAR		0x2702
#define GL_LINEAR_MIPMAP_NEAREST		0x2701
#define GL_LINEAR_MIPMAP_LINEAR			0x2703
#define GL_OBJECT_LINEAR			0x2401
#define GL_OBJECT_PLANE				0x2501
#define GL_EYE_LINEAR				0x2400
#define GL_EYE_PLANE				0x2502
#define GL_SPHERE_MAP				0x2402
#define GL_DECAL				0x2101
#define GL_MODULATE				0x2100
#define GL_NEAREST				0x2600
#define GL_REPEAT				0x2901
#define GL_CLAMP				0x2900
#define GL_S					0x2000
#define GL_T					0x2001
#define GL_R					0x2002
#define GL_Q					0x2003

/* GL_VERSION_1_2 */

#define GL_UNSIGNED_BYTE_3_3_2 0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4 0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1 0x8034
#define GL_UNSIGNED_INT_8_8_8_8 0x8035
#define GL_UNSIGNED_INT_10_10_10_2 0x8036
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_PACK_SKIP_IMAGES 0x806B
#define GL_PACK_IMAGE_HEIGHT 0x806C
#define GL_UNPACK_SKIP_IMAGES 0x806D
#define GL_UNPACK_IMAGE_HEIGHT 0x806E
#define GL_TEXTURE_3D 0x806F
#define GL_PROXY_TEXTURE_3D 0x8070
#define GL_TEXTURE_DEPTH 0x8071
#define GL_TEXTURE_WRAP_R 0x8072
#define GL_MAX_3D_TEXTURE_SIZE 0x8073
#define GL_UNSIGNED_BYTE_2_3_3_REV 0x8362
#define GL_UNSIGNED_SHORT_5_6_5 0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV 0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV 0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV 0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV 0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV 0x8368
#define GL_BGR 0x80E0
#define GL_BGRA 0x80E1
#define GL_MAX_ELEMENTS_VERTICES 0x80E8
#define GL_MAX_ELEMENTS_INDICES 0x80E9
#define GL_CLAMP_TO_EDGE 0x812F
#define GL_TEXTURE_MIN_LOD 0x813A
#define GL_TEXTURE_MAX_LOD 0x813B
#define GL_TEXTURE_BASE_LEVEL 0x813C
#define GL_TEXTURE_MAX_LEVEL 0x813D
#define GL_SMOOTH_POINT_SIZE_RANGE 0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY 0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE 0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_ALIASED_LINE_WIDTH_RANGE 0x846E
/* Vertex Arrays */
#define GL_VERTEX_ARRAY				0x8074
#define GL_NORMAL_ARRAY				0x8075
#define GL_COLOR_ARRAY				0x8076
#define GL_INDEX_ARRAY				0x8077
#define GL_TEXTURE_COORD_ARRAY			0x8078
#define GL_EDGE_FLAG_ARRAY			0x8079

#define GL_VERTEX_ARRAY_SIZE			0x807A
#define GL_VERTEX_ARRAY_TYPE			0x807B
#define GL_VERTEX_ARRAY_STRIDE			0x807C
#define GL_NORMAL_ARRAY_TYPE			0x807E
#define GL_NORMAL_ARRAY_STRIDE			0x807F
#define GL_COLOR_ARRAY_SIZE			0x8081
#define GL_COLOR_ARRAY_TYPE			0x8082
#define GL_COLOR_ARRAY_STRIDE			0x8083
#define GL_INDEX_ARRAY_TYPE			0x8085
#define GL_INDEX_ARRAY_STRIDE			0x8086
#define GL_TEXTURE_COORD_ARRAY_SIZE		0x8088
#define GL_TEXTURE_COORD_ARRAY_TYPE		0x8089
#define GL_TEXTURE_COORD_ARRAY_STRIDE		0x808A
#define GL_EDGE_FLAG_ARRAY_STRIDE		0x808C
#define GL_VERTEX_ARRAY_POINTER			0x808E
#define GL_NORMAL_ARRAY_POINTER			0x808F
#define GL_COLOR_ARRAY_POINTER			0x8090
#define GL_INDEX_ARRAY_POINTER			0x8091
#define GL_TEXTURE_COORD_ARRAY_POINTER		0x8092
#define GL_EDGE_FLAG_ARRAY_POINTER		0x8093
#define GL_V2F					0x2A20
#define GL_V3F					0x2A21
#define GL_C4UB_V2F				0x2A22
#define GL_C4UB_V3F				0x2A23
#define GL_C3F_V3F				0x2A24
#define GL_N3F_V3F				0x2A25
#define GL_C4F_N3F_V3F				0x2A26
#define GL_T2F_V3F				0x2A27
#define GL_T4F_V4F				0x2A28
#define GL_T2F_C4UB_V3F				0x2A29
#define GL_T2F_C3F_V3F				0x2A2A
#define GL_T2F_N3F_V3F				0x2A2B
#define GL_T2F_C4F_N3F_V3F			0x2A2C
#define GL_T4F_C4F_N3F_V4F			0x2A2D

/* GL_VERSION_1_3 */

#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF
#define GL_ACTIVE_TEXTURE 0x84E0
#define GL_MULTISAMPLE 0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define GL_SAMPLE_ALPHA_TO_ONE 0x809F
#define GL_SAMPLE_COVERAGE 0x80A0
#define GL_SAMPLE_BUFFERS 0x80A8
#define GL_SAMPLES 0x80A9
#define GL_SAMPLE_COVERAGE_VALUE 0x80AA
#define GL_SAMPLE_COVERAGE_INVERT 0x80AB
#define GL_TEXTURE_CUBE_MAP 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP 0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE 0x851C
#define GL_COMPRESSED_RGB 0x84ED
#define GL_COMPRESSED_RGBA 0x84EE
#define GL_TEXTURE_COMPRESSION_HINT 0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE 0x86A0
#define GL_TEXTURE_COMPRESSED 0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS 0x86A3
#define GL_CLAMP_TO_BORDER 0x812D

/* GL_VERSION_1_4 */

#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_POINT_FADE_THRESHOLD_SIZE 0x8128
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_DEPTH_COMPONENT24 0x81A6
#define GL_DEPTH_COMPONENT32 0x81A7
#define GL_MIRRORED_REPEAT 0x8370
#define GL_MAX_TEXTURE_LOD_BIAS 0x84FD
#define GL_TEXTURE_LOD_BIAS 0x8501
#define GL_INCR_WRAP 0x8507
#define GL_DECR_WRAP 0x8508
#define GL_TEXTURE_DEPTH_SIZE 0x884A
#define GL_TEXTURE_COMPARE_MODE 0x884C
#define GL_TEXTURE_COMPARE_FUNC 0x884D
#define GL_FUNC_ADD 0x8006
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_MIN 0x8007
#define GL_MAX 0x8008
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004

/* GL_VERSION_1_5 */

#define GL_BUFFER_SIZE 0x8764
#define GL_BUFFER_USAGE 0x8765
#define GL_QUERY_COUNTER_BITS 0x8864
#define GL_CURRENT_QUERY 0x8865
#define GL_QUERY_RESULT 0x8866
#define GL_QUERY_RESULT_AVAILABLE 0x8867
#define GL_ARRAY_BUFFER 0x8892
#define GL_ELEMENT_ARRAY_BUFFER 0x8893
#define GL_ARRAY_BUFFER_BINDING 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING 0x8895
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_READ_ONLY 0x88B8
#define GL_WRITE_ONLY 0x88B9
#define GL_READ_WRITE 0x88BA
#define GL_BUFFER_ACCESS 0x88BB
#define GL_BUFFER_MAPPED 0x88BC
#define GL_BUFFER_MAP_POINTER 0x88BD
#define GL_STREAM_DRAW 0x88E0
#define GL_STREAM_READ 0x88E1
#define GL_STREAM_COPY 0x88E2
#define GL_STATIC_DRAW 0x88E4
#define GL_STATIC_READ 0x88E5
#define GL_STATIC_COPY 0x88E6
#define GL_DYNAMIC_DRAW 0x88E8
#define GL_DYNAMIC_READ 0x88E9
#define GL_DYNAMIC_COPY 0x88EA
#define GL_SAMPLES_PASSED 0x8914
#define GL_SRC1_ALPHA 0x8589

/* GL_VERSION_2_0 */

#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE 0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE 0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE 0x8625
#define GL_CURRENT_VERTEX_ATTRIB 0x8626
#define GL_VERTEX_PROGRAM_POINT_SIZE 0x8642
#define GL_VERTEX_ATTRIB_ARRAY_POINTER 0x8645
#define GL_STENCIL_BACK_FUNC 0x8800
#define GL_STENCIL_BACK_FAIL 0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 0x8803
#define GL_MAX_DRAW_BUFFERS 0x8824
#define GL_DRAW_BUFFER0 0x8825
#define GL_DRAW_BUFFER1 0x8826
#define GL_DRAW_BUFFER2 0x8827
#define GL_DRAW_BUFFER3 0x8828
#define GL_DRAW_BUFFER4 0x8829
#define GL_DRAW_BUFFER5 0x882A
#define GL_DRAW_BUFFER6 0x882B
#define GL_DRAW_BUFFER7 0x882C
#define GL_DRAW_BUFFER8 0x882D
#define GL_DRAW_BUFFER9 0x882E
#define GL_DRAW_BUFFER10 0x882F
#define GL_DRAW_BUFFER11 0x8830
#define GL_DRAW_BUFFER12 0x8831
#define GL_DRAW_BUFFER13 0x8832
#define GL_DRAW_BUFFER14 0x8833
#define GL_DRAW_BUFFER15 0x8834
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_MAX_VERTEX_ATTRIBS 0x8869
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#define GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define GL_FRAGMENT_SHADER 0x8B30
#define GL_VERTEX_SHADER 0x8B31
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS 0x8B4A
#define GL_MAX_VARYING_FLOATS 0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_SHADER_TYPE 0x8B4F
#define GL_FLOAT_VEC2 0x8B50
#define GL_FLOAT_VEC3 0x8B51
#define GL_FLOAT_VEC4 0x8B52
#define GL_INT_VEC2 0x8B53
#define GL_INT_VEC3 0x8B54
#define GL_INT_VEC4 0x8B55
#define GL_BOOL 0x8B56
#define GL_BOOL_VEC2 0x8B57
#define GL_BOOL_VEC3 0x8B58
#define GL_BOOL_VEC4 0x8B59
#define GL_FLOAT_MAT2 0x8B5A
#define GL_FLOAT_MAT3 0x8B5B
#define GL_FLOAT_MAT4 0x8B5C
#define GL_SAMPLER_1D 0x8B5D
#define GL_SAMPLER_2D 0x8B5E
#define GL_SAMPLER_3D 0x8B5F
#define GL_SAMPLER_CUBE 0x8B60
#define GL_SAMPLER_1D_SHADOW 0x8B61
#define GL_SAMPLER_2D_SHADOW 0x8B62
#define GL_DELETE_STATUS 0x8B80
#define GL_COMPILE_STATUS 0x8B81
#define GL_LINK_STATUS 0x8B82
#define GL_VALIDATE_STATUS 0x8B83
#define GL_INFO_LOG_LENGTH 0x8B84
#define GL_ATTACHED_SHADERS 0x8B85
#define GL_ACTIVE_UNIFORMS 0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_SHADER_SOURCE_LENGTH 0x8B88
#define GL_ACTIVE_ATTRIBUTES 0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT 0x8B8B
#define GL_SHADING_LANGUAGE_VERSION 0x8B8C
#define GL_CURRENT_PROGRAM 0x8B8D
#define GL_POINT_SPRITE_COORD_ORIGIN 0x8CA0
#define GL_LOWER_LEFT 0x8CA1
#define GL_UPPER_LEFT 0x8CA2
#define GL_STENCIL_BACK_REF 0x8CA3
#define GL_STENCIL_BACK_VALUE_MASK 0x8CA4
#define GL_STENCIL_BACK_WRITEMASK 0x8CA5

/* GL_VERSION_2_1 */

#define GL_PIXEL_PACK_BUFFER 0x88EB
#define GL_PIXEL_UNPACK_BUFFER 0x88EC
#define GL_PIXEL_PACK_BUFFER_BINDING 0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING 0x88EF
#define GL_FLOAT_MAT2x3 0x8B65
#define GL_FLOAT_MAT2x4 0x8B66
#define GL_FLOAT_MAT3x2 0x8B67
#define GL_FLOAT_MAT3x4 0x8B68
#define GL_FLOAT_MAT4x2 0x8B69
#define GL_FLOAT_MAT4x3 0x8B6A
#define GL_SRGB 0x8C40
#define GL_SRGB8 0x8C41
#define GL_SRGB_ALPHA 0x8C42
#define GL_SRGB8_ALPHA8 0x8C43
#define GL_COMPRESSED_SRGB 0x8C48
#define GL_COMPRESSED_SRGB_ALPHA 0x8C49

/* GL_VERSION_3_0 */

#define GL_COMPARE_REF_TO_TEXTURE 0x884E
#define GL_CLIP_DISTANCE0 0x3000
#define GL_CLIP_DISTANCE1 0x3001
#define GL_CLIP_DISTANCE2 0x3002
#define GL_CLIP_DISTANCE3 0x3003
#define GL_CLIP_DISTANCE4 0x3004
#define GL_CLIP_DISTANCE5 0x3005
#define GL_CLIP_DISTANCE6 0x3006
#define GL_CLIP_DISTANCE7 0x3007
#define GL_MAX_CLIP_DISTANCES 0x0D32
#define GL_MAJOR_VERSION 0x821B
#define GL_MINOR_VERSION 0x821C
#define GL_NUM_EXTENSIONS 0x821D
#define GL_CONTEXT_FLAGS 0x821E
#define GL_COMPRESSED_RED 0x8225
#define GL_COMPRESSED_RG 0x8226
#define GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT 0x00000001
#define GL_RGBA32F 0x8814
#define GL_RGB32F 0x8815
#define GL_RGBA16F 0x881A
#define GL_RGB16F 0x881B
#define GL_VERTEX_ATTRIB_ARRAY_INTEGER 0x88FD
#define GL_MAX_ARRAY_TEXTURE_LAYERS 0x88FF
#define GL_MIN_PROGRAM_TEXEL_OFFSET 0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET 0x8905
#define GL_CLAMP_READ_COLOR 0x891C
#define GL_FIXED_ONLY 0x891D
#define GL_MAX_VARYING_COMPONENTS 0x8B4B
#define GL_TEXTURE_1D_ARRAY 0x8C18
#define GL_PROXY_TEXTURE_1D_ARRAY 0x8C19
#define GL_TEXTURE_2D_ARRAY 0x8C1A
#define GL_PROXY_TEXTURE_2D_ARRAY 0x8C1B
#define GL_TEXTURE_BINDING_1D_ARRAY 0x8C1C
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_R11F_G11F_B10F 0x8C3A
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B
#define GL_RGB9_E5 0x8C3D
#define GL_UNSIGNED_INT_5_9_9_9_REV 0x8C3E
#define GL_TEXTURE_SHARED_SIZE 0x8C3F
#define GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH 0x8C76
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE 0x8C7F
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS 0x8C80
#define GL_TRANSFORM_FEEDBACK_VARYINGS 0x8C83
#define GL_TRANSFORM_FEEDBACK_BUFFER_START 0x8C84
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE 0x8C85
#define GL_PRIMITIVES_GENERATED 0x8C87
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN 0x8C88
#define GL_RASTERIZER_DISCARD 0x8C89
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS 0x8C8A
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS 0x8C8B
#define GL_INTERLEAVED_ATTRIBS 0x8C8C
#define GL_SEPARATE_ATTRIBS 0x8C8D
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING 0x8C8F
#define GL_RGBA32UI 0x8D70
#define GL_RGB32UI 0x8D71
#define GL_RGBA16UI 0x8D76
#define GL_RGB16UI 0x8D77
#define GL_RGBA8UI 0x8D7C
#define GL_RGB8UI 0x8D7D
#define GL_RGBA32I 0x8D82
#define GL_RGB32I 0x8D83
#define GL_RGBA16I 0x8D88
#define GL_RGB16I 0x8D89
#define GL_RGBA8I 0x8D8E
#define GL_RGB8I 0x8D8F
#define GL_RED_INTEGER 0x8D94
#define GL_GREEN_INTEGER 0x8D95
#define GL_BLUE_INTEGER 0x8D96
#define GL_RGB_INTEGER 0x8D98
#define GL_RGBA_INTEGER 0x8D99
#define GL_BGR_INTEGER 0x8D9A
#define GL_BGRA_INTEGER 0x8D9B
#define GL_SAMPLER_1D_ARRAY 0x8DC0
#define GL_SAMPLER_2D_ARRAY 0x8DC1
#define GL_SAMPLER_1D_ARRAY_SHADOW 0x8DC3
#define GL_SAMPLER_2D_ARRAY_SHADOW 0x8DC4
#define GL_SAMPLER_CUBE_SHADOW 0x8DC5
#define GL_UNSIGNED_INT_VEC2 0x8DC6
#define GL_UNSIGNED_INT_VEC3 0x8DC7
#define GL_UNSIGNED_INT_VEC4 0x8DC8
#define GL_INT_SAMPLER_1D 0x8DC9
#define GL_INT_SAMPLER_2D 0x8DCA
#define GL_INT_SAMPLER_3D 0x8DCB
#define GL_INT_SAMPLER_CUBE 0x8DCC
#define GL_INT_SAMPLER_1D_ARRAY 0x8DCE
#define GL_INT_SAMPLER_2D_ARRAY 0x8DCF
#define GL_UNSIGNED_INT_SAMPLER_1D 0x8DD1
#define GL_UNSIGNED_INT_SAMPLER_2D 0x8DD2
#define GL_UNSIGNED_INT_SAMPLER_3D 0x8DD3
#define GL_UNSIGNED_INT_SAMPLER_CUBE 0x8DD4
#define GL_UNSIGNED_INT_SAMPLER_1D_ARRAY 0x8DD6
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY 0x8DD7
#define GL_QUERY_WAIT 0x8E13
#define GL_QUERY_NO_WAIT 0x8E14
#define GL_QUERY_BY_REGION_WAIT 0x8E15
#define GL_QUERY_BY_REGION_NO_WAIT 0x8E16
#define GL_BUFFER_ACCESS_FLAGS 0x911F
#define GL_BUFFER_MAP_LENGTH 0x9120
#define GL_BUFFER_MAP_OFFSET 0x9121
#define GL_DEPTH_COMPONENT32F 0x8CAC
#define GL_DEPTH32F_STENCIL8 0x8CAD
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV 0x8DAD
#define GL_INVALID_FRAMEBUFFER_OPERATION 0x0506
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING 0x8210
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE 0x8211
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE 0x8212
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE 0x8213
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE 0x8214
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE 0x8215
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE 0x8216
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE 0x8217
#define GL_FRAMEBUFFER_DEFAULT 0x8218
#define GL_FRAMEBUFFER_UNDEFINED 0x8219
#define GL_DEPTH_STENCIL_ATTACHMENT 0x821A
#define GL_MAX_RENDERBUFFER_SIZE 0x84E8
#define GL_DEPTH_STENCIL 0x84F9
#define GL_UNSIGNED_INT_24_8 0x84FA
#define GL_DEPTH24_STENCIL8 0x88F0
#define GL_TEXTURE_STENCIL_SIZE 0x88F1
#define GL_TEXTURE_RED_TYPE 0x8C10
#define GL_TEXTURE_GREEN_TYPE 0x8C11
#define GL_TEXTURE_BLUE_TYPE 0x8C12
#define GL_TEXTURE_ALPHA_TYPE 0x8C13
#define GL_TEXTURE_DEPTH_TYPE 0x8C16
#define GL_UNSIGNED_NORMALIZED 0x8C17
#define GL_FRAMEBUFFER_BINDING 0x8CA6
#define GL_DRAW_FRAMEBUFFER_BINDING 0x8CA6
#define GL_RENDERBUFFER_BINDING 0x8CA7
#define GL_READ_FRAMEBUFFER 0x8CA8
#define GL_DRAW_FRAMEBUFFER 0x8CA9
#define GL_READ_FRAMEBUFFER_BINDING 0x8CAA
#define GL_RENDERBUFFER_SAMPLES 0x8CAB
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE 0x8CD0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME 0x8CD1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL 0x8CD2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE 0x8CD3
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER 0x8CD4
#define GL_FRAMEBUFFER_COMPLETE 0x8CD5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT 0x8CD6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT 0x8CD7
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER 0x8CDB
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER 0x8CDC
#define GL_FRAMEBUFFER_UNSUPPORTED 0x8CDD
#define GL_MAX_COLOR_ATTACHMENTS 0x8CDF
#define GL_COLOR_ATTACHMENT0 0x8CE0
#define GL_COLOR_ATTACHMENT1 0x8CE1
#define GL_COLOR_ATTACHMENT2 0x8CE2
#define GL_COLOR_ATTACHMENT3 0x8CE3
#define GL_COLOR_ATTACHMENT4 0x8CE4
#define GL_COLOR_ATTACHMENT5 0x8CE5
#define GL_COLOR_ATTACHMENT6 0x8CE6
#define GL_COLOR_ATTACHMENT7 0x8CE7
#define GL_COLOR_ATTACHMENT8 0x8CE8
#define GL_COLOR_ATTACHMENT9 0x8CE9
#define GL_COLOR_ATTACHMENT10 0x8CEA
#define GL_COLOR_ATTACHMENT11 0x8CEB
#define GL_COLOR_ATTACHMENT12 0x8CEC
#define GL_COLOR_ATTACHMENT13 0x8CED
#define GL_COLOR_ATTACHMENT14 0x8CEE
#define GL_COLOR_ATTACHMENT15 0x8CEF
#define GL_DEPTH_ATTACHMENT 0x8D00
#define GL_STENCIL_ATTACHMENT 0x8D20
#define GL_FRAMEBUFFER 0x8D40
#define GL_RENDERBUFFER 0x8D41
#define GL_RENDERBUFFER_WIDTH 0x8D42
#define GL_RENDERBUFFER_HEIGHT 0x8D43
#define GL_RENDERBUFFER_INTERNAL_FORMAT 0x8D44
#define GL_STENCIL_INDEX1 0x8D46
#define GL_STENCIL_INDEX4 0x8D47
#define GL_STENCIL_INDEX8 0x8D48
#define GL_STENCIL_INDEX16 0x8D49
#define GL_RENDERBUFFER_RED_SIZE 0x8D50
#define GL_RENDERBUFFER_GREEN_SIZE 0x8D51
#define GL_RENDERBUFFER_BLUE_SIZE 0x8D52
#define GL_RENDERBUFFER_ALPHA_SIZE 0x8D53
#define GL_RENDERBUFFER_DEPTH_SIZE 0x8D54
#define GL_RENDERBUFFER_STENCIL_SIZE 0x8D55
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE 0x8D56
#define GL_MAX_SAMPLES 0x8D57
#define GL_FRAMEBUFFER_SRGB 0x8DB9
#define GL_HALF_FLOAT 0x140B
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT 0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT 0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT 0x0020
#define GL_COMPRESSED_RED_RGTC1 0x8DBB
#define GL_COMPRESSED_SIGNED_RED_RGTC1 0x8DBC
#define GL_COMPRESSED_RG_RGTC2 0x8DBD
#define GL_COMPRESSED_SIGNED_RG_RGTC2 0x8DBE
#define GL_RG 0x8227
#define GL_RG_INTEGER 0x8228
#define GL_R8 0x8229
#define GL_R16 0x822A
#define GL_RG8 0x822B
#define GL_RG16 0x822C
#define GL_R16F 0x822D
#define GL_R32F 0x822E
#define GL_RG16F 0x822F
#define GL_RG32F 0x8230
#define GL_R8I 0x8231
#define GL_R8UI 0x8232
#define GL_R16I 0x8233
#define GL_R16UI 0x8234
#define GL_R32I 0x8235
#define GL_R32UI 0x8236
#define GL_RG8I 0x8237
#define GL_RG8UI 0x8238
#define GL_RG16I 0x8239
#define GL_RG16UI 0x823A
#define GL_RG32I 0x823B
#define GL_RG32UI 0x823C
#define GL_VERTEX_ARRAY_BINDING 0x85B5

/* GL_VERSION_3_1 */

#define GL_SAMPLER_2D_RECT 0x8B63
#define GL_SAMPLER_2D_RECT_SHADOW 0x8B64
#define GL_SAMPLER_BUFFER 0x8DC2
#define GL_INT_SAMPLER_2D_RECT 0x8DCD
#define GL_INT_SAMPLER_BUFFER 0x8DD0
#define GL_UNSIGNED_INT_SAMPLER_2D_RECT 0x8DD5
#define GL_UNSIGNED_INT_SAMPLER_BUFFER 0x8DD8
#define GL_TEXTURE_BUFFER 0x8C2A
#define GL_MAX_TEXTURE_BUFFER_SIZE 0x8C2B
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING 0x8C2D
#define GL_TEXTURE_RECTANGLE 0x84F5
#define GL_TEXTURE_BINDING_RECTANGLE 0x84F6
#define GL_PROXY_TEXTURE_RECTANGLE 0x84F7
#define GL_MAX_RECTANGLE_TEXTURE_SIZE 0x84F8
#define GL_R8_SNORM 0x8F94
#define GL_RG8_SNORM 0x8F95
#define GL_RGB8_SNORM 0x8F96
#define GL_RGBA8_SNORM 0x8F97
#define GL_R16_SNORM 0x8F98
#define GL_RG16_SNORM 0x8F99
#define GL_RGB16_SNORM 0x8F9A
#define GL_RGBA16_SNORM 0x8F9B
#define GL_SIGNED_NORMALIZED 0x8F9C
#define GL_PRIMITIVE_RESTART 0x8F9D
#define GL_PRIMITIVE_RESTART_INDEX 0x8F9E
#define GL_COPY_READ_BUFFER 0x8F36
#define GL_COPY_WRITE_BUFFER 0x8F37
#define GL_UNIFORM_BUFFER 0x8A11
#define GL_UNIFORM_BUFFER_BINDING 0x8A28
#define GL_UNIFORM_BUFFER_START 0x8A29
#define GL_UNIFORM_BUFFER_SIZE 0x8A2A
#define GL_MAX_VERTEX_UNIFORM_BLOCKS 0x8A2B
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS 0x8A2C
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS 0x8A2D
#define GL_MAX_COMBINED_UNIFORM_BLOCKS 0x8A2E
#define GL_MAX_UNIFORM_BUFFER_BINDINGS 0x8A2F
#define GL_MAX_UNIFORM_BLOCK_SIZE 0x8A30
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS 0x8A31
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS 0x8A32
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS 0x8A33
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT 0x8A34
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH 0x8A35
#define GL_ACTIVE_UNIFORM_BLOCKS 0x8A36
#define GL_UNIFORM_TYPE 0x8A37
#define GL_UNIFORM_SIZE 0x8A38
#define GL_UNIFORM_NAME_LENGTH 0x8A39
#define GL_UNIFORM_BLOCK_INDEX 0x8A3A
#define GL_UNIFORM_OFFSET 0x8A3B
#define GL_UNIFORM_ARRAY_STRIDE 0x8A3C
#define GL_UNIFORM_MATRIX_STRIDE 0x8A3D
#define GL_UNIFORM_IS_ROW_MAJOR 0x8A3E
#define GL_UNIFORM_BLOCK_BINDING 0x8A3F
#define GL_UNIFORM_BLOCK_DATA_SIZE 0x8A40
#define GL_UNIFORM_BLOCK_NAME_LENGTH 0x8A41
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS 0x8A42
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES 0x8A43
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER 0x8A44
#define GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER 0x8A45
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER 0x8A46
#define GL_INVALID_INDEX 0xFFFFFFFFu

/* GL_VERSION_3_2 */

#define GL_CONTEXT_CORE_PROFILE_BIT 0x00000001
#define GL_CONTEXT_COMPATIBILITY_PROFILE_BIT 0x00000002
#define GL_LINES_ADJACENCY 0x000A
#define GL_LINE_STRIP_ADJACENCY 0x000B
#define GL_TRIANGLES_ADJACENCY 0x000C
#define GL_TRIANGLE_STRIP_ADJACENCY 0x000D
#define GL_PROGRAM_POINT_SIZE 0x8642
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS 0x8C29
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED 0x8DA7
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS 0x8DA8
#define GL_GEOMETRY_SHADER 0x8DD9
#define GL_GEOMETRY_VERTICES_OUT 0x8916
#define GL_GEOMETRY_INPUT_TYPE 0x8917
#define GL_GEOMETRY_OUTPUT_TYPE 0x8918
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS 0x8DDF
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES 0x8DE0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS 0x8DE1
#define GL_MAX_VERTEX_OUTPUT_COMPONENTS 0x9122
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS 0x9123
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS 0x9124
#define GL_MAX_FRAGMENT_INPUT_COMPONENTS 0x9125
#define GL_CONTEXT_PROFILE_MASK 0x9126
#define GL_DEPTH_CLAMP 0x864F
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION 0x8E4C
#define GL_FIRST_VERTEX_CONVENTION 0x8E4D
#define GL_LAST_VERTEX_CONVENTION 0x8E4E
#define GL_PROVOKING_VERTEX 0x8E4F
#define GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F
#define GL_MAX_SERVER_WAIT_TIMEOUT 0x9111
#define GL_OBJECT_TYPE 0x9112
#define GL_SYNC_CONDITION 0x9113
#define GL_SYNC_STATUS 0x9114
#define GL_SYNC_FLAGS 0x9115
#define GL_SYNC_FENCE 0x9116
#define GL_SYNC_GPU_COMMANDS_COMPLETE 0x9117
#define GL_UNSIGNALED 0x9118
#define GL_SIGNALED 0x9119
#define GL_ALREADY_SIGNALED 0x911A
#define GL_TIMEOUT_EXPIRED 0x911B
#define GL_CONDITION_SATISFIED 0x911C
#define GL_WAIT_FAILED 0x911D
#define GL_TIMEOUT_IGNORED 0xFFFFFFFFFFFFFFFFull
#define GL_SYNC_FLUSH_COMMANDS_BIT 0x00000001
#define GL_SAMPLE_POSITION 0x8E50
#define GL_SAMPLE_MASK 0x8E51
#define GL_SAMPLE_MASK_VALUE 0x8E52
#define GL_MAX_SAMPLE_MASK_WORDS 0x8E59
#define GL_TEXTURE_2D_MULTISAMPLE 0x9100
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE 0x9101
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9102
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9103
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_TEXTURE_SAMPLES 0x9106
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS 0x9107
#define GL_SAMPLER_2D_MULTISAMPLE 0x9108
#define GL_INT_SAMPLER_2D_MULTISAMPLE 0x9109
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE 0x910A
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910B
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910C
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910D
#define GL_MAX_COLOR_TEXTURE_SAMPLES 0x910E
#define GL_MAX_DEPTH_TEXTURE_SAMPLES 0x910F
#define GL_MAX_INTEGER_SAMPLES 0x9110

/* GL_VERSION_3_3 */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR 0x88FE
#define GL_SRC1_COLOR 0x88F9
#define GL_ONE_MINUS_SRC1_COLOR 0x88FA
#define GL_ONE_MINUS_SRC1_ALPHA 0x88FB
#define GL_MAX_DUAL_SOURCE_DRAW_BUFFERS 0x88FC
#define GL_ANY_SAMPLES_PASSED 0x8C2F
#define GL_SAMPLER_BINDING 0x8919
#define GL_RGB10_A2UI 0x906F
#define GL_TEXTURE_SWIZZLE_R 0x8E42
#define GL_TEXTURE_SWIZZLE_G 0x8E43
#define GL_TEXTURE_SWIZZLE_B 0x8E44
#define GL_TEXTURE_SWIZZLE_A 0x8E45
#define GL_TEXTURE_SWIZZLE_RGBA 0x8E46
#define GL_TIME_ELAPSED 0x88BF
#define GL_TIMESTAMP 0x8E28
#define GL_INT_2_10_10_10_REV 0x8D9F

/* GL_ARB_debug_output */

#define GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION_ARB 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM_ARB 0x8245
#define GL_DEBUG_SOURCE_API_ARB 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER_ARB 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY_ARB 0x8249
#define GL_DEBUG_SOURCE_APPLICATION_ARB 0x824A
#define GL_DEBUG_SOURCE_OTHER_ARB 0x824B
#define GL_DEBUG_TYPE_ERROR_ARB 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB 0x824E
#define GL_DEBUG_TYPE_PORTABILITY_ARB 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE_ARB 0x8250
#define GL_DEBUG_TYPE_OTHER_ARB 0x8251
#define GL_MAX_DEBUG_MESSAGE_LENGTH_ARB 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES_ARB 0x9144
#define GL_DEBUG_LOGGED_MESSAGES_ARB 0x9145
#define GL_DEBUG_SEVERITY_HIGH_ARB 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM_ARB 0x9147
#define GL_DEBUG_SEVERITY_LOW_ARB 0x9148

/* --------------------------- FUNCTION PROTOTYPES --------------------------- */


/* GL_VERSION_1_0 */
GLAPI void APIENTRY glMatrixMode (GLenum mode);
GLAPI void APIENTRY glLoadMatrixf (const GLfloat *m);
GLAPI void APIENTRY glViewport (GLint x, GLint y, GLsizei width, GLsizei height);
GLAPI void APIENTRY glCullFace (GLenum mode);
GLAPI void APIENTRY glFrontFace (GLenum mode);
GLAPI void APIENTRY glHint (GLenum target, GLenum mode);
GLAPI void APIENTRY glLineWidth (GLfloat width);
GLAPI void APIENTRY glPointSize (GLfloat size);
GLAPI void APIENTRY glPolygonMode (GLenum face, GLenum mode);
GLAPI void APIENTRY glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
GLAPI void APIENTRY glTexParameterf (GLenum target, GLenum pname, GLfloat param);
GLAPI void APIENTRY glTexParameterfv (GLenum target, GLenum pname, const GLfloat * params);
GLAPI void APIENTRY glTexParameteri (GLenum target, GLenum pname, GLint param);
GLAPI void APIENTRY glTexParameteriv (GLenum target, GLenum pname, const GLint * params);
GLAPI void APIENTRY glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void * pixels);
GLAPI void APIENTRY glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels);
GLAPI void APIENTRY glDrawBuffer (GLenum buf);
GLAPI void APIENTRY glClear (GLbitfield mask);
GLAPI void APIENTRY glClearColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GLAPI void APIENTRY glClearStencil (GLint s);
GLAPI void APIENTRY glClearDepth (GLdouble depth);
GLAPI void APIENTRY glStencilMask (GLuint mask);
GLAPI void APIENTRY glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
GLAPI void APIENTRY glDepthMask (GLboolean flag);
GLAPI void APIENTRY glDisable (GLenum cap);
GLAPI void APIENTRY glEnable (GLenum cap);
GLAPI void APIENTRY glFinish (void);
GLAPI void APIENTRY glFlush (void);
GLAPI void APIENTRY glBlendFunc (GLenum sfactor, GLenum dfactor);
GLAPI void APIENTRY glLogicOp (GLenum opcode);
GLAPI void APIENTRY glStencilFunc (GLenum func, GLint ref, GLuint mask);
GLAPI void APIENTRY glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
GLAPI void APIENTRY glDepthFunc (GLenum func);
GLAPI void APIENTRY glPixelStoref (GLenum pname, GLfloat param);
GLAPI void APIENTRY glPixelStorei (GLenum pname, GLint param);
GLAPI void APIENTRY glReadBuffer (GLenum src);
GLAPI void APIENTRY glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels);
GLAPI void APIENTRY glGetBooleanv (GLenum pname, GLboolean * data);
GLAPI void APIENTRY glGetDoublev (GLenum pname, GLdouble * data);
GLAPI GLenum APIENTRY glGetError (void);
GLAPI void APIENTRY glGetFloatv (GLenum pname, GLfloat * data);
GLAPI void APIENTRY glGetIntegerv (GLenum pname, GLint * data);
GLAPI const GLubyte * APIENTRY glGetString (GLenum name);
GLAPI void APIENTRY glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, void * pixels);
GLAPI void APIENTRY glGetTexParameterfv (GLenum target, GLenum pname, GLfloat * params);
GLAPI void APIENTRY glGetTexParameteriv (GLenum target, GLenum pname, GLint * params);
GLAPI void APIENTRY glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat * params);
GLAPI void APIENTRY glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint * params);
GLAPI GLboolean APIENTRY glIsEnabled (GLenum cap);
GLAPI void APIENTRY glDepthRange (GLdouble near, GLdouble far);


/* GL_VERSION_1_1 */

GLAPI void APIENTRY glDrawArrays (GLenum mode, GLint first, GLsizei count);
GLAPI void APIENTRY glDrawElements (GLenum mode, GLsizei count, GLenum type, const void * indices);
GLAPI void APIENTRY glPolygonOffset (GLfloat factor, GLfloat units);
GLAPI void APIENTRY glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
GLAPI void APIENTRY glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
GLAPI void APIENTRY glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
GLAPI void APIENTRY glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
GLAPI void APIENTRY glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void * pixels);
GLAPI void APIENTRY glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels);
GLAPI void APIENTRY glBindTexture (GLenum target, GLuint texture);
GLAPI void APIENTRY glDeleteTextures (GLsizei n, const GLuint * textures);
GLAPI void APIENTRY glGenTextures (GLsizei n, GLuint * textures);
GLAPI GLboolean APIENTRY glIsTexture (GLuint texture);
GLAPI void APIENTRY glEnableClientState (GLenum cap);
GLAPI void APIENTRY glDisableClientState (GLenum cap);
GLAPI void APIENTRY glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glNormalPointer (GLenum type, GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glIndexPointer (GLenum type, GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glEdgeFlagPointer (GLsizei stride, const GLvoid *ptr);
GLAPI void APIENTRY glGetPointerv (GLenum pname, GLvoid **params);
GLAPI void APIENTRY glArrayElement (GLint i);
GLAPI void APIENTRY glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
GLAPI void APIENTRY glTexEnvi (GLenum target, GLenum pname, GLint param);
GLAPI void APIENTRY glAlphaFunc (GLenum func, GLclampf ref);

/* GL_VERSION_1_2 */

typedef void (APIENTRY PFNGLDRAWRANGEELEMENTS_PROC (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices));
typedef void (APIENTRY PFNGLTEXIMAGE3D_PROC (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels));
typedef void (APIENTRY PFNGLTEXSUBIMAGE3D_PROC (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels));
typedef void (APIENTRY PFNGLCOPYTEXSUBIMAGE3D_PROC (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height));
typedef void (APIENTRY PFNGLDELETETEXTURES_PROC (GLsizei n, const GLuint * textures));
typedef void (APIENTRY PFNGLGENTEXTURES_PROC (GLsizei n, GLuint * textures));
typedef void (APIENTRY PFNGLBINDTEXTURE_PROC (GLenum target, GLuint texture));
typedef void (APIENTRY PFNGLTEXPARAMETERI_PROC (GLenum target, GLenum pname, GLint param));
typedef void (APIENTRY PFNGLTEXIMAGE2D_PROC (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels));
typedef void (APIENTRY PFNGLGETINTEGERV_PROC (GLenum pname, GLint * data));
typedef void (APIENTRY PFNGLPIXELSTOREI_PROC (GLenum pname, GLint param));
typedef void (APIENTRY PFNGLREADPIXELS_PROC (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels));
typedef void (APIENTRY PFNGLVIEWPORT_PROC (GLint x, GLint y, GLsizei width, GLsizei height));
typedef void (APIENTRY PFNGLCLEARCOLOR_PROC (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha));
typedef void (APIENTRY PFNGLCLEAR_PROC (GLbitfield mask));
typedef void (APIENTRY PFNGLSCISSOR_PROC (GLint x, GLint y, GLsizei width, GLsizei height));
typedef void (APIENTRY PFNGLDRAWARRAYS_PROC (GLenum mode, GLint first, GLsizei count));
typedef GLenum (APIENTRY PFNGLGETERROR_PROC (void));
typedef void (APIENTRY PFNGLDEPTHMASK_PROC (GLboolean flag));
typedef void (APIENTRY PFNGLBLENDFUNC_PROC (GLenum sfactor, GLenum dfactor));
typedef void (APIENTRY PFNGLHINT_PROC (GLenum target, GLenum mode));
typedef void (APIENTRY PFNGLENABLE_PROC (GLenum target));
typedef void (APIENTRY PFNGLDISABLE_PROC (GLenum target));
typedef void (APIENTRY PFNGLENABLECLIENTSTATE_PROC (GLenum cap));
typedef void (APIENTRY PFNGLTEXENVI_PROC (GLenum target, GLenum pname, GLint param));
typedef void (APIENTRY PFNGLPOLYGONMODE_PROC (GLenum face, GLenum mode));
typedef void (APIENTRY PFNGLALPHAFUNC_PROC (GLenum func, GLclampf ref));
typedef void (APIENTRY PFNGLVERTEXPOINTER_PROC (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr));
typedef void (APIENTRY PFNGLCOLORPOINTER_PROC (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr));
typedef void (APIENTRY PFNGLTEXCOORDPOINTER_PROC (GLint size, GLenum type, GLsizei stride, const GLvoid *ptr));
typedef void (APIENTRY PFNGLMATRIXMODE_PROC (GLenum mode));
typedef void (APIENTRY PFNGLLOADMATRIXF_PROC (const GLfloat *m));

GLAPI PFNGLDRAWRANGEELEMENTS_PROC* glpfDrawRangeElements;
GLAPI PFNGLTEXIMAGE3D_PROC* glpfTexImage3D;
GLAPI PFNGLTEXSUBIMAGE3D_PROC* glpfTexSubImage3D;
GLAPI PFNGLCOPYTEXSUBIMAGE3D_PROC* glpfCopyTexSubImage3D;
GLAPI PFNGLDELETETEXTURES_PROC* glpfDeleteTextures;
GLAPI PFNGLGENTEXTURES_PROC* glpfGenTextures;
GLAPI PFNGLBINDTEXTURE_PROC* glpfBindTexture;
GLAPI PFNGLTEXPARAMETERI_PROC* glpfTexParameteri;
GLAPI PFNGLTEXIMAGE2D_PROC* glpfTexImage2D;
GLAPI PFNGLGETINTEGERV_PROC* glpfGetIntegerv;
GLAPI PFNGLPIXELSTOREI_PROC* glpfPixelStorei;
GLAPI PFNGLREADPIXELS_PROC* glpfReadPixels;
GLAPI PFNGLVIEWPORT_PROC* glpfViewport;
GLAPI PFNGLCLEARCOLOR_PROC* glpfClearColor;
GLAPI PFNGLCLEAR_PROC* glpfClear;
GLAPI PFNGLSCISSOR_PROC* glpfScissor;
GLAPI PFNGLDRAWARRAYS_PROC* glpfDrawArrays;
GLAPI PFNGLDEPTHMASK_PROC* glpfDepthMask;
GLAPI PFNGLBLENDFUNC_PROC* glpfBlendFunc;
GLAPI PFNGLHINT_PROC* glpfHint;
GLAPI PFNGLGETERROR_PROC* glpfGetError;
GLAPI PFNGLENABLE_PROC* glpfEnable;
GLAPI PFNGLDISABLE_PROC* glpfDisable;
GLAPI PFNGLENABLECLIENTSTATE_PROC* glpfEnableClientState;
GLAPI PFNGLTEXENVI_PROC* glpfTexEnvi;
GLAPI PFNGLPOLYGONMODE_PROC* glpfPolygonMode;
GLAPI PFNGLALPHAFUNC_PROC* glpfAlphaFunc;
GLAPI PFNGLVERTEXPOINTER_PROC* glpfVertexPointer;
GLAPI PFNGLCOLORPOINTER_PROC* glpfColorPointer;
GLAPI PFNGLTEXCOORDPOINTER_PROC* glpfTexCoordPointer;
GLAPI PFNGLMATRIXMODE_PROC* glpfMatrixMode;
GLAPI PFNGLLOADMATRIXF_PROC* glpfLoadMatrixf;

#define glDrawRangeElements glpfDrawRangeElements
#define glTexImage3D glpfTexImage3D
#define glTexSubImage3D glpfTexSubImage3D
#define glCopyTexSubImage3D glpfCopyTexSubImage3D
#define glDeleteTextures glpfDeleteTextures
#define glGenTextures glpfGenTextures
#define glBindTexture glpfBindTexture
#define glTexParameteri glpfTexParameteri
#define glTexImage2D glpfTexImage2D
#define glGetIntegerv glpfGetIntegerv
#define glPixelStorei glpfPixelStorei
#define glReadPixels glpfReadPixels
#define glViewport glpfViewport
#define glClearColor glpfClearColor
#define glClear glpfClear
#define glScissor glpfScissor
#define glDrawArrays glpfDrawArrays
#define glDepthMask glpfDepthMask
#define glBlendFunc glpfBlendFunc
#define glHint glpfHint
#define glGetError glpfGetError
#define glEnable glpfEnable
#define glDisable glpfDisable
#define glEnableClientState glpfEnableClientState
#define glTexEnvi glpfTexEnvi
#define glPolygonMode glpfPolygonMode
#define glAlphaFunc glpfAlphaFunc
#define glVertexPointer glpfVertexPointer
#define glColorPointer glpfColorPointer
#define glTexCoordPointer glpfTexCoordPointer
#define glMatrixMode glpfMatrixMode
#define glLoadMatrixf glpfLoadMatrixf

/* GL_VERSION_1_3 */

typedef void (APIENTRY PFNGLACTIVETEXTURE_PROC (GLenum texture));
typedef void (APIENTRY PFNGLSAMPLECOVERAGE_PROC (GLfloat value, GLboolean invert));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXIMAGE3D_PROC (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXIMAGE2D_PROC (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXIMAGE1D_PROC (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXSUBIMAGE3D_PROC (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXSUBIMAGE2D_PROC (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLCOMPRESSEDTEXSUBIMAGE1D_PROC (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void * data));
typedef void (APIENTRY PFNGLGETCOMPRESSEDTEXIMAGE_PROC (GLenum target, GLint level, void * img));

GLAPI PFNGLACTIVETEXTURE_PROC* glpfActiveTexture;
GLAPI PFNGLSAMPLECOVERAGE_PROC* glpfSampleCoverage;
GLAPI PFNGLCOMPRESSEDTEXIMAGE3D_PROC* glpfCompressedTexImage3D;
GLAPI PFNGLCOMPRESSEDTEXIMAGE2D_PROC* glpfCompressedTexImage2D;
GLAPI PFNGLCOMPRESSEDTEXIMAGE1D_PROC* glpfCompressedTexImage1D;
GLAPI PFNGLCOMPRESSEDTEXSUBIMAGE3D_PROC* glpfCompressedTexSubImage3D;
GLAPI PFNGLCOMPRESSEDTEXSUBIMAGE2D_PROC* glpfCompressedTexSubImage2D;
GLAPI PFNGLCOMPRESSEDTEXSUBIMAGE1D_PROC* glpfCompressedTexSubImage1D;
GLAPI PFNGLGETCOMPRESSEDTEXIMAGE_PROC* glpfGetCompressedTexImage;

#define glActiveTexture glpfActiveTexture
#define glSampleCoverage glpfSampleCoverage
#define glCompressedTexImage3D glpfCompressedTexImage3D
#define glCompressedTexImage2D glpfCompressedTexImage2D
#define glCompressedTexImage1D glpfCompressedTexImage1D
#define glCompressedTexSubImage3D glpfCompressedTexSubImage3D
#define glCompressedTexSubImage2D glpfCompressedTexSubImage2D
#define glCompressedTexSubImage1D glpfCompressedTexSubImage1D
#define glGetCompressedTexImage glpfGetCompressedTexImage


/* GL_VERSION_1_4 */

typedef void (APIENTRY PFNGLBLENDFUNCSEPARATE_PROC (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha));
typedef void (APIENTRY PFNGLMULTIDRAWARRAYS_PROC (GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount));
typedef void (APIENTRY PFNGLMULTIDRAWELEMENTS_PROC (GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei drawcount));
typedef void (APIENTRY PFNGLPOINTPARAMETERF_PROC (GLenum pname, GLfloat param));
typedef void (APIENTRY PFNGLPOINTPARAMETERFV_PROC (GLenum pname, const GLfloat * params));
typedef void (APIENTRY PFNGLPOINTPARAMETERI_PROC (GLenum pname, GLint param));
typedef void (APIENTRY PFNGLPOINTPARAMETERIV_PROC (GLenum pname, const GLint * params));
typedef void (APIENTRY PFNGLBLENDCOLOR_PROC (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha));
typedef void (APIENTRY PFNGLBLENDEQUATION_PROC (GLenum mode));

GLAPI PFNGLBLENDFUNCSEPARATE_PROC* glpfBlendFuncSeparate;
GLAPI PFNGLMULTIDRAWARRAYS_PROC* glpfMultiDrawArrays;
GLAPI PFNGLMULTIDRAWELEMENTS_PROC* glpfMultiDrawElements;
GLAPI PFNGLPOINTPARAMETERF_PROC* glpfPointParameterf;
GLAPI PFNGLPOINTPARAMETERFV_PROC* glpfPointParameterfv;
GLAPI PFNGLPOINTPARAMETERI_PROC* glpfPointParameteri;
GLAPI PFNGLPOINTPARAMETERIV_PROC* glpfPointParameteriv;
GLAPI PFNGLBLENDCOLOR_PROC* glpfBlendColor;
GLAPI PFNGLBLENDEQUATION_PROC* glpfBlendEquation;

#define glBlendFuncSeparate glpfBlendFuncSeparate
#define glMultiDrawArrays glpfMultiDrawArrays
#define glMultiDrawElements glpfMultiDrawElements
#define glPointParameterf glpfPointParameterf
#define glPointParameterfv glpfPointParameterfv
#define glPointParameteri glpfPointParameteri
#define glPointParameteriv glpfPointParameteriv
#define glBlendColor glpfBlendColor
#define glBlendEquation glpfBlendEquation


/* GL_VERSION_1_5 */

typedef void (APIENTRY PFNGLGENQUERIES_PROC (GLsizei n, GLuint * ids));
typedef void (APIENTRY PFNGLDELETEQUERIES_PROC (GLsizei n, const GLuint * ids));
typedef GLboolean (APIENTRY PFNGLISQUERY_PROC (GLuint id));
typedef void (APIENTRY PFNGLBEGINQUERY_PROC (GLenum target, GLuint id));
typedef void (APIENTRY PFNGLENDQUERY_PROC (GLenum target));
typedef void (APIENTRY PFNGLGETQUERYIV_PROC (GLenum target, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETQUERYOBJECTIV_PROC (GLuint id, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETQUERYOBJECTUIV_PROC (GLuint id, GLenum pname, GLuint * params));
typedef void (APIENTRY PFNGLBINDBUFFER_PROC (GLenum target, GLuint buffer));
typedef void (APIENTRY PFNGLDELETEBUFFERS_PROC (GLsizei n, const GLuint * buffers));
typedef void (APIENTRY PFNGLGENBUFFERS_PROC (GLsizei n, GLuint * buffers));
typedef GLboolean (APIENTRY PFNGLISBUFFER_PROC (GLuint buffer));
typedef void (APIENTRY PFNGLBUFFERDATA_PROC (GLenum target, GLsizeiptr size, const void * data, GLenum usage));
typedef void (APIENTRY PFNGLBUFFERSUBDATA_PROC (GLenum target, GLintptr offset, GLsizeiptr size, const void * data));
typedef void (APIENTRY PFNGLGETBUFFERSUBDATA_PROC (GLenum target, GLintptr offset, GLsizeiptr size, void * data));
typedef void * (APIENTRY PFNGLMAPBUFFER_PROC (GLenum target, GLenum access));
typedef GLboolean (APIENTRY PFNGLUNMAPBUFFER_PROC (GLenum target));
typedef void (APIENTRY PFNGLGETBUFFERPARAMETERIV_PROC (GLenum target, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETBUFFERPOINTERV_PROC (GLenum target, GLenum pname, void ** params));

GLAPI PFNGLGENQUERIES_PROC* glpfGenQueries;
GLAPI PFNGLDELETEQUERIES_PROC* glpfDeleteQueries;
GLAPI PFNGLISQUERY_PROC* glpfIsQuery;
GLAPI PFNGLBEGINQUERY_PROC* glpfBeginQuery;
GLAPI PFNGLENDQUERY_PROC* glpfEndQuery;
GLAPI PFNGLGETQUERYIV_PROC* glpfGetQueryiv;
GLAPI PFNGLGETQUERYOBJECTIV_PROC* glpfGetQueryObjectiv;
GLAPI PFNGLGETQUERYOBJECTUIV_PROC* glpfGetQueryObjectuiv;
GLAPI PFNGLBINDBUFFER_PROC* glpfBindBuffer;
GLAPI PFNGLDELETEBUFFERS_PROC* glpfDeleteBuffers;
GLAPI PFNGLGENBUFFERS_PROC* glpfGenBuffers;
GLAPI PFNGLISBUFFER_PROC* glpfIsBuffer;
GLAPI PFNGLBUFFERDATA_PROC* glpfBufferData;
GLAPI PFNGLBUFFERSUBDATA_PROC* glpfBufferSubData;
GLAPI PFNGLGETBUFFERSUBDATA_PROC* glpfGetBufferSubData;
GLAPI PFNGLMAPBUFFER_PROC* glpfMapBuffer;
GLAPI PFNGLUNMAPBUFFER_PROC* glpfUnmapBuffer;
GLAPI PFNGLGETBUFFERPARAMETERIV_PROC* glpfGetBufferParameteriv;
GLAPI PFNGLGETBUFFERPOINTERV_PROC* glpfGetBufferPointerv;

#define glGenQueries glpfGenQueries
#define glDeleteQueries glpfDeleteQueries
#define glIsQuery glpfIsQuery
#define glBeginQuery glpfBeginQuery
#define glEndQuery glpfEndQuery
#define glGetQueryiv glpfGetQueryiv
#define glGetQueryObjectiv glpfGetQueryObjectiv
#define glGetQueryObjectuiv glpfGetQueryObjectuiv
#define glBindBuffer glpfBindBuffer
#define glDeleteBuffers glpfDeleteBuffers
#define glGenBuffers glpfGenBuffers
#define glIsBuffer glpfIsBuffer
#define glBufferData glpfBufferData
#define glBufferSubData glpfBufferSubData
#define glGetBufferSubData glpfGetBufferSubData
#define glMapBuffer glpfMapBuffer
#define glUnmapBuffer glpfUnmapBuffer
#define glGetBufferParameteriv glpfGetBufferParameteriv
#define glGetBufferPointerv glpfGetBufferPointerv


/* GL_VERSION_2_0 */

typedef void (APIENTRY PFNGLBLENDEQUATIONSEPARATE_PROC (GLenum modeRGB, GLenum modeAlpha));
typedef void (APIENTRY PFNGLDRAWBUFFERS_PROC (GLsizei n, const GLenum * bufs));
typedef void (APIENTRY PFNGLSTENCILOPSEPARATE_PROC (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass));
typedef void (APIENTRY PFNGLSTENCILFUNCSEPARATE_PROC (GLenum face, GLenum func, GLint ref, GLuint mask));
typedef void (APIENTRY PFNGLSTENCILMASKSEPARATE_PROC (GLenum face, GLuint mask));
typedef void (APIENTRY PFNGLATTACHSHADER_PROC (GLuint program, GLuint shader));
typedef void (APIENTRY PFNGLBINDATTRIBLOCATION_PROC (GLuint program, GLuint index, const GLchar * name));
typedef void (APIENTRY PFNGLCOMPILESHADER_PROC (GLuint shader));
typedef GLuint (APIENTRY PFNGLCREATEPROGRAM_PROC (void));
typedef GLuint (APIENTRY PFNGLCREATESHADER_PROC (GLenum type));
typedef void (APIENTRY PFNGLDELETEPROGRAM_PROC (GLuint program));
typedef void (APIENTRY PFNGLDELETESHADER_PROC (GLuint shader));
typedef void (APIENTRY PFNGLDETACHSHADER_PROC (GLuint program, GLuint shader));
typedef void (APIENTRY PFNGLDISABLEVERTEXATTRIBARRAY_PROC (GLuint index));
typedef void (APIENTRY PFNGLENABLEVERTEXATTRIBARRAY_PROC (GLuint index));
typedef void (APIENTRY PFNGLGETACTIVEATTRIB_PROC (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name));
typedef void (APIENTRY PFNGLGETACTIVEUNIFORM_PROC (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name));
typedef void (APIENTRY PFNGLGETATTACHEDSHADERS_PROC (GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders));
typedef GLint (APIENTRY PFNGLGETATTRIBLOCATION_PROC (GLuint program, const GLchar * name));
typedef void (APIENTRY PFNGLGETPROGRAMIV_PROC (GLuint program, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETPROGRAMINFOLOG_PROC (GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog));
typedef void (APIENTRY PFNGLGETSHADERIV_PROC (GLuint shader, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETSHADERINFOLOG_PROC (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog));
typedef void (APIENTRY PFNGLGETSHADERSOURCE_PROC (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source));
typedef GLint (APIENTRY PFNGLGETUNIFORMLOCATION_PROC (GLuint program, const GLchar * name));
typedef void (APIENTRY PFNGLGETUNIFORMFV_PROC (GLuint program, GLint location, GLfloat * params));
typedef void (APIENTRY PFNGLGETUNIFORMIV_PROC (GLuint program, GLint location, GLint * params));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBDV_PROC (GLuint index, GLenum pname, GLdouble * params));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBFV_PROC (GLuint index, GLenum pname, GLfloat * params));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBIV_PROC (GLuint index, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBPOINTERV_PROC (GLuint index, GLenum pname, void ** pointer));
typedef GLboolean (APIENTRY PFNGLISPROGRAM_PROC (GLuint program));
typedef GLboolean (APIENTRY PFNGLISSHADER_PROC (GLuint shader));
typedef void (APIENTRY PFNGLLINKPROGRAM_PROC (GLuint program));
typedef void (APIENTRY PFNGLSHADERSOURCE_PROC (GLuint shader, GLsizei count, const GLchar *const* string, const GLint * length));
typedef void (APIENTRY PFNGLUSEPROGRAM_PROC (GLuint program));
typedef void (APIENTRY PFNGLUNIFORM1F_PROC (GLint location, GLfloat v0));
typedef void (APIENTRY PFNGLUNIFORM2F_PROC (GLint location, GLfloat v0, GLfloat v1));
typedef void (APIENTRY PFNGLUNIFORM3F_PROC (GLint location, GLfloat v0, GLfloat v1, GLfloat v2));
typedef void (APIENTRY PFNGLUNIFORM4F_PROC (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3));
typedef void (APIENTRY PFNGLUNIFORM1I_PROC (GLint location, GLint v0));
typedef void (APIENTRY PFNGLUNIFORM2I_PROC (GLint location, GLint v0, GLint v1));
typedef void (APIENTRY PFNGLUNIFORM3I_PROC (GLint location, GLint v0, GLint v1, GLint v2));
typedef void (APIENTRY PFNGLUNIFORM4I_PROC (GLint location, GLint v0, GLint v1, GLint v2, GLint v3));
typedef void (APIENTRY PFNGLUNIFORM1FV_PROC (GLint location, GLsizei count, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORM2FV_PROC (GLint location, GLsizei count, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORM3FV_PROC (GLint location, GLsizei count, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORM4FV_PROC (GLint location, GLsizei count, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORM1IV_PROC (GLint location, GLsizei count, const GLint * value));
typedef void (APIENTRY PFNGLUNIFORM2IV_PROC (GLint location, GLsizei count, const GLint * value));
typedef void (APIENTRY PFNGLUNIFORM3IV_PROC (GLint location, GLsizei count, const GLint * value));
typedef void (APIENTRY PFNGLUNIFORM4IV_PROC (GLint location, GLsizei count, const GLint * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX2FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX3FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX4FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLVALIDATEPROGRAM_PROC (GLuint program));
typedef void (APIENTRY PFNGLVERTEXATTRIB1D_PROC (GLuint index, GLdouble x));
typedef void (APIENTRY PFNGLVERTEXATTRIB1DV_PROC (GLuint index, const GLdouble * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB1F_PROC (GLuint index, GLfloat x));
typedef void (APIENTRY PFNGLVERTEXATTRIB1FV_PROC (GLuint index, const GLfloat * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB1S_PROC (GLuint index, GLshort x));
typedef void (APIENTRY PFNGLVERTEXATTRIB1SV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB2D_PROC (GLuint index, GLdouble x, GLdouble y));
typedef void (APIENTRY PFNGLVERTEXATTRIB2DV_PROC (GLuint index, const GLdouble * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB2F_PROC (GLuint index, GLfloat x, GLfloat y));
typedef void (APIENTRY PFNGLVERTEXATTRIB2FV_PROC (GLuint index, const GLfloat * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB2S_PROC (GLuint index, GLshort x, GLshort y));
typedef void (APIENTRY PFNGLVERTEXATTRIB2SV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB3D_PROC (GLuint index, GLdouble x, GLdouble y, GLdouble z));
typedef void (APIENTRY PFNGLVERTEXATTRIB3DV_PROC (GLuint index, const GLdouble * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB3F_PROC (GLuint index, GLfloat x, GLfloat y, GLfloat z));
typedef void (APIENTRY PFNGLVERTEXATTRIB3FV_PROC (GLuint index, const GLfloat * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB3S_PROC (GLuint index, GLshort x, GLshort y, GLshort z));
typedef void (APIENTRY PFNGLVERTEXATTRIB3SV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NBV_PROC (GLuint index, const GLbyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NIV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NSV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NUB_PROC (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NUBV_PROC (GLuint index, const GLubyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NUIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4NUSV_PROC (GLuint index, const GLushort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4BV_PROC (GLuint index, const GLbyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4D_PROC (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w));
typedef void (APIENTRY PFNGLVERTEXATTRIB4DV_PROC (GLuint index, const GLdouble * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4F_PROC (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w));
typedef void (APIENTRY PFNGLVERTEXATTRIB4FV_PROC (GLuint index, const GLfloat * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4IV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4S_PROC (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w));
typedef void (APIENTRY PFNGLVERTEXATTRIB4SV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4UBV_PROC (GLuint index, const GLubyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4UIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIB4USV_PROC (GLuint index, const GLushort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBPOINTER_PROC (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void * pointer));

GLAPI PFNGLBLENDEQUATIONSEPARATE_PROC* glpfBlendEquationSeparate;
GLAPI PFNGLDRAWBUFFERS_PROC* glpfDrawBuffers;
GLAPI PFNGLSTENCILOPSEPARATE_PROC* glpfStencilOpSeparate;
GLAPI PFNGLSTENCILFUNCSEPARATE_PROC* glpfStencilFuncSeparate;
GLAPI PFNGLSTENCILMASKSEPARATE_PROC* glpfStencilMaskSeparate;
GLAPI PFNGLATTACHSHADER_PROC* glpfAttachShader;
GLAPI PFNGLBINDATTRIBLOCATION_PROC* glpfBindAttribLocation;
GLAPI PFNGLCOMPILESHADER_PROC* glpfCompileShader;
GLAPI PFNGLCREATEPROGRAM_PROC* glpfCreateProgram;
GLAPI PFNGLCREATESHADER_PROC* glpfCreateShader;
GLAPI PFNGLDELETEPROGRAM_PROC* glpfDeleteProgram;
GLAPI PFNGLDELETESHADER_PROC* glpfDeleteShader;
GLAPI PFNGLDETACHSHADER_PROC* glpfDetachShader;
GLAPI PFNGLDISABLEVERTEXATTRIBARRAY_PROC* glpfDisableVertexAttribArray;
GLAPI PFNGLENABLEVERTEXATTRIBARRAY_PROC* glpfEnableVertexAttribArray;
GLAPI PFNGLGETACTIVEATTRIB_PROC* glpfGetActiveAttrib;
GLAPI PFNGLGETACTIVEUNIFORM_PROC* glpfGetActiveUniform;
GLAPI PFNGLGETATTACHEDSHADERS_PROC* glpfGetAttachedShaders;
GLAPI PFNGLGETATTRIBLOCATION_PROC* glpfGetAttribLocation;
GLAPI PFNGLGETPROGRAMIV_PROC* glpfGetProgramiv;
GLAPI PFNGLGETPROGRAMINFOLOG_PROC* glpfGetProgramInfoLog;
GLAPI PFNGLGETSHADERIV_PROC* glpfGetShaderiv;
GLAPI PFNGLGETSHADERINFOLOG_PROC* glpfGetShaderInfoLog;
GLAPI PFNGLGETSHADERSOURCE_PROC* glpfGetShaderSource;
GLAPI PFNGLGETUNIFORMLOCATION_PROC* glpfGetUniformLocation;
GLAPI PFNGLGETUNIFORMFV_PROC* glpfGetUniformfv;
GLAPI PFNGLGETUNIFORMIV_PROC* glpfGetUniformiv;
GLAPI PFNGLGETVERTEXATTRIBDV_PROC* glpfGetVertexAttribdv;
GLAPI PFNGLGETVERTEXATTRIBFV_PROC* glpfGetVertexAttribfv;
GLAPI PFNGLGETVERTEXATTRIBIV_PROC* glpfGetVertexAttribiv;
GLAPI PFNGLGETVERTEXATTRIBPOINTERV_PROC* glpfGetVertexAttribPointerv;
GLAPI PFNGLISPROGRAM_PROC* glpfIsProgram;
GLAPI PFNGLISSHADER_PROC* glpfIsShader;
GLAPI PFNGLLINKPROGRAM_PROC* glpfLinkProgram;
GLAPI PFNGLSHADERSOURCE_PROC* glpfShaderSource;
GLAPI PFNGLUSEPROGRAM_PROC* glpfUseProgram;
GLAPI PFNGLUNIFORM1F_PROC* glpfUniform1f;
GLAPI PFNGLUNIFORM2F_PROC* glpfUniform2f;
GLAPI PFNGLUNIFORM3F_PROC* glpfUniform3f;
GLAPI PFNGLUNIFORM4F_PROC* glpfUniform4f;
GLAPI PFNGLUNIFORM1I_PROC* glpfUniform1i;
GLAPI PFNGLUNIFORM2I_PROC* glpfUniform2i;
GLAPI PFNGLUNIFORM3I_PROC* glpfUniform3i;
GLAPI PFNGLUNIFORM4I_PROC* glpfUniform4i;
GLAPI PFNGLUNIFORM1FV_PROC* glpfUniform1fv;
GLAPI PFNGLUNIFORM2FV_PROC* glpfUniform2fv;
GLAPI PFNGLUNIFORM3FV_PROC* glpfUniform3fv;
GLAPI PFNGLUNIFORM4FV_PROC* glpfUniform4fv;
GLAPI PFNGLUNIFORM1IV_PROC* glpfUniform1iv;
GLAPI PFNGLUNIFORM2IV_PROC* glpfUniform2iv;
GLAPI PFNGLUNIFORM3IV_PROC* glpfUniform3iv;
GLAPI PFNGLUNIFORM4IV_PROC* glpfUniform4iv;
GLAPI PFNGLUNIFORMMATRIX2FV_PROC* glpfUniformMatrix2fv;
GLAPI PFNGLUNIFORMMATRIX3FV_PROC* glpfUniformMatrix3fv;
GLAPI PFNGLUNIFORMMATRIX4FV_PROC* glpfUniformMatrix4fv;
GLAPI PFNGLVALIDATEPROGRAM_PROC* glpfValidateProgram;
GLAPI PFNGLVERTEXATTRIB1D_PROC* glpfVertexAttrib1d;
GLAPI PFNGLVERTEXATTRIB1DV_PROC* glpfVertexAttrib1dv;
GLAPI PFNGLVERTEXATTRIB1F_PROC* glpfVertexAttrib1f;
GLAPI PFNGLVERTEXATTRIB1FV_PROC* glpfVertexAttrib1fv;
GLAPI PFNGLVERTEXATTRIB1S_PROC* glpfVertexAttrib1s;
GLAPI PFNGLVERTEXATTRIB1SV_PROC* glpfVertexAttrib1sv;
GLAPI PFNGLVERTEXATTRIB2D_PROC* glpfVertexAttrib2d;
GLAPI PFNGLVERTEXATTRIB2DV_PROC* glpfVertexAttrib2dv;
GLAPI PFNGLVERTEXATTRIB2F_PROC* glpfVertexAttrib2f;
GLAPI PFNGLVERTEXATTRIB2FV_PROC* glpfVertexAttrib2fv;
GLAPI PFNGLVERTEXATTRIB2S_PROC* glpfVertexAttrib2s;
GLAPI PFNGLVERTEXATTRIB2SV_PROC* glpfVertexAttrib2sv;
GLAPI PFNGLVERTEXATTRIB3D_PROC* glpfVertexAttrib3d;
GLAPI PFNGLVERTEXATTRIB3DV_PROC* glpfVertexAttrib3dv;
GLAPI PFNGLVERTEXATTRIB3F_PROC* glpfVertexAttrib3f;
GLAPI PFNGLVERTEXATTRIB3FV_PROC* glpfVertexAttrib3fv;
GLAPI PFNGLVERTEXATTRIB3S_PROC* glpfVertexAttrib3s;
GLAPI PFNGLVERTEXATTRIB3SV_PROC* glpfVertexAttrib3sv;
GLAPI PFNGLVERTEXATTRIB4NBV_PROC* glpfVertexAttrib4Nbv;
GLAPI PFNGLVERTEXATTRIB4NIV_PROC* glpfVertexAttrib4Niv;
GLAPI PFNGLVERTEXATTRIB4NSV_PROC* glpfVertexAttrib4Nsv;
GLAPI PFNGLVERTEXATTRIB4NUB_PROC* glpfVertexAttrib4Nub;
GLAPI PFNGLVERTEXATTRIB4NUBV_PROC* glpfVertexAttrib4Nubv;
GLAPI PFNGLVERTEXATTRIB4NUIV_PROC* glpfVertexAttrib4Nuiv;
GLAPI PFNGLVERTEXATTRIB4NUSV_PROC* glpfVertexAttrib4Nusv;
GLAPI PFNGLVERTEXATTRIB4BV_PROC* glpfVertexAttrib4bv;
GLAPI PFNGLVERTEXATTRIB4D_PROC* glpfVertexAttrib4d;
GLAPI PFNGLVERTEXATTRIB4DV_PROC* glpfVertexAttrib4dv;
GLAPI PFNGLVERTEXATTRIB4F_PROC* glpfVertexAttrib4f;
GLAPI PFNGLVERTEXATTRIB4FV_PROC* glpfVertexAttrib4fv;
GLAPI PFNGLVERTEXATTRIB4IV_PROC* glpfVertexAttrib4iv;
GLAPI PFNGLVERTEXATTRIB4S_PROC* glpfVertexAttrib4s;
GLAPI PFNGLVERTEXATTRIB4SV_PROC* glpfVertexAttrib4sv;
GLAPI PFNGLVERTEXATTRIB4UBV_PROC* glpfVertexAttrib4ubv;
GLAPI PFNGLVERTEXATTRIB4UIV_PROC* glpfVertexAttrib4uiv;
GLAPI PFNGLVERTEXATTRIB4USV_PROC* glpfVertexAttrib4usv;
GLAPI PFNGLVERTEXATTRIBPOINTER_PROC* glpfVertexAttribPointer;

#define glBlendEquationSeparate glpfBlendEquationSeparate
#define glDrawBuffers glpfDrawBuffers
#define glStencilOpSeparate glpfStencilOpSeparate
#define glStencilFuncSeparate glpfStencilFuncSeparate
#define glStencilMaskSeparate glpfStencilMaskSeparate
#define glAttachShader glpfAttachShader
#define glBindAttribLocation glpfBindAttribLocation
#define glCompileShader glpfCompileShader
#define glCreateProgram glpfCreateProgram
#define glCreateShader glpfCreateShader
#define glDeleteProgram glpfDeleteProgram
#define glDeleteShader glpfDeleteShader
#define glDetachShader glpfDetachShader
#define glDisableVertexAttribArray glpfDisableVertexAttribArray
#define glEnableVertexAttribArray glpfEnableVertexAttribArray
#define glGetActiveAttrib glpfGetActiveAttrib
#define glGetActiveUniform glpfGetActiveUniform
#define glGetAttachedShaders glpfGetAttachedShaders
#define glGetAttribLocation glpfGetAttribLocation
#define glGetProgramiv glpfGetProgramiv
#define glGetProgramInfoLog glpfGetProgramInfoLog
#define glGetShaderiv glpfGetShaderiv
#define glGetShaderInfoLog glpfGetShaderInfoLog
#define glGetShaderSource glpfGetShaderSource
#define glGetUniformLocation glpfGetUniformLocation
#define glGetUniformfv glpfGetUniformfv
#define glGetUniformiv glpfGetUniformiv
#define glGetVertexAttribdv glpfGetVertexAttribdv
#define glGetVertexAttribfv glpfGetVertexAttribfv
#define glGetVertexAttribiv glpfGetVertexAttribiv
#define glGetVertexAttribPointerv glpfGetVertexAttribPointerv
#define glIsProgram glpfIsProgram
#define glIsShader glpfIsShader
#define glLinkProgram glpfLinkProgram
#define glShaderSource glpfShaderSource
#define glUseProgram glpfUseProgram
#define glUniform1f glpfUniform1f
#define glUniform2f glpfUniform2f
#define glUniform3f glpfUniform3f
#define glUniform4f glpfUniform4f
#define glUniform1i glpfUniform1i
#define glUniform2i glpfUniform2i
#define glUniform3i glpfUniform3i
#define glUniform4i glpfUniform4i
#define glUniform1fv glpfUniform1fv
#define glUniform2fv glpfUniform2fv
#define glUniform3fv glpfUniform3fv
#define glUniform4fv glpfUniform4fv
#define glUniform1iv glpfUniform1iv
#define glUniform2iv glpfUniform2iv
#define glUniform3iv glpfUniform3iv
#define glUniform4iv glpfUniform4iv
#define glUniformMatrix2fv glpfUniformMatrix2fv
#define glUniformMatrix3fv glpfUniformMatrix3fv
#define glUniformMatrix4fv glpfUniformMatrix4fv
#define glValidateProgram glpfValidateProgram
#define glVertexAttrib1d glpfVertexAttrib1d
#define glVertexAttrib1dv glpfVertexAttrib1dv
#define glVertexAttrib1f glpfVertexAttrib1f
#define glVertexAttrib1fv glpfVertexAttrib1fv
#define glVertexAttrib1s glpfVertexAttrib1s
#define glVertexAttrib1sv glpfVertexAttrib1sv
#define glVertexAttrib2d glpfVertexAttrib2d
#define glVertexAttrib2dv glpfVertexAttrib2dv
#define glVertexAttrib2f glpfVertexAttrib2f
#define glVertexAttrib2fv glpfVertexAttrib2fv
#define glVertexAttrib2s glpfVertexAttrib2s
#define glVertexAttrib2sv glpfVertexAttrib2sv
#define glVertexAttrib3d glpfVertexAttrib3d
#define glVertexAttrib3dv glpfVertexAttrib3dv
#define glVertexAttrib3f glpfVertexAttrib3f
#define glVertexAttrib3fv glpfVertexAttrib3fv
#define glVertexAttrib3s glpfVertexAttrib3s
#define glVertexAttrib3sv glpfVertexAttrib3sv
#define glVertexAttrib4Nbv glpfVertexAttrib4Nbv
#define glVertexAttrib4Niv glpfVertexAttrib4Niv
#define glVertexAttrib4Nsv glpfVertexAttrib4Nsv
#define glVertexAttrib4Nub glpfVertexAttrib4Nub
#define glVertexAttrib4Nubv glpfVertexAttrib4Nubv
#define glVertexAttrib4Nuiv glpfVertexAttrib4Nuiv
#define glVertexAttrib4Nusv glpfVertexAttrib4Nusv
#define glVertexAttrib4bv glpfVertexAttrib4bv
#define glVertexAttrib4d glpfVertexAttrib4d
#define glVertexAttrib4dv glpfVertexAttrib4dv
#define glVertexAttrib4f glpfVertexAttrib4f
#define glVertexAttrib4fv glpfVertexAttrib4fv
#define glVertexAttrib4iv glpfVertexAttrib4iv
#define glVertexAttrib4s glpfVertexAttrib4s
#define glVertexAttrib4sv glpfVertexAttrib4sv
#define glVertexAttrib4ubv glpfVertexAttrib4ubv
#define glVertexAttrib4uiv glpfVertexAttrib4uiv
#define glVertexAttrib4usv glpfVertexAttrib4usv
#define glVertexAttribPointer glpfVertexAttribPointer


/* GL_VERSION_2_1 */

typedef void (APIENTRY PFNGLUNIFORMMATRIX2X3FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX3X2FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX2X4FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX4X2FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX3X4FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));
typedef void (APIENTRY PFNGLUNIFORMMATRIX4X3FV_PROC (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value));

GLAPI PFNGLUNIFORMMATRIX2X3FV_PROC* glpfUniformMatrix2x3fv;
GLAPI PFNGLUNIFORMMATRIX3X2FV_PROC* glpfUniformMatrix3x2fv;
GLAPI PFNGLUNIFORMMATRIX2X4FV_PROC* glpfUniformMatrix2x4fv;
GLAPI PFNGLUNIFORMMATRIX4X2FV_PROC* glpfUniformMatrix4x2fv;
GLAPI PFNGLUNIFORMMATRIX3X4FV_PROC* glpfUniformMatrix3x4fv;
GLAPI PFNGLUNIFORMMATRIX4X3FV_PROC* glpfUniformMatrix4x3fv;

#define glUniformMatrix2x3fv glpfUniformMatrix2x3fv
#define glUniformMatrix3x2fv glpfUniformMatrix3x2fv
#define glUniformMatrix2x4fv glpfUniformMatrix2x4fv
#define glUniformMatrix4x2fv glpfUniformMatrix4x2fv
#define glUniformMatrix3x4fv glpfUniformMatrix3x4fv
#define glUniformMatrix4x3fv glpfUniformMatrix4x3fv


/* GL_VERSION_3_0 */

typedef void (APIENTRY PFNGLCOLORMASKI_PROC (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a));
typedef void (APIENTRY PFNGLGETBOOLEANI_V_PROC (GLenum target, GLuint index, GLboolean * data));
typedef void (APIENTRY PFNGLGETINTEGERI_V_PROC (GLenum target, GLuint index, GLint * data));
typedef void (APIENTRY PFNGLENABLEI_PROC (GLenum target, GLuint index));
typedef void (APIENTRY PFNGLDISABLEI_PROC (GLenum target, GLuint index));
typedef GLboolean (APIENTRY PFNGLISENABLEDI_PROC (GLenum target, GLuint index));
typedef void (APIENTRY PFNGLBEGINTRANSFORMFEEDBACK_PROC (GLenum primitiveMode));
typedef void (APIENTRY PFNGLENDTRANSFORMFEEDBACK_PROC (void));
typedef void (APIENTRY PFNGLBINDBUFFERRANGE_PROC (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size));
typedef void (APIENTRY PFNGLBINDBUFFERBASE_PROC (GLenum target, GLuint index, GLuint buffer));
typedef void (APIENTRY PFNGLTRANSFORMFEEDBACKVARYINGS_PROC (GLuint program, GLsizei count, const GLchar *const* varyings, GLenum bufferMode));
typedef void (APIENTRY PFNGLGETTRANSFORMFEEDBACKVARYING_PROC (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name));
typedef void (APIENTRY PFNGLCLAMPCOLOR_PROC (GLenum target, GLenum clamp));
typedef void (APIENTRY PFNGLBEGINCONDITIONALRENDER_PROC (GLuint id, GLenum mode));
typedef void (APIENTRY PFNGLENDCONDITIONALRENDER_PROC (void));
typedef void (APIENTRY PFNGLVERTEXATTRIBIPOINTER_PROC (GLuint index, GLint size, GLenum type, GLsizei stride, const void * pointer));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBIIV_PROC (GLuint index, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETVERTEXATTRIBIUIV_PROC (GLuint index, GLenum pname, GLuint * params));
typedef void (APIENTRY PFNGLVERTEXATTRIBI1I_PROC (GLuint index, GLint x));
typedef void (APIENTRY PFNGLVERTEXATTRIBI2I_PROC (GLuint index, GLint x, GLint y));
typedef void (APIENTRY PFNGLVERTEXATTRIBI3I_PROC (GLuint index, GLint x, GLint y, GLint z));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4I_PROC (GLuint index, GLint x, GLint y, GLint z, GLint w));
typedef void (APIENTRY PFNGLVERTEXATTRIBI1UI_PROC (GLuint index, GLuint x));
typedef void (APIENTRY PFNGLVERTEXATTRIBI2UI_PROC (GLuint index, GLuint x, GLuint y));
typedef void (APIENTRY PFNGLVERTEXATTRIBI3UI_PROC (GLuint index, GLuint x, GLuint y, GLuint z));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4UI_PROC (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w));
typedef void (APIENTRY PFNGLVERTEXATTRIBI1IV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI2IV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI3IV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4IV_PROC (GLuint index, const GLint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI1UIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI2UIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI3UIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4UIV_PROC (GLuint index, const GLuint * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4BV_PROC (GLuint index, const GLbyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4SV_PROC (GLuint index, const GLshort * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4UBV_PROC (GLuint index, const GLubyte * v));
typedef void (APIENTRY PFNGLVERTEXATTRIBI4USV_PROC (GLuint index, const GLushort * v));
typedef void (APIENTRY PFNGLGETUNIFORMUIV_PROC (GLuint program, GLint location, GLuint * params));
typedef void (APIENTRY PFNGLBINDFRAGDATALOCATION_PROC (GLuint program, GLuint color, const GLchar * name));
typedef GLint (APIENTRY PFNGLGETFRAGDATALOCATION_PROC (GLuint program, const GLchar * name));
typedef void (APIENTRY PFNGLUNIFORM1UI_PROC (GLint location, GLuint v0));
typedef void (APIENTRY PFNGLUNIFORM2UI_PROC (GLint location, GLuint v0, GLuint v1));
typedef void (APIENTRY PFNGLUNIFORM3UI_PROC (GLint location, GLuint v0, GLuint v1, GLuint v2));
typedef void (APIENTRY PFNGLUNIFORM4UI_PROC (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3));
typedef void (APIENTRY PFNGLUNIFORM1UIV_PROC (GLint location, GLsizei count, const GLuint * value));
typedef void (APIENTRY PFNGLUNIFORM2UIV_PROC (GLint location, GLsizei count, const GLuint * value));
typedef void (APIENTRY PFNGLUNIFORM3UIV_PROC (GLint location, GLsizei count, const GLuint * value));
typedef void (APIENTRY PFNGLUNIFORM4UIV_PROC (GLint location, GLsizei count, const GLuint * value));
typedef void (APIENTRY PFNGLTEXPARAMETERIIV_PROC (GLenum target, GLenum pname, const GLint * params));
typedef void (APIENTRY PFNGLTEXPARAMETERIUIV_PROC (GLenum target, GLenum pname, const GLuint * params));
typedef void (APIENTRY PFNGLGETTEXPARAMETERIIV_PROC (GLenum target, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETTEXPARAMETERIUIV_PROC (GLenum target, GLenum pname, GLuint * params));
typedef void (APIENTRY PFNGLCLEARBUFFERIV_PROC (GLenum buffer, GLint drawbuffer, const GLint * value));
typedef void (APIENTRY PFNGLCLEARBUFFERUIV_PROC (GLenum buffer, GLint drawbuffer, const GLuint * value));
typedef void (APIENTRY PFNGLCLEARBUFFERFV_PROC (GLenum buffer, GLint drawbuffer, const GLfloat * value));
typedef void (APIENTRY PFNGLCLEARBUFFERFI_PROC (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil));
typedef const GLubyte * (APIENTRY PFNGLGETSTRINGI_PROC (GLenum name, GLuint index));
typedef GLboolean (APIENTRY PFNGLISRENDERBUFFER_PROC (GLuint renderbuffer));
typedef void (APIENTRY PFNGLBINDRENDERBUFFER_PROC (GLenum target, GLuint renderbuffer));
typedef void (APIENTRY PFNGLDELETERENDERBUFFERS_PROC (GLsizei n, const GLuint * renderbuffers));
typedef void (APIENTRY PFNGLGENRENDERBUFFERS_PROC (GLsizei n, GLuint * renderbuffers));
typedef void (APIENTRY PFNGLRENDERBUFFERSTORAGE_PROC (GLenum target, GLenum internalformat, GLsizei width, GLsizei height));
typedef void (APIENTRY PFNGLGETRENDERBUFFERPARAMETERIV_PROC (GLenum target, GLenum pname, GLint * params));
typedef GLboolean (APIENTRY PFNGLISFRAMEBUFFER_PROC (GLuint framebuffer));
typedef void (APIENTRY PFNGLBINDFRAMEBUFFER_PROC (GLenum target, GLuint framebuffer));
typedef void (APIENTRY PFNGLDELETEFRAMEBUFFERS_PROC (GLsizei n, const GLuint * framebuffers));
typedef void (APIENTRY PFNGLGENFRAMEBUFFERS_PROC (GLsizei n, GLuint * framebuffers));
typedef GLenum (APIENTRY PFNGLCHECKFRAMEBUFFERSTATUS_PROC (GLenum target));
typedef void (APIENTRY PFNGLFRAMEBUFFERTEXTURE1D_PROC (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level));
typedef void (APIENTRY PFNGLFRAMEBUFFERTEXTURE2D_PROC (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level));
typedef void (APIENTRY PFNGLFRAMEBUFFERTEXTURE3D_PROC (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset));
typedef void (APIENTRY PFNGLFRAMEBUFFERRENDERBUFFER_PROC (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer));
typedef void (APIENTRY PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIV_PROC (GLenum target, GLenum attachment, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGENERATEMIPMAP_PROC (GLenum target));
typedef void (APIENTRY PFNGLBLITFRAMEBUFFER_PROC (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter));
typedef void (APIENTRY PFNGLRENDERBUFFERSTORAGEMULTISAMPLE_PROC (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height));
typedef void (APIENTRY PFNGLFRAMEBUFFERTEXTURELAYER_PROC (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer));
typedef void * (APIENTRY PFNGLMAPBUFFERRANGE_PROC (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access));
typedef void (APIENTRY PFNGLFLUSHMAPPEDBUFFERRANGE_PROC (GLenum target, GLintptr offset, GLsizeiptr length));
typedef void (APIENTRY PFNGLBINDVERTEXARRAY_PROC (GLuint array));
typedef void (APIENTRY PFNGLDELETEVERTEXARRAYS_PROC (GLsizei n, const GLuint * arrays));
typedef void (APIENTRY PFNGLGENVERTEXARRAYS_PROC (GLsizei n, GLuint * arrays));
typedef GLboolean (APIENTRY PFNGLISVERTEXARRAY_PROC (GLuint array));

GLAPI PFNGLCOLORMASKI_PROC* glpfColorMaski;
GLAPI PFNGLGETBOOLEANI_V_PROC* glpfGetBooleani_v;
GLAPI PFNGLGETINTEGERI_V_PROC* glpfGetIntegeri_v;
GLAPI PFNGLENABLEI_PROC* glpfEnablei;
GLAPI PFNGLDISABLEI_PROC* glpfDisablei;
GLAPI PFNGLISENABLEDI_PROC* glpfIsEnabledi;
GLAPI PFNGLBEGINTRANSFORMFEEDBACK_PROC* glpfBeginTransformFeedback;
GLAPI PFNGLENDTRANSFORMFEEDBACK_PROC* glpfEndTransformFeedback;
GLAPI PFNGLBINDBUFFERRANGE_PROC* glpfBindBufferRange;
GLAPI PFNGLBINDBUFFERBASE_PROC* glpfBindBufferBase;
GLAPI PFNGLTRANSFORMFEEDBACKVARYINGS_PROC* glpfTransformFeedbackVaryings;
GLAPI PFNGLGETTRANSFORMFEEDBACKVARYING_PROC* glpfGetTransformFeedbackVarying;
GLAPI PFNGLCLAMPCOLOR_PROC* glpfClampColor;
GLAPI PFNGLBEGINCONDITIONALRENDER_PROC* glpfBeginConditionalRender;
GLAPI PFNGLENDCONDITIONALRENDER_PROC* glpfEndConditionalRender;
GLAPI PFNGLVERTEXATTRIBIPOINTER_PROC* glpfVertexAttribIPointer;
GLAPI PFNGLGETVERTEXATTRIBIIV_PROC* glpfGetVertexAttribIiv;
GLAPI PFNGLGETVERTEXATTRIBIUIV_PROC* glpfGetVertexAttribIuiv;
GLAPI PFNGLVERTEXATTRIBI1I_PROC* glpfVertexAttribI1i;
GLAPI PFNGLVERTEXATTRIBI2I_PROC* glpfVertexAttribI2i;
GLAPI PFNGLVERTEXATTRIBI3I_PROC* glpfVertexAttribI3i;
GLAPI PFNGLVERTEXATTRIBI4I_PROC* glpfVertexAttribI4i;
GLAPI PFNGLVERTEXATTRIBI1UI_PROC* glpfVertexAttribI1ui;
GLAPI PFNGLVERTEXATTRIBI2UI_PROC* glpfVertexAttribI2ui;
GLAPI PFNGLVERTEXATTRIBI3UI_PROC* glpfVertexAttribI3ui;
GLAPI PFNGLVERTEXATTRIBI4UI_PROC* glpfVertexAttribI4ui;
GLAPI PFNGLVERTEXATTRIBI1IV_PROC* glpfVertexAttribI1iv;
GLAPI PFNGLVERTEXATTRIBI2IV_PROC* glpfVertexAttribI2iv;
GLAPI PFNGLVERTEXATTRIBI3IV_PROC* glpfVertexAttribI3iv;
GLAPI PFNGLVERTEXATTRIBI4IV_PROC* glpfVertexAttribI4iv;
GLAPI PFNGLVERTEXATTRIBI1UIV_PROC* glpfVertexAttribI1uiv;
GLAPI PFNGLVERTEXATTRIBI2UIV_PROC* glpfVertexAttribI2uiv;
GLAPI PFNGLVERTEXATTRIBI3UIV_PROC* glpfVertexAttribI3uiv;
GLAPI PFNGLVERTEXATTRIBI4UIV_PROC* glpfVertexAttribI4uiv;
GLAPI PFNGLVERTEXATTRIBI4BV_PROC* glpfVertexAttribI4bv;
GLAPI PFNGLVERTEXATTRIBI4SV_PROC* glpfVertexAttribI4sv;
GLAPI PFNGLVERTEXATTRIBI4UBV_PROC* glpfVertexAttribI4ubv;
GLAPI PFNGLVERTEXATTRIBI4USV_PROC* glpfVertexAttribI4usv;
GLAPI PFNGLGETUNIFORMUIV_PROC* glpfGetUniformuiv;
GLAPI PFNGLBINDFRAGDATALOCATION_PROC* glpfBindFragDataLocation;
GLAPI PFNGLGETFRAGDATALOCATION_PROC* glpfGetFragDataLocation;
GLAPI PFNGLUNIFORM1UI_PROC* glpfUniform1ui;
GLAPI PFNGLUNIFORM2UI_PROC* glpfUniform2ui;
GLAPI PFNGLUNIFORM3UI_PROC* glpfUniform3ui;
GLAPI PFNGLUNIFORM4UI_PROC* glpfUniform4ui;
GLAPI PFNGLUNIFORM1UIV_PROC* glpfUniform1uiv;
GLAPI PFNGLUNIFORM2UIV_PROC* glpfUniform2uiv;
GLAPI PFNGLUNIFORM3UIV_PROC* glpfUniform3uiv;
GLAPI PFNGLUNIFORM4UIV_PROC* glpfUniform4uiv;
GLAPI PFNGLTEXPARAMETERIIV_PROC* glpfTexParameterIiv;
GLAPI PFNGLTEXPARAMETERIUIV_PROC* glpfTexParameterIuiv;
GLAPI PFNGLGETTEXPARAMETERIIV_PROC* glpfGetTexParameterIiv;
GLAPI PFNGLGETTEXPARAMETERIUIV_PROC* glpfGetTexParameterIuiv;
GLAPI PFNGLCLEARBUFFERIV_PROC* glpfClearBufferiv;
GLAPI PFNGLCLEARBUFFERUIV_PROC* glpfClearBufferuiv;
GLAPI PFNGLCLEARBUFFERFV_PROC* glpfClearBufferfv;
GLAPI PFNGLCLEARBUFFERFI_PROC* glpfClearBufferfi;
GLAPI PFNGLGETSTRINGI_PROC* glpfGetStringi;
GLAPI PFNGLISRENDERBUFFER_PROC* glpfIsRenderbuffer;
GLAPI PFNGLBINDRENDERBUFFER_PROC* glpfBindRenderbuffer;
GLAPI PFNGLDELETERENDERBUFFERS_PROC* glpfDeleteRenderbuffers;
GLAPI PFNGLGENRENDERBUFFERS_PROC* glpfGenRenderbuffers;
GLAPI PFNGLRENDERBUFFERSTORAGE_PROC* glpfRenderbufferStorage;
GLAPI PFNGLGETRENDERBUFFERPARAMETERIV_PROC* glpfGetRenderbufferParameteriv;
GLAPI PFNGLISFRAMEBUFFER_PROC* glpfIsFramebuffer;
GLAPI PFNGLBINDFRAMEBUFFER_PROC* glpfBindFramebuffer;
GLAPI PFNGLDELETEFRAMEBUFFERS_PROC* glpfDeleteFramebuffers;
GLAPI PFNGLGENFRAMEBUFFERS_PROC* glpfGenFramebuffers;
GLAPI PFNGLCHECKFRAMEBUFFERSTATUS_PROC* glpfCheckFramebufferStatus;
GLAPI PFNGLFRAMEBUFFERTEXTURE1D_PROC* glpfFramebufferTexture1D;
GLAPI PFNGLFRAMEBUFFERTEXTURE2D_PROC* glpfFramebufferTexture2D;
GLAPI PFNGLFRAMEBUFFERTEXTURE3D_PROC* glpfFramebufferTexture3D;
GLAPI PFNGLFRAMEBUFFERRENDERBUFFER_PROC* glpfFramebufferRenderbuffer;
GLAPI PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIV_PROC* glpfGetFramebufferAttachmentParameteriv;
GLAPI PFNGLGENERATEMIPMAP_PROC* glpfGenerateMipmap;
GLAPI PFNGLBLITFRAMEBUFFER_PROC* glpfBlitFramebuffer;
GLAPI PFNGLRENDERBUFFERSTORAGEMULTISAMPLE_PROC* glpfRenderbufferStorageMultisample;
GLAPI PFNGLFRAMEBUFFERTEXTURELAYER_PROC* glpfFramebufferTextureLayer;
GLAPI PFNGLMAPBUFFERRANGE_PROC* glpfMapBufferRange;
GLAPI PFNGLFLUSHMAPPEDBUFFERRANGE_PROC* glpfFlushMappedBufferRange;
GLAPI PFNGLBINDVERTEXARRAY_PROC* glpfBindVertexArray;
GLAPI PFNGLDELETEVERTEXARRAYS_PROC* glpfDeleteVertexArrays;
GLAPI PFNGLGENVERTEXARRAYS_PROC* glpfGenVertexArrays;
GLAPI PFNGLISVERTEXARRAY_PROC* glpfIsVertexArray;

#define glColorMaski glpfColorMaski
#define glGetBooleani_v glpfGetBooleani_v
#define glGetIntegeri_v glpfGetIntegeri_v
#define glEnablei glpfEnablei
#define glDisablei glpfDisablei
#define glIsEnabledi glpfIsEnabledi
#define glBeginTransformFeedback glpfBeginTransformFeedback
#define glEndTransformFeedback glpfEndTransformFeedback
#define glBindBufferRange glpfBindBufferRange
#define glBindBufferBase glpfBindBufferBase
#define glTransformFeedbackVaryings glpfTransformFeedbackVaryings
#define glGetTransformFeedbackVarying glpfGetTransformFeedbackVarying
#define glClampColor glpfClampColor
#define glBeginConditionalRender glpfBeginConditionalRender
#define glEndConditionalRender glpfEndConditionalRender
#define glVertexAttribIPointer glpfVertexAttribIPointer
#define glGetVertexAttribIiv glpfGetVertexAttribIiv
#define glGetVertexAttribIuiv glpfGetVertexAttribIuiv
#define glVertexAttribI1i glpfVertexAttribI1i
#define glVertexAttribI2i glpfVertexAttribI2i
#define glVertexAttribI3i glpfVertexAttribI3i
#define glVertexAttribI4i glpfVertexAttribI4i
#define glVertexAttribI1ui glpfVertexAttribI1ui
#define glVertexAttribI2ui glpfVertexAttribI2ui
#define glVertexAttribI3ui glpfVertexAttribI3ui
#define glVertexAttribI4ui glpfVertexAttribI4ui
#define glVertexAttribI1iv glpfVertexAttribI1iv
#define glVertexAttribI2iv glpfVertexAttribI2iv
#define glVertexAttribI3iv glpfVertexAttribI3iv
#define glVertexAttribI4iv glpfVertexAttribI4iv
#define glVertexAttribI1uiv glpfVertexAttribI1uiv
#define glVertexAttribI2uiv glpfVertexAttribI2uiv
#define glVertexAttribI3uiv glpfVertexAttribI3uiv
#define glVertexAttribI4uiv glpfVertexAttribI4uiv
#define glVertexAttribI4bv glpfVertexAttribI4bv
#define glVertexAttribI4sv glpfVertexAttribI4sv
#define glVertexAttribI4ubv glpfVertexAttribI4ubv
#define glVertexAttribI4usv glpfVertexAttribI4usv
#define glGetUniformuiv glpfGetUniformuiv
#define glBindFragDataLocation glpfBindFragDataLocation
#define glGetFragDataLocation glpfGetFragDataLocation
#define glUniform1ui glpfUniform1ui
#define glUniform2ui glpfUniform2ui
#define glUniform3ui glpfUniform3ui
#define glUniform4ui glpfUniform4ui
#define glUniform1uiv glpfUniform1uiv
#define glUniform2uiv glpfUniform2uiv
#define glUniform3uiv glpfUniform3uiv
#define glUniform4uiv glpfUniform4uiv
#define glTexParameterIiv glpfTexParameterIiv
#define glTexParameterIuiv glpfTexParameterIuiv
#define glGetTexParameterIiv glpfGetTexParameterIiv
#define glGetTexParameterIuiv glpfGetTexParameterIuiv
#define glClearBufferiv glpfClearBufferiv
#define glClearBufferuiv glpfClearBufferuiv
#define glClearBufferfv glpfClearBufferfv
#define glClearBufferfi glpfClearBufferfi
#define glGetStringi glpfGetStringi
#define glIsRenderbuffer glpfIsRenderbuffer
#define glBindRenderbuffer glpfBindRenderbuffer
#define glDeleteRenderbuffers glpfDeleteRenderbuffers
#define glGenRenderbuffers glpfGenRenderbuffers
#define glRenderbufferStorage glpfRenderbufferStorage
#define glGetRenderbufferParameteriv glpfGetRenderbufferParameteriv
#define glIsFramebuffer glpfIsFramebuffer
#define glBindFramebuffer glpfBindFramebuffer
#define glDeleteFramebuffers glpfDeleteFramebuffers
#define glGenFramebuffers glpfGenFramebuffers
#define glCheckFramebufferStatus glpfCheckFramebufferStatus
#define glFramebufferTexture1D glpfFramebufferTexture1D
#define glFramebufferTexture2D glpfFramebufferTexture2D
#define glFramebufferTexture3D glpfFramebufferTexture3D
#define glFramebufferRenderbuffer glpfFramebufferRenderbuffer
#define glGetFramebufferAttachmentParameteriv glpfGetFramebufferAttachmentParameteriv
#define glGenerateMipmap glpfGenerateMipmap
#define glBlitFramebuffer glpfBlitFramebuffer
#define glRenderbufferStorageMultisample glpfRenderbufferStorageMultisample
#define glFramebufferTextureLayer glpfFramebufferTextureLayer
#define glMapBufferRange glpfMapBufferRange
#define glFlushMappedBufferRange glpfFlushMappedBufferRange
#define glBindVertexArray glpfBindVertexArray
#define glDeleteVertexArrays glpfDeleteVertexArrays
#define glGenVertexArrays glpfGenVertexArrays
#define glIsVertexArray glpfIsVertexArray


/* GL_VERSION_3_1 */

typedef void (APIENTRY PFNGLDRAWARRAYSINSTANCED_PROC (GLenum mode, GLint first, GLsizei count, GLsizei instancecount));
typedef void (APIENTRY PFNGLDRAWELEMENTSINSTANCED_PROC (GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount));
typedef void (APIENTRY PFNGLTEXBUFFER_PROC (GLenum target, GLenum internalformat, GLuint buffer));
typedef void (APIENTRY PFNGLPRIMITIVERESTARTINDEX_PROC (GLuint index));
typedef void (APIENTRY PFNGLCOPYBUFFERSUBDATA_PROC (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size));
typedef void (APIENTRY PFNGLGETUNIFORMINDICES_PROC (GLuint program, GLsizei uniformCount, const GLchar *const* uniformNames, GLuint * uniformIndices));
typedef void (APIENTRY PFNGLGETACTIVEUNIFORMSIV_PROC (GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETACTIVEUNIFORMNAME_PROC (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformName));
typedef GLuint (APIENTRY PFNGLGETUNIFORMBLOCKINDEX_PROC (GLuint program, const GLchar * uniformBlockName));
typedef void (APIENTRY PFNGLGETACTIVEUNIFORMBLOCKIV_PROC (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETACTIVEUNIFORMBLOCKNAME_PROC (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName));
typedef void (APIENTRY PFNGLUNIFORMBLOCKBINDING_PROC (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding));

GLAPI PFNGLDRAWARRAYSINSTANCED_PROC* glpfDrawArraysInstanced;
GLAPI PFNGLDRAWELEMENTSINSTANCED_PROC* glpfDrawElementsInstanced;
GLAPI PFNGLTEXBUFFER_PROC* glpfTexBuffer;
GLAPI PFNGLPRIMITIVERESTARTINDEX_PROC* glpfPrimitiveRestartIndex;
GLAPI PFNGLCOPYBUFFERSUBDATA_PROC* glpfCopyBufferSubData;
GLAPI PFNGLGETUNIFORMINDICES_PROC* glpfGetUniformIndices;
GLAPI PFNGLGETACTIVEUNIFORMSIV_PROC* glpfGetActiveUniformsiv;
GLAPI PFNGLGETACTIVEUNIFORMNAME_PROC* glpfGetActiveUniformName;
GLAPI PFNGLGETUNIFORMBLOCKINDEX_PROC* glpfGetUniformBlockIndex;
GLAPI PFNGLGETACTIVEUNIFORMBLOCKIV_PROC* glpfGetActiveUniformBlockiv;
GLAPI PFNGLGETACTIVEUNIFORMBLOCKNAME_PROC* glpfGetActiveUniformBlockName;
GLAPI PFNGLUNIFORMBLOCKBINDING_PROC* glpfUniformBlockBinding;

#define glDrawArraysInstanced glpfDrawArraysInstanced
#define glDrawElementsInstanced glpfDrawElementsInstanced
#define glTexBuffer glpfTexBuffer
#define glPrimitiveRestartIndex glpfPrimitiveRestartIndex
#define glCopyBufferSubData glpfCopyBufferSubData
#define glGetUniformIndices glpfGetUniformIndices
#define glGetActiveUniformsiv glpfGetActiveUniformsiv
#define glGetActiveUniformName glpfGetActiveUniformName
#define glGetUniformBlockIndex glpfGetUniformBlockIndex
#define glGetActiveUniformBlockiv glpfGetActiveUniformBlockiv
#define glGetActiveUniformBlockName glpfGetActiveUniformBlockName
#define glUniformBlockBinding glpfUniformBlockBinding


/* GL_VERSION_3_2 */

typedef void (APIENTRY PFNGLDRAWELEMENTSBASEVERTEX_PROC (GLenum mode, GLsizei count, GLenum type, const void * indices, GLint basevertex));
typedef void (APIENTRY PFNGLDRAWRANGEELEMENTSBASEVERTEX_PROC (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices, GLint basevertex));
typedef void (APIENTRY PFNGLDRAWELEMENTSINSTANCEDBASEVERTEX_PROC (GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount, GLint basevertex));
typedef void (APIENTRY PFNGLMULTIDRAWELEMENTSBASEVERTEX_PROC (GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei drawcount, const GLint * basevertex));
typedef void (APIENTRY PFNGLPROVOKINGVERTEX_PROC (GLenum mode));
typedef GLsync (APIENTRY PFNGLFENCESYNC_PROC (GLenum condition, GLbitfield flags));
typedef GLboolean (APIENTRY PFNGLISSYNC_PROC (GLsync sync));
typedef void (APIENTRY PFNGLDELETESYNC_PROC (GLsync sync));
typedef GLenum (APIENTRY PFNGLCLIENTWAITSYNC_PROC (GLsync sync, GLbitfield flags, GLuint64 timeout));
typedef void (APIENTRY PFNGLWAITSYNC_PROC (GLsync sync, GLbitfield flags, GLuint64 timeout));
typedef void (APIENTRY PFNGLGETINTEGER64V_PROC (GLenum pname, GLint64 * data));
typedef void (APIENTRY PFNGLGETSYNCIV_PROC (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values));
typedef void (APIENTRY PFNGLGETINTEGER64I_V_PROC (GLenum target, GLuint index, GLint64 * data));
typedef void (APIENTRY PFNGLGETBUFFERPARAMETERI64V_PROC (GLenum target, GLenum pname, GLint64 * params));
typedef void (APIENTRY PFNGLFRAMEBUFFERTEXTURE_PROC (GLenum target, GLenum attachment, GLuint texture, GLint level));
typedef void (APIENTRY PFNGLTEXIMAGE2DMULTISAMPLE_PROC (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations));
typedef void (APIENTRY PFNGLTEXIMAGE3DMULTISAMPLE_PROC (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations));
typedef void (APIENTRY PFNGLGETMULTISAMPLEFV_PROC (GLenum pname, GLuint index, GLfloat * val));
typedef void (APIENTRY PFNGLSAMPLEMASKI_PROC (GLuint maskNumber, GLbitfield mask));

GLAPI PFNGLDRAWELEMENTSBASEVERTEX_PROC* glpfDrawElementsBaseVertex;
GLAPI PFNGLDRAWRANGEELEMENTSBASEVERTEX_PROC* glpfDrawRangeElementsBaseVertex;
GLAPI PFNGLDRAWELEMENTSINSTANCEDBASEVERTEX_PROC* glpfDrawElementsInstancedBaseVertex;
GLAPI PFNGLMULTIDRAWELEMENTSBASEVERTEX_PROC* glpfMultiDrawElementsBaseVertex;
GLAPI PFNGLPROVOKINGVERTEX_PROC* glpfProvokingVertex;
GLAPI PFNGLFENCESYNC_PROC* glpfFenceSync;
GLAPI PFNGLISSYNC_PROC* glpfIsSync;
GLAPI PFNGLDELETESYNC_PROC* glpfDeleteSync;
GLAPI PFNGLCLIENTWAITSYNC_PROC* glpfClientWaitSync;
GLAPI PFNGLWAITSYNC_PROC* glpfWaitSync;
GLAPI PFNGLGETINTEGER64V_PROC* glpfGetInteger64v;
GLAPI PFNGLGETSYNCIV_PROC* glpfGetSynciv;
GLAPI PFNGLGETINTEGER64I_V_PROC* glpfGetInteger64i_v;
GLAPI PFNGLGETBUFFERPARAMETERI64V_PROC* glpfGetBufferParameteri64v;
GLAPI PFNGLFRAMEBUFFERTEXTURE_PROC* glpfFramebufferTexture;
GLAPI PFNGLTEXIMAGE2DMULTISAMPLE_PROC* glpfTexImage2DMultisample;
GLAPI PFNGLTEXIMAGE3DMULTISAMPLE_PROC* glpfTexImage3DMultisample;
GLAPI PFNGLGETMULTISAMPLEFV_PROC* glpfGetMultisamplefv;
GLAPI PFNGLSAMPLEMASKI_PROC* glpfSampleMaski;

#define glDrawElementsBaseVertex glpfDrawElementsBaseVertex
#define glDrawRangeElementsBaseVertex glpfDrawRangeElementsBaseVertex
#define glDrawElementsInstancedBaseVertex glpfDrawElementsInstancedBaseVertex
#define glMultiDrawElementsBaseVertex glpfMultiDrawElementsBaseVertex
#define glProvokingVertex glpfProvokingVertex
#define glFenceSync glpfFenceSync
#define glIsSync glpfIsSync
#define glDeleteSync glpfDeleteSync
#define glClientWaitSync glpfClientWaitSync
#define glWaitSync glpfWaitSync
#define glGetInteger64v glpfGetInteger64v
#define glGetSynciv glpfGetSynciv
#define glGetInteger64i_v glpfGetInteger64i_v
#define glGetBufferParameteri64v glpfGetBufferParameteri64v
#define glFramebufferTexture glpfFramebufferTexture
#define glTexImage2DMultisample glpfTexImage2DMultisample
#define glTexImage3DMultisample glpfTexImage3DMultisample
#define glGetMultisamplefv glpfGetMultisamplefv
#define glSampleMaski glpfSampleMaski


/* GL_VERSION_3_3 */

typedef void (APIENTRY PFNGLBINDFRAGDATALOCATIONINDEXED_PROC (GLuint program, GLuint colorNumber, GLuint index, const GLchar * name));
typedef GLint (APIENTRY PFNGLGETFRAGDATAINDEX_PROC (GLuint program, const GLchar * name));
typedef void (APIENTRY PFNGLGENSAMPLERS_PROC (GLsizei count, GLuint * samplers));
typedef void (APIENTRY PFNGLDELETESAMPLERS_PROC (GLsizei count, const GLuint * samplers));
typedef GLboolean (APIENTRY PFNGLISSAMPLER_PROC (GLuint sampler));
typedef void (APIENTRY PFNGLBINDSAMPLER_PROC (GLuint unit, GLuint sampler));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERI_PROC (GLuint sampler, GLenum pname, GLint param));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERIV_PROC (GLuint sampler, GLenum pname, const GLint * param));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERF_PROC (GLuint sampler, GLenum pname, GLfloat param));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERFV_PROC (GLuint sampler, GLenum pname, const GLfloat * param));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERIIV_PROC (GLuint sampler, GLenum pname, const GLint * param));
typedef void (APIENTRY PFNGLSAMPLERPARAMETERIUIV_PROC (GLuint sampler, GLenum pname, const GLuint * param));
typedef void (APIENTRY PFNGLGETSAMPLERPARAMETERIV_PROC (GLuint sampler, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETSAMPLERPARAMETERIIV_PROC (GLuint sampler, GLenum pname, GLint * params));
typedef void (APIENTRY PFNGLGETSAMPLERPARAMETERFV_PROC (GLuint sampler, GLenum pname, GLfloat * params));
typedef void (APIENTRY PFNGLGETSAMPLERPARAMETERIUIV_PROC (GLuint sampler, GLenum pname, GLuint * params));
typedef void (APIENTRY PFNGLQUERYCOUNTER_PROC (GLuint id, GLenum target));
typedef void (APIENTRY PFNGLGETQUERYOBJECTI64V_PROC (GLuint id, GLenum pname, GLint64 * params));
typedef void (APIENTRY PFNGLGETQUERYOBJECTUI64V_PROC (GLuint id, GLenum pname, GLuint64 * params));
typedef void (APIENTRY PFNGLVERTEXATTRIBDIVISOR_PROC (GLuint index, GLuint divisor));
typedef void (APIENTRY PFNGLVERTEXATTRIBP1UI_PROC (GLuint index, GLenum type, GLboolean normalized, GLuint value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP1UIV_PROC (GLuint index, GLenum type, GLboolean normalized, const GLuint * value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP2UI_PROC (GLuint index, GLenum type, GLboolean normalized, GLuint value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP2UIV_PROC (GLuint index, GLenum type, GLboolean normalized, const GLuint * value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP3UI_PROC (GLuint index, GLenum type, GLboolean normalized, GLuint value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP3UIV_PROC (GLuint index, GLenum type, GLboolean normalized, const GLuint * value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP4UI_PROC (GLuint index, GLenum type, GLboolean normalized, GLuint value));
typedef void (APIENTRY PFNGLVERTEXATTRIBP4UIV_PROC (GLuint index, GLenum type, GLboolean normalized, const GLuint * value));

GLAPI PFNGLBINDFRAGDATALOCATIONINDEXED_PROC* glpfBindFragDataLocationIndexed;
GLAPI PFNGLGETFRAGDATAINDEX_PROC* glpfGetFragDataIndex;
GLAPI PFNGLGENSAMPLERS_PROC* glpfGenSamplers;
GLAPI PFNGLDELETESAMPLERS_PROC* glpfDeleteSamplers;
GLAPI PFNGLISSAMPLER_PROC* glpfIsSampler;
GLAPI PFNGLBINDSAMPLER_PROC* glpfBindSampler;
GLAPI PFNGLSAMPLERPARAMETERI_PROC* glpfSamplerParameteri;
GLAPI PFNGLSAMPLERPARAMETERIV_PROC* glpfSamplerParameteriv;
GLAPI PFNGLSAMPLERPARAMETERF_PROC* glpfSamplerParameterf;
GLAPI PFNGLSAMPLERPARAMETERFV_PROC* glpfSamplerParameterfv;
GLAPI PFNGLSAMPLERPARAMETERIIV_PROC* glpfSamplerParameterIiv;
GLAPI PFNGLSAMPLERPARAMETERIUIV_PROC* glpfSamplerParameterIuiv;
GLAPI PFNGLGETSAMPLERPARAMETERIV_PROC* glpfGetSamplerParameteriv;
GLAPI PFNGLGETSAMPLERPARAMETERIIV_PROC* glpfGetSamplerParameterIiv;
GLAPI PFNGLGETSAMPLERPARAMETERFV_PROC* glpfGetSamplerParameterfv;
GLAPI PFNGLGETSAMPLERPARAMETERIUIV_PROC* glpfGetSamplerParameterIuiv;
GLAPI PFNGLQUERYCOUNTER_PROC* glpfQueryCounter;
GLAPI PFNGLGETQUERYOBJECTI64V_PROC* glpfGetQueryObjecti64v;
GLAPI PFNGLGETQUERYOBJECTUI64V_PROC* glpfGetQueryObjectui64v;
GLAPI PFNGLVERTEXATTRIBDIVISOR_PROC* glpfVertexAttribDivisor;
GLAPI PFNGLVERTEXATTRIBP1UI_PROC* glpfVertexAttribP1ui;
GLAPI PFNGLVERTEXATTRIBP1UIV_PROC* glpfVertexAttribP1uiv;
GLAPI PFNGLVERTEXATTRIBP2UI_PROC* glpfVertexAttribP2ui;
GLAPI PFNGLVERTEXATTRIBP2UIV_PROC* glpfVertexAttribP2uiv;
GLAPI PFNGLVERTEXATTRIBP3UI_PROC* glpfVertexAttribP3ui;
GLAPI PFNGLVERTEXATTRIBP3UIV_PROC* glpfVertexAttribP3uiv;
GLAPI PFNGLVERTEXATTRIBP4UI_PROC* glpfVertexAttribP4ui;
GLAPI PFNGLVERTEXATTRIBP4UIV_PROC* glpfVertexAttribP4uiv;

#define glBindFragDataLocationIndexed glpfBindFragDataLocationIndexed
#define glGetFragDataIndex glpfGetFragDataIndex
#define glGenSamplers glpfGenSamplers
#define glDeleteSamplers glpfDeleteSamplers
#define glIsSampler glpfIsSampler
#define glBindSampler glpfBindSampler
#define glSamplerParameteri glpfSamplerParameteri
#define glSamplerParameteriv glpfSamplerParameteriv
#define glSamplerParameterf glpfSamplerParameterf
#define glSamplerParameterfv glpfSamplerParameterfv
#define glSamplerParameterIiv glpfSamplerParameterIiv
#define glSamplerParameterIuiv glpfSamplerParameterIuiv
#define glGetSamplerParameteriv glpfGetSamplerParameteriv
#define glGetSamplerParameterIiv glpfGetSamplerParameterIiv
#define glGetSamplerParameterfv glpfGetSamplerParameterfv
#define glGetSamplerParameterIuiv glpfGetSamplerParameterIuiv
#define glQueryCounter glpfQueryCounter
#define glGetQueryObjecti64v glpfGetQueryObjecti64v
#define glGetQueryObjectui64v glpfGetQueryObjectui64v
#define glVertexAttribDivisor glpfVertexAttribDivisor
#define glVertexAttribP1ui glpfVertexAttribP1ui
#define glVertexAttribP1uiv glpfVertexAttribP1uiv
#define glVertexAttribP2ui glpfVertexAttribP2ui
#define glVertexAttribP2uiv glpfVertexAttribP2uiv
#define glVertexAttribP3ui glpfVertexAttribP3ui
#define glVertexAttribP3uiv glpfVertexAttribP3uiv
#define glVertexAttribP4ui glpfVertexAttribP4ui
#define glVertexAttribP4uiv glpfVertexAttribP4uiv


/* GL_ARB_debug_output */

typedef void (APIENTRY PFNGLDEBUGMESSAGECONTROLARB_PROC (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled));
typedef void (APIENTRY PFNGLDEBUGMESSAGEINSERTARB_PROC (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf));
typedef void (APIENTRY PFNGLDEBUGMESSAGECALLBACKARB_PROC (GLDEBUGPROCARB callback, const void * userParam));
typedef GLuint (APIENTRY PFNGLGETDEBUGMESSAGELOGARB_PROC (GLuint count, GLsizei bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog));

GLAPI PFNGLDEBUGMESSAGECONTROLARB_PROC* glpfDebugMessageControlARB;
GLAPI PFNGLDEBUGMESSAGEINSERTARB_PROC* glpfDebugMessageInsertARB;
GLAPI PFNGLDEBUGMESSAGECALLBACKARB_PROC* glpfDebugMessageCallbackARB;
GLAPI PFNGLGETDEBUGMESSAGELOGARB_PROC* glpfGetDebugMessageLogARB;

#define glDebugMessageControlARB glpfDebugMessageControlARB
#define glDebugMessageInsertARB glpfDebugMessageInsertARB
#define glDebugMessageCallbackARB glpfDebugMessageCallbackARB
#define glGetDebugMessageLogARB glpfGetDebugMessageLogARB


/* --------------------------- CATEGORY DEFINES ------------------------------ */

#define GL_VERSION_1_0
#define GL_VERSION_1_1
#define GL_VERSION_1_2
#define GL_VERSION_1_3
#define GL_VERSION_1_4
#define GL_VERSION_1_5
#define GL_VERSION_2_0
#define GL_VERSION_2_1
#define GL_VERSION_3_0
#define GL_VERSION_3_1
#define GL_VERSION_3_2
#define GL_VERSION_3_3
#define GL_ARB_debug_output

void ExtGLLoadFunctions();

#ifdef __cplusplus
}
#endif
