/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

c
c $Id: ARRAYLIM_3D.F,v 1.1 2000/04/21 16:20:21 sstanley Exp $
c

#undef  BL_LANG_CC
#ifndef BL_LANG_FORT
#define BL_LANG_FORT
#endif

#include <ArrayLim.H>

#define SDIM 3

c ::: -----------------------------------------------------------
c ::: This routine sets the values for the lo() and hi() arrays
c ::: from the ARG_L1, ARG_H1, ... macros.  This is done since
c ::: it is more convenient to use the lo() and hi() arrays.
c :::
c ::: INPUTS/OUTPUTS:
c :::
c ::: DIMS(holder)=> index extent of place holder array
c ::: lo(SDIM)    <= lower index limits
c ::: hi(SDIM)    <= upper index limits
c ::: -----------------------------------------------------------

      subroutine SET_LOHI(DIMS(holder), lo, hi)

      implicit none

c
c     :::: Passed Variables ::::
c
      integer DIMDEC(holder)
      integer lo(SDIM), hi(SDIM)


c
c     --------------------------------------
c     :::: Set Values for lo() and hi() ::::
c     --------------------------------------
c
      lo(1) = ARG_L1(holder)
      hi(1) = ARG_H1(holder)
      lo(2) = ARG_L2(holder)
      hi(2) = ARG_H2(holder)
      lo(3) = ARG_L3(holder)
      hi(3) = ARG_H3(holder)

      return
      end


c ::: -----------------------------------------------------------
c ::: This routine sets the values for the ARG_L1, ARG_H1, ... macros
c ::: from the lo() and hi() arrays.  This is done since
c ::: it is more convenient to use the macros to dimension arrays.
c :::
c ::: INPUTS/OUTPUTS:
c :::
c ::: FF_DIMS(holder) <=  index extent of place holder array
c ::: lo(SDIM)         => lower index limits
c ::: hi(SDIM)         => upper index limits
c ::: -----------------------------------------------------------

      subroutine SET_ARGS(DIMS(holder), lo, hi)

      implicit none

c
c     :::: Passed Variables ::::
c
      integer DIMDEC(holder)
      integer lo(SDIM), hi(SDIM)

c
c     --------------------------------------
c     :::: Set Values for lo() and hi() ::::
c     --------------------------------------
c
      ARG_L1(holder) = lo(1)
      ARG_H1(holder) = hi(1)
      ARG_L2(holder) = lo(2)
      ARG_H2(holder) = hi(2)
      ARG_L3(holder) = lo(3)
      ARG_H3(holder) = hi(3)

c
c
      return
      end

