/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** SETVELBC **
c ** Impose the physical boundary conditions on the velocity (u,v)
c *************************************************************************

      subroutine setvelbc(u,v,DIMS,bcx_lo,bcx_hi,bcy_lo,bcy_hi,irz,
     $                    visc_coef,dx,time)

      implicit none

      integer DIMS
      REAL_T     u(lo_1-1:hi_1+1,lo_2-1:hi_2+1)
      REAL_T     v(lo_1-1:hi_1+1,lo_2-1:hi_2+1)
      integer bcx_lo,bcx_hi
      integer bcy_lo,bcy_hi
      integer irz
      REAL_T visc_coef
      REAL_T dx(2)
      REAL_T time

c     Local variables
      integer is,ie,js,je,i,j

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2

      if (bcy_lo .eq. PERIODIC) then

        do i = is,ie 
          u(i,js-1) = u(i,je)
          v(i,js-1) = v(i,je)
        enddo

      elseif (bcy_lo .eq. WALL) then


c ::: REMEMBER -  THESE VALUES NOW LIVE ON CELL EDGES

        do i = is,ie 
          v(i,js-1) = zero
          u(i,js-1) = (fifteen*u(i,js  ) - ten*u(i,js+1) + 
     $                   three*u(i,js+2)) / eight
        enddo

        if (visc_coef .gt. zero) then
          do i = is,ie 
            u(i,js-1) = zero
          enddo
        endif

      elseif (bcy_lo .eq. INLET) then

        call velinflow(v,DIMS,time,dx(1),1,0)

        do i = is-1,ie+1 
          u(i,js-1) = zero
        enddo

      elseif (bcy_lo .eq. OUTLET) then

        do i = is-1,ie+1 
          u(i,js-1) = u(i,js)
          v(i,js-1) = v(i,js)
        enddo

      endif

      if (bcy_hi .eq. PERIODIC) then

        do i = is,ie 
          u(i,je+1) = u(i,js)
          v(i,je+1) = v(i,js)
        enddo

      elseif (bcy_hi .eq. WALL) then

c ::: REMEMBER -  THESE VALUES NOW LIVE ON CELL EDGES

        do i = is,ie 
          v(i,je+1) = zero
          u(i,je+1) = (fifteen*u(i,je  ) - ten*u(i,je-1) + 
     $                   three*u(i,je-2)) / eight
        enddo

        if (visc_coef .gt. zero) then
          do i = is,ie 
            u(i,je+1) = zero
          enddo
        endif

      elseif (bcy_hi .eq. INLET) then

        call velinflow(v,DIMS,time,dx(1),1,1)

        do i = is-1,ie+1 
          u(i,je+1) = zero
        enddo

      elseif (bcy_hi .eq. OUTLET) then

        do i = is-1,ie+1 
          u(i,je+1) = u(i,je)
          v(i,je+1) = v(i,je)
        enddo

      endif

      if (bcx_lo .eq. PERIODIC) then

        do j = js-1,je+1 
          u(is-1,j) =    u(ie,j)
          v(is-1,j) =    v(ie,j)
        enddo

      elseif (bcx_lo .eq. WALL) then

c ::: REMEMBER -  THESE VALUES NOW LIVE ON CELL EDGES

        do j = js-1,je+1 
          u(is-1,j) = zero
          v(is-1,j) = (fifteen*v(is  ,j) - ten*v(is+1,j) + 
     $                   three*v(is+2,j)) / eight
        enddo

        if (irz .eq. 0 .and. visc_coef .gt. zero) then
          do j = js-1,je+1 
            v(is-1,j) = zero
          enddo
        endif

        if (irz .eq. 1) then
          do j = js-1,je+1 
             v(is-1,j) =    v(is,j)
          enddo
        endif

      elseif (bcx_lo .eq. INLET) then

        call velinflow(u,DIMS,time,dx(2),0,0)

        do j = js-1,je+1 
          v(is-1,j) = zero
        enddo

      elseif (bcx_lo .eq. OUTLET) then

        do j = js-1,je+1 
          u(is-1,j) = u(is,j)
          v(is-1,j) = v(is,j)
        enddo

      endif

      if (bcx_hi .eq. PERIODIC) then

        do j = js-1,je+1 
          u(ie+1,j) =    u(is,j)
          v(ie+1,j) =    v(is,j)
        enddo

      elseif (bcx_hi .eq. WALL) then

c ::: REMEMBER -  THESE VALUES NOW LIVE ON CELL EDGES

        do j = js-1,je+1 
          u(ie+1,j) = zero
          v(ie+1,j) = (fifteen*v(ie  ,j) - ten*v(ie-1,j) + 
     $                   three*v(ie-2,j)) / eight
       enddo

        if (visc_coef .gt. zero) then
          do j = js-1,je+1 
            v(ie+1,j) = zero
          enddo
        endif

      elseif (bcx_hi .eq. INLET) then

        call velinflow(u,DIMS,time,dx(2),0,1)

        do j = js-1,je+1 
          v(ie+1,j) = zero
        enddo

      elseif (bcx_hi .eq. OUTLET) then

        do j = js-1,je+1 
          u(ie+1,j) = u(ie,j)
          v(ie+1,j) = v(ie,j)
        enddo

      endif

      return
      end
