/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_INITSIGMA    initsigma
#  define FORT_COARSIGMA    coarsigma
#  define FORT_RHSMAC       rhsmac
#  define FORT_GRADMAC      gradmac
#  define FORT_RESIDUAL     resmac
#  define FORT_GSRB         gsrbmac
#  define FORT_RESTRICT     coarsres
#  define FORT_INTERPOLATE  interp
#  define FORT_PROJUMAC     projumac
#  define FORT_SOLVEMAC     solvemac
#  define FORT_MKSUMMAC     mksummac
#else
#if defined (BL_FORT_USE_UNDERSCORE)
#  define FORT_INITSIGMA    initsigma_
#  define FORT_COARSIGMA    coarsigma_
#  define FORT_RHSMAC       rhsmac_
#  define FORT_GRADMAC      gradmac_
#  define FORT_RESIDUAL     resmac_
#  define FORT_GSRB         gsrbmac_
#  define FORT_RESTRICT     coarsres_
#  define FORT_INTERPOLATE  interp_
#  define FORT_PROJUMAC     projumac_
#  define FORT_SOLVEMAC     solvemac_
#  define FORT_MKSUMMAC     mksummac_
#elif defined (BL_FORT_USE_UPPERCASE)
#  define FORT_INITSIGMA    INITSIGMA
#  define FORT_COARSIGMA    COARSIGMA
#  define FORT_RHSMAC       RHSMAC
#  define FORT_RESIDUAL     RESMAC
#  define FORT_GSRB         GSRBMAC
#  define FORT_GRADMAC      GRADMAC
#  define FORT_RESTRICT     COARSRES
#  define FORT_INTERPOLATE  INTERP
#  define FORT_PROJUMAC     PROJUMAC
#  define FORT_SOLVEMAC     SOLVEMAC
#  define FORT_MKSUMMAC     MKSUMMAC
#elif defined (BL_FORT_USE_LOWERCASE)
#  define FORT_INITSIGMA    initsigma
#  define FORT_COARSIGMA    coarsigma
#  define FORT_RHSMAC       rhsmac
#  define FORT_RESIDUAL     resmac
#  define FORT_GSRB         gsrbmac
#  define FORT_GRADMAC      gradmac
#  define FORT_RESTRICT     coarsres
#  define FORT_INTERPOLATE  interp
#  define FORT_PROJUMAC     projumac
#  define FORT_SOLVEMAC     solvemac
#  define FORT_MKSUMMAC     mksummac
#endif

extern "C" {
  void FORT_INITSIGMA(Real * sigmax, Real * sigmay, Real * sigmaz, Real * rho, 
                      const int& lo_1, const int& lo_2, const int& lo_3,
                      const int& hi_1, const int& hi_2, const int& hi_3,
                      int * bcx_lo, int * bcx_hi, 
                      int * bcy_lo, int * bcy_hi, 
                      int * bcz_lo, int * bcz_hi); 

  void FORT_RHSMAC(Real * uhalfx, Real * uhalfy, Real * uhalfz, 
                   Real * divu_src, Real * rhs, 
                   const int& lo_1, const int& lo_2, const int& lo_3,
                   const int& hi_1, const int& hi_2, const int& hi_3,
                   Real * _hx, Real * _hy, Real * _hz, Real * rhsnorm);

  void FORT_GRADMAC(Real * gradpx, Real * gradpy, Real * gradpz,
		    Real * phi, 
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3,
                    Real * _hx, Real * _hy, Real * _hz, 
                    int * bcx_lo, int * bcx_hi, 
                    int * bcy_lo, int * bcy_hi, 
                    int * bcz_lo, int * bcz_hi); 

  void FORT_RESIDUAL(Real * resid, Real * phi, Real * f, 
                     Real * sigmax, Real * sigmay, Real * sigmaz,
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
                     Real * _hx, Real * _hy, Real * _hz, Real * rnorm, 
                     int * bcx_lo, int * bcx_hi, 
                     int * bcy_lo, int * bcy_hi, 
                     int * bcz_lo, int * bcz_hi); 

  void FORT_COARSIGMA(Real * sigmax , Real * sigmay,  Real * sigmaz, 
                      Real * sigmaxc, Real * sigmayc, Real * sigmazc,
                      const int& lo_1, const int& lo_2, const int& lo_3,
                      const int& hi_1, const int& hi_2, const int& hi_3,
                      const int& loc_1, const int& loc_2, const int& loc_3,
                      const int& hic_1, const int& hic_2, const int& hic_3);

  void FORT_GSRB(Real * phi, Real * f, 
                 Real * sigmax, Real * sigmay, Real * sigmaz,
                 const int& lo_1, const int& lo_2, const int& lo_3,
                 const int& hi_1, const int& hi_2, const int& hi_3,
	         Real * _hx, Real * _hy, Real * _hz,
                 int * bcx_lo, int * bcx_hi, 
                 int * bcy_lo, int * bcy_hi, 
                 int * bcz_lo, int * bcz_hi, int * nngsrb); 

  void FORT_RESTRICT(Real * res, Real * resc, 
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
                     const int& loc_1, const int& loc_2, const int& loc_3,
                     const int& hic_1, const int& hic_2, const int& hic_3);

  void FORT_INTERPOLATE(Real * phi, Real * deltac, 
                        const int& lo_1, const int& lo_2, const int& lo_3,
                        const int& hi_1, const int& hi_2, const int& hi_3,
                        const int& loc_1, const int& loc_2, const int& loc_3,
                        const int& hic_1, const int& hic_2, const int& hic_3);

  void FORT_PROJUMAC(Real * uhalfx, Real * uhalfy, Real * uhalfz,
                     Real * gradpx, Real * gradpy, Real * gradpz,
                     Real * rho,
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3);

  void FORT_SOLVEMAC(Real * dest, Real * dest0, Real *source, 
                     Real * sigmax,  Real * sigmay, Real * sigmaz,
 		     Real * sum, 
                     Real * r, Real * w, Real * z, Real * work, 
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
                     Real * _hx,  Real * _hy,  Real * _hz,
                     int * bcx_lo, int * bcx_hi, 
                     int * bcy_lo, int * bcy_hi, 
                     int * bcz_lo, int * bcz_hi, Real * rnorm,
                     Real * prob_norm); 

  void FORT_MKSUMMAC(Real * sigmax,  Real * sigmay, Real * sigmaz, Real * sum, 
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
                     Real * _hx,  Real * _hy, Real * _hz,
                     int * bcx_lo, int * bcx_hi, 
                     int * bcy_lo, int * bcy_hi, 
                     int * bcz_lo, int * bcz_hi);

};
#endif
