// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUIOpenGLRenderer.h"
#include "OpenGL3Renderer.pypp.hpp"

namespace bp = boost::python;

struct OpenGL3Renderer_wrapper : CEGUI::OpenGL3Renderer, bp::wrapper< CEGUI::OpenGL3Renderer > {

    virtual void beginRendering(  ) {
        if( bp::override func_beginRendering = this->get_override( "beginRendering" ) )
            func_beginRendering(  );
        else{
            this->CEGUI::OpenGL3Renderer::beginRendering(  );
        }
    }
    
    void default_beginRendering(  ) {
        CEGUI::OpenGL3Renderer::beginRendering( );
    }

    virtual void endRendering(  ) {
        if( bp::override func_endRendering = this->get_override( "endRendering" ) )
            func_endRendering(  );
        else{
            this->CEGUI::OpenGL3Renderer::endRendering(  );
        }
    }
    
    void default_endRendering(  ) {
        CEGUI::OpenGL3Renderer::endRendering( );
    }

    virtual ::CEGUI::Sizef getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        if( bp::override func_getAdjustedTextureSize = this->get_override( "getAdjustedTextureSize" ) )
            return func_getAdjustedTextureSize( boost::ref(sz) );
        else{
            return this->CEGUI::OpenGL3Renderer::getAdjustedTextureSize( boost::ref(sz) );
        }
    }
    
    ::CEGUI::Sizef default_getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        return CEGUI::OpenGL3Renderer::getAdjustedTextureSize( boost::ref(sz) );
    }

    virtual bool isS3TCSupported(  ) const  {
        if( bp::override func_isS3TCSupported = this->get_override( "isS3TCSupported" ) )
            return func_isS3TCSupported(  );
        else{
            return this->CEGUI::OpenGL3Renderer::isS3TCSupported(  );
        }
    }
    
    bool default_isS3TCSupported(  ) const  {
        return CEGUI::OpenGL3Renderer::isS3TCSupported( );
    }

    virtual void setupRenderingBlendMode( ::CEGUI::BlendMode const mode, bool const force=false ) {
        if( bp::override func_setupRenderingBlendMode = this->get_override( "setupRenderingBlendMode" ) )
            func_setupRenderingBlendMode( mode, force );
        else{
            this->CEGUI::OpenGL3Renderer::setupRenderingBlendMode( mode, force );
        }
    }
    
    void default_setupRenderingBlendMode( ::CEGUI::BlendMode const mode, bool const force=false ) {
        CEGUI::OpenGL3Renderer::setupRenderingBlendMode( mode, force );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget(  ) {
        if( bp::override func_createTextureTarget = this->get_override( "createTextureTarget" ) )
            return func_createTextureTarget(  );
        else{
            return this->CEGUI::OpenGLRendererBase::createTextureTarget(  );
        }
    }
    
    ::CEGUI::TextureTarget * default_createTextureTarget(  ) {
        return CEGUI::OpenGLRendererBase::createTextureTarget( );
    }

    virtual void destroyAllGeometryBuffers(  ) {
        if( bp::override func_destroyAllGeometryBuffers = this->get_override( "destroyAllGeometryBuffers" ) )
            func_destroyAllGeometryBuffers(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers(  );
        }
    }
    
    void default_destroyAllGeometryBuffers(  ) {
        CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers( );
    }

    virtual void destroyAllTextureTargets(  ) {
        if( bp::override func_destroyAllTextureTargets = this->get_override( "destroyAllTextureTargets" ) )
            func_destroyAllTextureTargets(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextureTargets(  );
        }
    }
    
    void default_destroyAllTextureTargets(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextureTargets( );
    }

    virtual void destroyAllTextures(  ) {
        if( bp::override func_destroyAllTextures = this->get_override( "destroyAllTextures" ) )
            func_destroyAllTextures(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextures(  );
        }
    }
    
    void default_destroyAllTextures(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextures( );
    }

    virtual void destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        if( bp::override func_destroyGeometryBuffer = this->get_override( "destroyGeometryBuffer" ) )
            func_destroyGeometryBuffer( boost::ref(buffer) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
        }
    }
    
    void default_destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
    }

    virtual void destroyTexture( ::CEGUI::Texture & texture ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(texture) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::Texture & texture ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
    }

    virtual void destroyTexture( ::CEGUI::String const & name ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(name) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::String const & name ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
    }

    virtual void destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        if( bp::override func_destroyTextureTarget = this->get_override( "destroyTextureTarget" ) )
            func_destroyTextureTarget( boost::python::ptr(target) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
        }
    }
    
    void default_destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
    }

    virtual ::CEGUI::uint getMaxTextureSize(  ) const  {
        if( bp::override func_getMaxTextureSize = this->get_override( "getMaxTextureSize" ) )
            return func_getMaxTextureSize(  );
        else{
            return this->CEGUI::OpenGLRendererBase::getMaxTextureSize(  );
        }
    }
    
    ::CEGUI::uint default_getMaxTextureSize(  ) const  {
        return CEGUI::OpenGLRendererBase::getMaxTextureSize( );
    }

    void initialiseDisplaySizeWithViewportSize(  ){
        CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize(  );
    }

    void initialiseMaxTextureSize(  ){
        CEGUI::OpenGLRendererBase::initialiseMaxTextureSize(  );
    }

    virtual bool isTextureDefined( ::CEGUI::String const & name ) const  {
        if( bp::override func_isTextureDefined = this->get_override( "isTextureDefined" ) )
            return func_isTextureDefined( boost::ref(name) );
        else{
            return this->CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
        }
    }
    
    bool default_isTextureDefined( ::CEGUI::String const & name ) const  {
        return CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
    }

    static void logTextureCreation( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureCreation( boost::ref(name) );
    }

    static void logTextureDestruction( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureDestruction( boost::ref(name) );
    }

    virtual void setDisplaySize( ::CEGUI::Sizef const & sz ) {
        if( bp::override func_setDisplaySize = this->get_override( "setDisplaySize" ) )
            func_setDisplaySize( boost::ref(sz) );
        else{
            this->CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
        }
    }
    
    void default_setDisplaySize( ::CEGUI::Sizef const & sz ) {
        CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
    }

};

void register_OpenGL3Renderer_class(){

    { //::CEGUI::OpenGL3Renderer
        typedef bp::class_< OpenGL3Renderer_wrapper, bp::bases< CEGUI::OpenGLRendererBase >, boost::noncopyable > OpenGL3Renderer_exposer_t;
        OpenGL3Renderer_exposer_t OpenGL3Renderer_exposer = OpenGL3Renderer_exposer_t( "OpenGL3Renderer", "*!\n\
        \n\
            Renderer class to interface with OpenGL\n\
        *\n", bp::no_init );
        bp::scope OpenGL3Renderer_scope( OpenGL3Renderer_exposer );
        { //::CEGUI::OpenGL3Renderer::beginRendering
        
            typedef void ( ::CEGUI::OpenGL3Renderer::*beginRendering_function_type )(  ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_beginRendering_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "beginRendering"
                , beginRendering_function_type(&::CEGUI::OpenGL3Renderer::beginRendering)
                , default_beginRendering_function_type(&OpenGL3Renderer_wrapper::default_beginRendering) );
        
        }
        { //::CEGUI::OpenGL3Renderer::bootstrapSystem
        
            typedef ::CEGUI::OpenGL3Renderer & ( *bootstrapSystem_function_type )( int const );
            
            OpenGL3Renderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OpenGL3Renderer::bootstrapSystem )
                , ( bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates the required objects to initialise the\n\
                    CEGUI system.\n\
            \n\
                    The created Renderer will use the current OpenGL viewport as it's\n\
                    default surface size.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OpenGL3Renderer\n\
                    - CEGUI.DefaultResourceProvider\n\
                    - CEGUI.System\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OpenGL3Renderer object that was created.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::bootstrapSystem
        
            typedef ::CEGUI::OpenGL3Renderer & ( *bootstrapSystem_function_type )( ::CEGUI::Sizef const &,int const );
            
            OpenGL3Renderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OpenGL3Renderer::bootstrapSystem )
                , ( bp::arg("display_size"), bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates the required objects to initialise the\n\
                    CEGUI system.\n\
            \n\
                    The created Renderer will use the current OpenGL viewport as it's\n\
                    default surface size.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OpenGL3Renderer\n\
                    - CEGUI.DefaultResourceProvider\n\
                    - CEGUI.System\n\
            \n\
                @param display_size\n\
                    Size object describing the initial display resolution.\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OpenGL3Renderer object that was created.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::create
        
            typedef ::CEGUI::OpenGL3Renderer & ( *create_function_type )( int const );
            
            OpenGL3Renderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OpenGL3Renderer::create )
                , ( bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create an OpenGL3Renderer object.\n\
            \n\
                @param tt_type\n\
                    Specifies one of the TextureTargetType enumerated values indicating the\n\
                    desired TextureTarget type to be used.\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::create
        
            typedef ::CEGUI::OpenGL3Renderer & ( *create_function_type )( ::CEGUI::Sizef const &,int const );
            
            OpenGL3Renderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OpenGL3Renderer::create )
                , ( bp::arg("display_size"), bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create an OpenGL3Renderer object.\n\
            \n\
                @param display_size\n\
                    Size object describing the initial display resolution.\n\
            \n\
                @param tt_type\n\
                    Specifies one of the TextureTargetType enumerated values indicating the\n\
                    desired TextureTarget type to be used.\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::destroy
        
            typedef void ( *destroy_function_type )( ::CEGUI::OpenGL3Renderer & );
            
            OpenGL3Renderer_exposer.def( 
                "destroy"
                , destroy_function_type( &::CEGUI::OpenGL3Renderer::destroy )
                , ( bp::arg("renderer") )
                , "*!\n\
                \n\
                    Destroy an OpenGL3Renderer object.\n\
            \n\
                @param renderer\n\
                    The OpenGL3Renderer object to be destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::destroySystem
        
            typedef void ( *destroySystem_function_type )(  );
            
            OpenGL3Renderer_exposer.def( 
                "destroySystem"
                , destroySystem_function_type( &::CEGUI::OpenGL3Renderer::destroySystem )
                , "*!\n\
                \n\
                    Convenience function to cleanup the CEGUI system and related objects\n\
                    that were created by calling the bootstrapSystem function.\n\
            \n\
                    This function will destroy the following objects for you:\n\
                    - CEGUI.System\n\
                    - CEGUI.DefaultResourceProvider\n\
                    - CEGUI.OpenGL3Renderer\n\
            \n\
                \note\n\
                    If you did not initialise CEGUI by calling the bootstrapSystem function,\n\
                    you should  e not call this, but rather delete any objects you created\n\
                    manually.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::endRendering
        
            typedef void ( ::CEGUI::OpenGL3Renderer::*endRendering_function_type )(  ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_endRendering_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "endRendering"
                , endRendering_function_type(&::CEGUI::OpenGL3Renderer::endRendering)
                , default_endRendering_function_type(&OpenGL3Renderer_wrapper::default_endRendering) );
        
        }
        { //::CEGUI::OpenGL3Renderer::getAdjustedTextureSize
        
            typedef ::CEGUI::Sizef ( ::CEGUI::OpenGL3Renderer::*getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            typedef ::CEGUI::Sizef ( OpenGL3Renderer_wrapper::*default_getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getAdjustedTextureSize"
                , getAdjustedTextureSize_function_type(&::CEGUI::OpenGL3Renderer::getAdjustedTextureSize)
                , default_getAdjustedTextureSize_function_type(&OpenGL3Renderer_wrapper::default_getAdjustedTextureSize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OpenGL3Renderer::getOpenGLStateChanger
        
            typedef ::CEGUI::OpenGL3StateChangeWrapper * ( ::CEGUI::OpenGL3Renderer::*getOpenGLStateChanger_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getOpenGLStateChanger"
                , getOpenGLStateChanger_function_type( &::CEGUI::OpenGL3Renderer::getOpenGLStateChanger )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Helper to get the wrapper used to check for redundant OpenGL state\n\
                    changes.\n\
            \n\
                @return\n\
                    The active OpenGL state change wrapper object.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::getShaderStandard
        
            typedef ::CEGUI::OpenGL3Shader * & ( ::CEGUI::OpenGL3Renderer::*getShaderStandard_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getShaderStandard"
                , getShaderStandard_function_type( &::CEGUI::OpenGL3Renderer::getShaderStandard )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Helper to return the reference to the pointer to the standard shader of\n\
                    the Renderer\n\
            \n\
                @return\n\
                    Reference to the pointer to the standard shader of the Renderer\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::getShaderStandardColourLoc
        
            typedef ::GLint ( ::CEGUI::OpenGL3Renderer::*getShaderStandardColourLoc_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getShaderStandardColourLoc"
                , getShaderStandardColourLoc_function_type( &::CEGUI::OpenGL3Renderer::getShaderStandardColourLoc )
                , "*!\n\
                \n\
                    Helper to return the attribute location of the colour variable in the\n\
                    standard shader\n\
            \n\
                @return\n\
                    Attribute location of the colour variable in the standard shader\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::getShaderStandardMatrixUniformLoc
        
            typedef ::GLint ( ::CEGUI::OpenGL3Renderer::*getShaderStandardMatrixUniformLoc_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getShaderStandardMatrixUniformLoc"
                , getShaderStandardMatrixUniformLoc_function_type( &::CEGUI::OpenGL3Renderer::getShaderStandardMatrixUniformLoc )
                , "*!\n\
                \n\
                    Helper to return the uniform location of the matrix variable in the\n\
                    standard shader\n\
            \n\
                @return\n\
                    Uniform location of the matrix variable in the standard shader\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::getShaderStandardPositionLoc
        
            typedef ::GLint ( ::CEGUI::OpenGL3Renderer::*getShaderStandardPositionLoc_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getShaderStandardPositionLoc"
                , getShaderStandardPositionLoc_function_type( &::CEGUI::OpenGL3Renderer::getShaderStandardPositionLoc )
                , "*!\n\
                \n\
                    Helper to return the attribute location of the position variable in the\n\
                    standard shader\n\
            \n\
                @return\n\
                    Attribute location of the position variable in the standard shader\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::getShaderStandardTexCoordLoc
        
            typedef ::GLint ( ::CEGUI::OpenGL3Renderer::*getShaderStandardTexCoordLoc_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getShaderStandardTexCoordLoc"
                , getShaderStandardTexCoordLoc_function_type( &::CEGUI::OpenGL3Renderer::getShaderStandardTexCoordLoc )
                , "*!\n\
                \n\
                    Helper to return the attribute location of the texture coordinate\n\
                    variable in the standard shader\n\
            \n\
                @return\n\
                    Attribute location of the texture coordinate variable in the standard\n\
                    shader\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGL3Renderer::isS3TCSupported
        
            typedef bool ( ::CEGUI::OpenGL3Renderer::*isS3TCSupported_function_type )(  ) const;
            typedef bool ( OpenGL3Renderer_wrapper::*default_isS3TCSupported_function_type )(  ) const;
            
            OpenGL3Renderer_exposer.def( 
                "isS3TCSupported"
                , isS3TCSupported_function_type(&::CEGUI::OpenGL3Renderer::isS3TCSupported)
                , default_isS3TCSupported_function_type(&OpenGL3Renderer_wrapper::default_isS3TCSupported) );
        
        }
        { //::CEGUI::OpenGL3Renderer::setupRenderingBlendMode
        
            typedef void ( ::CEGUI::OpenGL3Renderer::*setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            
            OpenGL3Renderer_exposer.def( 
                "setupRenderingBlendMode"
                , setupRenderingBlendMode_function_type(&::CEGUI::OpenGL3Renderer::setupRenderingBlendMode)
                , default_setupRenderingBlendMode_function_type(&OpenGL3Renderer_wrapper::default_setupRenderingBlendMode)
                , ( bp::arg("mode"), bp::arg("force")=(bool const)(false) ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::createGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::OpenGLRendererBase::*createGeometryBuffer_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createGeometryBuffer"
                , createGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::createGeometryBuffer)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::String const &,::CEGUI::String const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("filename"), bp::arg("resourceGroup") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::Sizef const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("size") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::GLuint,::CEGUI::Sizef const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createTexture"
                , createTexture_function_type( &::CEGUI::OpenGLRendererBase::createTexture )
                , ( bp::arg("name"), bp::arg("tex"), bp::arg("sz") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a texture that uses an existing OpenGL texture with the specified\n\
                    size.  Note that it is your responsibility to ensure that the OpenGL\n\
                    texture is valid and that the specified size is accurate.\n\
            \n\
                @param sz\n\
                    Size object that describes the pixel size of the OpenGL texture\n\
                    identified by  tex.\n\
            \n\
                @param name\n\
                    String holding the name for the new texture.  Texture names must be\n\
                    unique within the Renderer.\n\
            \n\
                @return\n\
                    Texture object that wraps the OpenGL texture  tex, and whose size is\n\
                    specified to be  sz.\n\
            \n\
                @exceptions\n\
                    - AlreadyExistsException - thrown if a Texture object named  name\n\
                      already exists within the system.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTextureTarget
        
            typedef ::CEGUI::TextureTarget * ( ::CEGUI::OpenGLRendererBase::*createTextureTarget_function_type )(  ) ;
            typedef ::CEGUI::TextureTarget * ( OpenGL3Renderer_wrapper::*default_createTextureTarget_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "createTextureTarget"
                , createTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::createTextureTarget)
                , default_createTextureTarget_function_type(&OpenGL3Renderer_wrapper::default_createTextureTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllGeometryBuffers_function_type )(  ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyAllGeometryBuffers_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyAllGeometryBuffers"
                , destroyAllGeometryBuffers_function_type(&::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers)
                , default_destroyAllGeometryBuffers_function_type(&OpenGL3Renderer_wrapper::default_destroyAllGeometryBuffers) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextureTargets
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextureTargets_function_type )(  ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyAllTextureTargets_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyAllTextureTargets"
                , destroyAllTextureTargets_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextureTargets)
                , default_destroyAllTextureTargets_function_type(&OpenGL3Renderer_wrapper::default_destroyAllTextureTargets) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextures
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextures_function_type )(  ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyAllTextures_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyAllTextures"
                , destroyAllTextures_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextures)
                , default_destroyAllTextures_function_type(&OpenGL3Renderer_wrapper::default_destroyAllTextures) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyGeometryBuffer
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyGeometryBuffer"
                , destroyGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::destroyGeometryBuffer)
                , default_destroyGeometryBuffer_function_type(&OpenGL3Renderer_wrapper::default_destroyGeometryBuffer)
                , ( bp::arg("buffer") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGL3Renderer_wrapper::default_destroyTexture)
                , ( bp::arg("texture") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::String const & ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGL3Renderer_wrapper::default_destroyTexture)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTextureTarget
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            
            OpenGL3Renderer_exposer.def( 
                "destroyTextureTarget"
                , destroyTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::destroyTextureTarget)
                , default_destroyTextureTarget_function_type(&OpenGL3Renderer_wrapper::default_destroyTextureTarget)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDefaultRenderTarget
        
            typedef ::CEGUI::RenderTarget & ( ::CEGUI::OpenGLRendererBase::*getDefaultRenderTarget_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "getDefaultRenderTarget"
                , getDefaultRenderTarget_function_type(&::CEGUI::OpenGLRendererBase::getDefaultRenderTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplayDPI
        
            typedef ::CEGUI::Vector2f const & ( ::CEGUI::OpenGLRendererBase::*getDisplayDPI_function_type )(  ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getDisplayDPI"
                , getDisplayDPI_function_type(&::CEGUI::OpenGLRendererBase::getDisplayDPI)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplaySize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::OpenGLRendererBase::*getDisplaySize_function_type )(  ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getDisplaySize"
                , getDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::getDisplaySize)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getIdentifierString
        
            typedef ::CEGUI::String const & ( ::CEGUI::OpenGLRendererBase::*getIdentifierString_function_type )(  ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getIdentifierString"
                , getIdentifierString_function_type(&::CEGUI::OpenGLRendererBase::getIdentifierString)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getMaxTextureSize
        
            typedef ::CEGUI::uint ( ::CEGUI::OpenGLRendererBase::*getMaxTextureSize_function_type )(  ) const;
            typedef ::CEGUI::uint ( OpenGL3Renderer_wrapper::*default_getMaxTextureSize_function_type )(  ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getMaxTextureSize"
                , getMaxTextureSize_function_type(&::CEGUI::OpenGLRendererBase::getMaxTextureSize)
                , default_getMaxTextureSize_function_type(&OpenGL3Renderer_wrapper::default_getMaxTextureSize) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*getTexture_function_type )( ::CEGUI::String const & ) const;
            
            OpenGL3Renderer_exposer.def( 
                "getTexture"
                , getTexture_function_type(&::CEGUI::OpenGLRendererBase::getTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize
        
            typedef void ( OpenGL3Renderer_wrapper::*initialiseDisplaySizeWithViewportSize_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "initialiseDisplaySizeWithViewportSize"
                , initialiseDisplaySizeWithViewportSize_function_type( &OpenGL3Renderer_wrapper::initialiseDisplaySizeWithViewportSize )
                , "! helper to set display size with current viewport size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseMaxTextureSize
        
            typedef void ( OpenGL3Renderer_wrapper::*initialiseMaxTextureSize_function_type )(  ) ;
            
            OpenGL3Renderer_exposer.def( 
                "initialiseMaxTextureSize"
                , initialiseMaxTextureSize_function_type( &OpenGL3Renderer_wrapper::initialiseMaxTextureSize )
                , "! helper to set (rough) max texture size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::isTextureDefined
        
            typedef bool ( ::CEGUI::OpenGLRendererBase::*isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            typedef bool ( OpenGL3Renderer_wrapper::*default_isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            
            OpenGL3Renderer_exposer.def( 
                "isTextureDefined"
                , isTextureDefined_function_type(&::CEGUI::OpenGLRendererBase::isTextureDefined)
                , default_isTextureDefined_function_type(&OpenGL3Renderer_wrapper::default_isTextureDefined)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureCreation
        
            typedef void ( *logTextureCreation_function_type )( ::CEGUI::String const & );
            
            OpenGL3Renderer_exposer.def( 
                "logTextureCreation"
                , logTextureCreation_function_type( &OpenGL3Renderer_wrapper::logTextureCreation )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureDestruction
        
            typedef void ( *logTextureDestruction_function_type )( ::CEGUI::String const & );
            
            OpenGL3Renderer_exposer.def( 
                "logTextureDestruction"
                , logTextureDestruction_function_type( &OpenGL3Renderer_wrapper::logTextureDestruction )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n\
            ! helper to safely log the destruction of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::setDisplaySize
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            typedef void ( OpenGL3Renderer_wrapper::*default_setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            
            OpenGL3Renderer_exposer.def( 
                "setDisplaySize"
                , setDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::setDisplaySize)
                , default_setDisplaySize_function_type(&OpenGL3Renderer_wrapper::default_setDisplaySize)
                , ( bp::arg("sz") ) );
        
        }
        OpenGL3Renderer_exposer.staticmethod( "bootstrapSystem" );
        OpenGL3Renderer_exposer.staticmethod( "create" );
        OpenGL3Renderer_exposer.staticmethod( "destroy" );
        OpenGL3Renderer_exposer.staticmethod( "destroySystem" );
        OpenGL3Renderer_exposer.staticmethod( "logTextureCreation" );
        OpenGL3Renderer_exposer.staticmethod( "logTextureDestruction" );
    }

}
