/*!
  @author Shin'ichiro Nakaoka
*/

#include "../LazyCaller.h"
#include <cnoid/PyUtil>
#include <cnoid/PythonUtil>

using namespace boost;
using namespace boost::python;
using namespace cnoid;

namespace {

struct PyFunc
{
    python::object func;
    PyFunc(python::object f) : func(f) {
        if(!PyFunction_Check(f.ptr()) && !PyMethod_Check(f.ptr())){
            PyErr_SetString(PyExc_TypeError, "Task command must be a function type object");
            python::throw_error_already_set();
        }
    }
    void operator()() {
        PyGILock lock;
        try {
            func();
        } catch(python::error_already_set const& ex) {
            handlePythonException();
        }
    }
};


void cnoid_callLater(python::object func)
{
    cnoid::callLater(PyFunc(func));
}


void cnoid_callSynchronously(python::object func)
{
    cnoid::callSynchronously(PyFunc(func));
}


} // namespace

namespace cnoid {

void exportLazyCaller()
{
    python::def("callLater", cnoid_callLater);
    python::def("callSynchronously", cnoid_callSynchronously);
}

}
