/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-06-28
 *
 */

#include <sys/time.h>
#include <cstdarg>
#include <cstring>
#include <cmath>
#include <fstream>

#include "config.h"

#include "log-facility.hh"

using namespace std;


Stilton::CLogFacility::
CLogFacility( const char *log_fname,
	      int inlog_threshold,
	      int instdout_tee_threshold,
	      unsigned short insec_dec_place,
	      int bits,
	      size_t buf_size)
      : status (bits),
	log_threshold (inlog_threshold),
	stdout_tee_threshold (instdout_tee_threshold),
	sec_dec_places (insec_dec_place)
{
	_line_buf = new char[_buf_size = buf_size];
	if ( log_fname && strlen(log_fname) ) {
		_log_fname = string(log_fname);
		_log_strm.open( log_fname);
		unitbuf( _log_strm);
	}
}

Stilton::CLogFacility::
~CLogFacility()
{
	if ( _log_fname.size() )
		_log_strm.close();
	delete[] _line_buf;
}


void
Stilton::CLogFacility::
msg( int vrb, const char *client_name, const char* fmt, ...)
{
	va_list ap;
	va_start (ap, fmt);
	msgv( vrb, client_name, fmt, ap);
	va_end (ap);
}


void
Stilton::CLogFacility::
msgv( int vrb, const char *client_name, const char* fmt, va_list ap)
{
//	if ( status & STILTON_LOG_NOLOCK )
//		boost::interprocess::scoped_lock<boost::interprocess::interprocess_mutex> L( _log_lock);

	if ( log_threshold < vrb && stdout_tee_threshold < vrb )
		return;

	char timestampbuf[32];
	time_t timestamp; time( &timestamp);
	struct timeval tp; gettimeofday( &tp, nullptr);
	strftime( timestampbuf, 31, "%F %T", localtime( &timestamp));
	char secfracbuf[sec_dec_places+3];
	snprintf( secfracbuf, sec_dec_places+2, ".%0*u", sec_dec_places,
		  (unsigned)round( tp.tv_usec / pow( 10., 6-sec_dec_places-1)));

	vsnprintf( _line_buf, _buf_size, fmt, ap);

	char *line = strtok( _line_buf, "\n");
	do {
		if ( vrb < 0 )
			printf( "%s%sError: %s\n", client_name ? client_name : "", (client_name && strlen(client_name)) ? ": " : "", line);
		else if ( stdout_tee_threshold >= vrb )
			printf( "%s%s%s\n", client_name ? client_name : "", (client_name && strlen(client_name)) ? ": " : "", line);

		if ( log_threshold >= vrb && _log_fname.size() )
			_log_strm << timestampbuf << (sec_dec_places > 0 ? secfracbuf : "") << ' '
				  << client_name << ": "
				  << (vrb < 0 ? "Error: " : "") << line << endl;
	} while ( (line = strtok( nullptr, "\n")) );

	if ( _log_fname.size() )
		_log_strm.flush();
}



// a one-liner, possibly unterminated by \n
void
Stilton::CLogFacility::
msg_( int vrb, const char *client_name, const char* fmt, ...)
{
	va_list ap;
	va_start (ap, fmt);
	msgv_( vrb, client_name, fmt, ap);
	va_end (ap);
}

void
Stilton::CLogFacility::
msgv_( int vrb, const char *client_name, const char* fmt, va_list ap)
{
//	if ( status & STILTON_LOG_NOLOCK )
//		boost::interprocess::scoped_lock<boost::interprocess::interprocess_mutex> L( _log_lock);

	if ( log_threshold < vrb && stdout_tee_threshold < vrb )
		return;

	char timestampbuf[32];
	time_t timestamp; time( &timestamp);
	struct timeval tp; gettimeofday( &tp, nullptr);
	strftime( timestampbuf, 31, "%F %T", localtime( &timestamp));
	char secfracbuf[sec_dec_places+3];
	snprintf( secfracbuf, sec_dec_places+2, ".%0*u", sec_dec_places,
		  (unsigned)round( tp.tv_usec / pow( 10., 6-sec_dec_places-1)));

	vsnprintf( _line_buf, _buf_size, fmt, ap);

	if ( vrb < 0 )
		printf( "%s%sError: %s", client_name ? client_name : "", (client_name && strlen(client_name)) ? ": " : "", _line_buf);
	else if ( stdout_tee_threshold >= vrb )
		printf( "%s%s%s", client_name ? client_name : "", (client_name && strlen(client_name)) ? ": " : "", _line_buf);

	if ( log_threshold >= vrb && _log_fname.size() )
		_log_strm << timestampbuf << (sec_dec_places > 0 ? secfracbuf : "") << ' '
			  << client_name << ": "
			  << (vrb < 0 ? "Error: " : "") << _line_buf << endl;
}


// eof
