/****************************************************************************
 *    lib/b/StaticRule.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "StaticRule.h"

using namespace B;

B::StaticRule::StaticRule(int line, Formula* F, Formula* G, Types* types) :  Statement(line, types), C::StaticRule(line, F, G, types) {

}

B::StaticRule::~StaticRule ( ) { }

void B::StaticRule::printDirect(Printer* p) {
	cerr << "% WARNING: No direct encoding for static rules yet\n";
}

void B::StaticRule::printNonDirect(Printer* p) {
	string T;
	set<Variable*>* vars = new set<Variable*>();

	// print the static rule twice: for T=0 and T>0
	for(int i = 1; i <= 2; ++i) {
		if(i == 1) {
			p->setSection('b');
			T = "0";
		}
		else {
			p->setSection('c');
			T = p->T;
		}

		FluentAction* f;
		string neg_f;
		FluentAction* g;
		string neg_g;

		// holds(f, T) :- holds(g, T).
		for(vector<Formula*>::iterator fluent_f = F_->begin(); fluent_f != F_->end(); ++fluent_f) {
			if(!(*fluent_f)->isFalse()) {
				// check for negation
				if((*fluent_f)->getType() == 'n') {
					f = (FluentAction*) (*fluent_f)->getFirstFormula();
					neg_f = p->neg;
				}
				else {
					f = (FluentAction*) *fluent_f;
					neg_f = "";
				}

				vars = f->getVariables();

				p->add("holds(" + neg_f + f->print(p) + ", " + T + ") :- ");
			}
			else {
				p->add(":- ");
			}

			if(G_ && !G_->isTrue()) {
				for(vector<Formula*>::iterator fluent_g = G_->begin(); fluent_g != G_->end(); ++fluent_g) {
					// check for negation
					if((*fluent_g)->getType() == 'n') {
						g = (FluentAction*) (*fluent_g)->getFirstFormula();
						neg_g = p->neg;
					}
					else {
						g = (FluentAction*) *fluent_g;
						neg_g = "";
					}

					p->add("holds(" + neg_g + g->print(p) + ", " + T + ")");
					if(fluent_g != G_->end()-1) p->add(", ");

					// get the vars
					set<Variable*>* tmp_vars = g->getVariables();
					if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
					delete tmp_vars;
				}

			}
			if(!vars->empty()) {
				if(G_ && !G_->isTrue()) p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");

		//	delete vars;
		}
	} // end of for loop for printing twice
}
