/****************************************************************************
 *    lib/c_taid/scanner.l - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

%{
#include "parser.h"
#include <stdio.h>

bool second_part = false;
bool asked_query = false;

void printPartError(const string, const int);
void printQueryError(const string, const int);

%}

%option yylineno nounput noyywrap c++ prefix="ctaid"

IDENTIFIER	[a-zA-Z][a-zA-Z0-9_]*
NEG_IDENTI	\-[a-zA-Z0-9_]+
NUMBER		[0-9]+
COMMENT		\%.*\n
ACT		<action>
FLU		<fluent>
DEF		<default>
CAUS	<causes>
IF		<if>
TRIG	<triggers>
ALLOW	<allows>
INHIB	<inhibits>
NCONC	<noconcurrency>
AT		<at>
OCAT	<occurs_at>
EXP		<explain>
PLAN	<plan>
PRED	<predict>

%%
[\t\n ]+		// ignore white space.
{ACT}			{ if(second_part) printPartError(yytext, lineno()); else return CtaidParser::ACT; }
{FLU}			{ return CtaidParser::FLU;	}
{DEF}			{ return CtaidParser::DEF; }
{CAUS}			{ return CtaidParser::CAUS; }
{IF}			{ return CtaidParser::IF; }
{TRIG}			{ if(second_part) printPartError(yytext, lineno()); else return CtaidParser::TRIG; }
{ALLOW}			{ if(second_part) printPartError(yytext, lineno()); else return CtaidParser::ALLOW; }
{INHIB}			{ return CtaidParser::INHIB; }
{NCONC}			{ return CtaidParser::NCONC; }
{AT}			{ return CtaidParser::AT; }
{OCAT}			{ second_part = true; return CtaidParser::OC_AT; }
{EXP}			{ if(asked_query) printQueryError(yytext, lineno());
				  else {
				  	asked_query = true;
					return CtaidParser::EXP;
				  }
				}
{PLAN}			{ if(asked_query) printQueryError(yytext, lineno());
				  else {
				  	asked_query = true;
					return CtaidParser::PLAN;
				  }
				}
{PRED}			{ if(asked_query) printQueryError(yytext, lineno());
				  else {
				  	asked_query = true;
					return CtaidParser::PRED;
				  }
				}
{IDENTIFIER}	{ return CtaidParser::IDENTIFIER; }
{NEG_IDENTI}	{ return CtaidParser::NEG_IDENTI; }
{NUMBER}		{ return CtaidParser::NUMBER; }
","				{ return CtaidParser::COMMA; }
"."				{ return CtaidParser::DOT; }
{COMMENT}		{ /* comment */ }
<<EOF>>         { yyterminate(); }
.				{ cerr << "\n\nError: Unknown keyword '"+string(yytext)+"' found at line "<<lineno()<<".\n";
				  exit(2);
				}
%%

void printPartError(const string etext, const int line) {
	cerr << "\n\nError: Keyword '"+etext+"' may only appear in description part, but found at line "<<line<<".\n";
	exit(2);
}

void printQueryError(const string etext, const int line) {
	cerr << "\n\nError: Keyword '"+etext+"' found at line "<<line<<", but only one query at a time allowed.\n";
	exit(2);
}
