#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/Data/CODFlags.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_MODULE} qw( has_attached_hydrogens )" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 17:12:38 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10066 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.10.0/tests/shtests/has_attached_hydrogens_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::CODFlags::has_attached_hydrogens
#* subroutine.
#**

use strict;
use warnings;

# use COD::CIF::Data::CODFlags qw( has_attached_hydrogens );

my $data_block_1 =
{
  'name'   => 'test_1',
  'tags'   => [],
  'loops'  => [],
  'inloop' => {},
  'values' => {},
  'precisions' => {},
  'types'  => {},
};

my $data_block_2 =
{
  'name'   => 'test_2',
  'tags'   => [ '_atom_site_attached_hydrogens' ],
  'loops'  => [ [ '_atom_site_attached_hydrogens' ] ],
  'inloop' => { '_atom_site_attached_hydrogens' => 0 },
  'values' => { '_atom_site_attached_hydrogens' => [ '?', '.' ] },
  'precisions' => {},
  'types'  => { '_atom_site_attached_hydrogens' => [ 'UQSTRING', 'UQSTRING' ] },
};

my $data_block_3 =
{
  'name'   => 'test_3',
  'tags'   => [ '_atom_site_attached_hydrogens' ],
  'loops'  => [ [ '_atom_site_attached_hydrogens' ] ],
  'inloop' => { '_atom_site_attached_hydrogens' => 0 },
  'values' => { '_atom_site_attached_hydrogens' => [ '0' ] },
  'precisions' => {},
  'types'  => { '_atom_site_attached_hydrogens' => [ 'INTEGER' ] },
};

my $data_block_4 =
{
  'name'   => 'test_4',
  'tags'   => [ '_atom_site_attached_hydrogens' ],
  'loops'  => [ [ '_atom_site_attached_hydrogens' ] ],
  'inloop' => { '_atom_site_attached_hydrogens' => 0 },
  'values' => { '_atom_site_attached_hydrogens' => [ '1' ] },
  'precisions' => {},
  'types'  => { '_atom_site_attached_hydrogens' => [ 'INTEGER' ] },
};

my @blocks = (
    $data_block_1,
    $data_block_2,
    $data_block_3,
    $data_block_4,
);

for my $data_block ( @blocks ) {
    my $has_attached_hydrogens = has_attached_hydrogens( $data_block );
    if ( $has_attached_hydrogens ) {
        print 'Data block \'' . $data_block->{'name'} . '\' has attached hydrogens.' . "\n";
    } else {
        print 'Data block \'' . $data_block->{'name'} . '\' does not have attached hydrogens.' . "\n";
    }
}

END_SCRIPT
