import Adapter from './application';

// TODO: Update to use this.formatDatacenter()
export default class ServiceInstanceAdapter extends Adapter {
  requestForQuery(request, { dc, ns, index, id, uri }) {
    if (typeof id === 'undefined') {
      throw new Error('You must specify an id');
    }
    return request`
      GET /v1/health/service/${id}?${{ dc }}
      X-Request-ID: ${uri}
      X-Range: ${id}

      ${{
        ...this.formatNspace(ns),
        index,
      }}
    `;
  }

  requestForQueryRecord(request, { dc, ns, index, id, uri }) {
    // query and queryRecord both use the same endpoint
    // they are just serialized differently
    return this.requestForQuery(...arguments);
  }
}
