/*****************************************************************************/
/*!
 * \file search_simple.h
 * 
 * Author: Clark Barrett
 * 
 * Created: Sat Mar 29 21:53:46 2003
 *
 * <hr>
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvc3__include__search_simple_h_
#define _cvc3__include__search_simple_h_

#include "search_impl_base.h"
#include "statistics.h"

namespace CVC3 {

class DecisionEngine;

/*!
 * \defgroup SE_Simple Simple Search Engine
 * \ingroup SE
 *
 * This module includes all the components of a very simplistic search
 * engine.  It is used mainly for debugging purposes.
 */

  //! Implementation of the simple search engine
  /*! \ingroup SE_Simple */
class SearchSimple: public SearchImplBase {
  /*! \addtogroup SE_Simple 
   * @{
   */

  //! Name
  std::string d_name;

  //! Decision Engine
  DecisionEngine* d_decisionEngine;

  //! Formula being checked
  CDO<Theorem> d_goal;
  //! Non-literals generated by DP's
  CDO<Theorem> d_nonLiterals;
  //! Theorem which records simplification of the last query
  CDO<Theorem> d_simplifiedThm;

  //! Recursive DPLL algorithm used by checkValid
  QueryResult checkValidRec(Theorem& thm);
  //! Private helper function for checkValid and restart
  QueryResult checkValidMain(const Expr& e2);

public:
  //! Constructor
  SearchSimple(TheoryCore* core);
  //! Destructor
  ~SearchSimple();
  
  // Implementation of virtual SearchEngine methods
  const std::string& getName() { return d_name; }
  QueryResult checkValidInternal(const Expr& e);
  QueryResult restartInternal(const Expr& e);
  void addLiteralFact(const Theorem& thm) {}
  void addNonLiteralFact(const Theorem& thm);

  /*! @} */ // end addtogroup SE_Simple
};

}

#endif
