We're proud to announce the new feature release of darktable, 4.6.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-4.6.1](https://github.com/darktable-org/darktable/releases/tag/release-4.6.1).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-4.6.1.tar.xz
??? darktable-4.6.1.tar.xz
$ sha256sum darktable-4.6.1-x86_64.dmg
??? darktable-4.6.1-x86_64.dmg
$ sha256sum darktable-4.6.1-arm64.dmg
??? darktable-4.6.1-arm64.dmg
$ sha256sum darktable-4.6.1-win64.exe
??? darktable-4.6.1.exe
```

When updating from the stable 4.4 series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 4.4.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 4.6.0:

- 606 commits to darktable+rawspeed
- 57 pull requests handled
- 12 issues closed


## The Big Ones

- Documentation is now complete for darktable 4.6 including translation
  into Ukrainian, Polish and Dutch.
  See [https://www.darktable.org/resources](https://www.darktable.org/resources)
  for details.

## Performance Improvements

- Fixed some OpenCL code paths that could produce garbled or unprocessed
  output without reporting the issue back to the pixel-pipe.

## Other Changes

- Image discovery from the import dialog is now performed
  asynchronously. This means that a long parsing (due to using recursive
  mode in a directory with a huge number of sub-directories and
  files) can be interrupted by selecting another place/directory
  or un-checking recursive mode.

## Bug Fixes

- Fixed an issue with importing images in recursive mode. Using this
  mode without having first selected a directory could freeze darktable due
  to it having to parse the whole disk (though it would recover eventually).

- When importing images in recursive mode, the thumbs for
  images discovered in sub-directories are now properly displayed.

- Fixed memory and resource leaks in the QOI image loader.

- Fixed RGBE image loader.

- Fixed possible issue with guide lines not being displayed in the
  Rotate and Perspective module.

- Fixed non-persistent zoom level in culling mode when switching images.

- Fixed crashes related to details mask when running low on GPU or
  system memory.

- Fixed incorrect rendering of an initial snapshot after creating a
  second snapshot.

- Keep selected styles in the style dialog after editing them.

- Fixed collection selection for ISO, aperture and aspect ratio to work
  in all locales (independent of any locale-specific decimal separator).

- Fixed RAW Chromatic Aberrations module, which could crash due to a
  rounding issue while computing an internal buffer size. This could
  cause a buffer overflow and possibly crash darktable.

- Avoid undershoots while interpolating in Lens Correction, Rotate and
  Perspective, Retouch and Liquify modules.

- Include LibRaw fix for artifacts when decoding high-ISO Canon CR3 files.

- Fixed possible incorrect module name when applying styles, whereby the
  module name was showing garbled text.

- Fixed possible incorrect default value initialized in Lens Correction legacy
  parameter migration from version 2.

- Fixed garbled output and possible OpenCL errors for very dark regions
  in Color Balance RGB.

- Fixed OpenCL startup for various cards.

- Fixed issue where the right-click-and-drag rotation line was not being
  displayed on the image when a darkroom module was expanded.

- Fixed lighttable scrolling freeze when using a track-pad.

- Fix compatibility issues with HDR created DNG files.

- Fix possible crash when using the capture's live view mode.

- Fixed a zooming bug in lighttable culling mode where some images' area
  could be plain grey or having a very small thumb.

- Fixed some missing pipe recomputing making processing modules' graph
  (Tone Equalizer for example) not properly updated.

- Fixed several mouse scroll-wheel issues on macOS when used in
  combination with the <kbd>Shift</kbd> modifier key (color harmonies
  width, module height, geotagging date/time, ...).

## Lua

### API Version

- API version is now 9.2.0

### Bug Fixes

- Fixed `scripts_installer` to handle user names with spaces on Windows.

### Add action support for Lua


### Other Lua changes

- n/a

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- In order to support the correct display of numbers in darktable, the
  minimum supported Gtk version has had to be increased to
  3.24.15. For people who need to build darktable with an older
  version, this can be achieved by removing line 241 of the
  `darktable.css` file on your system. See
  https://github.com/darktable-org/darktable/issues/13166.

- Starting with release 4.4 a new support policy regarding macOS
  versions has been put in place – darktable releases will now only
  support those macOS versions that are also supported by Apple.
  Release 4.6 therefore drops support for macOS versions older than
  12.5.

## Changed Dependencies

### Mandatory

- n/a

### Optional

- Bump libavif to 0.9.3

## RawSpeed changes


## Camera support, compared to 4.4

### Base Support

- Canon EOS Kiss F
- Canon EOS Kiss X50
- Canon EOS Kiss X90
- Canon IXY 220F (dng, chdk)
- Canon PowerShot SX220 HS (chdk)
- Fujifilm FinePix SL1000
- Fujifilm GFX100 II (compressed)
- Fujifilm X-S20 (compressed)
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV-50c
- Hasselblad CFV II 50C
- Hasselblad CFV II 50C
- Hasselblad CFV 100C
- Hasselblad CFV 100C
- ImBack ImB35mm (chdk)
- Leica M (Typ 262) (dng)
- Leica M-D (Typ 262) (dng)
- Leica M10-D (dng)
- Leica M10-P (dng)
- Leica M10-R (dng)
- Leica M11-P (dng)
- Leica Q2 Monochrom (dng)
- Leica S (Typ 007) (dng)
- Leica S2 (dng)
- Leica S3 (dng)
- Leica SL2 (dng)
- Leica SL2-S (dng)
- Leica T (Typ 701) (dng)
- Leica TL (dng)
- Leica TL2 (dng)
- Leica V-Lux 4 (4:3, 3:2, 1:1, 16:9)
- Leica V-Lux 5 (3:2)
- Leica X (Typ 113) (dng)
- Leica X Vario (Typ 107) (dng)
- Leica X-U (Typ 113) (dng)
- Leica X1 (dng)
- Nikon Coolpix A1000 (12bit-uncompressed)
- Nikon Z f (14bit-compressed)
- OM System TG-7
- Panasonic DC-TZ200D (3:2)
- Panasonic DC-TZ202D (3:2)
- Panasonic DC-TZ220 (3:2)
- Panasonic DC-TZ220D (3:2)
- Panasonic DC-ZS200D (3:2)
- Panasonic DC-ZS220 (3:2)
- Panasonic DC-ZS220D (3:2)
- Panasonic DMC-G10 (3:2, 16:9, 1:1)
- Panasonic DMC-GM1S (4:3, 3:2, 16:9, 1:1)
- Pentax K-3 Mark III Monochrome
- Pentax KF
- Pentax Q-S1 (dng)
- Pentax Q10 (dng)
- Samsung EK-GN120
- Samsung G920F (dng)
- Samsung G935F (dng)
- Samsung GX10 (dng)
- Samsung GX20 (dng)
- Samsung NX3300
- Sigma fp (dng)
- Sigma fp L (dng)
- Sigma sd Quattro (dng)
- Sigma sd Quattro H (dng)
- Sinar eVolution 75
- Sony ILCE-6700
- Sony ILCE-7CM2
- Sony ILCE-7CR
- Sony ILME-FX3
- Sony ZV-E1

### White Balance Presets

- Leica M (Typ 240)
- Olympus E-P7
- Olympus TG-6
- Phase One IQ180
- Sony ILCE-7CM2

### Noise Profiles

- Canon IXY 220F
- Nikon Z 8
- Nikon Z f
- Olympus E-P7
- Pentax *ist DS
- Sony ILCE-6700
- Sony ILCE-7CM2

### Missing Compression Mode Support

- Adobe enhanced DNGs (JPEG XL flavor)
- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- Samsung Expert RAW DNGs (JPEG XL flavor)
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples
are available on raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm FinePix S9600fd
- Fujifilm IS-1
- GoPro FUSION
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Minolta DiMAGE 5
- Olympus SP320
- Panasonic DMC-FX150
- Phase One IQ250
- Sinar Hy6/ Sinarback eXact
- ST Micro STV680

## Translations

- Add support for Dutch online help which is now fully complete.

- Albanian
- Brazilian Portuguese
- Chinese (Simplified)
- Chinese (Traditional)
- Czech
- Dutch
- European Spanish
- Finnish
- French
- German
- Hungarian
- Italian
- Japanese
- Polish
- Russian
- Slovenian
- Turkish
- Ukrainian
