/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>

#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

/* variables to access DBMix channels shared memory */
extern  int shmid, sysshmid;
extern dbfsd_data * sysdata;
extern local_channel * local_channels;
/* static local_channel * cue_channels; */
extern local_channel * ch;

extern int errno;
extern int debug_level; /* declared in debug module */

/*
  DBAudio_Close - closes this instance and frees all resources.
*/
int DBAudio_Close()
{
	int error;

	error = SUCCESS;

	Debug("DBAudioLib: freeing sampler buffer...");

	if (ch->sampler_buf != NULL)
	{
		free(ch->sampler_buf);
	}

	Debug("DBAudioLib: deleteing shared memory segment for channel data... ");
	/* close pipes */
	if(ch != NULL)
	{
		close(ch->client_comm_fd);
		
		if(DBAudio_Cue_Enabled())
		{
			close(ch->client_cue_fd);
		}
	}

	ch = NULL;

	/* detach channel memory segment */
	if(shmdt(local_channels) == -1)
	{
		Error("DBAudioLib: could not detach channel memory segment.");
		error = FAILURE;
	}

	local_channels = NULL;

	Debug("DBAudioLib: deleteing system data shared memory segment... ");

	/* detach system data memory segment */
	if(shmdt(sysdata) == -1)
	{
		Error("DBAudioLib: could not detach system data memory segment.");
		error =  FAILURE;
	}
	
	sysdata = NULL;

	Debug("DBAudioLib: close done.");

	return error;
}


#ifdef __cplusplus
}
#endif
