from typing import Container, Optional

from debputy.plugin.api.spec import (
    DebputyIntegrationMode,
    INTEGRATION_MODE_DH_DEBPUTY_RRR,
    INTEGRATION_MODE_DH_DEBPUTY,
)


def determine_debputy_integration_mode(
    all_sequences: Container[str],
) -> Optional[DebputyIntegrationMode]:

    has_zz_debputy = "zz-debputy" in all_sequences or "debputy" in all_sequences
    has_zz_debputy_rrr = "zz-debputy-rrr" in all_sequences
    has_any_existing = has_zz_debputy or has_zz_debputy_rrr
    if has_zz_debputy_rrr:
        return INTEGRATION_MODE_DH_DEBPUTY_RRR
    if has_any_existing:
        return INTEGRATION_MODE_DH_DEBPUTY
    return None
