# - Try to find DIRECTX_DIRECTSOUND
# Once done this will define
#
#  DIRECTX_DIRECTSOUND_FOUND - system has DIRECTX_DIRECTSOUND
#  DIRECTX_DIRECTSOUND_INCLUDE_DIRS - the DIRECTX_DIRECTSOUND include directory
#  DIRECTX_DIRECTSOUND_LIBRARIES - Link these to use DIRECTX_DIRECTSOUND
#  DIRECTX_DIRECTSOUND_DEFINITIONS - Compiler switches required for using DIRECTX_DIRECTSOUND
#
#  Copyright (c) 2007 Jamie Jones <jamie_jones_au@yahoo.com.au>
#
#  Redistribution and use is allowed according to the terms of the
#  GNU GPLv3 license.
#


if (DIRECTX_DIRECTSOUND_LIBRARIES AND DIRECTX_DIRECTSOUND_INCLUDE_DIRS)
  # in cache already
  set(DIRECTX_DIRECTSOUND_FOUND TRUE)
else (DIRECTX_DIRECTSOUND_LIBRARIES AND DIRECTX_DIRECTSOUND_INCLUDE_DIRS)
  find_path(DIRECTX_DIRECTSOUND_INCLUDE_DIR
    NAMES
      dsound.h
    PATHS
      $ENV{DIRECTXDIR}/include
      /usr/include
      /usr/local/include
      /opt/local/include
      /sw/include
  )

  find_library(LIBDSOUND_LIBRARY
    NAMES
      libdsound
    PATHS
      $ENV{DIRECTXDIR}/lib
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  set(DIRECTX_DIRECTSOUND_INCLUDE_DIRS
    ${DIRECTX_DIRECTSOUND_INCLUDE_DIR}
  )
  set(DIRECTX_DIRECTSOUND_LIBRARIES
    ${LIBDSOUND_LIBRARY}
)

  if (DIRECTX_DIRECTSOUND_INCLUDE_DIRS AND DIRECTX_DIRECTSOUND_LIBRARIES)
     set(DIRECTX_DIRECTSOUND_FOUND TRUE)
  endif (DIRECTX_DIRECTSOUND_INCLUDE_DIRS AND DIRECTX_DIRECTSOUND_LIBRARIES)

  if (DIRECTX_DIRECTSOUND_FOUND)
    if (NOT DIRECTX_DIRECTSOUND_FIND_QUIETLY)
      message(STATUS "Found DIRECTX_DIRECTSOUND: ${DIRECTX_DIRECTSOUND_LIBRARIES}")
    endif (NOT DIRECTX_DIRECTSOUND_FIND_QUIETLY)
  else (DIRECTX_DIRECTSOUND_FOUND)
    if (DIRECTX_DIRECTSOUND_FIND_REQUIRED)
      message(FATAL_ERROR "Could not find DIRECTX_DIRECTSOUND")
    endif (DIRECTX_DIRECTSOUND_FIND_REQUIRED)
  endif (DIRECTX_DIRECTSOUND_FOUND)

  # show the DIRECTX_DIRECTSOUND_INCLUDE_DIRS and DIRECTX_DIRECTSOUND_LIBRARIES variables only in the advanced view
  mark_as_advanced(DIRECTX_DIRECTSOUND_INCLUDE_DIRS DIRECTX_DIRECTSOUND_LIBRARIES)

endif (DIRECTX_DIRECTSOUND_LIBRARIES AND DIRECTX_DIRECTSOUND_INCLUDE_DIRS)

