/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2009-02-10
 * Description : rotate image batch tool.
 *
 * SPDX-FileCopyrightText: 2009-2024 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#ifndef DIGIKAM_BQM_ROTATE_H
#define DIGIKAM_BQM_ROTATE_H

// Local includes

#include "batchtool.h"

using namespace Digikam;

namespace DigikamBqmRotatePlugin
{

class Rotate : public BatchTool
{
    Q_OBJECT

public:

    explicit Rotate(QObject* const parent = nullptr);
    ~Rotate()                                               override;

    BatchToolSettings defaultSettings()                     override;

    BatchTool* clone(QObject* const parent = nullptr) const override;

    void registerSettingsWidget()                           override;

private:

    bool toolOperations()                                   override;

private Q_SLOTS:

    void slotAssignSettings2Widget()                        override;
    void slotSettingsChanged()                              override;

private:

    class Private;
    Private* const d;
};

} // namespace DigikamBqmRotatePlugin

#endif // DIGIKAM_BQM_ROTATE_H
