// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=nls, header=NonlinearProblem.h)
%feature("docstring")  dolfin::NonlinearProblem "
This is a base class for nonlinear problems which can return the
nonlinear function F(u) and its Jacobian J = dF(u)/du.
";

%feature("docstring")  dolfin::NonlinearProblem::NonlinearProblem "
Constructor
";

%feature("docstring")  dolfin::NonlinearProblem::form "
Function called by Newton solver before requesting F or J.
This can be used to compute F and J together
";

%feature("docstring")  dolfin::NonlinearProblem::F "
Compute F at current point x
";

%feature("docstring")  dolfin::NonlinearProblem::J "
Compute J = F' at current point x
";

// Documentation extracted from: (module=nls, header=NewtonSolver.h)
%feature("docstring")  dolfin::NewtonSolver "
This class defines a Newton solver for nonlinear systems of
equations of the form :math:`F(x) = 0`.
";

%feature("docstring")  dolfin::NewtonSolver::NewtonSolver "
**Overloaded versions**

* NewtonSolver\ ()

  Create nonlinear solver

* NewtonSolver\ (solver, factory)

  Create nonlinear solver using provided linear solver
  
  *Arguments*
      solver (:py:class:`GenericLinearSolver`)
          The linear solver.
      factory (:py:class:`GenericLinearAlgebraFactory`)
          The factory.
";

%feature("docstring")  dolfin::NewtonSolver::solve "
Solve abstract nonlinear problem :math:`F(x) = 0` for given
:math:`F` and Jacobian :math:`\dfrac{\partial F}{\partial x}`.

*Arguments*
    nonlinear_function (:py:class:`NonlinearProblem`)
        The nonlinear problem.
    x (:py:class:`GenericVector`)
        The vector.

*Returns*
    (int, bool)
        Pair of number of Newton iterations, and whether
        iteration converged)
";

%feature("docstring")  dolfin::NewtonSolver::iteration "
Return Newton iteration number

*Returns*
    int
        The iteration number.
";

%feature("docstring")  dolfin::NewtonSolver::residual "
Return current residual

*Returns*
    float
        Current residual.
";

%feature("docstring")  dolfin::NewtonSolver::relative_residual "
Return current relative residual

*Returns*
    float
      Current relative residual.
";

%feature("docstring")  dolfin::NewtonSolver::linear_solver "
Return the linear solver

*Returns*
    :py:class:`GenericLinearSolver`
        The linear solver.
";

%feature("docstring")  dolfin::NewtonSolver::default_parameters "
Default parameter values

*Returns*
    :py:class:`Parameters`
        Parameter values.
";

%feature("docstring")  dolfin::NewtonSolver::converged "
Convergence test
";

// Documentation extracted from: (module=nls, header=PETScSNESSolver.h)
%feature("docstring")  dolfin::PETScSNESSolver "
This class implements methods for solving nonlinear systems
via PETSc's SNES interface. It includes line search and trust
region techniques for globalising the convergence of the
nonlinear iteration.
";

%feature("docstring")  dolfin::PETScSNESSolver::PETScSNESSolver "
Create SNES solver for a particular method
";

%feature("docstring")  dolfin::PETScSNESSolver::solve "
**Overloaded versions**

* solve\ (nonlinear_problem, x, lb, ub)

  Solve a nonlinear variational inequality with bound constraints
  
  *Arguments*
      nonlinear_function (:py:class:`NonlinearProblem`)
          The nonlinear problem.
      x (:py:class:`GenericVector`)
          The vector.
      lb (:py:class:`GenericVector`)
          The lower bound.
      ub (:py:class:`GenericVector`)
          The upper bound.
  
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)

* solve\ (nonlinear_function, x)

  Solve abstract nonlinear problem :math:`F(x) = 0` for given
  :math:`F` and Jacobian :math:`\dfrac{\partial F}{\partial x}`.
  
  *Arguments*
      nonlinear_function (:py:class:`NonlinearProblem`)
          The nonlinear problem.
      x (:py:class:`GenericVector`)
          The vector.
  
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)
";

%feature("docstring")  dolfin::PETScSNESSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScSNESSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::PETScSNESSolver::snes "
Return PETSc SNES pointer
";

%feature("docstring")  dolfin::PETScSNESSolver::init "
Initialize SNES solver
";

%feature("docstring")  dolfin::PETScSNESSolver::set_linear_solver_parameters "
Update the linear solver parameters
";

%feature("docstring")  dolfin::PETScSNESSolver::FormFunction "
The callback for PETSc to compute F, the nonlinear residual
";

%feature("docstring")  dolfin::PETScSNESSolver::FormJacobian "
The callback for PETSc to compute A, the Jacobian
";

%feature("docstring")  dolfin::PETScSNESSolver::set_bounds "
Set the bounds on the problem from the parameters, if desired
Here, x is passed in as a model vector from which we make our Vecs
that tell PETSc the bounds if the \"sign\" parameter is used.
";

// Documentation extracted from: (module=nls, header=TAOLinearBoundSolver.h)
%feature("docstring")  dolfin::TAOLinearBoundSolver "
This class provides a bound constrained solver for a
linear variational inequality defined by a matrix A and a vector b.
It solves the problem:

Find :math:`x_l\leq x\leq x_u` such that
:math:`(Ax-b)\cdot (y-x)\geq 0,\; \forall x_l\leq y\leq x_u`

It is a wrapper for the TAO bound constrained solver.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::TAOLinearBoundSolver "
Create TAO bound constrained solver
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::solve "
**Overloaded versions**

* solve\ (A, x, b, xl, xu)

  Solve the linear variational inequality defined by A and b
  with xl =< x <= xu

* solve\ (A, x, b, xl, xu)

  Solve the linear variational inequality defined by A and b
  with xl =< x <= xu
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::set_ksp "
Set PETSC Krylov Solver (ksp) used by TAO
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::methods "
Return a list of available Tao solver methods
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::krylov_solvers "
Return a list of available krylov solvers
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::__TAOFormFunctionGradientQuadraticProblem "
Computes the value of the objective function and its gradient.
";

%feature("docstring")  dolfin::TAOLinearBoundSolver::__TAOFormHessianQuadraticProblem "
Computes the hessian of the quadratic objective function
";

