package com.ibm.icu.util; public class LocaleMatcher {private static final boolean DEBUG=false;private static final double DEFAULT_THRESHOLD=0.5D;private final ULocale defaultLanguage;java.util.Map<ULocale, com.ibm.icu.impl.Row.R2<ULocale, Double>> maximizedLanguageToWeight=new java.util.LinkedHashMap();LanguageMatcherData matcherData;private static LanguageMatcherData defaultWritten=LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$3(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(LanguageMatcherData.access$2(new LanguageMatcherData().addDistance("no","nb",100,"The language no is normally taken as nb in content; we might alias this for lookup."),"nn","nb",96),"nn","no",96).addDistance("da","no",90,"Danish and norwegian are reasonably close."),"da","nb",90).addDistance("hr","br",96,"Serbo-croatian variants are all very close."),"sh","br",96),"sr","br",96),"sh","hr",96),"sr","hr",96),"sh","sr",96).addDistance("sr-Latn","sr-Cyrl",90,"Most serbs can read either script."),"*-Hans","*-Hant",85,true,"Readers of simplified can read traditional much better than reverse.").addDistance("*-Hant","*-Hans",75,true).addDistance("en-*-US","en-*-CA",98,"US is different than others, and Canadian is inbetween."),"en-*-US","en-*-*",97),"en-*-CA","en-*-*",98),"en-*-*","en-*-*",99).addDistance("es-*-ES","es-*-ES",100,"Latin American Spanishes are closer to each other. Approximate by having es-ES be further from everything else."),"es-*-ES","es-*-*",93).addDistance("*","*",1,"[Default value -- must be at end!] Normally there is no comprehension of different languages.").addDistance("*-*","*-*",20,"[Default value -- must be at end!] Normally there is little comprehension of different scripts.").addDistance("*-*-*","*-*-*",96,"[Default value -- must be at end!] Normally there are small differences across regions.").freeze();private static java.util.HashMap<String, String> canonicalMap=new java.util.HashMap();static {LocaleMatcher.canonicalMap.put("iw","he");LocaleMatcher.canonicalMap.put("mo","ro");LocaleMatcher.canonicalMap.put("tl","fil");}public LocaleMatcher(LocalePriorityList languagePriorityList){this(languagePriorityList,LocaleMatcher.defaultWritten);}public LocaleMatcher(String languagePriorityListString){this(LocalePriorityList.add(languagePriorityListString).build());}public LocaleMatcher(LocalePriorityList languagePriorityList,LanguageMatcherData matcherData){this.matcherData=matcherData;r4=languagePriorityList.iterator();while (r4.hasNext()){ULocale language=(ULocale)r4.next();super.add(language,languagePriorityList.getWeight(language));}java.util.Iterator<ULocale> it=languagePriorityList.iterator();this.defaultLanguage=it.hasNext()?(ULocale)it.next():null;}public double match(ULocale desired,ULocale desiredMax,ULocale supported,ULocale supportedMax){return this.matcherData.match(desired,desiredMax,supported,supportedMax);}public ULocale canonicalize(ULocale ulocale){String lang=ulocale.getLanguage();String lang2=(String)LocaleMatcher.canonicalMap.get(lang);String script=ulocale.getScript();String script2=(String)LocaleMatcher.canonicalMap.get(script);String region=ulocale.getCountry();String region2=(String)LocaleMatcher.canonicalMap.get(region);if (lang2 != null || script2 != null || region2 != null)return new ULocale(lang2 == null?lang:lang2,script2 == null?script:script2,region2 == null?region:region2);return ulocale;}public ULocale getBestMatch(LocalePriorityList languageList){double bestWeight=0.0D;ULocale bestTableMatch=null;r6=languageList.iterator();while (r6.hasNext()){ULocale language=(ULocale)r6.next();com.ibm.icu.impl.Row.R2<ULocale, Double> matchRow=super.getBestMatchInternal(language);double weight=((Double)matchRow.get1()).doubleValue() * languageList.getWeight(language).doubleValue();if (weight <= bestWeight){}bestWeight=weight;bestTableMatch=(ULocale)matchRow.get0();}if (bestWeight < 0.5D)bestTableMatch=this.defaultLanguage;return bestTableMatch;}public ULocale getBestMatch(String languageList){return this.getBestMatch(LocalePriorityList.add(languageList).build());}public ULocale getBestMatch(ULocale ulocale){return (ULocale)super.getBestMatchInternal(ulocale).get0();}public String toString(){return "{" + this.defaultLanguage + ", " + this.maximizedLanguageToWeight + "}";}private com.ibm.icu.impl.Row.R2<ULocale, Double> getBestMatchInternal(ULocale languageCode){languageCode=this.canonicalize(languageCode);ULocale maximized=super.addLikelySubtags(languageCode);double bestWeight=0.0D;ULocale bestTableMatch=null;r7=this.maximizedLanguageToWeight.keySet().iterator();while (r7.hasNext()){ULocale tableKey=(ULocale)r7.next();com.ibm.icu.impl.Row.R2<ULocale, Double> row=(com.ibm.icu.impl.Row.R2)this.maximizedLanguageToWeight.get(tableKey);double match=this.match(languageCode,maximized,tableKey,(ULocale)row.get0());double weight=match * ((Double)row.get1()).doubleValue();if (weight <= bestWeight){}bestWeight=weight;bestTableMatch=tableKey;}if (bestWeight < 0.5D)bestTableMatch=this.defaultLanguage;return com.ibm.icu.impl.Row.R2.of(bestTableMatch,Double.valueOf(bestWeight));}private void add(ULocale language,Double weight){language=this.canonicalize(language);com.ibm.icu.impl.Row.R2<ULocale, Double> row=com.ibm.icu.impl.Row.of(super.addLikelySubtags(language),weight);this.maximizedLanguageToWeight.put(language,row);}private ULocale addLikelySubtags(ULocale languageCode){ULocale result=ULocale.addLikelySubtags(languageCode);if (result == null || result.equals(languageCode)){String language=languageCode.getLanguage();String script=languageCode.getScript();String region=languageCode.getCountry();return new ULocale((language.length() == 0?"und":language) + "_" + (script.length() == 0?"Zzzz":script) + "_" + (region.length() == 0?"ZZ":region));}return result;}public static class LanguageMatcherData implements Freezable<LanguageMatcherData>{ScoreData languageScores=new ScoreData(Level.language);ScoreData scriptScores=new ScoreData(Level.script);ScoreData regionScores=new ScoreData(Level.region);private boolean frozen=false;private static int[] $SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level;public double match(ULocale a,ULocale aMax,ULocale b,ULocale bMax){double diff=0.0D;diff=diff + this.languageScores.getScore(a,aMax,a.getLanguage(),aMax.getLanguage(),b,bMax,b.getLanguage(),bMax.getLanguage());diff=diff + this.scriptScores.getScore(a,aMax,a.getScript(),aMax.getScript(),b,bMax,b.getScript(),bMax.getScript());diff=diff + this.regionScores.getScore(a,aMax,a.getCountry(),aMax.getCountry(),b,bMax,b.getCountry(),bMax.getCountry());if (!a.getVariant().equals(b.getVariant()))diff=diff + 1.0D;if (diff < 0.0D)diff=0.0D; else if (diff > 1.0D)diff=1.0D;return 1.0D - diff;}private LanguageMatcherData addDistance(String desired,String supported,int percent){return super.addDistance(desired,supported,percent,false,null);}public LanguageMatcherData addDistance(String desired,String supported,int percent,String comment){return super.addDistance(desired,supported,percent,false,comment);}public LanguageMatcherData addDistance(String desired,String supported,int percent,boolean oneway){return super.addDistance(desired,supported,percent,oneway,null);}private LanguageMatcherData addDistance(String desired,String supported,int percent,boolean oneway,String comment){double score=1.0D - (double)percent / 100.0D;LocalePatternMatcher desiredMatcher=new LocalePatternMatcher(desired);Level desiredLen=desiredMatcher.getLevel();LocalePatternMatcher supportedMatcher=new LocalePatternMatcher(supported);Level supportedLen=supportedMatcher.getLevel();if (desiredLen != supportedLen)throw new IllegalArgumentException();com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data=com.ibm.icu.impl.Row.of(desiredMatcher,supportedMatcher,Double.valueOf(score));com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data2=oneway?null:com.ibm.icu.impl.Row.of(supportedMatcher,desiredMatcher,Double.valueOf(score));switch (desiredLen){case language:String dlanguage=desiredMatcher.getLanguage();String slanguage=supportedMatcher.getLanguage();this.languageScores.addDataToScores(dlanguage,slanguage,data);if (!oneway)this.languageScores.addDataToScores(slanguage,dlanguage,data2);break;case script:String dscript=desiredMatcher.getScript();String sscript=supportedMatcher.getScript();this.scriptScores.addDataToScores(dscript,sscript,data);if (!oneway)this.scriptScores.addDataToScores(sscript,dscript,data2);break;case region:String dregion=desiredMatcher.getRegion();String sregion=supportedMatcher.getRegion();this.regionScores.addDataToScores(dregion,sregion,data);if (!oneway)this.regionScores.addDataToScores(sregion,dregion,data2);break;}return this;}public LanguageMatcherData cloneAsThawed(){LanguageMatcherData result=(LanguageMatcherData)this.clone();result.languageScores=this.languageScores.cloneAsThawed();result.scriptScores=this.scriptScores.cloneAsThawed();result.regionScores=this.regionScores.cloneAsThawed();result.frozen=false;return result;}public LanguageMatcherData freeze(){return this;}public boolean isFrozen(){return this.frozen;}public Object cloneAsThawed(){return this.cloneAsThawed();}public Object freeze(){return this.freeze();}static LanguageMatcherData access$2(LanguageMatcherData arg0,String arg1,String arg2,int arg3){return arg0.addDistance(arg1,arg2,arg3);}static LanguageMatcherData access$3(LanguageMatcherData arg0,String arg1,String arg2,int arg3,boolean arg4,String arg5){return arg0.addDistance(arg1,arg2,arg3,arg4,arg5);}static int[] $SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level(){if (LanguageMatcherData.$SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level == null){}r0=new int[Level.values().length];r0[Level.language.ordinal()]=1;r0[Level.region.ordinal()]=3;r0[Level.script.ordinal()]=2;return LanguageMatcherData.$SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level=r0;}}private static class ScoreData implements Freezable<ScoreData>{java.util.LinkedHashSet<com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double>> scores=new java.util.LinkedHashSet();final double worst;final Level level;private boolean frozen=false;public ScoreData(Level level){this.level=level;this.worst=(double)(1 - (level == Level.language?90:level == Level.script?20:4)) / 100.0D;}void addDataToScores(String desired,String supported,com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data){this.scores.add(data);}double getScore(ULocale desiredLocale,ULocale dMax,String desiredRaw,String desiredMax,ULocale supportedLocale,ULocale sMax,String supportedRaw,String supportedMax){boolean desiredChange=desiredRaw.equals(desiredMax);boolean supportedChange=supportedRaw.equals(supportedMax);if (!desiredMax.equals(supportedMax)){double distance=super.getRawScore(dMax,sMax);if (desiredChange == supportedChange)distance=distance * 0.75D;if (desiredChange)distance=distance * 0.5D;} else if (desiredChange == supportedChange)double distance=0.0D; else double distance=0.25D * this.worst;return distance;}private double getRawScore(ULocale desiredLocale,ULocale supportedLocale){r4=this.scores.iterator();while (r4.hasNext()){com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> datum=(com.ibm.icu.impl.Row.R3)r4.next();if (((LocalePatternMatcher)datum.get0()).matches(desiredLocale) && ((LocalePatternMatcher)datum.get1()).matches(supportedLocale))return ((Double)datum.get2()).doubleValue();}return this.worst;}public String toString(){return this.level + ", " + this.scores;}public ScoreData cloneAsThawed(){ScoreData result=(ScoreData)this.clone();result.scores=(java.util.LinkedHashSet)result.scores.clone();result.frozen=false;return result;}public ScoreData freeze(){return this;}public boolean isFrozen(){return this.frozen;}public Object cloneAsThawed(){return this.cloneAsThawed();}public Object freeze(){return this.freeze();}}private static class LocalePatternMatcher {private String lang;private String script;private String region;private Level level;static java.util.regex.Pattern pattern=java.util.regex.Pattern.compile("([a-zA-Z]{1,8}|\\\\*)(?:-([a-zA-Z]{4}|\\\\*))?(?:-([a-zA-Z]{2}|[0-9]{3}|\\\\*))?");public LocalePatternMatcher(String toMatch){java.util.regex.Matcher matcher=LocalePatternMatcher.pattern.matcher(toMatch);if (!matcher.matches())throw new IllegalArgumentException("Bad pattern: " + toMatch);this.lang=matcher.group(1);this.script=matcher.group(2);this.region=matcher.group(3);this.level=this.region != null?Level.region:this.script != null?Level.script:Level.language;if (this.lang.equals("*"))this.lang=null;if (this.script != null && this.script.equals("*"))this.script=null;if (this.region != null && this.region.equals("*"))this.region=null;}boolean matches(ULocale ulocale){if (this.lang != null && !this.lang.equals(ulocale.getLanguage()))return false;if (this.script != null && !this.script.equals(ulocale.getScript()))return false;if (this.region != null && !this.region.equals(ulocale.getCountry()))return false;return true;}public Level getLevel(){return this.level;}public String getLanguage(){return this.lang == null?"*":this.lang;}public String getScript(){return this.script == null?"*":this.script;}public String getRegion(){return this.region == null?"*":this.region;}public String toString(){String result=this.getLanguage();if (this.level != Level.language){result=result + "-" + this.getScript();if (this.level != Level.script)result=result + "-" + this.getRegion();}return result;}}static enum Level {language,script,region}}
/*package com.ibm.icu.util; public class LocaleMatcher {
	private static final boolean DEBUG=false;private static final double DEFAULT_THRESHOLD=0.5D;private final ULocale defaultLanguage;java.util.Map<ULocale, com.ibm.icu.impl.Row.R2<ULocale, Double>> maximizedLanguageToWeight=new java.util.LinkedHashMap();
	LanguageMatcherData matcherData;
	private static LanguageMatcherData defaultWritten=
//			LanguageMatcherData.access$2(
//			LanguageMatcherData.access$2(
//			LanguageMatcherData.access$2(
//			LanguageMatcherData.access$3(
//			LanguageMatcherData.access$2(
//			LanguageMatcherData.access$2(
//			LanguageMatcherData.access$2(
			LanguageMatcherData.access$2(
			LanguageMatcherData.access$2(
			LanguageMatcherData.access$2(
			LanguageMatcherData.access$2(
			LanguageMatcherData.access$2(new LanguageMatcherData().addDistance("ONE","n",100,"O"),"n","n",96),"n","n",96).addDistance("TWO","n",90,"T"),"d","n",90).addDistance("THREE","b",96,"T"),"s","b",96),"s","b",96),"s","h",96),"s","h",96),"s","s",96).addDistance("FOUR","s",90,"F"),"*","*",85,true,"R").addDistance("SIX","e",98,"S"),"e","e",97),"e","e",98),"e","e",99).freeze();
//			LanguageMatcherData.access$2(new LanguageMatcherData().addDistance("ONE","n",100,"O"),"n","n",96),"n","n",96).addDistance("TWO","n",90,"T"),"d","n",90).addDistance("THREE","b",96,"T"),"s","b",96),"s","b",96),"s","h",96),"s","h",96),"s","s",96).addDistance("FOUR","s",90,"F"),"*","*",85,true,"R").addDistance("FIVE","*",75,true).addDistance("SIX","e",98,"S"),"e","e",97),"e","e",98),"e","e",99).addDistance("SEVEN","e",100,"L"),"e","e",93).addDistance("EIGHT","*",1,"g").addDistance("NINE","*",20,"s").addDistance("TEN","*",96,"e").freeze();
	private static java.util.HashMap<String, String> canonicalMap=new java.util.HashMap();static {LocaleMatcher.canonicalMap.put("iw","he");LocaleMatcher.canonicalMap.put("mo","ro");LocaleMatcher.canonicalMap.put("tl","fil");}public LocaleMatcher(LocalePriorityList languagePriorityList){this(languagePriorityList,LocaleMatcher.defaultWritten);}public LocaleMatcher(String languagePriorityListString){this(LocalePriorityList.add(languagePriorityListString).build());}public LocaleMatcher(LocalePriorityList languagePriorityList,LanguageMatcherData matcherData){this.matcherData=matcherData;r4=languagePriorityList.iterator();while (r4.hasNext()){ULocale language=(ULocale)r4.next();super.add(language,languagePriorityList.getWeight(language));}java.util.Iterator<ULocale> it=languagePriorityList.iterator();this.defaultLanguage=it.hasNext()?(ULocale)it.next():null;}public double match(ULocale desired,ULocale desiredMax,ULocale supported,ULocale supportedMax){return this.matcherData.match(desired,desiredMax,supported,supportedMax);}public ULocale canonicalize(ULocale ulocale){String lang=ulocale.getLanguage();String lang2=(String)LocaleMatcher.canonicalMap.get(lang);String script=ulocale.getScript();String script2=(String)LocaleMatcher.canonicalMap.get(script);String region=ulocale.getCountry();String region2=(String)LocaleMatcher.canonicalMap.get(region);if (lang2 != null || script2 != null || region2 != null)return new ULocale(lang2 == null?lang:lang2,script2 == null?script:script2,region2 == null?region:region2);return ulocale;}public ULocale getBestMatch(LocalePriorityList languageList){double bestWeight=0.0D;ULocale bestTableMatch=null;r6=languageList.iterator();while (r6.hasNext()){ULocale language=(ULocale)r6.next();com.ibm.icu.impl.Row.R2<ULocale, Double> matchRow=super.getBestMatchInternal(language);double weight=((Double)matchRow.get1()).doubleValue() * languageList.getWeight(language).doubleValue();if (weight <= bestWeight){}bestWeight=weight;bestTableMatch=(ULocale)matchRow.get0();}if (bestWeight < 0.5D)bestTableMatch=this.defaultLanguage;return bestTableMatch;}public ULocale getBestMatch(String languageList){return this.getBestMatch(LocalePriorityList.add(languageList).build());}public ULocale getBestMatch(ULocale ulocale){return (ULocale)super.getBestMatchInternal(ulocale).get0();}public String toString(){return "{" + this.defaultLanguage + ", " + this.maximizedLanguageToWeight + "}";}private com.ibm.icu.impl.Row.R2<ULocale, Double> getBestMatchInternal(ULocale languageCode){languageCode=this.canonicalize(languageCode);ULocale maximized=super.addLikelySubtags(languageCode);double bestWeight=0.0D;ULocale bestTableMatch=null;r7=this.maximizedLanguageToWeight.keySet().iterator();while (r7.hasNext()){ULocale tableKey=(ULocale)r7.next();com.ibm.icu.impl.Row.R2<ULocale, Double> row=(com.ibm.icu.impl.Row.R2)this.maximizedLanguageToWeight.get(tableKey);double match=this.match(languageCode,maximized,tableKey,(ULocale)row.get0());double weight=match * ((Double)row.get1()).doubleValue();if (weight <= bestWeight){}bestWeight=weight;bestTableMatch=tableKey;}if (bestWeight < 0.5D)bestTableMatch=this.defaultLanguage;return com.ibm.icu.impl.Row.R2.of(bestTableMatch,Double.valueOf(bestWeight));}private void add(ULocale language,Double weight){language=this.canonicalize(language);com.ibm.icu.impl.Row.R2<ULocale, Double> row=com.ibm.icu.impl.Row.of(super.addLikelySubtags(language),weight);this.maximizedLanguageToWeight.put(language,row);}private ULocale addLikelySubtags(ULocale languageCode){ULocale result=ULocale.addLikelySubtags(languageCode);if (result == null || result.equals(languageCode)){String language=languageCode.getLanguage();String script=languageCode.getScript();String region=languageCode.getCountry();return new ULocale((language.length() == 0?"und":language) + "_" + (script.length() == 0?"Zzzz":script) + "_" + (region.length() == 0?"ZZ":region));}return result;}public static class LanguageMatcherData implements Freezable<LanguageMatcherData>{ScoreData languageScores=new ScoreData(Level.language);ScoreData scriptScores=new ScoreData(Level.script);ScoreData regionScores=new ScoreData(Level.region);private boolean frozen=false;private static int[] $SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level;
	public double match(ULocale a,ULocale aMax,ULocale b,ULocale bMax){double diff=0.0D;diff=diff + this.languageScores.getScore(a,aMax,a.getLanguage(),aMax.getLanguage(),b,bMax,b.getLanguage(),bMax.getLanguage());diff=diff + this.scriptScores.getScore(a,aMax,a.getScript(),aMax.getScript(),b,bMax,b.getScript(),bMax.getScript());diff=diff + this.regionScores.getScore(a,aMax,a.getCountry(),aMax.getCountry(),b,bMax,b.getCountry(),bMax.getCountry());if (!a.getVariant().equals(b.getVariant()))diff=diff + 1.0D;if (diff < 0.0D)diff=0.0D; else if (diff > 1.0D)diff=1.0D;return 1.0D - diff;}
			private LanguageMatcherData addDistance(String desired,String supported,int percent){return super.addDistance(desired,supported,percent,false,null);}public LanguageMatcherData addDistance(String desired,String supported,int percent,String comment){return super.addDistance(desired,supported,percent,false,comment);}public LanguageMatcherData addDistance(String desired,String supported,int percent,boolean oneway){return super.addDistance(desired,supported,percent,oneway,null);}private LanguageMatcherData addDistance(String desired,String supported,int percent,boolean oneway,String comment){double score=1.0D - (double)percent / 100.0D;LocalePatternMatcher desiredMatcher=new LocalePatternMatcher(desired);Level desiredLen=desiredMatcher.getLevel();LocalePatternMatcher supportedMatcher=new LocalePatternMatcher(supported);Level supportedLen=supportedMatcher.getLevel();if (desiredLen != supportedLen)throw new IllegalArgumentException();com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data=com.ibm.icu.impl.Row.of(desiredMatcher,supportedMatcher,Double.valueOf(score));com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data2=oneway?null:com.ibm.icu.impl.Row.of(supportedMatcher,desiredMatcher,Double.valueOf(score));switch (desiredLen){case language:String dlanguage=desiredMatcher.getLanguage();String slanguage=supportedMatcher.getLanguage();this.languageScores.addDataToScores(dlanguage,slanguage,data);if (!oneway)this.languageScores.addDataToScores(slanguage,dlanguage,data2);break;case script:String dscript=desiredMatcher.getScript();String sscript=supportedMatcher.getScript();this.scriptScores.addDataToScores(dscript,sscript,data);if (!oneway)this.scriptScores.addDataToScores(sscript,dscript,data2);break;case region:String dregion=desiredMatcher.getRegion();String sregion=supportedMatcher.getRegion();this.regionScores.addDataToScores(dregion,sregion,data);if (!oneway)this.regionScores.addDataToScores(sregion,dregion,data2);break;}return this;}public LanguageMatcherData cloneAsThawed(){LanguageMatcherData result=(LanguageMatcherData)this.clone();result.languageScores=this.languageScores.cloneAsThawed();result.scriptScores=this.scriptScores.cloneAsThawed();result.regionScores=this.regionScores.cloneAsThawed();result.frozen=false;return result;}public LanguageMatcherData freeze(){return this;}public boolean isFrozen(){return this.frozen;}public Object cloneAsThawed(){return this.cloneAsThawed();}public Object freeze(){return this.freeze();}static LanguageMatcherData access$2(LanguageMatcherData arg0,String arg1,String arg2,int arg3){return arg0.addDistance(arg1,arg2,arg3);}static LanguageMatcherData access$3(LanguageMatcherData arg0,String arg1,String arg2,int arg3,boolean arg4,String arg5){return arg0.addDistance(arg1,arg2,arg3,arg4,arg5);}static int[] $SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level(){if (LanguageMatcherData.$SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level == null){}r0=new int[Level.values().length];r0[Level.language.ordinal()]=1;r0[Level.region.ordinal()]=3;r0[Level.script.ordinal()]=2;return LanguageMatcherData.$SWITCH_TABLE$com$ibm$icu$util$LocaleMatcher$Level=r0;}}private static class ScoreData implements Freezable<ScoreData>{java.util.LinkedHashSet<com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double>> scores=new java.util.LinkedHashSet();final double worst;final Level level;private boolean frozen=false;public ScoreData(Level level){this.level=level;this.worst=(double)(1 - (level == Level.language?90:level == Level.script?20:4)) / 100.0D;}void addDataToScores(String desired,String supported,com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data){this.scores.add(data);}double getScore(ULocale desiredLocale,ULocale dMax,String desiredRaw,String desiredMax,ULocale supportedLocale,ULocale sMax,String supportedRaw,String supportedMax){boolean desiredChange=desiredRaw.equals(desiredMax);boolean supportedChange=supportedRaw.equals(supportedMax);if (!desiredMax.equals(supportedMax)){double distance=super.getRawScore(dMax,sMax);if (desiredChange == supportedChange)distance=distance * 0.75D;if (desiredChange)distance=distance * 0.5D;} else if (desiredChange == supportedChange)double distance=0.0D; else double distance=0.25D * this.worst;return distance;}private double getRawScore(ULocale desiredLocale,ULocale supportedLocale){r4=this.scores.iterator();while (r4.hasNext()){com.ibm.icu.impl.Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> datum=(com.ibm.icu.impl.Row.R3)r4.next();if (((LocalePatternMatcher)datum.get0()).matches(desiredLocale) && ((LocalePatternMatcher)datum.get1()).matches(supportedLocale))return ((Double)datum.get2()).doubleValue();}return this.worst;}public String toString(){return this.level + ", " + this.scores;}public ScoreData cloneAsThawed(){ScoreData result=(ScoreData)this.clone();result.scores=(java.util.LinkedHashSet)result.scores.clone();result.frozen=false;return result;}public ScoreData freeze(){return this;}public boolean isFrozen(){return this.frozen;}public Object cloneAsThawed(){return this.cloneAsThawed();}public Object freeze(){return this.freeze();}}private static class LocalePatternMatcher {private String lang;private String script;private String region;private Level level;static java.util.regex.Pattern pattern=java.util.regex.Pattern.compile("([a-zA-Z]{1,8}|\\\\*)(?:-([a-zA-Z]{4}|\\\\*))?(?:-([a-zA-Z]{2}|[0-9]{3}|\\\\*))?");public LocalePatternMatcher(String toMatch){java.util.regex.Matcher matcher=LocalePatternMatcher.pattern.matcher(toMatch);if (!matcher.matches())throw new IllegalArgumentException("Bad pattern: " + toMatch);this.lang=matcher.group(1);this.script=matcher.group(2);this.region=matcher.group(3);this.level=this.region != null?Level.region:this.script != null?Level.script:Level.language;if (this.lang.equals("*"))this.lang=null;if (this.script != null && this.script.equals("*"))this.script=null;if (this.region != null && this.region.equals("*"))this.region=null;}boolean matches(ULocale ulocale){if (this.lang != null && !this.lang.equals(ulocale.getLanguage()))return false;if (this.script != null && !this.script.equals(ulocale.getScript()))return false;if (this.region != null && !this.region.equals(ulocale.getCountry()))return false;return true;}public Level getLevel(){return this.level;}public String getLanguage(){return this.lang == null?"*":this.lang;}public String getScript(){return this.script == null?"*":this.script;}public String getRegion(){return this.region == null?"*":this.region;}public String toString(){String result=this.getLanguage();if (this.level != Level.language){result=result + "-" + this.getScript();if (this.level != Level.script)result=result + "-" + this.getRegion();}return result;}}static enum Level {language,script,region}
			}

*//*class Y {
	public Y foo(String s1, String s2, int i) {
		return foo(s1, s2, i, false, null);
	}
	public Y foo(String s1, String s2, int i , String s3) {
		return foo(s1, s2, i, false, s3);
	}
	public Y foo(String s1, String s2, int i, boolean b) {
		return foo(s1, s2, i, b, null);
	}
	public Y foo(String s1, String s2, int i, boolean b, String s3) {
		return this;
	}
	public Y bar() {
		return this;
	}
}
class X {
	public static Y defaultWritten = new Y().foo("1", "n", 100, "O").freeze();
}
*/