# Parser test cases from https://github.com/lloyd/yajl
#
# This file is generated, DO NOT EDIT!
#
# See comments in yajlTestConverter.pl for instructions on
# how to regenerate this file from the original yajl sources.

sub cases {
  my  $VAR1 = [
    {
      name => "codepoints_from_hex",
      opts => [
        -5
      ],
      input => [
        "\"\\x0a\\x07\\x21\\x40\\x7c\"",
        ""
      ],
      gives => [
        "string: '",
        "\a!\@|'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "doubles",
      opts => [
        -5
      ],
      input => [
        "[ .1e2, 10., +3.141569, -.1e4, NaN, Infinity, +Infinity, -Infinity ]",
        ""
      ],
      gives => [
        "array open '['",
        "double: 10",
        "double: 10",
        "double: 3.14157",
        "double: -1000",
        "double: NaN",
        "double: Infinity",
        "double: Infinity",
        "double: -Infinity",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "integers",
      opts => [
        -5
      ],
      input => [
        "[ +1,+2,+3,+4,+5,+6,+7,+8,+9,",
        "  0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,",
        "  0xa,0xb,0xc,0xd,0xe,0xf,",
        "  0xA,0xB,0xC,0xD,0xE,0xF,",
        "  +0xfedcba98, -0x6789ABCD,",
        "  +123456789 , -123456789,",
        "  +2147483647, -2147483648,",
        "  0x7fffFFFFffffFFFF, -0x7FFFffffFFFFffff,",
        "  9223372036854775807, -9223372036854775807",
        "]",
        ""
      ],
      gives => [
        "array open '['",
        "integer: 1",
        "integer: 2",
        "integer: 3",
        "integer: 4",
        "integer: 5",
        "integer: 6",
        "integer: 7",
        "integer: 8",
        "integer: 9",
        "integer: 1",
        "integer: 2",
        "integer: 3",
        "integer: 4",
        "integer: 5",
        "integer: 6",
        "integer: 7",
        "integer: 8",
        "integer: 9",
        "integer: 10",
        "integer: 11",
        "integer: 12",
        "integer: 13",
        "integer: 14",
        "integer: 15",
        "integer: 10",
        "integer: 11",
        "integer: 12",
        "integer: 13",
        "integer: 14",
        "integer: 15",
        "integer: 4275878552",
        "integer: -1737075661",
        "integer: 123456789",
        "integer: -123456789",
        "integer: 2147483647",
        "integer: -2147483648",
        "integer: 9223372036854775807",
        "integer: -9223372036854775807",
        "integer: 9223372036854775807",
        "integer: -9223372036854775807",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "invalid_hex_char",
      opts => [
        -5
      ],
      input => [
        "\"yabba dabba do \\x1g !!\"",
        ""
      ],
      gives => [
        "lexical error: invalid (non-hex) character occurs after '\\x' inside string.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "map_identifiers",
      opts => [
        -5
      ],
      input => [
        "{",
        "  \$:1,",
        "  _:2,",
        "  A:3,",
        "  Z:4,",
        "  a:5,",
        "  z:6,",
        "  \$1:7,",
        "  _zz:8,",
        "  ZZ9\$Zalpha:9",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: '\$'",
        "integer: 1",
        "key: '_'",
        "integer: 2",
        "key: 'A'",
        "integer: 3",
        "key: 'Z'",
        "integer: 4",
        "key: 'a'",
        "integer: 5",
        "key: 'z'",
        "integer: 6",
        "key: '\$1'",
        "integer: 7",
        "key: '_zz'",
        "integer: 8",
        "key: 'ZZ9\$Zalpha'",
        "integer: 9",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "simple_with_comments",
      opts => [
        -5
      ],
      input => [
        "{",
        "  \"this\": \"is\", // ignore this",
        "  \"really\": \"simple\",",
        "  /* ignore",
        "this",
        "too * / ",
        "** //",
        "(/",
        "******/",
        "  \"json\": \"right?\"",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'this'",
        "string: 'is'",
        "key: 'really'",
        "string: 'simple'",
        "key: 'json'",
        "string: 'right?'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "spec_example",
      opts => [
        -5
      ],
      input => [
        "{",
        "  // comments",
        "  unquoted: 'and you can quote me on that',",
        "  singleQuotes: 'I can use \"double quotes\" here',",
        "  lineBreaks: \"Look, Mom! \\",
        "No \\\\n's!\",",
        "  hexadecimal: 0xdecaf,",
        "  leadingDecimalPoint: .8675309, andTrailing: 8675309.,",
        "  positiveSign: +1,",
        "  trailingComma: 'in objects', andIn: ['arrays',],",
        "  \"backwardsCompatible\": \"with JSON\",",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'unquoted'",
        "string: 'and you can quote me on that'",
        "key: 'singleQuotes'",
        "string: 'I can use \"double quotes\" here'",
        "key: 'lineBreaks'",
        "string: 'Look, Mom! No \\n's!'",
        "key: 'hexadecimal'",
        "integer: 912559",
        "key: 'leadingDecimalPoint'",
        "double: 0.867531",
        "key: 'andTrailing'",
        "double: 8.67531e+06",
        "key: 'positiveSign'",
        "integer: 1",
        "key: 'trailingComma'",
        "string: 'in objects'",
        "key: 'andIn'",
        "array open '['",
        "string: 'arrays'",
        "array close ']'",
        "key: 'backwardsCompatible'",
        "string: 'with JSON'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "strings",
      opts => [
        -5
      ],
      input => [
        "[",
        "  'Hello\\!',",
        "  \"\\\"Evenin\\',\\\" said the barman.\",",
        "  // The following string has 3 different escaped line-endings,",
        "  // LF, CR, and CR+LF, which all disappear from the final string.",
        "  \"Well \\",
        "hi \\\rthere \\\r",
        "y'all!\",",
        "  \"\\b\\f\\n\\r\\t\\v\\\\\",",
        "  '\\A\\C\\/\\D\\C',",
        "]",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'Hello!'",
        "string: '\"Evenin',\" said the barman.'",
        "string: 'Well hi there y'all!'",
        "string: '\b\f",
        "\r\t\13\\'",
        "string: 'AC/DC'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "trailing_commas",
      opts => [
        -5
      ],
      input => [
        "{\"array\":[1,2,],\"map\":{\"a\":1,},}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'array'",
        "array open '['",
        "integer: 1",
        "integer: 2",
        "array close ']'",
        "key: 'map'",
        "map open '{'",
        "key: 'a'",
        "integer: 1",
        "map close '}'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "difficult_json_c_test_case_with_comments",
      opts => [
        "-c"
      ],
      input => [
        "{ \"glossary\": { /* you */ \"title\": /**/ \"example glossary\", /*should*/\"GlossDiv\": { \"title\": /*never*/\"S\", /*ever*/\"GlossList\": [ { \"ID\": \"SGML\", \"SortAs\": \"SGML\", \"GlossTerm\": \"Standard Generalized Markup Language\", \"Acronym\": \"SGML\", \"Abbrev\": \"ISO 8879:1986\", \"GlossDef\": \"A meta-markup language, used to create markup languages such as DocBook.\", /*see*/\"GlossSeeAlso\"/*this*/:/*coming*/[/*out*/\"GML\"/*of*/,/*the*/\"XML\"/*parser!*/, \"markup\"] /*hey*/}/*ho*/]/*hey*/}/*ho*/} }  // and the parser won't even get this far, so chill.  /* hah!",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'glossary'",
        "map open '{'",
        "key: 'title'",
        "string: 'example glossary'",
        "key: 'GlossDiv'",
        "map open '{'",
        "key: 'title'",
        "string: 'S'",
        "key: 'GlossList'",
        "array open '['",
        "map open '{'",
        "key: 'ID'",
        "string: 'SGML'",
        "key: 'SortAs'",
        "string: 'SGML'",
        "key: 'GlossTerm'",
        "string: 'Standard Generalized Markup Language'",
        "key: 'Acronym'",
        "string: 'SGML'",
        "key: 'Abbrev'",
        "string: 'ISO 8879:1986'",
        "key: 'GlossDef'",
        "string: 'A meta-markup language, used to create markup languages such as DocBook.'",
        "key: 'GlossSeeAlso'",
        "array open '['",
        "string: 'GML'",
        "string: 'XML'",
        "string: 'markup'",
        "array close ']'",
        "map close '}'",
        "array close ']'",
        "map close '}'",
        "map close '}'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "simple_with_comments",
      opts => [
        "-c"
      ],
      input => [
        "{",
        "  \"this\": \"is\", // ignore this",
        "  \"really\": \"simple\",",
        "  /* ignore",
        "this",
        "too * / ",
        "** //",
        "(/",
        "******/",
        "  \"json\": \"right?\"",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'this'",
        "string: 'is'",
        "key: 'really'",
        "string: 'simple'",
        "key: 'json'",
        "string: 'right?'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "false_then_garbage",
      opts => [
        "-g"
      ],
      input => [
        "falsex"
      ],
      gives => [
        "bool: false",
        "memory leaks:\t0"
      ]
    },
    {
      name => "null_then_garbage",
      opts => [
        "-g"
      ],
      input => [
        "nullx",
        ""
      ],
      gives => [
        "null",
        "memory leaks:\t0"
      ]
    },
    {
      name => "true_then_garbage",
      opts => [
        "-g"
      ],
      input => [
        "truex"
      ],
      gives => [
        "bool: true",
        "memory leaks:\t0"
      ]
    },
    {
      name => "eof",
      opts => [
        "-m"
      ],
      input => [
        "{ \"123\":",
        ""
      ],
      gives => [
        "map open '{'",
        "key: '123'",
        "parse error: premature EOF",
        "memory leaks:\t0"
      ]
    },
    {
      name => "integers",
      opts => [
        "-m"
      ],
      input => [
        "1221 21",
        ""
      ],
      gives => [
        "integer: 1221",
        "integer: 21",
        "memory leaks:\t0"
      ]
    },
    {
      name => "multiple",
      opts => [
        "-m"
      ],
      input => [
        "",
        "{}",
        "{}",
        ""
      ],
      gives => [
        "map open '{'",
        "map close '}'",
        "map open '{'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "stuff",
      opts => [
        "-m"
      ],
      input => [
        "{}",
        "[]",
        "[]",
        "\"sdfasd\"",
        123,
        "{ \"123\" : 123 }",
        "3.1e124",
        ""
      ],
      gives => [
        "map open '{'",
        "map close '}'",
        "array open '['",
        "array close ']'",
        "array open '['",
        "array close ']'",
        "string: 'sdfasd'",
        "integer: 123",
        "map open '{'",
        "key: '123'",
        "integer: 123",
        "map close '}'",
        "double: 3.1e+124",
        "memory leaks:\t0"
      ]
    },
    {
      name => "array_open",
      opts => [
        "-p"
      ],
      input => [
        "[",
        ""
      ],
      gives => [
        "array open '['",
        "memory leaks:\t0"
      ]
    },
    {
      name => "eof_str",
      opts => [
        "-p"
      ],
      input => [
        "\"abc"
      ],
      gives => [
        "memory leaks:\t0"
      ]
    },
    {
      name => "map_open",
      opts => [
        "-p"
      ],
      input => [
        "{",
        ""
      ],
      gives => [
        "map open '{'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "partial_ok",
      opts => [
        "-p"
      ],
      input => [
        "[ \"foo\", \"bar\"",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'foo'",
        "string: 'bar'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "array",
      opts => [],
      input => [
        "[\"foo\",",
        " \"bar\", \"baz\",",
        " true,false,null,{\"key\":\"value\"},",
        " [null,null,null,[]],",
        " \"\\n\\r\\\\\"",
        "]",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'foo'",
        "string: 'bar'",
        "string: 'baz'",
        "bool: true",
        "bool: false",
        "null",
        "map open '{'",
        "key: 'key'",
        "string: 'value'",
        "map close '}'",
        "array open '['",
        "null",
        "null",
        "null",
        "array open '['",
        "array close ']'",
        "array close ']'",
        "string: '",
        "\r\\'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "array_close",
      opts => [],
      input => [
        "]",
        ""
      ],
      gives => [
        "parse error: unallowed token at this point in JSON text",
        "memory leaks:\t0"
      ]
    },
    {
      name => "bignums",
      opts => [],
      input => [
        "[ 9223372036854775807, -9223372036854775807 ]",
        ""
      ],
      gives => [
        "array open '['",
        "integer: 9223372036854775807",
        "integer: -9223372036854775807",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "bogus_char",
      opts => [],
      input => [
        "[\"this\",\"is\",\"what\",\"should\",\"be\",",
        " \"a happy bit of json\",",
        " \"but someone, misspelled \\\"true\\\"\", ture,",
        " \"who says JSON is easy for humans to generate?\"]",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'this'",
        "string: 'is'",
        "string: 'what'",
        "string: 'should'",
        "string: 'be'",
        "string: 'a happy bit of json'",
        "string: 'but someone, misspelled \"true\"'",
        "lexical error: invalid string in json text.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "codepoints_from_unicode_org",
      opts => [],
      input => [
        "\"\\u004d\\u0430\\u4e8c\\ud800\\udf02\"",
        ""
      ],
      gives => [
        "string: 'M\320\260\344\272\214\360\220\214\202'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "deep_arrays",
      opts => [],
      input => [
        "[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]"
      ],
      gives => [
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array open '['",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "difficult_json_c_test_case",
      opts => [],
      input => [
        "{ \"glossary\": { \"title\": \"example glossary\", \"GlossDiv\": { \"title\": \"S\", \"GlossList\": [ { \"ID\": \"SGML\", \"SortAs\": \"SGML\", \"GlossTerm\": \"Standard Generalized Markup Language\", \"Acronym\": \"SGML\", \"Abbrev\": \"ISO 8879:1986\", \"GlossDef\": \"A meta-markup language, used to create markup languages such as DocBook.\", \"GlossSeeAlso\": [\"GML\", \"XML\", \"markup\"] } ] } } }",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'glossary'",
        "map open '{'",
        "key: 'title'",
        "string: 'example glossary'",
        "key: 'GlossDiv'",
        "map open '{'",
        "key: 'title'",
        "string: 'S'",
        "key: 'GlossList'",
        "array open '['",
        "map open '{'",
        "key: 'ID'",
        "string: 'SGML'",
        "key: 'SortAs'",
        "string: 'SGML'",
        "key: 'GlossTerm'",
        "string: 'Standard Generalized Markup Language'",
        "key: 'Acronym'",
        "string: 'SGML'",
        "key: 'Abbrev'",
        "string: 'ISO 8879:1986'",
        "key: 'GlossDef'",
        "string: 'A meta-markup language, used to create markup languages such as DocBook.'",
        "key: 'GlossSeeAlso'",
        "array open '['",
        "string: 'GML'",
        "string: 'XML'",
        "string: 'markup'",
        "array close ']'",
        "map close '}'",
        "array close ']'",
        "map close '}'",
        "map close '}'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "doubles",
      opts => [],
      input => [
        "[ 0.1e2, 1e1, 3.141569, 10000000000000e-10]",
        ""
      ],
      gives => [
        "array open '['",
        "double: 10",
        "double: 10",
        "double: 3.14157",
        "double: 1000",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "doubles_in_array",
      opts => [],
      input => [
        "[0.00011999999999999999, 6E-06, 6E-06, 1E-06, 1E-06]",
        ""
      ],
      gives => [
        "array open '['",
        "double: 0.00012",
        "double: 6e-06",
        "double: 6e-06",
        "double: 1e-06",
        "double: 1e-06",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "empty_array",
      opts => [],
      input => [
        "[]"
      ],
      gives => [
        "array open '['",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "empty_string",
      opts => [],
      input => [
        "\"\"",
        ""
      ],
      gives => [
        "string: ''",
        "memory leaks:\t0"
      ]
    },
    {
      name => "escaped_bulgarian",
      opts => [],
      input => [
        "[\"\\u0414\\u0430\",",
        " \"\\u041c\\u0443\",",
        " \"\\u0415\\u0431\\u0430\",",
        " \"\\u041c\\u0430\\u0439\\u043a\\u0430\\u0442\\u0430\"]",
        ""
      ],
      gives => [
        "array open '['",
        "string: '\320\224\320\260'",
        "string: '\320\234\321\203'",
        "string: '\320\225\320\261\320\260'",
        "string: '\320\234\320\260\320\271\320\272\320\260\321\202\320\260'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "escaped_foobar",
      opts => [],
      input => [
        "\"\\u0066\\u006f\\u006f\\u0062\\u0061\\u0072\"",
        ""
      ],
      gives => [
        "string: 'foobar'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "false",
      opts => [],
      input => [
        "false",
        ""
      ],
      gives => [
        "bool: false",
        "memory leaks:\t0"
      ]
    },
    {
      name => "false_then_garbage",
      opts => [],
      input => [
        "falsex"
      ],
      gives => [
        "bool: false",
        "parse error: trailing garbage",
        "memory leaks:\t0"
      ]
    },
    {
      name => "issue_7",
      opts => [],
      input => [
        "2009-10-20\@20:38:21.539575",
        ""
      ],
      gives => [
        "integer: 2009",
        "parse error: trailing garbage",
        "memory leaks:\t0"
      ]
    },
    {
      name => "null_then_garbage",
      opts => [],
      input => [
        "nullx",
        ""
      ],
      gives => [
        "null",
        "parse error: trailing garbage",
        "memory leaks:\t0"
      ]
    },
    {
      name => "true_then_garbage",
      opts => [],
      input => [
        "truex",
        ""
      ],
      gives => [
        "bool: true",
        "parse error: trailing garbage",
        "memory leaks:\t0"
      ]
    },
    {
      name => "four_byte_utf8",
      opts => [],
      input => [
        "{ \"U+10ABCD\": \"\364\212\257\215\" }",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'U+10ABCD'",
        "string: '\364\212\257\215'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "hex",
      opts => [],
      input => [
        "0x1",
        ""
      ],
      gives => [
        "lexical error: probable hex number found, JSON5 is not enabled.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "high_overflow",
      opts => [],
      input => [
        "9223372036854775808"
      ],
      gives => [
        "parse error: integer overflow",
        "memory leaks:\t0"
      ]
    },
    {
      name => "infinity",
      opts => [],
      input => [
        "Infinity",
        ""
      ],
      gives => [
        "lexical error: special number Infinity or NaN found, JSON5 is not enabled.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "integers",
      opts => [],
      input => [
        "[ 1,2,3,4,5,6,7,",
        "  123456789 , -123456789,",
        "  2147483647, -2147483647 ]",
        ""
      ],
      gives => [
        "array open '['",
        "integer: 1",
        "integer: 2",
        "integer: 3",
        "integer: 4",
        "integer: 5",
        "integer: 6",
        "integer: 7",
        "integer: 123456789",
        "integer: -123456789",
        "integer: 2147483647",
        "integer: -2147483647",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "invalid_utf8",
      opts => [],
      input => [
        "[\"\320\224\320\260 \320\234\321 \320\225\320\261\320\260 \320\234\320\260\320\271\320\272\320\260\321\202\320\260\"]",
        ""
      ],
      gives => [
        "array open '['",
        "lexical error: invalid bytes in UTF8 string.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "isolated_surrogate_marker",
      opts => [],
      input => [
        "\"\\ud800\"",
        ""
      ],
      gives => [
        "string: '?'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "leading_zero_in_number",
      opts => [],
      input => [
        "{ \"bad thing\": 01 }",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'bad thing'",
        "integer: 0",
        "parse error: after key and value, inside map, I expect ',' or '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "lonely_minus_sign",
      opts => [],
      input => [
        "[",
        "\t\t\"foo\", true,",
        "\t\ttrue, \"blue\",",
        "\t\t\"baby where are you?\", \"oh boo hoo!\",",
        "        - ",
        "]",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'foo'",
        "bool: true",
        "bool: true",
        "string: 'blue'",
        "string: 'baby where are you?'",
        "string: 'oh boo hoo!'",
        "lexical error: malformed number, a digit is required after the plus/minus sign.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "lonely_number",
      opts => [],
      input => [
        123456789
      ],
      gives => [
        "integer: 123456789",
        "memory leaks:\t0"
      ]
    },
    {
      name => "low_overflow",
      opts => [],
      input => [
        "-9223372036854775808"
      ],
      gives => [
        "parse error: integer overflow",
        "memory leaks:\t0"
      ]
    },
    {
      name => "map_close",
      opts => [],
      input => [
        "}",
        ""
      ],
      gives => [
        "parse error: unallowed token at this point in JSON text",
        "memory leaks:\t0"
      ]
    },
    {
      name => "minus_infinity",
      opts => [],
      input => [
        "-Infinity",
        ""
      ],
      gives => [
        "lexical error: special number Infinity or NaN found, JSON5 is not enabled.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "missing_integer_after_decimal_point",
      opts => [],
      input => [
        "10.e2",
        ""
      ],
      gives => [
        "lexical error: malformed number, a digit is required after the decimal point.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "missing_integer_after_exponent",
      opts => [],
      input => [
        "10e",
        ""
      ],
      gives => [
        "lexical error: malformed number, a digit is required after the exponent.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "multiple",
      opts => [],
      input => [
        "",
        "{}",
        "{}",
        ""
      ],
      gives => [
        "map open '{'",
        "map close '}'",
        "parse error: trailing garbage",
        "memory leaks:\t0"
      ]
    },
    {
      name => "nan",
      opts => [],
      input => [
        "NaN",
        ""
      ],
      gives => [
        "lexical error: special number Infinity or NaN found, JSON5 is not enabled.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "non_utf8_char_in_string",
      opts => [],
      input => [
        "{\"CoreletAPIVersion\":2,\"CoreletType\":\"standalone\",\"documentation\":\"A corelet that provides the capability to upload a folder\222s contents into a user\222s locker.\",\"functions\":[{\"documentation\":\"Displays a dialog box that allows user to select a folder on the local system.\",\"name\":\"ShowBrowseDialog\",\"parameters\":[{\"documentation\":\"The callback function for results.\",\"name\":\"callback\",\"required\":true,\"type\":\"callback\"}]},{\"documentation\":\"Uploads all mp3 files in the folder provided.\",\"name\":\"UploadFolder\",\"parameters\":[{\"documentation\":\"The path to upload mp3 files from.\",\"name\":\"path\",\"required\":true,\"type\":\"string\"},{\"documentation\":\"The callback function for progress.\",\"name\":\"callback\",\"required\":true,\"type\":\"callback\"}]},{\"documentation\":\"Returns the server name to the current locker service.\",\"name\":\"GetLockerService\",\"parameters\":[]},{\"documentation\":\"Changes the name of the locker service.\",\"name\":\"SetLockerService\",\"parameters\":[{\"documentation\":\"The value of the locker service to set active.\",\"name\":\"LockerService\",\"required\":true,\"type\":\"string\"}]},{\"documentation\":\"Downloads locker files to the suggested folder.\",\"name\":\"DownloadFile\",\"parameters\":[{\"documentation\":\"The origin path of the locker file.\",\"name\":\"path\",\"required\":true,\"type\":\"string\"},{\"documentation\":\"The Window destination path of the locker file.\",\"name\":\"destination\",\"required\":true,\"type\":\"integer\"},{\"documentation\":\"The callback function for progress.\",\"name\":\"callback\",\"required\":true,\"type\":\"callback\"}]}],\"name\":\"LockerUploader\",\"version\":{\"major\":0,\"micro\":1,\"minor\":0},\"versionString\":\"0.0.1\"}"
      ],
      gives => [
        "map open '{'",
        "key: 'CoreletAPIVersion'",
        "integer: 2",
        "key: 'CoreletType'",
        "string: 'standalone'",
        "key: 'documentation'",
        "lexical error: invalid bytes in UTF8 string.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "partial_bad",
      opts => [],
      input => [
        "[ \"foo\", \"bar\"",
        ""
      ],
      gives => [
        "array open '['",
        "string: 'foo'",
        "string: 'bar'",
        "parse error: premature EOF",
        "memory leaks:\t0"
      ]
    },
    {
      name => "null",
      opts => [],
      input => [
        "null",
        ""
      ],
      gives => [
        "null",
        "memory leaks:\t0"
      ]
    },
    {
      name => "nulls_and_bools",
      opts => [],
      input => [
        "{",
        "\t\"boolean, true\": true,",
        "\t\"boolean, false\": false,",
        "\t\"null\": null",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'boolean, true'",
        "bool: true",
        "key: 'boolean, false'",
        "bool: false",
        "key: 'null'",
        "null",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "simple",
      opts => [],
      input => [
        "{",
        "  \"this\": \"is\",",
        "  \"really\": \"simple\",",
        "  \"json\": \"right?\"",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'this'",
        "string: 'is'",
        "key: 'really'",
        "string: 'simple'",
        "key: 'json'",
        "string: 'right?'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "simple_with_comments",
      opts => [],
      input => [
        "{",
        "  \"this\": \"is\", // ignore this",
        "  \"really\": \"simple\",",
        "  /* ignore",
        "this",
        "too * / ",
        "** //",
        "(/",
        "******/",
        "  \"json\": \"right?\"",
        "}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'this'",
        "string: 'is'",
        "lexical error: probable comment found in input text, comments are not enabled.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "string_invalid_escape",
      opts => [],
      input => [
        "[\"\\n foo \\/ bar \\r\\f\\\\\\uffff\\t\\b\\\"\\\\ and you can't escape thi\\s\"]",
        ""
      ],
      gives => [
        "array open '['",
        "lexical error: inside a string, '\\' occurs before a character which it may not.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "string_invalid_hex_char",
      opts => [],
      input => [
        "\"foo foo, blah blah \\u0123 \\u4567 \\u89ab \\uc/ef \\uABCD \\uEFFE bar baz bing\"",
        ""
      ],
      gives => [
        "lexical error: invalid (non-hex) character occurs after '\\u' inside string.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "string_with_escapes",
      opts => [],
      input => [
        "[\"\\n foo \\/ bar \\r\\f\\\\\\uffff\\t\\b\\\"\\\\\",",
        " \"\\\"and this string has an escape at the beginning\",",
        " \"and this string has no escapes\" ]",
        ""
      ],
      gives => [
        "array open '['",
        "string: '",
        " foo / bar \r\f\\\357\277\277\t\b\"\\'",
        "string: '\"and this string has an escape at the beginning'",
        "string: 'and this string has no escapes'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "string_with_invalid_newline",
      opts => [],
      input => [
        "\"la di dah.  this is a string, and I can do this, \\n, but not this",
        "\"",
        ""
      ],
      gives => [
        "lexical error: invalid character inside string.",
        "memory leaks:\t0"
      ]
    },
    {
      name => "three_byte_utf8",
      opts => [],
      input => [
        "{\"matzue\": \"\346\235\276\346\261\237\", \"asakusa\": \"\346\265\205\350\215\211\"}",
        ""
      ],
      gives => [
        "map open '{'",
        "key: 'matzue'",
        "string: '\346\235\276\346\261\237'",
        "key: 'asakusa'",
        "string: '\346\265\205\350\215\211'",
        "map close '}'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "true",
      opts => [],
      input => [
        "true",
        ""
      ],
      gives => [
        "bool: true",
        "memory leaks:\t0"
      ]
    },
    {
      name => "truncated_surrogate",
      opts => [],
      input => [
        "\"\\uDBFF\360\237\222\200\"",
        ""
      ],
      gives => [
        "string: '?\360\237\222\200'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "unescaped_bulgarian",
      opts => [],
      input => [
        "[\"\320\224\320\260 \320\234\321\203 \320\225\320\261\320\260 \320\234\320\260\320\271\320\272\320\260\321\202\320\260\"]",
        ""
      ],
      gives => [
        "array open '['",
        "string: '\320\224\320\260 \320\234\321\203 \320\225\320\261\320\260 \320\234\320\260\320\271\320\272\320\260\321\202\320\260'",
        "array close ']'",
        "memory leaks:\t0"
      ]
    },
    {
      name => "zerobyte",
      opts => [],
      input => [
        "\"\\u0000\"",
        ""
      ],
      gives => [
        "string: '\0'",
        "memory leaks:\t0"
      ]
    }
  ];

  return @{$VAR1};
}

1;
